/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.executeanalyse;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.control.BillPreOpenCheckUtil;
import kd.epm.eb.business.executeanalyse.AnalyseBudgetQueryService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.impl.model.AbstractBgControlRecord;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.executeanalyse.BizRowDataEntity;
import kd.epm.eb.formplugin.executeanalyse.ReportFormPlugin;
import kd.epm.eb.formplugin.executeanalyse.RowDataEntity;
import kd.epm.eb.formplugin.multiSelOne.MultiSelOneFormPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RelQueryExecuteRecordPlugin
extends ReportFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
TreeNodeQueryListener {
    private static final String MIAN_ENTRYENTITY = "entryentity1";
    private static final String BIZ_ENTRYENTITY = "entryentity2";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BTN_EXPORT_ALL = "btn_exportall";
    private static final String BTN_SHOWNUMBER = "btn_shownumber";
    private static final String BTN_SHOWNUMNAME = "btn_shownumname";
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_SHOWNAME = "btn_showname";
    private static final String BTN_LOADMORE = "btn_loadmore";
    private static final String CACHE_DIMKEYVALUEMAP = "dimKeyValueMap";
    private static final String PRE_F7_CUSTOM = "custom";
    private static final String PRE_ENTRY_CUSTOM = "e_custom";
    private static final String CACHE_ALL_ROWCONTROLRECORDS = "allRowControlRecords";
    private static final String CACHE_RELBILL_CONTROLRECORDS = "cacheRelBillControlRecords";
    private static final String CACHE_CUSTOM_DIMKEYMAP = "customDimKeyMap";
    private static final String CACHE_BILL_INFO = "cache_bill_info";
    private static final int MAX_ROW_COUNT = 10000;
    private static final int MAX_QUERY_CONTROL_RECORD_ROW = 10000;
    private static final int MAX_EXPORT_CONTROL_RECORD_ROW = 100000;
    private static final int MAX_EXPORT_GROUP_COUNT = 5000;
    private static final String NEED_LOAD_MORE_DATA = "needLoadMoreData";
    private static final String MEM_DISTYPE = "memDisType";
    private static final List<String> sortWayList = Arrays.asList("entity", "account", "budgetperiod", "custom0", "custom1", "custom2", "custom3", "custom4", "custom5", "custom6", "custom7", "custom8", "custom9", "version", "datatype", "audittrail", "changetype", "currency", "metric", "internalcompany");
    private static final Set<String> notNeedFindLeafDim = Sets.newHashSet((Object[])new String[]{"Version", "AuditTrail", "ChangeType", "Currency", "Metric"});
    private static final Set<String> ignoreDim = Sets.newHashSet((Object[])new String[]{"Version", "DataType", "AuditTrail", "ChangeType"});
    private static final Set<String> singleSelDim = Sets.newHashSet((Object[])new String[]{"Version", "DataType", "AuditTrail", "ChangeType"});
    private static final Log log = LogFactory.getLog(RelQueryExecuteRecordPlugin.class);

    public void initialize() {
        super.initialize();
        TreeEntryGrid controlRecordTree = (TreeEntryGrid)this.getControl(BIZ_ENTRYENTITY);
        controlRecordTree.addCellClickListener((TreeNodeQueryListener)this);
    }

    @Override
    public void ebPreOpen(PreOpenFormEventArgs e) {
        super.ebPreOpen(e);
        this.checkViewPermPreOpen(e);
    }

    public boolean notCheckPermInWorkFlow() {
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        this.updateCusDimShowInfo();
        this.cacheF7ControlDimNumber();
        this.initFilterPanelF7Data();
        this.initEntryData();
        this.canelDefaultScheme();
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dataset"});
        }
    }

    private void canelDefaultScheme() {
        List<FilterScheme> curFormAllScheme = this.getCurFormAllScheme();
        String schemeId = null;
        if (CollectionUtils.isNotEmpty(curFormAllScheme)) {
            for (FilterScheme scheme : curFormAllScheme) {
                if (!scheme.isDefault()) continue;
                schemeId = scheme.getId();
            }
        }
        if (schemeId != null) {
            FilterModel filterModel = new FilterModel();
            filterModel.setFormId(this.getView().getEntityId());
            filterModel.updateScheme(schemeId, false, new StringBuilder());
        }
    }

    private List<Dimension> getShowDimensionList() {
        Long dataSetId = this.getDataSetId();
        IModelCacheHelper orCreate = this.getModelCacheHelper();
        ArrayList<Dimension> datasetDimensions = new ArrayList<Dimension>(orCreate.getDimensionList(dataSetId));
        Set<Long> controlDimensionIds = this.getControlDimensionIds();
        if (controlDimensionIds.size() > 0) {
            datasetDimensions.removeIf(e -> !controlDimensionIds.contains(e.getId()));
        }
        return datasetDimensions;
    }

    private Set<Long> getControlDimensionIds() {
        HashSet<Long> dims = new HashSet<Long>();
        String fields = "id,model.id,businessmodel.id,entryentity,entryentity.id,entryentity.dimensionid";
        QFBuilder builder = new QFBuilder("model", "=", (Object)this.getModelId());
        builder.add(new QFilter("businessmodel", "=", (Object)this.getBizModelId()));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
        if (dynamicObject == null) {
            return dims;
        }
        DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entryentity");
        if (entries != null) {
            for (DynamicObject entry : entries) {
                dims.add(entry.getLong("dimensionid"));
            }
        }
        return dims;
    }

    private void filterSchemeByDataset() {
        ArrayList<FilterScheme> curDatasetScheme = new ArrayList<FilterScheme>();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        List<FilterScheme> allSchemes = this.getCurFormAllScheme();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        if (CollectionUtils.isNotEmpty(allSchemes)) {
            long modelId = 0L;
            long datasetId = 0L;
            for (FilterScheme filterScheme : allSchemes) {
                Map filterMap = (Map)SerializationUtils.fromJsonString((String)filterScheme.getScheme(), HashMap.class);
                String custfilters = (String)filterMap.get("custfilters");
                DynamicObject scheme = (DynamicObject)jser.deserializeFromString(custfilters, null);
                DynamicObject model = scheme.getDynamicObject("model");
                DynamicObject dataset = scheme.getDynamicObject("dataset");
                if (model != null) {
                    modelId = model.getLong("id");
                }
                if (dataset != null) {
                    datasetId = dataset.getLong("id");
                }
                if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)datasetId).booleanValue() || modelId != this.getModelId() || datasetId != this.getDataSetId()) continue;
                curDatasetScheme.add(filterScheme);
            }
        }
        reportFilter.setSchemeList(curDatasetScheme);
        this.getView().updateView("reportfilterap");
    }

    private List<FilterScheme> getCurFormAllScheme() {
        FilterModel filterModel = new FilterModel();
        filterModel.setFormId(this.getView().getEntityId());
        return filterModel.getSchemeList();
    }

    private void initEntryData() {
        this.getModel().deleteEntryData(MIAN_ENTRYENTITY);
        this.getModel().deleteEntryData(BIZ_ENTRYENTITY);
        this.search(null);
    }

    private void cacheF7ControlDimNumber() {
        HashMap<String, String> f7ControlDimNumber = new HashMap<String, String>(16);
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        List<Dimension> dimensions = this.getShowDimensionList();
        for (Dimension dim : dimensions) {
            String number = dim.getNumber();
            if (SysDimensionEnum.include((String)number, (Boolean)true)) {
                f7ControlDimNumber.put(number.toLowerCase(), number);
                continue;
            }
            f7ControlDimNumber.put(customDimKeyMap.get(number), number);
        }
        this.getPageCache().put("f7ControlDimNumber", SerializationUtils.serializeToBase64(f7ControlDimNumber));
    }

    private Map<String, String> getF7ControlDimNumber() {
        String f7ControlDimNumber = this.getPageCache().get("f7ControlDimNumber");
        if (f7ControlDimNumber != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)f7ControlDimNumber);
        }
        return new HashMap<String, String>();
    }

    private List<String> getOrderDimNumbers() {
        ArrayList<String> dimNumbers = new ArrayList<String>();
        Map<String, String> f7ControlDimNumber = this.getF7ControlDimNumber();
        for (String key : sortWayList) {
            if (f7ControlDimNumber.get(key) == null) continue;
            dimNumbers.add(f7ControlDimNumber.get(key));
        }
        return dimNumbers;
    }

    private void updateCusDimShowInfo() {
        List<Dimension> customDimensions = this.getCustomDimensions();
        HashMap<String, String> customDimKeyMap = new HashMap<String, String>(16);
        int i = 0;
        for (Dimension dimension : customDimensions) {
            String customDimKey = PRE_F7_CUSTOM + i;
            BasedataEdit control = (BasedataEdit)this.getControl(customDimKey);
            control.setCaption(new LocaleString(dimension.getName()));
            String entryCustomDimKey = PRE_ENTRY_CUSTOM + i;
            TextEdit entrControl = (TextEdit)this.getControl(entryCustomDimKey);
            entrControl.setCaption(new LocaleString(dimension.getName()));
            customDimKeyMap.put(dimension.getNumber(), customDimKey);
            ++i;
        }
        this.cacheCustomDimKeyMap(customDimKeyMap);
    }

    private void initFilterPanelF7Data() {
        Set<String> showDimensionNums = this.getShowDimensionNums();
        Map<String, List<Long>> dimKeyValueMap = this.getDimKeyValueMap();
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        this.getModel().beginInit();
        this.getModel().setValue("model", (Object)this.getModelId());
        this.getModel().setValue("dataset", (Object)this.getDataSetId());
        Long bizModel = modelCacheHelper.getBusModelByDataSet(this.getDataSetId());
        Map<String, Long> viewsMap = this.getViewsMap(modelCacheHelper, bizModel);
        if (dimKeyValueMap.size() != 0) {
            for (Map.Entry<String, List<Long>> entry : dimKeyValueMap.entrySet()) {
                Set _permissions;
                String dimNumber = entry.getKey();
                if (!showDimensionNums.contains(dimNumber)) continue;
                Long viewId = viewsMap.get(dimNumber);
                List<Long> dimMemValue = entry.getValue();
                String controlKey = dimNumber.toLowerCase();
                if (!SysDimensionEnum.include((String)dimNumber, (Boolean)true)) {
                    controlKey = customDimKeyMap.get(dimNumber);
                }
                if ((_permissions = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)this.getModelId(), (Long)bizModel, (Long)viewId, (boolean)true)) != null) {
                    dimMemValue.retainAll(_permissions);
                }
                if (dimMemValue.isEmpty()) continue;
                Control control = this.getControl(controlKey);
                if (control instanceof MulBasedataEdit) {
                    this.getModel().setValue(controlKey, (Object)dimMemValue.toArray());
                    continue;
                }
                if (!(control instanceof BasedataEdit)) continue;
                this.getModel().setValue(controlKey, (Object)dimMemValue.get(0));
            }
        } else {
            List<Dimension> dimensions = this.getShowDimensionList();
            Long bizModelId = modelCacheHelper.getBusModelByDataSet(this.getDataSetId());
            Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, bizModelId);
            Long memberId = 0L;
            for (Dimension dimension : dimensions) {
                String dimNumber = dimension.getNumber();
                String controlKey = dimNumber.toLowerCase();
                if (!SysDimensionEnum.include((String)dimNumber, (Boolean)true)) {
                    controlKey = customDimKeyMap.get(dimNumber);
                }
                boolean isModelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
                Long viewId = viewMap.get(dimNumber);
                if (isModelManager) {
                    List members = modelCacheHelper.getMembers(viewId, dimNumber);
                    if (CollectionUtils.isNotEmpty((Collection)members)) {
                        memberId = ((Member)members.get(0)).getId();
                    }
                } else {
                    Set permMembIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)this.getModelId(), (Long)bizModelId, (Long)viewId, (boolean)true);
                    if (CollectionUtils.isNotEmpty((Collection)permMembIds)) {
                        memberId = (Long)new ArrayList(permMembIds).get(0);
                    }
                }
                this.getModel().setValue(controlKey, (Object)new Object[]{memberId});
            }
        }
        this.getModel().endInit();
    }

    private void cacheCustomDimKeyMap(Map<String, String> customDimKeyMap) {
        this.getPageCache().put(CACHE_CUSTOM_DIMKEYMAP, SerializationUtils.serializeToBase64(customDimKeyMap));
    }

    private Map<String, String> getCustomDimKeyMap() {
        String cache_customDimKeyMap = this.getPageCache().get(CACHE_CUSTOM_DIMKEYMAP);
        if (cache_customDimKeyMap != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache_customDimKeyMap);
        }
        return new HashMap<String, String>();
    }

    private Map<String, Long> getViewsMap(IModelCacheHelper modelCacheHelper, Long bizModelId) {
        if (this.isFromReport()) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getCustomFormParam("dimViewMap")));
        }
        return modelCacheHelper.getViewsByBusModel(bizModelId);
    }

    private List<Dimension> getCustomDimensions() {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(10);
        List<Dimension> showDimensionList = this.getShowDimensionList();
        for (Dimension dimension : showDimensionList) {
            if (SysDimensionEnum.include((String)dimension.getNumber(), (Boolean)true)) continue;
            dimensions.add(dimension);
        }
        return dimensions;
    }

    private Set<String> getShowDimensionNums() {
        HashSet<String> set = new HashSet<String>(16);
        List<Dimension> showDimensionList = this.getShowDimensionList();
        for (Dimension dimension : showDimensionList) {
            set.add(dimension.getNumber());
        }
        return set;
    }

    private void initMainEntryData(Map<String, List<String>> queryParam, Boolean isNeedLoadMore) {
        ArrayList<Map<String, String>> controlMembers = new ArrayList<Map<String, String>>(16);
        List<RowDataEntity> rowDataEntities = this.getMainRowDataEntities(queryParam, controlMembers, isNeedLoadMore);
        log.info("rowDataEntities:" + rowDataEntities.size());
        if (CollectionUtils.isEmpty(rowDataEntities)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        Long modelId = this.getModelId();
        ArrayList<String> types = new ArrayList<String>(16);
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        Long dataSetId = this.getDataSetId();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dataSetId);
        Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, bizModelId);
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        List controlDimensions = instance.getControlDimensions(modelId, dataSetId);
        Collection balances = new BgControlCallerImpl().queryBalance(modelId, controlMembers, types, true, true, bizModelId);
        HashMap balanceMap = new HashMap(16);
        balances.forEach(e -> balanceMap.put(instance.getCtlKey(e, controlDimensions), e.getBalance()));
        String memDisType = this.getPageCache().get(MEM_DISTYPE);
        this.getModel().beginInit();
        int[] ints = this.getModel().batchCreateNewEntryRow(MIAN_ENTRYENTITY, rowDataEntities.size());
        int i = 0;
        for (RowDataEntity rowDataEntity : rowDataEntities) {
            Map<String, String> dimMemberValMap = rowDataEntity.getDimMemberValueMap();
            this.getModel().setValue("dimkeyvaluemap", (Object)SerializationUtils.toJsonString(dimMemberValMap), ints[i]);
            for (Map.Entry<String, String> entry : dimMemberValMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Member member = modelCacheHelper.getMember(key, viewMap.get(key), value);
                if (member == null) continue;
                String memberValue = this.getValueByDisplayType(member, memDisType);
                if (SysDimensionEnum.include((String)key, (Boolean)true)) {
                    this.getModel().setValue("e_" + key.toLowerCase(), (Object)memberValue, ints[i]);
                    continue;
                }
                if (customDimKeyMap.get(key) == null) continue;
                this.getModel().setValue("e_" + customDimKeyMap.get(key).toLowerCase(), (Object)memberValue, ints[i]);
            }
            this.getModel().setValue("e_budget", (Object)rowDataEntity.getBudget(), ints[i]);
            this.getModel().setValue("e_occupy", (Object)rowDataEntity.getOccupy(), ints[i]);
            this.getModel().setValue("e_execute", (Object)rowDataEntity.getExecute(), ints[i]);
            this.getModel().setValue("e_initactual", (Object)rowDataEntity.getInitActual(), ints[i]);
            this.getModel().setValue("e_budoccupy", (Object)rowDataEntity.getBudOccupy(), ints[i]);
            this.getModel().setValue("e_balance", balanceMap.get(instance.getCtlKey(rowDataEntity.getDimMemberValueMap(), controlDimensions)), ints[i]);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(MIAN_ENTRYENTITY);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCustomDimVisible();
        this.setICDimVisible();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model", "dataset"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MIAN_ENTRYENTITY, BIZ_ENTRYENTITY});
        this.updateBillShowField();
        this.filterSchemeByDataset();
        this.getView().setVisible(Boolean.valueOf(!this.isFromReport()), new String[]{"reportfilterap"});
    }

    private void setICDimVisible() {
        Set<String> hashSet = this.getShowDimensionNums();
        boolean isContainIC = hashSet.contains("InternalCompany");
        this.getView().setVisible(Boolean.valueOf(isContainIC), new String[]{"internalcompany", "e_internalcompany"});
    }

    private void setCustomDimVisible() {
        ArrayList<String> hideKeys = new ArrayList<String>();
        ArrayList<String> visibleKeys = new ArrayList<String>();
        Set<String> showDimensionNums = this.getShowDimensionNums();
        Map<String, String> f7ControlDimNumber = this.getF7ControlDimNumber();
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        int size = customDimKeyMap.size();
        for (int i = 0; i < 10; ++i) {
            String f7Key = PRE_F7_CUSTOM + i;
            String entryf7Key = PRE_ENTRY_CUSTOM + i;
            if (i < size && showDimensionNums.contains(f7ControlDimNumber.get(f7Key))) {
                visibleKeys.add(f7Key);
                visibleKeys.add(entryf7Key);
                continue;
            }
            hideKeys.add(f7Key);
            hideKeys.add(entryf7Key);
        }
        this.getView().setVisible(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), hideKeys.toArray(new String[0]));
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.filterSchemeByDataset();
        this.getView().updateView("reportfilterap");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(MIAN_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(BIZ_ENTRYENTITY);
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addF7SelectListener(this::beforeF7Select, this.getF7ControlDimNumber().keySet().toArray(new String[0]));
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.addSearchListener(this::search);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        Object source = event.getSource();
        if (key.equals("model")) {
            event.getCustomQFilters().addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(ModelUtil.getModelFilter((IFormView)this.getView()), null));
        } else if (key.equals("dataset")) {
            event.getCustomQFilters().addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        } else if (source instanceof BasedataEdit) {
            this.dimF7Select(event, key);
        }
    }

    private void dimF7Select(BeforeF7SelectEvent event, String controlKey) {
        Object source = event.getSource();
        Long busModel = this.getModelCacheHelper().getBusModelByDataSet(this.getDataSetId());
        if (source instanceof BasedataEdit) {
            Long modelId = this.getModelId();
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)this.getCurrentDimNumber(controlKey)), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(busModel);
            f7Param.setDatasetId(this.getDataSetId());
            f7Param.setOnlySelLeaf(this.isOnlyLeaf(controlKey));
            f7Param.setMultiSelect(!singleSelDim.contains(this.getCurrentDimNumber(controlKey)));
            f7Param.setCanSelectRoot(controlKey.startsWith(PRE_F7_CUSTOM));
            NewF7Utils.openF7((BeforeF7SelectEvent)event, (MemberF7Parameter)f7Param);
        }
    }

    private boolean isOnlyLeaf(String controlKey) {
        return "version".equals(controlKey) || "datatype".equals(controlKey) || "currency".equals(controlKey) || "metric".equals(controlKey);
    }

    public String getCurrentDimNumber(String controlKey) {
        Map<String, String> f7ControlDimNumber = this.getF7ControlDimNumber();
        return f7ControlDimNumber.get(controlKey);
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        if (MIAN_ENTRYENTITY.equals(entryKey)) {
            this.refreshControlRecord();
        }
    }

    private void refreshControlRecord() {
        int[] selectRows = this.getSelectRow();
        if (selectRows.length == 0) {
            this.getModel().deleteEntryData(BIZ_ENTRYENTITY);
            return;
        }
        List<BizRowDataEntity> selRowBizRowDataEntities = this.getBizRowDataEntities(false, false);
        this.updateBizRowDataEntity(selRowBizRowDataEntities);
        this.updateBillShowField();
    }

    private List<BizRowDataEntity> getBizRowDataEntities(boolean isAll, boolean isExport) {
        HashSet<String> dimMemberKeySet = new HashSet<String>(16);
        Map<String, Set<String>> rowDimMemberInfo = this.getRowDimMemberInfo(isAll, dimMemberKeySet);
        if (rowDimMemberInfo.size() == 0) {
            return new ArrayList<BizRowDataEntity>(0);
        }
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Long busModel = modelCacheHelper.getBusModelByDataSet(this.getDataSetId());
        Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, busModel);
        String crTable = "t_eb_cr" + busModel;
        if (!DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)crTable)) {
            return new ArrayList<BizRowDataEntity>(0);
        }
        BizModel bizModel = this.getBizModel(crTable);
        if (!bizModel.isEBByModel() && bizModel.getDimensions() == null) {
            return new ArrayList<BizRowDataEntity>(0);
        }
        List<Dimension> showDimensionList = this.getShowDimensionList();
        if (CollectionUtils.isEmpty(showDimensionList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"RelQueryExecuteRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        SqlBuilder sqlBuilder = this.buildQueryControlRecordWhereStr(rowDimMemberInfo, modelCacheHelper, showDimensionList, bizModel, false);
        List<BgControlRecord> bgControlRecords = this.queryControlRecords(sqlBuilder, modelCacheHelper, showDimensionList, bizModel, false, dimMemberKeySet, isExport);
        if (CollectionUtils.isEmpty(bgControlRecords)) {
            return new ArrayList<BizRowDataEntity>(0);
        }
        List<BgControlRecord> relBillControlRecords = this.queryRelBillControlRecords(rowDimMemberInfo, modelCacheHelper, showDimensionList, bizModel, bgControlRecords, isExport);
        Map<String, BigDecimal> relBillNwrifAmount = this.getRelBillNwriteAmount(relBillControlRecords);
        Map<String, String> relBillNumbers = this.getRelBillNumber(relBillControlRecords);
        this.cacheBillInfo(bgControlRecords, relBillControlRecords);
        Map<String, String> operationNameMap = this.queryOperationName(bgControlRecords);
        Map<Long, String> usernameMap = this.queryUserName(bgControlRecords);
        Set<String> entityNumbers = bgControlRecords.stream().map(AbstractBgControlRecord::getEntityNumber).collect(Collectors.toSet());
        Map<String, String> billTypeName = this.getBillTypeName(entityNumbers);
        Map<String, Map<Long, String>> reqFieldInfo = this.getReqFieldInfo(bgControlRecords);
        Set<Long> reqOrgUnitIds = bgControlRecords.stream().map(AbstractBgControlRecord::getReqOrgUnitId).collect(Collectors.toSet());
        Map<Long, String> reqOrgUnitMap = this.getReqOrgUnitMember(reqOrgUnitIds, modelCacheHelper, viewMap.get("Entity"));
        Set<Long> reqAccountIds = bgControlRecords.stream().map(AbstractBgControlRecord::getReqAccountId).collect(Collectors.toSet());
        Map<Long, String> reqAccountMap = this.getReqAccountMember(reqAccountIds, modelCacheHelper);
        List<String> needShowFiled = this.updateBillShowField();
        Map<String, String[]> billShowFiledValue = this.getBillShowFiledValue(needShowFiled, bgControlRecords);
        return this.buildBizRowDataEntities(modelCacheHelper, bgControlRecords, relBillNwrifAmount, operationNameMap, usernameMap, relBillNumbers, billTypeName, reqOrgUnitMap, reqAccountMap, billShowFiledValue, needShowFiled, reqFieldInfo);
    }

    private void cacheBillInfo(List<BgControlRecord> bgControlRecords, List<BgControlRecord> relBillControlRecords) {
        String[] billInfo1;
        String[] billInfo;
        HashMap<String, String[]> billInfos = new HashMap<String, String[]>(16);
        if (CollectionUtils.isNotEmpty(bgControlRecords)) {
            for (BgControlRecord bgControlRecord : bgControlRecords) {
                billInfo = new String[]{bgControlRecord.getEntityNumber(), bgControlRecord.getBizId()};
                billInfos.put(bgControlRecord.getBizNumber(), billInfo);
                billInfo1 = new String[]{bgControlRecord.getEntityNumber(), bgControlRecord.getBizNumber()};
                billInfos.put(bgControlRecord.getBizId(), billInfo1);
            }
        }
        if (CollectionUtils.isNotEmpty(relBillControlRecords)) {
            for (BgControlRecord bgControlRecord : relBillControlRecords) {
                billInfo = new String[]{bgControlRecord.getEntityNumber(), bgControlRecord.getBizId()};
                billInfos.put(bgControlRecord.getBizNumber(), billInfo);
                billInfo1 = new String[]{bgControlRecord.getEntityNumber(), bgControlRecord.getBizNumber()};
                billInfos.put(bgControlRecord.getBizId(), billInfo1);
            }
        }
        this.getPageCache().put(CACHE_BILL_INFO, SerializationUtils.serializeToBase64(billInfos));
    }

    private Map<String, String[]> getBillInfos() {
        String cache = this.getPageCache().get(CACHE_BILL_INFO);
        if (cache == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5355\u636e\u7684\u7f13\u5b58\u4fe1\u606f\uff0c\u9875\u9762\u53ef\u80fd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u3002", (String)"RelQueryExecuteRecordPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
    }

    private String[] getCurBillInfo(String billNumberOrBillId) {
        return this.getBillInfos().get(billNumberOrBillId);
    }

    private Map<String, Set<String>> getRowDimMemberInfo(boolean isAll, Set<String> dimMemberKeySet) {
        HashMap<String, Set<String>> rowDimMemberInfo;
        block8: {
            List<Dimension> showDimensionList;
            block7: {
                rowDimMemberInfo = new HashMap<String, Set<String>>(16);
                showDimensionList = this.getShowDimensionList();
                if (!isAll) break block7;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MIAN_ENTRYENTITY);
                if (!CollectionUtils.isNotEmpty((Collection)entryEntity)) break block8;
                for (DynamicObject object : entryEntity) {
                    String dimKeyValueMapJson = object.getString("dimkeyvaluemap");
                    if (dimKeyValueMapJson == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"RelQueryExecuteRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    Map dimKeyValueMap = (Map)SerializationUtils.fromJsonString((String)dimKeyValueMapJson, Map.class);
                    for (Map.Entry entry : dimKeyValueMap.entrySet()) {
                        Set memNums = rowDimMemberInfo.computeIfAbsent((String)entry.getKey(), (Function<String, Set<String>>)((Function<String, Set>)e -> new HashSet(10)));
                        memNums.add(entry.getValue());
                    }
                    dimMemberKeySet.add(this.getMemberKeyByDimGroupInfo(dimKeyValueMap, showDimensionList));
                }
                break block8;
            }
            int[] selectRows = this.getSelectRow();
            if (selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    Object dimKeyValueMapJson = this.getModel().getValue("dimkeyvaluemap", selectRow);
                    if (dimKeyValueMapJson == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"RelQueryExecuteRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    Map dimKeyValueMap = (Map)SerializationUtils.fromJsonString((String)dimKeyValueMapJson.toString(), Map.class);
                    for (Map.Entry entry : dimKeyValueMap.entrySet()) {
                        Set memNums = rowDimMemberInfo.computeIfAbsent((String)entry.getKey(), (Function<String, Set<String>>)((Function<String, Set>)e -> new HashSet(10)));
                        memNums.add(entry.getValue());
                    }
                    dimMemberKeySet.add(this.getMemberKeyByDimGroupInfo(dimKeyValueMap, showDimensionList));
                }
            }
        }
        return rowDimMemberInfo;
    }

    private SqlBuilder buildQueryControlRecordWhereStr(Map<String, Set<String>> rowDimMemberInfo, IModelCacheHelper modelCacheHelper, List<Dimension> showDimensionList, BizModel model, boolean isQueryRelBill) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(BgControlRecordUtils.getSql((BizModel)model).toString(), new Object[0]);
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.append(" fmodelid = ? ", new Object[]{modelCacheHelper.getModelobj().getId()});
        this.fillMemFilterSqlFilter(rowDimMemberInfo, modelCacheHelper, showDimensionList, sqlBuilder, isQueryRelBill);
        if (!isQueryRelBill) {
            sqlBuilder.append(" and  (", new Object[0]);
            sqlBuilder.append("frefbizid = ' ' ", new Object[0]);
            sqlBuilder.append("or (frefbizid != ' ' and foccperiodid != 0 and fbgperiodid != foccperiodid)", new Object[0]);
            sqlBuilder.append(")", new Object[0]);
        }
        return sqlBuilder;
    }

    private void fillMemFilterSqlFilter(Map<String, Set<String>> rowDimMemberInfo, IModelCacheHelper modelCacheHelper, List<Dimension> showDimensionList, SqlBuilder sqlBuilder, boolean isQueryRelBill) {
        Map bgMdRecordFields = BgControlRecordUtils.getBgMdRecordFields();
        Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, this.getBizModelId());
        for (Dimension dimension : showDimensionList) {
            ArrayList<Long> memberIds;
            Set<String> memNumbers;
            String dimNumber = dimension.getNumber();
            String field = (String)bgMdRecordFields.get(dimNumber);
            if (dimNumber.equals("ChangeType")) {
                Long viewId = viewMap.get("ChangeType");
                ArrayList<Long> members = new ArrayList<Long>(2);
                Member occupy = modelCacheHelper.getMember(dimNumber, viewId, "Occupation");
                Member execute = modelCacheHelper.getMember(dimNumber, viewId, "Execute");
                if (occupy != null) {
                    members.add(occupy.getId());
                }
                if (execute != null) {
                    members.add(execute.getId());
                }
                sqlBuilder.append(" and ", new Object[0]).appendIn(field, members);
                continue;
            }
            if (dimNumber.equals("AuditTrail")) {
                Member entityInput = modelCacheHelper.getMember(dimNumber, null, "EntityInput");
                if (entityInput == null) continue;
                sqlBuilder.append(" and ", new Object[0]).append(field, new Object[0]).append(" = ? ", new Object[]{entityInput.getId()});
                continue;
            }
            if (dimNumber.equals("DataType")) {
                Member actual = modelCacheHelper.getMember(dimNumber, null, "Actual");
                if (actual == null) continue;
                sqlBuilder.append(" and ", new Object[0]).append(field, new Object[0]).append(" = ? ", new Object[]{actual.getId()});
                continue;
            }
            if (dimNumber.equals("Version")) {
                Member version = modelCacheHelper.getMember(dimNumber, null, "ACTUAL");
                if (version == null) continue;
                sqlBuilder.append(" and ", new Object[0]).append(field, new Object[0]).append(" = ? ", new Object[]{version.getId()});
                continue;
            }
            if (isQueryRelBill && dimNumber.equals("BudgetPeriod")) continue;
            if (!SysDimensionEnum.include((String)dimNumber, (Boolean)true)) {
                memNumbers = rowDimMemberInfo.get(dimNumber);
                memberIds = new ArrayList<Long>(memNumbers.size());
                for (String memNumber : memNumbers) {
                    Member cusMember = modelCacheHelper.getMember(dimNumber, viewMap.get(dimNumber), memNumber);
                    if (cusMember == null) continue;
                    memberIds.add(cusMember.getId());
                }
                if (!CollectionUtils.isNotEmpty(memberIds)) continue;
                String index = dimension.getFieldMapped().replaceAll("dim", "");
                sqlBuilder.append(" and ", new Object[0]).appendIn("fuserdefinedid" + index, memberIds);
                continue;
            }
            memNumbers = rowDimMemberInfo.get(dimNumber);
            memberIds = new ArrayList(memNumbers.size());
            for (String memNumber : memNumbers) {
                Member member = modelCacheHelper.getMember(dimNumber, viewMap.get(dimNumber), memNumber);
                if (member == null) continue;
                memberIds.add(member.getId());
            }
            if (!CollectionUtils.isNotEmpty(memberIds)) continue;
            sqlBuilder.append(" and ", new Object[0]).appendIn(field, memberIds);
        }
    }

    private List<BgControlRecord> queryControlRecords(SqlBuilder sqlBuilder, IModelCacheHelper modelCacheHelper, List<Dimension> showDimensionList, BizModel model, boolean isQueryRelBill, Set<String> dimMemberKeySet, boolean isExport) {
        LinkedList<BgControlRecord> records;
        block24: {
            records = new LinkedList<BgControlRecord>();
            Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, this.getBizModelId());
            try (DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
                if (ds == null) break block24;
                String field = null;
                Row row = null;
                BgControlRecord record = null;
                kd.epm.eb.common.model.Member member = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    record = new BgControlRecord();
                    record.setId(row.getLong("fid"));
                    record.setModelId(row.getLong("fmodelid"));
                    record.setEntityNumber(row.getString("fentitynumber"));
                    record.setBizId(row.getString("fbizid"));
                    record.setBizNumber(row.getString("fbiznumber"));
                    record.setOperation(row.getString("foperation"));
                    record.setAmount(row.getBigDecimal("famount"));
                    record.setBizModel(model);
                    record.setRefBizId(row.getString("frefbizid"));
                    record.setCreator(row.getLong("fcreatorid"));
                    record.setCreateTime(row.getDate("fcreatetime"));
                    try {
                        record.setSerialJson(row.getString("fserialtextjson"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Member occPeriod = modelCacheHelper.getMember("BudgetPeriod", Long.valueOf(0L), row.getLong("foccperiodid"));
                    if (occPeriod != null) {
                        record.setOccPeriod(new kd.epm.eb.common.model.Member(occPeriod.getId(), occPeriod.getName(), occPeriod.getNumber()));
                    }
                    record.setReqOrgUnit(new kd.epm.eb.common.model.Member(row.getLong("freqorgunitid")));
                    Member entity = modelCacheHelper.getMember("Entity", viewMap.get("Entity"), record.getReqOrgUnit().getId());
                    if (entity != null) {
                        kd.epm.eb.common.model.Member reqOrgUnit = record.getReqOrgUnit();
                        reqOrgUnit.setNumber(entity.getNumber());
                        reqOrgUnit.setName(entity.getName());
                    }
                    record.setReqAccount(new kd.epm.eb.common.model.Member(row.getLong("freqaccountid")));
                    Member account = modelCacheHelper.getMember("Account", Long.valueOf(0L), record.getReqAccount().getId());
                    if (account != null) {
                        kd.epm.eb.common.model.Member reqAccount = record.getReqAccount();
                        reqAccount.setNumber(account.getNumber());
                        reqAccount.setName(account.getName());
                    }
                    Map fields = BgControlRecordUtils.getCommFields((BizModel)model);
                    for (kd.epm.eb.common.model.Dimension dimension : model.getDimensions()) {
                        field = BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) ? BgControlUtils.getUserDefinedIdField((kd.epm.eb.common.model.Dimension)dimension) : (String)fields.get(dimension.getNumber());
                        member = new kd.epm.eb.common.model.Member(row.getLong(field));
                        Member member1 = modelCacheHelper.getMember(dimension.getNumber(), viewMap.get(dimension.getNumber()), member.getId());
                        if (member1 != null) {
                            member.setNumber(member1.getNumber());
                            member.setName(member1.getName());
                        }
                        member.setDimension(dimension);
                        record.setMember(member);
                    }
                    if (!isQueryRelBill) {
                        String memberKeyByControlRecord = this.getMemberKeyByControlRecord(record, showDimensionList);
                        if (dimMemberKeySet != null && !dimMemberKeySet.contains(memberKeyByControlRecord)) continue;
                    }
                    records.add(record);
                    if (isExport && records.size() >= 100000) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u5206\u6279\u5bfc\u51fa\uff0c\u53ea\u5bfc\u51fa\u524d%1\u884c\u63a7\u5236\u8bb0\u5f55\u3002", (String)"RelQueryExecuteRecordPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[]{100000}), Integer.valueOf(5000));
                    } else {
                        if (isExport || records.size() < 10000) continue;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u5206\u6279\u67e5\u8be2\uff0c\u53ea\u8fd4\u56de\u524d%1\u884c\u63a7\u5236\u8bb0\u5f55\u3002", (String)"RelQueryExecuteRecordPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{10000}), Integer.valueOf(5000));
                    }
                    break;
                }
            }
        }
        if (!isQueryRelBill) {
            this.sortBgControlRecords(records);
        }
        return records;
    }

    private void sortBgControlRecords(List<BgControlRecord> controlRecords) {
        Map<String, String> f7ControlDimNumber = this.getF7ControlDimNumber();
        controlRecords.sort((o1, o2) -> {
            int seq = -1;
            for (String key : sortWayList) {
                String dimNumber = (String)f7ControlDimNumber.get(key);
                if (dimNumber == null) continue;
                String dimMem1 = o1.getMemberNumber(dimNumber);
                String dimMem2 = o2.getMemberNumber(dimNumber);
                seq = dimMem1.compareToIgnoreCase(dimMem2);
                if (dimMem1.compareToIgnoreCase(dimMem2) == 0) continue;
                break;
            }
            if (seq == 0) {
                seq = o1.getBizNumber().compareToIgnoreCase(o2.getBizNumber());
                if (seq == 0) {
                    Boolean isNwrite1 = StringUtils.isBlank((CharSequence)o1.getRefBizId());
                    Boolean isNwrite2 = StringUtils.isBlank((CharSequence)o2.getRefBizId());
                    seq = isNwrite1.compareTo(isNwrite2);
                }
                if (seq == 0) {
                    seq = o1.getCreateTime().compareTo(o2.getCreateTime());
                }
            }
            return seq;
        });
    }

    private List<BgControlRecord> queryRelBillControlRecords(Map<String, Set<String>> rowDimMemberInfo, IModelCacheHelper modelCacheHelper, List<Dimension> showDimensionList, BizModel model, List<BgControlRecord> bgControlRecords, boolean isExport) {
        List<BgControlRecord> controlRecords = new ArrayList<BgControlRecord>();
        if (CollectionUtils.isEmpty(bgControlRecords)) {
            return controlRecords;
        }
        ArrayList bizIds = new ArrayList();
        bgControlRecords.forEach(e -> {
            if (StringUtils.isNotBlank((CharSequence)e.getBizId())) {
                bizIds.add(e.getBizId());
            }
        });
        if (CollectionUtils.isEmpty(bizIds)) {
            return controlRecords;
        }
        SqlBuilder sqlBuilder = this.buildQueryControlRecordWhereStr(rowDimMemberInfo, modelCacheHelper, showDimensionList, model, true);
        sqlBuilder.append(" and ", new Object[0]);
        sqlBuilder.appendIn("frefbizid", bizIds);
        controlRecords = this.queryControlRecords(sqlBuilder, modelCacheHelper, showDimensionList, model, true, null, isExport);
        return controlRecords;
    }

    private Map<String, BigDecimal> getRelBillNwriteAmount(List<BgControlRecord> controlRecords) {
        HashMap<String, BigDecimal> relBillNwritAmount = new HashMap<String, BigDecimal>(16);
        for (BgControlRecord bgControlRecord : controlRecords) {
            Long occPeriodId = bgControlRecord.getOccPeriodId();
            Long curPeriodId = bgControlRecord.getMember("BudgetPeriod").getId();
            if (IDUtils.isNotEmptyLong((Long)occPeriodId).booleanValue() && !IDUtils.equals((Object)occPeriodId, (Object)curPeriodId)) continue;
            String signKey = bgControlRecord.getMemberKey(false) + bgControlRecord.getRefBizId();
            relBillNwritAmount.merge(signKey, bgControlRecord.getAmount(), BigDecimal::add);
        }
        return relBillNwritAmount;
    }

    private Map<String, String> getRelBillNumber(List<BgControlRecord> controlRecords) {
        HashMap<String, String> relBillNumbers = new HashMap<String, String>(16);
        for (BgControlRecord bgControlRecord : controlRecords) {
            String signKey;
            String bizNumber = bgControlRecord.getBizNumber();
            kd.epm.eb.common.model.Member member = bgControlRecord.getMember("ChangeType");
            if (member == null || relBillNumbers.get(signKey = bgControlRecord.getMemberKey(true) + member.getNumber() + bgControlRecord.getRefBizId()) != null && ((String)relBillNumbers.get(signKey)).contains(bizNumber)) continue;
            relBillNumbers.merge(signKey, bizNumber, (a, b) -> a + ";" + b);
        }
        return relBillNumbers;
    }

    private List<BizRowDataEntity> buildBizRowDataEntities(IModelCacheHelper orCreate, List<BgControlRecord> bgControlRecords, Map<String, BigDecimal> relBillNwrifAmount, Map<String, String> operationNameMap, Map<Long, String> usernameMap, Map<String, String> relBillNumberStrMap, Map<String, String> billTypeName, Map<Long, String> reqOrgUnitMap, Map<Long, String> reqAccountMap, Map<String, String[]> billShowFiledValue, List<String> needShowFiled, Map<String, Map<Long, String>> reqFieldInfo) {
        List<BizRowDataEntity> bizRowDataEntities = new ArrayList<BizRowDataEntity>();
        if (bgControlRecords != null && bgControlRecords.size() > 0) {
            List<Dimension> showDimensionList = this.getShowDimensionList();
            Map<String, Long> viewMap = this.getViewsMap(orCreate, this.getBizModelId());
            for (BgControlRecord bgControlRecord : bgControlRecords) {
                Member currencyMember;
                kd.epm.eb.common.model.Member changeType = bgControlRecord.getMember(SysDimensionEnum.ChangeType.getNumber());
                Member changeMember = orCreate.getMember(SysDimensionEnum.ChangeType.getNumber(), viewMap.get(SysDimensionEnum.ChangeType.getNumber()), changeType.getId());
                if (changeMember == null) continue;
                BigDecimal amount = bgControlRecord.getAmount();
                String bizId = bgControlRecord.getBizId();
                BizRowDataEntity bizRowDataEntity = new BizRowDataEntity();
                if (!reqFieldInfo.isEmpty() && StringUtils.isNotEmpty((CharSequence)bgControlRecord.getReqEntBaseData()) && IDUtils.isNotEmptyLong((Long)bgControlRecord.getReqEntId()).booleanValue() && reqFieldInfo.get(bgControlRecord.getReqEntBaseData()) != null && StringUtils.isNotEmpty((CharSequence)reqFieldInfo.get(bgControlRecord.getReqEntBaseData()).get(bgControlRecord.getReqEntId()))) {
                    bizRowDataEntity.setOrgunit(reqFieldInfo.get(bgControlRecord.getReqEntBaseData()).get(bgControlRecord.getReqEntId()));
                } else {
                    Member orgMember = orCreate.getMember("Entity", viewMap.get("Entity"), bgControlRecord.getReqOrgUnitId());
                    if (orgMember != null) {
                        bizRowDataEntity.setOrgunit(orgMember.getName());
                    } else {
                        bizRowDataEntity.setOrgunit(reqOrgUnitMap.get(bgControlRecord.getReqOrgUnitId()));
                    }
                }
                if (!reqFieldInfo.isEmpty() && StringUtils.isNotEmpty((CharSequence)bgControlRecord.getReqAccBaseData()) && IDUtils.isNotEmptyLong((Long)bgControlRecord.getReqAccId()).booleanValue() && reqFieldInfo.get(bgControlRecord.getReqAccBaseData()) != null && StringUtils.isNotEmpty((CharSequence)reqFieldInfo.get(bgControlRecord.getReqAccBaseData()).get(bgControlRecord.getReqAccId()))) {
                    bizRowDataEntity.setAccount(reqFieldInfo.get(bgControlRecord.getReqAccBaseData()).get(bgControlRecord.getReqAccId()));
                } else {
                    Member accountMember = orCreate.getMember("Account", Long.valueOf(0L), bgControlRecord.getReqAccountId());
                    if (accountMember != null) {
                        bizRowDataEntity.setAccount(accountMember.getName());
                    } else {
                        bizRowDataEntity.setAccount(reqAccountMap.get(bgControlRecord.getReqAccountId()));
                    }
                }
                Member periodMember = orCreate.getMember("BudgetPeriod", Long.valueOf(0L), bgControlRecord.getMember("BudgetPeriod").getId());
                if (periodMember != null) {
                    bizRowDataEntity.setPeriod(periodMember.getName());
                }
                if ((currencyMember = orCreate.getMember("Currency", Long.valueOf(0L), bgControlRecord.getMember("Currency").getId())) != null) {
                    bizRowDataEntity.setCurrency(currencyMember.getName());
                }
                bizRowDataEntity.setEntitynumber(bgControlRecord.getEntityNumber());
                bizRowDataEntity.setBillTypeName(billTypeName.get(bgControlRecord.getEntityNumber()));
                bizRowDataEntity.setBizId(bgControlRecord.getBizId());
                bizRowDataEntity.setChangeTypeMemNumber(changeMember.getNumber());
                bizRowDataEntity.setBiznumber(bgControlRecord.getBizNumber());
                if (needShowFiled.size() > 0) {
                    bizRowDataEntity.setBillShowFiledValue(billShowFiledValue.getOrDefault(bgControlRecord.getBizNumber(), new String[needShowFiled.size()]));
                }
                bizRowDataEntity.setUserId(bgControlRecord.getCreator());
                Long applierId = bgControlRecord.getApplierId();
                if (IDUtils.isNotNull((Long)applierId)) {
                    bizRowDataEntity.setUserId(applierId);
                }
                bizRowDataEntity.setUserName(usernameMap.get(bizRowDataEntity.getUserId()));
                bizRowDataEntity.setCreatetime(bgControlRecord.getCreateTime());
                bizRowDataEntity.setMemberKey(this.getMemberKeyByControlRecord(bgControlRecord, showDimensionList));
                String operationName = bgControlRecord.getOperation();
                if (operationNameMap.get(bgControlRecord.getEntityNumber() + "_" + bgControlRecord.getOperation()) != null) {
                    operationName = operationNameMap.get(bgControlRecord.getEntityNumber() + "_" + bgControlRecord.getOperation());
                }
                bizRowDataEntity.setOperation(operationName);
                Long occPeriodId = bgControlRecord.getOccPeriodId();
                Long curPeriodId = bgControlRecord.getMember("BudgetPeriod").getId();
                if (IDUtils.isNotEmptyLong((Long)occPeriodId).booleanValue() && !IDUtils.equals((Object)occPeriodId, (Object)curPeriodId)) {
                    bizRowDataEntity.setDiffPeriod(true);
                    if ("Occupation".equals(changeMember.getNumber())) {
                        bizRowDataEntity.setNwriteoff(amount);
                    } else if ("Execute".equals(changeMember.getNumber())) {
                        bizRowDataEntity.setNwriteexecute(amount);
                    }
                } else {
                    BigDecimal bigDecimal;
                    if ("Occupation".equals(changeMember.getNumber())) {
                        bizRowDataEntity.setOccupy(amount);
                        bigDecimal = relBillNwrifAmount.get(bgControlRecord.getMemberKey(false) + bizId);
                        if (bigDecimal != null) {
                            bizRowDataEntity.setNwriteoff(bigDecimal);
                            bizRowDataEntity.setNleftoccupy(amount.add(bigDecimal));
                        }
                    } else if ("Execute".equals(changeMember.getNumber())) {
                        bizRowDataEntity.setExecute(amount);
                        bigDecimal = relBillNwrifAmount.get(bgControlRecord.getMemberKey(false) + bizId);
                        if (bigDecimal != null) {
                            bizRowDataEntity.setNwriteexecute(bigDecimal);
                        }
                    }
                    String relBillNumbers = relBillNumberStrMap.get(bgControlRecord.getMemberKey(true) + changeMember.getNumber() + bizId);
                    bizRowDataEntity.setRelBillNumber(relBillNumbers);
                }
                bizRowDataEntities.add(bizRowDataEntity);
            }
        }
        if (this.isNeedCombineDetailRow()) {
            bizRowDataEntities = this.combineControlRecords(bizRowDataEntities);
        }
        return bizRowDataEntities;
    }

    private String getMemberKeyByControlRecord(BgControlRecord bgControlRecord, List<Dimension> showDimensionList) {
        StringBuilder str = new StringBuilder();
        for (Dimension dimension : showDimensionList) {
            String memNum;
            if (ignoreDim.contains(dimension.getNumber()) || (memNum = bgControlRecord.getMemberNumber(dimension.getNumber())) == null) continue;
            str.append(memNum).append("_");
        }
        return str.toString();
    }

    private String getMemberKeyByDimGroupInfo(Map<String, String> dimKeyValueMap, List<Dimension> showDimensionList) {
        StringBuilder str = new StringBuilder();
        for (Dimension dimension : showDimensionList) {
            String memNum;
            if (ignoreDim.contains(dimension.getNumber()) || (memNum = dimKeyValueMap.get(dimension.getNumber())) == null) continue;
            str.append(memNum).append("_");
        }
        return str.toString();
    }

    private Map<String, String> getBillTypeName(Set<String> entityNumbers) {
        HashMap<String, String> billTypeName = new HashMap<String, String>(16);
        if (!entityNumbers.isEmpty()) {
            QFilter filter = new QFilter("number", "in", entityNumbers);
            Map objs = BusinessDataServiceHelper.loadFromCache((String)"eb_structofbill", (String)"name, number", (QFilter[])filter.toArray());
            for (DynamicObject obj : objs.values()) {
                billTypeName.put(obj.getString("number"), obj.getString("name"));
            }
        }
        return billTypeName;
    }

    private Map<Long, String> getReqAccountMember(Set<Long> reqAccountIds, IModelCacheHelper modelCacheHelper) {
        HashMap<Long, String> accountMap = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(reqAccountIds)) {
            return accountMap;
        }
        for (Long reqAccountId : reqAccountIds) {
            Member member = modelCacheHelper.getMember("Account", Long.valueOf(0L), reqAccountId);
            if (member != null) continue;
            accountMap.put(reqAccountId, null);
        }
        if (!accountMap.isEmpty()) {
            QFilter filter = new QFilter("id", "in", accountMap.keySet());
            Map objs = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitemedit", (String)"id, name, number", (QFilter[])filter.toArray());
            for (DynamicObject obj : objs.values()) {
                accountMap.put(obj.getLong("id"), obj.getString("name"));
            }
        }
        return accountMap;
    }

    private Map<String, Map<Long, String>> getReqFieldInfo(List<BgControlRecord> bgControlRecords) {
        HashMap<String, Map<Long, String>> reqObjInfo = new HashMap<String, Map<Long, String>>(bgControlRecords.size());
        for (BgControlRecord bgControlRecord : bgControlRecords) {
            try {
                Map retMap;
                if (!StringUtils.isNotEmpty((CharSequence)bgControlRecord.getSerialJson())) continue;
                if (StringUtils.isNotEmpty((CharSequence)bgControlRecord.getReqAccBaseData()) && IDUtils.isNotEmptyLong((Long)bgControlRecord.getReqAccId()).booleanValue()) {
                    retMap = reqObjInfo.getOrDefault(bgControlRecord.getReqAccBaseData(), new HashMap());
                    retMap.put(bgControlRecord.getReqAccId(), null);
                    reqObjInfo.put(bgControlRecord.getReqAccBaseData(), retMap);
                }
                if (!StringUtils.isNotEmpty((CharSequence)bgControlRecord.getReqEntBaseData()) || !IDUtils.isNotEmptyLong((Long)bgControlRecord.getReqEntId()).booleanValue()) continue;
                retMap = reqObjInfo.getOrDefault(bgControlRecord.getReqEntBaseData(), new HashMap());
                retMap.put(bgControlRecord.getReqEntId(), null);
                reqObjInfo.put(bgControlRecord.getReqEntBaseData(), retMap);
            }
            catch (Exception retMap) {}
        }
        if (!reqObjInfo.isEmpty()) {
            for (Map.Entry entry : reqObjInfo.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || ((Map)entry.getValue()).isEmpty()) continue;
                Map KVmap = (Map)entry.getValue();
                QFBuilder qfBuilder = QFBuilder.newQFilter().and("id", "in", KVmap.keySet());
                String metadata = (String)entry.getKey();
                if ("bos_adminorg".equals(metadata)) {
                    metadata = "bos_adminorg_structure";
                    qfBuilder.add(new QFilter("org.id", "in", KVmap.keySet()));
                    qfBuilder.add(new QFilter("view.treetype", "=", (Object)"01"));
                }
                Map objs = BusinessDataServiceHelper.loadFromCache((String)metadata, (String)"id, name, number", (QFilter[])qfBuilder.toArray());
                for (DynamicObject obj : objs.values()) {
                    KVmap.put(obj.getLong("id"), obj.getString("name"));
                }
            }
        }
        return reqObjInfo;
    }

    private Map<Long, String> getReqOrgUnitMember(Set<Long> reqOrgUnitIds, IModelCacheHelper modelCacheHelper, Long viewId) {
        HashMap<Long, String> reqOrgUnitMap = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(reqOrgUnitIds)) {
            return reqOrgUnitMap;
        }
        for (Long reqOrgUnitId : reqOrgUnitIds) {
            Member member = modelCacheHelper.getMember("Entity", viewId, reqOrgUnitId);
            if (member != null) continue;
            reqOrgUnitMap.put(reqOrgUnitId, null);
        }
        QFilter filter = new QFilter("id", "in", reqOrgUnitMap.keySet());
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, name, number", (QFilter[])filter.toArray());
        for (DynamicObject obj : objs.values()) {
            reqOrgUnitMap.put(obj.getLong("id"), obj.getString("name"));
        }
        return reqOrgUnitMap;
    }

    private Map<Long, String> queryUserName(List<BgControlRecord> bgControlRecords) {
        HashMap<Long, String> usernameMap = new HashMap<Long, String>(16);
        ArrayList userIds = new ArrayList();
        if (CollectionUtils.isEmpty(bgControlRecords)) {
            return usernameMap;
        }
        bgControlRecords.forEach(e -> {
            Long applierId = e.getApplierId();
            if (IDUtils.isNotNull((Long)applierId)) {
                userIds.add(applierId);
            } else {
                userIds.add(e.getCreator());
            }
        });
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_user", (String)"name,id", (QFilter[])new QFilter("id", "in", userIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject object : query) {
                usernameMap.put(object.getLong("id"), object.getString("name"));
            }
        }
        return usernameMap;
    }

    private Map<String, String> queryOperationName(List<BgControlRecord> bgControlRecords) {
        HashMap<String, String> operationNameMap = new HashMap<String, String>(16);
        ArrayList entityNumbers = new ArrayList();
        ArrayList numbers = new ArrayList();
        if (CollectionUtils.isEmpty(bgControlRecords)) {
            return operationNameMap;
        }
        bgControlRecords.forEach(e -> {
            entityNumbers.add(e.getEntityNumber());
            numbers.add(e.getOperation());
        });
        QFilter qFilter1 = new QFilter("fieldtable", "in", entityNumbers);
        QFilter qFilter2 = new QFilter("number", "in", numbers);
        String selectFiled = "fieldtable,number,name";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)selectFiled, (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject object : query) {
                String entitynumber = object.getString("fieldtable");
                String operationNumber = object.getString("number");
                String operationName = object.getString("name");
                operationNameMap.put(entitynumber + "_" + operationNumber, operationName);
            }
        }
        return operationNameMap;
    }

    private BizModel getBizModel(String crTable) {
        BizModel model = new BizModel(ModelUtils.getModel((Long)this.getModelId()));
        if (!model.isEBByModel() && crTable.startsWith("t_eb_cr")) {
            model.setControlBusModelId(Long.valueOf(crTable.replaceFirst("t_eb_cr", "")));
        }
        if (model.getDimensions() == null || model.getDimensions().isEmpty()) {
            BgControlUtils.queryControlDimension((BizModel)model);
            if (!model.isEBByModel() && model.getControlDims() != null) {
                List dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)model, (boolean)false);
                dimensions = model.filterControlDims(dimensions);
                model.setDimension(dimensions);
            }
        }
        return model;
    }

    private List<BizRowDataEntity> combineControlRecords(List<BizRowDataEntity> bizRowDataEntities) {
        if (CollectionUtils.isEmpty(bizRowDataEntities)) {
            return bizRowDataEntities;
        }
        Iterator<BizRowDataEntity> iterator = bizRowDataEntities.iterator();
        ArrayList<BizRowDataEntity> afterCombineBizRowData = new ArrayList<BizRowDataEntity>(bizRowDataEntities.size());
        BizRowDataEntity lastRow = iterator.next();
        String lastKey = lastRow.getGroupKey();
        afterCombineBizRowData.add(lastRow);
        while (iterator.hasNext()) {
            BizRowDataEntity curRow = iterator.next();
            String curKey = curRow.getGroupKey();
            if (!lastRow.isDiffPeriod() && !curRow.isDiffPeriod() && curKey.equals(lastKey)) {
                if (lastRow.getDetailRecord() == null) {
                    BizRowDataEntity cloneRow = lastRow.clone();
                    cloneRow.setNwriteoff(null);
                    cloneRow.setNwriteexecute(null);
                    lastRow.addDetailRecord(cloneRow);
                    lastRow.setCollect(true);
                }
                lastRow.addDetailRecord(curRow);
                lastRow.setOrgunit(this.appendDiffMember(lastRow.getOrgunit(), curRow.getOrgunit()));
                lastRow.setAccount(this.appendDiffMember(lastRow.getAccount(), curRow.getAccount()));
                lastRow.addOccupy(curRow.getOccupy());
                lastRow.setNwriteoff(curRow.getNwriteoff());
                lastRow.addExecute(curRow.getExecute());
                lastRow.setNwriteexecute(curRow.getNwriteexecute());
                curRow.setNwriteoff(null);
                curRow.setNwriteexecute(null);
                continue;
            }
            afterCombineBizRowData.add(curRow);
            lastKey = curKey;
            lastRow = curRow;
        }
        return afterCombineBizRowData;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        int rowKey = evt.getRowKey();
        Object detailInfo = this.getModel().getValue("detail_info", rowKey);
        if (detailInfo != null && StringUtils.isNotEmpty((CharSequence)detailInfo.toString())) {
            List detailRowEntities = (List)SerializationUtils.deSerializeFromBase64((String)detailInfo.toString());
            if (CollectionUtils.isEmpty((Collection)detailRowEntities)) {
                return;
            }
            this.getModel().beginInit();
            int[] rowIndex = this.getModel().batchInsertEntryRow(BIZ_ENTRYENTITY, rowKey, detailRowEntities.size());
            int i = 0;
            for (BizRowDataEntity detailRowData : detailRowEntities) {
                this.fillBizRowEntryEntityInfo(detailRowData, rowIndex[i]);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(BIZ_ENTRYENTITY);
        }
    }

    private void updateBizRowDataEntity(List<BizRowDataEntity> bizRowDataEntities) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(BIZ_ENTRYENTITY);
        if (bizRowDataEntities.size() > 0) {
            int[] rows = this.getModel().batchCreateNewEntryRow(BIZ_ENTRYENTITY, bizRowDataEntities.size());
            int i = 0;
            for (BizRowDataEntity bizRowDataEntity : bizRowDataEntities) {
                this.fillBizRowEntryEntityInfo(bizRowDataEntity, rows[i]);
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(BIZ_ENTRYENTITY);
    }

    private Map<String, String[]> getBillShowFiledValue(List<String> needShowFiled, List<BgControlRecord> bgControlRecords) {
        if (needShowFiled.size() == 0) {
            return new HashMap<String, String[]>(0);
        }
        HashMap<String, Set> entityToBillIdMap = new HashMap<String, Set>(16);
        for (BgControlRecord bgControlRecord : bgControlRecords) {
            String entityNumber = bgControlRecord.getEntityNumber();
            String bizId = bgControlRecord.getBizId();
            try {
                if (!StringUtils.isNotEmpty((CharSequence)bizId)) continue;
                Set billIds = entityToBillIdMap.computeIfAbsent(entityNumber, e -> new HashSet(16));
                billIds.add(bizId);
            }
            catch (Exception e2) {
                log.info("getBillShowFiledValue:" + e2.toString());
            }
        }
        HashMap<String, String[]> billShowFiledValue = new HashMap<String, String[]>(16);
        HashMap comboItemKeyValues = new HashMap(16);
        for (Map.Entry entry : entityToBillIdMap.entrySet()) {
            DynamicObjectCollection billInfo;
            DynamicProperty property;
            String entityNumber = (String)entry.getKey();
            MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (dynamicObjectType == null) continue;
            ISimpleProperty primaryKey = dynamicObjectType.getPrimaryKey();
            HashSet billIds = primaryKey instanceof LongProp || primaryKey instanceof BasedataProp || primaryKey instanceof IntegerProp ? new HashSet(IDUtils.toLongs((Set)((Set)entry.getValue()))) : new HashSet((Collection)entry.getValue());
            Set billWholeFiled = dynamicObjectType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
            String billNumberField = ((BillEntityType)dynamicObjectType).getBillNo();
            if (StringUtils.isEmpty((CharSequence)billNumberField)) continue;
            HashSet<String> queryFiled = new HashSet<String>(needShowFiled);
            queryFiled.removeIf(e -> !billWholeFiled.contains(e.split("\\.")[0]));
            queryFiled.add(billNumberField);
            if (queryFiled.size() == 0) continue;
            for (String field : queryFiled) {
                List comboItems;
                property = dynamicObjectType.getProperty(field);
                if (!(property instanceof ComboProp) || !CollectionUtils.isNotEmpty((Collection)(comboItems = ((ComboProp)property).getComboItems()))) continue;
                comboItems.forEach(item -> comboItemKeyValues.put(property.getName() + item.getValue(), item.getName().getLocaleValue()));
            }
            try {
                billInfo = QueryServiceHelper.query((String)entityNumber, (String)StringUtils.join((Object[])queryFiled.toArray(), (String)","), (QFilter[])new QFilter("id", "in", billIds).toArray());
            }
            catch (Exception e3) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8054\u67e5\u6267\u884c\u8bb0\u5f55\u6269\u5c55\u9875\u9762\u201c\u5355\u636e\u53e6\u5916\u5c55\u793a\u5b57\u6bb5\u201d\u4e0b\u62c9\u9879\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u201c%1\u201d\u3002", (String)"RelQueryExecuteRecordPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{e3.toString()}));
                break;
            }
            if (!CollectionUtils.isNotEmpty((Collection)billInfo)) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < needShowFiled.size(); ++i) {
                String[] values;
                if (!queryFiled.contains(needShowFiled.get(i))) continue;
                property = dynamicObjectType.getProperty(needShowFiled.get(i));
                if (property instanceof ComboProp) {
                    for (DynamicObject object : billInfo) {
                        values = billShowFiledValue.computeIfAbsent(object.getString(billNumberField), e -> new String[needShowFiled.size()]);
                        values[i] = (String)comboItemKeyValues.get(property.getName() + object.getString(needShowFiled.get(i)));
                    }
                    continue;
                }
                if (property instanceof DateProp) {
                    for (DynamicObject object : billInfo) {
                        values = billShowFiledValue.computeIfAbsent(object.getString(billNumberField), e -> new String[needShowFiled.size()]);
                        values[i] = object.getDate(needShowFiled.get(i)) == null ? "" : dateFormat.format(object.getDate(needShowFiled.get(i)));
                    }
                    continue;
                }
                for (DynamicObject object : billInfo) {
                    values = billShowFiledValue.computeIfAbsent(object.getString(billNumberField), e -> new String[needShowFiled.size()]);
                    values[i] = object.getString(needShowFiled.get(i));
                }
            }
        }
        return billShowFiledValue;
    }

    private List<String> updateBillShowField() {
        ArrayList<String> needShowFiled = new ArrayList<String>(10);
        Map<String, LocaleString> billShowFiledName = this.getBillShowFiledName();
        Iterator<Map.Entry<String, LocaleString>> iterator = billShowFiledName.entrySet().iterator();
        HashSet<String> visibleField = new HashSet<String>(5);
        HashSet<String> noVisibleField = new HashSet<String>(5);
        for (int i = 0; i < 10; ++i) {
            String colKey = "f_billshowfiled" + i;
            if (iterator.hasNext()) {
                visibleField.add(colKey);
                Map.Entry<String, LocaleString> next = iterator.next();
                TextEdit entrControl = (TextEdit)this.getControl(colKey);
                entrControl.setCaption(billShowFiledName.get(next.getKey()));
                needShowFiled.add(next.getKey());
                continue;
            }
            noVisibleField.add(colKey);
        }
        if (CollectionUtils.isNotEmpty(visibleField)) {
            this.getView().setVisible(Boolean.valueOf(true), visibleField.toArray(new String[0]));
        }
        if (CollectionUtils.isNotEmpty(noVisibleField)) {
            this.getView().setVisible(Boolean.valueOf(false), noVisibleField.toArray(new String[0]));
        }
        return needShowFiled;
    }

    private Map<String, LocaleString> getBillShowFiledName() {
        String[] split;
        LinkedHashMap<String, LocaleString> billShowFiledName = new LinkedHashMap<String, LocaleString>(16);
        MulComboProp mulComboProp = (MulComboProp)((MulComboEdit)this.getControl("billshowfield")).getProperty();
        Object billShowFieldStr = mulComboProp.getDefValue();
        List comboItems = mulComboProp.getComboItems();
        Map<String, LocaleString> fieldNameMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
        for (String field : split = billShowFieldStr.toString().split(",")) {
            if (field.isEmpty() || field.startsWith(",") || billShowFiledName.size() >= 10 || !fieldNameMap.containsKey(field)) continue;
            billShowFiledName.put(field, fieldNameMap.get(field));
        }
        return billShowFiledName;
    }

    private void fillBizRowEntryEntityInfo(BizRowDataEntity bizRowDataEntity, int rowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(BIZ_ENTRYENTITY, rowIndex);
        entryRowEntity.set("f_entity", (Object)bizRowDataEntity.getOrgunit());
        entryRowEntity.set("f_account", (Object)bizRowDataEntity.getAccount());
        entryRowEntity.set("f_period", (Object)bizRowDataEntity.getPeriod());
        entryRowEntity.set("f_currency", (Object)bizRowDataEntity.getCurrency());
        entryRowEntity.set("f_entitynumber", (Object)bizRowDataEntity.getBillTypeName());
        entryRowEntity.set("f_billentitynumber", (Object)bizRowDataEntity.getEntityNumber());
        entryRowEntity.set("f_bizid", (Object)bizRowDataEntity.getBizId());
        entryRowEntity.set("f_biznumber", (Object)bizRowDataEntity.getBiznumber());
        entryRowEntity.set("t_creator_id", (Object)bizRowDataEntity.getUserId());
        entryRowEntity.set("f_createtime", (Object)bizRowDataEntity.getCreatetime());
        entryRowEntity.set("f_operation", (Object)bizRowDataEntity.getOperation());
        entryRowEntity.set("f_refbiznumber", (Object)bizRowDataEntity.getRelBillNumber());
        entryRowEntity.set("f_changetypememnumber", (Object)bizRowDataEntity.getChangeTypeMemNumber());
        entryRowEntity.set("f_occupy", (Object)bizRowDataEntity.getOccupy());
        entryRowEntity.set("f_nwriteoff", (Object)bizRowDataEntity.getNwriteoff());
        entryRowEntity.set("f_nleftoccupy", (Object)bizRowDataEntity.getNleftoccupy());
        entryRowEntity.set("f_execute", (Object)bizRowDataEntity.getExecute());
        entryRowEntity.set("f_nwriteexecute", (Object)bizRowDataEntity.getNwriteexecute());
        String[] billShowFiledValue = bizRowDataEntity.getBillShowFiledValue();
        if (billShowFiledValue != null && billShowFiledValue.length > 0) {
            for (int i = 0; i < billShowFiledValue.length; ++i) {
                entryRowEntity.set("f_billshowfiled" + i, (Object)billShowFiledValue[i]);
            }
        }
        if (bizRowDataEntity.isCollect()) {
            entryRowEntity.set("isgroupnode", (Object)true);
            entryRowEntity.set("detail_info", (Object)SerializationUtils.serializeToBase64(bizRowDataEntity.getDetailRecord()));
        }
    }

    private int[] getSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(MIAN_ENTRYENTITY);
        return entryGrid.getSelectRows();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (key) {
            case "model": {
                this.toDealModelChange(changeSet[0]);
                break;
            }
            case "dataset": {
                this.toDealDataSetChange();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String backKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("multiSelOne".equals(backKey) && returnData != null) {
            this.mulRelBillSelClose(returnData);
        }
    }

    private void mulRelBillSelClose(Object returnData) {
        String selectBillId;
        String[] curBillInfo;
        if (returnData instanceof String && (curBillInfo = this.getCurBillInfo(selectBillId = returnData.toString())) != null && curBillInfo.length == 2) {
            this.openBill(curBillInfo[0], selectBillId);
        }
    }

    private void toDealModelChange(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
    }

    private void toDealDataSetChange() {
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        String fieldName = evt.getFieldName();
        if ("f_biznumber".equals(fieldName)) {
            this.openCurBill(evt);
        } else if ("f_refbiznumber".equals(fieldName)) {
            this.openRelBill(evt);
        }
    }

    private void openCurBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String billNumber = (String)this.getModel().getValue("f_biznumber", rowIndex);
        String[] curBillInfo = this.getCurBillInfo(billNumber);
        if (curBillInfo != null && curBillInfo.length == 2) {
            this.openBill(curBillInfo[0], curBillInfo[1]);
        }
    }

    private void openRelBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String relBillNumberStr = (String)this.getModel().getValue("f_refbiznumber", rowIndex);
        if (StringUtils.isEmpty((CharSequence)relBillNumberStr)) {
            return;
        }
        if (relBillNumberStr.contains(";")) {
            String[] relBillNumbers = relBillNumberStr.split(";");
            this.openMulRelBillSelPage(relBillNumbers);
        } else {
            String[] curBillInfo = this.getCurBillInfo(relBillNumberStr);
            if (curBillInfo == null || curBillInfo.length != 2) {
                return;
            }
            this.openBill(curBillInfo[0], curBillInfo[1]);
        }
    }

    private void openMulRelBillSelPage(String[] relBillNumbers) {
        Map<String, String[]> billInfos = this.getBillInfos();
        HashMap<String, String> items = new HashMap<String, String>(relBillNumbers.length);
        for (String relBillNumber : relBillNumbers) {
            String[] billInfo = billInfos.get(relBillNumber);
            if (billInfo == null || billInfo.length != 2) continue;
            items.put(billInfo[1], relBillNumber);
        }
        FormShowParameter multiSelOneFormShowPram = MultiSelOneFormPlugin.getMultiSelOneFormShowPram((IFormPlugin)this, items, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5f20\u5355\u636e\u3002", (String)"RelQueryExecuteRecordPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(multiSelOneFormShowPram);
    }

    private void openBill(String entityNumber, String billId) {
        String appId = BillPreOpenCheckUtil.getInstance().checkViewPerm(entityNumber, (Object)billId, (IFormView)this.getView());
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            HashMap<String, String> openParameter = new HashMap<String, String>();
            HashMap<String, String> customParams = new HashMap<String, String>();
            openParameter.put("formId", entityNumber);
            openParameter.put("pkId", billId);
            customParams.put("checkRightAppId", appId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_export": {
                this.exportData(false);
                break;
            }
            case "btn_exportall": {
                this.exportData(true);
                break;
            }
            case "btn_showname": 
            case "btn_shownumber": 
            case "btn_shownumname": {
                this.getPageCache().put(MEM_DISTYPE, itemKey);
                this.updateDimMemberDisplayProp(itemKey);
                break;
            }
            case "refresh": {
                this.search(null);
                break;
            }
            case "btn_loadmore": {
                this.loadMoreData();
                break;
            }
        }
    }

    private void loadMoreData() {
        if (this.isNeedLoadMore().booleanValue()) {
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"RelQueryExecuteRecordPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                this.searchData(true);
                this.setNeedLoadMore(false);
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
            finally {
                this.getView().hideLoading();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52a0\u8f7d\u6240\u6709\u6210\u5458\u6570\u636e\u3002", (String)"RelQueryExecuteRecordPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateDimMemberDisplayProp(String displayType) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, this.getBizModelId());
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MIAN_ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject entryRowEntity : entryEntity) {
            String dimKeyValueMapJson = entryRowEntity.getString("dimkeyvaluemap");
            if (dimKeyValueMapJson == null) continue;
            Map dimMemberValMap = (Map)SerializationUtils.fromJsonString((String)dimKeyValueMapJson, Map.class);
            for (Map.Entry entry : dimMemberValMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Member member = modelCacheHelper.getMember(key, viewMap.get(key), value);
                if (member == null) continue;
                String memValue = this.getValueByDisplayType(member, displayType);
                if (SysDimensionEnum.include((String)key, (Boolean)true)) {
                    entryRowEntity.set("e_" + key.toLowerCase(), (Object)memValue);
                    continue;
                }
                if (customDimKeyMap.get(key) == null) continue;
                entryRowEntity.set("e_" + customDimKeyMap.get(key).toLowerCase(), (Object)memValue);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(MIAN_ENTRYENTITY);
    }

    private String getValueByDisplayType(Member member, String displayType) {
        String value = BTN_SHOWNUMBER.equals(displayType) ? member.getNumber() : (BTN_SHOWNUMNAME.equals(displayType) ? member.getNumber() + "#" + member.getName() : member.getName());
        return value;
    }

    private void exportData(boolean isAll) {
        List<DynamicObject> entityList = this.getMainEntityList(isAll);
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        XSSFWorkbook excelBook = new XSSFWorkbook();
        Map<String, List<BizRowDataEntity>> rowControlRecords = this.getRowControlRecords(isAll, true);
        this.handleData(excelBook, entityList, rowControlRecords, this.getMainRowHeader(), this.getBizRowHeader(), this.getMainRowProps());
        this.exportEntity(excelBook);
        this.writeLog("export", new MultiLangEnumBridge("\u5bfc\u51fa", "RelQueryExecuteRecordPlugin_46", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f\u3002", "RelQueryExecuteRecordPlugin_45", "epm-eb-formplugin"));
    }

    private List<DynamicObject> getMainEntityList(boolean isAll) {
        ArrayList<DynamicObject> entityList = new ArrayList<DynamicObject>(10);
        if (isAll) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MIAN_ENTRYENTITY);
            if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                entityList.addAll((Collection<DynamicObject>)entryEntity);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"RelQueryExecuteRecordPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            int[] selectRows = this.getSelectRow();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"RelQueryExecuteRecordPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                for (int selectRow : selectRows) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(MIAN_ENTRYENTITY, selectRow);
                    entityList.add(entryRowEntity);
                }
            }
        }
        return entityList;
    }

    private Map<String, List<BizRowDataEntity>> getRowControlRecords(boolean isAll, boolean isExport) {
        List<BizRowDataEntity> bizRowDataEntities = this.getBizRowDataEntities(isAll, isExport);
        HashMap<String, List<BizRowDataEntity>> relBizRowDataEntities = new HashMap<String, List<BizRowDataEntity>>(16);
        for (BizRowDataEntity bizRowDataEntity : bizRowDataEntities) {
            List curMemberKeyRelBizRowData = relBizRowDataEntities.computeIfAbsent(bizRowDataEntity.getMemberKey(), e -> new ArrayList(10));
            curMemberKeyRelBizRowData.add(bizRowDataEntity);
        }
        return relBizRowDataEntities;
    }

    private String[] getMainRowProps() {
        StringBuilder mainRowProps = new StringBuilder("e_entity,e_account,e_budgetperiod");
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        for (int i = 0; i < customDimKeyMap.size(); ++i) {
            mainRowProps.append(",").append(PRE_ENTRY_CUSTOM).append(i);
        }
        mainRowProps.append(",e_version,e_datatype,e_audittrail,e_changetype,e_currency,e_metric,");
        List<String> orderDimNumbers = this.getOrderDimNumbers();
        if (orderDimNumbers.contains(SysDimensionEnum.InternalCompany.getNumber())) {
            mainRowProps.append("e_").append(SysDimensionEnum.InternalCompany.getNumber().toLowerCase()).append(",");
        }
        mainRowProps.append("e_budget,e_occupy,e_execute,e_initactual,e_budoccupy,e_balance");
        return mainRowProps.toString().split(",");
    }

    private List<String> getBizRowHeader() {
        ArrayList<String> bizRowHeader = new ArrayList<String>(10);
        bizRowHeader.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"RelQueryExecuteRecordPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"RelQueryExecuteRecordPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"RelQueryExecuteRecordPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"RelQueryExecuteRecordPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"RelQueryExecuteRecordPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b9e\u4f53\u7f16\u7801", (String)"RelQueryExecuteRecordPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5355\u636eid", (String)"RelQueryExecuteRecordPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"RelQueryExecuteRecordPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Map<String, LocaleString> billShowFiledName = this.getBillShowFiledName();
        if (billShowFiledName.size() > 0) {
            for (LocaleString value : billShowFiledName.values()) {
                bizRowHeader.add(value.getLocaleValue());
            }
        }
        bizRowHeader.add(ResManager.loadKDString((String)"\u6263\u51cf\u7533\u8bf7\u4eba", (String)"RelQueryExecuteRecordPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u6263\u51cf\u65e5\u671f", (String)"RelQueryExecuteRecordPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u6263\u51cf\u52a8\u4f5c", (String)"RelQueryExecuteRecordPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u7f16\u7801", (String)"RelQueryExecuteRecordPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"RelQueryExecuteRecordPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u51b2\u9500\u5360\u7528\u6570", (String)"RelQueryExecuteRecordPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"RelQueryExecuteRecordPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        bizRowHeader.add(ResManager.loadKDString((String)"\u51b2\u9500\u6267\u884c\u6570", (String)"RelQueryExecuteRecordPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return bizRowHeader;
    }

    private List<String> getMainRowHeader() {
        ArrayList<String> rowHeader = new ArrayList<String>();
        List<String> orderDimNumbers = this.getOrderDimNumbers();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        orderDimNumbers.forEach(dimNumber -> {
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            rowHeader.add(dimension.getName());
        });
        rowHeader.add(ResManager.loadKDString((String)"\u9884\u7b97\u6570", (String)"RelQueryExecuteRecordPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rowHeader.add(ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"RelQueryExecuteRecordPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rowHeader.add(ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"RelQueryExecuteRecordPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rowHeader.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b9e\u9645\u6570", (String)"RelQueryExecuteRecordPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rowHeader.add(ResManager.loadKDString((String)"\u8c03\u6574\u5728\u9014\u9884\u7b97", (String)"RelQueryExecuteRecordPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rowHeader.add(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d", (String)"RelQueryExecuteRecordPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return rowHeader;
    }

    private void handleData(XSSFWorkbook excelBook, List<DynamicObject> entityList, Map<String, List<BizRowDataEntity>> allRowControlRecords, List<String> mainHeader, List<String> bizHeader, String[] mainRowProps) {
        String billName = ResManager.loadKDString((String)"\u8054\u67e5\u6267\u884c\u8bb0\u5f55", (String)"RelQueryExecuteRecordPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        XSSFSheet billSheet = excelBook.createSheet(billName);
        billSheet.setDefaultColumnWidth(20);
        CellStyle titleStyleCellStyle = this.getCellStyle(excelBook, true, false, true);
        CellStyle mainHeaderCellStyle = this.getCellStyle(excelBook, true, false, false);
        CellStyle mainDataCellTextStyle = this.getCellStyle(excelBook, false, false, false);
        CellStyle mainDataCellNumberStyle = this.getCellStyle(excelBook, false, false, false, true);
        CellStyle bizHeaderCellStyle = this.getCellStyle(excelBook, true, true, false);
        CellStyle bizDataCellTextStyle = this.getCellStyle(excelBook, false, true, false);
        CellStyle bizDataCellNumberStyle = this.getCellStyle(excelBook, false, true, false, true);
        XSSFRow schemeRow = billSheet.createRow(0);
        this.createTextCell(schemeRow, 0, ResManager.loadKDString((String)"kingdee#\u9884\u7b97\u6267\u884c\u8bb0\u5f55", (String)"RelQueryExecuteRecordPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), titleStyleCellStyle);
        XSSFRow mainHeaderRow = billSheet.createRow(2);
        for (int i = 0; i < mainHeader.size(); ++i) {
            this.createTextCell(mainHeaderRow, i, mainHeader.get(i), mainHeaderCellStyle);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<Dimension> showDimensionList = this.getShowDimensionList();
        boolean isExceedMaxGroupLimit = allRowControlRecords.size() > 5000;
        int rownum = 3;
        ArrayList amountCol = Lists.newArrayList((Object[])new String[]{"e_budget", "e_occupy", "e_execute", "e_initactual", "e_budoccupy", "e_balance"});
        for (DynamicObject dynamicObject : entityList) {
            XSSFRow mainDataRow = billSheet.createRow(rownum++);
            for (int l1 = 0; l1 < mainRowProps.length; ++l1) {
                String title = mainRowProps[l1];
                if (amountCol.contains(title)) {
                    this.createNumberCell(mainDataRow, l1, dynamicObject.getString(title), mainDataCellNumberStyle);
                    continue;
                }
                this.createTextCell(mainDataRow, l1, dynamicObject.getString(title), mainDataCellTextStyle);
            }
            String dimGroupInfoJson = dynamicObject.getString("dimkeyvaluemap");
            if (StringUtils.isEmpty((CharSequence)dimGroupInfoJson)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"RelQueryExecuteRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String memberKeyByDimGroupInfo = this.getMemberKeyByDimGroupInfo((Map)SerializationUtils.fromJsonString((String)dimGroupInfoJson, Map.class), showDimensionList);
            List<BizRowDataEntity> bizRowDataEntities = allRowControlRecords.get(memberKeyByDimGroupInfo);
            if (!CollectionUtils.isNotEmpty(bizRowDataEntities)) continue;
            XSSFRow bizHeaderRow = billSheet.createRow(rownum++);
            for (int l1 = 0; l1 < bizHeader.size(); ++l1) {
                this.createTextCell(bizHeaderRow, l1, bizHeader.get(l1), bizHeaderCellStyle);
            }
            int fromGroupRow = bizHeaderRow.getRowNum();
            int toGroupRow = bizHeaderRow.getRowNum();
            for (BizRowDataEntity bizRowDataEntity : bizRowDataEntities) {
                XSSFRow bizDataRow = billSheet.createRow(rownum++);
                this.createBizRowDataCell(bizDataCellTextStyle, bizDataCellNumberStyle, bizRowDataEntity, bizDataRow, false, decimalFormat, dateFormat);
                if (bizRowDataEntity.isCollect()) {
                    List<BizRowDataEntity> detailRecord = bizRowDataEntity.getDetailRecord();
                    for (BizRowDataEntity bizRowData : detailRecord) {
                        XSSFRow detailRow = billSheet.createRow(rownum++);
                        this.createBizRowDataCell(bizDataCellTextStyle, bizDataCellNumberStyle, bizRowData, detailRow, true, decimalFormat, dateFormat);
                    }
                }
                toGroupRow = rownum - 1;
            }
            if (isExceedMaxGroupLimit) continue;
            billSheet.groupRow(fromGroupRow, toGroupRow);
        }
    }

    private void createBizRowDataCell(CellStyle bizDataCellStyle, CellStyle bizDataCellNumberStyle, BizRowDataEntity bizRowDataEntity, XSSFRow bizDataRow, boolean isCollectRow, DecimalFormat decimalFormat, DateFormat dateFormat) {
        int i1 = 0;
        this.createTextCell(bizDataRow, i1++, isCollectRow && bizRowDataEntity.getOrgunit() != null ? "      " + bizRowDataEntity.getOrgunit() : bizRowDataEntity.getOrgunit(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getAccount(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getPeriod(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getCurrency(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getBillTypeName(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getEntityNumber(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getBizId(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getBiznumber(), bizDataCellStyle);
        String[] billShowFiledValue = bizRowDataEntity.getBillShowFiledValue();
        if (billShowFiledValue != null && billShowFiledValue.length > 0) {
            for (String value : billShowFiledValue) {
                this.createTextCell(bizDataRow, i1++, value, bizDataCellStyle);
            }
        }
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getUserName(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getCreatetime() == null ? "" : dateFormat.format(bizRowDataEntity.getCreatetime()), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getOperation(), bizDataCellStyle);
        this.createTextCell(bizDataRow, i1++, bizRowDataEntity.getRelBillNumber(), bizDataCellStyle);
        this.createNumberCell(bizDataRow, i1++, bizRowDataEntity.getOccupy() == null ? "" : decimalFormat.format(bizRowDataEntity.getOccupy()), bizDataCellNumberStyle);
        this.createNumberCell(bizDataRow, i1++, bizRowDataEntity.getNwriteoff() == null ? "" : decimalFormat.format(bizRowDataEntity.getNwriteoff()), bizDataCellNumberStyle);
        this.createNumberCell(bizDataRow, i1++, bizRowDataEntity.getExecute() == null ? "" : decimalFormat.format(bizRowDataEntity.getExecute()), bizDataCellNumberStyle);
        this.createNumberCell(bizDataRow, i1, bizRowDataEntity.getNwriteexecute() == null ? "" : decimalFormat.format(bizRowDataEntity.getNwriteexecute()), bizDataCellNumberStyle);
    }

    private void createTextCell(XSSFRow xssfRow, int cellNum, String cellValue, CellStyle cellStyle) {
        XSSFCell cell = xssfRow.createCell(cellNum);
        cell.setCellValue(cellValue);
        cell.setCellStyle(cellStyle);
        cell.setCellType(CellType.STRING);
    }

    private void createNumberCell(XSSFRow xssfRow, int cellNum, String cellValue, CellStyle cellStyle) {
        XSSFCell cell = xssfRow.createCell(cellNum);
        cell.setCellValue(cellValue);
        cell.setCellStyle(cellStyle);
        cell.setCellType(CellType.STRING);
        if (cellValue != null && !"".equals(cellValue)) {
            Double value = Double.valueOf(cellValue);
            cell.setCellValue(value.doubleValue());
            cell.setCellType(CellType.NUMERIC);
        }
    }

    private CellStyle getCellStyle(XSSFWorkbook excelBook, boolean height, boolean blankBackGround, boolean isTitle, Boolean isNumberic) {
        CellStyle cellStyle = this.getCellStyle(excelBook, height, blankBackGround, isTitle);
        if (isNumberic.booleanValue()) {
            XSSFCreationHelper creationHelper = excelBook.getCreationHelper();
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("#,##0.00"));
        }
        return cellStyle;
    }

    private CellStyle getCellStyle(XSSFWorkbook excelBook, boolean height, boolean blankBackGround, boolean isTitle) {
        XSSFCellStyle cellStyle = excelBook.createCellStyle();
        XSSFFont font = excelBook.createFont();
        font.setBold(height);
        cellStyle.setFont((Font)font);
        if (blankBackGround) {
            cellStyle.setFillForegroundColor(new XSSFColor(new Color(240, 240, 240), (IndexedColorMap)new DefaultIndexedColorMap()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (isTitle) {
            cellStyle.setFillForegroundColor(new XSSFColor(new Color(0, 176, 240), (IndexedColorMap)new DefaultIndexedColorMap()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntity(XSSFWorkbook excelBook) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            try {
                excelBook.write((OutputStream)outStream);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            try {
                outStream.flush();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ResManager.loadKDString((String)"\u8054\u67e5\u6267\u884c\u8bb0\u5f55.xlsx", (String)"RelQueryExecuteRecordPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), (InputStream)inStream, 10000);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }

    public Long getDataSetId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("dataset"));
    }

    public Long getBizModelId() {
        return this.getIModelCacheHelper().getBusModelByDataSet(this.getDataSetId());
    }

    private Map<String, List<Long>> getDimKeyValueMap() {
        String cacheDimKeyValueMap = this.getPageCache().get(CACHE_DIMKEYVALUEMAP);
        Object customParam = this.getView().getFormShowParameter().getCustomParam(CACHE_DIMKEYVALUEMAP);
        if (cacheDimKeyValueMap != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cacheDimKeyValueMap);
        }
        if (customParam != null) {
            this.getPageCache().put(CACHE_DIMKEYVALUEMAP, (String)customParam);
            return (Map)SerializationUtils.deSerializeFromBase64((String)((String)customParam));
        }
        return new HashMap<String, List<Long>>();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs filterContainerSearchClickArgs) {
        super.filterContainerSearchClick(filterContainerSearchClickArgs);
    }

    public void search(SearchEvent event) {
        this.setNeedLoadMore(false);
        this.searchData(false);
    }

    private void searchData(Boolean isNeedLoadMore) {
        Map<String, List<String>> queryParam = this.getReportFilterApDimParams();
        if (this.isWholeDimInfo(queryParam)) {
            this.getModel().deleteEntryData(MIAN_ENTRYENTITY);
            this.getModel().deleteEntryData(BIZ_ENTRYENTITY);
            this.removeRelPageCache();
            this.initMainEntryData(queryParam, isNeedLoadMore);
        }
    }

    private void removeRelPageCache() {
        this.getPageCache().remove(CACHE_ALL_ROWCONTROLRECORDS);
        this.getPageCache().remove(CACHE_RELBILL_CONTROLRECORDS);
    }

    private boolean isWholeDimInfo(Map<String, List<String>> queryParam) {
        boolean isWholeDimInfo = queryParam.size() != 0;
        for (Map.Entry<String, List<String>> entry : queryParam.entrySet()) {
            List<String> value = entry.getValue();
            String dimNumber = entry.getKey();
            if (CollectionUtils.isEmpty(value)) {
                isWholeDimInfo = false;
                break;
            }
            if (!value.contains(dimNumber) || !SysDimensionEnum.include((String)dimNumber, (Boolean)true)) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"RelQueryExecuteRecordPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{entry.getKey()}));
            return false;
        }
        if (!isWholeDimInfo) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u7ef4\u5ea6\u7b5b\u9009\u6761\u4ef6\u3002", (String)"RelQueryExecuteRecordPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.setCollapse(isWholeDimInfo);
        return isWholeDimInfo;
    }

    private Map<String, List<String>> getReportFilterApDimParams() {
        HashMap<String, List<String>> queryInfo = new HashMap<String, List<String>>(16);
        Set<String> dimNums = this.getShowDimensionNums();
        Map<String, String> customDimKeyMap = this.getCustomDimKeyMap();
        for (String dimNumber : dimNums) {
            DynamicObjectCollection dimMembers;
            String controlKey = dimNumber.toLowerCase();
            if (!SysDimensionEnum.include((String)dimNumber, (Boolean)true)) {
                controlKey = customDimKeyMap.get(dimNumber);
            }
            Object dimMemDy = this.getModel().getValue(controlKey);
            List<String> dimMemberNums = new ArrayList<String>();
            if (dimMemDy instanceof DynamicObjectCollection) {
                dimMembers = (DynamicObjectCollection)dimMemDy;
                dimMemberNums = dimMembers.stream().map(e -> e.getString("fbasedataid.number")).collect(Collectors.toList());
            } else if (dimMemDy instanceof DynamicObject) {
                dimMembers = (DynamicObject)dimMemDy;
                dimMemberNums.add(dimMembers.getString("number"));
            }
            queryInfo.put(dimNumber, dimMemberNums);
        }
        return queryInfo;
    }

    /*
     * WARNING - void declaration
     */
    private List<RowDataEntity> getMainRowDataEntities(Map<String, List<String>> queryParam, List<Map<String, String>> controlMembers, Boolean isNeedLoadMore) {
        Object value;
        ArrayList<RowDataEntity> rowDataEntities = new ArrayList<RowDataEntity>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map<String, Long> viewMap = this.getViewsMap(modelCacheHelper, this.getBizModelId());
        Set<String> initActualNums = this.getInitActualNumbers(modelCacheHelper, viewMap.get("ChangeType"));
        String[] dimensionNums = modelCacheHelper.getDimensionNums(this.getDataSetId());
        boolean isExceedMaxLimit = false;
        boolean isExceedInitLimit = false;
        this.addOtherParams(queryParam);
        List<BGCell> cells = this.getOlapData(queryParam);
        HashMap<String, BigDecimal> memNumbersToValue = new HashMap<String, BigDecimal>(16);
        for (BGCell cell : cells) {
            Map memberMap = cell.getMemberMap();
            value = cell.getValue();
            if (value == null) continue;
            ArrayList dimMemNums = new ArrayList(dimensionNums.length);
            for (String string : dimensionNums) {
                dimMemNums.add(memberMap.get(string));
            }
            memNumbersToValue.put(StringUtils.join((Object[])dimMemNums.toArray(), (String)"_"), ConvertUtils.toDecimal((Object)value));
        }
        HashMap<String, RowDataEntity> rowDimGroupKeysMap = new HashMap<String, RowDataEntity>(16);
        for (BGCell cell : cells) {
            void var21_29;
            BigDecimal bigDecimal;
            value = cell.getValue();
            if (value == null) continue;
            Map memberMap = cell.getMemberMap();
            String rowDimGroupKey = this.getRowDimGroupKey(dimensionNums, memberMap);
            HashMap<String, String> srcMemberMap = new HashMap<String, String>(16);
            ArrayList<String> srcMembers = new ArrayList<String>(16);
            for (String srcDimNumber : dimensionNums) {
                String srcMemberNumber = (String)memberMap.get(srcDimNumber);
                srcMemberMap.put(srcDimNumber, srcMemberNumber);
                srcMembers.add(srcMemberNumber);
            }
            RowDataEntity rowDataEntity = (RowDataEntity)rowDimGroupKeysMap.get(rowDimGroupKey);
            if (rowDataEntity == null) {
                if (rowDataEntities.size() >= 10000 && !isNeedLoadMore.booleanValue()) {
                    isExceedInitLimit = true;
                    this.setNeedLoadMore(true);
                    continue;
                }
                if (rowDataEntities.size() >= 100000) {
                    isExceedMaxLimit = true;
                    continue;
                }
                RowDataEntity rowDataEntity2 = new RowDataEntity();
                rowDataEntities.add(rowDataEntity2);
                rowDimGroupKeysMap.put(rowDimGroupKey, rowDataEntity2);
                HashMap<String, String> baseSrcMemberMap = new HashMap<String, String>(16);
                baseSrcMemberMap.putAll(srcMemberMap);
                controlMembers.add(baseSrcMemberMap);
                rowDataEntity2.setDimMemberValueMap(baseSrcMemberMap);
                baseSrcMemberMap.put("Version", queryParam.get("Version").get(0));
                baseSrcMemberMap.put("AuditTrail", queryParam.get("AuditTrail").get(0));
                baseSrcMemberMap.put("ChangeType", queryParam.get("ChangeType").get(0));
                baseSrcMemberMap.put("DataType", queryParam.get("DataType").get(0));
            }
            if ((bigDecimal = (BigDecimal)memNumbersToValue.get(StringUtils.join((Object[])srcMembers.toArray(), (String)"_"))) == null) continue;
            boolean initActual = this.isInitActual(srcMemberMap, initActualNums);
            if (this.isOccupyNumber(srcMemberMap)) {
                var21_29.setOccupy(bigDecimal);
            } else if (this.isExcuteNumber(srcMemberMap)) {
                var21_29.setExecute(bigDecimal);
            } else if (initActual) {
                var21_29.setInitActual(bigDecimal);
            } else if (this.isBudOccupy(srcMemberMap)) {
                var21_29.setBudOccupy(bigDecimal.abs());
            }
            if (!this.isBudget(var21_29.getDimMemberValueMap(), srcMemberMap) || initActual) continue;
            var21_29.setBudget(ConvertUtils.toDecimal((Object)value));
        }
        this.sortMainDataEntities(rowDataEntities);
        if (isExceedMaxLimit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5c55\u793a10\u4e07\u884c\u6570\u636e\u3002", (String)"RelQueryExecuteRecordPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (isExceedInitLimit) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u52a0\u8f7d\u884c\u6570\u8d85\u8fc7\u6700\u5927\u52a0\u8f7d\u884c\u6570%1\uff0c\u8bf7\u4f7f\u7528\u201c\u663e\u793a\u66f4\u591a\u201d\u67e5\u770b\u66f4\u591a\u4fe1\u606f\u3002", (String)"RelQueryExecuteRecordPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{10000}));
        }
        return rowDataEntities;
    }

    private Set<String> getInitActualNumbers(IModelCacheHelper modelCacheHelper, Long viewId) {
        List cTMembers = modelCacheHelper.getMember("ChangeType", viewId, "ActualChanges", RangeEnum.ALL.getIndex());
        if (CollectionUtils.isNotEmpty((Collection)cTMembers)) {
            return cTMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    private String getRowDimGroupKey(String[] dimensionNums, Map<String, String> memberMap) {
        ArrayList<String> rowDimGroupKey = new ArrayList<String>();
        for (String srcDimNumber : dimensionNums) {
            if ("Version".equals(srcDimNumber) || "DataType".equals(srcDimNumber) || "AuditTrail".equals(srcDimNumber) || "ChangeType".equals(srcDimNumber)) continue;
            rowDimGroupKey.add(memberMap.get(srcDimNumber));
        }
        return String.join((CharSequence)"_", rowDimGroupKey);
    }

    private void sortMainDataEntities(List<RowDataEntity> rowDataEntities) {
        final Map<String, String> f7ControlDimNumber = this.getF7ControlDimNumber();
        rowDataEntities.sort(new Comparator<RowDataEntity>(){

            @Override
            public int compare(RowDataEntity o1, RowDataEntity o2) {
                int seq = -1;
                Map<String, String> dimMemberValueMap1 = o1.getDimMemberValueMap();
                Map<String, String> dimMemberValueMap2 = o2.getDimMemberValueMap();
                for (String key : sortWayList) {
                    String dimMem2;
                    String dimMem1;
                    String dimNumber = (String)f7ControlDimNumber.get(key);
                    if (dimNumber == null || (dimMem1 = dimMemberValueMap1.get(dimNumber)).compareToIgnoreCase(dimMem2 = dimMemberValueMap2.get(dimNumber)) == 0) continue;
                    seq = dimMem1.compareToIgnoreCase(dimMem2);
                    break;
                }
                return seq;
            }
        });
    }

    private boolean isOccupyNumber(Map<String, String> srcMemberMap) {
        return "Occupation".equals(srcMemberMap.get(SysDimensionEnum.ChangeType.getNumber())) && "EntityInput".equals(srcMemberMap.get(SysDimensionEnum.AuditTrail.getNumber())) && "Actual".equals(srcMemberMap.get(SysDimensionEnum.DataType.getNumber())) && "ACTUAL".equals(srcMemberMap.get(SysDimensionEnum.Version.getNumber()));
    }

    private boolean isExcuteNumber(Map<String, String> srcMemberMap) {
        return "Execute".equals(srcMemberMap.get(SysDimensionEnum.ChangeType.getNumber())) && "EntityInput".equals(srcMemberMap.get(SysDimensionEnum.AuditTrail.getNumber())) && "Actual".equals(srcMemberMap.get(SysDimensionEnum.DataType.getNumber())) && "ACTUAL".equals(srcMemberMap.get(SysDimensionEnum.Version.getNumber()));
    }

    private boolean isInitActual(Map<String, String> srcMemberMap, Set<String> initActualNums) {
        return initActualNums.contains(srcMemberMap.get(SysDimensionEnum.ChangeType.getNumber())) && "EntityInput".equals(srcMemberMap.get(SysDimensionEnum.AuditTrail.getNumber())) && "Actual".equals(srcMemberMap.get(SysDimensionEnum.DataType.getNumber())) && "ACTUAL".equals(srcMemberMap.get(SysDimensionEnum.Version.getNumber()));
    }

    private boolean isBudOccupy(Map<String, String> srcMemberMap) {
        return "BudgetOccupation".equals(srcMemberMap.get(SysDimensionEnum.AuditTrail.getNumber()));
    }

    private boolean isBudget(Map<String, String> dimMemberValueMap, Map<String, String> srcMemberMap) {
        for (Map.Entry<String, String> entry : dimMemberValueMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (srcMemberMap.get(key).equals(value)) continue;
            return false;
        }
        return true;
    }

    private BigDecimal getDataValue(String[] dimensionNums, Map<String, String> srcMemberMap, Map<String, BigDecimal> memNumbersToValue, AnalysePreColType colType) {
        Map<String, String> memberParam = this.replaceMemberParam(srcMemberMap, colType);
        ArrayList<String> memNumbers = new ArrayList<String>(16);
        for (String dimNum : dimensionNums) {
            String memberNumber = memberParam.get(dimNum);
            memNumbers.add(memberNumber);
        }
        BigDecimal bigDecimal = memNumbersToValue.get(StringUtils.join((Object[])memNumbers.toArray(), (String)"_"));
        return bigDecimal != null ? bigDecimal : new BigDecimal(0);
    }

    private Map<String, String> replaceMemberParam(Map<String, String> srcMemberParam, AnalysePreColType NumberType) {
        HashMap<String, String> targetMemberParam = new HashMap<String, String>(16);
        targetMemberParam.putAll(srcMemberParam);
        switch (NumberType) {
            case OCCUPY: {
                targetMemberParam.put(SysDimensionEnum.ChangeType.getNumber(), "Occupation");
                targetMemberParam.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                targetMemberParam.put(SysDimensionEnum.DataType.getNumber(), "Actual");
                targetMemberParam.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
                break;
            }
            case EXECUTE: {
                targetMemberParam.put(SysDimensionEnum.ChangeType.getNumber(), "Execute");
                targetMemberParam.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                targetMemberParam.put(SysDimensionEnum.DataType.getNumber(), "Actual");
                targetMemberParam.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
                break;
            }
            case INIT_ACTUAL: {
                targetMemberParam.put(SysDimensionEnum.ChangeType.getNumber(), "ActualChanges");
                targetMemberParam.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                targetMemberParam.put(SysDimensionEnum.DataType.getNumber(), "Actual");
                targetMemberParam.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
                break;
            }
            case BUD_OCCUPY: {
                targetMemberParam.put(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation");
                break;
            }
        }
        return targetMemberParam;
    }

    private List<BGCell> getOlapData(Map<String, List<String>> currentQueryParam) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Long bizModel = modelCacheHelper.getBusModelByDataSet(this.getDataSetId());
        Map<String, Long> viewsByBusModel = this.getViewsMap(modelCacheHelper, bizModel);
        HashMap<String, Set<String>> queryInfo = new HashMap<String, Set<String>>(16);
        List dimensionList = this.getModelCacheHelper().getDimensionList(this.getDataSetId());
        for (Dimension dimension : dimensionList) {
            Set permMembNumbers;
            String dimNumber = dimension.getNumber();
            Long viewId = viewsByBusModel.get(dimNumber);
            List<String> memNumbers = currentQueryParam.get(dimNumber);
            if (memNumbers == null) {
                String defaultMember = SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber) ? dimension.getNoneNumber() : dimNumber;
                queryInfo.put(dimNumber, Collections.singleton(defaultMember));
                continue;
            }
            if (notNeedFindLeafDim.contains(dimNumber)) {
                queryInfo.put(dimNumber, new HashSet<String>(memNumbers));
                continue;
            }
            ArrayList allLeafMemberNumbers = new ArrayList();
            memNumbers.forEach(memNumber -> {
                List leafMembers = modelCacheHelper.getMember(dimNumber, viewId, memNumber, 90);
                if (CollectionUtils.isNotEmpty((Collection)leafMembers)) {
                    leafMembers.forEach(leafMember -> allLeafMemberNumbers.add(leafMember.getNumber()));
                }
            });
            if (CollectionUtils.isNotEmpty(allLeafMemberNumbers)) {
                queryInfo.put(dimNumber, new HashSet(allLeafMemberNumbers));
            }
            if ((permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)dimNumber, (Long)modelId, (Long)bizModel, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true)) != null) {
                allLeafMemberNumbers.retainAll(permMembNumbers);
            }
            if (!allLeafMemberNumbers.isEmpty()) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u7ef4\u5ea6\u7f3a\u5c11\u6709\u6548\u7684\u660e\u7ec6\u7ef4\u5ea6\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"RelQueryExecuteRecordPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
        }
        List cells = OlapCommService.getInstance().queryList(new QueryRequest(this.getModelId(), this.getDataSetId(), queryInfo));
        return cells;
    }

    private void addOtherParams(Map<String, List<String>> currentQueryParam) {
        List changeTypeParams = currentQueryParam.computeIfAbsent(SysDimensionEnum.ChangeType.getNumber(), e -> new ArrayList());
        changeTypeParams.add("Occupation");
        changeTypeParams.add("Execute");
        changeTypeParams.add("ActualChanges");
        List audittrialParams = currentQueryParam.computeIfAbsent(SysDimensionEnum.AuditTrail.getNumber(), e -> new ArrayList());
        audittrialParams.add("EntityInput");
        audittrialParams.add("BudgetOccupation");
        List datatypeParams = currentQueryParam.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), e -> new ArrayList());
        datatypeParams.add("Actual");
        List versionParams = currentQueryParam.computeIfAbsent(SysDimensionEnum.Version.getNumber(), e -> new ArrayList());
        versionParams.add("ACTUAL");
    }

    private void cacheDimKeyToMap(FormShowParameter formShowParameter, Map<String, Map<String, String>> dimKeyMap) {
        formShowParameter.setCustomParam("dimKeyMap", (Object)SerializationUtils.toJsonString(dimKeyMap));
    }

    private IModelCacheHelper getModelCacheHelper() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    private Boolean isNeedLoadMore() {
        return "1".equals(this.getPageCache().get(NEED_LOAD_MORE_DATA));
    }

    private void setNeedLoadMore(Boolean isNeedLoadMore) {
        this.getPageCache().put(NEED_LOAD_MORE_DATA, isNeedLoadMore != false ? "1" : "0");
    }

    protected boolean isNeedCombineDetailRow() {
        return (Boolean)this.getModel().getValue("isNeedCombineDetailRow");
    }

    @Override
    public String getBizAppId() {
        String bizAppId = super.getBizAppId();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null || ApplicationTypeEnum.BGRP.getAppnum().equals(bizAppId)) {
            return bizAppId;
        }
        String entityId = parentView.getEntityId();
        if (this.isNewEbForm() || entityId.endsWith("_nbg")) {
            return ApplicationTypeEnum.BG.getAppnum();
        }
        return ApplicationTypeEnum.BGM.getAppnum();
    }

    public String getAppIdFromMsgCentral(String appId, Long modelId) {
        return this.getAppIdFromMsgCentral4BGRP(appId, modelId);
    }

    public String appendDiffMember(String source, String current) {
        String[] split;
        if (source == null) {
            return current;
        }
        if (!source.contains(";")) {
            if (source.equals(current)) {
                return source;
            }
            return source + ";" + current;
        }
        for (String s : split = source.split(";")) {
            if (!s.equals(current)) continue;
            return source;
        }
        return source + ";" + current;
    }

    private boolean isFromReport() {
        return "true".equals(this.getCustomFormParam("isFromReport"));
    }
}

