/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.fieldselect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.StringUtils;
import kd.epm.eb.business.controlprocess.ControlProcessParasUtil;
import kd.epm.eb.business.controlprocess.ParaInfo;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.SimpleObject;

public class FileldSelectPlugin
extends AbstractFormPlugin {
    private static final String DATAKEY = "values";
    private static final String ENTRYKEY = "entryentity";
    private static final String OnlyOne = "onlyOne";
    private static final String SPLIT_CN = "\uff0c";
    private static final String SPLIT_EN = ",";
    private ControlProcessInfo info;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"button_close", "button_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        String clickkey;
        BillFieldTypeEmum billfieldtype;
        String entryfocusname;
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        Long entryfocusid = Long.valueOf(pageCache.get("entryfocusid"));
        List<ParaInfo> bizregs = this.getOneRegBills(entryfocusid, entryfocusname = pageCache.get("entryfocusname"), billfieldtype = this.getType(clickkey = (String)this.getView().getFormShowParameter().getCustomParam("clickkey")));
        if (bizregs == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u65e0\u53ef\u9009\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u201c%1\u201d\u5355\u636e\u7684\u63a7\u5236\u5b57\u6bb5\u6ce8\u518c\u3002", (String)"FileldSelectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{entryfocusname}));
        }
        this.getModel().deleteEntryData(ENTRYKEY);
        if (bizregs != null && !bizregs.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYKEY, bizregs.size());
            for (int i = 0; i < bizregs.size(); ++i) {
                ParaInfo paraInfo = bizregs.get(i);
                DynamicObject rowobj = (DynamicObject)this.getModel().getEntryEntity(ENTRYKEY).get(i);
                rowobj.set("name", (Object)paraInfo.getName());
                rowobj.set("number", (Object)paraInfo.getNumber());
                rowobj.set("fieldtype", (Object)paraInfo.getType());
                rowobj.set("id", (Object)paraInfo.getFid());
            }
        }
        this.getView().updateView(ENTRYKEY);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYKEY);
        String clickkey = (String)this.getView().getFormShowParameter().getCustomParam("clickkey");
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        Long entryfocusid = Long.valueOf(pageCache.get("entryfocusid"));
        String entryfocusname = pageCache.get("entryfocusname");
        BillFieldTypeEmum billfieldtype = this.getType(clickkey);
        List<ParaInfo> bizregs = this.getOneRegBills(entryfocusid, entryfocusname, billfieldtype);
        if (bizregs != null && bizregs.size() > 0) {
            String clickObjectStr;
            String replace;
            Object clickObject = this.getView().getFormShowParameter().getCustomParam(clickkey + "!number");
            boolean isNumber = true;
            if (clickObject == null) {
                clickObject = this.getView().getFormShowParameter().getCustomParam(clickkey);
                isNumber = false;
            }
            if (clickObject != null && !StringUtils.isEmpty((Object)(replace = (clickObjectStr = clickObject.toString()).replace(SPLIT_CN, SPLIT_EN)))) {
                String[] split = replace.trim().split(SPLIT_EN);
                int[] ints = new int[split.length];
                for (int i = 0; i < bizregs.size(); ++i) {
                    ParaInfo paraInfo = bizregs.get(i);
                    for (int k = 0; k < split.length; ++k) {
                        String name = paraInfo.getName();
                        if (isNumber) {
                            name = paraInfo.getNumber();
                        }
                        if (!split[k].equals(name)) continue;
                        ints[k] = i;
                    }
                }
                entryGrid.selectRows(ints, 0);
            }
        }
    }

    private List<ParaInfo> getOneRegBills(Long billid, String entryfocusname, BillFieldTypeEmum billfield) {
        Map regbills = ControlProcessParasUtil.getRegBillsFromCache((IPageCache)this.getPageCache());
        if (regbills.size() == 0 || regbills.get(billid) == null) {
            return null;
        }
        return (List)((Map)regbills.get(billid)).get(billfield.getNumber());
    }

    private BillFieldTypeEmum getType(String key) {
        switch (key) {
            case "takeoperation": {
                return BillFieldTypeEmum.TAKEOPERATION;
            }
            case "runoperation": {
                return BillFieldTypeEmum.RUNOPERATION;
            }
            case "returnoperation": {
                return BillFieldTypeEmum.RETURNOPERATION;
            }
            case "clearoperation": {
                return BillFieldTypeEmum.CLEAROPERATION;
            }
            case "writeoffsourcebill": 
            case "writeoffentry": 
            case "writeoffvalue": 
            case "writeoffsourcebillentry": {
                return BillFieldTypeEmum.WRITEOFFFIELD;
            }
        }
        return BillFieldTypeEmum.CONTROLVALUE;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("button_ok".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYKEY);
            int[] rows = entry.getSelectRows();
            if ("true".equals(this.getView().getFormShowParameter().getCustomParam(OnlyOne)) && rows.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"FileldSelectPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            int index = this.getClickRow();
            String clickkey = (String)this.getView().getFormShowParameter().getCustomParam("clickkey");
            ArrayList<SimpleObject> valueList = new ArrayList<SimpleObject>(16);
            DynamicObjectCollection rowobjs = this.getModel().getEntryEntity(ENTRYKEY);
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                String name = ((DynamicObject)rowobjs.get(row)).getString("name");
                String number = ((DynamicObject)rowobjs.get(row)).getString("number");
                String fid = ((DynamicObject)rowobjs.get(row)).getString("id");
                SimpleObject simpleObject = new SimpleObject(Long.parseLong(fid), name, number);
                valueList.add(simpleObject);
            }
            HashMap<String, Object> returnvalue = new HashMap<String, Object>(16);
            returnvalue.put("clickkey", clickkey);
            returnvalue.put("clickrow", index);
            if (!Arrays.asList("writeoffsourcebill", "writeoffentry", "writeoffvalue", "writeoffsourcebillentry").contains(clickkey)) {
                this.info = this.getInfo();
                this.info.updateRowInfo(index, clickkey, valueList);
                this.cacheInfo();
            } else {
                returnvalue.put("value", valueList);
            }
            this.getView().returnDataToParent(returnvalue);
            this.getView().getParentView().setReturnData(returnvalue);
            this.getView().close();
        }
    }

    public ControlProcessInfo getInfo() {
        if (this.info == null) {
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            String s = pageCache.get("controlprocessinfo");
            this.info = (ControlProcessInfo)SerializationUtils.deSerializeFromBase64((String)s);
        }
        return this.info;
    }

    public void cacheInfo() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("controlprocessinfo", SerializationUtils.serializeToBase64((Object)this.info));
    }

    public int getClickRow() {
        return (Integer)this.getView().getFormShowParameter().getCustomParam("clickrow");
    }
}

