/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.IconEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.forecast.helper.ForecastPanelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.DimensionItem;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ForecastConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String DIM_POOL = "dimpool";
    private static final String ALL_DIM = "all_dim";
    private static final String PREFIX_CUSTOM_ITEM = "cus_item_";
    private static final String VECTOR_SUFFIX = "vector_";
    private static final String FLEX_SUFFIX = "_pool";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long modelId = IDUtils.toLong((Object)formShowParameter.getCustomParam("model"));
        long bizModelId = IDUtils.toLong((Object)formShowParameter.getCustomParam("bizmodel"));
        long datasetId = IDUtils.toLong((Object)formShowParameter.getCustomParam("dataset"));
        String dimNumJson = (String)formShowParameter.getCustomParam("dim_member");
        String dimViewJson = (String)formShowParameter.getCustomParam("dim_view");
        this.getPageCache().put("model", String.valueOf(modelId));
        this.getPageCache().put("bizmodel", String.valueOf(bizModelId));
        this.getPageCache().put("dataset", String.valueOf(datasetId));
        this.getPageCache().put("dim_member", dimNumJson);
        this.getPageCache().put("dim_view", dimViewJson);
        this.initDimPool();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        if (this.isCustomItem(propName)) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            DimensionItem dimItem = this.findItemByKey(propName);
            if (dimItem != null) {
                String dimNumber = dimItem.getNumber();
                String bizModelId = this.getPageCache().get("bizmodel");
                Long modelId = this.getModelId();
                Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
                long viewId = this.getViewId(dimNumber);
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
                f7Param.setBusModelId(IDUtils.toLong((Object)bizModelId));
                f7Param.setDatasetId(dataSetId);
                f7Param.setEnableView(false);
                f7Param.setViewId(Long.valueOf(viewId));
                f7Param.setReturnAllData(true);
                f7Param.setCutTree(false);
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
            }
            e.addCustomQFilter(qFilter);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        DimensionItem dimItem = this.findItemByKey(controlKey);
        return dimItem.getNumber();
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            this.getView().returnDataToParent(this.getAllDimNum());
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            this.getView().close();
        } else if (this.isVectorKey(ctrlKey)) {
            boolean lock = Boolean.parseBoolean(this.getPageCache().get(ctrlKey));
            if (lock) {
                this.isLock(ctrlKey, true);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6837\u672c\u6570\u636e\u6765\u6e90\u5c06\u5bf9\u9884\u6d4b\u7ed3\u679c\u4ea7\u751f\u5f71\u54cd\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"ForecastConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ctrlKey, (IFormPlugin)this));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (this.isCustomItem(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DimensionItem dimItem = this.findItemByKey(key);
            if (dimItem == null || newVal == null) {
                return;
            }
            this.cacheDimNum(dimItem.getNumber(), newVal.getString("number"));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection members;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (this.isCustomItem(actionId) && evt.getReturnData() != null && evt.getReturnData() instanceof ListSelectedRowCollection && CollectionUtils.isNotEmpty((Collection)(members = (ListSelectedRowCollection)evt.getReturnData()))) {
            ListSelectedRow member = members.get(0);
            String dimNumber = String.valueOf(member.getDataMap().get("dimNumber"));
            String memberNumber = member.getNumber();
            this.cacheDimNum(dimNumber, memberNumber);
            this.getModel().setValue(actionId, member.getPrimaryKeyValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if (this.isVectorKey(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.isLock(key, false);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (this.isCustomItem(ctrlKey)) {
            DimensionItem dimItem = this.findItemByKey(ctrlKey);
            if (dimItem == null) {
                return;
            }
            BasedataEdit edit = ForecastPanelHelper.createBaseDataCtl(ctrlKey, this.getModel(), this.getView());
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            e.setControl((Control)edit);
        } else if (this.isVectorKey(ctrlKey)) {
            IconEdit edit = new IconEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        List<DimensionItem> dimItems = this.getAllDimension();
        if (dimItems == null) {
            return;
        }
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        for (DimensionItem item : dimItems) {
            String fieldKey = item.getFieldKey();
            String baseDataEntity = item.getMemberModel();
            ForecastPanelHelper.registerComplexProp((EntityType)mainEntityType, fieldKey, baseDataEntity);
        }
    }

    private boolean isCustomItem(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return controlKey.startsWith(PREFIX_CUSTOM_ITEM) && !controlKey.endsWith("_id");
    }

    private boolean isVectorKey(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return controlKey.startsWith(VECTOR_SUFFIX);
    }

    private void initDimPool() {
        this.initDimPanel();
        this.registerDynamicProps(null);
        this.setDefaultValue();
    }

    private void initDimPanel() {
        FlexPanelAp flexPanelAp = ForecastPanelHelper.createFlexPanel(DIM_POOL);
        List<DimensionItem> allDims = this.getAllDimension();
        Optional<DimensionItem> account = allDims.stream().filter(dim -> SysDimensionEnum.Account.getNumber().equals(dim.getNumber())).findFirst();
        account.ifPresent(dimensionItem -> this.initFlexPanel(flexPanelAp, (DimensionItem)dimensionItem));
        for (DimensionItem item : allDims) {
            if (SysDimensionEnum.Account.getNumber().equals(item.getNumber())) continue;
            this.initFlexPanel(flexPanelAp, item);
        }
        ForecastPanelHelper.updateControlMetadata(this.getView(), DIM_POOL, flexPanelAp.createControl());
    }

    private void initFlexPanel(FlexPanelAp flexPanelAp, DimensionItem item) {
        boolean isLock;
        String number = item.getNumber();
        FlexPanelAp dimFlexPanelAp = ForecastPanelHelper.createFlexPanel1(number.toLowerCase() + FLEX_SUFFIX);
        String fieldKey = item.getFieldKey();
        FieldAp fieldAp = ForecastPanelHelper.createBaseDataFieldAp(dimFlexPanelAp, fieldKey, item.getName(), item.getMemberModel());
        if (SysDimensionEnum.DataType.getNumber().equals(number) || SysDimensionEnum.Version.getNumber().equals(number)) {
            this.setTips(fieldAp);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{fieldKey});
        boolean bl = isLock = SysDimensionEnum.Entity.getNumber().equals(number) || this.isUserDefineDimension(number);
        if (isLock) {
            ForecastPanelHelper.createVectorFieldAp(dimFlexPanelAp, VECTOR_SUFFIX + number.toLowerCase());
        }
        flexPanelAp.getItems().add(dimFlexPanelAp);
    }

    private void setDefaultValue() {
        Map<String, String> allDimNum = this.getAllDimNum();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List<DimensionItem> allDimension = this.getAllDimension();
        for (DimensionItem d : allDimension) {
            String fieldKey = d.getFieldKey();
            String dimNumber = d.getNumber();
            Member member = modelCache.getMember(dimNumber, Long.valueOf(this.getViewId(dimNumber)), allDimNum.get(dimNumber));
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u7684\u6210\u5458%2\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002", (String)"ForecastConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, allDimNum.get(dimNumber)}));
            }
            this.getModel().setValue(fieldKey, (Object)member.getId());
            this.getView().updateView(fieldKey);
        }
    }

    private void setTips(FieldAp fieldAp) {
        Tips ctlTips = new Tips();
        ctlTips.setType("text");
        ctlTips.setTriggerType("hover");
        ctlTips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5982\u6709\u9700\u8981\uff0c\u8bf7\u5728\u667a\u80fd\u9884\u6d4b->\u9ed8\u8ba4\u8bbe\u7f6e\u4e2d\u4fee\u6539\u3002", (String)"ForecastConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        ctlTips.setLink(false);
        fieldAp.setCtlTips(ctlTips);
    }

    private long getViewId(String dimNumber) {
        Map<String, Long> viewMap = this.getViewMap();
        Long viewId = viewMap.get(dimNumber);
        if (viewId == null) {
            viewId = 0L;
        }
        return viewId;
    }

    private Map<String, Long> getViewMap() {
        String dimViewStr = this.getPageCache().get("dim_view");
        if (StringUtils.isEmpty((CharSequence)dimViewStr)) {
            return Collections.emptyMap();
        }
        JSONObject dimView = JSON.parseObject((String)dimViewStr);
        return dimView.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> IDUtils.toLong(v.getValue())));
    }

    private DimensionItem findItemByKey(String key) {
        List<DimensionItem> allDimension = this.getAllDimension();
        Optional<DimensionItem> optional = allDimension.stream().filter(d -> d.getFieldKey().equals(key)).findFirst();
        return optional.orElse(null);
    }

    private DimensionItem findItemByDimNumber(String dimNumber) {
        List<DimensionItem> allDimension = this.getAllDimension();
        Optional<DimensionItem> optional = allDimension.stream().filter(d -> d.getNumber().equalsIgnoreCase(dimNumber)).findFirst();
        return optional.orElse(null);
    }

    private List<DimensionItem> getAllDimension() {
        String allDim = this.getPageCache().get(ALL_DIM);
        if (StringUtils.isEmpty((CharSequence)allDim)) {
            return this.loadAllDim();
        }
        return JSON.parseArray((String)this.getPageCache().get(ALL_DIM), DimensionItem.class);
    }

    private List<DimensionItem> loadAllDim() {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            return Collections.emptyList();
        }
        Long dataSetId = this.getDataSetId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        ArrayList<DimensionItem> itemList = new ArrayList<DimensionItem>(dimensionList.size());
        for (Dimension d : dimensionList) {
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(d.getNumber())) continue;
            DimensionItem dimensionItem = new DimensionItem(d.getId(), d.getName(), d.getNumber(), d.getMemberModel(), d.getSeq(), DIM_POOL);
            itemList.add(dimensionItem);
        }
        this.getPageCache().put(ALL_DIM, JSON.toJSONString(itemList));
        return itemList;
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("model"));
    }

    private Long getDataSetId() {
        return IDUtils.toLong((Object)this.getPageCache().get("dataset"));
    }

    private Map<String, String> getAllDimNum() {
        return (Map)JSON.parseObject((String)this.getPageCache().get("dim_member"), Map.class);
    }

    private void cacheDimNum(String dimNumber, String memberNumber) {
        Map<String, String> allDimNum = this.getAllDimNum();
        allDimNum.put(dimNumber, memberNumber);
        this.getPageCache().put("dim_member", JSON.toJSONString(allDimNum));
    }

    private boolean isUserDefineDimension(String dimNumber) {
        return "epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
    }

    private void isLock(String ctrlKey, boolean lock) {
        VectorAp vectorFieldAp = ForecastPanelHelper.createVectorFieldAp(ctrlKey, lock ? "kdfont kdfont-suoding5" : "kdfont kdfont-jiesuo3");
        DimensionItem item = this.findItemByDimNumber(ctrlKey.replace(VECTOR_SUFFIX, ""));
        if (item != null) {
            this.getView().setEnable(Boolean.valueOf(!lock), new String[]{item.getFieldKey()});
        }
        this.getPageCache().put(ctrlKey, String.valueOf(!lock));
        this.getView().updateControlMetadata(ctrlKey, vectorFieldAp.createControl());
    }
}

