/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.forecast.gpt.GptForecast;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.analysiscanvas.constant.PropsDataType;
import kd.epm.eb.formplugin.analysiscanvas.model.PropsData;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GptForecastResultPlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(GptForecastResultPlugin.class);

    public void afterCreateNewData(EventObject e) {
        String action;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        log.info("customParams:{}", (Object)customParams);
        String pkId = customParams.get("pkId").toString();
        String attr = (String)CacheServiceHelper.get((String)("gptParamCache:" + pkId), String.class);
        log.info("attrParam:{}", (Object)attr);
        this.getPageCache().put("req_param", attr);
        JSONObject paramObj = JSON.parseObject((String)attr);
        int pageComp = 2;
        String showPage = paramObj.getString("showPage");
        if (StringUtils.isNotBlank((CharSequence)showPage)) {
            pageComp = Integer.parseInt(showPage.trim());
        }
        if (StringUtils.isBlank((CharSequence)(action = paramObj.getString("action")))) {
            action = PropsDataType.DATA_INIT.name();
        }
        if (PropsDataType.DATA_INIT.name().equals(action)) {
            this.sendDataInitEvent(pageComp);
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u9884\u6d4b\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ForecastPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        } else {
            GptForecast gptForecast = this.getGptForecast(false);
            JSONObject dataObj = gptForecast.getPredData(null);
            dataObj.fluentPut("compType", (Object)pageComp);
            this.sendDataUpdateEvent(dataObj);
        }
    }

    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("model"));
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = AnalysisCanvasUtils.unCompressData((String)evt.getEventArgs());
        log.info("customEvent eventName:{}, arg:{}", (Object)eventName, (Object)eventArgs);
        if ("predict".equals(eventName)) {
            this.predict();
        } else if ("predTargetSelect".equals(eventName) || "reloadData".equals(eventName)) {
            this.targetSelect(eventArgs);
        }
    }

    private void predict() {
        try {
            GptForecast gptForecast = this.getGptForecast(true);
            List dimHashIdLong = gptForecast.doPredict();
            if (CollectionUtils.isNotEmpty((Collection)dimHashIdLong)) {
                this.refreshResultPanel(gptForecast.getPredData((Long)dimHashIdLong.get(0)));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8db3\u591f\u7684\u6570\u636e\u7528\u4e8e\u8bad\u7ec3\u9884\u6d4b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u65f6\u95f4\u8303\u56f4\u3002", (String)"ForecastPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private GptForecast getGptForecast(boolean isPredictAction) {
        String param = this.getPageCache().get("req_param");
        return new GptForecast(param, isPredictAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetSelect(String eventArgs) {
        try {
            JSONObject jsonObj = JSON.parseObject((String)eventArgs);
            String dimHashId = jsonObj.getString("hashId");
            GptForecast gptForecast = this.getGptForecast(false);
            this.refreshResultPanel(gptForecast.getPredData(Long.valueOf(Long.parseLong(dimHashId))));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void refreshResultPanel(JSONObject dataObj) {
        this.sendDataUpdateEvent(dataObj);
    }

    private void sendDataInitEvent(int pageComp) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_INIT);
        propsData.setData(new JSONObject().fluentPut("compType", (Object)pageComp));
        this.sendData(propsData);
    }

    private void sendDataUpdateEvent(JSONObject dataObj) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_UPDATE);
        propsData.setData(dataObj);
        this.sendData(propsData);
    }

    private void sendData(PropsData data) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)data);
    }
}

