/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.business.forecast.model.PredParam;
import kd.epm.eb.business.forecast.model.PredTarget;
import kd.epm.eb.formplugin.forecast.PredictSideBarI18N;
import kd.epm.eb.formplugin.forecast.constant.PropsDataType;
import kd.epm.eb.formplugin.forecast.model.PropsData;

public class PredictCustomEvent {
    private static final Log log = LogFactory.getLog(PredictCustomEvent.class);

    public static PredictCustomEvent getInstance() {
        return InnerClass.instance;
    }

    private PredictCustomEvent() {
    }

    public void sendDataInitEvent(IFormView formView, PredParam predParam) {
        JSONObject json = new JSONObject();
        json.put("predParam", (Object)predParam);
        json.put("i18n", PredictSideBarI18N.getInstance().getI18NData());
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_INIT);
        propsData.setData(json);
        this.sendData(formView, propsData);
    }

    public void sendDataSwitchEvent(IFormView formView, JSONObject jsonObject) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_FLOATING);
        jsonObject.put("i18n", PredictSideBarI18N.getInstance().getI18NData());
        propsData.setData(jsonObject);
        this.sendData(formView, propsData);
    }

    public void sendCloseFloatingEvent(IFormView formView) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.CLOSE_FLOATING);
        this.sendData(formView, propsData);
    }

    public void sendDataUpdateRow(IFormView formView, Integer rowIndex, PredTarget target) {
        JSONObject json = new JSONObject();
        json.fluentPut("rowIndex", (Object)rowIndex);
        json.fluentPut("target", (Object)target);
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_UPDATE_ROW);
        propsData.setData(json);
        this.sendData(formView, propsData);
    }

    public void sendCellClickData(IFormView formView, JSONObject cellData) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_CELL_CLICK);
        propsData.setData(cellData);
        this.sendData(formView, propsData);
    }

    public void sendDataBpStartEvent(IFormView formView, MemberDto member) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_BP_START);
        propsData.setData(member);
        this.sendData(formView, propsData);
    }

    public void sendDataBpEndEvent(IFormView formView, MemberDto member) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_BP_END);
        propsData.setData(member);
        this.sendData(formView, propsData);
    }

    public void sendDataFactorsEvent(IFormView formView, List<PredFactor> factors) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_FACTOR);
        propsData.setData(factors);
        this.sendData(formView, propsData);
    }

    public void sendCleanEvent(IFormView formView) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.LOADING_CLEAN);
        this.sendData(formView, propsData);
    }

    public void sendDataEvent(IFormView formView, JSONObject dataObj, PropsDataType dataType) {
        PropsData propsData = new PropsData();
        propsData.setDataType(dataType);
        propsData.setData(dataObj);
        this.sendData(formView, propsData);
    }

    private void sendData(IFormView formView, PropsData data) {
        CustomControl customcontrol = (CustomControl)formView.getControl("customcontrolap");
        customcontrol.setData((Object)data);
    }

    private static class InnerClass {
        private static final PredictCustomEvent instance = new PredictCustomEvent();

        private InnerClass() {
        }
    }
}

