/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.forecast.PredictParamFactorService;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.forecast.helper.ForecastHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictParamFactorPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"dimmember", "btn_cancel", "btn_ok"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataset = (BasedataEdit)this.getControl("dataset");
        dataset.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.EDIT) {
            this.editFactor();
        } else if (status == OperationStatus.ADDNEW) {
            PredFactor predFactor = (PredFactor)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("factor")), PredFactor.class);
            if (predFactor == null) {
                this.addFactor();
            } else {
                this.viewFactor(predFactor);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getView().getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            Set roleModels = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView()));
            qFilterList.add(new QFilter("id", "in", (Object)roleModels));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
        if ("dataset".equals(key)) {
            e.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                Long datasetId = this.getDatasetId(IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)this.getModelId());
            }
        } else if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                Long modelId = this.getModelId();
                Long datasetId = IDUtils.toLong((Object)dataSetId);
                PredFactor predFactor = PredictParamFactorService.getInstance().queryMemory(modelId, datasetId);
                if (predFactor != null) {
                    this.initEntryEntityValue(modelId, datasetId, predFactor.getDimView(), predFactor.getDimConf());
                } else {
                    ForecastHelper.initEntryEntityDefault(this.getView(), modelId, datasetId);
                }
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getModel().setValue("members", null, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            this.buildFactor();
        }
        if ("btn_cancel".equals(ctrlKey)) {
            this.getView().close();
        }
        if ("dimmember".equals(ctrlKey)) {
            this.openDimSelect();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("memberCloseCallback".equals(actionId) && evt.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection members = (ListSelectedRowCollection)evt.getReturnData();
            StringBuilder sb = new StringBuilder();
            ArrayList<MemberDto> list = new ArrayList<MemberDto>();
            if (CollectionUtils.isNotEmpty((Collection)members)) {
                for (ListSelectedRow member : members) {
                    MemberDto item = new MemberDto();
                    item.setId(member.getPrimaryKeyValue().toString());
                    item.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                    item.setNumber(member.getNumber());
                    item.setName(member.getName());
                    ForecastHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), RangeEnum.ONLY.getIndex());
                    list.add(item);
                }
                Long viewId = IDUtils.toLong(members.get(0).getDataMap().get("viewid"));
                int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("viewid", (Object)viewId, rowIndex);
                this.getModel().setValue("members", (Object)JSON.toJSONString(list), rowIndex);
                this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
            }
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        }
        return modelId;
    }

    private void editFactor() {
        Long factorId = this.getFactorId();
        if (IDUtils.isNotEmptyLong((Long)factorId).booleanValue()) {
            PredFactor predFactor = PredictParamFactorService.getInstance().queryFactor(factorId);
            this.getModel().setValue("name", (Object)predFactor.getName());
            this.buildByPredFactor(predFactor);
        } else {
            this.buildByMemory();
        }
    }

    private void addFactor() {
        String memory = this.getView().getParentView().getPageCache().get("memoryFactor");
        if (StringUtils.isNotEmpty((CharSequence)memory)) {
            PredFactor predFactor = (PredFactor)JSONObject.parseObject((String)memory, PredFactor.class);
            this.buildByPredFactor(predFactor);
        } else {
            this.buildByMemory();
        }
    }

    private void viewFactor(PredFactor predFactor) {
        this.getModel().setValue("name", (Object)predFactor.getName());
        this.buildByPredFactor(predFactor);
        if (StringUtils.isNotEmpty((CharSequence)predFactor.getFactorId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "model", "dataset", "entryentity"});
        }
    }

    private void buildByMemory() {
        Long modelId = this.getModelId();
        PredFactor predFactor = PredictParamFactorService.getInstance().queryMemory(modelId);
        if (predFactor != null) {
            this.buildByPredFactor(predFactor);
        } else {
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
            Long datasetId = this.getDatasetId(modelId);
            this.getModel().setValue("dataset", (Object)datasetId);
            this.getPageCache().put("dataset", String.valueOf(datasetId));
            ForecastHelper.initEntryEntityDefault(this.getView(), this.getModelId(), this.getDatasetId());
        }
    }

    private void buildByPredFactor(PredFactor predFactor) {
        Long modelId = IDUtils.toLong((Object)predFactor.getModel());
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        Long datasetId = IDUtils.toLong((Object)predFactor.getDataset());
        this.getModel().setValue("dataset", (Object)datasetId);
        this.getPageCache().put("dataset", String.valueOf(datasetId));
        this.initEntryEntityValue(modelId, datasetId, predFactor.getDimView(), predFactor.getDimConf());
    }

    private Long getDatasetId(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("number", "=", (Object)"default");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        return dynamicObject == null ? null : Long.valueOf(dynamicObject.getLong("id"));
    }

    public Long getDatasetId() {
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue() && (datasetId = this.getDatasetId(this.getModelId())) != null) {
            this.getPageCache().put("dataset", String.valueOf(datasetId));
        }
        return datasetId;
    }

    public Long getTargetId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("targetid"));
    }

    public Long getFactorId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("factorid"));
    }

    private void openDimSelect() {
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject row = this.getView().getModel().getEntryRowEntity("entryentity", rowIndex);
        String dimNumber = row.getString("dimnumber");
        Long viewId = row.getLong("viewid");
        Long modelId = this.getModelId();
        Long dataSetId = this.getDatasetId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        boolean viewExisted = viewId == 0L || ModelHelper.viewExisted((Long)viewId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(modelCache.getBusModelByDataSet(dataSetId));
        f7Param.setDatasetId(dataSetId);
        f7Param.setViewId(Long.valueOf(viewExisted ? viewId : 0L));
        f7Param.addCustomFilter(qFilters);
        f7Param.setEnableView(true);
        f7Param.setReturnAllData(true);
        f7Param.setCanSelectBudgetPeriodRoot(false);
        if (StringUtils.isNotEmpty((CharSequence)row.getString("members")) && viewExisted) {
            List selectItemList = JSON.parseArray((String)row.getString("members"), MemberDto.class);
            Set ids = selectItemList.stream().map(p -> Long.parseLong(p.getId())).collect(Collectors.toSet());
            f7Param.setSelectIds(ids);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "memberCloseCallback");
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private void initEntryEntityValue(Long modelId, Long datasetId, String dimView, String dimConf) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        JSONObject dimensionViews = JSON.parseObject((String)dimView);
        JSONObject dimMembers = JSON.parseObject((String)dimConf);
        this.getView().getModel().deleteEntryData("entryentity");
        this.getView().getModel().batchCreateNewEntryRow("entryentity", dimensionList.size() - 1);
        AtomicInteger row = new AtomicInteger(0);
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            int rowIndex = row.getAndIncrement();
            String members = dimMembers.getString(dimNumber);
            Long viewId = IDUtils.toLong((Object)dimensionViews.get((Object)dimNumber));
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)members)) {
                List memberList = JSONObject.parseArray((String)members, MemberDto.class);
                List<MemberDto> excitedMember = memberList.stream().filter(memberDto -> AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberDto.getNumber()) != null).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(excitedMember)) {
                    excitedMember.forEach(memberDto -> {
                        Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberDto.getNumber());
                        ForecastHelper.buildMultiSelectF7ReturnValue(sb, member == null ? "" : member.getName(), Integer.parseInt(memberDto.getScope()));
                    });
                    this.getView().getModel().setValue("dimname", (Object)dimension.getName(), rowIndex);
                    this.getView().getModel().setValue("dimnumber", (Object)dimNumber, rowIndex);
                    this.getModel().setValue("viewid", (Object)viewId, rowIndex);
                    this.getModel().setValue("members", (Object)JSONObject.toJSONString(excitedMember), rowIndex);
                    this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
                } else {
                    Map<String, String> defaultMember = ForecastHelper.getDefaultMember();
                    boolean viewExisted = viewId == 0L || ModelHelper.viewExisted((Long)viewId);
                    ForecastHelper.setDefaultDimMember(modelCache, datasetId, dimension, dimNumber, viewExisted ? viewId : ForecastHelper.getDimDefaultView(modelCache, datasetId, dimNumber), defaultMember, rowIndex, this.getView());
                }
            } else {
                Map<String, String> defaultMember = ForecastHelper.getDefaultMember();
                boolean viewExisted = viewId == 0L || ModelHelper.viewExisted((Long)viewId);
                ForecastHelper.setDefaultDimMember(modelCache, datasetId, dimension, dimNumber, viewExisted ? viewId : ForecastHelper.getDimDefaultView(modelCache, datasetId, dimNumber), defaultMember, rowIndex, this.getView());
            }
        });
    }

    private void buildFactor() {
        OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("name");
        String name = ormLocaleValue.getLocaleValue();
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f71\u54cd\u56e0\u7d20\u540d\u79f0\u3002", (String)"PredictParamTargetPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"PredictParamFactorPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"PredictParamFactorPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection targets = this.getView().getModel().getEntryEntity("entryentity");
        JSONObject members = new JSONObject();
        JSONObject view = new JSONObject();
        for (DynamicObject row : targets) {
            String dimNumber = row.getString("dimnumber");
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) break;
            String member = row.getString("members");
            if (StringUtils.isEmpty((CharSequence)member)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u201c%1\u201d\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"PredictParamFactorPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getString("dimname")}));
                return;
            }
            members.put(dimNumber, (Object)member);
            Long viewId = row.getLong("viewid");
            if (!IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) continue;
            view.put(dimNumber, (Object)viewId);
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String dimConf = members.toJSONString();
        Long dimHashId = PredictParamFactorService.getInstance().calcDimHashId(modelId, datasetId, dimConf);
        if (status == OperationStatus.EDIT) {
            Long id = this.getFactorId();
            Long targetId = this.getTargetId();
            DynamicObject dynamicObject = PredictParamFactorService.getInstance().checkSameDimHashId(id, targetId, datasetId, dimHashId);
            if (dynamicObject != null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5177\u6709\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u7684\u5f71\u54cd\u56e0\u7d20\uff1a\u3010%1\u3011\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PredictParamFactorPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
                return;
            }
            Long factorId = PredictParamFactorService.getInstance().save(id, targetId, name, modelId, datasetId, dimConf, view.toJSONString());
            if (IDUtils.isNotEmptyLong((Long)factorId).booleanValue()) {
                this.getView().returnDataToParent((Object)factorId);
                this.getView().close();
            }
        } else {
            List factors = JSON.parseArray((String)((String)this.getView().getFormShowParameter().getCustomParam("factors")), PredFactor.class);
            PredFactor predFactor = new PredFactor();
            PredFactor lastFactor = (PredFactor)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("factor")), PredFactor.class);
            if (lastFactor == null) {
                boolean matchHashId = factors.stream().anyMatch(e -> modelId.toString().equals(e.getModel()) && datasetId.toString().equals(e.getDataset()) && dimHashId.toString().equals(e.getHashId()));
                if (matchHashId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5177\u6709\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u7684\u5f71\u54cd\u56e0\u7d20\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PredictParamFactorPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                factors.add(predFactor);
            } else {
                Integer rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowIndex");
                int size = factors.size();
                for (int i = 0; i < size; ++i) {
                    PredFactor factor = (PredFactor)factors.get(i);
                    if (i == rowIndex || !modelId.toString().equals(factor.getModel()) || !datasetId.toString().equals(factor.getDataset()) || !dimHashId.toString().equals(factor.getHashId())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5177\u6709\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u7684\u5f71\u54cd\u56e0\u7d20\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PredictParamFactorPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                factors.set(rowIndex, predFactor);
            }
            predFactor.setName(name);
            predFactor.setModel(modelId.toString());
            predFactor.setDataset(datasetId.toString());
            predFactor.setDimConf(dimConf);
            predFactor.setDimView(view.toJSONString());
            predFactor.setHashId(dimHashId.toString());
            this.getView().getParentView().getPageCache().put("memoryFactor", JSON.toJSONString((Object)predFactor));
            this.getView().returnDataToParent((Object)JSONObject.toJSONString((Object)factors));
            this.getView().close();
        }
    }
}

