/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.epm.eb.business.forecast.PredictParamFactorService;
import kd.epm.eb.business.forecast.PredictParamService;
import kd.epm.eb.business.forecast.PredictParamTargetService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.forecast.helper.ForecastHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class PredictParamPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String DATA_TYPE = "datatype";
    private static final String VERSION = "version";
    private static final String SAMPLE_LEN = "samplelen";
    private static final String USE_MODEL = "usemodel";
    private static final String REQ_TYPE = "reqtype";
    private static final String SHOW = "show";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"target", "factor", "btn_del_target", "btn_del_factor", "btn_add_target", "btn_add_factor"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataTypeEdit = (BasedataEdit)this.getControl(DATA_TYPE);
        dataTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit versionEdit = (BasedataEdit)this.getControl(VERSION);
        versionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"PredictParamPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.cacheModelId(modelId);
        this.initValue();
        this.initTargetEntry();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectDefaultRow(0);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("tnewentry".equals(operateKey)) {
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("targetentry");
            this.refreshFactorEntry(rowIndex);
            this.openPredictParamTarget();
        }
        if ("fnewentry".equals(operateKey)) {
            this.openPredictParamFactor();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row < 0) {
            return;
        }
        this.refreshFactorEntry(row);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "model": {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList();
                }
                qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            case "datatype": 
            case "version": {
                Long modelId = this.getModelId();
                if (modelId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExpenseAdjustParamShowPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)(key.equals(DATA_TYPE) ? SysDimensionEnum.DataType.getNumber() : SysDimensionEnum.Version.getNumber())), (String)ListSelectedRow.class.getName());
                f7Param.setOnlySelLeaf(true);
                NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("target".equals(ctrlKey)) {
            this.openPredictParamTarget();
        } else if ("factor".equals(ctrlKey)) {
            this.openPredictParamFactor();
        } else if ("btn_del_target".equals(ctrlKey)) {
            EntryGrid entry = (EntryGrid)this.getControl("targetentry");
            int[] selectedRows = entry.getEntryState().getSelectedRows();
            List ids = Arrays.stream(selectedRows).mapToObj(i -> IDUtils.toLong((Object)this.getModel().getValue("targetid", i))).filter(IDUtils::isNotEmptyLong).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5220\u9664\u9009\u4e2d\u884c\u9884\u6d4b\u5bf9\u8c61\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"PredictParamPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_del_target", (IFormPlugin)this));
            } else if (selectedRows.length == 1) {
                this.getView().getModel().deleteEntryRows("targetentry", selectedRows);
                this.getModel().beginInit();
                int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("targetentry");
                this.refreshFactorEntry(rowIndex);
            }
        } else if ("btn_del_factor".equals(ctrlKey)) {
            EntryGrid entry = (EntryGrid)this.getControl("factorentry");
            int[] selectedRows = entry.getEntryState().getSelectedRows();
            List ids = Arrays.stream(selectedRows).mapToObj(i -> IDUtils.toLong((Object)this.getModel().getValue("factorid", i))).filter(IDUtils::isNotEmptyLong).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5220\u9664\u9009\u4e2d\u884c\u5f71\u54cd\u56e0\u7d20\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"PredictParamPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_del_factor", (IFormPlugin)this));
            } else {
                this.getView().getModel().deleteEntryRows("factorentry", selectedRows);
                this.getModel().beginInit();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.checkPermission(this.getView(), evt.getItemKey());
        String key = evt.getItemKey();
        if ("btn_save".equals(key)) {
            this.save();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
            if (IDUtils.isNull((Long)modelId)) {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            } else {
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.cacheModelId(modelId);
                this.initValue();
                this.initTargetEntry();
                this.selectDefaultRow(0);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        int rowIndex;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Long targetId = (Long)evt.getReturnData();
        if ("paramTargetCloseCallback".equals(actionId) && IDUtils.isNotEmptyLong((Long)targetId).booleanValue()) {
            rowIndex = this.getModel().getEntryCurrentRowIndex("targetentry");
            DynamicObject target = PredictParamTargetService.getInstance().query(targetId);
            this.setTargetEntryRow(target, rowIndex);
        }
        if ("paramFactorCloseCallback".equals(actionId) && IDUtils.isNotEmptyLong((Long)targetId).booleanValue()) {
            rowIndex = this.getModel().getEntryCurrentRowIndex("factorentry");
            DynamicObject factor = PredictParamFactorService.getInstance().query(targetId);
            this.setFactorEntryRow(factor, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("btn_del_target".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("targetentry");
            DynamicObject row = this.getView().getModel().getEntryRowEntity("targetentry", rowIndex);
            Long targetId = row.getLong("targetid");
            PredictParamTargetService.getInstance().delete(targetId);
            this.getView().getModel().deleteEntryRow("targetentry", rowIndex);
            this.getModel().beginInit();
            rowIndex = this.getView().getModel().getEntryCurrentRowIndex("targetentry");
            this.refreshFactorEntry(rowIndex);
        }
        if ("btn_del_factor".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            EntryGrid entry = (EntryGrid)this.getControl("factorentry");
            int[] selectedRows = entry.getEntryState().getSelectedRows();
            List ids = Arrays.stream(selectedRows).mapToObj(i -> IDUtils.toLong((Object)this.getModel().getValue("factorid", i))).filter(IDUtils::isNotEmptyLong).collect(Collectors.toList());
            PredictParamFactorService.getInstance().delete(ids);
            this.getView().getModel().deleteEntryRows("factorentry", selectedRows);
            this.getModel().beginInit();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private void selectDefaultRow(int rowIndex) {
        DynamicObjectCollection targets = this.getView().getModel().getEntryEntity("targetentry");
        if (CollectionUtils.isNotEmpty((Collection)targets)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("targetentry");
            entryGrid.selectRows(rowIndex, true);
            this.refreshFactorEntry(rowIndex);
        }
    }

    private void refreshFactorEntry(int rowIndex) {
        DynamicObject row = this.getView().getModel().getEntryRowEntity("targetentry", rowIndex);
        if (row != null && IDUtils.isNotEmptyLong((Long)row.getLong("targetid")).booleanValue()) {
            this.initFactorEntry(row.getLong("targetid"));
        } else {
            this.getView().getModel().deleteEntryData("factorentry");
        }
        this.getView().updateView("factorentry");
    }

    private void save() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue(DATA_TYPE);
        if (dataType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6837\u672c\u6570\u636e\u7684\u6570\u636e\u7c7b\u578b\u3002", (String)"PredictParamPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION);
        if (version == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6837\u672c\u6570\u636e\u7684\u7248\u672c\u3002", (String)"PredictParamPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Integer sampleLen = (Integer)this.getModel().getValue(SAMPLE_LEN);
        if (sampleLen == null || (long)sampleLen.intValue() == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6837\u672c\u6570\u636e\u671f\u95f4\u3002", (String)"PredictParamPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"eb_predict_param");
        DynamicProperty _property = dt.getProperty(SAMPLE_LEN);
        if (_property instanceof IntegerProp) {
            BigDecimal max = ((IntegerProp)_property).getMax();
            BigDecimal min = ((IntegerProp)_property).getMin();
            if (min.intValue() > sampleLen || max.intValue() < sampleLen) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[%1,%2]\u3002", (String)"PredictParamPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{min, max}));
                return;
            }
        }
        String useModel = (String)this.getModel().getValue(USE_MODEL);
        String reqType = (String)this.getModel().getValue(REQ_TYPE);
        boolean showFlag = (Boolean)this.getModel().getValue(SHOW);
        Long id = PredictParamService.getInstance().save(this.getModelId(), Long.valueOf(dataType.getLong("id")), Long.valueOf(version.getLong("id")), sampleLen, useModel, reqType, Boolean.valueOf(showFlag));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PredictParamPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "PredictParamPlugin_3", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u9ed8\u8ba4\u53c2\u6570id\uff1a%1$s\u4fdd\u5b58\u6210\u529f", "PredictParamPlugin_4", "epm-eb-formplugin");
        this.writeLog(null, "save", opName, opDesc, new String[]{String.valueOf(id)});
    }

    private void initTargetEntry() {
        DynamicObjectCollection targets = PredictParamTargetService.getInstance().queryByModel(this.getModelId());
        if (CollectionUtils.isNotEmpty((Collection)targets)) {
            this.getView().getModel().deleteEntryData("targetentry");
            this.getView().getModel().batchCreateNewEntryRow("targetentry", targets.size());
            AtomicInteger row = new AtomicInteger(0);
            targets.forEach(target -> {
                int rowIndex = row.getAndIncrement();
                this.setTargetEntryRow((DynamicObject)target, rowIndex);
            });
        } else {
            this.getView().getModel().deleteEntryData("targetentry");
            this.getView().getModel().deleteEntryData("factorentry");
        }
    }

    private void setTargetEntryRow(DynamicObject target, int rowIndex) {
        long dataset = target.getLong("dataset");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)target.getLong("model"));
        List dimensionList = modelCache.getDimensionList(Long.valueOf(dataset));
        JSONObject dimensionViews = JSON.parseObject((String)target.getString("dimview"));
        JSONObject dimMembers = JSON.parseObject((String)target.getString("dimconf"));
        String targetName = null;
        try {
            targetName = ForecastHelper.buildDimensionCombName(modelCache, dataset, dimensionList, dimensionViews, dimMembers);
        }
        catch (Exception e) {
            PredictParamTargetService.getInstance().delete(Long.valueOf(target.getLong("id")));
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a\u201d%2\u201c\u3002", (String)"PredictParamPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex + 1, e.getMessage()}));
            return;
        }
        this.getModel().setValue("targetid", (Object)target.getLong("id"), rowIndex);
        this.getModel().setValue("tdataset", (Object)dataset, rowIndex);
        this.getModel().setValue("target", (Object)targetName, rowIndex);
    }

    private void initFactorEntry(Long targetId) {
        DynamicObjectCollection factors = PredictParamFactorService.getInstance().queryByTarget(targetId);
        if (CollectionUtils.isNotEmpty((Collection)factors)) {
            this.getView().getModel().deleteEntryData("factorentry");
            this.getView().getModel().batchCreateNewEntryRow("factorentry", factors.size());
            AtomicInteger row = new AtomicInteger(0);
            factors.forEach(factor -> {
                int rowIndex = row.getAndIncrement();
                this.setFactorEntryRow((DynamicObject)factor, rowIndex);
            });
        } else {
            this.getView().getModel().deleteEntryData("factorentry");
        }
    }

    private void setFactorEntryRow(DynamicObject factor, int rowIndex) {
        long dataset = factor.getLong("dataset");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)factor.getLong("model"));
        List dimensionList = modelCache.getDimensionList(Long.valueOf(dataset));
        JSONObject dimensionViews = JSON.parseObject((String)factor.getString("dimview"));
        JSONObject dimMembers = JSON.parseObject((String)factor.getString("dimconf"));
        String targetName = null;
        try {
            targetName = ForecastHelper.buildDimensionCombName(modelCache, dataset, dimensionList, dimensionViews, dimMembers);
        }
        catch (Exception e) {
            PredictParamFactorService.getInstance().delete(Collections.singletonList(factor.getLong("id")));
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a\u201d%2\u201c\u3002", (String)"PredictParamPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex + 1, e.getMessage()}));
            return;
        }
        this.getModel().setValue("factorid", (Object)factor.getLong("id"), rowIndex);
        this.getModel().setValue("fmodel", (Object)factor.getLong("model"), rowIndex);
        this.getModel().setValue("fdataset", (Object)dataset, rowIndex);
        this.getModel().setValue("fname", (Object)factor.getString("name"), rowIndex);
        this.getModel().setValue("factor", (Object)targetName, rowIndex);
    }

    private void initValue() {
        DynamicObject param = PredictParamService.getInstance().query(this.getModelId());
        if (param == null) {
            Member versionMember;
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Member dataTypeMember = modelCacheHelper.getMember(SysDimensionEnum.DataType.getNumber(), null, "Actual");
            if (dataTypeMember != null) {
                this.getModel().setValue(DATA_TYPE, (Object)dataTypeMember.getId());
            }
            if ((versionMember = modelCacheHelper.getMember(SysDimensionEnum.Version.getNumber(), null, "ACTUAL")) != null) {
                this.getModel().setValue(VERSION, (Object)versionMember.getId());
            }
            this.getModel().setValue(SAMPLE_LEN, (Object)36);
        } else {
            this.getModel().setValue(DATA_TYPE, (Object)param.getLong(DATA_TYPE));
            this.getModel().setValue(VERSION, (Object)param.getLong(VERSION));
            this.getModel().setValue(SAMPLE_LEN, (Object)param.getInt(SAMPLE_LEN));
            this.getModel().setValue(USE_MODEL, (Object)param.getString(USE_MODEL));
            this.getModel().setValue(REQ_TYPE, (Object)param.getString(REQ_TYPE));
            this.getModel().setValue(SHOW, (Object)param.getBoolean(SHOW));
        }
    }

    private void openPredictParamTarget() {
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("targetentry");
        DynamicObject row = this.getView().getModel().getEntryRowEntity("targetentry", rowIndex);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_predict_param_target");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "paramTargetCloseCallback"));
        fsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        fsp.setCustomParam("targetid", row == null ? null : Long.valueOf(row.getLong("targetid")));
        this.getView().showForm(fsp);
    }

    private void openPredictParamFactor() {
        int targetRowIndex = this.getView().getModel().getEntryCurrentRowIndex("targetentry");
        DynamicObject target = this.getView().getModel().getEntryRowEntity("targetentry", targetRowIndex);
        if (target == null || IDUtils.isEmptyLong((Long)target.getLong("targetid")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6709\u6570\u636e\u7684\u9884\u6d4b\u5bf9\u8c61\u518d\u8fdb\u884c\u65b0\u589e\u3002", (String)"PredictParamPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("factorentry");
        DynamicObject row = this.getView().getModel().getEntryRowEntity("factorentry", rowIndex);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_predict_param_factor");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "paramFactorCloseCallback"));
        fsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setCustomParam("targetid", (Object)target.getLong("targetid"));
        fsp.setCustomParam("factorid", row == null ? null : Long.valueOf(row.getLong("factorid")));
        this.getView().showForm(fsp);
    }

    private void cacheModelId(Long modelId) {
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
    }
}

