/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.forecast.PredictParamTargetService;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.forecast.helper.ForecastHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictParamTargetPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"dimmember", "btn_cancel", "btn_ok"});
        BasedataEdit dataset = (BasedataEdit)this.getControl("dataset");
        dataset.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = this.getModelId();
        this.getModel().setValue("model", (Object)modelId);
        Long targetId = this.getTargetId();
        if (IDUtils.isNotEmptyLong((Long)targetId).booleanValue()) {
            DynamicObject target = PredictParamTargetService.getInstance().query(targetId);
            Long datasetId = target.getLong("dataset");
            this.getModel().setValue("dataset", (Object)datasetId);
            this.getPageCache().put("dataset", String.valueOf(datasetId));
            this.initEntryEntityValue(target);
        } else {
            DynamicObject memory = PredictParamTargetService.getInstance().queryMemory(modelId);
            if (memory != null) {
                Long datasetId = memory.getLong("dataset");
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", String.valueOf(datasetId));
                this.initEntryEntityValue(memory);
            } else {
                this.getModel().setValue("dataset", (Object)this.getDatasetId());
                ForecastHelper.initEntryEntityDefault(this.getView(), this.getModelId(), this.getDatasetId());
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            e.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                DynamicObject memory = PredictParamTargetService.getInstance().queryMemory(this.getModelId(), IDUtils.toLong((Object)dataSetId));
                if (memory != null) {
                    this.initEntryEntityValue(memory);
                } else {
                    ForecastHelper.initEntryEntityDefault(this.getView(), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                }
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getModel().setValue("members", null, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        Long targetId;
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey) && IDUtils.isNotEmptyLong((Long)(targetId = this.buildTarget())).booleanValue()) {
            this.getView().returnDataToParent((Object)targetId);
            this.getView().close();
        }
        if ("btn_cancel".equals(ctrlKey)) {
            this.getView().close();
        }
        if ("dimmember".equals(ctrlKey)) {
            this.openDimSelect();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("memberCloseCallback".equals(actionId) && evt.getReturnData() instanceof DynamicObjectCollection) {
            DynamicObjectCollection rows = (DynamicObjectCollection)evt.getReturnData();
            StringBuilder sb = new StringBuilder();
            ArrayList<MemberDto> list = new ArrayList<MemberDto>();
            if (CollectionUtils.isNotEmpty((Collection)rows)) {
                for (DynamicObject row : rows) {
                    MemberDto item = new MemberDto();
                    item.setId(row.getString("memberid"));
                    item.setScope(row.getString("scope"));
                    item.setNumber(row.getString("number"));
                    item.setName(row.getString("name"));
                    ForecastHelper.buildMultiSelectF7ReturnValue(sb, row.getString("name"), row.getInt("scope"));
                    list.add(item);
                }
                Long viewId = ((DynamicObject)rows.get(0)).getLong("viewid");
                int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("viewid", (Object)viewId, rowIndex);
                this.getModel().setValue("members", (Object)JSON.toJSONString(list), rowIndex);
                this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
            }
        }
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
    }

    public Long getDatasetId() {
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            QFilter qFilter1 = new QFilter("number", "=", (Object)"default");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
            Long l = datasetId = dynamicObject == null ? null : Long.valueOf(dynamicObject.getLong("id"));
            if (datasetId != null) {
                this.getPageCache().put("dataset", String.valueOf(datasetId));
            }
        }
        return datasetId;
    }

    public Long getTargetId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("targetid"));
    }

    private void openDimSelect() {
        boolean viewExisted;
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject row = this.getView().getModel().getEntryRowEntity("entryentity", rowIndex);
        String dimNumber = row.getString("dimnumber");
        Long viewId = row.getLong("viewid");
        Long modelId = this.getModelId();
        Long dataSetId = this.getDatasetId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("number", "!=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()));
        }
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "memberCloseCallback"));
        param.setqFilters(qFilters);
        param.setLockRangeSelect(false);
        param.setEnableView(true);
        param.setNeedPermCheck(true);
        param.setSign(dimNumber);
        param.setBizModelId(bizModelId);
        param.setDatasetId(dataSetId);
        boolean bl = viewExisted = viewId == 0L || ModelHelper.viewExisted((Long)viewId);
        if (StringUtils.isNotEmpty((CharSequence)row.getString("members")) && viewExisted) {
            List selectItemList = JSON.parseArray((String)row.getString("members"), MemberDto.class);
            List conList = selectItemList.stream().map(s -> {
                MemberCondition memberCondition = new MemberCondition();
                memberCondition.setNumber(s.getNumber());
                memberCondition.setRange(s.getScope());
                return memberCondition;
            }).collect(Collectors.toList());
            param.setCon_list(conList);
        }
        CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)(viewExisted ? viewId : 0L), (IFormView)this.getView(), (RangeF7Param)param);
    }

    private void initEntryEntityValue(DynamicObject target) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)target.getLong("model"));
        Long datasetId = target.getLong("dataset");
        List dimensionList = modelCache.getDimensionList(datasetId);
        JSONObject dimensionViews = JSON.parseObject((String)target.getString("dimview"));
        JSONObject dimMembers = JSON.parseObject((String)target.getString("dimconf"));
        this.getView().getModel().deleteEntryData("entryentity");
        this.getView().getModel().batchCreateNewEntryRow("entryentity", dimensionList.size() - 1);
        AtomicInteger row = new AtomicInteger(0);
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            int rowIndex = row.getAndIncrement();
            String members = dimMembers.getString(dimNumber);
            Long viewId = IDUtils.toLong((Object)dimensionViews.get((Object)dimNumber));
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)members)) {
                List memberList = JSONObject.parseArray((String)members, MemberDto.class);
                List<MemberDto> excitedMember = memberList.stream().filter(memberDto -> AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberDto.getNumber()) != null).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(excitedMember)) {
                    excitedMember.forEach(memberDto -> {
                        Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberDto.getNumber());
                        ForecastHelper.buildMultiSelectF7ReturnValue(sb, member == null ? "" : member.getName(), Integer.parseInt(memberDto.getScope()));
                    });
                    this.getView().getModel().setValue("dimname", (Object)dimension.getName(), rowIndex);
                    this.getView().getModel().setValue("dimnumber", (Object)dimNumber, rowIndex);
                    this.getModel().setValue("viewid", (Object)viewId, rowIndex);
                    this.getModel().setValue("members", (Object)JSONObject.toJSONString(excitedMember), rowIndex);
                    this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
                } else {
                    Map<String, String> defaultMember = ForecastHelper.getDefaultMember();
                    boolean viewExisted = viewId == 0L || ModelHelper.viewExisted((Long)viewId);
                    ForecastHelper.setDefaultDimMember(modelCache, datasetId, dimension, dimNumber, viewExisted ? viewId : ForecastHelper.getDimDefaultView(modelCache, datasetId, dimNumber), defaultMember, rowIndex, this.getView());
                }
            } else {
                Map<String, String> defaultMember = ForecastHelper.getDefaultMember();
                boolean viewExisted = viewId == 0L || ModelHelper.viewExisted((Long)viewId);
                ForecastHelper.setDefaultDimMember(modelCache, datasetId, dimension, dimNumber, viewExisted ? viewId : ForecastHelper.getDimDefaultView(modelCache, datasetId, dimNumber), defaultMember, rowIndex, this.getView());
            }
        });
    }

    private Long buildTarget() {
        Long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"PredictParamTargetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return 0L;
        }
        DynamicObjectCollection targets = this.getView().getModel().getEntryEntity("entryentity");
        JSONObject members = new JSONObject();
        JSONObject view = new JSONObject();
        targets.forEach(row -> {
            String dimNumber = row.getString("dimnumber");
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            String member = row.getString("members");
            if (StringUtils.isEmpty((CharSequence)member)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u201c%1\u201d\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"PredictParamTargetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getString("dimname")}));
            }
            members.put(dimNumber, (Object)member);
            Long viewId = row.getLong("viewid");
            if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                view.put(dimNumber, (Object)viewId);
            }
        });
        return PredictParamTargetService.getInstance().save(this.getTargetId(), this.getModelId(), datasetId, members.toJSONString(), view.toJSONString());
    }
}

