/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.forecast.ForecastConstants;
import kd.epm.eb.business.forecast.PredictGuideService;
import kd.epm.eb.business.forecast.PredictMemoryService;
import kd.epm.eb.business.forecast.PredictParamFactorService;
import kd.epm.eb.business.forecast.PredictParamService;
import kd.epm.eb.business.forecast.PredictParamTargetService;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.business.forecast.WriteService;
import kd.epm.eb.business.forecast.entity.PredictRecord;
import kd.epm.eb.business.forecast.helper.ForecastChartHelper;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.business.forecast.model.PredParam;
import kd.epm.eb.business.forecast.model.PredTarget;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.params.ParamServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.forecast.PredictCustomEvent;
import kd.epm.eb.formplugin.forecast.PredictSideBarI18N;
import kd.epm.eb.formplugin.forecast.constant.ForecastPluginConstants;
import kd.epm.eb.formplugin.forecast.constant.PropsDataType;
import kd.epm.eb.formplugin.forecast.helper.ForecastHelper;
import kd.epm.eb.spread.utils.ReportEditHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class PredictSidebarPlugin
extends AbstractFormPlugin
implements SubPage {
    private static final Log log = LogFactory.getLog(PredictSidebarPlugin.class);
    private static final String CURR_ROW_DATA = "currRowData";

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("isWrite", Boolean.FALSE.toString());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long modelId = (Long)formShowParameter.getCustomParam("modelId");
        this.getPageCache().put("model", String.valueOf(modelId));
        long dataSetId = (Long)formShowParameter.getCustomParam("dataSetId");
        this.getPageCache().put("dataset", String.valueOf(dataSetId));
        Long canvasId = IDUtils.toLong((Object)formShowParameter.getCustomParam("canvasId"));
        this.getPageCache().put("canvasid", String.valueOf(canvasId));
        Long sandboxId = IDUtils.toLong((Object)formShowParameter.getCustomParam("sandboxId"));
        this.getPageCache().put("sandboxid", String.valueOf(sandboxId));
        Long schemeId = IDUtils.toLong((Object)formShowParameter.getCustomParam("schemeId"));
        this.getPageCache().put("schemeid", String.valueOf(schemeId));
        Long processId = IDUtils.toLong((Object)formShowParameter.getCustomParam("processId"));
        this.getPageCache().put("processid", String.valueOf(processId));
        Long taskProcessId = IDUtils.toLong((Object)formShowParameter.getCustomParam("taskProcessId"));
        this.getPageCache().put("taskprocessid", String.valueOf(taskProcessId));
        String precessType = (String)formShowParameter.getCustomParam("processType");
        this.getPageCache().put("processtype", precessType);
        Long templateId = IDUtils.toLong((Object)formShowParameter.getCustomParam("templateId"));
        this.getPageCache().put("templateId", String.valueOf(templateId));
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)formShowParameter.getCustomParam("predictData")))) {
            this.initPredictPage(formShowParameter);
        } else if (StringUtils.isNotEmpty((CharSequence)((CharSequence)formShowParameter.getCustomParam("predictGuide")))) {
            this.initResultPage(formShowParameter);
        } else {
            this.setInitData(formShowParameter, modelId, dataSetId, schemeId, processId, canvasId);
        }
    }

    private void initResultPage(FormShowParameter formShowParameter) {
        PredParam predParam = (PredParam)JSONObject.parseObject((String)((String)formShowParameter.getCustomParam("predictGuide")), PredParam.class);
        List factors = predParam.getFactors();
        if (CollectionUtils.isNotEmpty((Collection)factors)) {
            this.getView().getPageCache().put("memoryFactor", JSON.toJSONString(factors.get(factors.size() - 1)));
        }
        String recordId = (String)formShowParameter.getCustomParam("recordId");
        this.queryPredictResult(recordId, 1, predParam);
        if (predParam.getAutoWrite().booleanValue()) {
            this.refreshParentData();
        }
    }

    private void initPredictPage(FormShowParameter formShowParameter) {
        JSONObject jsonObject = JSON.parseObject((String)((String)formShowParameter.getCustomParam("predictData")));
        this.getPageCache().put("showFloating", jsonObject.getString("showFloating"));
        PredictCustomEvent.getInstance().sendDataSwitchEvent(this.getView(), jsonObject);
    }

    private void setInitData(FormShowParameter formShowParameter, Long modelId, Long dataSetId, Long schemeId, Long processId, Long canvasId) {
        List<Map<String, String>> cellDimNumList;
        Map dimViewMap;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(dataSetId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        this.getPageCache().put("bizmodel", String.valueOf(bizModelId));
        if ("eb_analysiscanvas_design".equals(formShowParameter.getParentFormId())) {
            String dimViewStr = (String)formShowParameter.getCustomParam("dimViewMap");
            dimViewMap = ForecastHelper.getViewMap(dimViewStr);
            JSONArray allDimArray = JSON.parseArray((String)((String)formShowParameter.getCustomParam("allDimNum")));
            cellDimNumList = allDimArray.stream().filter(Objects::nonNull).map(obj -> {
                JSONObject jsonObject = (JSONObject)obj;
                return jsonObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
            }).collect(Collectors.toList());
        } else {
            ReportEditHelper reportEditHelper = new ReportEditHelper(this.getView());
            List selectedRange = reportEditHelper.getSelectedRange();
            dimViewMap = reportEditHelper.getDimensionViewByCell((String)selectedRange.get(0));
            cellDimNumList = reportEditHelper.getMemberMapByRange(selectedRange);
        }
        String dataUnit = (String)formShowParameter.getCustomParam("dataunit");
        this.getPageCache().put("dataunit", dataUnit);
        JSONObject unitSettingJson = (JSONObject)formShowParameter.getCustomParam("unitSetting");
        Map unitSetting = PredictHelper.getUnitSetting((JSONObject)unitSettingJson);
        Map dataUnitMap = PredictHelper.getDataUnitMap((Map)unitSetting, (String)dataUnit);
        List<Map<String, String>> validDimNumList = this.filterValidMetricAndRepeat(modelCache, dimensionList, cellDimNumList);
        PredParam predParam = new PredParam();
        predParam.setNeedGuide(Boolean.valueOf(!PredictGuideService.getInstance().isNeedGuide()));
        String writable = (String)formShowParameter.getCustomParam("writable");
        predParam.setWritable(StringUtils.isBlank((CharSequence)writable) ? Boolean.TRUE : Boolean.valueOf(writable));
        String backRunnable = (String)formShowParameter.getCustomParam("backRunnable");
        predParam.setBackRunnable(StringUtils.isBlank((CharSequence)backRunnable) ? Boolean.TRUE : Boolean.valueOf(backRunnable));
        this.initPredTimeRange(cellDimNumList, modelCache, predParam);
        this.initPredTarget(modelCache, dimensionList, dimViewMap, validDimNumList, predParam, dataUnitMap);
        Set targetIds = PredictParamTargetService.getInstance().matchParamTarget(modelId, dataSetId, modelCache, dimensionList, validDimNumList);
        List predFactors = PredictParamFactorService.getInstance().queryFactor(targetIds);
        List memoryFactors = PredictMemoryService.getInstance().queryMemory(dataSetId);
        predFactors.addAll(memoryFactors);
        List distinctFactors = predFactors.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), ArrayList::new));
        predParam.setFactors(distinctFactors);
        long recordId = PredictRecordService.getInstance().hasPredicting(modelId.longValue(), schemeId, processId, canvasId);
        if (recordId > 0L) {
            JSONObject json = new JSONObject();
            json.fluentPut("componentName", (Object)"ing");
            json.fluentPut("recordId", (Object)String.valueOf(recordId));
            json.fluentPut("predictGuide", (Object)predParam);
            json.fluentPut("i18n", PredictSideBarI18N.getInstance().getI18NData());
            PredictCustomEvent.getInstance().sendDataEvent(this.getView(), json, PropsDataType.DOING_PREDICT);
        } else {
            PredictCustomEvent.getInstance().sendDataInitEvent(this.getView(), predParam);
        }
    }

    private List<Map<String, String>> filterValidMetricAndRepeat(IModelCacheHelper modelCache, List<Dimension> dimensionList, List<Map<String, String>> cellDimNumList) {
        HashSet dimHashIdSet = new HashSet(cellDimNumList.size());
        return cellDimNumList.stream().filter(dimMap -> {
            String key = dimensionList.stream().filter(dim -> !SysDimensionEnum.BudgetPeriod.getNumber().equals(dim.getNumber())).map(dim -> (String)dimMap.get(dim.getNumber())).filter(StringUtils::isNotEmpty).collect(Collectors.joining("!"));
            Long dimHashId = Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
            if (dimHashIdSet.contains(dimHashId)) {
                return false;
            }
            dimHashIdSet.add(dimHashId);
            return this.isValidMetric(modelCache, (Map<String, String>)dimMap);
        }).collect(Collectors.toList());
    }

    private boolean isValidMetric(IModelCacheHelper modelCache, Map<String, String> dimMap) {
        String metricNum = dimMap.get(SysDimensionEnum.Metric.getNumber());
        Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNum);
        if (member == null) {
            return false;
        }
        return ForecastPluginConstants.validMetricSet.contains(member.getDatatype());
    }

    private void initPredTimeRange(List<Map<String, String>> cellDimNumList, IModelCacheHelper modelCache, PredParam predParam) {
        MemberDto memberDto;
        Member minBpMember = null;
        Member maxBpMember = null;
        for (Map<String, String> cellDimNumMap : cellDimNumList) {
            String bpMemNum = cellDimNumMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, bpMemNum);
            if (minBpMember == null || maxBpMember == null) {
                minBpMember = member;
                maxBpMember = member;
                continue;
            }
            if (member.getLevel() > minBpMember.getLevel()) {
                minBpMember = member;
                maxBpMember = member;
                continue;
            }
            if (member.getLevel() != minBpMember.getLevel()) continue;
            if (member.getSeq() < minBpMember.getSeq()) {
                minBpMember = member;
                continue;
            }
            if (member.getSeq() <= maxBpMember.getSeq()) continue;
            maxBpMember = member;
        }
        if (minBpMember != null) {
            memberDto = new MemberDto();
            memberDto.setNumber(minBpMember.getNumber());
            memberDto.setName(minBpMember.getName());
            predParam.setBpStart(memberDto);
        }
        if (maxBpMember != null) {
            memberDto = new MemberDto();
            memberDto.setNumber(maxBpMember.getNumber());
            memberDto.setName(maxBpMember.getName());
            predParam.setBpEnd(memberDto);
        }
    }

    private void initPredTarget(IModelCacheHelper modelCache, List<Dimension> dimensionList, Map<String, Long> dimViewMap, List<Map<String, String>> validDimNumList, PredParam predParam, Map<String, String> dataUnitMap) {
        if (CollectionUtils.isEmpty(validDimNumList)) {
            predParam.setTargets(new ArrayList());
            return;
        }
        Long modelId = this.getModelId();
        List<String> nameSortDimList = this.calcNameSortDim(validDimNumList);
        Map<String, String> defaultSettingParam = this.getDimFromSettingParam(predParam, modelId);
        String dimView = JSONObject.toJSONString(dimViewMap);
        List targets = validDimNumList.stream().map(allDimNum -> {
            HashMap<String, String> sampleDimNumMap = new HashMap<String, String>((Map<String, String>)allDimNum);
            sampleDimNumMap.putAll(defaultSettingParam);
            ArrayList memberName = new ArrayList(nameSortDimList.size());
            nameSortDimList.forEach(dimNumber -> {
                String memberNum = (String)allDimNum.get(dimNumber);
                Member member = modelCache.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), memberNum);
                memberName.add(member == null ? "" : member.getName());
            });
            long dimHashId = PredictHelper.calcDimHashId((List)dimensionList, (Map)allDimNum);
            PredTarget target = new PredTarget();
            target.setHashId(String.valueOf(dimHashId));
            target.setName(StringUtils.join(memberName, (String)","));
            target.setNumber(JSON.toJSONString((Object)allDimNum));
            target.setSampleName(this.setMemberNames(modelCache, dimensionList, sampleDimNumMap, dimViewMap));
            target.setSampleNumber(JSON.toJSONString(sampleDimNumMap));
            target.setDataUnit(PredictHelper.getMetricUnit((String)((String)allDimNum.get(SysDimensionEnum.Metric.getNumber())), (Map)dataUnitMap));
            target.setDimView(dimView);
            return target;
        }).collect(Collectors.toList());
        predParam.setTargets(targets);
    }

    private List<String> calcNameSortDim(List<Map<String, String>> validDimNumList) {
        LinkedHashMap filterDimMember = new LinkedHashMap(16);
        validDimNumList.forEach(dim -> {
            for (Map.Entry dimMap : dim.entrySet()) {
                String dimNumber = (String)dimMap.getKey();
                String memberNumber = (String)dimMap.getValue();
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
                Set memberNumbers = filterDimMember.computeIfAbsent(dimNumber, v -> new HashSet());
                memberNumbers.add(memberNumber);
            }
        });
        ArrayList<String> nameSortDimList = new ArrayList<String>();
        nameSortDimList.add(SysDimensionEnum.Account.getNumber());
        for (Map.Entry dimMap : filterDimMember.entrySet()) {
            if (((Set)dimMap.getValue()).size() <= 1) continue;
            nameSortDimList.add((String)dimMap.getKey());
        }
        return nameSortDimList;
    }

    private Map<String, String> getDimFromSettingParam(PredParam predParam, long modelId) {
        DynamicObject param = PredictParamService.getInstance().loadSingle(Long.valueOf(modelId));
        HashMap<String, String> dimNumbers = new HashMap<String, String>(2);
        if (param == null) {
            dimNumbers.put(SysDimensionEnum.DataType.getNumber(), "Actual");
            dimNumbers.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
        } else {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            String dataType = param.getString("datatype.number");
            Member dataTypeMember = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), null, dataType);
            if (dataTypeMember == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8bbe\u7f6e\u7ef4\u5ea6\uff1a\u6570\u636e\u7c7b\u578b\u7684\u6210\u5458\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u9ed8\u8ba4\u8bbe\u7f6e\u91cd\u65b0\u914d\u7f6e\u3002", (String)"ForecastPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String version = param.getString("version.number");
            Member versionMember = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, version);
            if (versionMember == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8bbe\u7f6e\u7ef4\u5ea6\uff1a\u7248\u672c\u7684\u6210\u5458\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u9ed8\u8ba4\u8bbe\u7f6e\u91cd\u65b0\u914d\u7f6e\u3002", (String)"ForecastPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            dimNumbers.put(SysDimensionEnum.DataType.getNumber(), dataType);
            dimNumbers.put(SysDimensionEnum.Version.getNumber(), version);
            if (predParam != null) {
                predParam.setBpNum(Integer.valueOf(param.getInt("samplelen")));
                predParam.setUseModel(param.getString("usemodel"));
                predParam.setReqType(param.getString("reqtype"));
            }
        }
        return dimNumbers;
    }

    private String setMemberNames(IModelCacheHelper modelCache, List<Dimension> dimensionList, Map<String, String> allDimNum, Map<String, Long> dimViewMap) {
        return dimensionList.stream().map(dimension -> {
            String dimNumber = dimension.getNumber();
            String memNumber = (String)allDimNum.get(dimNumber);
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || StringUtils.isEmpty((CharSequence)memNumber)) {
                return null;
            }
            Long viewId = IDUtils.toLong(dimViewMap.get(dimNumber));
            Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memNumber);
            if (member == null) {
                return null;
            }
            return member.getName();
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!Boolean.parseBoolean(this.getPageCache().get("showFloating"))) {
            this.doFullScreenEvent(true);
            this.getView().returnDataToParent((Object)Boolean.parseBoolean(this.getPageCache().get("isWrite")));
            IFormView parentView = this.getView().getParentView();
            parentView.setVisible(Boolean.valueOf(false), new String[]{"predictpanel"});
            parentView.getPageCache().put("predictShow", String.valueOf(false));
            this.getView().sendFormAction(parentView);
        } else {
            PredictCustomEvent.getInstance().sendCloseFloatingEvent(this.getView());
            if (Boolean.parseBoolean(this.getPageCache().get("isClose"))) {
                this.getView().returnDataToParent((Object)false);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        try {
            ForecastPluginConstants.Event event = ForecastPluginConstants.Event.find(eventName);
            switch (event) {
                case EVENT_CLOSE: {
                    this.doCloseEvent();
                    break;
                }
                case EVENT_FULL_SCREEN: {
                    boolean showFullScreen = Boolean.parseBoolean(this.getPageCache().get("showFullScreen"));
                    this.doFullScreenEvent(showFullScreen);
                    break;
                }
                case EVENT_SET_CELL_SAMPLE: {
                    this.openDimConfigPage(eventArgs);
                    break;
                }
                case EVENT_SET_CELL_PERIOD: {
                    this.openUnPeriodF7(eventArgs);
                    break;
                }
                case EVENT_SET_BP_START: 
                case EVENT_SET_BP_END: {
                    this.openPeriodF7Select(eventName, eventArgs);
                    break;
                }
                case EVENT_START_PREDICT: {
                    this.startPredict(eventArgs);
                    this.cacheEditStatus(false);
                    break;
                }
                case EVENT_CANCEL_PREDICT: {
                    this.cancelPredict(eventArgs);
                    break;
                }
                case EVENT_OPEN_FACTOR: 
                case EVENT_ADD_FACTOR: {
                    this.openFactor(eventName, eventArgs);
                    break;
                }
                case EVENT_REFRESH_FACTOR: {
                    this.refreshFactor(eventArgs);
                    break;
                }
                case EVENT_NOT_NEED_GUIDE: {
                    PredictGuideService.getInstance().save();
                    break;
                }
                case EVENT_GET_PREDICT_RECORD: {
                    this.getPredictRecordInfo(eventArgs);
                    break;
                }
                case EVENT_QUERY_PREDICT_RESULT: {
                    JSONObject param = JSON.parseObject((String)eventArgs);
                    String recordId = param.getString("recordId");
                    Integer page = param.getInteger("page");
                    this.queryPredictResult(recordId, page, null);
                    break;
                }
                case EVENT_QUERY_PREV_RESULT: {
                    this.queryPrevResult(eventArgs);
                    break;
                }
                case EVENT_QUERY_DIFF_DATA: {
                    this.queryCurrDataAndDiff(eventArgs);
                    break;
                }
                case EVENT_BACKGROUND_RUN: {
                    this.dispatch(eventArgs);
                    break;
                }
                case EVENT_ADD_OR_REPLACE_TARGET: {
                    this.addOrReplaceTarget(eventArgs);
                    break;
                }
                case EVENT_BATCH_ADD_TARGET: {
                    this.batchAddTarget(eventArgs);
                    break;
                }
                case EVENT_DEL_ROW_TARGET: {
                    this.delRowTarget(eventArgs);
                    break;
                }
                case EVENT_SWITCH_FLOATING: {
                    String formId = this.getView().getParentView().getFormShowParameter().getFormId();
                    CommandParam cmd = new CommandParam("eb_predict_sidebar", formId, "switchFloating", new Object[]{eventArgs, this.getView().getFormShowParameter().getCustomParams()});
                    this.sendMsg(this.getView(), cmd);
                    break;
                }
                case EVENT_REWRITE_ALL: {
                    this.getPageCache().put("event_param", eventArgs);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5bf9\u5f53\u524d\u6240\u6709\u9884\u6d4b\u5bf9\u8c61\u7684\u9884\u6d4b\u503c\u56de\u5199\u81f3\u6570\u636e\u5e93\uff0c\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002\u5df2\u6570\u636e\u9501\u5b9a\u3001\u5b58\u5728\u4e1a\u52a1\u89c4\u5219\u3001\u975e\u660e\u7ec6\u7ec4\u5408\u6216\u65e0\u6570\u636e\u6210\u5458\u6743\u9650\u7b49\u60c5\u51b5\u5c06\u65e0\u6cd5\u56de\u5199\u3002\u786e\u5b9a\u8981\u5168\u90e8\u56de\u5199\u5417\uff1f", (String)"ForecastPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("writeAllConfirmCallBack", (IFormPlugin)this));
                    break;
                }
                case EVENT_REWRITE: {
                    this.getPageCache().put("event_param", eventArgs);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5bf9\u6240\u9009\u4e2d\u884c\u9884\u6d4b\u5bf9\u8c61\u7684\u9884\u6d4b\u503c\u56de\u5199\u81f3\u6570\u636e\u5e93\uff0c\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002\u5df2\u6570\u636e\u9501\u5b9a\u3001\u5b58\u5728\u4e1a\u52a1\u89c4\u5219\u3001\u975e\u660e\u7ec6\u7ec4\u5408\u6216\u65e0\u6570\u636e\u6210\u5458\u6743\u9650\u7b49\u60c5\u51b5\u5c06\u65e0\u6cd5\u56de\u5199\u3002\u786e\u5b9a\u8981\u56de\u5199\u5417\uff1f", (String)"ForecastResultPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("writeConfirmCallBack", (IFormPlugin)this));
                    break;
                }
                case EVENT_EDIT_STATUS: {
                    this.syncEditStatus(eventArgs);
                }
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        PredTarget target;
        Integer rowIndex;
        JSONObject json;
        String data;
        String actionId = e.getActionId();
        if ("configCloseCallback".equals(actionId) && e.getReturnData() instanceof Map) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
            Map allDimNum = (Map)e.getReturnData();
            data = this.getPageCache().get(CURR_ROW_DATA);
            json = JSON.parseObject((String)data);
            rowIndex = json.getInteger("rowIndex");
            target = (PredTarget)JSON.parseObject((String)json.getString("target"), PredTarget.class);
            Map viewMap = PredictHelper.getViewMap((String)target.getDimView());
            target.setSampleNumber(JSON.toJSONString((Object)allDimNum));
            target.setSampleName(this.setMemberNames(modelCache, dimensionList, allDimNum, viewMap));
            PredictCustomEvent.getInstance().sendDataUpdateRow(this.getView(), rowIndex, target);
        }
        if ("periodCloseCallback".equals(actionId) && e.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)e.getReturnData();
            List names = selectedRows.stream().map(ListSelectedRow::getName).collect(Collectors.toList());
            List numbers = selectedRows.stream().map(ListSelectedRow::getNumber).collect(Collectors.toList());
            data = this.getPageCache().get(CURR_ROW_DATA);
            json = JSON.parseObject((String)data);
            rowIndex = json.getInteger("rowIndex");
            target = (PredTarget)JSON.parseObject((String)json.getString("target"), PredTarget.class);
            target.setUnPeriodName(StringUtils.join(names, (String)","));
            target.setUnPeriodNumber(JSON.toJSONString(numbers));
            PredictCustomEvent.getInstance().sendDataUpdateRow(this.getView(), rowIndex, target);
        }
        if ((actionId.equals(ForecastPluginConstants.Event.EVENT_SET_BP_START.getName()) || actionId.equals(ForecastPluginConstants.Event.EVENT_SET_BP_END.getName())) && e.getReturnData() instanceof ListSelectedRowCollection && ((ListSelectedRowCollection)e.getReturnData()).size() > 0) {
            ListSelectedRow row = ((ListSelectedRowCollection)e.getReturnData()).get(0);
            MemberDto memberDto = new MemberDto();
            memberDto.setId(row.getPrimaryKeyValue().toString());
            memberDto.setName(row.getName());
            memberDto.setNumber(row.getNumber());
            if (actionId.equals(ForecastPluginConstants.Event.EVENT_SET_BP_START.getName())) {
                PredictCustomEvent.getInstance().sendDataBpStartEvent(this.getView(), memberDto);
            } else {
                PredictCustomEvent.getInstance().sendDataBpEndEvent(this.getView(), memberDto);
            }
        }
        if ("paramFactorCloseCallback".equals(actionId) && e.getReturnData() instanceof String && StringUtils.isNotEmpty((CharSequence)((String)e.getReturnData()))) {
            String returnData = (String)e.getReturnData();
            List factors = JSONObject.parseArray((String)returnData, PredFactor.class);
            PredictCustomEvent.getInstance().sendDataFactorsEvent(this.getView(), factors);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            if ("writeAllConfirmCallBack".equals(key)) {
                this.resultAllWrite();
            } else if ("writeConfirmCallBack".equals(key)) {
                this.resultWrite();
            }
        }
    }

    private void doCloseEvent() {
        this.getView().close();
    }

    private void doFullScreenEvent(boolean showFullScreen) {
        IFormView parentView = this.getView().getParentView();
        String formId = this.getView().getParentView().getFormShowParameter().getFormId();
        if ("eb_analysiscanvas_design".equals(formId)) {
            parentView.setVisible(Boolean.valueOf(showFullScreen), new String[]{"splitcontainerap"});
        } else if ("bgm_rptpreparation".equals(formId) || "eb_executetask".equals(formId) || "eb_reportquery_new".equals(formId)) {
            parentView.setVisible(Boolean.valueOf(showFullScreen), new String[]{"flexpanelap8"});
        }
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey("predictpanel");
        flex.setGrow(0);
        flex.setShrink(0);
        flex.setDirection("column");
        flex.setWrap(false);
        flex.setWidth(showFullScreen ? new LocaleString("702px") : new LocaleString("100%"));
        parentView.updateControlMetadata("predictpanel", flex.createControl());
        this.getPageCache().put("showFullScreen", String.valueOf(!showFullScreen));
        this.getView().sendFormAction(parentView);
        PredictCustomEvent.getInstance().sendDataEvent(this.getView(), null, PropsDataType.REFRESH_CHART);
    }

    private void openDimConfigPage(String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        PredTarget target = (PredTarget)JSON.parseObject((String)json.getString("target"), PredTarget.class);
        String sampleNumber = target.getSampleNumber();
        if (StringUtils.isEmpty((CharSequence)sampleNumber)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_forecast_conf");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("bizmodel", (Object)this.getPageCache().get("bizmodel"));
        showParameter.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        showParameter.setCustomParam("dim_member", (Object)sampleNumber);
        showParameter.setCustomParam("dim_view", (Object)target.getDimView());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "configCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getPageCache().put(CURR_ROW_DATA, eventArgs);
        this.getView().showForm(showParameter);
    }

    private void openPeriodF7Select(String eventName, String eventArgs) {
        MemberDto memberDto = (MemberDto)JSON.parseObject((String)eventArgs, MemberDto.class);
        String dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        Long modelId = this.getModelId();
        Long bizModelId = IDUtils.toLong((Object)this.getPageCache().get("bizmodel"));
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bizModelId);
        f7Param.setDatasetId(dataSetId);
        f7Param.setReturnAllData(true);
        f7Param.setCutTree(false);
        if (memberDto != null) {
            IModelCacheHelper modelCache;
            Member member;
            Long selectedId = IDUtils.toLong((Object)memberDto.getId());
            if (IDUtils.isEmptyLong((Long)selectedId).booleanValue() && (member = (modelCache = ModelCacheContext.getOrCreate((Long)modelId)).getMember(dimNumber, null, memberDto.getNumber())) != null) {
                selectedId = member.getId();
            }
            f7Param.setSelectId(selectedId);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, eventName);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private void openUnPeriodF7(String eventArgs) {
        this.getPageCache().put(CURR_ROW_DATA, eventArgs);
        JSONObject json = JSON.parseObject((String)eventArgs);
        PredTarget target = (PredTarget)JSON.parseObject((String)json.getString("target"), PredTarget.class);
        if (StringUtils.isEmpty((CharSequence)target.getNumber())) {
            return;
        }
        String dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        Long modelId = this.getModelId();
        Long bizModelId = IDUtils.toLong((Object)this.getPageCache().get("bizmodel"));
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bizModelId);
        f7Param.setDatasetId(dataSetId);
        f7Param.setReturnAllData(true);
        f7Param.setCutTree(false);
        f7Param.setMultiSelect(true);
        f7Param.setSelectIds(this.getPeriodIds(modelId, dimNumber, target.getUnPeriodNumber()));
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "periodCloseCallback"));
    }

    private void startPredict(String eventArgs) {
        PredParam predParam = (PredParam)JSON.parseObject((String)eventArgs, PredParam.class);
        if (!this.check(predParam)) {
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        Long modelId = this.getModelId();
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        Long canvasId = IDUtils.toLong((Object)this.getPageCache().get("canvasid"));
        Long sandboxId = IDUtils.toLong((Object)this.getPageCache().get("sandboxid"));
        Long processId = IDUtils.toLong((Object)this.getPageCache().get("processid"));
        String appId = "eb";
        String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
        long recordId = (Long)DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"PredictService", (String)"predict", (Object[])new Object[]{eventArgs, modelId, datasetId, 0L, processId, canvasId, sandboxId});
        JSONObject json = new JSONObject();
        json.fluentPut("componentName", (Object)"ing");
        json.fluentPut("recordId", (Object)String.valueOf(recordId));
        PredictCustomEvent.getInstance().sendDataEvent(this.getView(), json, PropsDataType.DOING_PREDICT);
        this.getPageCache().put("isWrite", predParam.getAutoWrite().toString());
        List memoryFactors = predParam.getFactors().stream().filter(e -> StringUtils.isEmpty((CharSequence)e.getFactorId())).collect(Collectors.toList());
        PredictMemoryService.getInstance().save(datasetId, memoryFactors);
    }

    private void cancelPredict(String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        String recordId = json.getString("recordId");
        PredParam predParam = (PredParam)JSONObject.parseObject((String)json.getString("predictGuide"), PredParam.class);
        if (IDUtils.isNotEmptyLong((Long)IDUtils.toLong((Object)recordId)).booleanValue()) {
            PredictRecordService.getInstance().cancel(IDUtils.toLong((Object)recordId).longValue());
        }
        PredictCustomEvent.getInstance().sendDataInitEvent(this.getView(), predParam);
    }

    private void openFactor(String eventName, String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        List factors = JSON.parseArray((String)json.getString("factors"), PredFactor.class);
        Integer rowIndex = json.getInteger("rowIndex");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_predict_param_factor");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "paramFactorCloseCallback"));
        fsp.setStatus(OperationStatus.ADDNEW);
        if (eventName.equals(ForecastPluginConstants.Event.EVENT_OPEN_FACTOR.getName())) {
            fsp.setCustomParam("factor", (Object)JSON.toJSONString(factors.get(rowIndex)));
            fsp.setCustomParam("rowIndex", (Object)rowIndex);
            fsp.setCustomParam("factors", (Object)json.getString("factors"));
        } else {
            fsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            fsp.setCustomParam("factors", (Object)json.getString("factors"));
        }
        this.getView().showForm(fsp);
    }

    private void refreshFactor(String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        List factors = JSON.parseArray((String)json.getString("factors"), PredFactor.class);
        List predTargetList = JSON.parseArray((String)json.getString("targets"), PredTarget.class);
        Long modelId = this.getModelId();
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        List validDimNumList = predTargetList.stream().filter(e -> e != null && e.getDataUnit() != null).map(e -> PredictHelper.json2Map((String)e.getNumber())).collect(Collectors.toList());
        Set targetIds = PredictParamTargetService.getInstance().matchParamTarget(modelId, datasetId, modelCache, dimensionList, validDimNumList);
        List predFactors = PredictParamFactorService.getInstance().queryFactor(targetIds);
        factors.addAll(predFactors);
        List memoryFactors = PredictMemoryService.getInstance().queryMemory(datasetId);
        factors.addAll(memoryFactors);
        List distinctFactors = factors.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), ArrayList::new));
        PredictCustomEvent.getInstance().sendDataFactorsEvent(this.getView(), distinctFactors);
    }

    private void resultAllWrite() {
        String recordId = this.getPageCache().get("event_param");
        DynamicObjectCollection dyObjs = PredictResultService.getInstance().querySuccessResult(IDUtils.toLong((Object)recordId).longValue());
        List resultIds = dyObjs.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        List predModelList = PredictResultService.getInstance().query(resultIds);
        this.doResultWrite(IDUtils.toLong((Object)recordId), predModelList);
    }

    private void resultWrite() {
        JSONObject json = JSON.parseObject((String)this.getPageCache().get("event_param"));
        String recordId = json.getString("recordId");
        JSONArray ids = json.getJSONArray("ids");
        List resultIds = ids.stream().map(v -> IDUtils.toLong((Object)v.toString())).collect(Collectors.toList());
        List predModelList = PredictResultService.getInstance().query(resultIds);
        this.doResultWrite(IDUtils.toLong((Object)recordId), predModelList);
    }

    private void doResultWrite(long recordId, List<PredModel> predModelList) {
        if (CollectionUtils.isNotEmpty(predModelList)) {
            PredictRecord record = PredictRecordService.getInstance().load(recordId);
            long modelId = record.getModel();
            long datasetId = record.getDataset();
            Long canvasId = record.getCanvasId();
            Long sandboxId = record.getSandboxId();
            WriteService.getInstance().write(modelId, datasetId, canvasId, sandboxId, predModelList);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u9884\u6d4b\u56de\u5199\u6570\u636e", "ForecastPlugin_20", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u9884\u6d4b\u6570\u636e\u56de\u5199\u5230\u6570\u636e\u5e93\u3002", "ForecastPlugin_21", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getModel().getDataEntityType().getName(), null, (String)"forecast", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u5199\u6210\u529f\u3002", (String)"ForecastPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("isWrite", Boolean.TRUE.toString());
            this.refreshParentData();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9884\u6d4b\u6570\u636e\uff0c\u8bf7\u5148\u9884\u6d4b\u518d\u56de\u5199\u3002", (String)"ForecastPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean check(PredParam predParam) {
        if (CollectionUtils.isEmpty((Collection)predParam.getTargets())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u9884\u6d4b\u76ee\u6807\u6570\u636e\u3002", (String)"ForecastPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        List targetList = predParam.getTargets().stream().filter(target -> StringUtils.isNotBlank((CharSequence)target.getHashId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(targetList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u9884\u6d4b\u76ee\u6807\u6570\u636e\u3002", (String)"ForecastPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        predParam.setTargets(targetList);
        MemberDto bpStart = predParam.getBpStart();
        if (bpStart == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u6d4b\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ForecastPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        MemberDto bpEnd = predParam.getBpEnd();
        if (bpEnd == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u6d4b\u5468\u671f\u7ed3\u675f\u65f6\u95f4\u3002", (String)"ForecastPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String bgStartNumber = bpStart.getNumber();
        String bgEndNumber = bpEnd.getNumber();
        Member startMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, bgStartNumber);
        Member endMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, bgEndNumber);
        if (startMember.getLevel() != endMember.getLevel()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5c42\u7ea7\u7684\u9884\u6d4b\u6570\u636e\u7684\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"ForecastPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (startMember.getSeq() > endMember.getSeq()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6d4b\u5468\u671f\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ForecastPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        List predBgList = modelCache.getMemberBetween(SysDimensionEnum.BudgetPeriod.getNumber(), startMember.getNumber(), endMember.getNumber(), true);
        if (predBgList.size() > 48) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6d4b\u5468\u671f\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc748\u3002", (String)"ForecastPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Integer sampleLen = predParam.getBpNum();
        if (sampleLen == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6837\u672c\u6570\u636e\u671f\u6570\u3002", (String)"ForecastPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("lstm".equals(predParam.getUseModel()) && sampleLen < predBgList.size() * 2 + 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Lstm\u7b97\u6cd5\u8bf7\u8bbe\u7f6e\u6837\u672c\u6570\u636e\u671f\u6570>\u9884\u6d4b\u5468\u671f\u6570\u91cf*2+1\u3002", (String)"ForecastPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Member sampleStartMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), bgStartNumber, -sampleLen.intValue());
        Member sampleEndMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), bgStartNumber, -1);
        if (sampleStartMember == null || sampleEndMember == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6837\u672c\u671f\u95f4\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u6837\u672c\u6570\u636e\u671f\u6570\u3002", (String)"ForecastPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (PredTarget p2 : predParam.getTargets()) {
            String numbers = p2.getUnPeriodNumber();
            if (StringUtils.isEmpty((CharSequence)numbers)) continue;
            List members = JSON.parseArray((String)numbers, String.class);
            for (String number : members) {
                Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, number);
                if (member.getLevel() == startMember.getLevel()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0e\u9884\u6d4b\u5468\u671f\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u76f8\u540c\u5c42\u7ea7\u7684\u5f02\u5e38\u671f\u95f4\u3002", (String)"ForecastPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (predParam.getTargets().stream().anyMatch(p -> StringUtils.isNotEmpty((CharSequence)p.getUnPeriodNumber())) && StringUtils.isEmpty((CharSequence)predParam.getUnFill())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f02\u5e38\u671f\u95f4\u7684\u6570\u636e\u5904\u7406\u7c7b\u578b\u3002", (String)"ForecastPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Set<Long> getPeriodIds(Long modelId, String dimNumber, String numbers) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        if (StringUtils.isNotEmpty((CharSequence)numbers)) {
            List numberList = JSON.parseArray((String)numbers, String.class);
            LinkedHashSet<Long> numberSet = new LinkedHashSet<Long>(numberList.size());
            numberList.forEach(e -> numberSet.add(modelCache.getMember(dimNumber, null, e).getId()));
            return numberSet;
        }
        return Collections.emptySet();
    }

    private void addOrReplaceTarget(String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        Integer index = json.getInteger("index");
        DimInfoDto dimInfo = (DimInfoDto)JSONObject.parseObject((String)json.getString("cellClickData"), DimInfoDto.class);
        dimInfo.setUnitSetting(PredictHelper.getUnitSetting((JSONObject)JSONObject.parseObject((String)json.getString("cellClickData")).getJSONObject("unitSetting")));
        PredParam predParam = (PredParam)JSONObject.parseObject((String)json.getString("guideData"), PredParam.class);
        Long modelId = dimInfo.getModelId();
        Long datasetId = dimInfo.getDatasetId();
        if (!Objects.equals(datasetId, IDUtils.toLong((Object)this.getPageCache().get("dataset")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PredictSidebarPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        List memberInfoList = dimInfo.getMemberInfoList().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(memberInfoList) || !this.isValidMetric(modelCache, (Map)memberInfoList.get(0))) {
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        Map allDimNum = (Map)memberInfoList.get(0);
        Long dimHashId = PredictHelper.calcDimHashId((List)dimensionList, (Map)allDimNum);
        List<PredTarget> targets = predParam.getTargets();
        if (targets.stream().filter(Objects::nonNull).anyMatch(e -> dimHashId.toString().equals(e.getHashId()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u9884\u6d4b\u76ee\u6807\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PredictSidebarPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        Map unitSetting = dimInfo.getUnitSetting();
        Map dataUnitMap = PredictHelper.getDataUnitMap((Map)unitSetting, (String)dimInfo.getDataUnit());
        PredTarget predTarget = this.cellDataToTarget(dimHashId, dimInfo.getViewMap(), allDimNum, PredictHelper.getMetricUnit((String)((String)allDimNum.get(SysDimensionEnum.Metric.getNumber())), (Map)dataUnitMap));
        targets.set(index, predTarget);
        targets = targets.stream().filter(target -> StringUtils.isNotBlank((CharSequence)target.getHashId())).collect(Collectors.toList());
        this.rebuildTargetList(modelCache, dimensionList, targets);
        this.calcFactor(predParam, modelId, datasetId, modelCache, dimensionList, targets, predParam.getFactors());
    }

    private void batchAddTarget(String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        DimInfoDto dimInfo = (DimInfoDto)JSONObject.parseObject((String)json.getString("cellClickData"), DimInfoDto.class);
        dimInfo.setUnitSetting(PredictHelper.getUnitSetting((JSONObject)JSONObject.parseObject((String)json.getString("cellClickData")).getJSONObject("unitSetting")));
        PredParam predParam = (PredParam)JSONObject.parseObject((String)json.getString("guideData"), PredParam.class);
        Long modelId = dimInfo.getModelId();
        Long datasetId = dimInfo.getDatasetId();
        if (!Objects.equals(datasetId, IDUtils.toLong((Object)this.getPageCache().get("dataset")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PredictSidebarPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        LinkedHashMap dimHashMap = dimInfo.getMemberInfoList().stream().filter(e -> e != null && this.isValidMetric(modelCache, (Map<String, String>)e)).collect(Collectors.toMap(v -> PredictHelper.calcDimHashId((List)dimensionList, (Map)v), p -> p, (k1, k2) -> k2, LinkedHashMap::new));
        if (MapUtils.isEmpty((Map)dimHashMap)) {
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        List<PredTarget> targets = predParam.getTargets();
        ArrayList<PredTarget> predTargetList = new ArrayList<PredTarget>(dimHashMap.size());
        Map viewMap = dimInfo.getViewMap();
        String dataUnit = dimInfo.getDataUnit();
        Map unitSetting = dimInfo.getUnitSetting();
        Map dataUnitMap = PredictHelper.getDataUnitMap((Map)unitSetting, (String)dataUnit);
        for (Map.Entry dimHash : dimHashMap.entrySet()) {
            Long dimHashId = (Long)dimHash.getKey();
            if (!targets.stream().filter(Objects::nonNull).noneMatch(e -> dimHashId.toString().equals(e.getHashId()))) continue;
            Map allDimNum = (Map)dimHash.getValue();
            PredTarget predTarget = this.cellDataToTarget(dimHashId, viewMap, allDimNum, PredictHelper.getMetricUnit((String)((String)allDimNum.get(SysDimensionEnum.Metric.getNumber())), (Map)dataUnitMap));
            predTargetList.add(predTarget);
        }
        if (CollectionUtils.isEmpty(predTargetList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u9884\u6d4b\u76ee\u6807\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PredictSidebarPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        targets.addAll(predTargetList);
        targets = targets.stream().filter(target -> StringUtils.isNotBlank((CharSequence)target.getHashId())).collect(Collectors.toList());
        this.rebuildTargetList(modelCache, dimensionList, targets);
        this.calcFactor(predParam, modelId, datasetId, modelCache, dimensionList, targets, predParam.getFactors());
    }

    private void delRowTarget(String eventArgs) {
        PredParam predParam = (PredParam)JSONObject.parseObject((String)eventArgs, PredParam.class);
        Long modelId = this.getModelId();
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        this.calcFactor(predParam, modelId, datasetId, modelCache, dimensionList, predParam.getTargets(), predParam.getFactors());
    }

    private void syncEditStatus(String eventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        Boolean rowEdit = jsonObject.getBoolean("rowEdit");
        Boolean batchEdit = jsonObject.getBoolean("batchEdit");
        boolean editStatus = rowEdit == false || batchEdit == false;
        this.cacheEditStatus(editStatus);
    }

    private void cacheEditStatus(boolean status) {
        this.getPageCache().put("editStatus", String.valueOf(status));
    }

    private boolean getEditStatus() {
        String str = this.getPageCache().get("editStatus");
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                return Boolean.parseBoolean(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void calcFactor(PredParam predParam, Long modelId, Long datasetId, IModelCacheHelper modelCache, List<Dimension> dimensionList, List<PredTarget> predTargetList, List<PredFactor> oldFactors) {
        List validDimNumList = predTargetList.stream().filter(e -> e != null && e.getDataUnit() != null).map(e -> PredictHelper.json2Map((String)e.getNumber())).collect(Collectors.toList());
        Set targetIds = PredictParamTargetService.getInstance().matchParamTarget(modelId, datasetId, modelCache, dimensionList, validDimNumList);
        List predFactors = PredictParamFactorService.getInstance().queryFactor(targetIds);
        List customFactor = oldFactors.stream().filter(e -> StringUtils.isEmpty((CharSequence)e.getFactorId())).collect(Collectors.toList());
        predFactors.addAll(customFactor);
        List distinctFactors = predFactors.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), ArrayList::new));
        predParam.setFactors(distinctFactors);
        PredictCustomEvent.getInstance().sendDataInitEvent(this.getView(), predParam);
    }

    private PredTarget cellDataToTarget(Long dimHashId, Map<String, Long> dimViewMap, Map<String, String> allDimNum, String dataUnit) {
        PredTarget predTarget = new PredTarget();
        predTarget.setHashId(dimHashId.toString());
        predTarget.setNumber(JSON.toJSONString(allDimNum));
        predTarget.setDataUnit(dataUnit);
        predTarget.setDimView(JSONObject.toJSONString(dimViewMap));
        return predTarget;
    }

    private void rebuildTargetList(IModelCacheHelper modelCache, List<Dimension> dimensionList, List<PredTarget> targets) {
        List<Map<String, String>> validDimNumList = targets.stream().filter(Objects::nonNull).map(e -> PredictHelper.json2Map((String)e.getNumber())).collect(Collectors.toList());
        Long modelId = this.getModelId();
        List<String> nameSortDimList = this.calcNameSortDim(validDimNumList);
        Map<String, String> dimFromSettingParam = this.getDimFromSettingParam(null, modelId);
        targets.forEach(target -> {
            if (target == null) {
                return;
            }
            Map allDimNum = PredictHelper.json2Map((String)target.getNumber());
            Map dimViewMap = PredictHelper.getViewMap((String)target.getDimView());
            ArrayList memberName = new ArrayList(nameSortDimList.size());
            nameSortDimList.forEach(dimNumber -> {
                String memberNum = (String)allDimNum.get(dimNumber);
                Member member = modelCache.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), memberNum);
                memberName.add(member == null ? "" : member.getName());
            });
            target.setName(StringUtils.join(memberName, (String)","));
            if (target.getSampleNumber() == null) {
                HashMap<String, String> sampleDimNumMap = new HashMap<String, String>(allDimNum);
                sampleDimNumMap.putAll(dimFromSettingParam);
                target.setSampleName(this.setMemberNames(modelCache, dimensionList, sampleDimNumMap, dimViewMap));
                target.setSampleNumber(JSON.toJSONString(sampleDimNumMap));
            }
        });
    }

    private void getPredictRecordInfo(String recordId) {
        boolean complete = PredictRecordService.getInstance().isComplete(IDUtils.toLong((Object)recordId).longValue());
        if (!complete) {
            this.queryPredictData(IDUtils.toLong((Object)recordId));
        }
        JSONObject result = new JSONObject();
        result.fluentPut("componentName", (Object)(complete ? "result" : "ing"));
        result.fluentPut("complete", (Object)complete);
        PredictCustomEvent.getInstance().sendDataEvent(this.getView(), result, PropsDataType.RECORD_INFO);
        if (complete && Boolean.parseBoolean(this.getPageCache().get("isWrite"))) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u9884\u6d4b\u56de\u5199\u6570\u636e", "ForecastPlugin_20", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u9884\u6d4b\u6570\u636e\u81ea\u52a8\u56de\u5199\u5230\u6570\u636e\u5e93", "ForecastPlugin_23", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getModel().getDataEntityType().getName(), null, (String)"forecast", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
            this.refreshParentData();
        }
    }

    private void queryPredictResult(String recordId, Integer page, PredParam predParam) {
        Long modelId = this.getModelId();
        List predModelList = PredictResultService.getInstance().queryRecordResult(modelId, IDUtils.toLong((Object)recordId).longValue(), page.intValue());
        List resultData = predModelList.stream().map(predModel -> {
            JSONObject targetMem = new JSONObject().fluentPut("hashId", (Object)String.valueOf(predModel.getDimHash())).fluentPut("name", (Object)predModel.getName());
            JSONObject dataObj = new JSONObject();
            dataObj.put("predModel", predModel);
            dataObj.put("targets", (Object)targetMem);
            dataObj.put("dataUnitStr", (Object)PredictHelper.getDataUnitStr((String)predModel.getDataUnit()));
            dataObj.put("active", (Object)false);
            if (ForecastConstants.Status.SUCCESS.getValue().equals(predModel.getStatus())) {
                List timeRangeList = ForecastChartHelper.formatTime((List)predModel.getSampleIndexList(), (int)predModel.getPeriodType());
                timeRangeList.addAll(ForecastChartHelper.formatTime((List)predModel.getPredIndexList(), (int)predModel.getPeriodType()));
                dataObj.put("xAxis", (Object)timeRangeList);
            }
            return dataObj;
        }).collect(Collectors.toList());
        JSONObject result = new JSONObject();
        result.fluentPut("componentName", (Object)"result");
        result.fluentPut("recordId", (Object)recordId);
        result.fluentPut("page", (Object)page);
        result.fluentPut("hasNextPage", (Object)PredictResultService.getInstance().hasNextPage(modelId.longValue(), page.intValue()));
        result.fluentPut("resultData", resultData);
        result.fluentPut("predictGuide", (Object)predParam);
        result.fluentPut("i18n", PredictSideBarI18N.getInstance().getI18NData());
        PredictCustomEvent.getInstance().sendDataEvent(this.getView(), result, PropsDataType.PREDICT_RESULT);
    }

    private void queryPrevResult(String eventArgs) {
        JSONObject param = JSON.parseObject((String)eventArgs);
        String recordId = param.getString("recordId");
        String dimHashId = param.getString("dimHashId");
        JSONObject dataObj = new JSONObject();
        PredictRecord predictRecord = PredictRecordService.getInstance().load(IDUtils.toLong((Object)recordId).longValue());
        if (predictRecord != null) {
            PredModel prevPredModel = PredictRecordService.getInstance().queryPrevData(predictRecord.getModel().longValue(), Long.parseLong(dimHashId), predictRecord.getSchemeId(), predictRecord.getProcessId(), predictRecord.getCanvasId());
            if (prevPredModel == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0a\u6b21\u9884\u6d4b\u7ed3\u679c\u3002", (String)"PredictSidebarPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
                return;
            }
            dataObj.put("predModel", (Object)prevPredModel);
            if (ForecastConstants.Status.SUCCESS.getValue().equals(prevPredModel.getStatus())) {
                List timeRangeList = ForecastChartHelper.formatTime((List)prevPredModel.getSampleIndexList(), (int)prevPredModel.getPeriodType());
                timeRangeList.addAll(ForecastChartHelper.formatTime((List)prevPredModel.getPredIndexList(), (int)prevPredModel.getPeriodType()));
                dataObj.put("xAxis", (Object)timeRangeList);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0a\u6b21\u9884\u6d4b\u7ed3\u679c\u3002", (String)"PredictSidebarPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            PredictCustomEvent.getInstance().sendCleanEvent(this.getView());
            return;
        }
        JSONObject result = new JSONObject();
        result.fluentPut("recordId", (Object)recordId);
        result.fluentPut("dimHashId", (Object)dimHashId);
        result.fluentPut("resultData", (Object)dataObj);
        PredictCustomEvent.getInstance().sendDataEvent(this.getView(), result, PropsDataType.PREV_RESULT);
    }

    private void queryCurrDataAndDiff(String eventArgs) {
        JSONObject param = JSON.parseObject((String)eventArgs);
        String recordId = param.getString("recordId");
        String dimHashId = param.getString("dimHashId");
        JSONObject result = PredictRecordService.getInstance().queryCurrDataAndDiff(Long.parseLong(recordId), Long.parseLong(dimHashId));
        PredictCustomEvent.getInstance().sendDataEvent(this.getView(), result, PropsDataType.DIFF_DATA);
    }

    private void dispatch(String eventArgs) {
        JSONObject param = JSON.parseObject((String)eventArgs);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        Long canvasId = IDUtils.toLong((Object)this.getPageCache().get("canvasid"));
        Long templateId = IDUtils.toLong((Object)this.getPageCache().get("templateId"));
        String predictGuide = param.getString("predictGuide");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.epm.eb.business.forecast.PredictTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 80);
        params.put("recordId", param.getString("recordId"));
        params.put("predictGuide", predictGuide);
        params.put("pageId", this.getView().getParentView().getPageId());
        params.put("formId", this.getView().getParentView().getFormShowParameter().getFormId());
        params.put("modelId", IDUtils.toLong((Object)this.getPageCache().get("model")));
        params.put("dataSetId", IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        params.put("canvasId", canvasId);
        params.put("sandboxId", IDUtils.toLong((Object)this.getPageCache().get("sandboxid")));
        params.put("schemeId", IDUtils.toLong((Object)this.getPageCache().get("schemeid")));
        params.put("processId", IDUtils.toLong((Object)this.getPageCache().get("processid")));
        params.put("taskProcessId", IDUtils.toLong((Object)this.getPageCache().get("taskprocessid")));
        params.put("processType", this.getPageCache().get("processtype"));
        params.put("templateId", templateId);
        PredParam predParam = (PredParam)JSONObject.parseObject((String)predictGuide, PredParam.class);
        if (IDUtils.isNotEmptyLong((Long)canvasId).booleanValue()) {
            String canvasName = AnalysisCanvasService.getInstance().queryName(canvasId);
            jobInfo.setName(ResManager.loadResFormat((String)"%1%2%3\u81f3%4", (String)"PredictSidebarPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{canvasName, "_", predParam.getBpStart().getName(), predParam.getBpEnd().getName()}));
        } else {
            DynamicObject template = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"name", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
            jobInfo.setName(ResManager.loadResFormat((String)"%1%2%3\u81f3%4", (String)"PredictSidebarPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{template.getString("name"), "_", predParam.getBpStart().getName(), predParam.getBpEnd().getName()}));
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        this.doTranBackground(taskId, jobInfo, closeCallBack);
        this.getView().close();
    }

    private void doTranBackground(String taskId, JobInfo jobInfo, CloseCallBack closeCallBack) {
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
            jobFormInfo.setParentPageId(this.getView().getPageId());
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setTimeout(3600);
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setClickClassName("kd.epm.eb.formplugin.forecast.task.PredictTaskClick");
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)"BOSSchedule-task-background-monitor", (Runnable)subscriber);
            }
        }
    }

    public void dealMsg(CommandParam command) {
        DimInfoDto dimInfo;
        if ("cellClick".equals(command.getOperation()) && "eb_analysiscanvas_design".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
            dimInfo = (DimInfoDto)command.getParam().get(0);
        } else {
            Map params = (Map)command.getParam().get(0);
            dimInfo = new DimInfoDto();
            dimInfo.setModelId((Long)params.get("modelId"));
            dimInfo.setDatasetId((Long)params.get("dataSetId"));
            dimInfo.setTemplateId((Long)params.get("templateId"));
            dimInfo.setDataUnit((String)params.get("dataunit"));
            dimInfo.setUnitSetting((Map)params.get("unitSetting"));
            ReportEditHelper reportEditHelper = new ReportEditHelper(this.getView());
            List selectedRange = reportEditHelper.getSelectedRange();
            Triple viewByRange = reportEditHelper.getDimensionViewByRange(selectedRange);
            if (this.getEditStatus() && (((Map)viewByRange.getMiddle()).size() > 1 || ((Map)viewByRange.getRight()).size() > 1) && (reportEditHelper.existsMultiView((Map)viewByRange.getMiddle()) || reportEditHelper.existsMultiView((Map)viewByRange.getRight()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u62a5\u8868\u533a\u57df\u540c\u4e00\u7ef4\u5ea6\u5b58\u5728\u591a\u4e2a\u89c6\u56fe\uff0c\u8bf7\u5206\u5f00\u9009\u62e9\u3002", (String)"PredictSidebarPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            dimInfo.setViewMap(reportEditHelper.getDimensionViewByCell((String)selectedRange.get(0)));
            dimInfo.setMemberInfoList(reportEditHelper.getMemberMapByRange(selectedRange));
        }
        Long modelId = dimInfo.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List memberInfoList = dimInfo.getMemberInfoList().stream().filter(Objects::nonNull).collect(Collectors.toList());
        Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, (String)((Map)memberInfoList.get(0)).get(SysDimensionEnum.Account.getNumber()));
        dimInfo.setMemberInfo((Map)ImmutableMap.of((Object)SysDimensionEnum.Account.getNumber(), (Object)member.getName()));
        List dimensionList = modelCache.getDimensionList(dimInfo.getDatasetId());
        Long dimHashId = PredictHelper.calcDimHashId((List)dimensionList, (Map)((Map)memberInfoList.get(0)));
        JSONObject json = new JSONObject();
        json.fluentPut("dimInfo", (Object)JSONObject.toJSONString((Object)dimInfo)).fluentPut("dimHashId", (Object)dimHashId.toString());
        PredictCustomEvent.getInstance().sendCellClickData(this.getView(), json);
    }

    private void refreshParentData() {
        String formId = this.getView().getParentView().getFormShowParameter().getFormId();
        CommandParam cmd = new CommandParam("eb_predict_sidebar", formId, "refreshData", new Object[0]);
        this.sendMsg(this.getView(), cmd);
    }

    private void queryPredictData(Long recordId) {
        if (PredictRecordService.getInstance().isPredict(recordId.longValue())) {
            String appId = "eb";
            String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
            DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"PredictService", (String)"queryPredictData", (Object[])new Object[]{recordId});
        }
    }
}

