/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ForecastHelper {
    public static Map<String, Long> getViewMap(String dimViewStr) {
        if (StringUtils.isEmpty((CharSequence)dimViewStr)) {
            return Collections.emptyMap();
        }
        JSONObject dimView = JSON.parseObject((String)dimViewStr);
        return dimView.entrySet().stream().filter(k -> !View.NoViewDimNums.contains(k.getKey())).collect(Collectors.toMap(v -> ((String)v.getKey()).contains("_") ? StringUtils.substring((String)((String)v.getKey()), (int)0, (int)((String)v.getKey()).lastIndexOf("_")) : (String)v.getKey(), v -> IDUtils.toLong(v.getValue()), (o1, o2) -> o2));
    }

    public static String buildDimensionCombName(IModelCacheHelper modelCache, Long datasetId, List<Dimension> dimensionList, JSONObject dimensionViews, JSONObject dimMembers) {
        Map<String, String> defaultMember = ForecastHelper.getDefaultMember();
        StringBuilder sb = new StringBuilder();
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            String members = dimMembers.getString(dimNumber);
            Long viewId = IDUtils.toLong((Object)dimensionViews.get((Object)dimNumber));
            if (StringUtils.isNotEmpty((CharSequence)members)) {
                List memberList = JSONObject.parseArray((String)members, MemberDto.class);
                List excitedMember = memberList.stream().filter(memberDto -> AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberDto.getNumber()) != null).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(excitedMember)) {
                    StringBuilder memberSb = new StringBuilder();
                    memberList.forEach(memberDto -> {
                        Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberDto.getNumber());
                        if (member == null) {
                            return;
                        }
                        ForecastHelper.buildMultiSelectF7ReturnValue(memberSb, member.getName(), Integer.parseInt(memberDto.getScope()));
                    });
                    sb.append(dimension.getName()).append("_").append(memberSb.indexOf(",") > 0 ? memberSb.substring(0, memberSb.length() - 1) : "").append("\u3001");
                } else {
                    Member member = ForecastHelper.getDefaultMember(modelCache, datasetId, dimension, dimNumber, viewId, defaultMember);
                    if (member != null) {
                        sb.append(dimension.getName()).append("_").append(member.getName()).append("\u3001");
                    }
                }
            } else {
                Member member = ForecastHelper.getDefaultMember(modelCache, datasetId, dimension, dimNumber, viewId, defaultMember);
                if (member != null) {
                    sb.append(dimension.getName()).append("_").append(member.getName()).append("\u3001");
                }
            }
        });
        return sb.indexOf("\u3001") > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    public static void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"DiffAnalyzePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public static void initEntryEntityDefault(IFormView formView, Long modelId, Long datasetId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        formView.getModel().deleteEntryData("entryentity");
        formView.getModel().batchCreateNewEntryRow("entryentity", dimensionList.size() - 1);
        Map<String, String> defaultMember = ForecastHelper.getDefaultMember();
        AtomicInteger row = new AtomicInteger(0);
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            int rowIndex = row.getAndIncrement();
            Long viewId = ForecastHelper.getDimDefaultView(modelCache, datasetId, dimNumber);
            ForecastHelper.setDefaultDimMember(modelCache, datasetId, dimension, dimNumber, viewId, defaultMember, rowIndex, formView);
        });
    }

    public static void setDefaultDimMember(IModelCacheHelper modelCache, Long datasetId, Dimension dimension, String dimNumber, Long viewId, Map<String, String> defaultMember, int rowIndex, IFormView formView) {
        Member member = ForecastHelper.getDefaultMember(modelCache, datasetId, dimension, dimNumber, viewId, defaultMember);
        if (member != null) {
            MemberDto memberDto = new MemberDto();
            memberDto.setId(member.getId().toString());
            memberDto.setName(member.getName());
            memberDto.setNumber(member.getNumber());
            memberDto.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
            List<MemberDto> memberList = Collections.singletonList(memberDto);
            StringBuilder sb = new StringBuilder();
            ForecastHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), RangeEnum.ONLY.getIndex());
            formView.getModel().setValue("dimname", (Object)dimension.getName(), rowIndex);
            formView.getModel().setValue("dimnumber", (Object)dimNumber, rowIndex);
            formView.getModel().setValue("viewid", (Object)viewId, rowIndex);
            formView.getModel().setValue("members", (Object)JSON.toJSONString(memberList), rowIndex);
            formView.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
        } else {
            formView.getModel().setValue("dimname", (Object)dimension.getName(), rowIndex);
            formView.getModel().setValue("dimnumber", (Object)dimNumber, rowIndex);
        }
    }

    private static Member getDefaultMember(IModelCacheHelper modelCache, Long datasetId, Dimension dimension, String dimNumber, Long viewId, Map<String, String> defaultMember) {
        Member member = null;
        if (defaultMember.containsKey(dimNumber)) {
            String memberNumber = defaultMember.get(dimNumber);
            member = modelCache.getMember(dimNumber, viewId, memberNumber);
        } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            List memberSort = modelCache.getMemberSort(SysDimensionEnum.Entity.getNumber(), viewId, "Entity", RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
            if (CollectionUtils.isNotEmpty((Collection)memberSort)) {
                member = memberSort.stream().filter(e -> !e.isLeaf()).findFirst().orElseGet(() -> (Member)memberSort.get(0));
            }
        } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            List memberSort = modelCache.getMemberSort(SysDimensionEnum.Account.getNumber(), viewId, "Account", RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
            List accountList = memberSort.stream().filter(e -> datasetId.equals(e.getDatasetId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(accountList)) {
                member = accountList.stream().filter(e -> !e.isLeaf()).findFirst().orElseGet(() -> (Member)accountList.get(0));
            }
        } else if ("epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber))) {
            member = modelCache.getMember(dimNumber, viewId, dimension.getNoneNumber());
        }
        return member;
    }

    public static Map<String, String> getDefaultMember() {
        HashMap<String, String> defaultMember = new HashMap<String, String>(16);
        defaultMember.put(SysDimensionEnum.Version.getNumber(), "VNone");
        defaultMember.put(SysDimensionEnum.Metric.getNumber(), "Money");
        defaultMember.put(SysDimensionEnum.Currency.getNumber(), "CNY");
        defaultMember.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
        defaultMember.put(SysDimensionEnum.ChangeType.getNumber(), "CurrentPeriod");
        defaultMember.put(SysDimensionEnum.DataType.getNumber(), "Budget");
        defaultMember.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
        return defaultMember;
    }

    public static Long getDimDefaultView(IModelCacheHelper modelCache, long datasetId, String dimNumber) {
        return IDUtils.toLong((Object)modelCache.getViewByDataSetAndDimNumber(Long.valueOf(datasetId), dimNumber));
    }

    public static void switchFloating(String data, Map<String, Object> param, IFormView formView, IFormPlugin formPlugin) {
        JSONObject jsonObject = JSON.parseObject((String)data);
        Boolean showFloating = jsonObject.getBoolean("showFloating");
        FormShowParameter showParameter = new FormShowParameter();
        String pageId = formView.getPageId() + "eb_predict_sidebar" + showFloating;
        ForecastHelper.cachePageId(formView.getPageCache(), "eb_predict_sidebar", pageId);
        showParameter.setFormId("eb_predict_sidebar");
        param.put("predictData", data);
        showParameter.setCustomParams(param);
        showParameter.setParentPageId(formView.getPageId());
        showParameter.setCloseCallBack(new CloseCallBack(formPlugin, "predictDataCloseCallback"));
        if (showFloating.booleanValue()) {
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setPageId(pageId);
            StyleCss css = new StyleCss();
            css.setWidth("700");
            css.setHeight("800");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setFloatingDirection(FloatingDirection.RightCenter);
            showParameter.getOpenStyle().setNoSwitchFocus(true);
            formView.setVisible(Boolean.valueOf(false), new String[]{"predictpanel"});
        } else {
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setPageId(pageId);
            showParameter.getOpenStyle().setTargetKey("predictpanel");
            formView.setVisible(Boolean.valueOf(true), new String[]{"predictpanel"});
            showParameter.setShowTitle(false);
            showParameter.setShowClose(false);
            formView.setVisible(Boolean.valueOf(true), new String[]{"predictpanel"});
        }
        IFormView predictView = formView.getView(formView.getPageId() + "eb_predict_sidebar" + (showFloating == false));
        if (predictView != null) {
            predictView.getPageCache().put("isClose", "true");
            predictView.close();
            formView.sendFormAction(predictView);
        }
        formView.getPageCache().put("predictShow", String.valueOf(true));
        formView.showForm(showParameter);
    }

    public static void cachePageId(IPageCache pageCache, String formId, String pageId) {
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
    }
}

