/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.pojo.TemplatePojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.forecast.util.ShowFormUtil;
import kd.epm.eb.formplugin.utils.ReportOpenUtil;

public class PredictTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        IFormView mainView = this.getMainView();
        JobInfo jobInfo = this.getJobFormInfo().getJobInfo();
        if (taskInfo.isTaskEnd()) {
            String appId = jobInfo.getAppId();
            Map params = jobInfo.getParams();
            String formId = (String)params.get("formId");
            if ("eb_analysiscanvas_design".equals(formId)) {
                Long pkId = IDUtils.toLong(params.get("canvasId"));
                params.put("id", pkId);
            }
            ShowFormUtil.openApp(appId, mainView);
            String pageId = (String)params.get("pageId");
            if (!ShowFormUtil.openApp(appId, mainView)) {
                return;
            }
            if ("eb_analysiscanvas_design".equals(formId)) {
                if (!ShowFormUtil.openPageExisted(pageId, mainView)) {
                    this.openAnalysisCanvasDesignPage(appId, formId, pageId, params, mainView);
                } else {
                    this.openPredictPage(pageId, formId, params, mainView);
                }
            } else if ("bgm_rptpreparation".equals(formId) || "eb_executetask".equals(formId)) {
                if (!ShowFormUtil.openPageExisted(pageId, mainView)) {
                    this.openRptOrTaskPage(appId, formId, params, mainView);
                } else {
                    this.openPredictPage(pageId, formId, params, mainView);
                }
            }
        }
    }

    private void openAnalysisCanvasDesignPage(String appId, String formId, String pageId, Map<String, Object> params, IFormView mainView) {
        Long canvasId = IDUtils.toLong((Object)params.get("canvasId"));
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(canvasId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setPageId(pageId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadResFormat((String)"\u6c99\u76d8\u6a21\u62df-%1", (String)"AnalysisCanvasListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{canvas.getName()}));
        showParameter.setCustomParam("id", (Object)canvasId);
        showParameter.setShowTitle(true);
        ShowFormUtil.openNewPage(appId, showParameter, mainView);
        this.openPredictPage(pageId, formId, params, mainView);
    }

    private void openRptOrTaskPage(String appId, String formId, Map<String, Object> params, IFormView mainView) {
        DynamicObject dynamicObject;
        Long processId = (Long)params.get("processId");
        Long taskProcessId = (Long)params.get("taskProcessId");
        String processType = (String)params.get("processType");
        Long templateId = (Long)params.get("templateId");
        TemplatePojo templatePojo = new TemplatePojo();
        templatePojo.setTemplateIdLong(templateId);
        ReportProcessPojo pojo = new ReportProcessPojo();
        pojo.setReportProcessIdLong(processId);
        pojo.setReportProcessTypeString(processType);
        if (processType.equals(ProcessTypeEnum.REPORT.getNumber())) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)taskProcessId, (String)"eb_schemeassign");
            pojo.setReportOrTaskIdLong(Long.valueOf(dynamicObject.getLong("scheme.id")));
        } else if (processType.equals(ProcessTypeEnum.TASK.getNumber())) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)taskProcessId, (String)"eb_taskprocess");
            pojo.setReportOrTaskIdLong(Long.valueOf(dynamicObject.getLong("task.id")));
        }
        pojo.setTemplatePojo(templatePojo);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appPageId = ShowFormUtil.getAppPageId(mainView.getPageId(), appInfo.getNumber());
        IFormView appPageView = mainView.getViewNoPlugin(appPageId);
        String reportPageId = ReportOpenUtil.openReoprt(appPageView, pojo);
        mainView.sendFormAction(appPageView);
        this.openPredictPage(reportPageId, formId, params, mainView);
    }

    private void openPredictPage(String pageId, String formId, Map<String, Object> params, IFormView mainView) {
        IFormView canvasFormView = mainView.getViewNoPlugin(pageId);
        ShowFormUtil.activatePage(pageId, mainView, params);
        if (canvasFormView == null || Boolean.parseBoolean(canvasFormView.getPageCache().get("predictShow"))) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        String predictPageId = pageId + "eb_predict_sidebar";
        this.cachePageId(canvasFormView.getPageCache(), "eb_predict_sidebar", predictPageId);
        showParameter.setFormId("eb_predict_sidebar");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setPageId(predictPageId);
        showParameter.getOpenStyle().setTargetKey("predictpanel");
        showParameter.setShowTitle(false);
        showParameter.setShowClose(false);
        showParameter.setCustomParams(params);
        this.openPredictPanel(canvasFormView);
        canvasFormView.showForm(showParameter);
        mainView.sendFormAction(canvasFormView);
    }

    private void openPredictPanel(IFormView predictParentView) {
        predictParentView.setVisible(Boolean.valueOf(true), new String[]{"predictpanel"});
        predictParentView.getPageCache().put("predictShow", String.valueOf(true));
    }

    private void cachePageId(IPageCache pageCache, String formId, String pageId) {
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
    }
}

