/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.forecast.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ShowFormUtil {
    private static final Log log = LogFactory.getLog(ShowFormUtil.class);

    public static boolean openApp(String appId, IFormView myView) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String mainPageId = appInfo.getHomeId();
        if (mainPageId != null && mainPageId.trim().length() != 0) {
            DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)"bos_formmeta", (String)"number, inheritpath");
            if (pageObject == null) {
                myView.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\uff01", (String)"ShowFormUtil_1", (String)"bos-ais-core", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            String mainPageNumber = pageObject.getString("number");
            customParams.put("appname", appInfo.getName().getLocaleValue());
            customParams.put("appmainnumber", mainPageNumber);
            OpenPageUtils.openApp((String)appInfo.getNumber(), null, customParams, (IFormView)myView);
            String appPageId = ShowFormUtil.getAppPageId(myView.getPageId(), appInfo.getNumber());
            IFormView appPageView = myView.getViewNoPlugin(appPageId);
            if (appPageView == null) {
                OpenPageUtils.openApp((String)appInfo.getNumber(), null, null, (IFormView)myView, (String)appInfo.getName().getLocaleValue());
            }
            return true;
        }
        myView.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u8bd5\uff01", (String)"ShowFormUtil_0", (String)"bos-ais-core", (Object[])new Object[0]), Integer.valueOf(3000));
        return false;
    }

    public static boolean openPageExisted(String pageId, IFormView myView) {
        IFormView formIdPage = myView.getViewNoPlugin(pageId);
        return formIdPage != null;
    }

    public static void openNewPage(String appId, FormShowParameter fsp, IFormView myView) {
        IFormView mainPageView = myView.getMainView();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        if (mainPageView == null) {
            log.info("openBill----mainPageView or mainPageID is null");
        } else {
            String appPageId = ShowFormUtil.getAppPageId(mainPageView.getPageId(), appInfo.getNumber());
            IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
            if (appPageView != null) {
                if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                    appPageView = mainPageView;
                }
                if (myView.getPageId().equals(appPageView.getPageId())) {
                    myView.showForm(fsp);
                } else {
                    appPageView.showForm(fsp);
                    myView.sendFormAction(appPageView);
                }
            } else {
                log.info("openBill----appPageView is null");
            }
        }
    }

    public static void openBill(String appId, String billFormId, Map<String, Object> customParams, Object billPkId, String pageId, IFormView myView) {
        customParams.put("formId", billFormId);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appNumber = appInfo.getNumber();
        String mainPageId = appInfo.getHomeId();
        if (mainPageId != null && mainPageId.trim().length() != 0) {
            DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)"bos_formmeta", (String)"number, inheritpath");
            if (pageObject == null) {
                myView.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\uff01", (String)"ShowFormUtil_1", (String)"bos-ais-core", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                IFormView formIdPage;
                String mainPageNumber = pageObject.getString("number");
                customParams.put("appname", appInfo.getName().getLocaleValue());
                customParams.put("appmainnumber", mainPageNumber);
                OpenPageUtils.openApp((String)appInfo.getNumber(), (String)null, customParams, (IFormView)myView);
                if (StringUtils.isEmpty((String)pageId)) {
                    pageId = ShowFormUtil.getBillPageId(myView.getMainView(), billFormId, billPkId.toString());
                }
                if ((formIdPage = myView.getViewNoPlugin(pageId)) != null) {
                    ShowFormUtil.activatePage(pageId, myView, customParams);
                } else {
                    ShowFormUtil.openBill(appNumber, billFormId, pageId, customParams, myView);
                }
            }
        } else {
            myView.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u8bd5\uff01", (String)"ShowFormUtil_0", (String)"bos-ais-core", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private static void openBill(String appNumber, String formId, String billPageId, Map<String, Object> customParams, IFormView myView) {
        IFormView mainPageView = myView.getMainView();
        if (mainPageView == null) {
            log.info("openBill----mainPageView or mainPageID is null");
        } else {
            String appPageId = ShowFormUtil.getAppPageId(mainPageView.getPageId(), appNumber);
            IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
            if (appPageView != null) {
                if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                    appPageView = mainPageView;
                }
                FormShowParameter fsp = ShowFormUtil.createShowFormParameter(formId, customParams);
                fsp.setHasRight(true);
                fsp.setAppId(appNumber);
                fsp.setCustomParam("appid", (Object)appNumber);
                ShowFormUtil.addCustomParam(fsp, customParams);
                fsp.setPageId(billPageId);
                if (myView.getPageId().equals(appPageView.getPageId())) {
                    myView.showForm(fsp);
                } else {
                    appPageView.showForm(fsp);
                    myView.sendFormAction(appPageView);
                }
            } else {
                log.info("openBill----appPageView is null");
            }
        }
    }

    public static void activatePage(String pageID, IFormView view, Map<String, Object> map) {
        String menuId = pageID.split("root")[0];
        IFormView childView = view.getViewNoPlugin(pageID);
        if (childView != null && "wftask".equals(childView.getFormShowParameter().getAppId())) {
            childView = view.getView(pageID);
        }
        if (childView == null) {
            log.debug("the pageView of need activate is null, the pageID is: " + pageID);
        } else if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
            ShowFormUtil.dealCustomParams(childView, (HashMap)map.get("customparameters"));
            childView.getFormShowParameter().setHasRight(true);
            childView.activate();
            if ("wftask".equals(childView.getFormShowParameter().getAppId())) {
                childView.updateView();
            }
            view.sendFormAction(childView);
            long userId = RequestContext.get().getCurrUserId();
            String time = new SimpleDateFormat("yyy-MM-dd hh:mm:ss").format(new Date(System.currentTimeMillis()));
            String debugInfo = "the ending of click APP debug info is: ---userID:" + userId + "---time:" + time + "---menuId Or appId:" + menuId + "---PageID" + pageID;
            log.info(debugInfo);
        }
    }

    private static void dealCustomParams(IFormView childView, Map<String, Object> customparameters) {
        List<String> list = Arrays.asList("messageId", "tabType", "openPage", "billFormId");
        for (String p : list) {
            childView.getFormShowParameter().getCustomParams().remove(p);
        }
        if (customparameters != null) {
            FormShowParameter fsp = childView.getFormShowParameter();
            for (String p : list) {
                Object v = customparameters.get(p);
                if (v == null) continue;
                fsp.setCustomParam(p, v);
            }
        }
    }

    public static FormShowParameter createShowFormParameter(String formNumber, Map<String, Object> parameter) {
        FormShowParameter sp = FormShowParameter.createFormShowParameter(parameter);
        sp.getOpenStyle().setShowType(ShowType.NewTabPage);
        sp.getOpenStyle().setTargetKey("_submaintab_");
        HashMap map = new HashMap();
        sp.setCustomParams(map);
        return sp;
    }

    public static String getAppPageId(String mainPageViewPageId, String appNumber) {
        return appNumber + mainPageViewPageId;
    }

    private static void addCustomParam(FormShowParameter fsp, Map<String, Object> customParams) {
        if (customParams != null) {
            customParams.forEach((arg_0, arg_1) -> ((FormShowParameter)fsp).setCustomParam(arg_0, arg_1));
        }
    }

    private static String getBillPageId(IFormView targetView, String formId, String billPkid) {
        return formId + targetView.getPageId() + "_" + billPkid;
    }
}

