/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.formula;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.constant.MessageConstant;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.catalog.utils.CatalogServiceHelper;
import kd.epm.eb.formplugin.formula.utils.BizRuleUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class BizRuleListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener {
    private static final String DELETEBIZRULE_COMFIRM = "deletebizrule_comfirm";
    private static final String DELETECATALOG_COMFIRM = "deletecatalog_comfirm";
    private static final String TREENAME = "bizrulecatalog";
    private static final String KEY_BIZRULECATALOG = "bizrulecatalog";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String dynamic_allocate_formid = "eb_dynamic_brallocate";
    public static final String FOCUS_NODE_ID = "FOCUS_NODE_ID";
    private static final String TREELIST = "treelist";

    public void initialize() {
        super.initialize();
    }

    public String getModelSign() {
        return "modelbd";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
        BasedataEdit model = (BasedataEdit)this.getControl(this.getModelSign());
        model.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView());
            beforeF7SelectEvent.getCustomQFilters().addAll(modelFilter);
        });
    }

    private void addListeners() {
        this.addClickListeners(new String[]{"btn_add", "btn_delete", "btn_modify", "searchbefore", "searchnext"});
        TreeView treeView = (TreeView)this.getControl("bizrulecatalog");
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.addPagerClickListener(pagerClickEvent -> this.refreshBillList());
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam("bizrulecatalog")));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_execute", "bar_executeinfo"});
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(modelCacheKey));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)this.getModelSign(), (boolean)false);
        }
        if (IDUtils.isNull((Long)modelId)) {
            BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"BizRuleListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BizRuleListPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BizRuleListPlugin_5", "epm-eb-formplugin"));
        this.getModel().setValue(this.getModelSign(), (Object)modelId);
        this.modelChange(modelId);
    }

    private void modelChange(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        this.getPageCache().put(modelCacheKey, modelId.toString());
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.setFilterParameter(fp);
        billList.clearSelection();
        this.refreshTree();
        this.refreshBillList();
    }

    private void refreshBillList() {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        boolean isAllChild = Boolean.parseBoolean(this.getModel().getValue("treecheckbox").toString());
        QFilter qFilter1 = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)nodeId));
        QFilter qFilter2 = null;
        if (isAllChild) {
            String str = this.getPageCache().get(TREELIST);
            if (StringUtils.isEmpty((String)str)) {
                return;
            }
            List treeList = (List)SerializationUtils.fromJsonString((String)str, List.class);
            ArrayList<String> list = new ArrayList<String>(16);
            this.queryAllChildNodeList(nodeId, treeList, list);
            if (!list.isEmpty()) {
                qFilter2 = new QFilter("catalog", "in", (Object)IDUtils.toLongs(list));
            }
            billList.setFilter(qFilter1.or(qFilter2));
        } else {
            billList.setFilter(qFilter1);
        }
        billList.clearSelection();
        billList.refresh();
    }

    private void queryAllChildNodeList(String nodeId, List<Map<String, String>> treeList, List<String> allChildNodeList) {
        for (Map<String, String> map : treeList) {
            if (!map.get("parentid").equals(nodeId)) continue;
            allChildNodeList.add(map.get("id"));
            this.queryAllChildNodeList(map.get("id"), treeList, allChildNodeList);
        }
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl("bizrulecatalog");
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode bizrulecatalog = new TreeNode();
        String modelid = this.getPageCache().get(modelCacheKey);
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelid));
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "name";
        String rootNodeId = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_bizrulecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(16);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject dynamicObject : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", dynamicObject.getString("id"));
                memberMap.put("number", dynamicObject.getString("number"));
                memberMap.put("name", dynamicObject.getString("name"));
                memberMap.put("parentid", dynamicObject.getString("parent"));
                treeList.add(memberMap);
                if (!"0".equals(dynamicObject.getString("parent"))) continue;
                rootNodeId = dynamicObject.getString("id");
                bizrulecatalog.setId(rootNodeId);
                this.getPageCache().put(FOCUS_NODE_ID, rootNodeId);
                this.getPageCache().put("rootnodeid", rootNodeId);
            }
        }
        bizrulecatalog.setParentid("");
        bizrulecatalog.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5206\u7c7b", (String)"BizRuleListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getPageCache().put(TREELIST, SerializationUtils.toJsonString(treeList));
        EpmTreeUtils.setEntryNode((TreeNode)bizrulecatalog, treeList, (String)rootNodeId);
        EpmTreeUtils.spreadAllNode((TreeNode)bizrulecatalog);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)bizrulecatalog));
        TreeView tree = (TreeView)this.getControl("bizrulecatalog");
        tree.addNode(bizrulecatalog);
        tree.focusNode(bizrulecatalog);
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        switch (name = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refreshBillList();
                break;
            }
            case "modelbd": {
                Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)this.getModelSign());
                if (IDUtils.isNull((Long)modelId)) {
                    this.getModel().setValue(this.getModelSign(), (Object)this.getPageCache().get(modelCacheKey));
                    break;
                }
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get(modelCacheKey)))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.modelChange(modelId);
                break;
            }
        }
    }

    protected boolean validator() {
        String modulid = this.getPageCache().get(modelCacheKey);
        if (StringUtils.isEmpty((String)modulid)) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        if (!this.validator()) {
            return;
        }
        Control c = (Control)evt.getSource();
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (nodeId == null) {
            nodeId = "0";
        }
        switch (c.getKey().toLowerCase()) {
            case "btn_add": {
                this.addCatalog(nodeId);
                break;
            }
            case "btn_delete": {
                this.deleteCatalog(nodeId);
                break;
            }
            case "btn_modify": {
                this.modifyCatalog(nodeId);
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("bizrulecatalog", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("bizrulecatalog", TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    private void addCatalog(String nodeId) {
        long modelId = this.getModelId();
        QFilter modelQfilter = new QFilter("model", "=", (Object)modelId);
        QFilter numberQfilter = new QFilter("number", "=", (Object)"root");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_bizrulecatalog", (String)"id,number,name", (QFilter[])new QFilter[]{modelQfilter, numberQfilter});
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0root\u8282\u70b9", (String)"BizRuleListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        nodeId = dynamicObject.getString("id");
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("model", modelId);
        long id = Long.parseLong(nodeId);
        customParams.put("parent", id);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "epm_bizrulecatalog");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("epm_bizrulecatalog");
        baseShowParameter.setCustomParams(customParams);
        baseShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(baseShowParameter);
    }

    private void deleteCatalog(String focusNodeId) {
        String rootNodeId = this.getPageCache().get("rootnodeid");
        boolean flag = focusNodeId.equals(rootNodeId);
        if (flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BizRuleListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("parent", "=", (Object)IDUtils.toLong((Object)focusNodeId));
        QFilter[] filters2 = new QFilter[]{filter};
        if (QueryServiceHelper.exists((String)"epm_bizrulecatalog", (QFilter[])filters2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0b\u5b58\u5728\u4e0b\u7ea7\u5206\u7c7b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BizRuleListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter2 = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)focusNodeId));
        if (QueryServiceHelper.exists((String)"eb_bizruleentity", (QFilter[])filter2.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0b\u5b58\u5728\u4e1a\u52a1\u89c4\u5219\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BizRuleListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"BizRuleListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETECATALOG_COMFIRM, (IFormPlugin)this));
    }

    private void modifyCatalog(String focusNodeId) {
        String rootNodeId = this.getPageCache().get("rootnodeid");
        if (rootNodeId.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u5206\u7c7b\u4e0d\u80fd\u4fee\u6539\u3002", (String)"BizRuleListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setPkId((Object)Long.parseLong(focusNodeId));
        showParameter.setFormId("epm_bizrulecatalog");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "epm_bizrulecatalog");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        switch (key) {
            case "bar_add": {
                this.addBizRule("eb_bizruleentity");
                break;
            }
            case "bar_delete": {
                if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"BizRuleListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETEBIZRULE_COMFIRM, (IFormPlugin)this));
                break;
            }
            case "bar_enable": 
            case "bar_disable": {
                if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
                    return;
                }
                ArrayList<Object> forbiddenIdList = new ArrayList<Object>(16);
                billList.getSelectedRows().forEach(e -> forbiddenIdList.add(e.getPrimaryKeyValue()));
                boolean status = key.equals("bar_enable");
                BizRuleUtils.changeBizruleStatus(forbiddenIdList, status);
                this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "BizRuleListPlugin_15", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "BizRuleListPlugin_16", "epm-eb-formplugin"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"BizRuleListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.refreshBillList();
                break;
            }
            case "bar_allocate": {
                this.showDynamicAllocateForm();
                break;
            }
            case "bar_moveup": {
                this.moveUp();
                break;
            }
            case "bar_movedown": {
                this.moveDown();
                break;
            }
            case "bar_refresh": {
                billList.clearSelection();
                this.refreshBillList();
                break;
            }
        }
    }

    private void showDynamicAllocateForm() {
        FormShowParameter form = new FormShowParameter();
        form.setFormId(dynamic_allocate_formid);
        form.setCustomParam(modelCacheKey, (Object)this.getPageCache().get(modelCacheKey));
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            form.setParentPageId(this.getView().getParentView().getPageId());
        }
        form.setPageId(form.getFormId() + "_" + this.getView().getPageId());
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5206\u914d", (String)"BizRuleListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        IFormView mainView = this.getView().getMainView();
        IFormView childFormView = null;
        if (mainView != null) {
            childFormView = this.getView().getMainView().getView(form.getPageId());
        }
        if (childFormView != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm(form);
        }
    }

    private void moveDown() {
        int i;
        if (this.checkSelection(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u52a8\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
            return;
        }
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (focusNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u6240\u5c5e\u7684\u5206\u7c7b\u3002", (String)"BizRuleListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String rootNodeId = this.getPageCache().get("rootnodeid");
        if (rootNodeId.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u79fb\u52a8\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        HashSet selectedIdList = new HashSet(16);
        billList.getSelectedRows().forEach(e -> selectedIdList.add(Long.parseLong(e.getPrimaryKeyValue().toString())));
        QFilter filter = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)focusNodeId));
        DynamicObject[] bizRules = BusinessDataServiceHelper.load((String)"eb_bizruleentity", (String)"id, name, number, executeseq", (QFilter[])new QFilter[]{filter}, (String)"executeseq");
        int count = bizRules.length - 1;
        for (i = bizRules.length - 1; i >= 0; --i) {
            if (!selectedIdList.contains(bizRules[i].getLong("id"))) continue;
            if (count == i) {
                --count;
                continue;
            }
            DynamicObject nextValue = bizRules[i + 1];
            bizRules[i + 1] = bizRules[i];
            bizRules[i] = nextValue;
        }
        if (count == bizRules.length - selectedIdList.size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4ee5\u79fb\u52a8\u7684\u89c4\u5219\u3002", (String)"BizRuleListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (i = 0; i < bizRules.length; ++i) {
            bizRules[i].set("executeseq", (Object)(i + 1));
        }
        SaveServiceHelper.save((DynamicObject[])bizRules);
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BizRuleListPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BizRuleListPlugin_5", "epm-eb-formplugin"));
        this.refreshBillList();
    }

    private void moveUp() {
        int i;
        if (this.checkSelection(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u52a8\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
            return;
        }
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (focusNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u6240\u5c5e\u7684\u5206\u7c7b\u3002", (String)"BizRuleListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String rootNodeId = this.getPageCache().get("rootnodeid");
        if (rootNodeId.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u79fb\u52a8\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        HashSet selectedIdList = new HashSet(16);
        billList.getSelectedRows().forEach(e -> selectedIdList.add(Long.parseLong(e.getPrimaryKeyValue().toString())));
        QFilter filter = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)focusNodeId));
        DynamicObject[] bizRules = BusinessDataServiceHelper.load((String)"eb_bizruleentity", (String)"id, name, number, executeseq, catalog", (QFilter[])new QFilter[]{filter}, (String)"executeseq");
        int count = 0;
        for (i = 0; i < bizRules.length; ++i) {
            if (!selectedIdList.contains(bizRules[i].getLong("id"))) continue;
            if (count == i) {
                ++count;
                continue;
            }
            DynamicObject preValue = bizRules[i - 1];
            bizRules[i - 1] = bizRules[i];
            bizRules[i] = preValue;
        }
        if (count == selectedIdList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4ee5\u79fb\u52a8\u7684\u89c4\u5219\u3002", (String)"BizRuleListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (i = 0; i < bizRules.length; ++i) {
            bizRules[i].set("executeseq", (Object)(i + 1));
        }
        SaveServiceHelper.save((DynamicObject[])bizRules);
        this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "BizRuleListPlugin_15", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "BizRuleListPlugin_16", "epm-eb-formplugin"));
        this.refreshBillList();
    }

    protected boolean checkSelection(String tips) {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(tips);
            return true;
        }
        return false;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        boolean isAllChild = Boolean.parseBoolean(this.getModel().getValue("treecheckbox").toString());
        QFilter qFilter1 = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)nodeId));
        QFilter qFilter2 = null;
        if (isAllChild) {
            String str = this.getPageCache().get(TREELIST);
            if (str == null) {
                e.getQFilters().add(new QFilter("1", "!=", (Object)1));
                return;
            }
            List treeList = (List)SerializationUtils.fromJsonString((String)str, List.class);
            ArrayList<String> list = new ArrayList<String>(16);
            this.queryAllChildNodeList(nodeId, treeList, list);
            if (!list.isEmpty()) {
                qFilter2 = new QFilter("catalog", "in", (Object)IDUtils.toLongs(list));
            }
            e.getQFilters().add(qFilter1.or(qFilter2));
        } else {
            e.getQFilters().add(qFilter1);
        }
    }

    private void updateBizRule(List<Object> idList, String propertyName, Object value) {
        Object[] entitys;
        for (DynamicObject dynamicObject : entitys = BusinessDataServiceHelper.load((String)"eb_bizruleentity", (String)propertyName, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList.toArray())})) {
            dynamicObject.set(propertyName, value);
        }
        if (entitys.length > 0) {
            SaveServiceHelper.save((IDataEntityType)entitys[0].getDynamicObjectType(), (Object[])entitys);
        }
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BizRuleListPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4e1a\u52a1\u89c4\u5219\u4fee\u6539\u6210\u529f\u3002", "BizRuleListPlugin_31", "epm-eb-formplugin"));
    }

    @Override
    public String getBizEntityNumber() {
        return "eb_bizruleentity";
    }

    private void addBizRule(String formId) {
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (focusNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u6240\u5c5e\u7684\u5206\u7c7b\u3002", (String)"BizRuleListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String rootNodeId = this.getPageCache().get("rootnodeid");
        if (rootNodeId.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u521b\u5efa\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject catalog = new JSONObject();
        catalog.put("id", (Object)focusNodeId);
        catalog.put("processcatalog", (Object)focusNodeId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParam(modelCacheKey, (Object)this.getPageCache().get(modelCacheKey));
        formShowParameter.setCustomParam("catalog", (Object)catalog.toJSONString());
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"BizRuleListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (DELETECATALOG_COMFIRM.equals(callBackId)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                TreeView tree = (TreeView)this.getControl("bizrulecatalog");
                Map map = tree.getTreeState().getFocusNode();
                String nodeId = (String)map.get("id");
                String parentId = (String)map.get("parentid");
                this.deleteCatalogNode(nodeId, parentId);
            }
        } else if (DELETEBIZRULE_COMFIRM.equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
            ArrayList<Object> ids = new ArrayList<Object>(16);
            billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
            BizRuleUtils.deleteBizRuleByIds(ids);
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BizRuleListPlugin_33", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4e1a\u52a1\u89c4\u5219\u5220\u9664\u6210\u529f\u3002", "BizRuleListPlugin_34", "epm-eb-formplugin"));
            this.refreshBillList();
        }
    }

    private void deleteCatalogNode(String nodeId, String parentId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"epm_bizrulecatalog");
        CatalogServiceHelper.antiAllocate(Long.parseLong(nodeId));
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])new Object[]{nodeId});
        QFilter fCatId = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)nodeId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"eb_bizruleentity", (String)"id", (QFilter[])fCatId.toArray());
        ArrayList<Object> ids = new ArrayList<Object>(16);
        if (collection != null && !collection.isEmpty()) {
            for (DynamicObject obj : collection) {
                ids.add(obj.getLong("id"));
            }
        }
        this.updateBizRule(ids, "catalog", parentId);
        this.refreshTree();
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BizRuleListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BizRuleListPlugin_33", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "BizRuleListPlugin_35", "epm-eb-formplugin"));
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        BillList list = (BillList)evt.getSource();
        this.billListClick(list);
        evt.setCancel(true);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("number")) {
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            this.billListClick(list);
            args.setCancel(true);
        }
    }

    public void billListClick(BillList list) {
        DynamicObject dynamicObject;
        if (!list.getSelectedRows().isEmpty() && (dynamicObject = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), list.getFocusRowPkId())) != null && dynamicObject.get("id") != null && dynamicObject.get("name") != null) {
            String id = dynamicObject.get("id").toString();
            String name = dynamicObject.get("name").toString();
            this.editBizRule(id, name);
        }
    }

    private void editBizRule(String bizRuleId, String bizRuleName) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "eb_bizruleentity");
        openParameter.put("pkId", bizRuleId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadResFormat((String)"\u4e1a\u52a1\u89c4\u5219-%1", (String)"BizRuleListPlugin_37_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{bizRuleName}));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "eb_bizruleentity");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "epm_bizrulecatalog": {
                this.refreshTree();
                break;
            }
            default: {
                this.refreshBillList();
            }
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue(this.getModelSign());
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        this.getPageCache().put(FOCUS_NODE_ID, evt.getNodeId().toString());
        billList.clearSelection();
        this.refreshBillList();
    }
}

