/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.formula;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.formula.AcctFormulaParser;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.f7.DimMemberF7SelInfo;
import kd.epm.eb.common.formula.BudFormulaConfig;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.DimViewMember;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class BudFormulaEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(BudFormulaEditPlugin.class);
    private static final String f7containerKey = "f7container";
    private static final Set<String> baseDataKeys = Sets.newHashSet((Object[])new String[]{"account", "year", "period", "metric", "currency", "entity", "datatype", "version", "audittrail", "changetype", "internalcompany", "userdim1", "userdim2", "userdim3", "userdim4", "userdim5", "userdim6", "userdim7", "userdim8", "userdim9"});

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
        baseDataKeys.forEach(key -> this.addF7SelectListener(this, new String[]{key}));
        this.addF7SelectListener(this, new String[]{"model", "dataset"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBackData();
    }

    private void fillBackData() {
        String formulaStr = (String)this.getCustomFormParam("formula");
        if (this.isEmpty(formulaStr)) {
            return;
        }
        try {
            BudFormulaConfig formulaConfig = (BudFormulaConfig)AcctFormulaParser.parser((String)formulaStr);
            IDataModel dataModel = this.getModel();
            IFormView formView = this.getView();
            dataModel.setValue("model", (Object)formulaConfig.getModel().getId());
            dataModel.setValue("dataset", (Object)formulaConfig.getDataset().getId());
            this.updateF7List();
            Map<String, String> dimKeyMap = this.getOrCacheDimKeyMap(null);
            Map dimViewIds = this.getDimViewIdsFromCache();
            dimKeyMap.forEach((f7Key, dimNum) -> {
                DimViewMember membObj = (DimViewMember)formulaConfig.getDimMembers().get(dimNum);
                if (membObj != null) {
                    if (membObj.getNumber().equals("@")) {
                        formView.setEnable(Boolean.valueOf(false), new String[]{f7Key});
                        dataModel.setValue(f7Key + "var", (Object)true);
                    } else {
                        dataModel.setValue(f7Key, (Object)membObj.getId());
                        dimViewIds.put(dimNum, membObj.getViewId());
                    }
                }
            });
            this.cacheDimViewIds(dimViewIds);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u516c\u5f0f\u5185\u5bb9\u52a0\u8f7d\u5931\u8d25\uff1a%1\u3002", (String)"BudFormulaEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("model".equals(propName)) {
            this.clearDataset();
        } else if ("dataset".equals(propName)) {
            this.updateF7List();
        } else if (propName.endsWith("var")) {
            this.dealVarChange(propName, changeData);
        }
    }

    private void dealVarChange(String propName, ChangeData changeData) {
        String f7Key = propName.replace("var", "");
        if (baseDataKeys.contains(f7Key)) {
            boolean checked = (Boolean)changeData.getNewValue();
            if (checked) {
                this.getModel().setValue(f7Key, null);
            }
            this.getView().setEnable(Boolean.valueOf(!checked), new String[]{f7Key});
        }
    }

    private void clearDataset() {
        this.getModel().setValue("dataset", null);
    }

    public void updateF7List() {
        IModelCacheHelper modelCacheHelper;
        Long dataSetId = this.getDataSetId();
        Map<String, String> dimKeyMap = this.getOrCacheDimKeyMap(null);
        IDataModel dataModel = this.getModel();
        dimKeyMap.keySet().forEach(f7Key -> {
            dataModel.setValue(f7Key, null);
            dataModel.setValue(f7Key + "var", (Object)false);
        });
        HashMap<String, String> newDimKeyMap = new HashMap<String, String>(baseDataKeys.size());
        IFormView formView = this.getView();
        if (this.notEmpty(dataSetId) && (modelCacheHelper = this.getIModelCacheHelper()) != null) {
            List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
            Count count = new Count(1);
            dimensionList.forEach(dimension -> {
                String dimNum = dimension.getNumber();
                if (dimension.isPreset()) {
                    newDimKeyMap.put(dimNum.toLowerCase(), dimNum);
                } else {
                    String f7Key = "userdim" + count.getCount();
                    BasedataEdit control = (BasedataEdit)formView.getControl(f7Key);
                    control.setCaption(new LocaleString(dimension.getName()));
                    newDimKeyMap.put(f7Key, dimNum);
                    count.addOne();
                }
            });
            newDimKeyMap.remove(SysDimensionEnum.BudgetPeriod.getNumber().toLowerCase());
            newDimKeyMap.put(SysDimensionEnum.Period.getNumber().toLowerCase(), SysDimensionEnum.Period.getNumber());
            newDimKeyMap.put(SysDimensionEnum.Year.getNumber().toLowerCase(), SysDimensionEnum.Year.getNumber());
        }
        baseDataKeys.forEach(key -> {
            boolean newShow = newDimKeyMap.containsKey(key);
            boolean oldShow = dimKeyMap.containsKey(key);
            String f7PanelKey = key + "panel";
            if (newShow && !oldShow) {
                formView.setVisible(Boolean.valueOf(true), new String[]{f7PanelKey});
            } else if (!newShow && oldShow) {
                formView.setVisible(Boolean.valueOf(false), new String[]{f7PanelKey});
            }
        });
        this.getOrCacheDimKeyMap(newDimKeyMap);
        this.cacheDimViewIds(new HashMap(16));
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    public Long getBizModelId() {
        return (Long)this.getValue("dataset", "businessmodel_id");
    }

    public Long getDataSetId() {
        return (Long)this.getValue("dataset", "id");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            this.selectData2Return();
        }
    }

    private void selectData2Return() {
        String modelNum = (String)this.getValue("model", "shownumber");
        String datasetNum = (String)this.getValue("dataset", "number");
        ArrayList<String> errorInfo = new ArrayList<String>(16);
        if (this.isEmpty(modelNum)) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BudFormulaEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (this.isEmpty(datasetNum)) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"BudFormulaEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        BudFormulaConfig formulaConfig = new BudFormulaConfig();
        if (errorInfo.isEmpty()) {
            formulaConfig.setModel(new BasedataPojo(Long.valueOf(0L), null, modelNum));
            formulaConfig.setDataset(new BasedataPojo(Long.valueOf(0L), null, datasetNum));
            Map<String, String> dimKeyMap = this.getOrCacheDimKeyMap(null);
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Map viewIdMap = this.getDimViewIdsFromCache();
            for (Map.Entry<String, String> entry : dimKeyMap.entrySet()) {
                View view;
                String f7Key = entry.getKey();
                String dimNum = entry.getValue();
                boolean isVar = (Boolean)this.getValue(f7Key + "var", null);
                if (isVar) {
                    formulaConfig.getDimMembers().put(dimNum, new DimViewMember(Long.valueOf(0L), null, "@", Long.valueOf(0L), null));
                    continue;
                }
                String membNum = (String)this.getValue(f7Key, "number");
                if (this.isEmpty(membNum) && !SysDimensionEnum.Year.getNumber().equals(dimNum) && !SysDimensionEnum.Period.getNumber().equals(dimNum) && !SysDimensionEnum.Entity.getNumber().equals(dimNum)) {
                    Dimension dimension = modelCacheHelper.getDimension(dimNum);
                    errorInfo.add(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9%1\u6210\u5458\u3002", (String)"BudFormulaEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension == null ? dimNum : dimension.getName()}));
                    continue;
                }
                Long viewId = (Long)viewIdMap.get(dimNum);
                String viewNumber = null;
                if (this.notEmpty(viewId) && (view = modelCacheHelper.getDimension(dimNum).getView(viewId)) != null) {
                    viewNumber = view.getNumber();
                }
                formulaConfig.getDimMembers().put(dimNum, this.isEmpty(membNum) ? null : new DimViewMember(Long.valueOf(0L), null, membNum, (Long)viewIdMap.get(f7Key), viewNumber));
            }
        }
        if (errorInfo.size() > 0) {
            this.getView().showTipNotification(String.join((CharSequence)"\n", errorInfo));
        } else {
            this.getView().returnDataToParent((Object)formulaConfig.toString());
            this.getView().close();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Name = beforeF7SelectEvent.getProperty().getName();
        if ("model".equals(f7Name)) {
            beforeF7SelectEvent.getCustomQFilters().addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        } else if ("dataset".equals(f7Name)) {
            beforeF7SelectEvent.getCustomQFilters().add(this.getModelFilter());
        } else if (baseDataKeys.contains(f7Name)) {
            Long bizModelId = this.getBizModelId();
            if (this.isEmpty(bizModelId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"BudFormulaEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!SysDimensionEnum.Period.getNumber().toLowerCase(Locale.getDefault()).equals(f7Name)) {
                HashMap<String, String> cusParam = new HashMap<String, String>(16);
                if (SysDimensionEnum.Year.getNumber().toLowerCase(Locale.getDefault()).equals(f7Name)) {
                    ArrayList<QFilter> qFilters = ((BasedataEdit)beforeF7SelectEvent.getSource()).getQFilters();
                    if (qFilters == null) {
                        qFilters = new ArrayList<QFilter>(1);
                        qFilters.add(new QFilter("level", "=", (Object)2));
                        ((BasedataEdit)beforeF7SelectEvent.getSource()).setQFilters(qFilters);
                    }
                    cusParam.put("title", ResManager.loadKDString((String)"\u8d22\u5e74\u7ef4\u5ea6\u6210\u5458", (String)"BudFormulaEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    cusParam.put("rootText", ResManager.loadKDString((String)"Year \u8d22\u5e74", (String)"BudFormulaEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                boolean checkVBudDataPerm = CommonUtils.checkVBudDataPerm((Long)this.getModelId(), (boolean)true);
                this.switchDimNewF7(beforeF7SelectEvent, bizModelId, Collections.singletonList(this.getDataSetId()), checkVBudDataPerm, f7Param -> {
                    String rootText;
                    String title = (String)cusParam.get("title");
                    if (title != null) {
                        f7Param.setTitle(title);
                    }
                    if ((rootText = (String)cusParam.get("rootText")) != null) {
                        f7Param.setRootText(rootText);
                    }
                    f7Param.setEnableView(true);
                    Long viewId = this.getDimViewIdFromCache(f7Param.getDimensionNumber());
                    if (this.notEmpty(viewId)) {
                        f7Param.setViewId(viewId);
                    }
                });
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private QFilter getModelFilter() {
        QFilter filter = null;
        Long modelId = this.getModelId();
        if (this.isEmpty(modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BudFormulaEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        filter = new QFilter("model", "=", (Object)modelId);
        return filter;
    }

    public String getCurrentDimNumber(String controlKey) {
        if (baseDataKeys.contains(controlKey)) {
            Map<String, String> dimKeyMap = this.getOrCacheDimKeyMap(null);
            String dimNum = dimKeyMap.get(controlKey);
            if (SysDimensionEnum.Year.getNumber().equals(dimNum)) {
                dimNum = SysDimensionEnum.BudgetPeriod.getNumber();
            }
            return dimNum;
        }
        return null;
    }

    private Map<String, String> getOrCacheDimKeyMap(Map<String, String> dimKeyMap) {
        if (dimKeyMap == null) {
            String cacheStr = this.getPageCache().get("refDimKeyMap");
            dimKeyMap = cacheStr == null ? new HashMap(16) : (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        } else {
            this.getPageCache().put("refDimKeyMap", SerializationUtils.serializeToBase64(dimKeyMap));
        }
        return dimKeyMap;
    }

    public void dealSingleMemberF7Back(DimMemberF7SelInfo selMember) {
        if (SysDimensionEnum.dimHasView((String)selMember.getDimNumber())) {
            this.cacheDimViewId(selMember.getViewId(), selMember.getDimNumber());
        }
    }

    public Set<String> getMemberF7KeySet() {
        return baseDataKeys;
    }
}

