/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.catalog.utils.CatalogServiceHelper;
import kd.epm.eb.formplugin.formula.AllocateTemplate;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.lang3.StringUtils;

public class DynamicAndStaticBizRuleAllocatePlugin
extends AllocateTemplate {
    public static final String leftTree = "treeCacheName";
    private static final String btn_moveup = "btn_moveup";
    private static final String btn_movedown = "btn_movedown";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_moveup, btn_movedown, "searchbefore", "searchnext"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), DynamicAndStaticBizRuleAllocatePlugin.this.getView(), DynamicAndStaticBizRuleAllocatePlugin.this.getPageCache(), new TreeSearchUtil.TreeSearchParam("allocate_tree"));
                } else {
                    DynamicAndStaticBizRuleAllocatePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"DynamicAndStaticBizRuleAllocatePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setValueOnModel("model", this.getFormCustomParam("KEY_MODEL_ID"));
        super.afterCreateNewData(e);
    }

    public void setValueOnModel(String propName, Object value) {
        this.setValueOnModel(this.getModel(), propName, value);
    }

    public void setValueOnModel(IDataModel model, String propName, Object value) {
        model.setValue(propName, value);
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue("model", "id");
        if (modelId == null) {
            modelId = 0L;
        }
        return modelId;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_moveup": {
                this.moveUp();
                break;
            }
            case "btn_movedown": {
                this.moveDown();
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("allocate_tree", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("allocate_tree", TreeSearchUtil.SearchBtnStatus.RIGHT));
            }
        }
    }

    private void moveUp() {
        int row;
        EntryGrid tempEntry = (EntryGrid)this.getControl("allocate_template");
        int[] idxs = tempEntry.getSelectRows();
        if (idxs == null || idxs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObject template = this.getModel().getEntryRowEntity("allocate_template", idxs[0]);
        long templateId = template.getLong("allocate_id");
        EntryGrid entryGrid = (EntryGrid)this.getControl("allocated_template");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u914d\u7684\u4e1a\u52a1\u89c4\u5219\u5206\u7ec4\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        int[] finishSelectRows = new int[selectRows.length];
        int temp = 0;
        for (int i = 0; i < selectRows.length; ++i) {
            row = selectRows[i];
            if (row - temp == 0) {
                ++temp;
                finishSelectRows[i] = row;
                continue;
            }
            finishSelectRows[i] = row - 1;
        }
        if (temp == selectRows.length) {
            return;
        }
        HashMap<Integer, String> moveup = new HashMap<Integer, String>(16);
        for (int i = 0; i < finishSelectRows.length; ++i) {
            row = selectRows[i];
            if (row == finishSelectRows[i]) continue;
            DynamicObject doj = this.getModel().getEntryRowEntity("allocated_template", row);
            String id = doj.getString("allocated_id");
            moveup.put(row + 1, id);
        }
        CatalogServiceHelper.moveup(templateId, moveup);
        this.initAntiallocate();
        entryGrid.selectRows(finishSelectRows, finishSelectRows[0]);
    }

    private void moveDown() {
        int row;
        EntryGrid tempEntry = (EntryGrid)this.getControl("allocate_template");
        int[] idxs = tempEntry.getSelectRows();
        if (idxs == null || idxs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObject template = this.getModel().getEntryRowEntity("allocate_template", idxs[0]);
        long templateId = template.getLong("allocate_id");
        EntryGrid entryGrid = (EntryGrid)this.getControl("allocated_template");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u914d\u7684\u4e1a\u52a1\u89c4\u5219\u5206\u7ec4\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        int[] finishSelectRows = new int[selectRows.length];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryGrid.getEntryKey());
        int temp = entryEntity.size() - 1;
        for (int i = selectRows.length - 1; i >= 0; --i) {
            row = selectRows[i];
            if (row - temp == 0) {
                --temp;
                finishSelectRows[i] = row;
                continue;
            }
            finishSelectRows[i] = row + 1;
        }
        if (temp == entryEntity.size() - 1 - selectRows.length) {
            return;
        }
        HashMap<Integer, String> movedown = new HashMap<Integer, String>(16);
        for (int i = 0; i < finishSelectRows.length; ++i) {
            row = selectRows[i];
            if (row == finishSelectRows[i]) continue;
            DynamicObject doj = this.getModel().getEntryRowEntity("allocated_template", row);
            String id = doj.getString("allocated_id");
            movedown.put(row + 1, id);
        }
        CatalogServiceHelper.movedown(templateId, movedown);
        this.initAntiallocate();
        entryGrid.selectRows(finishSelectRows, finishSelectRows[0]);
    }

    @Override
    protected void initAllocate() {
        long modelId = this.getModelId();
        DynamicObjectCollection dynamicReport = QueryServiceHelper.query((String)"eb_templateentity_bg", (String)"id,number,name,templatetype", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"number");
        this.getModel().deleteEntryData("allocate_template");
        if (dynamicReport.size() <= 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("allocate_template", dynamicReport.size());
        int size = dynamicReport.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicReport.get(i);
            DynamicObject entity = this.getModel().getEntryRowEntity("allocate_template", i);
            entity.set("allocate_id", dynamicObject.get("id"));
            entity.set("allocate_number", dynamicObject.get("number"));
            entity.set("allocate_name", dynamicObject.get("name"));
            entity.set("templatetype", dynamicObject.get("templatetype"));
        }
    }

    @Override
    protected void initAllocateTree() {
        TreeView tree = (TreeView)this.getControl("allocate_tree");
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        long modelId = this.getModelId();
        TreeNode rootNode = new TreeNode();
        HashMap<String, List<TreeNode>> catalogTreeMap = new HashMap<String, List<TreeNode>>(16);
        QFilter fmodel = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"epm_bizrulecatalog", (String)"id, name, number, parent", (QFilter[])new QFilter[]{fmodel}, (String)"name");
        if (catalogs != null && !catalogs.isEmpty()) {
            for (DynamicObject catalog : catalogs) {
                if ("root".equals(catalog.getString("number"))) {
                    rootNode = this.convertCatalog2TreeNode(catalog);
                    rootNode.setParentid("");
                    continue;
                }
                TreeNode treeNode = this.convertCatalog2TreeNode(catalog);
                String parentid = treeNode.getParentid();
                ArrayList<TreeNode> treeNodeList = (ArrayList<TreeNode>)catalogTreeMap.get(parentid);
                if (treeNodeList == null) {
                    treeNodeList = new ArrayList<TreeNode>(16);
                    treeNodeList.add(treeNode);
                    catalogTreeMap.put(parentid, treeNodeList);
                    continue;
                }
                treeNodeList.add(treeNode);
            }
        }
        this.expandleftNextLevel(rootNode, catalogTreeMap);
        TreeView leftTree = (TreeView)this.getControl("allocate_tree");
        this.cacheLeftRoot(rootNode);
        leftTree.addNode(rootNode);
        leftTree.expand(rootNode.getId());
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
    }

    private void expandleftNextLevel(TreeNode parentNode, Map<String, List<TreeNode>> childrenDataMap) {
        List<TreeNode> treeNodes = childrenDataMap.get(parentNode.getId());
        if (treeNodes != null) {
            parentNode.addChildren(treeNodes);
        }
        if (parentNode.getChildren() != null) {
            if (parentNode.getChildren().size() == 0) {
                parentNode.setChildren(null);
            } else {
                for (TreeNode child : parentNode.getChildren()) {
                    this.expandleftNextLevel(child, childrenDataMap);
                }
            }
        }
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(leftTree, SerializationUtils.toJsonString((Object)rootleft));
    }

    protected TreeNode getCacheLeftRoot() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(leftTree))) {
            TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(leftTree), TreeNode.class);
            return leftRoot;
        }
        return null;
    }

    private TreeNode convertCatalog2TreeNode(DynamicObject dynaObj) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(dynaObj.getString("id"));
        treeNode.setText(dynaObj.getString("number") + " " + dynaObj.getString("name"));
        treeNode.setLongNumber(dynaObj.getString("number"));
        treeNode.setParentid(dynaObj.getString("parent"));
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("type", "catalog");
        treeNode.setData(map);
        return treeNode;
    }

    @Override
    protected void initAntiallocate() {
        EntryGrid tempEntry = (EntryGrid)this.getControl("allocate_template");
        int[] idxs = tempEntry.getSelectRows();
        if (idxs == null || idxs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity("allocate_template", idxs[0]);
        if (row != null) {
            this.getModel().deleteEntryData("allocated_template");
            long templateId = row.getLong("allocate_id");
            QFilter ftemp = new QFilter("template", "=", (Object)templateId);
            DynamicObjectCollection bizrules = QueryServiceHelper.query((String)"eb_brallocateentity", (String)"id,catalog.id,catalog.number,catalog.name,executetype,execseq", (QFilter[])ftemp.toArray(), (String)"execseq");
            if (bizrules.size() <= 0) {
                return;
            }
            this.getModel().batchCreateNewEntryRow("allocated_template", bizrules.size());
            int size = bizrules.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject dynamicObject = (DynamicObject)bizrules.get(i);
                DynamicObject entity = this.getModel().getEntryRowEntity("allocated_template", i);
                entity.set("allocated_trueid", dynamicObject.get("id"));
                entity.set("allocated_id", dynamicObject.get("catalog.id"));
                entity.set("allocated_number", dynamicObject.get("catalog.number"));
                entity.set("allocated_name", dynamicObject.get("catalog.name"));
                entity.set("allocated_executetype", dynamicObject.get("executetype"));
                entity.set("execseq", dynamicObject.get("execseq"));
            }
            this.getView().updateView("allocated_template");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "allocated_executetype": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("allocated_template");
                Object allocated_trueid = this.getModel().getValue("allocated_trueid", rowIndex);
                if (allocated_trueid == null) break;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)allocated_trueid, (String)"eb_brallocateentity");
                ChangeData[] changeSet = e.getChangeSet();
                dynamicObject.set("executetype", changeSet[0].getNewValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "DynamicAndStaticBizRuleAllocatePlugin_1", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "DynamicAndStaticBizRuleAllocatePlugin_2", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
            }
        }
    }

    @Override
    protected void allocate() {
        TreeView treeView = (TreeView)this.getControl("allocate_tree");
        List catalogIdList = treeView.getTreeState().getSelectedNodeId();
        if (catalogIdList.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u4e1a\u52a1\u89c4\u5219\u5206\u7ec4\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        EntryGrid tempEntry = (EntryGrid)this.getControl("allocate_template");
        int[] idxs = tempEntry.getSelectRows();
        if (idxs == null || idxs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity("allocate_template", idxs[0]);
        long templateId = row.getLong("allocate_id");
        long modelId = this.getModelId();
        TreeNode leftRoot = this.getCacheLeftRoot();
        ArrayList<DynamicObject> saveCatalog = new ArrayList<DynamicObject>(16);
        int maxSeq = 0;
        HashSet<String> existCatalogId = new HashSet<String>(16);
        QFilter templateQfilter = new QFilter("template", "=", (Object)templateId);
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"eb_brallocateentity", (String)"id,catalog,execseq", (QFilter[])new QFilter[]{templateQfilter});
        if (catalogs != null && !catalogs.isEmpty()) {
            for (DynamicObject catalog : catalogs) {
                existCatalogId.add(catalog.getString("catalog"));
                if (maxSeq >= catalog.getInt("execseq")) continue;
                maxSeq = catalog.getInt("execseq");
            }
        }
        String templatetype = null;
        if (QueryServiceHelper.exists((String)"eb_templateentity", (Object)templateId)) {
            templatetype = "eb_templateentity";
        } else if (QueryServiceHelper.exists((String)"eb_templateentity_bg", (Object)templateId)) {
            templatetype = "eb_templateentity_bg";
        } else {
            throw new KDBizException(ResManager.loadResFormat((String)"\u627e\u4e0d\u5230\u5f53\u524d\u6a21\u677f\uff0c\u6a21\u677fid = %1", (String)"DynamicAndStaticBizRuleAllocatePlugin_12_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{templateId}));
        }
        for (int i = 0; i < catalogIdList.size(); ++i) {
            String catalogId = (String)catalogIdList.get(i);
            TreeNode treeNode = leftRoot.getTreeNode(catalogId, 20);
            String longNumber = treeNode.getLongNumber();
            if ("root".equals(longNumber) || existCatalogId.contains(catalogId)) continue;
            saveCatalog.add(this.genCatalogDO(templatetype, templateId, catalogId, modelId, ++maxSeq));
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])saveCatalog.toArray(new DynamicObject[0]));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u914d", "DynamicAndStaticBizRuleAllocatePlugin_4", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5206\u914d\u6210\u529f", "DynamicAndStaticBizRuleAllocatePlugin_5", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"distribution", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        this.initAntiallocate();
        treeView.uncheckNode(leftRoot.getId());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"DynamicAndStaticBizRuleAllocatePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
    }

    private DynamicObject genCatalogDO(String templateType, long templateId, String catalog, long modelId, int execseq) {
        DynamicObject DO = BusinessDataServiceHelper.newDynamicObject((String)"eb_brallocateentity");
        DO.set("templatetype", (Object)templateType);
        DO.set("template", (Object)templateId);
        DO.set("catalog", (Object)catalog);
        DO.set("model", (Object)modelId);
        DO.set("executetype", (Object)"1");
        DO.set("execseq", (Object)execseq);
        return DO;
    }

    @Override
    protected void antiAllocate() {
        EntryGrid entryGrid1 = (EntryGrid)this.getControl("allocated_template");
        int[] idxs = entryGrid1.getSelectRows();
        if (idxs == null || idxs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u914d\u7684\u4e1a\u52a1\u89c4\u5219\u5206\u7ec4\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("allocate_template");
        int[] ids = entryGrid.getSelectRows();
        if (ids == null || ids.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity("allocate_template", ids[0]);
        Long templateId = row.getLong("allocate_id");
        HashSet<Long> catalogIds = new HashSet<Long>(16);
        for (int selectRow : idxs) {
            row = this.getModel().getEntryRowEntity("allocated_template", selectRow);
            catalogIds.add(row.getLong("allocated_id"));
        }
        CatalogServiceHelper.antiAllocate(templateId, catalogIds);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53cd\u5206\u914d", "DynamicAndStaticBizRuleAllocatePlugin_7", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u53cd\u5206\u914d\u6210\u529f\u5171%1$s\u6761", "DynamicAndStaticBizRuleAllocatePlugin_8_repair", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"dedistribution", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{catalogIds.size() + ""});
        this.initAntiallocate();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u6210\u529f\u3002", (String)"DynamicAndStaticBizRuleAllocatePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
    }
}

