/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.forecast.QueryService;
import kd.epm.eb.business.forecast.gpt.GptForecastService;
import kd.epm.eb.business.forecast.gpt.GptParamService;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GptCellDataPlugin
extends AbstractBasePlugin
implements IGPTAction,
Serializable {
    private static final Log log = LogFactory.getLog(GptCellDataPlugin.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        log.info("{} invokeAction action:{} params:{}", new Object[]{LOG_PREFIX, action, params.toString()});
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        JSONObject paramObj = GptParamService.getInstance().load(action);
        log.info("{} invokeAction action:{} paramObj:{}", new Object[]{LOG_PREFIX, action, paramObj.toJSONString()});
        String modelNumber = paramObj.getString("model");
        String datasetNum = paramObj.getString("dataset");
        if (StringUtils.isBlank((CharSequence)modelNumber)) {
            modelNumber = "88GPT";
        }
        if (StringUtils.isBlank((CharSequence)datasetNum)) {
            datasetNum = "default";
        }
        long modelId = GptForecastService.getInstance().queryModelId(modelNumber);
        long datasetId = GptForecastService.getInstance().queryDatasetId(modelId, datasetNum);
        List boxIdList = Collections.emptyList();
        String sandboxLen = paramObj.getString("boxes");
        if (StringUtils.isNotBlank((CharSequence)sandboxLen)) {
            boxIdList = GptForecastService.getInstance().getLatestBox(Integer.parseInt(sandboxLen));
        }
        JSONObject defaultDim = new JSONObject();
        String dim = paramObj.getString("dim");
        if (StringUtils.isNotBlank((CharSequence)dim)) {
            defaultDim = JSON.parseObject((String)dim);
        }
        List cellList = Collections.emptyList();
        String cellStr = paramObj.getString("cells");
        if (StringUtils.isNotBlank((CharSequence)cellStr)) {
            cellList = JSON.parseArray((String)cellStr, JSONObject.class);
        }
        String dataUnitStr = paramObj.getString("dataUnit");
        if (CollectionUtils.isNotEmpty((Collection)cellList)) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
            List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            Map<String, Long> viewMap = this.getViewMap(sortedDimList, modelCache, datasetId);
            Map<String, String> dataUnitMap = this.getDataUnitMap(dataUnitStr);
            if (CollectionUtils.isEmpty((Collection)boxIdList)) {
                for (int i = 0; i < cellList.size(); ++i) {
                    JSONObject dimMemMap = (JSONObject)cellList.get(i);
                    HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(16);
                    this.buildQueryDim(modelCache, sortedDimList, dimMemMap, defaultDim, queryDim);
                    Map bgCellMap = QueryService.getInstance().queryCurrData(modelId, datasetId, null, queryDim, viewMap);
                    String postfix = String.valueOf(i + 1);
                    this.setReturnValue(returnParams, defaultDim, modelCache, sortedDimList, dataUnitMap, bgCellMap, postfix, dimMemMap);
                }
            } else {
                for (int i = 0; i < boxIdList.size(); ++i) {
                    Long sandboxId = (Long)boxIdList.get(i);
                    for (int k = 0; k < cellList.size(); ++k) {
                        JSONObject dimMemMap = (JSONObject)cellList.get(k);
                        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(16);
                        this.buildQueryDim(modelCache, sortedDimList, dimMemMap, defaultDim, queryDim);
                        Map bgCellMap = QueryService.getInstance().queryCurrData(modelId, datasetId, sandboxId, queryDim, viewMap);
                        String postfix = i + 1 + "_" + (k + 1);
                        this.setReturnValue(returnParams, defaultDim, modelCache, sortedDimList, dataUnitMap, bgCellMap, postfix, dimMemMap);
                    }
                }
            }
        }
        log.info("invokeAction,returnParams:{}", returnParams);
        return returnParams;
    }

    private void setReturnValue(Map<String, String> returnParams, JSONObject defaultDim, IModelCacheHelper modelCache, List<String> sortedDimList, Map<String, String> dataUnitMap, Map<MembersKey, BGCell> bgCellMap, String postfix, JSONObject dimMemMap) {
        Map<String, String> queryCellMap = this.getQueryCellMap(modelCache, sortedDimList, dimMemMap, defaultDim);
        String key = queryCellMap.get(SysDimensionEnum.Account.getNumber());
        Object result = null;
        String unitStr = dataUnitMap.get(key);
        BigDecimal dataUnit = PredictHelper.getDataUnit((String)unitStr);
        Object cellValue = QueryService.getInstance().getCellValue(modelCache, queryCellMap, sortedDimList, bgCellMap, dataUnit);
        if (cellValue != null) {
            BigDecimal bigDecimal = cellValue instanceof Long ? BigDecimal.valueOf((Long)cellValue) : (BigDecimal)cellValue;
            String metricNumber = queryCellMap.get(SysDimensionEnum.Metric.getNumber());
            String metricDataType = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).getDatatype();
            if (MetricDataTypeEnum.RATE.getIndex().equals(metricDataType)) {
                result = bigDecimal.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP).doubleValue();
            } else {
                bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
                result = bigDecimal.doubleValue();
            }
        }
        String value = "";
        if (result != null) {
            value = result.toString();
        }
        returnParams.put(key + postfix, value);
    }

    private Map<String, Long> getViewMap(List<String> sortedDimList, IModelCacheHelper modelCache, long datasetId) {
        HashMap<String, Long> dimViewMap = new HashMap<String, Long>(sortedDimList.size());
        sortedDimList.forEach(dimNum -> {
            Map viewsByDataSetIncludeBase = modelCache.getViewsByDataSetIncludeBase(Long.valueOf(datasetId));
            long viewId = viewsByDataSetIncludeBase == null ? 0L : IDUtils.toLong(viewsByDataSetIncludeBase.get(dimNum));
            dimViewMap.put((String)dimNum, viewId);
        });
        return dimViewMap;
    }

    private Map<String, String> getDataUnitMap(String dataUnitStr) {
        if (StringUtils.isEmpty((CharSequence)dataUnitStr)) {
            return Collections.emptyMap();
        }
        JSONObject dataUnitObj = JSON.parseObject((String)dataUnitStr);
        return dataUnitObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
    }

    private void buildQueryDim(IModelCacheHelper modelCache, List<String> sortedDimList, JSONObject dimMemMap, JSONObject defaultDim, Map<String, Set<String>> queryDim) {
        sortedDimList.forEach(dim -> {
            String memNum = dimMemMap.getString(dim);
            if (StringUtils.isBlank((CharSequence)memNum)) {
                memNum = defaultDim.getString(dim);
            }
            if (StringUtils.isBlank((CharSequence)memNum)) {
                Dimension dimension = modelCache.getDimension(dim);
                memNum = dimension.getNoneNumber();
            }
            Set memSet = queryDim.computeIfAbsent((String)dim, k -> new HashSet(16));
            memSet.add(memNum);
        });
    }

    private Map<String, String> getQueryCellMap(IModelCacheHelper modelCache, List<String> sortedDimList, JSONObject dimMemMap, JSONObject defaultDim) {
        HashMap<String, String> cellMap = new HashMap<String, String>(sortedDimList.size());
        sortedDimList.forEach(dim -> {
            String memNum = dimMemMap.getString(dim);
            if (StringUtils.isBlank((CharSequence)memNum)) {
                memNum = defaultDim.getString(dim);
            }
            if (StringUtils.isBlank((CharSequence)memNum)) {
                Dimension dimension = modelCache.getDimension(dim);
                memNum = dimension.getNoneNumber();
            }
            cellMap.put((String)dim, memNum);
        });
        return cellMap;
    }
}

