/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.forecast.helper.ForecastEntryHelper;

public class GptDynamicEntryPlugin
extends AbstractBasePlugin {
    private static final Log log = LogFactory.getLog(GptDynamicEntryPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        EntryType varEntryType = (EntryType)mainEntityType.getAllEntities().get(ENTRY_ENTITY);
        varEntryType.createPropIndexs();
        varEntryType.setDbIgnore(true);
        List<JSONObject> head = this.getHead();
        head.forEach(json -> json.forEach((key, value) -> ForecastEntryHelper.registerSimpleProp((EntityType)varEntryType, key)));
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        EntryGrid entryGrid = (EntryGrid)e.getControl();
        if (entryGrid == null) {
            return;
        }
        if (ENTRY_ENTITY.equals(ctrlKey)) {
            entryGrid.getItems().clear();
            List<JSONObject> head = this.getHead();
            head.forEach(json -> json.forEach((key, value) -> {
                TextEdit colEdit = ForecastEntryHelper.createEntryTextCtl(key, ctrlKey, entryGrid.getModel(), this.getView());
                entryGrid.getItems().add(colEdit);
            }));
        }
    }

    private void initEntry(List<JSONObject> head) {
        EntryAp varEntryAp = ForecastEntryHelper.createEntry(ENTRY_ENTITY);
        head.forEach(json -> json.forEach((key, value) -> ForecastEntryHelper.createEntryTextFieldAp(varEntryAp, key, String.valueOf(value), "left", "")));
        ForecastEntryHelper.updateEntry(varEntryAp, this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<JSONObject> head = this.getHead();
        List<JSONObject> data = this.getData();
        this.initEntry(head);
        this.refreshEntry(data);
    }

    private void refreshEntry(List<JSONObject> data) {
        IDataModel dataModel = this.getControl(ENTRY_ENTITY).getModel();
        dataModel.deleteEntryData(ENTRY_ENTITY);
        dataModel.batchCreateNewEntryRow(ENTRY_ENTITY, data.size());
        AtomicInteger row = new AtomicInteger(0);
        data.forEach(json -> {
            int i = row.getAndIncrement();
            json.forEach((key, value) -> dataModel.setValue(key, value, i));
        });
        this.getView().updateView(ENTRY_ENTITY);
    }

    private List<JSONObject> getHead() {
        String pkId = (String)this.getView().getFormShowParameter().getShowParameter().getCustomParam("pkId");
        String head = (String)CacheServiceHelper.get((String)("gptDynamicCache:head:" + pkId), String.class);
        log.info("dynamic head:{}", (Object)head);
        return JSONObject.parseArray((String)head, JSONObject.class);
    }

    private List<JSONObject> getData() {
        String pkId = (String)this.getView().getFormShowParameter().getShowParameter().getCustomParam("pkId");
        String data = (String)CacheServiceHelper.get((String)("gptDynamicCache:data:" + pkId), String.class);
        log.info("dynamic data:{}", (Object)data);
        return JSONObject.parseArray((String)data, JSONObject.class);
    }
}

