/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class GptFactorsDataPlugin
extends AbstractBasePlugin
implements IGPTAction,
Serializable {
    private static final Log log = LogFactory.getLog(GptFactorsDataPlugin.class);
    private static List<List<String>> datas = new ArrayList<List<String>>();
    private static final List<String> dataList = Lists.newArrayList((Object[])new String[]{"1,586.70", "1,591.00", "1,591.90", "1,592.80", "1,589.10", "1,590.50", "1,582.50", "1,576.80", "1,570.60", "1,567.10", "1,565.40", "1,561.90", "1,562.90", "1,560.90", "1,451.30", "1,557.50", "1,554.80", "1,547.70", "1,545.50", "1,543.70", "1,538.50", "1,537.80", "1,549.76", "1,552.86", "1,543.60", "1,544.40", "1,544.40", "1,532.85", "1,525.23", "1,508.63", "1,498.15", "1,486.26", "1,470.08", "1,461.32", "1,445.42", "1,436.80", "1,426.81", "1,429.67", "1,429.67", "1,429.67", "1,425.39", "1,397.44", "1,384.98", "1,380.84", "1,373.97", "1,359.02", "1,354.95", "1,352.25", "1,342.85", "1,338.83", "1,334.83", "1,332.16", "1,333.50", "1,330.83", "1,326.85", "1,315.02", "1,299.42", "1,287.83", "1,277.61", "1,275.06", "1,278.90", "1,275.30", "1,265.40", "1,248.00", "1,226.40", "1,209.10", "1,193.00", "1,175.10", "1,157.10", "1,139.80", "1,126.80", "1,117.10", "1,109.70", "1,105.40", "1,102.00", "1,098.60", "1,093.70", "1,088.70", "1,083.30", "1,080.30", "1,079.60", "1,079.70", "1,079.50", "1,080.50", "1,082.50", "1,084.40", "1,086.70", "1,090.20", "1,093.60", "1,095.80", "1,097.20", "1,097.90", "1,098.30", "1,098.10", "1,097.70", "1,093.90", "1,088.90", "1,049.10", "1,075.10", "1,066.20", "1,061.80", "1,050.50", "1,041.80", "1,058.74", "1,052.43", "1,050.32", "1,037.87", "1,037.87", "1,037.87", "1,037.87", "1,040.99", "1,043.08", "1,047.27", "1,053.59", "1,056.76", "1,073.94", "1,096.98", "1,114.82", "1,115.93", "1,129.49"});
    private static final String json;
    private static final String ENTRY_ENTITY = "entryentity";

    private void initdata() {
        if (datas == null || datas.isEmpty()) {
            datas = (List)SerializationUtils.fromJsonString((String)json, ArrayList.class);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap", "retract"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"retract"});
        this.initdata();
        this.loadData(12);
    }

    private void loadData(int top) {
        int size = Math.min(top, datas.size());
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        if (size == 0) {
            return;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, size);
        model.beginInit();
        for (int i = 0; i < size; ++i) {
            List<String> rowdata = datas.get(i);
            for (int col = 0; col < 2; ++col) {
                model.setValue("factor" + col, (Object)rowdata.get(col), i);
            }
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("buttonap")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"retract"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap"});
            this.loadData(120);
        }
        if (clickKey.equals("retract")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"retract"});
            this.loadData(12);
        }
    }

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        log.info("invokeAction,action:{},params:{}", (Object)action, (Object)params.toString());
        StringBuilder url = new StringBuilder(UrlService.getDomainContextUrl());
        url.append("?formId=").append("eb_factordata_gpt");
        url.append("&gaiIframeSize={\"height\":646}");
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        returnParams.put("url", url.toString());
        log.info("invokeAction,returnUrl:{}", (Object)((Object)returnParams).toString());
        return returnParams;
    }

    static {
        Calendar c = Calendar.getInstance();
        c.set(1, 2021);
        c.set(2, 12);
        List monthList = dataList.stream().map(data -> {
            int year = c.get(1);
            int month = c.get(2);
            c.set(2, month - 1);
            return ResManager.loadResFormat((String)"%1\u5e74%2\u6708", (String)"GptFactorsDataPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{year, month});
        }).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataList.size(); ++i) {
            sb.append("  [\"");
            sb.append((String)monthList.get(i));
            sb.append("\",\"");
            sb.append(dataList.get(i));
            sb.append("\"],");
        }
        json = "[" + sb.substring(0, sb.length() - 1) + "]";
    }
}

