/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.formplugin.gpt.action.IGPTEbAction;
import kd.epm.eb.formplugin.gpt.constant.GptForecastConstants;
import org.apache.commons.lang3.StringUtils;

public class GptForecastActionPlugin
extends AbstractBasePlugIn
implements IGPTFormAction,
Serializable {
    private static final Log log = LogFactory.getLog(GptForecastActionPlugin.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";
    private static final String SUC_MSG_KEY = "title";
    private static final String RET_MSG_KEY = "msginfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        GptForecastConstants.Action actionObj;
        super.itemClick(evt);
        String action = evt.getItemKey();
        String paramStr = this.getModel().getValue("param").toString();
        Map<String, String> paramMap = Collections.emptyMap();
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            JSONObject jsonObject = JSON.parseObject((String)paramStr);
            paramMap = jsonObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
        }
        if ((actionObj = GptForecastConstants.Action.find(action)) == null) {
            throw new KDBizException("Not Support Action, Check It.");
        }
        Map<String, String> resultMap = this.invokeAction(this.getView().getPageId(), actionObj.getActionName(), paramMap);
        this.getModel().setValue("result", (Object)resultMap.toString());
    }

    public Map<String, String> invokeAction(String pageId, String action, Map<String, String> params) {
        log.info("{} invokeAction action:{} params:{}", new Object[]{LOG_PREFIX, action, params.toString()});
        Map<String, String> ret = new HashMap<String, String>(2);
        GptForecastConstants.Action actionObj = GptForecastConstants.Action.find(action);
        if (actionObj == null) {
            ret.put(RET_MSG_KEY, "Not Support Action, Check It.");
            return ret;
        }
        try {
            Class<?> actionClazz = Class.forName(actionObj.getActionClass());
            IGPTEbAction ebAction = (IGPTEbAction)actionClazz.newInstance();
            ret = ebAction.invokeAction(pageId, action, params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ret.put(RET_MSG_KEY, "500:" + e.getMessage());
        }
        log.info("{} invokeAction action:{} return:{}", new Object[]{LOG_PREFIX, action, ret});
        return ret;
    }
}

