/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.forecast.QueryService;
import kd.epm.eb.business.forecast.gpt.GptForecastService;
import kd.epm.eb.business.forecast.gpt.GptParamService;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.PropsDataType;
import kd.epm.eb.formplugin.analysiscanvas.model.PropsData;
import org.apache.commons.lang3.StringUtils;

public class GptForecastComparePlugin
extends AbstractBasePlugin
implements IGPTAction,
Serializable {
    private static final Log log = LogFactory.getLog(GptForecastComparePlugin.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";
    private static final String CACHE_KEY = "cmp:param";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TABLE_TITLE = "sandbox";
    private static final String INDEX = "index";

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        log.info("{} invokeAction,action:{},params:{}", new Object[]{LOG_PREFIX, action, params.toString()});
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        JSONObject paramObj = GptParamService.getInstance().load(action);
        log.info("{} invokeAction action:{} paramObj:{}", new Object[]{LOG_PREFIX, action, paramObj.toJSONString()});
        CacheServiceHelper.put((String)"gptParamCache:cmp:param", (Object)paramObj.getString("attr"));
        String domain = System.getProperty("domain.contextUrl");
        String url = domain + "?formId=" + "eb_predict_cmp";
        returnParams.put("url", url);
        log.info("invokeAction,returnUrl:{}", (Object)url);
        return returnParams;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.sendDataInitEvent();
    }

    private void refreshEntry(JSONObject paramObj) {
        String modelNumber = paramObj.getString("model");
        String datasetNum = paramObj.getString("dataset");
        long modelId = GptForecastService.getInstance().queryModelId(modelNumber);
        long datasetId = GptForecastService.getInstance().queryDatasetId(modelId, datasetNum);
        int sandboxLen = paramObj.getIntValue("boxes");
        List boxIdList = GptForecastService.getInstance().getLatestBox(sandboxLen);
        Collections.reverse(boxIdList);
        String dim = paramObj.getString("dim");
        JSONObject defaultDim = JSON.parseObject((String)dim);
        String bpNumStart = paramObj.getString("start");
        String bpNumEnd = paramObj.getString("end");
        List yearList = PredictHelper.getYearList((String)bpNumStart, (String)bpNumEnd);
        Set<String> bgMemNumSet = yearList.stream().map(year -> "FY" + year).collect(Collectors.toSet());
        String cellStr = paramObj.getString("cells");
        List cellList = JSON.parseArray((String)cellStr, JSONObject.class);
        String dataUnitStr = paramObj.getString("dataUnit");
        Map<String, String> dataUnitMap = this.getDataUnitMap(dataUnitStr);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Map<String, Long> viewMap = this.getViewMap(sortedDimList, modelCache, datasetId);
        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(16);
        JSONObject dataObj = new JSONObject();
        JSONObject chartData1 = new JSONObject();
        JSONObject chartData2 = new JSONObject();
        JSONObject chartData3 = new JSONObject();
        for (JSONObject dimMemMap : cellList) {
            this.buildQueryDim(modelCache, sortedDimList, dimMemMap, defaultDim, queryDim, bgMemNumSet);
        }
        AtomicInteger row = new AtomicInteger(0);
        ArrayList yDataList = new ArrayList(4);
        ArrayList legendNameList = new ArrayList(4);
        for (JSONObject dimMemMap : cellList) {
            int rowIndex = row.getAndIncrement();
            ArrayList<JSONObject> yData = new ArrayList<JSONObject>(boxIdList.size() * yearList.size());
            ArrayList<String> legendNameStringList = new ArrayList<String>(16);
            for (int colIndex = 0; colIndex < boxIdList.size(); ++colIndex) {
                String type = rowIndex == 2 ? "line" : "bar";
                String profit = rowIndex == 2 ? ResManager.loadKDString((String)"\u5229\u6da6\u7387", (String)"GptForecastComparePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5229\u6da6", (String)"GptForecastComparePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                String legendName = rowIndex == 0 || rowIndex == 3 ? String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u65b9\u6848-%s", (String)"GptForecastComparePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), colIndex + 1) : String.format(ResManager.loadKDString((String)"\u65b9\u6848-%s", (String)"GptForecastComparePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), colIndex + 1 + profit);
                legendNameStringList.add(legendName);
                JSONObject data = new JSONObject();
                data.fluentPut("name", (Object)legendName);
                data.fluentPut("type", (Object)type);
                ArrayList<JSONObject> dataList = new ArrayList<JSONObject>(16);
                Long sandboxId = (Long)boxIdList.get(colIndex);
                Map bgCellMap = QueryService.getInstance().queryCurrData(modelId, datasetId, sandboxId, queryDim, viewMap);
                for (Year year2 : yearList) {
                    JSONObject jsonObject = new JSONObject();
                    String periodNumber = "FY" + year2;
                    dimMemMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), (Object)periodNumber);
                    String cellValue = this.getCellValue(defaultDim, modelCache, sortedDimList, dataUnitMap, bgCellMap, dimMemMap);
                    jsonObject.fluentPut("name", (Object)year2.toString());
                    jsonObject.fluentPut("value", (Object)cellValue);
                    dataList.add(jsonObject);
                }
                data.fluentPut("data", dataList);
                yData.add(data);
            }
            legendNameList.add(legendNameStringList);
            yDataList.add(yData);
        }
        List year3 = yearList.stream().map(Year::toString).collect(Collectors.toList());
        chartData1.fluentPut("title", (Object)ResManager.loadKDString((String)"\u6536\u5165\u5bf9\u6bd4", (String)"GptForecastComparePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        chartData1.fluentPut("legend", legendNameList.get(0));
        chartData1.fluentPut("xData", year3);
        chartData1.fluentPut("yData", yDataList.get(0));
        ArrayList legend2 = new ArrayList();
        ArrayList yDataList2 = new ArrayList();
        legend2.addAll((Collection)legendNameList.get(1));
        legend2.addAll((Collection)legendNameList.get(2));
        yDataList2.addAll((Collection)yDataList.get(1));
        yDataList2.addAll((Collection)yDataList.get(2));
        chartData2.fluentPut("title", (Object)ResManager.loadKDString((String)"\u51c0\u5229\u6da6\u5bf9\u6bd4", (String)"GptForecastComparePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        chartData2.fluentPut("legend", legend2);
        chartData2.fluentPut("xData", year3);
        chartData2.fluentPut("yData", yDataList2);
        chartData3.fluentPut("title", (Object)ResManager.loadKDString((String)"\u8425\u9500\u8d39\u7528\u5bf9\u6bd4", (String)"GptForecastComparePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        chartData3.fluentPut("legend", legendNameList.get(3));
        chartData3.fluentPut("xData", year3);
        chartData3.fluentPut("yData", yDataList.get(3));
        dataObj.fluentPut("chartData1", (Object)chartData1);
        dataObj.fluentPut("chartData2", (Object)chartData2);
        dataObj.fluentPut("chartData3", (Object)chartData3);
        dataObj.fluentPut("compType", (Object)3);
        this.sendDataUpdateEvent(dataObj);
    }

    private String getCellValue(JSONObject defaultDim, IModelCacheHelper modelCache, List<String> sortedDimList, Map<String, String> dataUnitMap, Map<MembersKey, BGCell> bgCellMap, JSONObject dimMemMap) {
        Map<String, String> queryCellMap = this.getQueryCellMap(modelCache, sortedDimList, dimMemMap, defaultDim);
        Object result = null;
        String unitStr = dataUnitMap.get(queryCellMap.get(SysDimensionEnum.Account.getNumber()));
        BigDecimal dataUnit = PredictHelper.getDataUnit((String)unitStr);
        Object cellValue = QueryService.getInstance().getCellValue(modelCache, queryCellMap, sortedDimList, bgCellMap, dataUnit);
        if (cellValue != null) {
            BigDecimal bigDecimal = cellValue instanceof Long ? BigDecimal.valueOf((Long)cellValue) : (BigDecimal)cellValue;
            String metricNumber = queryCellMap.get(SysDimensionEnum.Metric.getNumber());
            String metricDataType = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).getDatatype();
            result = MetricDataTypeEnum.RATE.getIndex().equals(metricDataType) ? Double.valueOf(bigDecimal.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP).doubleValue()) : Double.valueOf(bigDecimal.doubleValue());
        }
        String value = "";
        if (result != null) {
            value = result.toString();
        }
        return value;
    }

    private Map<String, Long> getViewMap(List<String> sortedDimList, IModelCacheHelper modelCache, long datasetId) {
        HashMap<String, Long> dimViewMap = new HashMap<String, Long>(sortedDimList.size());
        sortedDimList.forEach(dimNum -> {
            Map viewsByDataSetIncludeBase = modelCache.getViewsByDataSetIncludeBase(Long.valueOf(datasetId));
            long viewId = viewsByDataSetIncludeBase == null ? 0L : IDUtils.toLong(viewsByDataSetIncludeBase.get(dimNum));
            dimViewMap.put((String)dimNum, viewId);
        });
        return dimViewMap;
    }

    private Map<String, String> getDataUnitMap(String dataUnitStr) {
        if (StringUtils.isEmpty((CharSequence)dataUnitStr)) {
            return Collections.emptyMap();
        }
        JSONObject dataUnitObj = JSON.parseObject((String)dataUnitStr);
        return dataUnitObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
    }

    private void buildQueryDim(IModelCacheHelper modelCache, List<String> sortedDimList, JSONObject dimMemMap, JSONObject defaultDim, Map<String, Set<String>> queryDim, Set<String> bgMemNumSet) {
        sortedDimList.forEach(dim -> {
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dim)) {
                queryDim.put((String)dim, bgMemNumSet);
            } else {
                String memNum = dimMemMap.getString(dim);
                if (StringUtils.isBlank((CharSequence)memNum)) {
                    memNum = defaultDim.getString(dim);
                }
                if (StringUtils.isBlank((CharSequence)memNum)) {
                    Dimension dimension = modelCache.getDimension(dim);
                    memNum = dimension.getNoneNumber();
                }
                Set memSet = queryDim.computeIfAbsent((String)dim, k -> new HashSet(16));
                memSet.add(memNum);
            }
        });
    }

    private Map<String, String> getQueryCellMap(IModelCacheHelper modelCache, List<String> sortedDimList, JSONObject dimMemMap, JSONObject defaultDim) {
        HashMap<String, String> cellMap = new HashMap<String, String>(sortedDimList.size());
        sortedDimList.forEach(dim -> {
            String memNum = dimMemMap.getString(dim);
            if (StringUtils.isBlank((CharSequence)memNum)) {
                memNum = defaultDim.getString(dim);
            }
            if (StringUtils.isBlank((CharSequence)memNum)) {
                Dimension dimension = modelCache.getDimension(dim);
                memNum = dimension.getNoneNumber();
            }
            cellMap.put((String)dim, memNum);
        });
        return cellMap;
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = AnalysisCanvasUtils.unCompressData((String)evt.getEventArgs());
        log.info("customEvent eventName:{}, arg:{}", (Object)eventName, (Object)eventArgs);
        if ("predict".equals(eventName)) {
            String attr = (String)CacheServiceHelper.get((String)"gptParamCache:cmp:param", String.class);
            log.info("attrParam:{}", (Object)attr);
            JSONObject paramObj = JSON.parseObject((String)attr);
            this.refreshEntry(paramObj);
        }
    }

    private void sendDataInitEvent() {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_INIT);
        int compType = 3;
        propsData.setData(new JSONObject().fluentPut("compType", (Object)compType));
        this.sendData(propsData);
    }

    private void sendDataUpdateEvent(JSONObject dataObj) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.DATA_UPDATE);
        propsData.setData(dataObj);
        this.sendData(propsData);
    }

    private void sendData(PropsData data) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)data);
    }
}

