/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.forecast.gpt.GptParamService;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class GptForecastPlugin
extends AbstractBasePlugin
implements IGPTAction,
Serializable {
    private static final Log log = LogFactory.getLog(GptForecastPlugin.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        String url;
        String formId;
        String appId;
        String pkId;
        log.info("invokeAction,action:{},params:{}", (Object)action, (Object)params.toString());
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        JSONObject paramObj = GptParamService.getInstance().load(action);
        log.info("{} invokeAction action:{} paramObj:{}", new Object[]{LOG_PREFIX, action, paramObj.toJSONString()});
        String domain = paramObj.getString("domain");
        if (StringUtils.isBlank((CharSequence)domain)) {
            domain = System.getProperty("domain.contextUrl");
        }
        if (StringUtils.isBlank((CharSequence)(pkId = paramObj.getString("pkId")))) {
            pkId = String.valueOf(System.currentTimeMillis());
        }
        if (StringUtils.isBlank((CharSequence)(appId = paramObj.getString("appId")))) {
            appId = ApplicationTypeEnum.BGM.getAppnum();
        }
        if (StringUtils.isBlank((CharSequence)(formId = paramObj.getString("formId")))) {
            formId = "eb_predict_gpt";
        }
        if (domain.startsWith("bizAction")) {
            url = domain + "&gaiParams={\"appId\":\"" + appId + "\",\"billFormId\":\"" + formId + "\",\"billPkId\":\"" + pkId + "\"}";
        } else {
            String width = paramObj.getString("width");
            String height = paramObj.getString("height");
            if (StringUtils.isBlank((CharSequence)width)) {
                width = "1200";
            }
            if (StringUtils.isBlank((CharSequence)height)) {
                height = "650";
            }
            url = domain + "?formId=" + formId + "&pkId=" + paramObj.getString("pkId") + "&gaiIframeSize={\"width\":" + width + ",\"height\":" + height + "}";
        }
        CacheServiceHelper.put((String)("gptParamCache:" + pkId), (Object)paramObj.getString("attr"));
        returnParams.put("url", url);
        log.info("invokeAction,returnUrl:{}", (Object)url);
        return returnParams;
    }
}

