/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.forecast.gpt.GptForecastService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.formplugin.gpt.action.IGPTEbAction;

public class ClearPredictAction
implements IGPTEbAction {
    private static final Log log = LogFactory.getLog(ClearPredictAction.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";

    @Override
    public Map<String, String> doAction(String pageId, String action, JSONObject paramObj, Map<String, String> pageParams) {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        try {
            String modelNumber = paramObj.getString("model");
            String datasetNum = paramObj.getString("dataset");
            long modelId = GptForecastService.getInstance().queryModelId(modelNumber);
            long datasetId = GptForecastService.getInstance().queryDatasetId(modelId, datasetNum);
            GptForecastService.getInstance().deleteCanvasSandbox();
            String startNumber = paramObj.getString("timeStart");
            String endNumber = paramObj.getString("timeEnd");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List timeMemberList = modelCache.getMemberBetween(SysDimensionEnum.BudgetPeriod.getNumber(), startNumber, endNumber, true);
            Set bpMemSet = timeMemberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            HashMap deleteRange = new HashMap(16);
            deleteRange.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpMemSet);
            ShrekOlapServiceHelper.deleteData((Long)modelId, (Long)datasetId, deleteRange, (String)SysDimensionEnum.Version.getNumber(), (String)"vAapplication");
            ret.put("msginfo", paramObj.getString("title"));
        }
        catch (Exception e) {
            ret.put("msginfo", String.format(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ForecastPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }
}

