/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.epm.eb.business.forecast.gpt.GptParamService;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import org.apache.commons.lang3.StringUtils;

public interface IGPTEbAction {
    public static final Log log = LogFactory.getLog(IGPTEbAction.class);
    public static final String LOG_PREFIX = "EB-FORECAST-GPT";
    public static final String SUC_MSG_KEY = "title";
    public static final String RET_MSG_KEY = "msginfo";

    public Map<String, String> doAction(String var1, String var2, JSONObject var3, Map<String, String> var4);

    default public Map<String, String> invokeAction(String pageId, String action, Map<String, String> pageParams) {
        log.info("{} invokeAction action:{} params:{}", new Object[]{LOG_PREFIX, action, pageParams.toString()});
        JSONObject paramObj = GptParamService.getInstance().load(action);
        log.info("{} invokeAction action:{} paramObj:{}", new Object[]{LOG_PREFIX, action, paramObj.toJSONString()});
        Map<String, String> ret = this.doAction(pageId, action, paramObj, pageParams);
        log.info("{} invokeAction action:{} return:{}", new Object[]{LOG_PREFIX, action, ret});
        return ret;
    }

    default public IFormView getFormView(String pageId, Map<String, String> ret) {
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        if (formView == null) {
            log.info("{} formView null pageId:{}", (Object)LOG_PREFIX, (Object)pageId);
            ret.put(RET_MSG_KEY, ResManager.loadKDString((String)"\u8bf7\u5728\u9884\u6d4b\u7ed3\u679c\u9875\u9762\u4e0b\u4ea4\u4e92\u3002", (String)"ForecastPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return formView;
    }

    default public String getYearTotal(JSONObject dataObj) {
        JSONArray yearTotal = dataObj.getJSONArray("yearTotal");
        return yearTotal.stream().map(obj -> {
            JSONObject jsonObj = (JSONObject)obj;
            return jsonObj.getString("name") + ": " + jsonObj.getString("val") + jsonObj.getString("unit");
        }).collect(Collectors.joining("\u3001"));
    }

    default public String buildRedirectUrl(JSONObject paramObj, String pkId) {
        String url;
        String formId;
        String appId;
        String domain = paramObj.getString("domain");
        if (StringUtils.isBlank((CharSequence)domain)) {
            domain = System.getProperty("domain.contextUrl");
        }
        if (StringUtils.isBlank((CharSequence)(appId = paramObj.getString("appId")))) {
            appId = ApplicationTypeEnum.BGM.getAppnum();
        }
        if (StringUtils.isBlank((CharSequence)(formId = paramObj.getString("formId")))) {
            formId = "eb_predict_gpt";
        }
        if (domain.startsWith("bizAction")) {
            url = domain + "&gaiParams={\"appId\":\"" + appId + "\",\"billFormId\":\"" + formId + "\",\"billPkId\":\"" + pkId + "\"}";
        } else {
            String width = paramObj.getString("width");
            String height = paramObj.getString("height");
            if (StringUtils.isBlank((CharSequence)width)) {
                width = "1200";
            }
            if (StringUtils.isBlank((CharSequence)height)) {
                height = "650";
            }
            url = domain + "?formId=" + formId + "&pkId=" + pkId + "&gaiIframeSize={\"width\":" + width + ",\"height\":" + height + "}";
            String attrParam = paramObj.getString("attrParam");
            if (StringUtils.isNotBlank((CharSequence)attrParam)) {
                url = url + "&" + attrParam;
            }
        }
        return url;
    }
}

