/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.forecast.gpt.GptForecast;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.formplugin.gpt.action.IGPTEbAction;
import org.apache.commons.lang3.StringUtils;

public class PredictAction
implements IGPTEbAction {
    private static final Log log = LogFactory.getLog(PredictAction.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";

    @Override
    public Map<String, String> doAction(String pageId, String action, JSONObject paramObj, Map<String, String> pageParams) {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        try {
            String attr = paramObj.getString("attr");
            log.info("{} attrParam:{}", (Object)LOG_PREFIX, (Object)attr);
            GptForecast gptForecast = new GptForecast(attr, true);
            gptForecast.doPredict();
            String pkId = paramObj.getString("pkId");
            if (StringUtils.isBlank((CharSequence)pkId)) {
                pkId = String.valueOf(System.currentTimeMillis());
            }
            String url = this.buildRedirectUrl(paramObj, pkId);
            CacheServiceHelper.put((String)("gptParamCache:" + pkId), (Object)paramObj.getString("attr"));
            ret.put("msginfo", paramObj.getString("title"));
            ret.put("url", url);
            log.info("{} PREDICT returnUrl:{}", (Object)LOG_PREFIX, (Object)url);
        }
        catch (Exception e) {
            ret.put("msginfo", String.format(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ForecastPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }
}

