/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.epm.eb.business.forecast.gpt.GptForecast;
import kd.epm.eb.formplugin.analysiscanvas.constant.PropsDataType;
import kd.epm.eb.formplugin.analysiscanvas.model.PropsData;
import kd.epm.eb.formplugin.gpt.action.IGPTEbAction;
import org.apache.commons.lang3.StringUtils;

public class RePredictAction
implements IGPTEbAction {
    private static final Log log = LogFactory.getLog(RePredictAction.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";

    @Override
    public Map<String, String> doAction(String pageId, String action, JSONObject paramObj, Map<String, String> pageParams) {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        IFormView formView = this.getFormView(pageId, ret);
        if (formView == null) {
            return ret;
        }
        try {
            String formId = ((FormView)formView).getFormId();
            CustomControl customcontrol = (CustomControl)formView.getControl("customcontrolap");
            if (customcontrol == null) {
                log.info("{} currPage is not eb_predict_gpt, formId:{}", (Object)LOG_PREFIX, (Object)formId);
                ret.put("msginfo", ResManager.loadKDString((String)"\u8bf7\u5207\u6362\u81f3\u9884\u6d4b\u7ed3\u679c\u9875\u9762\u3002", (String)"ForecastPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                String lastYearTotalStr = "";
                String lastAttr = formView.getPageCache().get("req_param");
                log.info("{} formId:{} lastAttrParam:{}", new Object[]{LOG_PREFIX, formId, lastAttr});
                if (StringUtils.isNotBlank((CharSequence)lastAttr)) {
                    GptForecast lastGptForecast = new GptForecast(lastAttr, false);
                    JSONObject lastDataObj = lastGptForecast.getPredData(null);
                    lastYearTotalStr = this.getYearTotal(lastDataObj);
                }
                String attr = paramObj.getString("attr");
                log.info("{} formId:{} attrParam:{}", new Object[]{LOG_PREFIX, formId, attr});
                formView.getPageCache().put("req_param", attr);
                GptForecast gptForecast = new GptForecast(attr, true);
                gptForecast.doPredict();
                JSONObject dataObj = gptForecast.getPredData(null);
                String yearTotalStr = this.getYearTotal(dataObj);
                PropsData propsData = new PropsData();
                propsData.setDataType(PropsDataType.DATA_RELOAD);
                customcontrol.setData((Object)propsData);
                List actionResult = formView.getActionResult();
                String value = SerializationUtils.toJsonString((Object)actionResult);
                ret.put("actionresult", value);
                ret.put("yearTotal", yearTotalStr);
                ret.put("lastYearTotal", lastYearTotalStr);
                ret.put("msginfo", paramObj.getString("title"));
                log.info("{} RE_PREDICT actionResult:{}", (Object)LOG_PREFIX, (Object)value);
            }
        }
        catch (Exception e) {
            ret.put("msginfo", String.format(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ForecastPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }
}

