/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.gpt.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ShowFormUtil {
    private static final Log log = LogFactory.getLog(ShowFormUtil.class);

    public static void openBill(String appId, String billFormId, Object billPkId, IFormView myView, String crossPageData) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("formId", billFormId);
        para.put("pkId", billPkId);
        HashMap<String, Object> tmpParams = new HashMap<String, Object>(para);
        tmpParams.put("view", myView);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appNumber = appInfo.getNumber();
        String mainPageId = appInfo.getHomeId();
        if (mainPageId != null && mainPageId.trim().length() != 0) {
            DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)"bos_formmeta", (String)"number, inheritpath");
            if (pageObject == null) {
                throw new KDBizException("Application main page not exists\u3002");
            }
            String mainPageNumber = pageObject.getString("number");
            String billPkIdString = billPkId.toString();
            tmpParams.put("appname", appInfo.getName().getLocaleValue());
            tmpParams.put("appmainnumber", mainPageNumber);
            tmpParams.put("pkId", billPkIdString);
            OpenPageUtils.openApp((String)appInfo.getNumber(), null, tmpParams, (IFormView)myView);
            tmpParams.remove("view");
            String pageId = ShowFormUtil.getBillPageId(myView.getMainView(), billFormId, billPkIdString);
            IFormView formIdPage = myView.getViewNoPlugin(pageId);
            if (formIdPage == null) {
                IFormView mainPageView = myView.getMainView();
                if (mainPageView == null) {
                    log.info("openBill----mainPageView or mainPageID is null");
                } else {
                    String appPageId = ShowFormUtil.getAppPageId(mainPageView.getPageId(), appNumber);
                    IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
                    if (appPageView != null) {
                        if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                            appPageView = mainPageView;
                        }
                        FormShowParameter fsp = ShowFormUtil.createShowFormParameter(billFormId, tmpParams);
                        fsp.setHasRight(true);
                        fsp.setAppId(appNumber);
                        fsp.setCustomParam("appid", (Object)appNumber);
                        fsp.setCustomParam("crossPageData", (Object)crossPageData);
                        ShowFormUtil.addCustomParam(fsp, tmpParams);
                        fsp.setPageId(pageId);
                        if (myView.getPageId().equals(appPageView.getPageId())) {
                            myView.showForm(fsp);
                        } else {
                            appPageView.showForm(fsp);
                            myView.sendFormAction(appPageView);
                        }
                    } else {
                        log.info("openBill----appPageView is null");
                    }
                }
            }
        } else {
            throw new KDBizException("Application main page no config\u3002");
        }
    }

    public static FormShowParameter createShowFormParameter(String formNumber, Map<String, Object> parameter) {
        FormShowParameter sp = FormShowParameter.createFormShowParameter(parameter);
        sp.getOpenStyle().setShowType(ShowType.NewTabPage);
        sp.getOpenStyle().setTargetKey("_submaintab_");
        HashMap map = new HashMap();
        sp.setCustomParams(map);
        return sp;
    }

    public static void addCustomParam(FormShowParameter fsp, Map<String, Object> customParams) {
        if (customParams != null) {
            customParams.forEach((arg_0, arg_1) -> ((FormShowParameter)fsp).setCustomParam(arg_0, arg_1));
        }
    }

    public static String getBillPageId(IFormView targetView, String formId, String billPkid) {
        return formId + targetView.getPageId() + "_" + billPkid;
    }

    public static String getAppPageId(String mainPageViewPageId, String appNumber) {
        return appNumber + mainPageViewPageId;
    }
}

