/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.guides;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.epm.eb.common.guide.GuideData;
import kd.epm.eb.common.guide.GuideItem;

public class GuidesBuilder {
    private static final GuidesBuilder instance = new GuidesBuilder();

    private GuidesBuilder() {
    }

    public static GuidesBuilder getInstance() {
        return instance;
    }

    public FlexPanelAp createGuide(GuideData items) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setGrow(0);
        flexPanelAp.setShrink(0);
        flexPanelAp.setJustifyContent("space-between");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setDirection("column");
        flexPanelAp.setWrap(false);
        int seq = 1;
        int endSeq = items.getItemList().size();
        for (GuideItem guideItem : items.getItemList()) {
            FlexPanelAp item = this.createItem(seq, endSeq, guideItem, this.getItemStatus(seq, items.getEditIndex(), items.getViewIndex()));
            flexPanelAp.getItems().add(item);
            ++seq;
        }
        return flexPanelAp;
    }

    private int getItemStatus(int seq, int editSeq, int viewSeq) {
        int itemStatus = seq == editSeq ? 2 : (seq > editSeq ? 1 : (seq == viewSeq ? 4 : 3));
        return itemStatus;
    }

    private FlexPanelAp createItem(int seq, int endSeq, GuideItem guideItem, int itemStatus) {
        FlexPanelAp itemAp = new FlexPanelAp();
        itemAp.setShrink(1);
        itemAp.setGrow(1);
        itemAp.setDirection("column");
        itemAp.setAlignItems("center");
        itemAp.setWrap(false);
        itemAp.setKey("g-item-" + seq);
        LabelAp upLine = this.createLine(seq, true, endSeq, itemStatus);
        LabelAp downLine = this.createLine(seq, false, endSeq, itemStatus);
        LabelAp numbSign = this.createNumbSign(seq, 30, itemStatus);
        LabelAp textSign = this.createTextSign(seq, guideItem.getTitle(), itemStatus);
        itemAp.getItems().add(upLine);
        itemAp.getItems().add(numbSign);
        itemAp.getItems().add(textSign);
        itemAp.getItems().add(downLine);
        return itemAp;
    }

    private LabelAp createTextSign(int seq, String itemText, int itemStatus) {
        LabelAp textSign = new LabelAp();
        textSign.setKey("g-item-down-text-" + seq);
        if (itemStatus == 2) {
            textSign.setForeColor("themeColor");
        }
        textSign.setName(new LocaleString(itemText));
        textSign.setTextAlign("center");
        return textSign;
    }

    private LabelAp createNumbSign(int seq, int width, int status) {
        String fontColor;
        String text;
        String widthVal = width + "px";
        LabelAp numbSign = new LabelAp();
        numbSign.setKey("g-item-up-num-" + seq);
        numbSign.setClickable(true);
        numbSign.setWidth(new LocaleString(widthVal));
        numbSign.setHeight(new LocaleString(widthVal));
        numbSign.setRadius(width / 2 + "px");
        numbSign.setLineHeight(width - 4 + "px");
        numbSign.setLabelStyle("1");
        numbSign.setTextAlign("center");
        numbSign.setFontSize(14);
        String backColor = "white";
        String bordColor = null;
        if (status == 3) {
            text = "\u2713";
            fontColor = "green";
        } else {
            text = String.valueOf(seq);
            if (status == 1) {
                fontColor = "#d9d9d9";
            } else if (status == 2) {
                fontColor = "themeColor";
            } else {
                fontColor = "white";
                backColor = "themeColor";
                bordColor = "themeColor";
            }
        }
        numbSign.setName(new LocaleString(text));
        numbSign.setForeColor(fontColor);
        numbSign.setBackColor(backColor);
        Margin margin = new Margin();
        margin.setTop("2px");
        Style style = this.getBordStyle(bordColor == null ? fontColor : bordColor);
        style.setMargin(margin);
        numbSign.setStyle(style);
        return numbSign;
    }

    private LabelAp createLine(int seq, boolean isUp, int endSeq, int itemStatus) {
        LabelAp line = new LabelAp();
        line.setShrink(1);
        line.setGrow(1);
        line.setWidth(new LocaleString("3px"));
        if (isUp) {
            line.setKey("g-item-line-u-" + seq);
            if (seq != 1) {
                if (itemStatus == 1) {
                    line.setBackColor("#e5e5e5");
                } else {
                    line.setBackColor("themeColor");
                }
            }
        } else {
            line.setKey("g-item-line-d-" + seq);
            if (seq != endSeq) {
                if (itemStatus > 2) {
                    line.setBackColor("themeColor");
                } else {
                    line.setBackColor("#e5e5e5");
                }
            }
        }
        return line;
    }

    private Style getBordStyle(String borderColor) {
        Style style = new Style();
        Border border = new Border();
        String borderVal = "2px_solid_" + borderColor;
        border.setTop(borderVal);
        border.setBottom(borderVal);
        border.setLeft(borderVal);
        border.setRight(borderVal);
        style.setBorder(border);
        return style;
    }
}

