/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.AccountSystemInportTypeEnum;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.formplugin.importplugin.DimSysImportBasePlugin;

public class AccountSysImport
extends DimSysImportBasePlugin {
    private DynamicObject metric = null;
    public static final String DATASET = "dataset";
    private static final String DATASET_NUMBER = "dataset_number";

    @Override
    public void afterCreateNewData(EventObject e) {
        String datasetId = (String)this.getView().getFormShowParameter().getCustomParam("datasetId");
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
            DynamicObject datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)modelId);
            datasetId = String.valueOf(datasetObj.getLong("id"));
        }
        this.getPageCache().put(DATASET, datasetId);
        this.getPageCache().put(DATASET_NUMBER, (String)this.getView().getFormShowParameter().getCustomParam(DATASET_NUMBER));
        super.afterCreateNewData(e);
        this.displayColor();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        if ("combofield".equals(prop)) {
            this.initLeftTree();
        }
        this.displayColor();
    }

    private void displayColor() {
        Set<String> rightNumbers = this.getRightNodeNumber();
        TreeNode cacheLeftRoot = this.getCacheLeftRoot();
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(cacheLeftRoot, list, true, 20);
        list.removeIf(l -> {
            Object number = this.getNodeProperty("number", (TreeNode)l);
            return number == null || !rightNumbers.contains(((String)this.getNodeProperty("number", (TreeNode)l)).toUpperCase());
        });
        this.setLeftTreeNoteColor("btngo", "blue", list, false);
    }

    @Override
    protected void setLeftTreeNoteColor(String key, String strColor, List<TreeNode> selectNode, boolean doAll) {
        if (doAll) {
            this.setLeftTreeColor(null, strColor, true);
        } else {
            ArrayList<String> leftNodeids = new ArrayList<String>(16);
            switch (key) {
                case "btnback": {
                    TreeNode rightRoot = selectNode.get(0);
                    this.getLeftNodesByRightTree(rightRoot, leftNodeids);
                    this.setLeftTreeColor(leftNodeids, "", false);
                    break;
                }
                case "btngo": {
                    Boolean allchildren = (Boolean)this.getModel().getValue("allchildren");
                    TreeNode leftRoot = new TreeNode();
                    if (allchildren.booleanValue()) {
                        leftRoot = this.getCacheNode("wholeLeftTree");
                    }
                    for (int i = 0; i < selectNode.size(); ++i) {
                        String nodeId = selectNode.get(i).getId();
                        if (allchildren.booleanValue()) {
                            TreeNode treeNode = leftRoot.getTreeNode(nodeId, 20);
                            ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
                            this.getAllChilden(treeNode, allchilden, true, 20);
                            for (TreeNode node : allchilden) {
                                node.setIsOpened(true);
                                leftNodeids.add((String)this.getNodeProperty("id", node));
                            }
                            continue;
                        }
                        leftNodeids.add(nodeId);
                    }
                    this.setLeftTreeColor(leftNodeids, "blue", false);
                    break;
                }
                case "btnupdate": {
                    selectNode.forEach(e -> leftNodeids.add(e.getId()));
                    this.setLeftTreeColor(leftNodeids, "blue", false);
                    break;
                }
                default: {
                    Set<String> rightNumbers = this.getRightNodeNumber();
                    TreeNode cacheLeftRoot = this.getCacheLeftRoot();
                    ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
                    this.getAllChilden(cacheLeftRoot, allchilden, true, 20);
                    for (TreeNode treeNode : allchilden) {
                        if (rightNumbers.contains(this.getNodeProperty("number", treeNode))) continue;
                        leftNodeids.add((String)this.getNodeProperty("id", treeNode));
                    }
                    this.setLeftTreeColor(leftNodeids, "", false);
                }
            }
        }
    }

    private void getLeftNodesByRightTree(TreeNode rightRoot, List<String> allNodeIds) {
        boolean newNode = this.isNewNode(rightRoot);
        if (newNode) {
            this.getLeftNodes(rightRoot, allNodeIds);
        } else {
            List children = rightRoot.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    this.getLeftNodesByRightTree(child, allNodeIds);
                }
            }
        }
    }

    private void getLeftNodes(TreeNode rightRoot, List<String> allNodeids) {
        String id = this.getNodeProperty("id", rightRoot).toString();
        allNodeids.add(id);
        List children = rightRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.getLeftNodes(child, allNodeids);
            }
        }
    }

    private void setLeftTreeColor(List<String> actSelectIds, String strColor, boolean doAll) {
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (doAll) {
            ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
            this.getAllChilden(leftRoot, allchilden, true, 20);
            for (TreeNode treeNode : allchilden) {
                treeNode.setColor(strColor);
            }
            treeleft.updateNodes(allchilden);
        } else {
            ArrayList<TreeNode> colorNodeLst = new ArrayList<TreeNode>();
            for (String id : actSelectIds) {
                TreeNode selectNode;
                if (id == null || (selectNode = leftRoot.getTreeNode(id, 20)) == null) continue;
                selectNode.setColor(strColor);
                colorNodeLst.add(selectNode);
            }
            treeleft.updateNodes(colorNodeLst);
        }
        treeleft.expand(leftRoot.getId());
        this.cacheLeftRoot(leftRoot);
    }

    @Override
    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
        List<Object> selectIds = new ArrayList(16);
        if (leftRoot != null && leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.collapseChild(leftRoot, treeleft);
            this.getAllChilden(leftRoot, allchilden, false, 20);
            List selectNodes = treeleft.getTreeState().getSelectedNodes();
            selectIds = selectNodes.stream().map(e -> (String)e.get("id")).collect(Collectors.toList());
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
        for (TreeNode node : allchilden) {
            if (!selectIds.contains(node.getId())) continue;
            treeleft.checkNode(node);
        }
    }

    @Override
    protected TreeNode getLeftRoot() {
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>();
        LinkedHashSet allNumbers = Sets.newLinkedHashSet();
        String typeIndex = (String)this.getModel().getValue("combofield");
        AccountSystemInportTypeEnum typeEnum = AccountSystemInportTypeEnum.getEnumByIndex((String)typeIndex);
        if (typeEnum.getTypeBaseDataKey() == null) {
            Long useOrg = RequestContext.get().getOrgId();
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)typeEnum.getBaseDataKey(), (Long)useOrg);
            QFilter q1 = new QFilter("enable", "=", (Object)"1");
            String selectFields1 = "id,longnumber,name,number,parent.id as parentid,level as dseq ,isleaf,level";
            DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)typeEnum.getBaseDataKey(), (String)selectFields1, (QFilter[])new QFilter[]{qFilter, q1}, (String)"number,level");
            if (!ds.isEmpty()) {
                for (Row row : ds) {
                    allNodes.put(row.getString("id"), this.createTreeNode(row, "left"));
                }
            }
        } else {
            QFilter qfDefault = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
            String selectFields = "id,'' as longnumber,name,number,parent.id as parentid,level as dseq ,isleaf,level";
            DataSet ds = QueryServiceHelper.queryDataSet((String)"AccountSysImport1", (String)typeEnum.getTypeBaseDataKey(), (String)selectFields, (QFilter[])qfDefault.toArray(), (String)"number,level");
            if (!ds.isEmpty()) {
                for (Row row : ds) {
                    if (!allNumbers.add(row.getString("number"))) continue;
                    allNodes.put(row.getString("id"), this.createLeftTypeTreeNode(row));
                }
            }
            String selectFields2 = "id,longnumber,name,number,parent.id as parentid,level as dseq ,isleaf,level,accounttype";
            DataSet ds2 = QueryServiceHelper.queryDataSet((String)"AccountSysImport2", (String)typeEnum.getBaseDataKey(), (String)selectFields2, (QFilter[])qfDefault.toArray(), (String)"level, number");
            if (!ds2.isEmpty()) {
                for (Row row : ds2) {
                    if (!allNumbers.add(row.getString("number"))) continue;
                    allNodes.put(row.getString("id"), this.createLeftTreeNode(row));
                }
            }
        }
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntitySysImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.buildTree(allNodes, root);
        root.setParentid("");
        if (root.getData() == null) {
            root.setData(new HashMap());
        }
        this.cacheNode("wholeLeftTree", root);
        TreeNode copyRoot = this.copyNode(root);
        this.copyOneLevel(copyRoot, root.getChildren());
        return copyRoot;
    }

    private TreeNode createLeftTreeNode(Row row) {
        TreeNode node = new TreeNode();
        node.setId(row.getString("id"));
        node.setText(row.getString("number") + " " + row.getString("name"));
        String parentId = "0".equals(row.getString("parentid")) ? row.getString("accounttype") : row.getString("parentid");
        node.setParentid(parentId);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", row.getString("id"));
        data.put("name", row.getString("name"));
        data.put("number", row.getString("number"));
        data.put("parentid", parentId);
        data.put("isleaf", row.getBoolean("isleaf"));
        data.put("longnumber", row.getString("longnumber"));
        data.put("dseq", row.getInteger("dseq"));
        data.put("level", row.getInteger("level"));
        data.put("isNew", "1");
        node.setData(data);
        return node;
    }

    private TreeNode createLeftTypeTreeNode(Row row) {
        TreeNode node = new TreeNode();
        node.setId(row.getString("id"));
        node.setText(row.getString("number") + " " + row.getString("name"));
        node.setParentid(row.getString("parentid"));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", row.getString("id"));
        data.put("name", row.getString("name"));
        data.put("number", row.getString("number"));
        data.put("parentid", row.getString("parentid"));
        data.put("isleaf", row.getBoolean("isleaf"));
        data.put("longnumber", row.getString("longnumber"));
        data.put("dseq", row.getInteger("dseq"));
        data.put("level", row.getInteger("level"));
        data.put("isNew", "1");
        data.put("isType", "1");
        node.setData(data);
        return node;
    }

    @Override
    protected void setMemberOtherInfo(DynamicObject treeMem) {
        treeMem.set("accounttype", (Object)"50");
        treeMem.set("drcrdirect", (Object)"0");
        treeMem.set("aggoprt", (Object)"1");
        treeMem.set("storagetype", (Object)"2");
        String datasetId = (String)this.getView().getFormShowParameter().getCustomParam("datasetId");
        if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            DynamicObject datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)this.getModelId());
            datasetId = String.valueOf(datasetObj.getLong("id"));
        }
        if (datasetId != null) {
            treeMem.set(DATASET, (Object)datasetId);
        }
        if (this.metric == null) {
            this.metric = this.getMetricMember();
        }
        if (this.metric == null) {
            return;
        }
        DynamicObjectCollection entryentity = (DynamicObjectCollection)treeMem.get("entryentity");
        DynamicObject newMetric = entryentity.addNew();
        newMetric.set("metric", (Object)this.metric.getLong("id"));
        newMetric.set("istopoly", (Object)this.metric.getBoolean("isagg"));
        newMetric.set("databytime", (Object)"0");
        newMetric.set("skip", (Object)"0");
        newMetric.set("change", (Object)"1");
    }

    private DynamicObject getMetricMember() {
        QFilter q1 = new QFilter("number", "=", (Object)"Money");
        QFilter q2 = new QFilter("model", "=", (Object)this.getModelId());
        return QueryServiceHelper.queryOne((String)"epm_metricmembertree", (String)"id,datatype,masterid,name,number,isagg", (QFilter[])new QFilter[]{q1, q2});
    }

    @Override
    protected String getTreeModelType() {
        return "epm_accountmembertree";
    }

    @Override
    protected String getSlipMsg() {
        return ResManager.loadKDString((String)"\u4e0e\u540c\u4f53\u7cfb\u5176\u4ed6\u6570\u636e\u96c6\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u79d1\u76ee\uff0c\u5728\u5f53\u524d\u6570\u636e\u96c6\u5df2\u8df3\u8fc7\u3002", (String)"AccountSysImport_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected String getBackSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u8df3\u8fc7\u5df2\u4fdd\u5b58\u7684\u79d1\u76ee\u3002\u5982\u9700\u6e05\u9664\u5df2\u4fdd\u5b58\u7684\u79d1\u76ee\uff0c\u8bf7\u5728\u6210\u5458\u5217\u8868\u4e2d\u5220\u9664\u3002", (String)"AccountSysImport_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected List<String> getCanMoveIds(TreeView treeleft, List<String> illegalSelectIds) {
        List<String> result = super.getCanMoveIds(treeleft, illegalSelectIds);
        if (!this.isBgmd() || result.size() == 0) {
            return result;
        }
        List selectNodes = treeleft.getTreeState().getSelectedNodes();
        String datasetId = this.getPageCache().get(DATASET);
        if (datasetId == null) {
            return result;
        }
        Set<String> existNumbers = this.queryOtherDataSetAccount(datasetId);
        for (Map node : selectNodes) {
            String number = ((String)node.get("text")).split(" ")[0].toUpperCase();
            String id = (String)node.get("id");
            if (!existNumbers.contains(number)) continue;
            result.remove(id);
            if (illegalSelectIds.contains(id)) continue;
            illegalSelectIds.add(id);
        }
        return result;
    }

    @Override
    protected String getNoticeMessage() {
        if (this.isBgmd()) {
            return this.getBgmdTip();
        }
        return this.getEbTip();
    }

    private String getEbTip() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u53f3\u4fa7\u7f16\u7801\u5df2\u5b58\u5728\uff08\u6216\u56e0\u6743\u9650\u95ee\u9898\u65e0\u6cd5\u67e5\u770b\uff09\uff1b", (String)"AccountSysImport_11", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"2\u3001\u5de6\u4fa7\u7f16\u7801\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u5982\u60ca\u53f9\u53f7\u7b49\uff1b", (String)"AccountSysImport_12", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"3\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u51cf\u53f7\u5f00\u5934\uff1b", (String)"AccountSysImport_13", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"4\u3001\u5de6\u4fa7\u7f16\u7801\u4e2d\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u4e0d\u5b58\u5728\u5176\u4ed6\u5b57\u7b26\uff1b", (String)"AccountSysImport_14", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"5\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5._inv\u7ed3\u5c3e\uff1b", (String)"AccountSysImport_16", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"6\u3001\u5de6\u4fa7\u7f16\u7801\u4e3a\u4fdd\u7559\u5b57\uff1a'all', 'none', 'null', 'other'\u3002", (String)"AccountSysImport_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return sb.toString();
    }

    private String getBgmdTip() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u53f3\u4fa7\u7f16\u7801\u5df2\u5b58\u5728\uff08\u6216\u56e0\u6743\u9650\u95ee\u9898\u65e0\u6cd5\u67e5\u770b\uff09\uff1b", (String)"AccountSysImport_4", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"2\u3001\u5176\u4ed6\u6570\u636e\u96c6\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u79d1\u76ee\uff1b", (String)"AccountSysImport_5", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"3\u3001\u5de6\u4fa7\u7f16\u7801\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u5982\u60ca\u53f9\u53f7\u7b49\uff1b", (String)"AccountSysImport_6", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"4\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u51cf\u53f7\u5f00\u5934\uff1b", (String)"AccountSysImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"5\u3001\u5de6\u4fa7\u7f16\u7801\u4e2d\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u4e0d\u5b58\u5728\u5176\u4ed6\u5b57\u7b26\uff1b", (String)"AccountSysImport_8", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"6\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5._inv\u7ed3\u5c3e\uff1b", (String)"AccountSysImport_17", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"7\u3001\u5de6\u4fa7\u7f16\u7801\u4e3a\u4fdd\u7559\u5b57\uff1a'all', 'none', 'null', 'other'\uff1b", (String)"AccountSysImport_10", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"8\u3001\u4f1a\u8ba1\u79d1\u76ee\u7684\u5206\u7c7b\u4e0d\u4f1a\u88ab\u9009\u62e9\u5230\u53f3\u4fa7\u3002", (String)"DimSysImportBasePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return sb.toString();
    }

    private Set<String> queryOtherDataSetAccount(String datasetId) {
        if (StringUtils.isEmpty((String)datasetId)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> numbers = new LinkedHashSet<String>();
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter datasetQf = new QFilter(DATASET, "!=", (Object)Long.parseLong(datasetId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id,name,number,membersource", (QFilter[])new QFilter[]{modelQf, datasetQf});
        for (DynamicObject dynamicObject : dynamicObjects) {
            numbers.add(dynamicObject.getString("number").toUpperCase());
        }
        return numbers;
    }

    @Override
    protected void allgo() {
        TreeView treeright = (TreeView)this.getView().getControl("treeright");
        String rightFocusId = treeright.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)rightFocusId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"AccountSysImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        String permInfo = this.checkEbMemAddNewPerm(rightFocusNode);
        if (!permInfo.equals("")) {
            this.getView().showTipNotification(permInfo);
            return;
        }
        TreeNode leftRoot = this.getWholeTree("wholeLeftTree");
        if (leftRoot == null) {
            return;
        }
        Set<String> rightNumbers = this.getNodeNumber(rightRoot);
        boolean hasSkip = this.hasSkip(leftRoot, rightNumbers);
        List leftNodes = leftRoot.getChildren();
        if (!hasSkip) {
            hasSkip = this.checkExistNumber(leftNodes);
        }
        ArrayList<TreeNode> goNodes = new ArrayList<TreeNode>();
        goNodes.add(rightRoot);
        goNodes.forEach(goNode -> {
            this.rootGo((TreeNode)goNode, leftRoot, rightNumbers, rightRoot);
            treeright.updateNode(goNode);
            treeright.expand(goNode.getId());
        });
        rightFocusNode.setExpend(true);
        this.cacheRightRoot(rightRoot);
        treeright.focusNode(rightFocusNode);
        if (hasSkip) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u60c5\u51b5\u7684\u5de6\u4fa7\u5185\u5bb9\u5c06\u4e0d\u4f1a\u88ab\u9009\u62e9\u5230\u53f3\u4fa7\uff1a", (String)"DimSysImportBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getNoticeMessage(), MessageTypes.Default);
        }
    }

    @Override
    protected boolean hasSkip(TreeNode leftRoot, Set<String> rightNumbers) {
        if ("0".equals(leftRoot.getId())) {
            List children = leftRoot.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    if (!this.hasSkip(child, rightNumbers)) continue;
                    return true;
                }
            }
        } else {
            Map datas = (Map)leftRoot.getData();
            boolean isType = "1".equals(datas.get("isType"));
            if (this.isNodeExists(rightNumbers, leftRoot) || !this.codeRule((String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)leftRoot)) || isType) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void rootGo(TreeNode rightFocusNode, TreeNode leftRoot, Set<String> numbers, TreeNode rightRootNode) {
        List children = leftRoot.getChildren();
        if (this.isBgmd()) {
            Set<String> existNumber = this.queryOtherDataSetAccount(this.getPageCache().get(DATASET));
            if (existNumber.size() > 0) {
                children.removeIf(e -> existNumber.contains(e.getText().split(" ")[0].toUpperCase()));
            }
            this.filterChildren(children, existNumber);
        }
        children.forEach(selectNode -> {
            Map datas = (Map)selectNode.getData();
            if (!"1".equals(datas.get("isType"))) {
                this.singleGo(rightFocusNode, (TreeNode)selectNode, numbers, true, rightRootNode);
            }
        });
    }

    private boolean checkExistNumber(List<TreeNode> nodes) {
        Set<String> existNumber = this.queryOtherDataSetAccount(this.getPageCache().get(DATASET));
        for (TreeNode node : nodes) {
            String number = node.getText().split(" ")[0].toUpperCase();
            if (!existNumber.contains(number)) continue;
            return true;
        }
        return false;
    }

    private void filterChildren(List<TreeNode> nodes, Set<String> existNumber) {
        if (nodes == null || nodes.isEmpty() || existNumber == null) {
            return;
        }
        ArrayList<TreeNode> removes = new ArrayList<TreeNode>(nodes.size());
        for (TreeNode _node : nodes) {
            String number = _node.getText().split(" ")[0].toUpperCase();
            if (!existNumber.contains(number)) continue;
            removes.add(_node);
        }
        if (!removes.isEmpty()) {
            nodes.removeAll(removes);
        }
        for (TreeNode _node : nodes) {
            this.filterChildren(_node.getChildren(), existNumber);
        }
    }
}

