/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.enums.ImportEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.PropValueChangeEvent;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.cube.dimension.ImportAndExport.CustomEntity;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class CustomPropertyImport
extends AbstractFormPlugin
implements UploadListener {
    public static final String BTNOK = "btnok";
    public static final String BTNDOWNLOAD = "btndownload";
    public static final String IMPORT_PAGE = "importPage";
    private boolean addNew = false;
    private static final Log log = LogFactory.getLog(CustomPropertyImport.class);
    private static final String CACHE_TEMPLATEDATA = "templateDataCache";
    private static final char ENTER = '\r';
    private static final char LINE_FEED = '\n';
    private boolean erroFlag = false;
    private List<CustomEntity> sysMember = new LinkedList<CustomEntity>();
    private List<CustomEntity> impMember = new LinkedList<CustomEntity>();
    private static String errorMessage = "";
    private final Map<String, Integer> propertyLength = Maps.newLinkedHashMap();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNDOWNLOAD});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            this.addNew = this.isAddnew();
            try {
                List<InputStream> inportStreams = this.getInportStreams();
                String message = this.checkTemplate(inportStreams);
                this.returnExceptionMessage(message);
                List<Workbook> uploadBooks = this.getXSSFWorkbooks(inportStreams);
                message = this.checkFileFormat(uploadBooks);
                this.returnExceptionMessage(message);
                ArrayList<Workbook> errorBooks = new ArrayList<Workbook>();
                for (Workbook uploadBook : uploadBooks) {
                    this.erroFlag = false;
                    this.getView().getParentView().getPageCache().put("importUpdate", "true");
                    this.handleProperties(uploadBook, errorBooks);
                }
                if (errorBooks.size() == 0) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"CustomPropertyImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getView().returnDataToParent((Object)IMPORT_PAGE);
                    this.getView().close();
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"CustomPropertyImport_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                for (Workbook errorBook : errorBooks) {
                    String fileName = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"CustomPropertyImport_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)CustomPropertyImport.writeFile(errorBook, fileName));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                List ids = this.impMember.stream().map(CustomEntity::getProperty).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Long dimensionId = this.getDimensionId();
                if (IDUtils.isNotNull((Long)dimensionId)) {
                    MemberPropCacheService.updateVersion((Long)this.getModelid(), (Long)dimensionId);
                } else {
                    MemberPropCacheService.updateVersion((Long)this.getModelid(), ids);
                }
                EventBusUtil.asyncPost((Object)new PropValueChangeEvent(this.getModelId()));
            }
        } else if (BTNDOWNLOAD.equals(key)) {
            this.getTemplateData();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    protected void getTemplateData() {
        ImportEntity importEntity = new ImportEntity();
        String cache = this.getPageCache().get(CACHE_TEMPLATEDATA);
        if (cache != null) {
            importEntity = (ImportEntity)SerializationUtils.deSerializeFromBase64((String)cache);
        } else {
            importEntity.setTemplateName(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u6a21\u677f", (String)"CustomPropertyImport_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            importEntity.setSheetTitle(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u2014\u5bfc\u5165", (String)"CustomPropertyImport_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            importEntity.setSheetNotes(ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b\u3002\u66f4\u65b0\u529f\u80fd\u4e0d\u53ef\u66f4\u65b0\u5c5e\u6027\u7f16\u7801\u3001\u5c5e\u6027\u540d\u79f0\u548c\u5c5e\u6027\u503c\u7f16\u7801\u3002\u53ea\u66f4\u65b0\u586b\u5199\u4e86\u6570\u636e\u7684\u5c5e\u6027\uff0c\u4e0d\u586b\u4e0d\u66f4\u65b0\u3002\u591a\u4e2a\u5c5e\u6027\u503c\u9700\u8981\u548c\u5c5e\u6027\u4e00\u4e00\u5bf9\u5e94\u3002", (String)"CustomPropertyImport_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
            headerMap.put("0", new Header(ResManager.loadKDString((String)"*\u5c5e\u6027\u7f16\u7801", (String)"CustomPropertyImport_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"CustomPropertyImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            headerMap.put("1", new Header(ResManager.loadKDString((String)"*\u5c5e\u6027\u540d\u79f0", (String)"CustomPropertyImport_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"CustomPropertyImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            headerMap.put("2", new Header(ResManager.loadKDString((String)"*\u5c5e\u6027\u503c\u7f16\u7801", (String)"CustomPropertyImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"CustomPropertyImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            headerMap.put("3", new Header(ResManager.loadKDString((String)"*\u5c5e\u6027\u503c\u540d\u79f0", (String)"CustomPropertyImport_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"CustomPropertyImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            importEntity.setSheetHeaderMap(headerMap);
            this.getPageCache().put(CACHE_TEMPLATEDATA, SerializationUtils.serializeToBase64((Object)importEntity));
        }
        FileImportUtils instance = FileImportUtils.getInstance((ImportEntity)importEntity);
        String url = instance.saveFileAsUrl(instance.createImportTemplate(), importEntity.getTemplateName());
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private Long getDimensionId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("dimensionId");
    }

    private Long getModelid() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    private static String writeFile(Workbook wb, String fileName) throws IOException {
        return POIUtils.writeFile((Workbook)wb, (String)fileName);
    }

    private void handleProperties(Workbook uploadBook, List<Workbook> errorBooks) {
        Sheet uploadBookSheet = uploadBook.getSheetAt(0);
        XSSFWorkbook errorBook = new XSSFWorkbook();
        Sheet errorBookSheet = this.getErrorBookSheet((Workbook)errorBook, uploadBookSheet);
        int colNum = this.getHeaderInfo().size();
        this.sysMember = this.getStructOfMember();
        ArrayList<String> updateData = new ArrayList<String>(16);
        CustomEntity customEntity = null;
        int lastRowNum = uploadBookSheet.getLastRowNum();
        HashMap<String, Map> valueObjectMap = new HashMap<String, Map>(16);
        Set ids = BgmdMainSubControlHelper.getInstance().getAllSubIds(this.getModelid());
        List grandSubs = BgmdMainSubControlHelper.getInstance().getAllGrandSonModel(ids);
        grandSubs.forEach(e -> ids.add(e.getLong("id")));
        DynamicObject mainModel = BgmdMainSubControlHelper.getInstance().getMainModel(this.getModelid());
        if (mainModel != null) {
            Long mainId = mainModel.getLong("id");
            ids.add(mainId);
            DynamicObject grandModel = BgmdMainSubControlHelper.getInstance().getMainModel(mainId);
            if (grandModel != null) {
                ids.add(grandModel.getLong("id"));
            }
        }
        HashMap<String, Set> mapAll = new HashMap<String, Set>(16);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            QFilter qFilter = new QFilter("property.model", "in", (Object)ids);
            DynamicObjectCollection allPropertyValues = QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)"number,name,property.name,property.number, syncstatus", (QFilter[])qFilter.toArray());
            for (Object value : allPropertyValues) {
                Set set = mapAll.computeIfAbsent(value.getString("property.number"), e -> new HashSet(16));
                set.add(value.getString("number"));
                Map objectMap = valueObjectMap.computeIfAbsent(value.getString("property.number"), e -> new HashMap());
                objectMap.put(value.getString("number"), value);
            }
        }
        HashMap<String, Map> mapSelf = new HashMap<String, Map>(16);
        if (1 == BgmdMainSubControlHelper.getInstance().checkModelType(this.getModelid())) {
            errorMessage = ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb %1 \u7ba1\u63a7\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BgmdMainSubControlHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{BgmdMainSubControlHelper.getInstance().getMainModelName(this.getModelid())});
            QFilter qFilter = new QFilter("property.model", "=", (Object)this.getModelid());
            DynamicObjectCollection propertyValues = QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)"number,name,property.name,property.number, syncstatus", (QFilter[])qFilter.toArray());
            for (DynamicObject value : propertyValues) {
                Map mapValue = mapSelf.computeIfAbsent(value.getString("property.number"), e -> new HashMap());
                mapValue.put(value.getString("number"), value.getString("name"));
                Map objectMap = valueObjectMap.computeIfAbsent(value.getString("property.number"), e -> new HashMap());
                objectMap.put(value.getString("number"), value);
            }
        }
        for (int i = 3; i <= lastRowNum; ++i) {
            String customName;
            String customNumber;
            Row uploadRow = uploadBookSheet.getRow(i);
            StringBuilder str = new StringBuilder();
            for (int i1 = 0; i1 < 4; ++i1) {
                str.append(this.getStringValue(uploadRow.getCell(i1), this.getCellTypeEnum(uploadRow.getCell(i1))));
            }
            if (str.toString().isEmpty()) break;
            Row errorRow = errorBookSheet.createRow(i);
            this.copyRow(uploadRow, errorRow, colNum);
            int columnNumber = 0;
            Cell uploadcell1 = uploadRow.getCell(columnNumber++);
            String number_value = this.getStringValue(uploadcell1, this.getCellTypeEnum(uploadcell1));
            Cell uploadcell2 = uploadRow.getCell(columnNumber++);
            String nameValue = this.getStringValue(uploadcell2, this.getCellTypeEnum(uploadcell2));
            String message = this.checkNumber(number_value, nameValue);
            if (!StringUtils.isEmpty((String)message)) {
                this.returnErrorTip(message, errorRow, (Workbook)errorBook);
                continue;
            }
            if ((customEntity = this.getCustomEntity(updateData, customEntity, number_value, nameValue)) == null) continue;
            if (!StringUtils.isEmpty((String)(message = this.checkCustomNumber(customEntity, customNumber = this.getStringValue(uploadcell1 = uploadRow.getCell(columnNumber++), this.getCellTypeEnum(uploadcell1)), customName = this.getStringValue(uploadcell2 = uploadRow.getCell(columnNumber), this.getCellTypeEnum(uploadcell2)), (Map)mapSelf.get(number_value), (Set)mapAll.get(number_value), (Map)valueObjectMap.get(number_value))))) {
                this.returnErrorTip(message, errorRow, (Workbook)errorBook);
                String number = customEntity.getNumber();
                this.impMember.removeIf(next -> number.equals(next.getNumber()) && next.getParent().size() == 0);
                updateData.removeIf(number::equals);
            } else {
                this.buildImember(customEntity, customNumber, customName);
            }
            this.verifyOutOfRange((Workbook)errorBook, errorRow);
        }
        if (this.erroFlag) {
            errorBooks.add((Workbook)errorBook);
        }
        if (this.addNew) {
            this.saveImportDataLeft();
        } else {
            this.updateImportData();
        }
    }

    private void buildImember(CustomEntity customEntity, String customNumber, String customName) {
        LinkedList<CustomEntity> parent = customEntity.getParent();
        if (parent == null) {
            parent = new LinkedList<CustomEntity>();
        }
        CustomEntity customEntitys = new CustomEntity();
        customEntitys.setNumber(customNumber);
        customEntitys.setName(customName);
        parent.add(customEntitys);
        customEntity.setParent(parent);
        if (!this.judgeCustomDelete(customEntity)) {
            this.impMember.add(customEntity);
        }
    }

    private boolean judgeCustomDelete(CustomEntity customEntity) {
        for (CustomEntity entity : this.impMember) {
            if (!customEntity.getNumber().equals(entity.getNumber())) continue;
            return true;
        }
        return false;
    }

    private void verifyOutOfRange(Workbook errorBook, Row errorRow) {
        HashSet<String> customEntityList = new HashSet<String>();
        for (CustomEntity entity : this.impMember) {
            int num = 0;
            for (CustomEntity customEntity1 : this.sysMember) {
                if (entity.getNumber().equals(customEntity1.getNumber())) continue;
                ++num;
            }
            if (num != this.sysMember.size()) continue;
            customEntityList.add(entity.getNumber());
        }
        if (this.sysMember.size() + customEntityList.size() > 15) {
            String message = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u6700\u5927\u81ea\u5b9a\u4e49\u5c5e\u6027\u6570\u91cf\u3002", (String)"CustomPropertyImport_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.returnErrorTip(message, errorRow, errorBook);
            if (CollectionUtils.isNotEmpty(this.impMember)) {
                this.impMember.remove(this.impMember.size() - 1);
            }
        }
    }

    private CustomEntity getCustomEntity(List<String> updateData, CustomEntity customEntity, String number_value, String nameValue) {
        if (updateData.size() > 0) {
            if (updateData.contains(number_value)) {
                for (CustomEntity entity : this.impMember) {
                    if (!number_value.equals(entity.getNumber()) || !nameValue.equals(entity.getName())) continue;
                    customEntity = entity;
                }
            } else {
                customEntity = this.getCustomEntity(number_value, nameValue);
                updateData.add(number_value);
            }
        } else {
            customEntity = this.getCustomEntity(number_value, nameValue);
            updateData.add(number_value);
        }
        return customEntity;
    }

    private CustomEntity getCustomEntity(String number_value, String nameValue) {
        CustomEntity customEntity = new CustomEntity();
        customEntity.setNumber(number_value);
        customEntity.setName(nameValue);
        customEntity.setParent(new LinkedList());
        this.impMember.add(customEntity);
        return customEntity;
    }

    private String checkCustomNumber(CustomEntity uploadRow, String custom_number, String custom_name, Map<String, String> map, Set<String> set, Map<String, DynamicObject> valueObjectMap) {
        DynamicObject dynamicObject;
        if (map != null && map.size() > 0 && valueObjectMap != null && (dynamicObject = valueObjectMap.get(custom_number)) != null && StringUtils.isNotEmpty((String)dynamicObject.getString("syncstatus"))) {
            return errorMessage;
        }
        if (CollectionUtils.isNotEmpty(set) && set.contains(custom_number) && map != null && (map.size() == 0 || !map.containsKey(custom_number))) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u5f53\u524d\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u6216\u5b50\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdMainSubControlHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)custom_number) || StringUtils.isEmpty((String)custom_name)) {
            return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u6216\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"CustomPropertyImport_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (custom_name.indexOf(13) >= 0 || custom_name.indexOf(10) >= 0) {
            return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u540d\u79f0\u5b58\u5728\u6362\u884c\u7b26", (String)"CustomPropertyImport_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (custom_number.length() > this.getPropertyDefaultLength("number") || custom_name.length() > this.getPropertyDefaultLength("name")) {
            return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u6216\u540d\u79f0\u7684\u957f\u5ea6\u8d85\u51fa\u6700\u5927\u9650\u5236\u3002", (String)"CustomPropertyImport_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (!CheckStringsUtil.checkAllowNumStartForCustonProperty((String)custom_number)) {
            return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u53ef\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26\u6216\u8005\u4ee5\u7279\u6b8a\u5b57\u7b26\u5f00\u5934\u3002", (String)"CustomPropertyImport_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (this.addNew) {
            return this.verifyLegalData(uploadRow, custom_number, custom_name);
        }
        return this.verifyUpdateData(uploadRow, custom_number, custom_name);
    }

    protected int getPropertyDefaultLength(@NotNull String propertyName) {
        DynamicObject propertyValue = BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue");
        return this.propertyLength.computeIfAbsent(propertyName, f -> {
            IDataEntityProperty _property;
            DataEntityPropertyCollection properties = propertyValue.getDataEntityType().getProperties();
            if (properties != null && (_property = (IDataEntityProperty)properties.get((Object)propertyName)) instanceof TextProp) {
                return ((TextProp)_property).getMaxLenth();
            }
            return 50;
        });
    }

    private String verifyUpdateData(CustomEntity uploadRow, String custom_number, String custom_name) {
        List parent1;
        for (CustomEntity customEntity : this.sysMember) {
            if (!uploadRow.getNumber().equals(customEntity.getNumber()) || !uploadRow.getName().equals(customEntity.getName())) continue;
            parent1 = customEntity.getParent();
            for (CustomEntity entity : parent1) {
                if (custom_number.equals(entity.getNumber()) || !custom_name.equals(entity.getName())) continue;
                return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        for (CustomEntity customEntity : this.impMember) {
            if (!uploadRow.getNumber().equals(customEntity.getNumber()) || !uploadRow.getName().equals(customEntity.getName())) continue;
            parent1 = customEntity.getParent();
            for (CustomEntity entity : parent1) {
                if (custom_number.equals(entity.getNumber()) && custom_name.equals(entity.getName())) {
                    return ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5c5e\u6027\u503c\u7f16\u7801\u548c\u540d\u79f0\u3002", (String)"CustomPropertyImport_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (custom_number.equals(entity.getNumber()) && !custom_name.equals(entity.getName())) {
                    return ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5c5e\u6027\u503c\u7f16\u7801\u3002", (String)"CustomPropertyImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (custom_number.equals(entity.getNumber()) || !custom_name.equals(entity.getName())) continue;
                return ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5c5e\u6027\u503c\u540d\u79f0\u3002", (String)"CustomPropertyImport_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String verifyLegalData(CustomEntity uploadRow, String custom_number, String custom_name) {
        List parent1;
        for (CustomEntity customEntity : this.sysMember) {
            if (!uploadRow.getNumber().equals(customEntity.getNumber()) || !uploadRow.getName().equals(customEntity.getName())) continue;
            parent1 = customEntity.getParent();
            for (CustomEntity entity : parent1) {
                if (custom_number.equals(entity.getNumber())) {
                    return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (!custom_name.equals(entity.getName())) continue;
                return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        for (CustomEntity customEntity : this.impMember) {
            if (!uploadRow.getNumber().equals(customEntity.getNumber()) || !uploadRow.getName().equals(customEntity.getName())) continue;
            parent1 = customEntity.getParent();
            for (CustomEntity entity : parent1) {
                if (custom_number.equals(entity.getNumber())) {
                    return ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5c5e\u6027\u503c\u7f16\u7801\u3002", (String)"CustomPropertyImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (!custom_name.equals(entity.getName())) continue;
                return ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5c5e\u6027\u503c\u540d\u79f0\u3002", (String)"CustomPropertyImport_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void updateImportData() {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(16);
        Long dimensionId = this.getDimensionId();
        Long modelId = this.getModelid();
        int index = 1;
        if (this.sysMember.size() > 0) {
            index = this.sysMember.get(this.sysMember.size() - 1).getDseq() + 1;
        }
        for (CustomEntity customEntity : this.impMember) {
            if (!this.judgeSysMember(customEntity)) {
                index = this.saveCustomValueUpdate(objects, dimensionId, modelId, index, customEntity);
                continue;
            }
            HashSet<Long> idList = new HashSet<Long>();
            HashSet<String> numberLists = new HashSet<String>();
            LinkedList<CustomEntity> upCustoms = new LinkedList<CustomEntity>();
            LinkedList<CustomEntity> addCustoms = new LinkedList<CustomEntity>();
            for (CustomEntity entity : this.sysMember) {
                if (!customEntity.getNumber().equals(entity.getNumber()) || !customEntity.getName().equals(entity.getName())) continue;
                List parent = entity.getParent();
                List parentNew = customEntity.getParent();
                this.judgeSaveOrUpdate(idList, numberLists, upCustoms, addCustoms, parent, parentNew);
                List<DynamicObject> dynamicObjects = this.updataCustomValue(idList, numberLists, upCustoms);
                if (dynamicObjects.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
                this.updateCustomSave(addCustoms, entity, parent);
            }
        }
    }

    private int saveCustomValueUpdate(List<DynamicObject> objects, Long dimensionId, Long modelId, int index, CustomEntity customEntity) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_customproperty");
        object.set("source", (Object)1);
        object.set("model", (Object)modelId);
        object.set("number", (Object)customEntity.getNumber());
        object.set("name", (Object)customEntity.getName());
        object.set("dimension", (Object)dimensionId);
        object.set("creater", (Object)UserUtils.getUserId());
        object.set("modifier", (Object)UserUtils.getUserId());
        object.set("createdate", (Object)TimeServiceHelper.now());
        object.set("modifydate", (Object)TimeServiceHelper.now());
        object.set("dseq", (Object)index++);
        objects.add(object);
        SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
        this.sysMember = this.getStructOfMember();
        for (CustomEntity entity : this.sysMember) {
            this.saveCustomValue(customEntity, entity);
        }
        return index;
    }

    private void updateCustomSave(List<CustomEntity> addCustoms, CustomEntity entity, List<CustomEntity> parent) {
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(16);
        int indexs = parent.size() + 1;
        for (CustomEntity custom : addCustoms) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue");
            dynamicObject.set("source", (Object)1);
            dynamicObject.set("number", (Object)custom.getNumber());
            dynamicObject.set("name", (Object)custom.getName());
            dynamicObject.set("property", (Object)entity.getId());
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
            dynamicObject.set("dseq", (Object)indexs++);
            objectList.add(dynamicObject);
        }
        if (objectList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[objectList.size()]));
        }
    }

    private List<DynamicObject> updataCustomValue(Set<Long> idList, Set<String> numberLists, List<CustomEntity> upCustoms) {
        DynamicObject[] load;
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        QFilter qfModel = new QFilter("property", "in", idList);
        QFilter qfNmubers = new QFilter("number", "in", numberLists);
        QFilter[] qFilters = new QFilter[]{qfModel, qfNmubers};
        for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"eb_custompropertyvalue", (String)this.getSelectFieter(), (QFilter[])qFilters)) {
            for (CustomEntity data : upCustoms) {
                if (!object.getString("number").equals(data.getNumber())) continue;
                object.set("number", (Object)data.getNumber());
                object.set("name", (Object)data.getName());
                object.set("modifier", (Object)UserUtils.getUserId());
                object.set("modifydate", (Object)new Date());
                dynamicObjects.add(object);
            }
        }
        return dynamicObjects;
    }

    private void judgeSaveOrUpdate(Set<Long> idList, Set<String> numberLists, List<CustomEntity> upCustoms, List<CustomEntity> addCustoms, List<CustomEntity> parent, List<CustomEntity> parentNew) {
        for (CustomEntity customEntity : parentNew) {
            if (this.judgeUpdateCustomValue(parent, customEntity, idList, numberLists)) {
                upCustoms.add(customEntity);
                continue;
            }
            addCustoms.add(customEntity);
        }
    }

    private boolean judgeUpdateCustomValue(List<CustomEntity> parent, CustomEntity custom, Set<Long> idList, Set<String> numberLists) {
        for (CustomEntity customEntity : parent) {
            if (!custom.getNumber().equals(customEntity.getNumber())) continue;
            idList.add(customEntity.getProperty());
            numberLists.add(customEntity.getNumber());
            return true;
        }
        return false;
    }

    private void saveCustomValue(CustomEntity customEntity, CustomEntity entity) {
        if (customEntity.getNumber().equals(entity.getNumber()) && customEntity.getName().equals(entity.getName())) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
            List parentNew = customEntity.getParent();
            int num = 1;
            for (CustomEntity custom : parentNew) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue");
                dynamicObject.set("source", (Object)1);
                dynamicObject.set("number", (Object)custom.getNumber());
                dynamicObject.set("name", (Object)custom.getName());
                dynamicObject.set("property", (Object)entity.getId());
                dynamicObject.set("creater", (Object)UserUtils.getUserId());
                dynamicObject.set("modifier", (Object)UserUtils.getUserId());
                dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
                dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                dynamicObject.set("dseq", (Object)num++);
                dynamicObjects.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    private void saveImportDataLeft() {
        Long dimensionId = this.getDimensionId();
        Long modelId = this.getModelid();
        int index = 1;
        if (this.sysMember.size() > 0) {
            index = this.sysMember.get(this.sysMember.size() - 1).getDseq() + 1;
        }
        if (this.impMember.size() > 0) {
            for (CustomEntity customEntity : this.impMember) {
                if (this.judgeSysMember(customEntity)) {
                    this.saveCustomValue(customEntity);
                    continue;
                }
                ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(16);
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_customproperty");
                object.set("source", (Object)1);
                object.set("model", (Object)modelId);
                object.set("number", (Object)customEntity.getNumber());
                object.set("name", (Object)customEntity.getName());
                object.set("dimension", (Object)dimensionId);
                object.set("creater", (Object)UserUtils.getUserId());
                object.set("modifier", (Object)UserUtils.getUserId());
                object.set("createdate", (Object)TimeServiceHelper.now());
                object.set("modifydate", (Object)TimeServiceHelper.now());
                object.set("dseq", (Object)index++);
                objects.add(object);
                SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
                this.sysMember = this.getStructOfMember();
                this.saveCustomValue(customEntity);
            }
        }
    }

    private boolean judgeSysMember(CustomEntity customEntity) {
        for (CustomEntity entity : this.sysMember) {
            if (!customEntity.getNumber().equals(entity.getNumber()) || !customEntity.getName().equals(entity.getName())) continue;
            return true;
        }
        return false;
    }

    private void saveCustomValue(CustomEntity customEntity) {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(16);
        for (CustomEntity entity : this.sysMember) {
            if (!customEntity.getNumber().equals(entity.getNumber())) continue;
            List parent = entity.getParent();
            List parentNew = customEntity.getParent();
            int index = parent.size() + 1;
            for (CustomEntity custom : parentNew) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue");
                dynamicObject.set("source", (Object)1);
                dynamicObject.set("number", (Object)custom.getNumber());
                dynamicObject.set("name", (Object)custom.getName());
                dynamicObject.set("property", (Object)entity.getId());
                dynamicObject.set("creater", (Object)UserUtils.getUserId());
                dynamicObject.set("modifier", (Object)UserUtils.getUserId());
                dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
                dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                dynamicObject.set("dseq", (Object)index++);
                objects.add(dynamicObject);
            }
        }
        SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
    }

    private void returnErrorTip(String errorString, Row errorRow, Workbook errorBook) {
        this.erroFlag = true;
        if (errorRow != null) {
            Cell errorCell = errorRow.getCell(0);
            if (errorCell == null) {
                errorCell = errorRow.createCell(0);
                this.setColor(errorCell, errorBook);
            }
            errorCell.setCellValue(errorString);
        }
    }

    private void setColor(Cell errorCell, Workbook errorBook) {
        CellStyle style = errorBook.createCellStyle();
        Font font = errorBook.createFont();
        font.setColor((short)10);
        style.setFont(font);
        errorCell.setCellStyle(style);
    }

    private String checkNumber(String number_value, String name_value) {
        if (StringUtils.isEmpty((String)number_value) || StringUtils.isEmpty((String)name_value)) {
            return ResManager.loadKDString((String)"\u5c5e\u6027\u7f16\u7801\u6216\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"CustomPropertyImport_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (!CheckStringsUtil.checkAllowNumStart((String)number_value)) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u5141\u8bb8\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3002", (String)"CustomPropertyEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (name_value.indexOf(13) >= 0 || name_value.indexOf(10) >= 0) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u4f7f\u7528\u6362\u884c\u7b26\u3002", (String)"CustomPropertyImport_24", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (number_value.length() > this.getPropertyDefaultLength("number") || name_value.length() > this.getPropertyDefaultLength("name")) {
            return ResManager.loadKDString((String)"\u5c5e\u6027\u7f16\u7801\u6216\u540d\u79f0\u7684\u957f\u5ea6\u8d85\u51fa\u6700\u5927\u9650\u5236\u3002", (String)"CustomPropertyImport_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (this.addNew) {
            for (CustomEntity customEntity : this.sysMember) {
                if (number_value.equals(customEntity.getNumber()) && !name_value.equals(customEntity.getName())) {
                    return ResManager.loadKDString((String)"\u5c5e\u6027\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (!name_value.equals(customEntity.getName()) || number_value.equals(customEntity.getNumber())) continue;
                return ResManager.loadKDString((String)"\u8be5\u5c5e\u6027\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            if (this.impMember != null) {
                for (CustomEntity customEntity : this.impMember) {
                    if (number_value.equals(customEntity.getNumber()) && !name_value.equals(customEntity.getName())) {
                        return ResManager.loadKDString((String)"\u5c5e\u6027\u7f16\u7801\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    }
                    if (number_value.equals(customEntity.getNumber()) || !name_value.equals(customEntity.getName())) continue;
                    return ResManager.loadKDString((String)"\u5c5e\u6027\u540d\u79f0\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            } else {
                this.impMember = new ArrayList<CustomEntity>(16);
            }
            return "";
        }
        for (CustomEntity customEntity : this.sysMember) {
            if (!number_value.equals(customEntity.getNumber()) && name_value.equals(customEntity.getName())) {
                return ResManager.loadKDString((String)"\u5c5e\u6027\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            if (!number_value.equals(customEntity.getNumber()) || name_value.equals(customEntity.getName())) continue;
            return ResManager.loadKDString((String)"\u5c5e\u6027\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"CustomPropertyImport_31", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (this.impMember != null) {
            for (CustomEntity customEntity : this.impMember) {
                if (number_value.equals(customEntity.getNumber()) && !name_value.equals(customEntity.getName())) {
                    return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"CustomPropertyImport_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (number_value.equals(customEntity.getNumber()) || !name_value.equals(customEntity.getName())) continue;
                return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u540d\u79f0\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"CustomPropertyImport_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        } else {
            this.impMember = new ArrayList<CustomEntity>(16);
        }
        return "";
    }

    private boolean checkSepcialNumber(String value) {
        return !NumberCheckUtils.checkNumber((String)value);
    }

    private CellType getCellTypeEnum(Cell cell) {
        if (cell != null) {
            return cell.getCellType();
        }
        return CellType.STRING;
    }

    private String getStringValue(Cell cell, CellType cellType) {
        if (cell == null) {
            return "";
        }
        if (CellType.NUMERIC.equals((Object)cellType)) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim();
        }
        if (CellType.STRING.equals((Object)cellType)) {
            return cell.getStringCellValue().trim();
        }
        return "";
    }

    private void copyRow(Row uploadRow, Row errorRow, int colNum) {
        for (int i = 0; i < colNum; ++i) {
            Cell uploadCell = uploadRow.getCell(i);
            if (uploadCell == null) continue;
            Cell errorCell = errorRow.createCell(i + 1);
            if (CellType.NUMERIC.equals((Object)uploadCell.getCellType())) {
                errorCell.setCellValue(NumberToTextConverter.toText((double)uploadCell.getNumericCellValue()));
                continue;
            }
            if (!CellType.STRING.equals((Object)uploadCell.getCellType())) continue;
            errorCell.setCellValue(uploadCell.getStringCellValue());
        }
    }

    private List<CustomEntity> getStructOfMember() {
        LinkedList<CustomEntity> customList = new LinkedList<CustomEntity>();
        DynamicObjectCollection query = this.selectCustomLeft();
        for (DynamicObject dynamicObject : query) {
            CustomEntity entity = this.setCustomEntity(dynamicObject);
            customList.add(entity);
        }
        for (CustomEntity entity : customList) {
            LinkedList<CustomEntity> parent = new LinkedList<CustomEntity>();
            DynamicObjectCollection objects = this.selectCustomFight(entity.getId());
            for (DynamicObject object : objects) {
                CustomEntity customEntity = this.setSeconEntity(object);
                parent.add(customEntity);
            }
            entity.setParent(parent);
        }
        return customList;
    }

    private CustomEntity setSeconEntity(DynamicObject object) {
        CustomEntity customSeconEntity = new CustomEntity();
        customSeconEntity.setId(Long.valueOf(object.getLong("id")));
        customSeconEntity.setNumber(object.getString("number"));
        customSeconEntity.setName(object.getString("name"));
        customSeconEntity.setSource(object.getInt("source"));
        customSeconEntity.setProperty(Long.valueOf(object.getLong("property")));
        customSeconEntity.setDseq(object.getInt("dseq"));
        return customSeconEntity;
    }

    private CustomEntity setCustomEntity(DynamicObject dynamicObject) {
        CustomEntity customEntity = new CustomEntity();
        customEntity.setId(Long.valueOf(dynamicObject.getLong("id")));
        customEntity.setNumber(dynamicObject.getString("number"));
        customEntity.setName(dynamicObject.getString("name"));
        customEntity.setSource(dynamicObject.getInt("source"));
        customEntity.setDseq(dynamicObject.getInt("dseq"));
        return customEntity;
    }

    private DynamicObjectCollection selectCustomFight(Long customId) {
        QFilter qfDimensionLefa = new QFilter("property", "=", (Object)customId);
        return QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)this.getSelectFieterDseq(), (QFilter[])new QFilter[]{qfDimensionLefa});
    }

    private DynamicObjectCollection selectCustomLeft() {
        QFilter qfModel = new QFilter("model", "=", (Object)this.getModelid());
        QFilter qfDimension = new QFilter("dimension", "=", (Object)this.getDimensionId());
        return QueryServiceHelper.query((String)"eb_customproperty", (String)this.getSelectFieter(), (QFilter[])new QFilter[]{qfModel, qfDimension}, (String)"dseq asc");
    }

    private String getSelectFieterDseq() {
        return "id,name,number,property,source,creater,modifier,createdate,modifydate,dseq";
    }

    private String getSelectFieter() {
        return "id,name,number,source,model,dimension,creater,modifier,createdate,modifydate,dseq";
    }

    private Sheet getErrorBookSheet(Workbook errorBook, Sheet uploadBookSheet) {
        Sheet errorSheet = errorBook.createSheet();
        for (int i = 0; i < 3; ++i) {
            Row errorRow = errorSheet.createRow(i);
            if (i == 2) {
                errorRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"CustomPropertyImport_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                int size = this.getHeaderInfo().size();
                this.copyRow(uploadBookSheet.getRow(i), errorRow, size);
                continue;
            }
            this.copyRow(uploadBookSheet.getRow(i), errorRow, 1);
        }
        return errorSheet;
    }

    private String checkFileFormat(List<Workbook> uploadBooks) {
        try {
            for (Workbook uploadBook : uploadBooks) {
                Sheet uploadSheet = uploadBook.getSheetAt(0);
                Row row3 = uploadSheet.getRow(2);
                if (row3 == null) {
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"CustomPropertyImport_35", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                List<String> headerInfo = this.getHeaderInfo();
                for (int i = 0; i < headerInfo.size(); ++i) {
                    if (row3.getCell(i).getStringCellValue().trim().equals(headerInfo.get(i))) continue;
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"CustomPropertyImport_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"CustomPropertyImport_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private List<String> getHeaderInfo() {
        return Arrays.asList(ResManager.loadKDString((String)"*\u5c5e\u6027\u7f16\u7801", (String)"CustomPropertyImport_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5c5e\u6027\u540d\u79f0", (String)"CustomPropertyImport_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5c5e\u6027\u503c\u7f16\u7801", (String)"CustomPropertyImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5c5e\u6027\u503c\u540d\u79f0", (String)"CustomPropertyImport_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private List<Workbook> getXSSFWorkbooks(List<InputStream> inputStreams) {
        ArrayList<Workbook> workbooks = new ArrayList<Workbook>();
        try {
            for (InputStream inportStream : inputStreams) {
                workbooks.add(WorkbookFactory.create((InputStream)inportStream));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"CustomPropertyImport_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return workbooks;
    }

    private String checkTemplate(List<InputStream> inportStreams) {
        if (inportStreams.size() == 0) {
            return ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"CustomPropertyImport_37", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void returnExceptionMessage(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            throw new KDBizException(message);
        }
    }

    private boolean isAddnew() {
        return ImportEnum.IMPORTTYPE_NEW.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = file_url == null ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    private List<InputStream> getInportStreams() {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String file_url = this.getPageCache().get("file_url");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        if (file_url != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new String[]{};
                    reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return inputStreams;
    }
}

