/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.FactoryChangeEvent;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.formplugin.dimension.action.ActionFactory;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.importplugin.UpdateResultParam;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class DimSysImportBasePlugin
extends MainSubAbstractFormPlugin
implements ClickListener,
TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener {
    private static final Log log = LogFactory.getLog(DimSysImportBasePlugin.class);
    protected static final String cache_leftTree = "lefttree";
    protected static final String cache_rightTree = "righttree";
    protected static final String cache_rightNumbers = "rightTreeAllNumbers";
    protected static final String entityRightTree = "entityRightTree";
    protected static final String rightCurrentNode = "rightCurrentNode";
    protected static final String treeLeft = "treeleft";
    protected static final String treeRight = "treeright";
    protected static final String LList = "llist";
    protected static final String LFocus = "lfocus";
    protected static final String Loldcache = "loldcache";
    protected static final String RList = "rlist";
    protected static final String RFocus = "rfocus";
    protected static final String Roldcache = "roldcache";
    public static final int MAX_LEVEL = 20;
    public static final String wholeLeftTree = "wholeLeftTree";
    public static final String wholeRightTree = "wholeRightTree";
    protected static final String sign_allChoose = "sign_allChoose";
    protected static final String cache_resultSearch = "resultSearch";
    protected static final String cache_currentFocusId = "currentFocusId";
    protected static final String cache_searchSign = "searchSign";
    protected static final String MEMBERKEY = "memberKey";
    protected static final String DIMENSIONID = "dimensionId";
    protected static final String DIMENSIONNUMBER = "dimensionNumber";
    protected static final String MODEL = "model";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"baritemconfirm", "baritemcancel"});
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "searchbefore1", "searchnext1"});
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        treeleft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView rightTree = (TreeView)this.getView().getControl(treeRight);
        rightTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeleft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        rightTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btngo", "btnallgo", "btnback", "btnallback", "btnupdate"});
        this.addClickListeners(new String[]{"allchoose", "allclear", "allexpand", "allshrink", "allclear1"});
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                TreeNode beforNode;
                String before = DimSysImportBasePlugin.this.getPageCache().get(DimSysImportBasePlugin.cache_currentFocusId);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)before) && (beforNode = DimSysImportBasePlugin.this.getCacheLeftRoot().getTreeNode(before, 20)) != null) {
                    beforNode.setColor("");
                    TreeView treeView = (TreeView)DimSysImportBasePlugin.this.getControl(DimSysImportBasePlugin.treeLeft);
                    treeView.updateNode(beforNode);
                }
                DimSysImportBasePlugin.this.clearSearchCache();
                DimSysImportBasePlugin.this.searchLeftTree(event.getText());
            }
        });
        Search sr = (Search)this.getControl("searchapright");
        sr.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                DimSysImportBasePlugin.this.clearSearchCache();
                DimSysImportBasePlugin.this.searchRightTree(event.getText());
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IPageCache pageCache = this.getPageCache();
        String membermodel = (String)formShowParameter.getCustomParam(MEMBERKEY);
        Long modelId = (Long)formShowParameter.getCustomParam(MODEL);
        Long dimensionID = (Long)formShowParameter.getCustomParam(DIMENSIONID);
        String dimensionNum = (String)formShowParameter.getCustomParam(DIMENSIONNUMBER);
        pageCache.put(DIMENSIONID, dimensionID.toString());
        pageCache.put(MEMBERKEY, membermodel);
        pageCache.put(MODEL, modelId.toString());
        pageCache.put(DIMENSIONNUMBER, dimensionNum);
        this.initLeftTree();
        this.initRightTree();
    }

    protected void initLeftTree() {
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        TreeNode rootleft = this.getLeftRoot();
        if ("-1".equals(rootleft.getId())) {
            treeleft.setRootVisible(false);
        } else {
            treeleft.setRootVisible(true);
        }
        treeleft.deleteAllNodes();
        treeleft.updateNode(rootleft);
        treeleft.addNode(rootleft);
        treeleft.expand(rootleft.getId());
        this.cacheLeftRoot(rootleft);
    }

    protected void initRightTree() {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        TreeNode rootRight = this.getRigthRoot();
        treeright.deleteAllNodes();
        treeright.addNode(rootRight);
        treeright.focusNode(rootRight);
        treeright.expand(rootRight.getId());
        this.cacheRightRoot(rootRight);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btngo": {
                this.selectGoRight();
                break;
            }
            case "btnback": {
                this.selectGoLeft();
                break;
            }
            case "btnallgo": {
                this.allgo();
                this.setLeftTreeNoteColor(key, "blue", null, true);
                break;
            }
            case "btnallback": {
                this.allback();
                this.setLeftTreeNoteColor(key, "", null, false);
                break;
            }
            case "btnupdate": {
                this.updateNode(0L);
                break;
            }
            case "allchoose": {
                this.clickAllChoose();
                break;
            }
            case "allclear": {
                this.clickAllClear();
                break;
            }
            case "allexpand": {
                this.spreadAll();
                break;
            }
            case "allshrink": {
                this.collapseAll();
                break;
            }
            case "baritemconfirm": {
                this.saveData();
                break;
            }
            case "baritemcancel": {
                this.getView().close();
                break;
            }
            case "searchbefore1": 
            case "searchnext1": {
                this.searchUpAndDown(key);
                break;
            }
            case "searchbefore": 
            case "searchnext": {
                this.searchUpAndDownRight(key);
                break;
            }
        }
    }

    protected void updateNode(Long viewId) {
        TreeView leftTreeView = (TreeView)this.getView().getControl(treeLeft);
        List leftSelNodes = leftTreeView.getTreeState().getSelectedNodes();
        TreeView rightTreeView = (TreeView)this.getView().getControl(treeRight);
        List rightSelNodes = rightTreeView.getTreeState().getSelectedNodes();
        if (leftSelNodes.size() != 1 || rightSelNodes.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5de6\u53f3\u9009\u62e9\u4e00\u4e2a\u76f8\u540c\u7f16\u7801\u8282\u70b9\u540e\u70b9\u51fb\u66f4\u65b0\u3002", (String)"DimSysImportBasePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map nextLeft = (Map)leftSelNodes.get(0);
        Map nextRight = (Map)rightSelNodes.get(0);
        TreeNode cacheWholeLeftNode = this.getCacheNode(wholeLeftTree);
        TreeNode cacheRightRoot = this.getCacheRightRoot();
        TreeNode leftSelNode = cacheWholeLeftNode.getTreeNode(String.valueOf(nextLeft.get("id")), 20);
        TreeNode rightSelNode = cacheRightRoot.getTreeNode(String.valueOf(nextRight.get("id")), 20);
        if (leftSelNode == null || rightSelNode == null) {
            return;
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)String.valueOf(nextLeft.get("text")), (CharSequence)String.valueOf(nextRight.get("text")))) {
            String rightSelNumber;
            if (leftSelNode.getData() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6e90\u6210\u5458\u8282\u70b9\u65e0\u6570\u636e\u3002", (String)"DimSysImportBasePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rightSelNode.getData() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u76ee\u6807\u6210\u5458\u8282\u70b9\u65e0\u6570\u636e\u3002", (String)"DimSysImportBasePlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String leftSelNumber = (String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)leftSelNode);
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)leftSelNumber, (CharSequence)(rightSelNumber = (String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)rightSelNode)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5de6\u53f3\u9009\u62e9\u4e00\u4e2a\u76f8\u540c\u7f16\u7801\u8282\u70b9\u540e\u70b9\u51fb\u66f4\u65b0\u3002", (String)"DimSysImportBasePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        HashMap<String, Integer> rightChildNodeLevelMap = new HashMap<String, Integer>(16);
        this.getChildNodeLevelMap(rightSelNode, rightChildNodeLevelMap, 1);
        if (rightChildNodeLevelMap.size() > 0) {
            HashMap<String, Integer> leftChildNodeLevelMap = new HashMap<String, Integer>(16);
            this.getChildNodeLevelMap(leftSelNode, leftChildNodeLevelMap, 1);
            for (Map.Entry entry : rightChildNodeLevelMap.entrySet()) {
                String number = (String)entry.getKey();
                int level = (Integer)entry.getValue();
                if (!leftChildNodeLevelMap.containsKey(number) || (Integer)leftChildNodeLevelMap.get(number) == level) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de6\u53f3\u4e24\u4fa7\u9009\u62e9\u8282\u70b9\u7684\u4e0b\u7ea7\u5c42\u7ea7\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"DimSysImportBasePlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        UpdateResultParam updateResultParam = new UpdateResultParam();
        Set<String> rightExistNumbers = this.getNodeNumber(cacheRightRoot);
        rightExistNumbers.addAll(this.queryDimViewMembers());
        HashMap<Long, Boolean> rightNumberToManagePermMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, QuoteCheckResult> rightNumberToDataQuoteMap = new HashMap<Long, QuoteCheckResult>(16);
        LinkedHashMap<String, TreeNode> leftNumberToNodeMap = new LinkedHashMap<String, TreeNode>(16);
        HashMap<String, String> leftNumberToParentMap = new HashMap<String, String>(16);
        HashMap<String, TreeNode> rightNumberToNodeMap = new HashMap<String, TreeNode>(16);
        this.getNumberToNodeMap(leftNumberToNodeMap, leftSelNode);
        this.getNumberToNodeMap(rightNumberToNodeMap, rightSelNode);
        this.getNumberToParentMap(leftNumberToParentMap, leftSelNode);
        Long modelId = this.getModelId();
        Long dimId = this.getDimId();
        Dimension dimension = this.getIModelCacheHelper().getDimension(dimId);
        Long userId = this.getUserId();
        leftNumberToNodeMap.remove(TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)leftSelNode));
        HashMap viewMemberIdMap = Maps.newHashMapWithExpectedSize((int)1);
        for (Map.Entry entry : leftNumberToNodeMap.entrySet()) {
            String number = (String)entry.getKey();
            TreeNode leftNode = (TreeNode)entry.getValue();
            this.syncNode(number, leftNode, leftNumberToParentMap, rightNumberToNodeMap, rightExistNumbers, updateResultParam, rightNumberToManagePermMap, rightNumberToDataQuoteMap, modelId, dimension, viewId, userId, viewMemberIdMap);
            if (updateResultParam.getSyncNodes().size() <= updateResultParam.updateMaxAmountLimit()) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u66f4\u65b0\u6210\u5458\u6570\u91cf\u8d85\u8fc7%1\uff0c\u8bf7\u9009\u62e9\u4f4e\u5c42\u7ea7\u8282\u70b9\u8fdb\u884c\u66f4\u65b0\u3002", (String)"DimSysImportBasePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{updateResultParam.updateMaxAmountLimit()}));
            return;
        }
        if (updateResultParam.getSyncNodes().size() > 0) {
            this.cacheNode(cache_rightTree, cacheRightRoot);
            rightTreeView.updateNode(rightSelNode);
            rightTreeView.expand(rightSelNode.getId());
            rightTreeView.focusNode(rightSelNode);
            leftTreeView.uncheckNodes(Collections.singletonList(String.valueOf(nextLeft.get("id"))));
            this.setLeftTreeNoteColor("btnupdate", "blue", updateResultParam.getSyncNodes(), false);
        }
        this.showUpdateNodeMessage(updateResultParam);
    }

    private void showUpdateNodeMessage(UpdateResultParam updateResultParam) {
        if (updateResultParam.isExistNumberIllegal() || updateResultParam.isExistNumberRepeat() || updateResultParam.isExistNoAddChildPerm() || updateResultParam.isExistDataQuote()) {
            String sb = ResManager.loadKDString((String)"1\u3001\u53f3\u4fa7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u5de6\u4fa7\u4e0e\u53f3\u4fa7\u7684\u5c42\u7ea7\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u81ea\u5df1\u548c\u4e0b\u7ea7\u90fd\u4e0d\u4f1a\u66f4\u65b0\uff1b", (String)"DimSysImportBasePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2\u3001\u5de6\u4fa7\u7f16\u7801\u4e0d\u662f\u534a\u89d2\u5b57\u7b26\u6216\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u5982\u60ca\u53f9\u53f7\u7b49\uff1b", (String)"DimSysImportBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u51cf\u53f7\u5f00\u5934\uff1b", (String)"DimSysImportBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"4\u3001\u5de6\u4fa7\u7f16\u7801\u4e2d\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u4e0d\u5b58\u5728\u5176\u4ed6\u5b57\u7b26\uff1b", (String)"DimSysImportBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"5\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5._inv\u7ed3\u5c3e\uff1b", (String)"DimSysImportBasePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"6\u3001\u5de6\u4fa7\u7f16\u7801\u4e3a\u4fdd\u7559\u5b57\uff1a'all', 'none', 'null', 'other'\uff1b", (String)"DimSysImportBasePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"7\u3001\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53f3\u4fa7\u6210\u5458\u7684\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff1b", (String)"DimSysImportBasePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"8\u3001\u53f3\u4fa7\u6210\u5458\u5df2\u88ab\u591a\u7ef4\u6570\u636e\u5e93\u6570\u636e\u5f15\u7528\uff0c\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"DimSysImportBasePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u60c5\u51b5\u7684\u5de6\u4fa7\u5185\u5bb9\u5c06\u4e0d\u4f1a\u88ab\u66f4\u65b0\u5230\u53f3\u4fa7\uff1a", (String)"DimSysImportBasePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), sb, MessageTypes.Default);
        } else if (updateResultParam.isExistTypeNode()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u5206\u7c7b\u65e0\u6cd5\u9009\u62e9\u81f3\u53f3\u4fa7\u3002", (String)"DimSysImportBasePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (updateResultParam.getSyncNodes().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5de6\u4fa7\u9009\u4e2d\u8282\u70b9\u6ca1\u6709\u53ef\u66f4\u65b0\u5230\u53f3\u4fa7\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimSysImportBasePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void getNumberToParentMap(Map<String, String> numberToParentMap, TreeNode node) {
        String number = (String)this.getNodeProperty("number", node);
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                String childNumber = (String)this.getNodeProperty("number", child);
                numberToParentMap.put(childNumber, number);
                this.getNumberToParentMap(numberToParentMap, child);
            }
        }
    }

    private void getNumberToNodeMap(Map<String, TreeNode> numberToNodeMap, TreeNode node) {
        String number = (String)this.getNodeProperty("number", node);
        numberToNodeMap.put(number, node);
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                this.getNumberToNodeMap(numberToNodeMap, child);
            }
        }
    }

    private void syncNode(String number, TreeNode leftNode, Map<String, String> leftNumberToParentMap, Map<String, TreeNode> rightNumberToNodeMap, Set<String> rightExistNumbers, UpdateResultParam updateResultParam, Map<Long, Boolean> rightNumberToManagePermMap, Map<Long, QuoteCheckResult> rightNumberToDataQuoteMap, Long modelId, Dimension dimension, Long viewId, Long userId, Map<Long, Long> viewMemberIdMap) {
        String parentNumber;
        TreeNode rightParentNode;
        if (!this.codeRule(number)) {
            updateResultParam.setExistNumberIllegal(true);
            return;
        }
        if (rightExistNumbers.contains(number)) {
            return;
        }
        TreeNode rightNode = rightNumberToNodeMap.get(number);
        if (rightNode == null && (rightParentNode = rightNumberToNodeMap.get(parentNumber = leftNumberToParentMap.get(number))) != null) {
            Long memberId = IDUtils.toLong((Object)rightParentNode.getId());
            if (!View.NoViewDimNums.contains(dimension.getNumber()) && !this.isEB()) {
                Long viewMemberId = memberId;
                boolean exists = QueryServiceHelper.exists((String)"eb_viewmember", (Object)viewMemberId);
                if (!exists) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u518d\u540c\u6b65\u3002", (String)"DimSysImportBasePlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                memberId = viewMemberIdMap.computeIfAbsent(memberId, v -> BusinessDataServiceHelper.loadSingle((Object)viewMemberId, (String)"eb_viewmember", (String)"memberid").getLong("memberid"));
            }
            if (!this.checkEnableAddChild(rightNumberToManagePermMap, rightNumberToDataQuoteMap, updateResultParam, modelId, dimension.getId(), viewId, userId, memberId)) {
                return;
            }
            Map data = (Map)leftNode.getData();
            try {
                String viewType = (String)this.getModel().getValue("combofield");
                if (this.isFromSystem(viewType)) {
                    data.put("isSystem", "true");
                }
            }
            catch (Exception viewType) {
                // empty catch block
            }
            if ("1".equals(data.get("isType"))) {
                updateResultParam.setExistTypeNode(true);
                return;
            }
            String nodeId = String.valueOf(GlobalIdUtil.genGlobalLongId());
            TreeNode _node = new TreeNode();
            _node.setId(nodeId);
            _node.setParentid(rightParentNode.getId());
            _node.setData(new HashMap(data));
            _node.setText(leftNode.getText());
            _node.setColor("#5E80EB");
            rightParentNode.addChild(_node);
            rightNumberToNodeMap.put(number, _node);
            rightExistNumbers.add(number);
            updateResultParam.addSyncNode(leftNode);
        }
    }

    private boolean isFromSystem(String viewType) {
        return StringUtils.equals((String)viewType, (String)"01") || StringUtils.equals((String)viewType, (String)"15") || StringUtils.equals((String)viewType, (String)"02");
    }

    private boolean checkEnableAddChild(Map<Long, Boolean> rightNumberToManagePermMap, Map<Long, QuoteCheckResult> rightNumberToDataQuoteMap, UpdateResultParam updateResultParam, Long modelId, Long dimId, Long viewId, Long userId, Long memberId) {
        Boolean hasPerm = rightNumberToManagePermMap.get(memberId);
        if (hasPerm == null) {
            hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
            rightNumberToManagePermMap.put(memberId, hasPerm);
        }
        if (!hasPerm.booleanValue()) {
            updateResultParam.setExistNoAddChildPerm(true);
            return false;
        }
        QuoteCheckResult quote = rightNumberToDataQuoteMap.get(memberId);
        if (quote == null) {
            quote = MemberQuote.get().checkQuoteDataResult(QuoteBuilder.build((Long)modelId, (Long)dimId, (Long)memberId));
            rightNumberToDataQuoteMap.put(memberId, quote);
        }
        if (quote.isHasQuote()) {
            updateResultParam.setExistDataQuote(true);
            return false;
        }
        return true;
    }

    private void getChildNodeLevelMap(@NotNull TreeNode selNode, Map<String, Integer> nodeLevelMap, int level) {
        List children = selNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            ++level;
            for (TreeNode child : children) {
                String number = (String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)child);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)number)) {
                    nodeLevelMap.put(number, level);
                }
                this.getChildNodeLevelMap(child, nodeLevelMap, level);
            }
        }
    }

    protected void clickAllChoose() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        treeleft.checkNodes(this.getAllNode(leftRoot, new ArrayList<TreeNode>()));
        this.getPageCache().put(sign_allChoose, "1");
    }

    protected void clickAllClear() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        this.allClear(leftRoot, treeleft);
    }

    protected void clickRightClear() {
        TreeNode rightRoot = this.getCacheRightRoot();
        if (rightRoot == null) {
            return;
        }
        TreeView treeRightView = (TreeView)this.getView().getControl(treeRight);
        this.allClear(rightRoot, treeRightView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveData() {
        block23: {
            TreeNode rightRoot = this.getCacheRightRoot();
            LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
            this.checkOlapConnect();
            LinkedHashMap<String, TreeNode> rightNewNodes = new LinkedHashMap<String, TreeNode>();
            LinkedHashSet<String> addNewNumbers = new LinkedHashSet<String>();
            this.getRightNewNodes(rightRoot, rightNewNodes, parentIds, addNewNumbers);
            List<DynamicObject> toSaveMembers = this.transformNodes(rightNewNodes);
            Long dimId = this.getDimId();
            Dimension dimension = this.getIModelCacheHelper().getDimension(dimId);
            Long modelId = this.getModelId();
            BailOrgService bailOrgService = BailOrgService.getInstance();
            Map bailOrgRelationMap = bailOrgService.allocateBailOrgRelation(modelId, toSaveMembers);
            try {
                if (toSaveMembers.isEmpty()) break block23;
                HashMap<String, List<DynamicObject>> otherParams = new HashMap<String, List<DynamicObject>>(16);
                otherParams.put("toSaveMembers", toSaveMembers);
                this.canDoOperation("save", otherParams);
                try (TXHandle tx = TX.requiresNew((String)"saveData");){
                    try {
                        if (!this.isEB() && !View.NoViewDimNums.contains(dimension.getNumber())) {
                            List<DimensionViewMember> dimensionViewMembers = this.transDimensionViewMember(rightNewNodes, rightRoot, this.getViewId());
                            Long viewId = Long.valueOf(this.getPageCache().get("viewId"));
                            ViewMemberManager.getInstance().insertViewAndDimMember(this.getModelId().longValue(), dimension.getNumber(), viewId, dimensionViewMembers);
                        } else {
                            DynamicObjectUtils.save(toSaveMembers);
                        }
                        bailOrgService.saveBailOrgRelation(modelId, bailOrgRelationMap);
                        parentIds.removeAll(rightNewNodes.keySet());
                        this.handleParentProperties(parentIds.stream().map(Long::parseLong).toArray());
                        this.afterSave(toSaveMembers, parentIds);
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                        log.error("sysImport-error:", (Throwable)ex);
                        throw new KDBizException(ex.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    String _modelId = this.getPageCache().get(MODEL);
                    String _dimensionId = this.getView().getFormShowParameter().getCustomParam(DIMENSIONID).toString();
                    CubeUtils.get().checkDimension(Long.valueOf(_modelId), Long.valueOf(_dimensionId));
                    DynamicObject _dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(_dimensionId), (String)"epm_dimension", (String)"id, name, number");
                    HashSet<String> memberNames = new HashSet<String>(toSaveMembers.size());
                    for (DynamicObject _member : toSaveMembers) {
                        memberNames.add(_member.getString("number") + '-' + _member.getString("name"));
                    }
                    String opMember = StringUtils.join(memberNames, (char)',');
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u7cfb\u7edf\u5bfc\u5165", "DimSysImportBasePlugin_21", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7ef4\u5ea6-%1$s\uff0c\u65b0\u589e\u6216\u4fee\u6539\u66f4\u65b0\u7ef4\u5ea6\u6210\u5458(%2$s)\u603b\u5171%3$s\u6761\u6570\u636e\u3002", "DimSysImportBasePlugin_22", "epm-eb-formplugin");
                    this.writeLog(null, "import", opName, opDescription, new String[]{_dimension.getString("name"), opMember, String.valueOf(toSaveMembers.size())});
                    throw throwable;
                }
                String _modelId = this.getPageCache().get(MODEL);
                String _dimensionId = this.getView().getFormShowParameter().getCustomParam(DIMENSIONID).toString();
                CubeUtils.get().checkDimension(Long.valueOf(_modelId), Long.valueOf(_dimensionId));
                DynamicObject _dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(_dimensionId), (String)"epm_dimension", (String)"id, name, number");
                HashSet<String> memberNames = new HashSet<String>(toSaveMembers.size());
                for (DynamicObject _member : toSaveMembers) {
                    memberNames.add(_member.getString("number") + '-' + _member.getString("name"));
                }
                String opMember = StringUtils.join(memberNames, (char)',');
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u7cfb\u7edf\u5bfc\u5165", "DimSysImportBasePlugin_21", "epm-eb-formplugin");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7ef4\u5ea6-%1$s\uff0c\u65b0\u589e\u6216\u4fee\u6539\u66f4\u65b0\u7ef4\u5ea6\u6210\u5458(%2$s)\u603b\u5171%3$s\u6761\u6570\u636e\u3002", "DimSysImportBasePlugin_22", "epm-eb-formplugin");
                this.writeLog(null, "import", opName, opDescription, new String[]{_dimension.getString("name"), opMember, String.valueOf(toSaveMembers.size())});
            }
            finally {
                this.syncOlapData(toSaveMembers, parentIds);
            }
        }
        this.getView().close();
    }

    private Long getViewId() {
        String viewIdString = this.getPageCache().get("viewId");
        if (StringUtils.isNotEmpty((String)viewIdString)) {
            return Long.parseLong(viewIdString);
        }
        return (Long)this.getView().getFormShowParameter().getCustomParam("viewId");
    }

    protected List<DimensionViewMember> transDimensionViewMember(Map<String, TreeNode> rightNewNodes, TreeNode rightRoot, Long viewId) {
        String treeModelType = this.getTreeModelType();
        long modelId = this.getModelId();
        Long dimId = this.getDimId();
        ArrayList<DimensionViewMember> dimensionViewMembers = new ArrayList<DimensionViewMember>(rightNewNodes.size());
        Dimension dimension = this.getIModelCacheHelper().getDimension(dimId);
        String dimensionNumber = dimension.getNumber();
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)UserUtils.getUserId());
        List parentIds = rightNewNodes.values().stream().map(x -> IDUtils.toLong(((Map)x.getData()).get("parentid"))).filter(x -> x != null).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid", (QFilter[])new QFilter("id", "in", parentIds).toArray());
        Map<Object, Object> parentIdToMember = CollectionUtils.isEmpty((Collection)dynamicObjects) ? new HashMap(16) : dynamicObjects.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getLong("memberid")));
        HashMap<String, String> longNumberMap = new HashMap<String, String>(16);
        for (TreeNode node : rightNewNodes.values()) {
            String currLongNumber;
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)treeModelType);
            DimensionViewMember dimensionViewMember = new DimensionViewMember();
            dimensionViewMember.setStatus("C");
            dimensionViewMember.setEnable("1");
            TextProp tpNameProp = (TextProp)member.getDynamicObjectType().getProperty("Name");
            int iNameLen = tpNameProp.getMaxLenth();
            TextProp tpNumberProp = (TextProp)member.getDynamicObjectType().getProperty("number");
            int iNumberLen = tpNumberProp.getMaxLenth();
            String number = (String)this.getNodeProperty("number", node);
            String name = (String)this.getNodeProperty("name", node);
            String substringNumber = org.apache.commons.lang3.StringUtils.substring((String)number, (int)0, (int)iNumberLen);
            String substringName = org.apache.commons.lang3.StringUtils.substring((String)name, (int)0, (int)iNameLen);
            Map data = (Map)node.getData();
            dimensionViewMember.setViewMemberId(Long.valueOf(Long.parseLong(node.getId())));
            dimensionViewMember.setName(substringName);
            dimensionViewMember.setNumber(substringNumber);
            dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.ADD.getIndex());
            dimensionViewMember.setMembersource(MemberSourceEnum.SYSTEM_IMPORT.getIndex());
            dimensionViewMember.setMemberId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
            parentIdToMember.put(dimensionViewMember.getViewMemberId(), dimensionViewMember.getMemberId());
            dimensionViewMember.setShowNumber(data.getOrDefault("shownumber", dimensionViewMember.getNumber()));
            this.setMemberSpecialInfo(dimensionViewMember);
            if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                dimensionViewMember.setAggoprt("1");
                dimensionViewMember.setCurrency((Long)data.get("defaultCurrency"));
            }
            dimensionViewMember.setLevel((Integer)this.getNodeProperty("level", node));
            String parentLongNumber = (String)longNumberMap.get(node.getParentid());
            TreeNode parentNode = rightRoot.getTreeNode(node.getParentid());
            if (StringUtils.isEmpty((String)parentLongNumber)) {
                if (parentNode == null) {
                    currLongNumber = (String)data.get("longnumber");
                    dimensionViewMember.setLongNumber(currLongNumber);
                } else {
                    Map parentMap = (Map)parentNode.getData();
                    parentLongNumber = (String)parentMap.get("longnumber");
                    currLongNumber = (StringUtils.isEmpty((String)parentLongNumber) ? dimensionNumber : parentLongNumber) + "!" + dimensionViewMember.getNumber();
                    dimensionViewMember.setLongNumber(currLongNumber);
                }
            } else {
                currLongNumber = (StringUtils.isEmpty((String)parentLongNumber) ? dimensionNumber : parentLongNumber) + "!" + dimensionViewMember.getNumber();
                dimensionViewMember.setLongNumber(currLongNumber);
            }
            longNumberMap.put(node.getId(), currLongNumber);
            dimensionViewMember.setParentId(Long.valueOf(parentNode == null ? Long.parseLong(node.getParentid()) : Long.parseLong(parentNode.getId())));
            Long memberParentId = (Long)parentIdToMember.get(dimensionViewMember.getParentId());
            dimensionViewMember.setParentMemberId(memberParentId == null ? dimensionViewMember.getMemberId() : memberParentId);
            dimensionViewMember.setModel(Long.valueOf(modelId));
            dimensionViewMember.setDimension(dimId);
            dimensionViewMember.setDseq((Integer)this.getNodeProperty("dseq", node));
            dimensionViewMember.setIsLeaf(node.getChildren() == null || node.getChildren().isEmpty());
            dimensionViewMembers.add(dimensionViewMember);
        }
        if (!dimensionViewMembers.isEmpty()) {
            this.replaceId(dimensionViewMembers);
        }
        return dimensionViewMembers;
    }

    protected void setMemberSpecialInfo(DimensionViewMember dimensionViewMember) {
    }

    protected void replaceId(List<DimensionViewMember> dimensionViewMembers) {
        ArrayList<DimensionViewMember> tempObjs = new ArrayList<DimensionViewMember>(dimensionViewMembers);
        dimensionViewMembers.clear();
        LinkedHashMap<Integer, List> levelDynamicObjectMap = new LinkedHashMap<Integer, List>();
        for (DimensionViewMember toSaveObj : tempObjs) {
            List objs = levelDynamicObjectMap.computeIfAbsent(toSaveObj.getLevel(), k -> new LinkedList());
            objs.add(toSaveObj);
        }
        LinkedHashMap<Long, Long> idsMap = new LinkedHashMap<Long, Long>();
        List levels = levelDynamicObjectMap.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        int last = (Integer)levels.get(levels.size() - 1);
        for (int i = ((Integer)levels.get(0)).intValue(); i <= last; ++i) {
            List dimensionViewMembers1 = (List)levelDynamicObjectMap.get(i);
            long[] newIds = DBServiceHelper.genLongIds(null, (int)dimensionViewMembers1.size());
            int jn = dimensionViewMembers1.size();
            for (int j = 0; j < jn; ++j) {
                DimensionViewMember dimensionViewMember = (DimensionViewMember)dimensionViewMembers1.get(j);
                idsMap.putIfAbsent(dimensionViewMember.getViewMemberId(), newIds[j]);
                dimensionViewMember.setViewMemberId(Long.valueOf(newIds[j]));
                Long parentId = (Long)idsMap.get(dimensionViewMember.getParentId());
                if (parentId == null) continue;
                dimensionViewMember.setParentId(parentId);
            }
            dimensionViewMembers.addAll(dimensionViewMembers1);
        }
    }

    protected List<DynamicObject> transformNodes(Map<String, TreeNode> rightNewNodes) {
        String treeModelType = this.getTreeModelType();
        long modelId = this.getModelId();
        Long dimId = this.getDimId();
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)UserUtils.getUserId());
        Date createTime = TimeServiceHelper.now();
        ArrayList<DynamicObject> toSaveMembers = new ArrayList<DynamicObject>(rightNewNodes.size());
        for (TreeNode node : rightNewNodes.values()) {
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)treeModelType);
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)member, (DynamicObject)user, (Date)createTime);
            TextProp tpNameProp = (TextProp)member.getDynamicObjectType().getProperty("Name");
            int iNameLen = tpNameProp.getMaxLenth();
            TextProp tpNumberProp = (TextProp)member.getDynamicObjectType().getProperty("number");
            int iNumberLen = tpNumberProp.getMaxLenth();
            String number = (String)this.getNodeProperty("number", node);
            String name = (String)this.getNodeProperty("name", node);
            member.set("id", (Object)Long.valueOf(node.getId()));
            member.set("number", (Object)org.apache.commons.lang3.StringUtils.substring((String)number, (int)0, (int)iNumberLen));
            member.set("shownumber", (Object)org.apache.commons.lang3.StringUtils.substring((String)number, (int)0, (int)iNumberLen));
            member.set("name", (Object)org.apache.commons.lang3.StringUtils.substring((String)name, (int)0, (int)iNameLen));
            member.set("membersource", (Object)MemberSourceEnum.SYSTEM_IMPORT.getIndex());
            member.set("longnumber", this.getNodeProperty("longnumber", node));
            member.set("level", this.getNodeProperty("level", node));
            TreeNode parentNode = rightNewNodes.get(this.getNodeProperty("parentid", node));
            member.set("parent", (Object)(parentNode == null ? node.getParentid() : parentNode.getId()));
            member.set(MODEL, (Object)modelId);
            member.set("dimension", (Object)dimId);
            member.set("dseq", this.getNodeProperty("dseq", node));
            member.set("storagetype", (Object)"2");
            member.set("isleaf", (Object)(node.getChildren() == null || node.getChildren().isEmpty() ? 1 : 0));
            this.setMemberOtherInfo(member);
            toSaveMembers.add(member);
        }
        this.setBatchMemberOtherInfo(toSaveMembers);
        if (!toSaveMembers.isEmpty()) {
            this.changeId(toSaveMembers);
        }
        return toSaveMembers;
    }

    protected List[] getBatchMembers(List<DynamicObject> members, int batchSize) {
        if (members == null || members.isEmpty()) {
            return new List[0];
        }
        int count = (members.size() - 1) / batchSize + 1;
        int fromIndex = 0;
        int toIndex = members.size() > batchSize ? batchSize : members.size();
        List[] batchMembers = new List[count];
        for (int index = 0; index < count; ++index) {
            batchMembers[index] = members.subList(fromIndex, toIndex);
            fromIndex += batchSize;
            if ((toIndex += batchSize) <= members.size()) continue;
            toIndex = members.size();
        }
        return batchMembers;
    }

    protected void changeId(List<DynamicObject> toSaveMembers) {
        ArrayList<DynamicObject> tempObjs = new ArrayList<DynamicObject>(toSaveMembers);
        toSaveMembers.clear();
        LinkedHashMap<Integer, List> levelDynamicObjectMap = new LinkedHashMap<Integer, List>();
        for (DynamicObject toSaveObj : tempObjs) {
            List objs = levelDynamicObjectMap.computeIfAbsent(toSaveObj.getInt("level"), k -> new LinkedList());
            objs.add(toSaveObj);
        }
        LinkedHashMap<Long, Long> idsMap = new LinkedHashMap<Long, Long>();
        List levels = levelDynamicObjectMap.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        int last = (Integer)levels.get(levels.size() - 1);
        for (int i = ((Integer)levels.get(0)).intValue(); i <= last; ++i) {
            List dynamicObjects = (List)levelDynamicObjectMap.get(i);
            long[] newIds = DBServiceHelper.genLongIds(null, (int)dynamicObjects.size());
            int jn = dynamicObjects.size();
            for (int j = 0; j < jn; ++j) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(j);
                idsMap.putIfAbsent(dynamicObject.getLong("id"), newIds[j]);
                dynamicObject.set("id", (Object)newIds[j]);
                Long parentId = (Long)idsMap.get(dynamicObject.getLong("parent"));
                if (parentId == null) continue;
                dynamicObject.set("parent", (Object)parentId);
            }
            toSaveMembers.addAll(dynamicObjects);
        }
    }

    private void getAllChildren(TreeNode parentNode, List<TreeNode> actSelectNodes) {
        if (parentNode == null) {
            return;
        }
        List children = parentNode.getChildren();
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                TreeNode child = (TreeNode)children.get(i);
                actSelectNodes.add(child);
                this.getAllChildren(child, actSelectNodes);
            }
        }
    }

    protected void getRightNewNodes(TreeNode parentNode, Map<String, TreeNode> rigthNewNodes, Set<String> parentIds, Set<String> addNewNumbers) {
        List rightChildren = parentNode.getChildren();
        if (rightChildren != null) {
            for (int i = 0; i < rightChildren.size(); ++i) {
                int lastSeq = i > 0 ? (Integer)this.getNodeProperty("dseq", (TreeNode)rightChildren.get(i - 1)) : 0;
                TreeNode rightChild = (TreeNode)rightChildren.get(i);
                Map data = (Map)rightChild.getData();
                data.put("dseq", lastSeq + 1);
                String number = (String)this.getNodeProperty("number", rightChild);
                data.put("longnumber", this.getNodeProperty("longnumber", parentNode) + "!" + number);
                data.put("level", (Integer)this.getNodeProperty("level", parentNode) + 1);
                data.put("parentid", this.getNodeProperty("id", parentNode));
                if (this.isNewNode(rightChild)) {
                    rigthNewNodes.put((String)this.getNodeProperty("id", rightChild), rightChild);
                    parentIds.add(parentNode.getId());
                    if (!addNewNumbers.add(number.toUpperCase())) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u91cd\u590d\u7f16\u7801%1\u3002", (String)"DimSysImportBasePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                    }
                }
                if (rightChild.getChildren() == null || rightChild.getChildren().isEmpty()) continue;
                this.getRightNewNodes(rightChild, rigthNewNodes, parentIds, addNewNumbers);
            }
        }
    }

    private void checkOlapConnect() {
        if (!OlapServiceHelper.checkIsOnlineByCube((Long)this.getModelId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u94fe\u63a5\u4e0d\u53ef\u7528\u3002", (String)"DimSysImportBasePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected void syncOlapData(List<DynamicObject> toInsertMembers, Set<String> parentIds) {
        String dimensionNumber;
        if (toInsertMembers.size() == 0) {
            return;
        }
        long modelId = this.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model");
        List datasets = this.getDataSets(model, dimensionNumber = this.getPageCache().get(DIMENSIONNUMBER));
        if (datasets.size() == 0) {
            return;
        }
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model);
        Model modelObj = Model.of((DynamicObject)model);
        ShrekOlapServiceHelper.addCubeMembers((Model)modelObj, datasets, (String)dimensionNumber, (List)Member.of(toInsertMembers, (boolean)"Account".equals(dimensionNumber)), (ShrekConfig)config);
        Long userId = UserUtils.getUserId();
        String traceId = RequestContext.get().getTraceId();
        EventBusUtil.asyncPost((Object)new FactoryChangeEvent(Long.valueOf(modelId), this.getDimId(), IDUtils.toLongs(parentIds), userId, traceId));
        if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
            QFBuilder builder = new QFBuilder();
            builder.add(MODEL, "=", (Object)modelId);
            builder.add("number", "=", (Object)SysDimensionEnum.InternalCompany.getNumber());
            DynamicObject icDim = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id,number,name", (QFilter[])builder.toArray());
            String selectFields = "id,number,dseq,aggoprt,parent,isleaf,storagetype";
            List numbers = toInsertMembers.stream().map(m -> m.getString("number")).collect(Collectors.toList());
            builder.clear();
            builder.add(MODEL, "=", (Object)modelId);
            builder.add("number", "in", numbers);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_icmembertree", (String)selectFields, (QFilter[])builder.toArray());
            if (query.size() > 0) {
                datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)SysDimensionEnum.InternalCompany.getNumber());
                ShrekOlapServiceHelper.addCubeMembers((Model)modelObj, (List)datasets, (String)SysDimensionEnum.InternalCompany.getNumber(), (List)Member.of(query.stream().collect(Collectors.toList()), (boolean)false), (ShrekConfig)config);
                Set icParentIds = query.stream().map(d -> d.getLong("parent")).collect(Collectors.toSet());
                EventBusUtil.asyncPost((Object)new FactoryChangeEvent(Long.valueOf(modelId), Long.valueOf(icDim.getLong("id")), IDUtils.toLongs(icParentIds), userId, traceId));
            }
        }
    }

    protected List<Dataset> getDataSets(DynamicObject modelObj, String dimensionNumber) {
        if ((ModelServiceHelper.isBGMDModel((Long)modelObj.getLong("id")) || NewEbAppUtil.isNewEbModel((Long)modelObj.getLong("id"))) && ShrekOlapServiceHelper.needDMLOlap((DynamicObject)modelObj) && SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            String datasetId = this.getPageCache().get("dataset");
            DynamicObject datasetDoj = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset");
            Dataset dataset = new Dataset(Long.valueOf(datasetDoj.getLong("id")), datasetDoj.getString("number"));
            return Collections.singletonList(dataset);
        }
        return DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)dimensionNumber);
    }

    protected void selectGoRight() {
        TreeNode leftRoot;
        ArrayList<String> illegalSelectIds;
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        List<String> selectIds = this.getCanMoveIds(treeleft, illegalSelectIds = new ArrayList<String>());
        if (selectIds.size() == 0 && illegalSelectIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        String rightFocusId = treeright.getTreeState().getFocusNodeId();
        if (rightFocusId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean allchildren = (Boolean)this.getModel().getValue("allchildren");
        if (allchildren.booleanValue() && illegalSelectIds.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u8282\u70b9\u6216\u4e0b\u7ea7\u5305\u542b\u4e0d\u5408\u6cd5\u7f16\u7801\u3002", (String)"DimSysImportBasePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        if (!this.isNewNode(rightFocusNode)) {
            String permInfo = this.checkEbMemAddNewPerm(rightFocusNode);
            if (!permInfo.equals("")) {
                this.getView().showTipNotification(permInfo);
                return;
            }
            String viewId = this.getPageCache().get("viewId");
            DimManagerInfo dimInfo = ActionFactory.buildDim(this.getModelId(), this.getDimId(), Long.parseLong(rightFocusId), IDUtils.toLong((Object)viewId));
            IAction action = ActionFactory.getAction(DimMembActionEnum.ADDCHILD, this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
            action.beforeAction();
            if (!action.isBeforeAction()) {
                return;
            }
        }
        if ((leftRoot = this.getWholeTree(wholeLeftTree)) == null) {
            return;
        }
        Set<String> rightNumbers = this.getNodeNumber(rightRoot);
        rightNumbers.addAll(this.queryDimViewMembers());
        boolean hasSkip = false;
        boolean hasType = false;
        ArrayList<TreeNode> actSelectNodes = new ArrayList<TreeNode>(10);
        ArrayList existNumbers = new ArrayList(10);
        for (String id : selectIds) {
            TreeNode selectNode = leftRoot.getTreeNode(id, 20);
            Map datas = (Map)selectNode.getData();
            if (!hasType && "1".equals(datas.get("isType"))) {
                hasType = true;
            }
            if (!hasType && !selectIds.contains(selectNode.getParentid())) {
                selectNode.setParentid("0");
                actSelectNodes.add(selectNode);
            }
            if (hasSkip || !this.isNodeExists(rightNumbers, selectNode)) continue;
            existNumbers.add(this.getNodeProperty("number", selectNode));
            hasSkip = true;
        }
        if (allchildren.booleanValue() && existNumbers.size() > 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6240\u9009\u62e9\u7684\u8282\u70b9\u6216\u4e0b\u7ea7\u5305\u542b\u91cd\u590d\u7f16\u7801%1\u3002", (String)"DimSysImportBasePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", existNumbers)}));
            return;
        }
        this.wholeOne(treeright, rightRoot, rightFocusNode, rightNumbers, actSelectNodes, false);
        this.cacheRightRoot(rightRoot);
        treeright.focusNode(rightFocusNode);
        treeleft.uncheckNodes(selectIds);
        this.setLeftTreeNoteColor("btngo", "blue", actSelectNodes, false);
        if (illegalSelectIds.size() != 0) {
            hasSkip = true;
        }
        if (hasSkip) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u60c5\u51b5\u7684\u5de6\u4fa7\u5185\u5bb9\u5c06\u4e0d\u4f1a\u88ab\u9009\u62e9\u5230\u53f3\u4fa7\uff1a", (String)"DimSysImportBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getNoticeMessage(), MessageTypes.Default);
        } else if (hasType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u5206\u7c7b\u65e0\u6cd5\u9009\u62e9\u81f3\u53f3\u4fa7\u3002", (String)"DimSysImportBasePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected String getNoticeMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u53f3\u4fa7\u7f16\u7801\u5df2\u5b58\u5728\uff08\u6216\u56e0\u6743\u9650\u95ee\u9898\u65e0\u6cd5\u67e5\u770b\uff09\uff1b", (String)"DimSysImportBasePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"2\u3001\u5de6\u4fa7\u7f16\u7801\u4e0d\u662f\u534a\u89d2\u5b57\u7b26\u6216\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u5982\u60ca\u53f9\u53f7\u7b49\uff1b", (String)"DimSysImportBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"3\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u51cf\u53f7\u5f00\u5934\uff1b", (String)"DimSysImportBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"4\u3001\u5de6\u4fa7\u7f16\u7801\u4e2d\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u4e0d\u5b58\u5728\u5176\u4ed6\u5b57\u7b26\uff1b", (String)"DimSysImportBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"5\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5._inv\u7ed3\u5c3e\uff1b", (String)"AccountSysImport_16", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"6\u3001\u5de6\u4fa7\u7f16\u7801\u4e3a\u4fdd\u7559\u5b57\uff1a'all', 'none', 'null', 'other'\u3002", (String)"DimSysImportBasePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return sb.toString();
    }

    protected void selectGoLeft() {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        String rightFocusId = treeright.getTreeState().getFocusNodeId();
        if (rightFocusId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        if (rightFocusId.equals(rightRoot.getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"DimSysImportBasePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        boolean hasSkip = false;
        Set<String> rightNumbers = this.getNodeNumber(rightRoot);
        if (this.isNewNode(rightFocusNode)) {
            TreeNode parentNode = rightRoot.deleteChildNode(rightFocusId);
            this.removeRightCache(rightNumbers, rightFocusNode);
            treeright.deleteNode(rightFocusId);
            if (parentNode.getChildren() == null || parentNode.getChildren().size() == 0) {
                parentNode.setChildren(null);
            }
            treeright.updateNode(parentNode);
            treeright.expand(parentNode.getId());
            treeright.focusNode(parentNode);
        } else {
            this.nodeBack(rightRoot, rightFocusNode, rightNumbers, false);
            treeright.updateNode(rightFocusNode);
            treeright.expand(rightFocusId);
            treeright.focusNode(rightFocusNode);
            hasSkip = true;
        }
        this.cacheRightRoot(rightRoot);
        ArrayList<TreeNode> selNoteLs = new ArrayList<TreeNode>();
        selNoteLs.add(rightFocusNode);
        this.setLeftTreeNoteColor("btnback", "", selNoteLs, false);
        if (hasSkip) {
            this.getView().showTipNotification(this.getBackSlipMsg());
        }
    }

    private void handleParentProperties(Object[] parentIds) {
        if (parentIds == null || parentIds.length == 0) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.getMemberkey(), (String)"id, number,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)parentIds)});
        if (load != null) {
            HashSet<String> needUpdateSignParentNumbers = new HashSet<String>(16);
            for (DynamicObject object : load) {
                if (object.getBoolean("isleaf")) {
                    needUpdateSignParentNumbers.add(object.getString("number"));
                }
                object.set("isleaf", (Object)false);
            }
            SaveServiceHelper.save((DynamicObject[])load);
            if (CollectionUtils.isNotEmpty(needUpdateSignParentNumbers)) {
                this.updateSubSign("updateData_entity", needUpdateSignParentNumbers, null);
            }
        }
    }

    protected void wholeOne(TreeView treeright, TreeNode rightRoot, TreeNode rightFocusNode, Set<String> numbers, List<TreeNode> actSelectNodes, boolean isAllgo) {
        for (TreeNode actSelectNode : actSelectNodes) {
            this.singleGo(rightFocusNode, actSelectNode, numbers, isAllgo, rightRoot);
        }
        treeright.updateNode(rightFocusNode);
        treeright.expand(rightFocusNode.getId());
    }

    protected List<TreeNode> singleGo(TreeNode rightFocusNode, TreeNode actSelectNode, Set<String> numbers, boolean isAllgo, TreeNode rightRoot) {
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        List selectIds = treeleft.getTreeState().getSelectedNodeId();
        TreeNode copy = this.cloneNode(actSelectNode, selectIds, isAllgo);
        return this.totalMerge(rightFocusNode, numbers, copy, rightRoot);
    }

    protected void rootGo(TreeNode rightFocusNode, TreeNode leftRoot, Set<String> rightNumbers, TreeNode rightRootNode) {
        if (!ResManager.loadKDString((String)"\u79d1\u76ee\u6839\u8282\u70b9", (String)"DimSysImportBasePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(leftRoot.getText())) {
            ArrayList<TreeNode> actNodes = new ArrayList<TreeNode>();
            actNodes.add(leftRoot);
            TreeView treeright = (TreeView)this.getView().getControl(treeRight);
            this.wholeOne(treeright, rightRootNode, rightFocusNode, rightNumbers, actNodes, true);
        } else {
            List children = leftRoot.getChildren();
            if (children != null) {
                leftRoot.getChildren().forEach(selectNode -> this.singleGo(rightFocusNode, (TreeNode)selectNode, rightNumbers, true, rightRootNode));
            }
        }
    }

    protected List<TreeNode> totalMerge(TreeNode rightFocusNode, Set<String> numbers, TreeNode copy, TreeNode rightRoot) {
        if (!this.isNodeExists(numbers, copy)) {
            this.slipTreeNode(numbers, copy);
            this.formalAddChild(rightFocusNode, copy);
            if (!((Boolean)this.getModel().getValue("allchildren")).booleanValue() || "0".equals(copy.getParentid())) {
                copy.setParentid(rightFocusNode.getId());
            }
            copy.setParentid(rightFocusNode.getId());
            this.addRightCache(numbers, copy);
            ArrayList<TreeNode> copys = new ArrayList<TreeNode>();
            copys.add(copy);
            return copys;
        }
        TreeNode matchNode = this.isMatch(rightFocusNode, copy);
        if (matchNode != null) {
            if (copy.getChildren() != null) {
                TreeView treeright = (TreeView)this.getView().getControl(treeRight);
                this.wholeOne(treeright, rightRoot, matchNode, numbers, copy.getChildren(), true);
            }
            return null;
        }
        this.slipTreeNode(numbers, copy);
        if (copy.getChildren() != null) {
            copy.getChildren().forEach(node -> node.setParentid(rightFocusNode.getId()));
            copy.getChildren().forEach(node -> this.addRightCache(numbers, (TreeNode)node));
            rightFocusNode.addChildren(copy.getChildren());
            return copy.getChildren();
        }
        return null;
    }

    private void formalAddChild(TreeNode rightFocusNode, TreeNode copy) {
        if (this.codeRule((String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)copy))) {
            rightFocusNode.addChild(copy);
        } else if (CollectionUtils.isNotEmpty((Collection)copy.getChildren())) {
            copy.getChildren().forEach(node1 -> node1.setParentid(rightFocusNode.getId()));
            rightFocusNode.addChildren(copy.getChildren());
        }
    }

    protected boolean isNodeExists(Set<String> numbers, TreeNode selectNode) {
        String number = (String)this.getNodeProperty("number", selectNode);
        return numbers.contains(number.toUpperCase());
    }

    private void addRightCache(Set<String> numbers, TreeNode copy) {
        String number = (String)this.getNodeProperty("number", copy);
        numbers.add(number.toUpperCase());
        if (copy.getChildren() != null) {
            for (TreeNode child : copy.getChildren()) {
                this.addRightCache(numbers, child);
            }
        }
    }

    protected void removeRightCache(Set<String> rightNumbers, TreeNode copy) {
        String number = (String)this.getNodeProperty("number", copy);
        rightNumbers.remove(number.toUpperCase());
        List children = copy.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.removeRightCache(rightNumbers, child);
            }
        }
    }

    private TreeNode isMatch(TreeNode rightFocusNode, TreeNode copy) {
        List children = rightFocusNode.getChildren();
        if (children != null) {
            String Cnumber = (String)this.getNodeProperty("number", copy);
            for (TreeNode focusChild : children) {
                String Fnumber = (String)this.getNodeProperty("number", focusChild);
                if (!focusChild.getId().equals(copy.getId()) && !Fnumber.equals(Cnumber)) continue;
                return focusChild;
            }
        }
        return null;
    }

    protected void slipTreeNode(Set<String> numbers, TreeNode node) {
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            ArrayList newChilds = Lists.newArrayListWithExpectedSize((int)children.size());
            for (int i = 0; i < children.size(); ++i) {
                TreeNode child = (TreeNode)children.get(i);
                if (this.isNodeExists(numbers, child) || !this.codeRule((String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)child))) {
                    List childChildren = child.getChildren();
                    if (!CollectionUtils.isNotEmpty((Collection)childChildren)) continue;
                    childChildren.forEach(node1 -> node1.setParentid(node.getId()));
                    children.addAll(childChildren);
                    continue;
                }
                newChilds.add(child);
                this.slipTreeNode(numbers, child);
            }
            if (CollectionUtils.isNotEmpty((Collection)newChilds)) {
                node.setChildren((List)newChilds);
            } else {
                node.setChildren(null);
            }
        }
    }

    private void allClear(TreeNode leftRoot, TreeView treeleft) {
        List<String> ids = this.getAllIds(leftRoot, new LinkedList<String>());
        treeleft.uncheckNodes(ids);
    }

    protected void allChoose(final TreeView treeleft, TreeNode leftRoot) {
        if (leftRoot.getChildren() != null) {
            treeleft.checkNodes(leftRoot.getChildren());
            leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    DimSysImportBasePlugin.this.allChoose(treeleft, t);
                }
            });
        }
    }

    protected void allgo() {
        String permInfo;
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        String rightFocusId = treeright.getTreeState().getFocusNodeId();
        if (rightFocusId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        if (!this.isNewNode(rightFocusNode) && !(permInfo = this.checkEbMemAddNewPerm(rightFocusNode)).equals("")) {
            this.getView().showTipNotification(permInfo);
            return;
        }
        Set<String> rightNumbers = this.getNodeNumber(rightRoot);
        rightNumbers.addAll(this.queryDimViewMembers());
        TreeNode leftRoot = this.getWholeTree(wholeLeftTree);
        if (leftRoot == null) {
            return;
        }
        boolean hasSkip = this.hasSkip(leftRoot, rightNumbers);
        ArrayList<TreeNode> goNodes = new ArrayList<TreeNode>();
        goNodes.add(rightRoot);
        goNodes.forEach(goNode -> {
            this.rootGo((TreeNode)goNode, leftRoot, rightNumbers, rightRoot);
            treeright.updateNode(goNode);
            treeright.expand(goNode.getId());
        });
        rightFocusNode.setExpend(true);
        this.cacheRightRoot(rightRoot);
        treeright.focusNode(rightFocusNode);
        if (hasSkip) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u60c5\u51b5\u7684\u5de6\u4fa7\u5185\u5bb9\u5c06\u4e0d\u4f1a\u88ab\u9009\u62e9\u5230\u53f3\u4fa7\uff1a", (String)"DimSysImportBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getNoticeMessage(), MessageTypes.Default);
            return;
        }
    }

    protected void allback() {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        TreeNode rightRoot = this.getCacheRightRoot();
        Set<String> rightNumbers = this.getNodeNumber(rightRoot);
        boolean hasSkip = false;
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(rightRoot, list, true, 20);
        for (TreeNode treeNode : list) {
            if (this.isNewNode(treeNode)) continue;
            hasSkip = true;
        }
        this.nodeAllBack(rightRoot, rightNumbers, true);
        rightRoot.setExpend(true);
        treeright.updateNode(rightRoot);
        treeright.expand(rightRoot.getId());
        this.cacheRightRoot(rightRoot);
        treeright.focusNode(rightRoot);
        if (hasSkip) {
            this.getView().showTipNotification(this.getBackSlipMsg());
        }
    }

    public void nodeBack(TreeNode rightRoot, TreeNode rightFocusNode, Set<String> rightNumbers, boolean force) {
        List children = rightFocusNode.getChildren();
        for (int i = 0; rightFocusNode.getChildren() != null && i < rightFocusNode.getChildren().size(); ++i) {
            TreeNode child = (TreeNode)children.get(i);
            if (this.isNewNode(child) && force) {
                TreeNode parentNode = rightFocusNode.deleteChildNode(child.getId());
                if (parentNode != null && parentNode.getChildren() != null && parentNode.getChildren().size() == 0) {
                    parentNode.setChildren(null);
                }
                --i;
                this.removeRightCache(rightNumbers, child);
                continue;
            }
            this.nodeBack(rightRoot, child, rightNumbers, force);
        }
    }

    private void nodeAllBack(TreeNode rightFocusNode, Set<String> rightNumbers, boolean force) {
        List children = rightFocusNode.getChildren();
        for (int i = 0; rightFocusNode.getChildren() != null && i < rightFocusNode.getChildren().size(); ++i) {
            TreeNode child = (TreeNode)children.get(i);
            if (this.isNewNode(child) && force) {
                TreeNode parentNode = rightFocusNode.deleteChildNode(child.getId());
                if (parentNode.getChildren() != null && parentNode.getChildren().size() == 0) {
                    parentNode.setChildren(null);
                }
                --i;
                this.removeRightCache(rightNumbers, child);
                continue;
            }
            this.nodeBack(rightFocusNode, child, rightNumbers, force);
        }
    }

    protected boolean hasSkip(TreeNode leftRoot, Set<String> rightNumbers) {
        if (this.isNodeExists(rightNumbers, leftRoot) || !this.codeRule((String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)leftRoot))) {
            return true;
        }
        List children = leftRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (!this.hasSkip(child, rightNumbers)) continue;
                return true;
            }
        }
        return false;
    }

    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        List children = leftRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.collapseChild(child, treeleft);
            }
        }
        List selectNodes = treeleft.getTreeState().getSelectedNodes();
        List selectIds = selectNodes.stream().map(e -> (String)e.get("id")).collect(Collectors.toList());
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
        ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
        this.getAllChilden(leftRoot, allchilden, false, 20);
        for (TreeNode node : allchilden) {
            if (!selectIds.contains(node.getId())) continue;
            treeleft.checkNode(node);
        }
    }

    protected void getAllChilden(TreeNode root, List<TreeNode> nodes, boolean hasSelf, int level) {
        List children;
        if (hasSelf) {
            nodes.add(root);
        }
        if ((children = root.getChildren()) != null && children.size() > 0 && level > 0) {
            nodes.addAll(children);
            for (TreeNode child : children) {
                this.getAllChilden(child, nodes, false, --level);
            }
        }
    }

    protected void collapseChild(TreeNode leftRoot, TreeView treeleft) {
        List children = leftRoot.getChildren();
        if (children != null && children.size() > 0) {
            leftRoot.setIsOpened(false);
            for (TreeNode child : children) {
                this.collapseChild(child, treeleft);
            }
        }
    }

    protected void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        this.spreadChild(leftRoot, treeleft);
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    protected void spreadChild(TreeNode leftRoot, TreeView treeleft) {
        List children = leftRoot.getChildren();
        if (children != null && children.size() > 0) {
            leftRoot.setIsOpened(true);
            for (TreeNode child : children) {
                this.spreadChild(child, treeleft);
            }
        }
    }

    protected TreeNode getLeftRoot() {
        return null;
    }

    protected TreeNode getRigthRoot() {
        Map<String, TreeNode> allNode = this.queryDimMembers();
        TreeNode root = null;
        for (Map.Entry<String, TreeNode> entry : allNode.entrySet()) {
            TreeNode node = entry.getValue();
            if (!"0".equals(node.getParentid())) continue;
            root = node;
            break;
        }
        if (root != null) {
            this.buildTree(allNode, root);
            root.setParentid("");
            this.cacheNode(wholeRightTree, root);
        }
        return root;
    }

    protected void buildTree(Map<String, TreeNode> map, TreeNode root) {
        for (Map.Entry<String, TreeNode> entry : map.entrySet()) {
            TreeNode node = entry.getValue();
            String id = entry.getKey();
            String parentId = node.getParentid();
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)parentId)) continue;
            if (map.get(parentId) != null) {
                TreeNode parent = map.get(parentId);
                parent.addChild(node);
                continue;
            }
            if (id.equals(root.getId())) continue;
            root.addChild(node);
        }
    }

    private Map<String, TreeNode> queryDimMembers() {
        LinkedHashMap<String, TreeNode> map = new LinkedHashMap<String, TreeNode>(16);
        long modelId = this.getModelId();
        Long dimId = this.getDimId();
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.add("dimension", "=", (Object)dimId);
        qfBuilder.add("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        qfBuilder.add("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        if ("epm_accountmembertree".equals(this.getMemberkey()) && this.isBgmd()) {
            qfBuilder.add("dataset", "=", (Object)Long.parseLong(this.getView().getFormShowParameter().getCustomParam("datasetId").toString()));
            qfBuilder.or("number", "=", (Object)"Account");
        }
        boolean isManager = false;
        String dimNum = (String)this.getView().getFormShowParameter().getCustomParam(DIMENSIONNUMBER);
        Set hasPermInfoIds = DimMembPermUtil.getDimManagerHasPermMembIds((Long)this.getModelId(), (Long)this.getUserId(), (String)dimNum, (Long)0L, (boolean)false);
        if (MemberPermHelper.ifUserHasRootPermByModel((Long)this.getUserId(), (Long)this.getModelId())) {
            isManager = true;
        }
        String selectfields = "id,name,number,parent as parentid,longnumber,isleaf,dseq,level";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".queryDimMembers"), (String)this.getMemberkey(), (String)selectfields, (QFilter[])qfBuilder.toArray(), (String)"level, dseq");
        if (!dataSet.isEmpty()) {
            for (Row row : dataSet) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)row.getString("id")) || !isManager && !hasPermInfoIds.contains(row.getLong("id")) && !"1".equals(row.getString("level"))) continue;
                map.put(row.getString("id"), this.createTreeNode(row, "right"));
            }
        }
        return map;
    }

    protected Set<String> queryDimViewMembers() {
        LinkedHashSet<String> viewMembers = new LinkedHashSet<String>();
        QFBuilder builder = new QFBuilder();
        builder.add(MODEL, "=", (Object)this.getModelId());
        builder.add("dimension", "=", (Object)this.getDimId());
        builder.add("membersource", "=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDimViewMembers", (String)this.getMemberkey(), (String)"number", (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    viewMembers.add(row.getString("number").toUpperCase());
                }
            }
        }
        return viewMembers;
    }

    protected TreeNode createTreeNode(Row row, String target) {
        TreeNode node = new TreeNode();
        node.setId(row.getString("id"));
        node.setText(row.getString("number") + " " + row.getString("name"));
        node.setParentid(row.getString("parentid"));
        node.setLongNumber(row.getString("longnumber"));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", row.getString("id"));
        data.put("name", row.getString("name"));
        data.put("number", row.getString("number"));
        data.put("parentid", row.getString("parentid"));
        data.put("isleaf", row.getBoolean("isleaf"));
        data.put("longnumber", row.getString("longnumber"));
        data.put("dseq", row.getInteger("dseq"));
        data.put("level", row.getInteger("level"));
        if ("left".equals(target)) {
            data.put("isNew", "1");
        } else {
            data.put("isNew", "0");
        }
        node.setData(data);
        return node;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String key = treeView.getKey();
        TreeNode wholeTree = null;
        TreeNode currenTree = null;
        if (treeLeft.equals(key)) {
            wholeTree = this.getCacheNode(wholeLeftTree);
            currenTree = this.getCacheLeftRoot();
        } else {
            wholeTree = this.getCacheNode(wholeRightTree);
            currenTree = this.getCacheRightRoot();
        }
        String expendNodeId = evt.getNodeId().toString();
        TreeNode expendNode = currenTree.getTreeNode(expendNodeId, 20);
        List children = expendNode.getChildren();
        if (children != null && children.size() > 0) {
            return;
        }
        TreeNode treeNode = wholeTree.getTreeNode(expendNodeId, 20);
        if (treeNode != null) {
            this.copyOneLevel(expendNode, treeNode.getChildren());
            List children1 = expendNode.getChildren();
            if (children1 != null) {
                Set<String> rightNumbers = this.getRightNodeNumber();
                for (TreeNode node : children1) {
                    if (!rightNumbers.contains(((String)this.getNodeProperty("number", node)).toUpperCase())) continue;
                    node.setColor("blue");
                }
            }
        }
        if (treeLeft.equals(key)) {
            this.cacheLeftRoot(currenTree);
        } else {
            this.cacheRightRoot(currenTree);
        }
        treeView.updateNode(expendNode);
        treeView.expand(expendNodeId);
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        this.cacheNode(cache_leftTree, rootleft);
    }

    protected TreeNode getCacheLeftRoot() {
        return this.getCacheNode(cache_leftTree);
    }

    protected TreeNode getCacheRightRoot() {
        return this.getCacheNode(cache_rightTree);
    }

    protected void cacheRightRoot(TreeNode rootRight) {
        Queue<TreeNode> queue = TreeSearchUtil.getQueue(rootRight);
        while (!queue.isEmpty()) {
            TreeNode node = queue.poll();
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                child.setParentid(node.getId());
            }
        }
        this.cacheNode(cache_rightTree, rootRight);
    }

    protected TreeNode getCacheNode(@NotNull String cacheKey) {
        String nodeCache = this.getPageCache().get(cacheKey);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)nodeCache)) {
            try {
                return (TreeNode)SerializationUtils.deSerializeFromBase64((String)nodeCache);
            }
            catch (Exception ex) {
                log.error("getCacheNode-error", (Throwable)ex);
            }
        }
        return null;
    }

    protected void cacheNode(@NotNull String cacheKey, @NotNull TreeNode node) {
        try {
            this.getPageCache().put(cacheKey, SerializationUtils.serializeToBase64((Object)node));
        }
        catch (Exception ex) {
            log.error("cacheNode-error", (Throwable)ex);
        }
    }

    public String checkEbMemAddNewPerm(TreeNode currentRightNode) {
        String viewId = this.getPageCache().get("viewId");
        DimManagerInfo dimInfo = ActionFactory.buildDim(this.getModelId(), this.getDimId(), Long.parseLong(currentRightNode.getId()), IDUtils.toLong((Object)viewId));
        IAction action = ActionFactory.getMemberPermAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo, "btn_sysimport", DimMembActionEnum.ADDCHILD);
        action.beforeAction();
        return action.getResult();
    }

    protected void setMemberOtherInfo(DynamicObject member) {
    }

    protected void setBatchMemberOtherInfo(List<DynamicObject> members) {
    }

    protected void afterSave(List<DynamicObject> toSaveMembers, Set<String> parentIds) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(rightCurrentNode, nodeId);
    }

    protected String getTreeModelType() {
        return "";
    }

    protected TreeNode cloneNode(TreeNode actSelectNode, List<String> selectIds, boolean isAllGo) {
        TreeNode copy = new TreeNode();
        copy.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        copy.setParentid(actSelectNode.getParentid());
        Object data = actSelectNode.getData();
        Map sourceData = (Map)data;
        HashMap copyData = new HashMap();
        copyData.putAll(sourceData);
        copy.setData(copyData);
        copy.setText(actSelectNode.getText());
        copy.setColor("#5E80EB");
        List children = actSelectNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (!selectIds.contains(child.getId()) && !isAllGo) continue;
                copy.addChild(this.cloneNode(child, selectIds, isAllGo));
            }
        }
        if (((Boolean)this.getModel().getValue("allchildren")).booleanValue() && actSelectNode.getChildren() != null) {
            copy.setChildren(actSelectNode.getChildren());
        }
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(copy, list, true, 20);
        for (TreeNode treeNode : list) {
            treeNode.setColor("#5E80EB");
        }
        return copy;
    }

    protected String getSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u8df3\u8fc7\u5df2\u5b58\u5728\u7684\u6210\u5458\u3002", (String)"DimSysImportBasePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    protected String getBackSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u8df3\u8fc7\u5df2\u4fdd\u5b58\u7684\u6210\u5458\u3002\u5982\u9700\u6e05\u9664\u5df2\u4fdd\u5b58\u7684\u6210\u5458\uff0c\u8bf7\u5728\u6210\u5458\u5217\u8868\u4e2d\u5220\u9664\u3002", (String)"DimSysImportBasePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    protected <T> T getNodeProperty(String key, TreeNode rightNode) {
        Object data = rightNode.getData();
        if (data instanceof Map) {
            Map nodeData = (Map)data;
            Object value = nodeData.get(key);
            return (T)(value != null ? value : nodeData.get(key.toUpperCase()));
        }
        return null;
    }

    private void setNodeProperty(String key, Object value, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        nodeData.put(key, value);
    }

    protected boolean isNewNode(TreeNode rightFocusNode) {
        return "1".equals(this.getNodeProperty("isNew", rightFocusNode));
    }

    protected String getRightSelector() {
        return "id,name,number,parent,parent.number,dseq,level,longnumber,isleaf";
    }

    protected void setLeftTreeNoteColor(String key, String strColor, List<TreeNode> selectNode, boolean doAll) {
    }

    private List<TreeNode> getAllNode(TreeNode treeNode, List<TreeNode> treeNodes) {
        treeNodes.add(treeNode);
        List children = treeNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.getAllNode(child, treeNodes);
            }
        }
        return treeNodes;
    }

    private List<String> getAllIds(TreeNode treeNode, List<String> ids) {
        ids.add(treeNode.getId());
        List children = treeNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.getAllIds(child, ids);
            }
        }
        return ids;
    }

    protected Set<String> getRightNodeNumber() {
        TreeNode rightTree = this.getCacheRightRoot();
        if (rightTree != null) {
            return this.getNodeNumber(rightTree);
        }
        return null;
    }

    protected Set<String> getNodeNumber(TreeNode node) {
        if (node == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> numbers = new LinkedHashSet<String>();
        this.getNodeNumber(node, numbers);
        return numbers;
    }

    private void getNodeNumber(TreeNode node, Set<String> numbers) {
        if (node == null) {
            return;
        }
        String number = (String)this.getNodeProperty("number", node);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)number)) {
            numbers.add(number.trim().toUpperCase());
        }
        if (node.getChildren() != null) {
            int in = node.getChildren().size();
            for (int i = 0; i < in; ++i) {
                this.getNodeNumber((TreeNode)node.getChildren().get(i), numbers);
            }
        }
    }

    protected List<String> getCanMoveIds(TreeView treeleft, List<String> illegalSelectIds) {
        List selectNodes = treeleft.getTreeState().getSelectedNodes();
        ArrayList<String> canMoveId = new ArrayList<String>(10);
        TreeNode leftRoot = this.getCacheNode(wholeLeftTree);
        Boolean allchildren = (Boolean)this.getModel().getValue("allchildren");
        for (Map node : selectNodes) {
            String id = node.get("id").toString();
            if ("0".equals(id) || "root".equals(id)) {
                illegalSelectIds.add(id);
                continue;
            }
            TreeNode treeNode = leftRoot.getTreeNode(id, 20);
            ArrayList<TreeNode> allChilden = new ArrayList<TreeNode>(10);
            allChilden.add(treeNode);
            if (treeNode == null) continue;
            if (allchildren.booleanValue()) {
                this.getAllChildren(treeNode, allChilden);
            }
            for (TreeNode child : allChilden) {
                String cid = child.getId();
                if (this.codeRule((String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)child))) {
                    canMoveId.add(cid);
                    continue;
                }
                illegalSelectIds.add(cid);
            }
        }
        return canMoveId;
    }

    protected boolean codeRule(String number) {
        return NumberCheckUtils.checkNumber((String)number) && !number.equalsIgnoreCase("other") && !number.equalsIgnoreCase("all") && !number.equalsIgnoreCase("none") && !number.equalsIgnoreCase("null") && !org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)number, (CharSequence)"._inv");
    }

    protected TreeNode copyNode(TreeNode node) {
        TreeNode copyNode = new TreeNode();
        copyNode.setId(node.getId());
        copyNode.setText(node.getText());
        copyNode.setParentid(node.getParentid());
        copyNode.setData(node.getData());
        copyNode.setLongNumber(node.getLongNumber());
        List children = node.getChildren();
        if (children != null && children.size() > 0) {
            copyNode.setChildren(new ArrayList(16));
        }
        return copyNode;
    }

    protected void copyOneLevel(TreeNode parentNode, List<TreeNode> levelNodes) {
        if (levelNodes != null) {
            for (TreeNode levelNode : levelNodes) {
                parentNode.addChild(this.copyNode(levelNode));
            }
        }
    }

    protected TreeNode getWholeTree(String cacheKey) {
        return this.getCacheNode(cacheKey);
    }

    private void searchLeftTree(String text) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u641c\u7d22\u7684\u5185\u5bb9\u3002", (String)"DimSysImportBasePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode leftWholeTree = this.getWholeTree(wholeLeftTree);
        List<String> searchResult = this.getSearchResult(new ArrayList<String>(16), leftWholeTree, text.toLowerCase());
        if (searchResult.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DimSysImportBasePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusid = searchResult.get(0);
        List<String> parentPath = this.getParentPath(leftWholeTree, new ArrayList<String>(16), focusid);
        TreeView treeView = (TreeView)this.getControl(treeLeft);
        for (int i = parentPath.size() - 1; i > 0; --i) {
            treeView.expand(parentPath.get(i));
            this.treeExpandEvevt(treeView, parentPath.get(i));
        }
        TreeNode currentNode = this.getCacheLeftRoot().getTreeNode(parentPath.get(0), 20);
        currentNode.setColor("red");
        treeView.updateNode(currentNode);
        treeView.focusNode(currentNode);
        this.getPageCache().put(cache_resultSearch, SerializationUtils.serializeToBase64(searchResult));
        this.getPageCache().put(cache_searchSign, "left");
        this.getPageCache().put(cache_currentFocusId, focusid);
    }

    private List<String> getSearchResult(List<String> searchResult, TreeNode root, String text) {
        List children;
        String text1 = root.getText().toLowerCase();
        if (text1.contains(text)) {
            searchResult.add(root.getId());
        }
        if ((children = root.getChildren()) != null) {
            for (TreeNode child : children) {
                this.getSearchResult(searchResult, child, text);
            }
        }
        return searchResult;
    }

    private List<String> getParentPath(TreeNode root, List<String> parentPath, String focusId) {
        String parentid;
        TreeNode parent;
        parentPath.add(focusId);
        TreeNode treeNode = root.getTreeNode(focusId, 20);
        if (treeNode != null && (parent = root.getTreeNode(parentid = treeNode.getParentid(), 20)) != null) {
            this.getParentPath(root, parentPath, parent.getId());
        }
        return parentPath;
    }

    private void treeExpandEvevt(TreeView treeView, String nodeId) {
        TreeNodeEvent evt = new TreeNodeEvent((Object)treeView, null, (Object)nodeId);
        this.queryTreeNodeChildren(evt);
    }

    protected void searchUpAndDown(String key) {
        String currentFocusId = this.getPageCache().get(cache_currentFocusId);
        String sign = this.getPageCache().get(cache_searchSign);
        String result = this.getPageCache().get(cache_resultSearch);
        if (currentFocusId == null || sign == null || result == null) {
            return;
        }
        if (!"left".equals(sign)) {
            return;
        }
        List searchResult = (List)SerializationUtils.deSerializeFromBase64((String)result);
        String before = currentFocusId;
        int i = searchResult.indexOf(currentFocusId);
        if ("searchbefore1".equals(key)) {
            if (i == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761", (String)"DimSysImportBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            --i;
        } else {
            if (i == searchResult.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd9\u662f\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DimSysImportBasePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ++i;
        }
        TreeView treeView = (TreeView)this.getControl(treeLeft);
        TreeNode beforNode = this.getCacheLeftRoot().getTreeNode(before, 20);
        beforNode.setColor("");
        treeView.updateNode(beforNode);
        currentFocusId = (String)searchResult.get(i);
        List<String> parentPath = this.getParentPath(this.getWholeTree(wholeLeftTree), new ArrayList<String>(16), currentFocusId);
        for (int j = parentPath.size() - 1; j > 0; --j) {
            treeView.expand(parentPath.get(j));
            this.treeExpandEvevt(treeView, parentPath.get(j));
        }
        TreeNode treeNode = this.getCacheLeftRoot().getTreeNode(parentPath.get(0), 20);
        treeNode.setColor("red");
        treeView.updateNode(treeNode);
        treeView.focusNode(treeNode);
        this.getPageCache().put(cache_currentFocusId, currentFocusId);
    }

    private void searchRightTree(String text) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u641c\u7d22\u7684\u5185\u5bb9\u3002", (String)"DimSysImportBasePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode right = this.getWholeTree(wholeRightTree);
        List<String> searchResult = this.getSearchResult(new ArrayList<String>(16), right, text.toLowerCase());
        if (searchResult.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DimSysImportBasePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusid = searchResult.get(0);
        List<String> parentPath = this.getParentPath(right, new ArrayList<String>(16), focusid);
        TreeView treeView = (TreeView)this.getControl(treeRight);
        for (int i = parentPath.size() - 1; i > 0; --i) {
            treeView.expand(parentPath.get(i));
        }
        TreeNode currentNode = right.getTreeNode(parentPath.get(0), 20);
        treeView.updateNode(currentNode);
        treeView.focusNode(currentNode);
        this.getPageCache().put(cache_resultSearch, SerializationUtils.serializeToBase64(searchResult));
        this.getPageCache().put(cache_searchSign, "right");
        this.getPageCache().put(cache_currentFocusId, focusid);
    }

    protected void searchUpAndDownRight(String key) {
        String currentFocusId = this.getPageCache().get(cache_currentFocusId);
        String sign = this.getPageCache().get(cache_searchSign);
        String result = this.getPageCache().get(cache_resultSearch);
        if (currentFocusId == null || sign == null || result == null) {
            return;
        }
        if (!"right".equals(sign)) {
            return;
        }
        List searchResult = (List)SerializationUtils.deSerializeFromBase64((String)result);
        int i = searchResult.indexOf(currentFocusId);
        if ("searchbefore".equals(key)) {
            if (i == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761", (String)"DimSysImportBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            --i;
        } else {
            if (i == searchResult.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd9\u662f\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DimSysImportBasePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ++i;
        }
        TreeView treeView = (TreeView)this.getControl(treeRight);
        TreeNode right = this.getCacheRightRoot();
        currentFocusId = (String)searchResult.get(i);
        List<String> parentPath = this.getParentPath(right, new ArrayList<String>(16), currentFocusId);
        for (int j = parentPath.size() - 1; j > 0; --j) {
            treeView.expand(parentPath.get(j));
        }
        TreeNode treeNode = right.getTreeNode(parentPath.get(0), 20);
        treeView.focusNode(treeNode);
        this.getPageCache().put(cache_currentFocusId, currentFocusId);
    }

    @Override
    public Long getModelId() {
        return Long.valueOf(this.getPageCache().get(MODEL));
    }

    public Long getDimId() {
        String dimId = this.getView().getFormShowParameter().getCustomParam(DIMENSIONID).toString();
        Long id = 0L;
        if (dimId != null) {
            id = Long.valueOf(dimId);
        }
        return id;
    }

    protected String getMemberkey() {
        return this.getPageCache().get(MEMBERKEY);
    }

    private void clearSearchCache() {
        this.getPageCache().put(cache_resultSearch, null);
        this.getPageCache().put(cache_searchSign, null);
        this.getPageCache().put(cache_currentFocusId, null);
    }

    protected boolean isBgmd() {
        return "bgmd".equals(this.getAppNum());
    }

    protected boolean isEB() {
        return ApplicationTypeEnum.EB.getAppnum().equals(this.getAppNum()) && !NewEbAppUtil.isNewEbModel((Long)this.getModelId());
    }

    protected String getAppNum() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }
}

