/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.importplugin.DimSysImportBasePlugin;
import kd.epm.eb.model.utils.EntityVersioningUtil;

public class EntitySysImport
extends DimSysImportBasePlugin {
    public static final String leftTreeNodeIds = "leftTreeNodeIds";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = this.getModelId();
        Date modelDate = EntityVersioningUtil.getModelBeginDate((Object)modelId);
        if (modelDate != null) {
            this.getModel().setValue("datefield", (Object)modelDate);
            DateEdit de = (DateEdit)this.getControl("datefield");
            de.setMinDate(modelDate);
        }
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        QFilter qfNumber = new QFilter("number", "=", (Object)"InternalCompany");
        DynamicObject icDimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{qfModel, qfNumber});
        this.getPageCache().put("icDimension", icDimension.getString("id"));
        qfNumber = new QFilter("number", "=", (Object)"ICEntity");
        DynamicObject icParent = QueryServiceHelper.queryOne((String)"epm_icmembertree", (String)"id,isleaf", (QFilter[])new QFilter[]{qfModel, qfNumber});
        this.getPageCache().put("icParent", icParent.getString("id"));
        this.getPageCache().put("icParentIsLeaf", icParent.getBoolean("isleaf") ? "1" : "0");
        int icMaxSeq = DimensionServiceHelper.getDSeq((long)icParent.getLong("id"), (String)"epm_icmembertree");
        this.getPageCache().put("icMaxSeq", String.valueOf(icMaxSeq));
        HashMap<String, String> leftNodeIds = new HashMap<String, String>();
        this.cacheLeftIds(leftNodeIds);
        qfNumber = new QFilter("number", "=", (Object)"CNY");
        DynamicObject currency = QueryServiceHelper.queryOne((String)"epm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{qfNumber, qfModel});
        if (currency != null) {
            this.getModel().setValue("defaultcurrency", (Object)currency.getString("id"));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(qfModel);
        qFilters.add(new QFilter("number", "!=", (Object)"Currency"));
        BasedataEdit defaultcurrency = (BasedataEdit)this.getControl("defaultcurrency");
        defaultcurrency.setQFilters(qFilters);
        this.displayColor();
    }

    @Override
    protected TreeNode getLeftRoot() {
        QFBuilder qfBuilder;
        TreeNode root = null;
        DataSet dataSet = null;
        LinkedHashMap<String, TreeNode> allNode = new LinkedHashMap<String, TreeNode>(16);
        String viewType = (String)this.getModel().getValue("combofield");
        if (StringUtils.equals((String)viewType, (String)"01") || StringUtils.equals((String)viewType, (String)"15")) {
            qfBuilder = new QFBuilder("view.treetype", "=", (Object)viewType);
            qfBuilder.add("org.enable", "=", (Object)"1");
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
            freezeFilter.or("isfreeze", "is null", null);
            qfBuilder.add(freezeFilter);
            String selectFields = "org.id as id,org.name as name,org.number as number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level";
            dataSet = QueryServiceHelper.queryDataSet((String)"EntitySysImport.getOrgTreeDataEB", (String)"bos_adminorg_structure", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"org.number,level");
        } else if (StringUtils.equals((String)viewType, (String)"02")) {
            qfBuilder = new QFBuilder("enable", "=", (Object)"1");
            String selectFields = "id,name,number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level";
            dataSet = QueryServiceHelper.queryDataSet((String)"EntitySysImport.BOS_COSTCENTER", (String)"bos_costcenter", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"number,level");
        }
        if (dataSet != null) {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                allNode.put(row.getString("id"), this.createTreeNode(row, "left"));
                if (!"0".equals(row.getString("parentid"))) continue;
                root = (TreeNode)allNode.get(row.getString("id"));
            }
        }
        root = root == null ? new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntitySysImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0])) : root;
        this.buildTree(allNode, root);
        root.setParentid("");
        this.cacheNode("wholeLeftTree", root);
        TreeNode copyRoot = this.copyNode(root);
        this.copyOneLevel(copyRoot, root.getChildren());
        return copyRoot;
    }

    private void displayColor() {
        Set<String> rightNumbers = this.getRightNodeNumber();
        TreeNode cacheLeftRoot = this.getCacheLeftRoot();
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(cacheLeftRoot, list, true, 20);
        list.removeIf(l -> !rightNumbers.contains((this.getNodeProperty("number", (TreeNode)l) == null ? "" : (String)this.getNodeProperty("number", (TreeNode)l)).toUpperCase()));
        this.setLeftTreeNoteColor("btngo", "blue", list, false);
    }

    @Override
    protected void setLeftTreeNoteColor(String key, String strColor, List<TreeNode> selectNode, boolean doAll) {
        if (doAll) {
            this.setLeftTreeColor(null, strColor, true);
        } else {
            LinkedList<String> leftNodeids = new LinkedList<String>();
            switch (key) {
                case "btnback": {
                    TreeNode rightRoot = selectNode.get(0);
                    this.getLeftNodesByRightTree(rightRoot, leftNodeids);
                    this.setLeftTreeColor(leftNodeids, "", false);
                    break;
                }
                case "btngo": {
                    Boolean allchildren = (Boolean)this.getModel().getValue("allchildren");
                    TreeNode leftRoot = new TreeNode();
                    if (allchildren.booleanValue()) {
                        leftRoot = this.getCacheNode("wholeLeftTree");
                    }
                    for (int i = 0; i < selectNode.size(); ++i) {
                        String nodeId = selectNode.get(i).getId();
                        if (allchildren.booleanValue()) {
                            TreeNode treeNode = leftRoot.getTreeNode(nodeId, 20);
                            ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
                            this.getAllChilden(treeNode, allchilden, true, 20);
                            for (TreeNode node : allchilden) {
                                node.setIsOpened(true);
                                leftNodeids.add((String)this.getNodeProperty("id", node));
                            }
                            continue;
                        }
                        leftNodeids.add(nodeId);
                    }
                    this.setLeftTreeColor(leftNodeids, "blue", false);
                    break;
                }
                case "btnupdate": {
                    selectNode.forEach(e -> leftNodeids.add(e.getId()));
                    this.setLeftTreeColor(leftNodeids, "blue", false);
                    break;
                }
                default: {
                    TreeNode rightTree = this.getCacheRightRoot();
                    Set<String> rightNumbers = this.getNodeNumber(rightTree);
                    TreeNode cacheLeftRoot = this.getCacheLeftRoot();
                    LinkedList<TreeNode> allchilden = new LinkedList<TreeNode>();
                    this.getAllChilden(cacheLeftRoot, allchilden, true, 20);
                    for (TreeNode treeNode : allchilden) {
                        if (rightNumbers.contains(this.getNodeProperty("number", treeNode))) continue;
                        leftNodeids.add((String)this.getNodeProperty("id", treeNode));
                    }
                    this.setLeftTreeColor(leftNodeids, "", false);
                }
            }
        }
    }

    private void setLeftTreeColor(List<String> actSelectIds, String strColor, boolean doAll) {
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (doAll) {
            ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
            this.getAllChilden(leftRoot, allchilden, true, 20);
            for (TreeNode treeNode : allchilden) {
                treeNode.setColor(strColor);
            }
            treeleft.updateNodes(allchilden);
            treeleft.expand(leftRoot.getId());
        } else {
            ArrayList<TreeNode> colorNodeLst = new ArrayList<TreeNode>();
            for (String id : actSelectIds) {
                TreeNode selectNode;
                if (id == null || (selectNode = leftRoot.getTreeNode(id, 20)) == null) continue;
                selectNode.setColor(strColor);
                colorNodeLst.add(selectNode);
            }
            treeleft.updateNodes(colorNodeLst);
        }
        treeleft.expand(leftRoot.getId());
        this.cacheLeftRoot(leftRoot);
    }

    private void getLeftNodesByRightTree(TreeNode rightRoot, List<String> allNodeIds) {
        boolean newNode = this.isNewNode(rightRoot);
        if (newNode) {
            this.getLeftNodes(rightRoot, allNodeIds);
        } else {
            List children = rightRoot.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    this.getLeftNodesByRightTree(child, allNodeIds);
                }
            }
        }
    }

    private void getLeftNodes(TreeNode rightRoot, List<String> allNodeids) {
        String id = this.getNodeProperty("id", rightRoot).toString();
        allNodeids.add(id);
        List children = rightRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.getLeftNodes(child, allNodeids);
            }
        }
    }

    protected void cacheLeftIds(Map<String, String> LeftNodeIds) {
        this.getPageCache().put(leftTreeNodeIds, SerializationUtils.toJsonString(LeftNodeIds));
    }

    protected Map<String, String> getCacheLeftIds() {
        return (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(leftTreeNodeIds), Map.class);
    }

    private Map<String, String> addLeftCache(final Map<String, String> cache, TreeNode leftRoot) {
        if (leftRoot == null) {
            return cache;
        }
        String number = (String)this.getNodeProperty("number", leftRoot);
        cache.put(number, leftRoot.getId());
        if (leftRoot.getChildren() != null) {
            leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    EntitySysImport.this.addLeftCache(cache, t);
                }
            });
        }
        return cache;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        if ("combofield".equals(prop)) {
            this.initLeftTree();
        }
        this.displayColor();
    }

    @Override
    protected void setMemberOtherInfo(DynamicObject member) {
        member.set("aggoprt", (Object)"1");
        member.set("isinnerorg", (Object)"0");
    }

    @Override
    protected void setBatchMemberOtherInfo(List<DynamicObject> members) {
        String orgCode;
        if (members == null || members.isEmpty()) {
            return;
        }
        HashMap<String, DynamicObject> memberMap = new HashMap<String, DynamicObject>(members.size());
        for (DynamicObject _member : members) {
            memberMap.put(_member.getString("number"), _member);
        }
        HashMap<String, String> codesMap = new HashMap<String, String>(members.size());
        QFilter filter = new QFilter("number", "in", memberMap.keySet());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBosOrg", (String)"bos_org", (String)"number, uniformsocialcreditcode", (QFilter[])new QFilter[]{filter}, null);){
            if (ds != null) {
                for (Row row : ds) {
                    String number = row.getString("number");
                    orgCode = row.getString("uniformsocialcreditcode");
                    if (orgCode != null && (orgCode = orgCode.trim()).length() > 9) {
                        orgCode = orgCode.trim().substring(orgCode.length() - 9);
                    }
                    codesMap.put(number, orgCode);
                }
            }
        }
        Long userId = UserUtils.getUserId();
        Long defaultCurrencyId = ((DynamicObject)this.getModel().getValue("defaultcurrency")).getLong("id");
        Date time = TimeServiceHelper.now();
        Date _effdate = (Date)this.getModel().getValue("datefield");
        for (Map.Entry entry : memberMap.entrySet()) {
            DynamicObject _member = (DynamicObject)entry.getValue();
            orgCode = (String)codesMap.get(entry.getKey());
            if (orgCode != null) {
                _member.set("orgcode", (Object)orgCode);
            }
            _member.set("currency", (Object)defaultCurrencyId);
            DynamicObjectCollection nameRecords = _member.getDynamicObjectCollection("namechangerds");
            DynamicObject nameRecord = nameRecords.addNew();
            nameRecord.set("namerds", _member.get("name"));
            nameRecord.set("simplenamerds", _member.get("simplename"));
            nameRecord.set("nameeffdate", (Object)_effdate);
            nameRecord.set("namemodifier", (Object)userId);
            nameRecord.set("namemodifytime", (Object)time);
            nameRecord.set("seq", (Object)1);
        }
    }

    @Override
    protected String getTreeModelType() {
        return SysDimensionEnum.Entity.getMemberTreemodel();
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btngo".equals(key) || "btnallgo".equals(key) || "btnupgrade".equals(key)) {
            TreeView treeright = (TreeView)this.getView().getControl("treeright");
            String rightFocusId = treeright.getTreeState().getFocusNodeId();
            if (rightFocusId == null) {
                return;
            }
            TreeNode rightRoot = this.getCacheRightRoot();
            TreeNode rightFocusNode = null;
            rightFocusNode = "btnallgo".equals(key) ? rightRoot : rightRoot.getTreeNode(rightFocusId, 20);
            try {
                if (!this.checkDimPermission("NEW", (String)((Map)rightRoot.getData()).get("number"), (String)((Map)rightFocusNode.getData()).get("number"), this.getDimManagerInfo().getViewId())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u60a8\u6ca1\u6709%1\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"EntitySysImport_1", (String)"epm-eb-formplugin", (Object[])new Object[]{rightFocusNode.getText()}));
                }
            }
            catch (Throwable e) {
                CommonServiceHelper.dealException((IFormView)this.getView(), (String)"beforeClick", (Throwable)e);
            }
        }
    }

    @Override
    protected void saveData() {
        if (this.beforeSave()) {
            return;
        }
        super.saveData();
    }

    private boolean beforeSave() {
        if (this.getModel().getValue("defaultcurrency") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9ed8\u8ba4\u5e01\u79cd\u3002", (String)"EntitySysImport_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        TreeNode rightRoot = this.getCacheNode("righttree");
        boolean isAddNew = false;
        if (rightRoot.getChildren() != null) {
            List childs = rightRoot.getChildren();
            for (int i = 0; i < childs.size() && !(isAddNew = this.isAddNew((TreeNode)childs.get(i), rightRoot, i)); ++i) {
            }
        }
        if (isAddNew) {
            Date effDate = (Date)this.getModel().getValue("datefield");
            String messge = EntityVersioningUtil.checkModelDate((long)Long.parseLong(this.getPageCache().get("model")), (Date)effDate);
            if (!StringUtils.isEmpty((String)messge)) {
                this.getView().showErrorNotification(messge);
                this.getPageCache().put("isNew", null);
                return true;
            }
        }
        return false;
    }

    private boolean isAddNew(TreeNode rightRoot, TreeNode parent, int seq) {
        Map rightRootMap = (Map)rightRoot.getData();
        if ("1".equals(rightRootMap.get("isNew"))) {
            return true;
        }
        List childs = rightRoot.getChildren();
        if (childs != null) {
            for (int i = 0; i < childs.size(); ++i) {
                if (!this.isAddNew((TreeNode)childs.get(i), rightRoot, i)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void afterSave(List<DynamicObject> toSaveMembers, Set<String> parentIds) {
        super.afterSave(toSaveMembers, parentIds);
    }
}

