/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.formplugin.importplugin.ImportContext;

public class ImportTemplateHeader {
    public static final String CACHE_TEMPLATE_DATA = "templateDataCache";
    private final ImportContext context;

    public static ImportTemplateHeader get(ImportContext context) {
        return new ImportTemplateHeader(context);
    }

    protected ImportContext getContext() {
        return this.context;
    }

    public ImportTemplateHeader(ImportContext context) {
        this.context = context;
    }

    public ImportEntity getTemplateData(boolean isImport) {
        ImportEntity importEntity;
        if (this.getContext().getPageCache() != null) {
            String cache = this.getContext().getPageCache().get(CACHE_TEMPLATE_DATA);
            if (cache != null) {
                importEntity = (ImportEntity)SerializationUtils.deSerializeFromBase64((String)cache);
            } else {
                importEntity = this.createTemplateData(isImport);
                this.getContext().getPageCache().put(CACHE_TEMPLATE_DATA, SerializationUtils.serializeToBase64((Object)importEntity));
            }
        } else {
            importEntity = this.createTemplateData(isImport);
        }
        return importEntity;
    }

    protected ImportEntity createTemplateData(boolean isImport) {
        ImportEntity importData = new ImportEntity();
        if (isImport) {
            importData.setTemplateName(ResManager.loadResFormat((String)"%1\u5bfc\u5165\u6a21\u677f", (String)"UserDefineMemberImport_14", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getContext().getDimName()}));
            importData.setSheetTitle(ResManager.loadResFormat((String)"%1\u2014\u5bfc\u5165", (String)"UserDefineMemberImport_15", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getContext().getDimName()}));
        } else {
            importData.setTemplateName(ResManager.loadResFormat((String)"%1\u5bfc\u51fa\u6570\u636e", (String)"MemberExport_0", (String)"epm-eb-cube", (Object[])new Object[]{this.getContext().getDimName()}));
            importData.setSheetTitle(ResManager.loadResFormat((String)"%1\u2014\u5bfc\u51fa", (String)"MemberExport_1", (String)"epm-eb-cube", (Object[])new Object[]{this.getContext().getDimName()}));
        }
        importData.setSheetHeaderMap(this.getHeaderData());
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\u66f4\u65b0\u65f6\uff0c\u7f16\u7801\u4e0d\u53ef\u66f4\u6539\u3002", (String)"DimMemImportBasePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.dealDimImportEntity(importData);
        return importData;
    }

    protected void dealDimImportEntity(ImportEntity importData) {
        Map comboBoxList = importData.getComboBoxList();
        HashMap headerMap = Maps.newHashMapWithExpectedSize((int)importData.getSheetHeaderMap().size());
        for (Map.Entry _header : importData.getSheetHeaderMap().entrySet()) {
            headerMap.put(((Header)_header.getValue()).getColumnNum(), Integer.parseInt((String)_header.getKey()));
        }
        Integer index = (Integer)headerMap.get("aggoprt");
        if (index != null) {
            comboBoxList.put(index, new String[]{ResManager.loadKDString((String)"\u52a0(+)", (String)"AccountMemberImport_41", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51cf(-)", (String)"AccountMemberImport_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ffd\u7565(~)", (String)"AccountMemberImport_43", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        }
        if ((index = (Integer)headerMap.get("accounttype")) != null) {
            comboBoxList.put(index, new String[]{ResManager.loadKDString((String)"\u8d22\u52a1\u7c7b", (String)"AccountMemberImport_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edf\u8ba1\u7c7b", (String)"AccountMemberImport_21", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        }
        if ((index = (Integer)headerMap.get("drcrdirect")) != null) {
            comboBoxList.put(index, new String[]{ResManager.loadKDString((String)"\u65e0", (String)"AccountMemberImport_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u501f", (String)"AccountMemberImport_23", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d37", (String)"AccountMemberImport_24", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        }
    }

    protected Map<String, Header> getHeaderData() {
        Map<String, Header> headerData;
        switch (this.getContext().getDimNumber()) {
            case "Entity": {
                headerData = this.getEntityHeaderData();
                break;
            }
            case "Account": {
                headerData = this.getAccountHeaderData();
                break;
            }
            case "ChangeType": {
                headerData = this.getChangeTypeHeaderData();
                break;
            }
            default: {
                headerData = "epm_userdefinedmembertree".equals(this.getContext().getMemberModel()) ? this.getUserDefinedHeaderData() : this.getDefaultHeaderData();
            }
        }
        return headerData;
    }

    protected Map<String, Header> getDefaultHeaderData() {
        LinkedHashMap<String, Header> headerData = new LinkedHashMap<String, Header>();
        int size = 0;
        if (this.getContext().getModelCache().getModelobj().isModelByEB()) {
            headerData.put(String.valueOf(size++), new Header("number", ResManager.loadKDString((String)"*\u7f16\u7801", (String)"DimMemImportBasePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemImportBasePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        } else {
            headerData.put(String.valueOf(size++), new Header("number", ResManager.loadKDString((String)"*\u5185\u7801", (String)"DimMemImportBasePlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemImportBasePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            headerData.put(String.valueOf(size++), new Header("shownumber", ResManager.loadKDString((String)"*\u7f16\u7801", (String)"DimMemImportBasePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemImportBasePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        headerData.put(String.valueOf(size++), new Header("name", ResManager.loadKDString((String)"*\u540d\u79f0", (String)"DimMemImportBasePlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemImportBasePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        if (this.getContext().getModelCache().getModelobj().isModelByEB()) {
            headerData.put(String.valueOf(size), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801", (String)"DimMemImportBasePlugin_371", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        } else {
            headerData.put(String.valueOf(size), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"DimMemImportBasePlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        }
        return headerData;
    }

    protected String getParentNumberTips() {
        String tips = StringUtils.equals((String)"InternalCompany", (String)this.getContext().getDimNumber()) ? ResManager.loadKDString((String)"\u586b\u5199ICEntity\u6216ICOEntity", (String)"DimMemImportBasePlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\u3002\u9ed8\u8ba4\u6839\u8282\u70b9\u3002", (String)"DimMemImportBasePlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        return tips;
    }

    protected Map<String, Header> getEntityHeaderData() {
        Map<String, Header> headerData = this.getDefaultHeaderData();
        int size = headerData.size() - 1;
        headerData.put(String.valueOf(size++), new Header("simpleName", ResManager.loadKDString((String)"\u7b80\u79f0", (String)"EntityMemberImport_25", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"EntityMemberImport_27", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        if (this.getContext().getModelCache().getModelobj().isModelByEB()) {
            headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801", (String)"DimMemImportBasePlugin_371", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        } else {
            headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"EntityMemberImport_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        }
        headerData.put(String.valueOf(size++), new Header("aggoprt", ResManager.loadKDString((String)"\u805a\u5408\u7b97\u6cd5", (String)"EntityMemberExport_13", (String)"epm-eb-cube", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u52a0(+)", (String)"EntityMemberExport_14", (String)"epm-eb-cube", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("owner.name", ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u540d\u79f0", (String)"EntityMemberImport_36", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u5f55\u9879\uff0c\u586b\u5199\u5bf9\u5e94\u7ec4\u7ec7\u7684\u9884\u7b97\u7ba1\u7406\u8d1f\u8d23\u4eba", (String)"EntityMemberImport_40", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("owner.number", ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u5de5\u53f7", (String)"EntityMemberImport_37", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u5f55\u9879\uff0c\u586b\u5199\u5bf9\u5e94\u7ec4\u7ec7\u7684\u9884\u7b97\u7ba1\u7406\u8d1f\u8d23\u4eba", (String)"EntityMemberImport_40", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("executor.name", ResManager.loadKDString((String)"\u6267\u884c\u4eba\u540d\u79f0", (String)"EntityMemberImport_38", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u5f55\u9879\uff0c\u586b\u5199\u5bf9\u5e94\u7ec4\u7ec7\u7684\u9884\u7b97\u7f16\u5236\u4efb\u52a1\u9ed8\u8ba4\u6267\u884c\u4eba", (String)"EntityMemberImport_41", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("executor.number", ResManager.loadKDString((String)"\u6267\u884c\u4eba\u5de5\u53f7", (String)"EntityMemberImport_39", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u5f55\u9879\uff0c\u586b\u5199\u5bf9\u5e94\u7ec4\u7ec7\u7684\u9884\u7b97\u7f16\u5236\u4efb\u52a1\u9ed8\u8ba4\u6267\u884c\u4eba", (String)"EntityMemberImport_41", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        List customProperties = this.getContext().getPropCache().getPropertiesByDim(this.getContext().getDimNumber());
        for (CustomProperty _property : customProperties) {
            headerData.put(String.valueOf(size++), new Header(_property.getName(), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u76f8\u5e94\u7684\u5c5e\u6027\u503c\u7f16\u7801\u3002", (String)"EntityMemberImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        String comment = ResManager.loadKDString((String)"\u4ec5\u4f9b\u67e5\u770b\uff0c\u5bfc\u5165\u65e0\u6548\u3002", (String)"EntityMemberExport_19", (String)"epm-eb-cube", (Object[])new Object[0]);
        headerData.put(String.valueOf(size++), new Header("creator.name", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"EntityMemberExport_15", (String)"epm-eb-cube", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"EntityMemberExport_16", (String)"epm-eb-cube", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("modifier.name", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u4eba", (String)"EntityMemberExport_17", (String)"epm-eb-cube", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("modifytime", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4", (String)"EntityMemberExport_18", (String)"epm-eb-cube", (Object[])new Object[0]), comment));
        if (Dimension.hasDisable((String)this.getContext().getMemberModel())) {
            headerData.put(String.valueOf(size++), new Header("disable", ResManager.loadKDString((String)"\u542f\u7528\u7981\u7528", (String)"DimMemberExportBasePlugin_14", (String)"epm-eb-cube", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ec5\u4f9b\u67e5\u770b\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u4f7f\u7528\u7cfb\u7edf\u7684\u6279\u91cf\u542f\u7528\u7981\u7528\u529f\u80fd\uff0c\u5bfc\u5165\u65e0\u6548", (String)"DimMemberExportBasePlugin_15", (String)"epm-eb-cube", (Object[])new Object[0])));
        }
        headerData.put(String.valueOf(size), new Header("description", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"EntityMemberExport_20", (String)"epm-eb-cube", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u4e3a\u65e0\u3002", (String)"EntityMemberImport_18", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        return headerData;
    }

    protected Map<String, Header> getAccountHeaderData() {
        Map<String, Header> headerData = this.getDefaultHeaderData();
        int size = headerData.size() - 1;
        headerData.put(String.valueOf(size++), new Header("simpleName", ResManager.loadKDString((String)"\u7b80\u79f0", (String)"AccountMemberImport_65", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"AccountMemberImport_67", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        if (this.getContext().getModelCache().getModelobj().isModelByEB()) {
            headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801", (String)"DimMemImportBasePlugin_371", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        } else {
            headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"AccountMemberImport_66", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        }
        headerData.put(String.valueOf(size++), new Header("aggoprt", ResManager.loadKDString((String)"\u805a\u5408\u7b97\u6cd5", (String)"AccountMemberImport_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4+", (String)"AccountMemberImport_30", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("accounttype", ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b", (String)"AccountMemberImport_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u8d22\u52a1\u7c7b", (String)"AccountMemberImport_32", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("drcrdirect", ResManager.loadKDString((String)"\u501f\u8d37", (String)"AccountMemberImport_33", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u65e0", (String)"AccountMemberImport_34", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        if (!this.getContext().getModelCache().getModelobj().isModelByEB()) {
            headerData.put(String.valueOf(size++), new Header(ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"AccountMemberImport_37", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u968f\u79d1\u76ee\u7c7b\u578b\u53d8\u5316\uff0c\u5982\u82e5\u5bfc\u5165\u591a\u4e2a\u5ea6\u91cf\uff0c\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u9694\u5f00", (String)"AccountMemberImport_38", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        List customProperties = this.getContext().getPropCache().getPropertiesByDim(this.getContext().getDimNumber());
        for (CustomProperty _property : customProperties) {
            headerData.put(String.valueOf(size++), new Header(_property.getName(), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u76f8\u5e94\u7684\u5c5e\u6027\u503c\u7f16\u7801\u3002", (String)"EntityMemberImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        return headerData;
    }

    protected Map<String, Header> getChangeTypeHeaderData() {
        Map<String, Header> headerData = this.getDefaultHeaderData();
        int size = headerData.size();
        headerData.put(String.valueOf(size), new Header("aggoprt", ResManager.loadKDString((String)"\u805a\u5408\u7b97\u6cd5", (String)"ChangeTypeMemberImport_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4+", (String)"ChangeTypeMemberImport_13", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        return headerData;
    }

    protected Map<String, Header> getUserDefinedHeaderData() {
        Map<String, Header> headerData = this.getDefaultHeaderData();
        int size = headerData.size() - 1;
        headerData.put(String.valueOf(size++), new Header("simpleName", ResManager.loadKDString((String)"\u7b80\u79f0", (String)"UserDefineMemberImport_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"UserDefineMemberImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        if (this.getContext().getModelCache().getModelobj().isModelByEB()) {
            headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801", (String)"DimMemImportBasePlugin_371", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        } else {
            headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"AccountMemberImport_66", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        }
        headerData.put(String.valueOf(size++), new Header("aggoprt", ResManager.loadKDString((String)"\u805a\u5408\u7b97\u6cd5", (String)"EntityMemberExport_13", (String)"epm-eb-cube", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u52a0(+)", (String)"EntityMemberExport_14", (String)"epm-eb-cube", (Object[])new Object[0])));
        List customProperties = this.getContext().getPropCache().getPropertiesByDim(this.getContext().getDimNumber());
        for (CustomProperty _property : customProperties) {
            headerData.put(String.valueOf(size++), new Header(_property.getName(), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u76f8\u5e94\u7684\u5c5e\u6027\u503c\u7f16\u7801\u3002", (String)"EntityMemberImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        return headerData;
    }
}

