/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.importplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.ActionFactory;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.importplugin.DimSysImportBasePlugin;
import kd.epm.eb.model.utils.EntityVersioningUtil;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MemberImportPlugin
extends DimSysImportBasePlugin {
    public static final String leftTreeNodeIds = "leftTreeNodeIds";
    private Log log = LogFactory.getLog(MemberImportPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long modelId = (Long)formShowParameter.getCustomParam("model");
            this.getPageCache().put("model", String.valueOf(modelId));
            Long dimmenId = (Long)this.getView().getFormShowParameter().getCustomParam("dimensionId");
            Dimension dimension = this.getIModelCacheHelper().getDimension(dimmenId);
            Label label = (Label)this.getControl("labelap1");
            label.setText(ResManager.loadResFormat((String)"\u6210\u5458\u5bfc\u5165-%1", (String)"MemberImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
            this.initTargetList(dimmenId, true);
            this.initSourceList(dimmenId, true);
            super.afterCreateNewData(e);
            Date modelDate = EntityVersioningUtil.getModelBeginDate((Object)modelId);
            if (modelDate != null) {
                this.getModel().setValue("datefield", (Object)modelDate);
                DateEdit de = (DateEdit)this.getControl("datefield");
                de.setMinDate(modelDate);
            }
            QFilter qfModel = new QFilter("model", "=", (Object)modelId);
            QFilter qfNumber = new QFilter("number", "=", (Object)"CNY");
            DynamicObject currency = QueryServiceHelper.queryOne((String)"epm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{qfNumber, qfModel});
            if (currency != null) {
                this.getModel().setValue("defaultcurrency", (Object)currency.getString("id"));
            }
            HashMap<String, String> leftNodeIds = new HashMap<String, String>();
            this.cacheLeftIds(leftNodeIds);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
            qFilters.add(qfModel);
            qFilters.add(new QFilter("number", "!=", (Object)"Currency"));
            BasedataEdit defaultcurrency = (BasedataEdit)this.getControl("defaultcurrency");
            defaultcurrency.setQFilters(qFilters);
            this.displayColor();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    protected TreeNode getLeftRoot() {
        QFBuilder qfBuilder;
        TreeNode root = null;
        DataSet dataSet = null;
        this.initTargetList(this.getDimId(), false);
        LinkedHashMap<String, TreeNode> allNode = new LinkedHashMap<String, TreeNode>(16);
        String viewType = (String)this.getModel().getValue("combofield");
        if (StringUtils.equals((String)viewType, (String)"01") || StringUtils.equals((String)viewType, (String)"15")) {
            qfBuilder = new QFBuilder("view.treetype", "=", (Object)viewType);
            qfBuilder.add("org.enable", "=", (Object)"1");
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
            freezeFilter.or("isfreeze", "is null", null);
            qfBuilder.add(freezeFilter);
            String selectFields = "org.id as id,org.name as name,org.number as number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level";
            dataSet = QueryServiceHelper.queryDataSet((String)"EntitySysImport.getOrgTreeDataEB", (String)"bos_adminorg_structure", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"org.number,level");
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    allNode.put(row.getString("id"), this.createTreeNode(row, "left"));
                    if (!"0".equals(row.getString("parentid"))) continue;
                    root = (TreeNode)allNode.get(row.getString("id"));
                }
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap141", "flexpanelap1411"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap14111"});
        } else if (StringUtils.equals((String)viewType, (String)"02")) {
            String selectFields = "id,name,number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level";
            qfBuilder = new QFBuilder("enable", "=", (Object)"1");
            dataSet = QueryServiceHelper.queryDataSet((String)"EntitySysImport.BOS_COSTCENTER", (String)"bos_costcenter", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"number,level");
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    allNode.put(row.getString("id"), this.createTreeNode(row, "left"));
                    if (!"0".equals(row.getString("parentid"))) continue;
                    root = (TreeNode)allNode.get(row.getString("id"));
                }
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap141", "flexpanelap1411"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap14111"});
        } else {
            qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId()).and("dimension", "=", (Object)this.getDimId()).and("enable", "=", (Object)"1");
            if (StringUtils.isNotEmpty((String)viewType)) {
                long viewId = Long.parseLong(viewType);
                qfBuilder.add(new QFilter("view", "=", (Object)viewId));
                qfBuilder.add(new QFilter("showself", "=", (Object)true));
                String selectFields = "id,name,number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level,view,shownumber,memberid,aggoprt,disable,refview";
                dataSet = QueryServiceHelper.queryDataSet((String)"EntitySysImport.getViewMember", (String)"eb_viewmember", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"level, dseq, number");
                if (dataSet != null) {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        allNode.put(row.getString("id"), this.createTreeNode(row, "left", true));
                        if (!"0".equals(row.getString("parentid"))) continue;
                        root = (TreeNode)allNode.get(row.getString("id"));
                    }
                }
            }
            if (ViewGroupManager.getInstance().isCrossGroup(this.getSourceViewId(), this.getTargetViewId())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap14111"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap14111"});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap141", "flexpanelap1411"});
        }
        root = root == null ? new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntitySysImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0])) : root;
        Label label = (Label)this.getControl("count");
        label.setText(String.valueOf(allNode.size()));
        this.buildTree(allNode, root);
        root.setParentid("");
        this.cacheNode("wholeLeftTree", root);
        TreeNode copyRoot = this.copyNode(root);
        this.copyOneLevel(copyRoot, root.getChildren());
        return copyRoot;
    }

    protected TreeNode createTreeNode(Row row, String target, Boolean isView) {
        TreeNode node = new TreeNode();
        node.setId(row.getString("id"));
        node.setText(row.getString("number") + " " + row.getString("name"));
        node.setParentid(row.getString("parentid"));
        node.setLongNumber(row.getString("longnumber"));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", row.getString("id"));
        data.put("name", row.getString("name"));
        data.put("number", row.getString("number"));
        data.put("parentid", row.getString("parentid"));
        data.put("isleaf", row.getBoolean("isleaf"));
        data.put("longnumber", row.getString("longnumber"));
        data.put("dseq", row.getInteger("dseq"));
        data.put("level", row.getInteger("level"));
        if (isView.booleanValue()) {
            data.put("view", row.getLong("view"));
            data.put("shownumber", row.getString("shownumber"));
            data.put("memberid", row.getLong("memberid"));
            data.put("aggoprt", row.getString("aggoprt"));
            data.put("disable", row.getBoolean("disable"));
            data.put("refview", row.getLong("refview"));
        }
        if ("left".equals(target)) {
            data.put("isNew", "1");
        } else {
            data.put("isNew", "0");
        }
        node.setData(data);
        return node;
    }

    private void displayColor() {
        Set<String> rightNumbers = this.getRightNodeNumber();
        TreeNode cacheLeftRoot = this.getCacheLeftRoot();
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(cacheLeftRoot, list, true, 20);
        list.removeIf(l -> !rightNumbers.contains((this.getNodeProperty("number", (TreeNode)l) == null ? "" : (String)this.getNodeProperty("number", (TreeNode)l)).toUpperCase()));
        this.setLeftTreeNoteColor("btngo", "blue", list, false);
    }

    @Override
    protected void setLeftTreeNoteColor(String key, String strColor, List<TreeNode> selectNode, boolean doAll) {
        if (doAll) {
            this.setLeftTreeColor(null, strColor, true);
        } else {
            LinkedList<String> leftNodeids = new LinkedList<String>();
            switch (key) {
                case "btnback": {
                    for (TreeNode treeNode : selectNode) {
                        this.getLeftNodesByRightTree(treeNode, leftNodeids);
                    }
                    this.setLeftTreeColor(leftNodeids, "", false);
                    break;
                }
                case "btngo": {
                    TreeNode leftRoot = new TreeNode();
                    Boolean allchildren = true;
                    String viewType = (String)this.getModel().getValue("combofield");
                    if (this.isFromSystem(viewType)) {
                        allchildren = (Boolean)this.getModel().getValue("allchildren");
                    }
                    if (allchildren.booleanValue()) {
                        leftRoot = this.getCacheNode("wholeLeftTree");
                    }
                    if (ViewGroupManager.getInstance().isCrossGroup(this.getSourceViewId(), this.getTargetViewId())) {
                        for (int i = 0; i < selectNode.size(); ++i) {
                            String nodeId = selectNode.get(i).getId();
                            TreeNode treeNode = leftRoot.getTreeNode(nodeId, 20);
                            Boolean isChildren = (Boolean)this.getModel().getValue("children");
                            Integer childLevel = Integer.valueOf((String)this.getModel().getValue("childlevel"));
                            if (isChildren.booleanValue() && childLevel > 0) {
                                ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
                                this.getAllChilden(treeNode, allchilden, true, childLevel);
                                for (TreeNode node : allchilden) {
                                    node.setIsOpened(true);
                                    leftNodeids.add((String)this.getNodeProperty("id", node));
                                }
                                continue;
                            }
                            leftNodeids.add(nodeId);
                        }
                    } else {
                        for (int i = 0; i < selectNode.size(); ++i) {
                            String nodeId = selectNode.get(i).getId();
                            if (allchildren.booleanValue()) {
                                TreeNode treeNode = leftRoot.getTreeNode(nodeId, 20);
                                ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
                                this.getAllChilden(treeNode, allchilden, true, 20);
                                for (TreeNode node : allchilden) {
                                    node.setIsOpened(true);
                                    leftNodeids.add((String)this.getNodeProperty("id", node));
                                }
                                continue;
                            }
                            leftNodeids.add(nodeId);
                        }
                    }
                    this.setLeftTreeColor(leftNodeids, "blue", false);
                    break;
                }
                case "btnupdate": {
                    selectNode.forEach(e -> leftNodeids.add(e.getId()));
                    this.setLeftTreeColor(leftNodeids, "blue", false);
                    break;
                }
                default: {
                    TreeNode rightTree = this.getCacheRightRoot();
                    Set<String> rightNumbers = this.getNodeNumber(rightTree);
                    TreeNode cacheLeftRoot = this.getCacheLeftRoot();
                    LinkedList<TreeNode> allchilden = new LinkedList<TreeNode>();
                    this.getAllChilden(cacheLeftRoot, allchilden, true, 20);
                    for (TreeNode treeNode : allchilden) {
                        if (rightNumbers.contains(this.getNodeProperty("number", treeNode))) continue;
                        leftNodeids.add((String)this.getNodeProperty("id", treeNode));
                    }
                    this.setLeftTreeColor(leftNodeids, "", false);
                }
            }
        }
    }

    private void setLeftTreeColor(List<String> actSelectIds, String strColor, boolean doAll) {
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (doAll) {
            ArrayList<TreeNode> allchilden = new ArrayList<TreeNode>(16);
            this.getAllChilden(leftRoot, allchilden, true, 20);
            for (TreeNode treeNode : allchilden) {
                treeNode.setColor(strColor);
            }
            treeleft.updateNodes(allchilden);
            treeleft.expand(leftRoot.getId());
        } else {
            ArrayList<TreeNode> colorNodeLst = new ArrayList<TreeNode>();
            for (String id : actSelectIds) {
                TreeNode selectNode;
                if (id == null || (selectNode = leftRoot.getTreeNode(id, 20)) == null) continue;
                selectNode.setColor(strColor);
                colorNodeLst.add(selectNode);
            }
            treeleft.updateNodes(colorNodeLst);
        }
        treeleft.expand(leftRoot.getId());
        this.cacheLeftRoot(leftRoot);
    }

    private void getLeftNodesByRightTree(TreeNode rightRoot, List<String> allNodeIds) {
        boolean newNode = this.isNewNode(rightRoot);
        if (newNode) {
            this.getLeftNodes(rightRoot, allNodeIds);
        } else {
            List children = rightRoot.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    this.getLeftNodesByRightTree(child, allNodeIds);
                }
            }
        }
    }

    private void getLeftNodes(TreeNode rightRoot, List<String> allNodeids) {
        String id = this.getNodeProperty("id", rightRoot).toString();
        allNodeids.add(id);
        List children = rightRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.getLeftNodes(child, allNodeids);
            }
        }
    }

    protected void cacheLeftIds(Map<String, String> LeftNodeIds) {
        this.getPageCache().put(leftTreeNodeIds, SerializationUtils.toJsonString(LeftNodeIds));
    }

    protected Map<String, String> getCacheLeftIds() {
        return (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(leftTreeNodeIds), Map.class);
    }

    private Map<String, String> addLeftCache(final Map<String, String> cache, TreeNode leftRoot) {
        if (leftRoot == null) {
            return cache;
        }
        String number = (String)this.getNodeProperty("number", leftRoot);
        cache.put(number, leftRoot.getId());
        if (leftRoot.getChildren() != null) {
            leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    MemberImportPlugin.this.addLeftCache(cache, t);
                }
            });
        }
        return cache;
    }

    private void initTargetList(Long dimensionId, Boolean select) {
        DynamicObjectCollection views = ViewGroupManager.getInstance().getViewByDimensionId(this.getModelId().longValue(), dimensionId.longValue());
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        Long currentViewId = (Long)this.getView().getFormShowParameter().getCustomParam("viewId");
        for (DynamicObject view : views) {
            String viewType = (String)this.getModel().getValue("combofield");
            if (StringUtils.isNotEmpty((String)viewType) && StringUtils.notEquals((String)viewType, (String)"01") && StringUtils.notEquals((String)viewType, (String)"15") && StringUtils.notEquals((String)viewType, (String)"02")) {
                Long viewId = Long.parseLong(viewType);
                if (view.getLong("id") == viewId.longValue()) continue;
            }
            ComboItem comboItem = new ComboItem(new LocaleString(view.getString("name")), view.getLong("id") + "");
            comboItemList.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("target");
        comboEdit.setComboItems(comboItemList);
        Long targetViewId = this.getTargetViewId();
        if (targetViewId == null) {
            if (currentViewId != null && currentViewId != 0L) {
                this.getModel().setValue("target", (Object)currentViewId);
            } else if (comboItemList.size() > 0 && select.booleanValue()) {
                this.getModel().setValue("target", (Object)((ComboItem)comboItemList.get(0)).getValue());
            }
        } else {
            this.getModel().setValue("target", (Object)targetViewId);
        }
    }

    private void initSourceList(Long dimensionId, Boolean select) {
        DynamicObjectCollection views = ViewGroupManager.getInstance().getViewByDimensionId(this.getModelId().longValue(), dimensionId.longValue());
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        Dimension dimension = this.getIModelCacheHelper().getDimension(dimensionId);
        for (DynamicObject view : views) {
            String viewType = (String)this.getModel().getValue("target");
            if (StringUtils.isNotEmpty((String)viewType)) {
                Long viewId = Long.parseLong(viewType);
                if (view.getLong("id") == viewId.longValue()) continue;
            }
            ComboItem comboItem = new ComboItem(new LocaleString(view.getString("name")), view.getLong("id") + "");
            comboItemList.add(comboItem);
        }
        if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"MemberImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0])), "01"));
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"MemberImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])), "15"));
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"MemberImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0])), "02"));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        comboEdit.setComboItems(comboItemList);
        if (comboItemList.size() > 0 && select.booleanValue()) {
            this.getModel().setValue("combofield", (Object)((ComboItem)comboItemList.get(0)).getValue());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            String prop = e.getProperty().getName();
            if ("combofield".equals(prop)) {
                this.initLeftTree();
                this.initRightTree();
            } else if ("target".equals(prop)) {
                if (ViewGroupManager.getInstance().isCrossGroup(this.getSourceViewId(), this.getTargetViewId())) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap14111"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap14111"});
                }
                this.initRightTree();
            }
            this.displayColor();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    protected TreeNode getRigthRoot() {
        TreeNode root = null;
        DataSet dataSet = null;
        this.initSourceList(this.getDimId(), false);
        LinkedHashMap<String, TreeNode> allNode = new LinkedHashMap<String, TreeNode>(16);
        String viewType = (String)this.getModel().getValue("target");
        if (StringUtils.isEmpty((String)viewType)) {
            return new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntitySysImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder("enable", "=", (Object)"1");
        long viewId = Long.parseLong(viewType);
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("dimension", "=", (Object)this.getDimId()));
        qfBuilder.add(new QFilter("view", "=", (Object)viewId));
        qfBuilder.add(new QFilter("showself", "=", (Object)true));
        String selectFields = "id,name,number,parent.id as parentid,isleaf,longnumber ,level as dseq ,level";
        dataSet = QueryServiceHelper.queryDataSet((String)"EntitySysImport.getViewMember", (String)"eb_viewmember", (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"level, dseq, number");
        if (dataSet != null) {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                allNode.put(row.getString("id"), this.createTreeNode(row, "right"));
                if (!"0".equals(row.getString("parentid"))) continue;
                root = (TreeNode)allNode.get(row.getString("id"));
            }
        }
        root = root == null ? new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntitySysImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0])) : root;
        Label label = (Label)this.getControl("count1");
        label.setText(String.valueOf(allNode.size()));
        this.buildTree(allNode, root);
        root.setParentid("");
        this.cacheNode("wholeRightTree", root);
        return root;
    }

    @Override
    public void click(EventObject evt) {
        try {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "btngo": {
                    this.selectGoRight();
                    break;
                }
                case "btnback": {
                    this.selectGoLeft();
                    break;
                }
                case "btnallgo": {
                    this.allgo();
                    this.setLeftTreeNoteColor(key, "blue", null, true);
                    break;
                }
                case "btnallback": {
                    this.allback();
                    this.setLeftTreeNoteColor(key, "", null, false);
                    break;
                }
                case "btnupdate": {
                    String target = (String)this.getModel().getValue("target");
                    this.updateNode(IDUtils.toLong((Object)target));
                    break;
                }
                case "allchoose": {
                    this.clickAllChoose();
                    break;
                }
                case "allclear": {
                    this.clickAllClear();
                    break;
                }
                case "allclear1": {
                    this.clickRightClear();
                    break;
                }
                case "allexpand": {
                    this.spreadAll();
                    break;
                }
                case "allshrink": {
                    this.collapseAll();
                    break;
                }
                case "baritemconfirm": {
                    this.saveData();
                    break;
                }
                case "baritemcancel": {
                    this.getView().close();
                    break;
                }
                case "searchbefore1": 
                case "searchnext1": {
                    this.searchUpAndDown(key);
                    break;
                }
                case "searchbefore": 
                case "searchnext": {
                    this.searchUpAndDownRight(key);
                    break;
                }
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    protected void selectGoLeft() {
        TreeView treeright = (TreeView)this.getView().getControl("treeright");
        List selectedNodeIds = treeright.getTreeState().getSelectedNodeId();
        if (selectedNodeIds == null || selectedNodeIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        ArrayList<TreeNode> selNoteLs = new ArrayList<TreeNode>(16);
        for (String rightFocusId : selectedNodeIds) {
            if (rightFocusId.equals(rightRoot.getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"DimSysImportBasePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
            if (rightFocusNode == null) continue;
            boolean hasSkip = false;
            Set<String> rightNumbers = this.getNodeNumber(rightRoot);
            if (this.isNewNode(rightFocusNode)) {
                TreeNode parentNode = rightRoot.getTreeNode(rightFocusNode.getParentid(), 20);
                if (this.isNewNode(parentNode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u5f15\u7528\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\uff0c\u5982\u679c\u9700\u64a4\u56de\u4e0b\u7ea7\u5f15\u7528\u6210\u5458\uff0c\u8bf7\u64a4\u9500\u5b8c\u6574\u7684\u5f15\u7528\u6811\u3002", (String)"MemberImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                TreeNode noCurrNode = rightRoot.deleteChildNode(rightFocusId);
                this.removeRightCache(rightNumbers, rightFocusNode);
                treeright.deleteNode(rightFocusId);
                if (noCurrNode.getChildren() == null || noCurrNode.getChildren().size() == 0) {
                    noCurrNode.setChildren(null);
                }
                treeright.updateNode(noCurrNode);
                treeright.expand(noCurrNode.getId());
                treeright.focusNode(noCurrNode);
            } else {
                this.nodeBack(rightRoot, rightFocusNode, rightNumbers, false);
                treeright.updateNode(rightFocusNode);
                treeright.expand(rightFocusId);
                treeright.focusNode(rightFocusNode);
                hasSkip = true;
            }
            selNoteLs.add(rightFocusNode);
            if (!hasSkip) continue;
            this.getView().showTipNotification(this.getBackSlipMsg());
        }
        this.setLeftTreeNoteColor("btnback", "", selNoteLs, false);
        this.cacheRightRoot(rightRoot);
    }

    @Override
    protected void selectGoRight() {
        TreeNode leftRoot;
        Map datas;
        ArrayList<String> illegalSelectIds;
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        List<String> selectIds = this.getCanMoveIds(treeleft, illegalSelectIds = new ArrayList<String>());
        if (selectIds.size() == 0 && illegalSelectIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeright = (TreeView)this.getView().getControl("treeright");
        List selectedNodeIds = treeright.getTreeState().getSelectedNodeId();
        if (selectedNodeIds == null || selectedNodeIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u53f3\u6811\u8282\u70b9\u3002", (String)"DimSysImportBasePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String rightFocusId = (String)selectedNodeIds.get(0);
        Boolean allchildren = (Boolean)this.getModel().getValue("allchildren");
        if (allchildren.booleanValue() && illegalSelectIds.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u8282\u70b9\u6216\u4e0b\u7ea7\u5305\u542b\u4e0d\u5408\u6cd5\u7f16\u7801\u3002", (String)"DimSysImportBasePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        if (!ViewGroupManager.getInstance().isOrganization(this.getSourceViewId()) && !ViewGroupManager.getInstance().isCrossGroup(this.getSourceViewId(), this.getTargetViewId()) && "1".equals((datas = (Map)rightFocusNode.getData()).get("isNew"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6539\u53d8\u5f15\u7528\u6210\u5458\u7684\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"MemberValidator_4", (String)"epm-eb-olap", (Object[])new Object[0]));
            return;
        }
        if (!this.isNewNode(rightFocusNode)) {
            String permInfo = this.checkEbMemAddNewPerm(rightFocusNode);
            if (!permInfo.equals("")) {
                this.getView().showTipNotification(permInfo);
                return;
            }
            DimManagerInfo dimInfo = ActionFactory.buildDim(this.getModelId(), this.getDimId(), Long.parseLong(rightFocusId), this.getTargetViewId());
            IAction action = ActionFactory.getAction(DimMembActionEnum.ADDCHILD, this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
            action.beforeAction();
            if (!action.isBeforeAction()) {
                return;
            }
        }
        if ((leftRoot = this.getWholeTree("wholeLeftTree")) == null) {
            return;
        }
        if (illegalSelectIds.size() == 1 && ((String)illegalSelectIds.get(0)).equals("root") && CollectionUtils.isEmpty((Collection)leftRoot.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u6210\u5458\u3002", (String)"MemberImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<String> rightNumbers = this.getNodeNumber(rightRoot);
        boolean hasSkip = false;
        boolean hasType = false;
        ArrayList<TreeNode> actSelectNodes = new ArrayList<TreeNode>(10);
        ArrayList<String> existNumbers = new ArrayList<String>(10);
        for (String id : selectIds) {
            TreeNode selectNode = leftRoot.getTreeNode(id, 20);
            Map datas2 = (Map)selectNode.getData();
            if (!hasType && "1".equals(datas2.get("isType"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u662f\u5206\u7c7b\u8282\u70b9\uff0c\u624d\u80fd\u632a\u5230\u53f3\u8fb9\u3002", (String)"MemberImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!hasType && !selectIds.contains(selectNode.getParentid())) {
                Object level = ((Map)selectNode.getData()).get("level");
                if ("1".equals(String.valueOf(level))) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6240\u9009\u62e9\u7684\u6839\u8282\u70b9%1\u4e0d\u652f\u6301\u9009\u62e9\u81f3\u53f3\u4fa7\u3002", (String)"MemberImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{selectNode.getText()}));
                    return;
                }
                selectNode.setParentid("0");
                actSelectNodes.add(selectNode);
            }
            if (hasSkip || !this.isNodeExists(rightNumbers, selectNode)) continue;
            String number = (String)this.getNodeProperty("number", selectNode);
            existNumbers.add(number);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53f3\u4fa7\u5185\u7801:%1\u5df2\u5b58\u5728\u3002", (String)"MemberImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
            return;
        }
        if (allchildren.booleanValue() && existNumbers.size() > 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6240\u9009\u62e9\u7684\u8282\u70b9\u6216\u4e0b\u7ea7\u5305\u542b\u91cd\u590d\u7f16\u7801%1\u3002", (String)"DimSysImportBasePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", existNumbers)}));
            return;
        }
        this.wholeOne(treeright, rightRoot, rightFocusNode, rightNumbers, actSelectNodes, false);
        this.cacheRightRoot(rightRoot);
        treeright.focusNode(rightFocusNode);
        treeleft.uncheckNodes(selectIds);
        this.setLeftTreeNoteColor("btngo", "blue", actSelectNodes, false);
        if (illegalSelectIds.size() != 0) {
            hasSkip = true;
        }
        if (hasSkip) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u60c5\u51b5\u7684\u5de6\u4fa7\u5185\u5bb9\u5c06\u4e0d\u4f1a\u88ab\u9009\u62e9\u5230\u53f3\u4fa7\uff1a", (String)"DimSysImportBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getNoticeMessage(), MessageTypes.Default);
        } else if (hasType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u5206\u7c7b\u65e0\u6cd5\u9009\u62e9\u81f3\u53f3\u4fa7\u3002", (String)"DimSysImportBasePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected List<TreeNode> singleGo(TreeNode rightFocusNode, TreeNode actSelectNode, Set<String> numbers, boolean isAllgo, TreeNode rightRoot) {
        TreeNode copy;
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        List selectIds = treeleft.getTreeState().getSelectedNodeId();
        if (ViewGroupManager.getInstance().isCrossGroup(this.getSourceViewId(), this.getTargetViewId())) {
            Boolean children = (Boolean)this.getModel().getValue("children");
            Integer childLevel = Integer.valueOf((String)this.getModel().getValue("childlevel"));
            copy = this.cloneNode(actSelectNode, selectIds, isAllgo, children, childLevel);
        } else {
            copy = this.cloneNode(actSelectNode, selectIds, isAllgo);
        }
        return this.totalMerge(rightFocusNode, numbers, copy, rightRoot);
    }

    @Override
    protected void slipTreeNode(Set<String> numbers, TreeNode node) {
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            ArrayList newChilds = Lists.newArrayListWithExpectedSize((int)children.size());
            for (int i = 0; i < children.size(); ++i) {
                TreeNode child = (TreeNode)children.get(i);
                if (this.isNodeExists(numbers, child) || !this.codeRule((String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)child))) {
                    String number = (String)TreeNodeUtils.getNodeProperties((String)"number", (TreeNode)child);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u53f3\u4fa7\u7f16\u7801:[%1]\u5df2\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"MemberImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                }
                newChilds.add(child);
                this.slipTreeNode(numbers, child);
            }
            if (CollectionUtils.isNotEmpty((Collection)newChilds)) {
                node.setChildren((List)newChilds);
            } else {
                node.setChildren(null);
            }
        }
    }

    private TreeNode cloneNode(TreeNode actSelectNode, List<String> selectIds, boolean isAllGo, Boolean isChildren, Integer childLevel) {
        TreeNode copy = new TreeNode();
        copy.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        copy.setParentid(actSelectNode.getParentid());
        Object data = actSelectNode.getData();
        Map sourceData = (Map)data;
        HashMap<String, String> copyData = new HashMap<String, String>();
        copyData.putAll(sourceData);
        copyData.put("isSystem", "false");
        copy.setData(copyData);
        copy.setText(actSelectNode.getText());
        copy.setColor("#5E80EB");
        List children = actSelectNode.getChildren();
        if (children != null && isChildren.booleanValue() && childLevel > 0) {
            Integer n = childLevel;
            childLevel = childLevel - 1;
            Integer n2 = childLevel;
            for (TreeNode child : children) {
                copy.addChild(this.cloneNode(child, selectIds, isAllGo, true, childLevel));
            }
        }
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(copy, list, true, 20);
        for (TreeNode treeNode : list) {
            treeNode.setColor("#5E80EB");
        }
        return copy;
    }

    @Override
    protected TreeNode cloneNode(TreeNode actSelectNode, List<String> selectIds, boolean isAllGo) {
        TreeNode copy = new TreeNode();
        copy.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        copy.setParentid(actSelectNode.getParentid());
        Object data = actSelectNode.getData();
        Map sourceData = (Map)data;
        HashMap<String, Object> copyData = new HashMap<String, Object>();
        copyData.putAll(sourceData);
        String viewType = (String)this.getModel().getValue("combofield");
        Boolean allchildren = true;
        if (this.isFromSystem(viewType)) {
            allchildren = (Boolean)this.getModel().getValue("allchildren");
            Object datefield = this.getModel().getValue("datefield");
            if (datefield == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u6548\u65e5\u671f", (String)"MemberImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            copyData.put("startTime", datefield);
            DynamicObject defaultCurrency = (DynamicObject)this.getModel().getValue("defaultcurrency");
            if (defaultCurrency == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9ed8\u8ba4\u5e01\u79cd", (String)"MemberImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            copyData.put("defaultCurrency", defaultCurrency.getLong("id"));
            copyData.put("isSystem", "true");
        } else {
            copyData.put("isSystem", "false");
        }
        copy.setData(copyData);
        copy.setText(actSelectNode.getText());
        copy.setColor("#5E80EB");
        List children = actSelectNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (!selectIds.contains(child.getId()) && !isAllGo && !allchildren.booleanValue()) continue;
                copy.addChild(this.cloneNode(child, selectIds, isAllGo));
            }
        }
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        this.getAllChilden(copy, list, true, 20);
        for (TreeNode treeNode : list) {
            treeNode.setColor("#5E80EB");
        }
        return copy;
    }

    private String getTargetViewNumber() {
        String target = (String)this.getModel().getValue("target");
        if (StringUtils.isNotEmpty((String)target)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(target), (String)"eb_dimensionview");
            return dynamicObject.getString("number");
        }
        return "";
    }

    private boolean isFromSystem(String viewType) {
        return StringUtils.equals((String)viewType, (String)"01") || StringUtils.equals((String)viewType, (String)"15") || StringUtils.equals((String)viewType, (String)"02");
    }

    @Override
    public String checkEbMemAddNewPerm(TreeNode currentRightNode) {
        try {
            DimManagerInfo dimInfo = ActionFactory.buildDim(this.getModelId(), this.getDimId(), Long.parseLong(currentRightNode.getId()), this.getTargetViewId());
            IAction action = ActionFactory.getMemberPermAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo, "btn_sysimport", DimMembActionEnum.ADDCHILD);
            action.beforeAction();
            return action.getResult();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private Long getTargetViewId() {
        String target = (String)this.getModel().getValue("target");
        if (StringUtils.isEmpty((String)target)) {
            return null;
        }
        return Long.parseLong(target);
    }

    private String getSourceViewId() {
        return (String)this.getModel().getValue("combofield");
    }

    @Override
    protected void setMemberOtherInfo(DynamicObject member) {
        member.set("aggoprt", (Object)"1");
        member.set("isinnerorg", (Object)"0");
    }

    @Override
    protected void setBatchMemberOtherInfo(List<DynamicObject> members) {
        String orgCode;
        if (members == null || members.isEmpty()) {
            return;
        }
        HashMap<String, DynamicObject> memberMap = new HashMap<String, DynamicObject>(members.size());
        for (DynamicObject _member : members) {
            memberMap.put(_member.getString("number"), _member);
        }
        HashMap<String, String> codesMap = new HashMap<String, String>(members.size());
        QFilter filter = new QFilter("number", "in", memberMap.keySet());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBosOrg", (String)"bos_org", (String)"number, uniformsocialcreditcode", (QFilter[])new QFilter[]{filter}, null);){
            if (ds != null) {
                for (Row row : ds) {
                    String number = row.getString("number");
                    orgCode = row.getString("uniformsocialcreditcode");
                    if (orgCode != null && (orgCode = orgCode.trim()).length() > 9) {
                        orgCode = orgCode.trim().substring(orgCode.length() - 9);
                    }
                    codesMap.put(number, orgCode);
                }
            }
        }
        Long userId = UserUtils.getUserId();
        Long defaultCurrencyId = ((DynamicObject)this.getModel().getValue("defaultcurrency")).getLong("id");
        Date time = TimeServiceHelper.now();
        Date _effdate = (Date)this.getModel().getValue("datefield");
        for (Map.Entry entry : memberMap.entrySet()) {
            DynamicObject _member = (DynamicObject)entry.getValue();
            orgCode = (String)codesMap.get(entry.getKey());
            if (orgCode != null) {
                _member.set("orgcode", (Object)orgCode);
            }
            _member.set("currency", (Object)defaultCurrencyId);
            DynamicObjectCollection nameRecords = _member.getDynamicObjectCollection("namechangerds");
            DynamicObject nameRecord = nameRecords.addNew();
            nameRecord.set("namerds", _member.get("name"));
            nameRecord.set("simplenamerds", _member.get("simplename"));
            nameRecord.set("nameeffdate", (Object)_effdate);
            nameRecord.set("namemodifier", (Object)userId);
            nameRecord.set("namemodifytime", (Object)time);
            nameRecord.set("seq", (Object)1);
        }
    }

    @Override
    protected String getTreeModelType() {
        return SysDimensionEnum.Entity.getMemberTreemodel();
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        block9: {
            try {
                super.beforeClick(evt);
                String key = ((Control)evt.getSource()).getKey();
                if (!"btngo".equals(key) && !"btnallgo".equals(key) && !"btnupgrade".equals(key)) break block9;
                TreeView treeright = (TreeView)this.getView().getControl("treeright");
                String rightFocusId = treeright.getTreeState().getFocusNodeId();
                if (rightFocusId == null) {
                    return;
                }
                String target = (String)this.getModel().getValue("target");
                if (StringUtils.isEmpty((String)target)) {
                    return;
                }
                long targetViewId = IDUtils.toLong((Object)target);
                TreeNode rightRoot = this.getCacheRightRoot();
                TreeNode rightFocusNode = null;
                rightFocusNode = "btnallgo".equals(key) ? rightRoot : rightRoot.getTreeNode(rightFocusId, 20);
                if (rightRoot == null || rightRoot.getData() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53f3\u6811\u6210\u5458\u4e3a\u7a7a", (String)"MemberImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Dimension dimension = this.getIModelCacheHelper().getDimension(this.getDimId());
                try {
                    if (!this.checkDimPermission("NEW", dimension.getNumber(), (String)((Map)rightFocusNode.getData()).get("number"), targetViewId)) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u60a8\u6ca1\u6709%1\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"EntitySysImport_1", (String)"epm-eb-formplugin", (Object[])new Object[]{rightFocusNode.getText()}));
                    }
                }
                catch (Throwable e) {
                    CommonServiceHelper.dealException((IFormView)this.getView(), (String)"beforeClick", (Throwable)e);
                }
            }
            catch (KDBizException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
            }
        }
    }

    @Override
    protected void saveData() {
        try {
            String target = (String)this.getModel().getValue("target");
            if (StringUtils.isEmpty((String)target)) {
                return;
            }
            long viewId = Long.parseLong(target);
            Dimension dimension = this.getIModelCacheHelper().getDimension(this.getDimId());
            TreeNode rightRoot = this.getCacheRightRoot();
            LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
            LinkedHashMap<String, TreeNode> rightNewNodes = new LinkedHashMap<String, TreeNode>();
            LinkedHashSet<String> addNewNumbers = new LinkedHashSet<String>();
            this.getRightNewNodes(rightRoot, rightNewNodes, parentIds, addNewNumbers);
            List<DimensionViewMember> dimensionViewMembers = this.transDimensionViewMember(rightNewNodes, rightRoot, Long.parseLong(target));
            ViewMemberManager.getInstance().insertViewAndDimMember(this.getModelId().longValue(), dimension.getNumber(), Long.valueOf(viewId), dimensionViewMembers);
            HashSet memberNames = Sets.newHashSetWithExpectedSize((int)dimensionViewMembers.size());
            for (DimensionViewMember _member : dimensionViewMembers) {
                memberNames.add(_member.getNumber() + '-' + _member.getName());
            }
            String opMember = StringUtils.join((Collection)memberNames, (char)',');
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u7cfb\u7edf\u5bfc\u5165", "DimSysImportBasePlugin_21", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7ef4\u5ea6-%1$s\uff0c\u65b0\u589e\u6216\u4fee\u6539\u66f4\u65b0\u7ef4\u5ea6\u6210\u5458(%2$s)\u603b\u5171%3$s\u6761\u6570\u636e\u3002", "DimSysImportBasePlugin_22", "epm-eb-formplugin");
            this.writeLog(null, "copy", opName, opDescription, new String[]{dimension.getName(), opMember, String.valueOf(dimensionViewMembers.size())});
            this.getView().close();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    protected List<DimensionViewMember> transDimensionViewMember(Map<String, TreeNode> rightNewNodes, TreeNode rightRoot, Long viewId) {
        try {
            String treeModelType = this.getTreeModelType();
            long modelId = this.getModelId();
            Long dimId = this.getDimId();
            boolean hasSimpleName = Dimension.hasSimpleName((String)treeModelType);
            ArrayList<DimensionViewMember> dimensionViewMembers = new ArrayList<DimensionViewMember>(rightNewNodes.size());
            Dimension dimension = this.getIModelCacheHelper().getDimension(dimId);
            String dimensionNumber = dimension.getNumber();
            boolean hasEntity = "Entity".equals(dimensionNumber);
            DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            user.set("id", (Object)UserUtils.getUserId());
            List memberids = rightNewNodes.values().stream().map(x -> (Long)((Map)x.getData()).get("memberid")).filter(x -> x != null).collect(Collectors.toList());
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])memberids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dimension.getMemberModel()));
            Map<Long, DynamicObject> idMap = Arrays.stream(load).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
            Set targetViews = ViewGroupManager.getInstance().getViewsByViewId(viewId.longValue());
            List parentIds = rightNewNodes.values().stream().map(x -> IDUtils.toLong(((Map)x.getData()).get("parentid"))).filter(x -> x != null).collect(Collectors.toList());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid", (QFilter[])new QFilter("id", "in", parentIds).toArray());
            Map<Object, Object> parentIdToMember = CollectionUtils.isEmpty((Collection)dynamicObjects) ? new HashMap(16) : dynamicObjects.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getLong("memberid")));
            HashMap<String, String> longNumberMap = new HashMap<String, String>(16);
            for (TreeNode node : rightNewNodes.values()) {
                String currLongNumber;
                DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)treeModelType);
                DimensionViewMember dimensionViewMember = new DimensionViewMember();
                dimensionViewMember.setStatus("C");
                dimensionViewMember.setEnable("1");
                TextProp tpNameProp = (TextProp)member.getDynamicObjectType().getProperty("Name");
                int iNameLen = tpNameProp.getMaxLenth();
                TextProp tpNumberProp = (TextProp)member.getDynamicObjectType().getProperty("number");
                int iNumberLen = tpNumberProp.getMaxLenth();
                String number = (String)this.getNodeProperty("number", node);
                String name = (String)this.getNodeProperty("name", node);
                String substringNumber = org.apache.commons.lang3.StringUtils.substring((String)number, (int)0, (int)iNumberLen);
                String substringName = org.apache.commons.lang3.StringUtils.substring((String)name, (int)0, (int)iNameLen);
                Map data = (Map)node.getData();
                dimensionViewMember.setViewMemberId(Long.valueOf(Long.parseLong(node.getId())));
                String isSystem = (String)data.get("isSystem");
                dimensionViewMember.setName(substringName);
                if ("true".equals(isSystem)) {
                    dimensionViewMember.setNumber(substringNumber);
                    dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.ADD.getIndex());
                    dimensionViewMember.setMembersource(MemberSourceEnum.SYSTEM_IMPORT.getIndex());
                    dimensionViewMember.setAggoprt("1");
                    dimensionViewMember.setMemberId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
                    dimensionViewMember.setShowNumber(data.getOrDefault("shownumber", dimensionViewMember.getNumber()));
                    if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                        dimensionViewMember.setCurrency((Long)data.get("defaultCurrency"));
                    }
                } else {
                    dimensionViewMember.setMemberId((Long)data.get("memberid"));
                    if (!targetViews.contains((Long)data.get("view"))) {
                        dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.OUTER_REF.getIndex());
                    } else {
                        dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.INNER_REF.getIndex());
                    }
                    Boolean disable = MapUtils.getBoolean((Map)data, (Object)"disable", (Boolean)false);
                    dimensionViewMember.setDisable(disable != false ? "1" : "0");
                    dimensionViewMember.setNumber(substringNumber);
                    DynamicObject dynamicObject = idMap.get(dimensionViewMember.getMemberId());
                    if (dynamicObject != null) {
                        ILocaleString name1;
                        if (hasSimpleName) {
                            dimensionViewMember.setSimpleName(dynamicObject.getLocaleString("simplename"));
                        }
                        if (hasEntity) {
                            dimensionViewMember.setCurrency(Long.valueOf(dynamicObject.getLong("currency.id")));
                        }
                        if ((name1 = dynamicObject.getLocaleString("name")) != null) {
                            dimensionViewMember.setName(name1);
                        }
                    }
                    dimensionViewMember.setAggoprt((String)data.get("aggoprt"));
                    Long refview = (Long)data.get("refview");
                    if (refview == null || refview == 0L) {
                        dimensionViewMember.setRefview((Long)data.get("view"));
                    } else {
                        dimensionViewMember.setRefview(refview);
                    }
                    dimensionViewMember.setShowNumber(data.getOrDefault("shownumber", dimensionViewMember.getNumber()));
                    dimensionViewMember.setMembersource(MemberSourceEnum.SYSTEM_IMPORT.getIndex());
                }
                dimensionViewMember.setLevel((Integer)this.getNodeProperty("level", node));
                String parentLongNumber = (String)longNumberMap.get(node.getParentid());
                TreeNode parentNode = rightRoot.getTreeNode(node.getParentid());
                if (StringUtils.isEmpty((String)parentLongNumber)) {
                    if (parentNode == null) {
                        currLongNumber = (String)data.get("longnumber");
                        dimensionViewMember.setLongNumber(currLongNumber);
                    } else {
                        Map parentMap = (Map)parentNode.getData();
                        parentLongNumber = (String)parentMap.get("longnumber");
                        currLongNumber = (StringUtils.isEmpty((String)parentLongNumber) ? dimensionNumber : parentLongNumber) + "!" + dimensionViewMember.getNumber();
                        dimensionViewMember.setLongNumber(currLongNumber);
                    }
                } else {
                    currLongNumber = (StringUtils.isEmpty((String)parentLongNumber) ? dimensionNumber : parentLongNumber) + "!" + dimensionViewMember.getNumber();
                    dimensionViewMember.setLongNumber(currLongNumber);
                }
                longNumberMap.put(node.getId(), currLongNumber);
                parentIdToMember.put(dimensionViewMember.getViewMemberId(), dimensionViewMember.getMemberId());
                dimensionViewMember.setParentId(parentNode == null ? IDUtils.toLong((Object)node.getParentid()) : IDUtils.toLong((Object)parentNode.getId()));
                Long memberParentId = (Long)parentIdToMember.get(dimensionViewMember.getParentId());
                dimensionViewMember.setParentMemberId(memberParentId == null ? dimensionViewMember.getMemberId() : memberParentId);
                dimensionViewMember.setModel(Long.valueOf(modelId));
                dimensionViewMember.setDimension(dimId);
                dimensionViewMember.setDseq((Integer)this.getNodeProperty("dseq", node));
                dimensionViewMember.setIsLeaf(node.getChildren() == null || node.getChildren().isEmpty());
                dimensionViewMembers.add(dimensionViewMember);
            }
            if (!dimensionViewMembers.isEmpty()) {
                this.replaceId(dimensionViewMembers);
            }
            return dimensionViewMembers;
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    @Override
    protected void afterSave(List<DynamicObject> toSaveMembers, Set<String> parentIds) {
        try {
            super.afterSave(toSaveMembers, parentIds);
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }
}

