/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.license;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.UserUtils;

public interface EBLicense {
    public static final Set<String> KEYS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"eb_versioncontrollist", "eb_dimmaterulelist", "eb_dimmembermappinglist", "eb_billlist", "eb_bgcontrolporcesslist", "eb_parametercontrolset", "eb_centralized_lists", "eb_controldimlist", "eb_rulecontrollist", "eb_adddimmaterule"}));
    public static final Set<String> EBKEYS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"eb_adjustbilllist", "eb_adjpstbilllist", "eb_schemelist", "eb_sharedimensiondatalist", "eb_periodvariable", "eb_integration", "eb_integration_out", "eb_dim_membermap", "eb_offsetentry_addnew", "eb_templatelist_bg", "eb_dimensionmanagerlist", "eb_model_list", "eb_datalocklist", "eb_collectionconfiglist", "eb_collectionexecutelist", "eb_approvebill", "bgmd_datalocklist_nbg", "eb_examinelist_nbg", "eb_integrationlist_nbg", "eb_integrationoutlist", "eb_sharedimension_nbg", "bgm_adjustrule", "eb_adjustbill_nbg", "eb_adjpstbill_nbg", "eb_adjustbill", "eb_adjpstbill", "eb_ebdimmembermaplist", "bgm_adjustbill", "bgm_adjpstbill", "eb_executeanalyselist_nbg", "eb_versioncopyschemel_nbg", "eb_datavalidationlist_nbg", "eb_currencyconverlist_nbg", "eb_cryconvertlogshow_nbg", "eb_ebrptschemelist_nbg", "epm_dimensionmanager_nbg", "eb_modeltransfer_nbg", "eb_templatelist_nbg", "eb_bizrulegrouplist2_nbg", "epm_variablemanager_nbg", "eb_integrationmaplist_nbg", "eb_qinganalysisdslist_nbg", "bgm_rptpreparation", "eb_approvaltypelist_new", "eb_centralrela_setting", "bgc_controlwarnningscheme", "bgc_recipientmapping", "bgc_controlwarningrule", "bgmd_datalockcaselist_nbg", "eb_approvebill_manage", "eb_approvebill_newlist", "eb_integrationoutlist_nbg"}));
    public static final Set<String> BGMDKEYS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"eb_examinelist", "epm_model", "eb_integrationlist", "eb_integrationoutlist", "eb_integration_maplist", "eb_dim_membermaplist", "eb_sharedimension", "eb_bizrulegrouplist2", "eb_modeltransfer", "eb_taskhome", "eb_taskdecompose", "eb_examinelist", "eb_periodvariable", "eb_broadcaselist", "eb_offsetrule_list", "eb_currencyconvertlist", "eb_currencyconvertlogshow", "eb_templatelist", "eb_appscenariolist", "eb_businessmodellist", "eb_datasetlist", "epm_model", "epm_dimensionmanager", "eb_receiveparameterlist", "eb_rollbudget", "epm_variablemanager", "eb_datasetlist", "epm_model", "epm_dimensionmanager", "bgmd_datalocklist", "eb_analyserpttemplatelist", "eb_rptschemelist", "eb_decompose_scheme", "eb_qinganalysisds_list", "eb_applytemplatelist", "eb_bgapplyhome", "eb_fixedvaluelist", "eb_decomposescheme", "eb_bgdecomposelist", "eb_applyschedulequery", "eb_centralappplanlist", "eb_cenappbilllist", "eb_bgrejectbilllist", "eb_billrejectconfiglist", "eb_centralschemelist", "eb_approvaltypelist_new", "eb_centralrela_setting", "eb_task_transfer", "epm_mainsubmodel_list", "bgmd_datalockcaselist", "bgc_controlwarnningscheme", "bgc_recipientmapping", "bgc_controlwarningrule", "eb_approvaldimensionlist"}));
    public static final Set<String> BGMKEYS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"eb_taskmonitor_pandect", "eb_datauploadscheme", "eb_modelupload", "bgm_adjpstbilllist", "bgm_adjustbilllist", "eb_offsetentry", "eb_approvebill", "eb_executetask", "bgm_adjustrule", "bgm_adjustbill", "bgm_adjpstbill", "eb_reportquery_new", "eb_analysiscanvaslist", "bgm_rptpreparation", "eb_mydecompose_task", "eb_executeanalyselist", "eb_analysereportlist", "eb_versioncopyschemelist", "eb_datavalidationlist", "bgm_targetschemelist", "eb_approvebill_manage", "eb_approvebill_newlist"}));
    public static final Set<String> BGRPKEYS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"eb_executetask", "bgm_rptpreparation", "eb_approvebill", "bgm_adjustbill", "bgm_adjpstbill", "eb_executeanalyselist"}));

    default public LicenseCheckResult checkcharacter(String formId) {
        String productVersion;
        BigDecimal version;
        LicenseCheckResult re = null;
        if (KEYS.contains(formId) && (version = ConvertUtils.toDecimal((Object)(productVersion = LicenseServiceHelper.getProductVersion()))).compareTo(new BigDecimal("1.0")) > 0 && version.compareTo(new BigDecimal("4.0")) <= 0) {
            re = LicenseServiceHelper.checkPerformGroup((String)"PRO_BGC");
        }
        return re;
    }

    default public LicenseCheckResult checkLicense(String appId, String formId) {
        LicenseCheckResult re = null;
        Long userId = UserUtils.getUserId();
        if (EBKEYS.contains(formId) && "eb".equals(appId)) {
            re = LicenseServiceHelper.checkByAppAndBizObj((String)appId, (String)"eb_executeanalyze", (Long)userId);
        } else if (BGMDKEYS.contains(formId) && "bgmd".equals(appId)) {
            re = LicenseServiceHelper.checkByAppAndBizObj((String)appId, (String)"eb_reportqueryprocess", (Long)userId);
        } else if (BGMKEYS.contains(formId) && "bgm".equals(appId)) {
            re = LicenseServiceHelper.checkByAppAndBizObj((String)appId, (String)"eb_reportqueryprocess", (Long)userId);
        } else if (BGRPKEYS.contains(formId) && "bgrp".equals(appId)) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
            re = LicenseServiceHelper.checkByAppAndBizObj((String)appInfo.getId(), (String)"bgm_rptpreparation", (Long)userId);
        }
        return re;
    }

    default public void ebPreOpen(PreOpenFormEventArgs e) {
        FormShowParameter fs = (FormShowParameter)e.getSource();
        fs.setHasRight(true);
        String formId = fs.getFormId();
        if (formId.equals("bos_list")) {
            ListShowParameter source = (ListShowParameter)e.getSource();
            formId = source.getBillFormId();
        }
        String appId = e.getFormShowParameter().getAppId();
        LicenseCheckResult re = null;
        if ("eb".equals(appId) || "bgm".equals(appId) || "bgmd".equals(appId) || "bgrp".equals(appId)) {
            re = this.checkLicense(appId, formId);
        } else if ("bgc".equals(appId)) {
            re = this.checkcharacter(formId);
        }
        if (re != null && !re.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(re.getMsg());
            e.setCancelFormShowParameter(re.getCancelFormShowParameter());
        }
    }
}

