/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.logmanage;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.epbs.common.cache.model.Dimension;
import kd.epm.epbs.common.cache.model.Member;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.log.olap.AbstractOlapLogPlugin;

public class EpbsOlapLogNewPlugin
extends AbstractOlapLogPlugin {
    private static final Log log = LogFactory.getLog(EpbsOlapLogNewPlugin.class);
    private static final String DATASET = "dataset";
    private static final String MEM_VIEW_MAP = "memViewMap";
    private static final Set<String> singleDims = new HashSet<String>(Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.InternalCompany.getNumber()));
    private Map<String, String> entityMap = null;

    protected void initData() {
        super.initData();
        this.getModel().setValue(DATASET, (Object)this.getDataSetId());
    }

    protected boolean isCreateDimComponent() {
        return super.isCreateDimComponent() && this.getModel().getValue(DATASET) != null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener((BeforeF7SelectListener)this, new String[]{DATASET});
    }

    protected String getCubeNumber() {
        Model modelobj = this.getIModelCacheHelper().getModelobj();
        boolean modelByEB = modelobj.isModelByEB();
        if (modelByEB) {
            return ShrekOlapUtils.getCubeNumber((Model)modelobj);
        }
        if (modelobj.isModelByNewEB()) {
            List allDatasets = DatasetServiceHelper.getAllDatasets((Long)this.getModelId());
            return ShrekOlapUtils.getCubeNumber((Dataset)((Dataset)allDatasets.get(0)));
        }
        return ShrekOlapUtils.getCubeNumber((Dataset)Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)this.getDataSetId())));
    }

    protected Optional<String> validate() {
        Optional validate = super.validate();
        if (validate.isPresent()) {
            return validate;
        }
        if (this.getDataSetId() == 0L) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"OlapLogPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return validate;
    }

    protected String getOpTargetDesc(Map<String, String> opTargetList, String optarget) {
        if (StringUtils.isEmpty((String)optarget)) {
            return optarget;
        }
        if (null == this.entityMap) {
            this.entityMap = Maps.newLinkedHashMapWithExpectedSize((int)100);
        }
        String entityName = this.entityMap.computeIfAbsent(optarget, f -> {
            try {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)f);
                if (type != null) {
                    return LanguageUtils.getLocaleValue((ILocaleString)type.getDisplayName());
                }
            }
            catch (Exception ex) {
                log.warn("parse-metadata-error", (Throwable)ex);
            }
            return f;
        });
        return entityName;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        super.beforeF7Select(event);
        switch (name = event.getProperty().getName()) {
            case "dataset": {
                event.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
        }
    }

    public Long getDataSetId() {
        List allDatasets;
        Long dataset = IDUtils.toLong((Object)this.getFormShowParameter().getCustomParam(DATASET));
        if (dataset == 0L && this.getFormShowParameter().getCustomParam("firstvisitPage") != null && !(allDatasets = DatasetServiceHelper.getAllDatasets((Long)this.getModelId())).isEmpty()) {
            return ((Dataset)allDatasets.get(0)).getId();
        }
        return dataset;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        long datasetId2;
        long datasetId;
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(DATASET) && (datasetId = IDUtils.toLong2((Object)e.getChangeSet()[0].getNewValue()).longValue()) != (datasetId2 = IDUtils.toLong2((Object)e.getChangeSet()[0].getOldValue()).longValue())) {
            this.switchPage(m -> {
                m.put("KEY_MODEL_ID", IDUtils.toLong2((Object)this.getModel().getValue("model")));
                m.put(DATASET, datasetId);
            });
        }
    }

    protected Set<String> getSingleDims() {
        if (Objects.equals("1", PluginUtils.getCustomParams(this.getView(), "type"))) {
            return Sets.newHashSet();
        }
        return singleDims;
    }

    protected void openF7(String f7Key, String dimNumber) {
        List memberIdsFromCache;
        Object key1;
        Long modelId = this.getModelId();
        Long datasetId = this.getDataSetId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (String)dimNumber);
        f7Param.setReturnClassName(ListSelectedRow.class.getName());
        f7Param.setEnableView(true);
        if (!this.getSingleDims().contains(dimNumber)) {
            f7Param.setMultiSelect(true);
        }
        f7Param.setBusModelId(modelCache.getBusModelByDataSet(datasetId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            f7Param.setDatasetId(datasetId);
        }
        if ((key1 = this.getModel().getValue(f7Key)) != null && StringUtils.isNotEmpty((String)key1.toString()) && (memberIdsFromCache = this.getMemberIdsFromCache(f7Key)) != null) {
            f7Param.setSelectIds(new HashSet(memberIdsFromCache));
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, f7Key));
    }

    protected Member getMemberByNumber(String dimNumber, String memberNumber) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        kd.epm.eb.common.cache.impl.Dimension dimension = modelCache.getDimension(dimNumber);
        kd.epm.eb.common.cache.impl.Member member = dimension.getStructOfMember(memberNumber);
        if (member != null) {
            return new Member(member.getId(), member.getNumber(), member.getName());
        }
        return null;
    }

    public List<Dimension> getDimensionList() {
        if (IDUtils.isNotNull((long)this.getModelId())) {
            IModelCacheHelper modelCache = this.getIModelCacheHelper();
            Long dataSetId = this.getDataSetId();
            if (dataSetId != null && dataSetId > 0L) {
                List dimensionList = modelCache.getDimensionList(dataSetId);
                if (this.isNewEbForm()) {
                    return dimensionList.stream().filter(dimension -> !SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())).map(e -> new Dimension(e.getId(), e.getNumber(), e.getName(), e.getMemberModel(), e.isPreset())).collect(Collectors.toList());
                }
                return dimensionList.stream().map(e -> new Dimension(e.getId(), e.getNumber(), e.getName(), e.getMemberModel(), e.isPreset())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public void closedCallBack(ClosedCallBackEvent cbe) {
        super.closedCallBack(cbe);
        this.cacheMemViewMap(cbe);
    }

    private void cacheMemViewMap(ClosedCallBackEvent cbe) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)cbe.getReturnData();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Map dataMap = selectedRows.get(0).getDataMap();
        Long viewId = IDUtils.toLong(dataMap.get("viewid"));
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            Map<String, Long> memViewMap = this.getMemViewMap();
            memViewMap.put((String)dataMap.get("dimNumber"), viewId);
            this.getPageCache().put(MEM_VIEW_MAP, SerializationUtils.serializeToBase64(memViewMap));
        }
    }

    private Map<String, Long> getMemViewMap() {
        String cache = this.getPageCache().get(MEM_VIEW_MAP);
        if (cache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new HashMap<String, Long>(16);
    }

    protected Map<String, Set<String>> getMemberMap() {
        Long modelId = this.getModelId();
        Long dataSetId = this.getDataSetId();
        Map<String, Long> views = this.getMemViewMap();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap dimMemberMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap permissionMap = Maps.newHashMapWithExpectedSize((int)16);
        Long bizCtrlRangeId = modelCache.getBusModelByDataSet(dataSetId);
        List dimensionList = modelCache.getDimensionList(dataSetId);
        Map viewIds = modelCache.getViewsByDataSet(dataSetId);
        for (kd.epm.eb.common.cache.impl.Dimension dimension : dimensionList) {
            String dimNumber = dimension.getNumber();
            Set permMemberNumbers = DimMembPermHelper.getPermMembNumbers((String)dimNumber, (Long)modelId, (Long)bizCtrlRangeId, (Long)((Long)viewIds.get(dimNumber)), (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permissionMap.put(dimNumber, permMemberNumbers);
        }
        Map dimMapping = this.getDimMapping();
        for (Map.Entry entry : dimMapping.entrySet()) {
            String f7key = (String)entry.getKey();
            String dimNumber = (String)entry.getValue();
            List memberNumbersFromCache = this.getMemberNumbersFromCache(f7key);
            if (memberNumbersFromCache != null) {
                HashSet memberNumbers = new HashSet(memberNumbersFromCache);
                Long view = views.get(dimNumber);
                for (String memberNumber : memberNumbersFromCache) {
                    List detailChildren = modelCache.getDetailChildren(modelCache.getMember(dimNumber, view, memberNumber));
                    if (detailChildren == null) continue;
                    memberNumbers.addAll(detailChildren.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                }
                if (memberNumbers.isEmpty()) {
                    log.info("\u5f53\u524d\u7528\u6237(" + dimNumber + ")\u7ef4\u5ea6\u8fc7\u6ee4\u51fa\u6765\u65e0\u6210\u5458");
                    return dimMemberMap;
                }
                Set permMembNumbers = (Set)permissionMap.get(dimNumber);
                if (permMembNumbers == null) {
                    dimMemberMap.put(dimNumber, memberNumbers);
                    continue;
                }
                Sets.SetView hasPermSet = Sets.intersection(memberNumbers, (Set)permMembNumbers);
                dimMemberMap.put(dimNumber, hasPermSet);
                continue;
            }
            Set permissionMembers = (Set)permissionMap.get(dimNumber);
            if (permissionMembers == null) continue;
            dimMemberMap.put(dimNumber, permissionMembers);
        }
        return dimMemberMap;
    }

    protected IModelCacheHelper getIModelCacheHelper() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    protected boolean isNewEbForm() {
        boolean result = false;
        IFormView view = this.getView();
        if (view != null) {
            String formSign = this.getView().getPageCache().get("newEbForm");
            result = "true".equals(formSign);
        }
        return result;
    }
}

