/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.formplugin.mapping.DimMappingImportUtils;

public class DimMappingImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(DimMappingImportPlugin.class);
    private boolean errorFlag = false;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndownload"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                this.getModel().getValue("radiogroupfield");
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"DimMappingImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List file_urls = (List)SerializationUtils.deSerializeFromBase64((String)file_url);
                if (file_urls == null || file_urls.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"DimMappingImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                boolean hsError = false;
                StringBuilder errorMsg = new StringBuilder();
                HashSet<Long> bussModelIds = new HashSet<Long>(10);
                for (String s : file_urls) {
                    String[] reqParams = new URL(s).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = null;
                    try {
                        content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    }
                    catch (Exception e) {
                        log.error("import.error", (Throwable)e);
                        throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff0c\u53ef\u80fd\u6587\u4ef6\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"DimMappingImportPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (content == null) continue;
                    this.handleInputStream(content, errorMsg, bussModelIds);
                    if (!this.errorFlag) continue;
                    hsError = true;
                }
                if (!bussModelIds.isEmpty()) {
                    Map importConfigMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("importMessageMap")));
                    String _modelId = (String)importConfigMap.get("modelId");
                    Long modelId = null;
                    try {
                        modelId = Long.parseLong(_modelId);
                    }
                    catch (Exception e) {
                        log.error("import.error", (Throwable)e);
                        throw new KDBizException(e.getMessage());
                    }
                    for (Long bussModelId : bussModelIds) {
                        BgLockCacheServiceHelper.reloadCache((Long)modelId, (Long)bussModelId);
                    }
                }
                if (!hsError) {
                    this.getView().setReturnData((Object)"success");
                    this.getView().returnDataToParent((Object)"success");
                    this.getView().close();
                }
                if (errorMsg.length() <= 0) return;
                this.getView().showErrorNotification(errorMsg.toString());
                return;
            }
            catch (Exception e) {
                log.error("import.error", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        if (!"btndownload".equals(((Button)evt.getSource()).getKey())) return;
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("whiteset/whiteset_template.xlsx");
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ResManager.loadKDString((String)"\u63a7\u5236\u767d\u540d\u5355\u5bfc\u5165\u6a21\u677f.xlsx", (String)"DimMappingImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), inputStream, 10000);
            if (!StringUtils.isNotEmpty((String)url)) return;
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private void handleInputStream(TempFileCacheDownloadable.Content content, StringBuilder errorMsg, Set<Long> bussModelIds) {
        Map importMessageMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("importMessageMap")));
        boolean bl = this.errorFlag = !DimMappingImportUtils.get().importByStream(this.getView(), this.getModel(), content, importMessageMap, errorMsg, bussModelIds);
        if (!this.errorFlag) {
            BgMemMappingServiceHelper.clearCacheByMapping((Long)Long.valueOf((String)importMessageMap.get("primaryKeyValue")));
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.processUpload(evt, false);
    }

    public void afterRemove(UploadEvent evt) {
        this.processUpload(evt, true);
    }

    private void processUpload(UploadEvent evt, boolean isRemove) {
        String urles = "";
        List urls = null;
        urls = this.getPageCache().get("file_url") == null ? new ArrayList(16) : (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("file_url"));
        for (Object url : evt.getUrls()) {
            urles = (String)((Map)url).get("url");
            if (isRemove) {
                urls.remove(urles);
                continue;
            }
            urls.add(urles);
        }
        this.getPageCache().put("file_url", SerializationUtils.serializeToBase64(urls));
    }
}

