/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.DimMappingIsContainEnum;
import kd.epm.eb.common.enums.ImportEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.RangeMappingEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class DimMappingImportUtils {
    private static final Log log = LogFactory.getLog(DimMappingImportUtils.class);
    public static final String BUSINESS_BASE_DATA = "businessbasedata";
    public static final String BUSINESS_BASE_EXT_DATA = "businessbasedataext";
    public static final String USE_ASSIST_DATA = "useassistdata";
    public static final String USE_MORE_DATA = "usemorebussdata";
    public static final String USE_MORE_ASSIST_DATA = "usemoreassistdata";
    public static final String MODEL_ID = "modelId";
    public static final String BUS_MODEL_ID = "busModelId";
    public static final String VIEW_ID = "viewId";
    public static final String DIMENSION_NUMBER = "dimnumber";
    public static final String BOS_ORG = "bos_org";
    public static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    public static final String ADMIN_ORG = "bos_adminorg";
    public static final String ADMIN_ORG_STRUCTURE = "bos_adminorg_structure";
    public static final int INDEX_ID = 0;
    public static final int INDEX_NAME = 1;

    public static DimMappingImportUtils get() {
        return new DimMappingImportUtils();
    }

    public boolean importByStream(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull TempFileCacheDownloadable.Content content, @NotNull Map<String, String> importConfigMap, StringBuilder errorMsg, Set<Long> bussModelIds) {
        Workbook dataBook;
        XSSFWorkbook errorBook = new XSSFWorkbook();
        boolean result = false;
        this.dealImportConfigMap(importConfigMap);
        String _modelId = importConfigMap.get(MODEL_ID);
        String _busModelId = importConfigMap.get(BUS_MODEL_ID);
        String _viewId = importConfigMap.get(VIEW_ID);
        ItemImportConfig config = new ItemImportConfig();
        config.bizAppId = AppMetadataCache.getAppInfo((String)view.getFormShowParameter().getAppId()).getId();
        config.bizEntityNumber = dataModel.getDataEntityType().getName();
        config.modelId = StringUtils.isNotEmpty((String)_modelId) ? Long.parseLong(_modelId) : 0L;
        config.busModelId = StringUtils.isNotEmpty((String)_busModelId) ? Long.parseLong(_busModelId) : 0L;
        config.dimNumber = importConfigMap.get(DIMENSION_NUMBER);
        config.viewId = StringUtils.isNotEmpty((String)_viewId) ? Long.valueOf(Long.parseLong(_viewId)) : null;
        config.itemMappingId = Long.valueOf(importConfigMap.get("primaryKeyValue"));
        config.entityNumber = importConfigMap.get(BUSINESS_BASE_DATA);
        config.extEntityNumber = importConfigMap.get(BUSINESS_BASE_EXT_DATA);
        if ("gl_org".equals(config.extEntityNumber)) {
            config.extEntityNumber = BOS_ORG;
        }
        config.hasMoreData = this.hasUseMoreBizData(importConfigMap);
        config.hasAssistData = this.hasUseAssistData(importConfigMap);
        config.hasMoreAssistData = this.hasUseMoreAssistBizData(importConfigMap);
        DynamicObject itemMapping = this.getItemMapping(config.itemMappingId);
        if (itemMapping == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6%1\u5bfc\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingImportUtils_0", (String)"epm-eb-formplugin", (Object[])new Object[]{content.getFilename()}));
        }
        config.hasItemMapping = !itemMapping.getBoolean("isfreetype");
        try {
            dataBook = WorkbookFactory.create((InputStream)content.getInputStream());
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u4e0d\u662fExcel\u683c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{content.getFilename()}));
        }
        Sheet sheet = dataBook.getSheetAt(0);
        this.checkStyle(config, sheet, content.getFilename());
        POIUtils.POIConfig poiConfig = new POIUtils.POIConfig();
        poiConfig.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
        POIUtils.get().copyBook(dataBook, (Workbook)errorBook, poiConfig);
        Sheet errorSheet = errorBook.getSheetAt(0);
        config.errorBook = errorBook;
        config.errorSheet = errorSheet;
        boolean hasCover = this.hasCover(dataModel);
        List<ItemMapping> mappings = this.getImportData(config, sheet, itemMapping, hasCover);
        this.checkMember(config, mappings);
        if (this.checkErrorInfo(config)) {
            result = this.update(itemMapping, config, mappings, hasCover);
            if (SysDimensionEnum.Entity.getNumber().equals(config.dimNumber)) {
                bussModelIds.add(config.busModelId);
            }
        } else {
            POIUtils.downloadFile((IFormView)view, (Workbook)config.errorBook);
            if (errorMsg.length() > 0) {
                errorMsg.append("\r\n");
            }
            errorMsg.append(ResManager.loadResFormat((String)"\u6587\u4ef6%1\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u8be6\u60c5\u3002", (String)"TaskDispatchImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{content.getFilename()}));
        }
        return result;
    }

    private void dealImportRangeAndName(ItemImportConfig config, List<ItemMapping> mappings) {
        Map<String, Object[]> bizNumbers;
        String entityNumber;
        if (!config.hasItemMapping) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        LinkedHashSet bizIds = Sets.newLinkedHashSet();
        LinkedHashSet noLeafIds = Sets.newLinkedHashSet();
        for (Map.Entry<String, Map<String, Object[]>> entry : config.getBizNumberMap().entrySet()) {
            Throwable throwable;
            DataSet ds;
            entityNumber = DimMappingImportUtils.dealEntityNumber(entry.getKey());
            bizNumbers = entry.getValue();
            String fields = "id,number,name";
            builder.clear();
            builder.add(new QFilter("number", "in", bizNumbers.keySet()));
            if (BOS_ORG_STRUCTURE.equalsIgnoreCase(entityNumber) || ADMIN_ORG_STRUCTURE.equalsIgnoreCase(entityNumber)) {
                fields = "org.id,org.number,org.name";
                builder.clear();
                builder.add(new QFilter("org.number", "in", bizNumbers.keySet()));
                builder.add(new QFilter("view", "=", (Object)DimMappingImportUtils.getOrgView(entityNumber)));
                builder.add(new QFilter("isfreeze", "=", (Object)Character.valueOf('0')));
            }
            String pField = this.hasLevel(entityNumber);
            try {
                ds = QueryServiceHelper.queryDataSet((String)entityNumber, (String)entityNumber, (String)fields, (QFilter[])builder.toArrays(), null);
                throwable = null;
                try {
                    if (ds != null) {
                        for (kd.bos.algo.Row row : ds) {
                            bizNumbers.put(row.getString(1), new Object[]{row.getLong(0), row.getString(2)});
                            bizIds.add(row.getLong(0));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds != null) {
                        if (throwable != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadResFormat((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\uff1a%1\u7684\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002", (String)"DimMappingImportPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber}));
            }
            if (!StringUtils.isNotEmpty((String)pField) || bizIds.isEmpty()) continue;
            builder.clear();
            builder.add(new QFilter(pField, "in", (Object)bizIds));
            if (BOS_ORG_STRUCTURE.equalsIgnoreCase(entityNumber) || ADMIN_ORG_STRUCTURE.equalsIgnoreCase(entityNumber)) {
                builder.add(new QFilter("view", "=", (Object)DimMappingImportUtils.getOrgView(entityNumber)));
                builder.add(new QFilter("isfreeze", "=", (Object)Character.valueOf('0')));
            }
            try {
                ds = QueryServiceHelper.queryDataSet((String)entityNumber, (String)entityNumber, (String)pField, (QFilter[])builder.toArrays(), null);
                throwable = null;
                try {
                    if (ds == null) continue;
                    for (kd.bos.algo.Row row : ds) {
                        noLeafIds.add(row.getLong(pField));
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadResFormat((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\uff1a%1\u7684\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002", (String)"DimMappingImportPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber}));
            }
        }
        for (ItemMapping item : mappings) {
            Object[] bizObj;
            entityNumber = config.hasMoreData ? item.entityNumber : config.entityNumber;
            bizNumbers = config.getBizNumberMap().get(entityNumber);
            Object[] objectArray = bizObj = bizNumbers != null ? bizNumbers.get(item.bizNumber) : null;
            if (bizObj != null && bizObj.length > 0) {
                item.bizId = (Long)bizObj[0];
                item.bizName = (String)bizObj[1];
            }
            if (item.wildcard) {
                item.range = "";
            } else if (item.isCheckRangeDetail()) {
                if (!item.wildcard && !config.hasMoreData && noLeafIds.contains(item.bizId)) {
                    if (StringUtils.isEmpty((String)item.range)) {
                        item.range = String.valueOf(RangeEnum.ALL_EXCLUDE.getIndex());
                    }
                } else if (item.isCheckRangeDetail()) {
                    item.range = String.valueOf(RangeEnum.ONLY.getIndex());
                }
            }
            if (!config.hasAssistData) continue;
            String extEntityNumber = config.hasMoreAssistData ? item.extEntityNumber : config.extEntityNumber;
            bizNumbers = config.getBizNumberMap().get(extEntityNumber);
            bizObj = bizNumbers != null ? bizNumbers.get(item.extBizNumber) : null;
            if (bizObj == null || bizObj.length <= 0) continue;
            item.extBizId = (Long)bizObj[0];
            item.extBizName = (String)bizObj[1];
        }
    }

    protected boolean hasCover(@NotNull IDataModel dataModel) {
        ImportEnum importType = ImportEnum.getEnum((String)this.getImportType(dataModel));
        return ImportEnum.IMPORTTYPE_COVER == importType;
    }

    protected void checkStyle(@NotNull ItemImportConfig config, @NotNull Sheet sheet, String fileName) {
        block6: {
            try {
                Cell cell;
                Row row = sheet.getRow(0);
                Cell cell2 = cell = row != null ? row.getCell(0) : null;
                if (cell == null || !cell.getStringCellValue().contains("")) {
                    // empty if block
                }
                if ((row = sheet.getRow(2)) != null) {
                    String[] heads = DimMappingImportUtils.getHeadInfo(config);
                    if (row.getLastCellNum() > heads.length) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DimMappingImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
                    }
                    for (int i = 0; i < heads.length; ++i) {
                        cell = row.getCell(i);
                        if (i == heads.length - 1 || cell == null || cell.getStringCellValue().contains(heads[i]) || (cell = row.getCell(i)) != null && cell.getStringCellValue().contains(heads[i])) continue;
                        throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DimMappingImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
                    }
                    break block6;
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u5934\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DimMappingImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
            }
        }
    }

    protected void dealImportConfigMap(@NotNull Map<String, String> importConfigMap) {
        String entityNumber = importConfigMap.get(BUSINESS_BASE_DATA);
        if (BOS_ORG.equalsIgnoreCase(entityNumber)) {
            importConfigMap.put(BUSINESS_BASE_DATA, DimMappingImportUtils.dealEntityNumber(BOS_ORG));
        }
    }

    public static String dealEntityNumber(String entityNumber) {
        if (entityNumber == null) {
            return "";
        }
        switch (entityNumber) {
            case "bos_org": {
                return BOS_ORG_STRUCTURE;
            }
            case "bos_adminorg": {
                return ADMIN_ORG_STRUCTURE;
            }
        }
        return entityNumber;
    }

    private String hasLevel(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
        IDataEntityProperty parent = (IDataEntityProperty)properties.get((Object)"parent");
        IDataEntityProperty parentId = (IDataEntityProperty)properties.get((Object)"parentid");
        String field = null;
        if (parent != null && !parent.getAlias().isEmpty()) {
            field = "parent";
        } else if (parentId != null && !parentId.getAlias().isEmpty()) {
            field = "parentid";
        }
        return field;
    }

    protected boolean hasUseAssistData(@NotNull Map<String, String> importConfigMap) {
        return Boolean.parseBoolean(importConfigMap.get(USE_ASSIST_DATA));
    }

    protected boolean hasUseMoreBizData(@NotNull Map<String, String> importConfigMap) {
        return Boolean.parseBoolean(importConfigMap.get(USE_MORE_DATA));
    }

    private boolean hasUseMoreAssistBizData(@NotNull Map<String, String> importConfigMap) {
        return Boolean.parseBoolean(importConfigMap.get(USE_MORE_ASSIST_DATA));
    }

    protected String getImportType(@NotNull IDataModel model) {
        return (String)model.getValue("radiogroupfield");
    }

    protected static String[] getHeadInfo(@NotNull ItemImportConfig config) {
        LinkedList heads = Lists.newLinkedList();
        if (config.hasItemMapping) {
            if (config.hasMoreData) {
                heads.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMemberMappingListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                heads.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMemberMappingListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMappingImportPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (!config.hasMoreData) {
                heads.add(ResManager.loadKDString((String)"\u8303\u56f4", (String)"DimMemberMappingListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            heads.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"DimMemberMappingListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"DimMemberMappingListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"DimMemberMappingListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"DimMemberMappingListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (config.hasAssistData) {
                if (config.hasMoreAssistData) {
                    heads.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportUtils_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    heads.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"DimMappingImportUtils_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                heads.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                heads.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"DimMappingImportUtils_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            heads.add(ResManager.loadKDString((String)"\u9884\u5b9e\u6620\u5c04\u6210\u5458\u5173\u7cfb", (String)"DimMemberMappingListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"DimMemberMappingListPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMappingImportPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"DimMappingImportUtils_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return heads.toArray(new String[0]);
    }

    public static Integer getOrgView(@NotNull String entityNumber) {
        Integer orgView = null;
        switch (entityNumber) {
            case "bos_org": 
            case "bos_org_structure": {
                orgView = Integer.valueOf(OrgViewTypeEnum.IS_ORGUNIT.getViewType());
                break;
            }
            case "bos_adminorg": 
            case "bos_adminorg_structure": {
                orgView = Integer.valueOf(OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType());
            }
        }
        return orgView;
    }

    protected void checkMember(@NotNull ItemImportConfig config, @NotNull List<ItemMapping> mappings) {
        Throwable throwable;
        DataSet ds;
        String memberModel;
        if (!config.hasItemMapping) {
            return;
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id, shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)config.modelId)});
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingImportUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)config.modelId);
        Dimension dimension = modelCache.getDimension(config.dimNumber);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6307\u5b9a\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DimMappingImportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean isBase = true;
        QFBuilder builder = new QFBuilder();
        if (IDUtils.isNotNull((Long)config.viewId)) {
            builder.add(new QFilter("id", "=", (Object)config.viewId));
            DynamicObject view = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id, source, usage", (QFilter[])builder.toArrays());
            if (view != null && "0".equals(view.getString("source"))) {
                isBase = false;
            }
        }
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(config.dimNumber);
        LinkedHashSet busModelNum = Sets.newLinkedHashSet();
        String fields = hasAccount ? "id,number,name,parent,dataset.id" : "id,number,name,parent";
        builder.clear();
        if (isBase) {
            memberModel = dimension.getMemberModel();
            this.addQueryDimMemberBuilder(config, dimension, builder);
        } else {
            memberModel = "eb_viewmember";
            builder.add(new QFilter("view", "=", (Object)config.viewId));
            this.addQueryDimMemberBuilder(config, dimension, builder);
        }
        Object[] acmember = new Object[]{};
        Object[] bgmember = new Object[]{};
        LinkedHashSet memberIds = Sets.newLinkedHashSet();
        LinkedHashSet noLeafIds = Sets.newLinkedHashSet();
        try {
            ds = QueryServiceHelper.queryDataSet((String)"queryDimMember", (String)memberModel, (String)fields, (QFilter[])builder.toArrays(), null);
            throwable = null;
            try {
                if (ds != null) {
                    if (hasAccount && !modelCache.getModelobj().isModelByEB()) {
                        HashSet datasetIds = new HashSet(BusinessModelServiceHelper.getInstance().queryDataSetIds(config.busModelId));
                        for (Object row : ds) {
                            if (datasetIds.contains(row.getLong("dataset.id"))) {
                                config.getMemberMap().put(row.getString("number"), new Object[]{row.getLong("id"), row.getString("name"), row.getString("parent")});
                                memberIds.add(row.getLong("id"));
                                continue;
                            }
                            busModelNum.add(row.getString("number"));
                        }
                    } else {
                        for (kd.bos.algo.Row row : ds) {
                            config.getMemberMap().put(row.getString("number"), new Object[]{row.getLong("id"), row.getString("name"), row.getString("parent")});
                            memberIds.add(row.getLong("id"));
                        }
                    }
                }
            }
            catch (Throwable datasetIds) {
                throwable = datasetIds;
                throw datasetIds;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable datasetIds) {
                            throwable.addSuppressed(datasetIds);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6307\u5b9a\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002", (String)"DimMappingImportUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getNumber()}));
        }
        builder.clear();
        if (isBase) {
            this.addQueryDimMemberBuilderByParent(config, builder, memberIds);
        } else {
            builder.add(new QFilter("view", "=", (Object)config.viewId));
            builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            this.addQueryDimMemberBuilderByParent(config, builder, memberIds);
        }
        try {
            ds = QueryServiceHelper.queryDataSet((String)"queryDimMember", (String)memberModel, (String)"parent.id", (QFilter[])builder.toArrays(), null);
            throwable = null;
            try {
                if (ds != null) {
                    for (kd.bos.algo.Row row : ds) {
                        noLeafIds.add(row.getLong("parent.id"));
                    }
                }
            }
            catch (Throwable datasetIds) {
                throwable = datasetIds;
                throw datasetIds;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable datasetIds) {
                            throwable.addSuppressed(datasetIds);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6307\u5b9a\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002", (String)"DimMappingImportUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getNumber()}));
        }
        StringBuilder msg = new StringBuilder();
        List noExistItems = mappings.stream().filter(e -> IDUtils.isEmptyLong((Long)e.bizId)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(noExistItems)) {
            HashSet<String> bizMemberRangeSet = new HashSet<String>(noExistItems.size());
            for (ItemMapping itemMapping : noExistItems) {
                msg.setLength(0);
                String bizMemberRangeKey = itemMapping.bizNumber + '@' + (itemMapping.wildcard ? Character.valueOf('%') : itemMapping.range);
                if (config.hasAssistData && StringUtils.isNotEmpty((String)itemMapping.extBizNumber)) {
                    bizMemberRangeKey = bizMemberRangeKey + itemMapping.extBizNumber;
                    if (itemMapping.extWildcard) {
                        bizMemberRangeKey = bizMemberRangeKey + '%';
                    }
                }
                if (bizMemberRangeSet.contains(bizMemberRangeKey)) {
                    if (StringUtils.isNotEmpty((String)itemMapping.extBizNumber)) {
                        msg.append(ResManager.loadResFormat((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u548c\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\u3002", (String)"DimMappingImportUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[]{itemMapping.bizNumber, itemMapping.extBizNumber}));
                    } else {
                        msg.append(ResManager.loadResFormat((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\u3002", (String)"DimMappingImportUtils_11", (String)"epm-eb-formplugin", (Object[])new Object[]{itemMapping.bizNumber}));
                    }
                } else {
                    bizMemberRangeSet.add(bizMemberRangeKey);
                }
                if (StringUtils.isNotEmpty((String)itemMapping.bizNumber) && StringUtils.isEmpty((String)itemMapping.bizName)) {
                    msg.append(ResManager.loadResFormat((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599(%1)\u5df2\u586b\u7f16\u7801,\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (String)"DimMappingImportUtils_18", (String)"epm-eb-formplugin", (Object[])new Object[]{itemMapping.bizNumber}));
                }
                this.handleErrorMessageCell(config, msg, itemMapping);
            }
        }
        HashSet notSelRootDimSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber()});
        for (ItemMapping item : mappings) {
            msg.setLength(0);
            if (item.acName != null && item.acNumber == null) {
                msg.append(ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u540d\u79f0\u4e3a\u201c%1\u201d\u7684\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u3002", (String)"DimMappingImportUtils_16", (String)"epm-eb-formplugin", (Object[])new Object[]{item.acName}));
            }
            if (item.bgName != null && item.bgNumber == null) {
                msg.append(ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u540d\u79f0\u4e3a\u201c%1\u201d\u7684\u9884\u7b97\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u3002", (String)"DimMappingImportUtils_17", (String)"epm-eb-formplugin", (Object[])new Object[]{item.bgName}));
            }
            if (StringUtils.isNotEmpty((String)item.acNumber)) {
                acmember = config.getMemberMap().get(item.acNumber);
                if (acmember == null) {
                    if (busModelNum.contains(item.acNumber)) {
                        msg.append(ResManager.loadResFormat((String)"\u79d1\u76ee\u201c%1\u201d\u4e0d\u5728\u5f53\u524d\u6210\u5458\u6620\u5c04\u6240\u5c5e\u7684\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimMappingImportUtils_12", (String)"epm-eb-formplugin", (Object[])new Object[]{item.acNumber}));
                    } else {
                        msg.append(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"DimMappingImportUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[]{item.acNumber}));
                    }
                } else if (noLeafIds.contains(acmember[0])) {
                    msg.append(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u4e3a\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"DimMappingImportPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    item.acMemberId = (Long)acmember[0];
                    item.acName = (String)acmember[1];
                }
            }
            if (StringUtils.isNotEmpty((String)item.bgNumber)) {
                bgmember = config.getMemberMap().get(item.bgNumber);
                if (bgmember == null) {
                    if (busModelNum.contains(item.bgNumber)) {
                        msg.append(ResManager.loadResFormat((String)"\u79d1\u76ee\u201c%1\u201d\u4e0d\u5728\u5f53\u524d\u6210\u5458\u6620\u5c04\u6240\u5c5e\u7684\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimMappingImportUtils_12", (String)"epm-eb-formplugin", (Object[])new Object[]{item.bgNumber}));
                    } else {
                        msg.append(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"DimMappingImportUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[]{item.bgNumber}));
                    }
                    msg.append("\r\n");
                } else if (notSelRootDimSet.contains(config.dimNumber) && item.bgNumber.equals(config.dimNumber)) {
                    msg.append(ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u5bfc\u5165\u7684\u9884\u7b97\u6570\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u662f\u6839\u6210\u5458\u3002", (String)"DimMappingImportUtils_19", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
                } else {
                    item.bgMemberId = (Long)bgmember[0];
                    item.bgName = (String)bgmember[1];
                }
            }
            if (item.extBizName != null && item.extBizNumber == null) {
                msg.append(ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u540d\u79f0\u4e3a\u201c%1\u201d\u7684\u57fa\u7840\u8d44\u6599\u6210\u5458\u7f16\u7801\u3002", (String)"DimMappingImportUtils_15", (String)"epm-eb-formplugin", (Object[])new Object[]{item.extBizName}));
            }
            if (StringUtils.isNotEmpty((String)item.acNumber) && StringUtils.isNotEmpty((String)item.bgNumber) && StringUtils.isEmpty((String)msg.toString())) {
                Long parent = null;
                if (acmember != null && acmember.length > 2) {
                    parent = IDUtils.toLong((Object)acmember[2]);
                }
                Long acMemberId = null;
                if (bgmember != null && bgmember.length > 0) {
                    acMemberId = IDUtils.toLong((Object)bgmember[0]);
                }
                Long bgMemberId = null;
                if (bgmember != null && bgmember.length > 0) {
                    bgMemberId = IDUtils.toLong((Object)bgmember[0]);
                }
                item.isContain = parent != null && parent.equals(bgMemberId) || acMemberId != null && acMemberId.equals(bgMemberId) ? "0" : "1";
            }
            this.handleErrorMessageCell(config, msg, item);
        }
    }

    private void addQueryDimMemberBuilderByParent(@NotNull ItemImportConfig config, QFBuilder builder, Set<Long> memberIds) {
        builder.add(new QFilter("model", "=", (Object)config.modelId));
        builder.add(new QFilter("parent", "in", memberIds));
    }

    private void addQueryDimMemberBuilder(@NotNull ItemImportConfig config, Dimension dimension, QFBuilder builder) {
        builder.add(new QFilter("model", "=", (Object)config.modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("number", "in", config.getMemberMap().keySet()));
    }

    private void handleErrorMessageCell(@NotNull ItemImportConfig config, StringBuilder msg, ItemMapping itemMapping) {
        if (msg.length() > 0) {
            Cell cell = POIUtils.getCell((Sheet)config.errorSheet, (int)itemMapping.rowIndex, (int)0);
            String _msg = POIUtils.getStringValue((Cell)cell);
            if (StringUtils.isNotEmpty((String)_msg)) {
                msg.append(_msg);
            } else {
                POIUtils.setCellStyleOfRed((Cell)cell);
            }
            cell.setCellValue(msg.toString());
        }
    }

    protected boolean checkErrorInfo(@NotNull ItemImportConfig config) {
        Sheet errorSheet = config.errorSheet;
        Iterator rows = errorSheet.rowIterator();
        while (rows.hasNext()) {
            String error;
            Row row = (Row)rows.next();
            if (row.getRowNum() < 3 || !StringUtils.isNotEmpty((String)(error = POIUtils.getStringValue((Cell)row.getCell(0))))) continue;
            return false;
        }
        return true;
    }

    protected List<ItemMapping> getImportData(@NotNull ItemImportConfig config, @NotNull Sheet dataSheet, @NotNull DynamicObject itemMapping, boolean hasCover) {
        LinkedList mappings = Lists.newLinkedList();
        LinkedHashMap sourceKey = Maps.newLinkedHashMap();
        LinkedHashMap wildcardKeys = Maps.newLinkedHashMap();
        LinkedHashMap extWildcardKeys = Maps.newLinkedHashMap();
        if (!hasCover) {
            DynamicObjectCollection _entries = itemMapping.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < _entries.size(); ++i) {
                ItemMappingWildcard wildcard = ItemMappingWildcard.loadWildCard((DynamicObject)_entries.get(i), i);
                if (wildcard == null) continue;
                wildcard.checkWildcard(wildcardKeys, (Map<String, Map<String, ItemMappingWildcard>>)extWildcardKeys);
            }
        }
        int rowMax = 100000;
        Iterator rows = dataSheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            if (row.getRowNum() < 3) continue;
            if (row.getRowNum() > rowMax || this.isEmptyRow(row)) break;
            ItemMapping mapping = this.createItemMapping();
            mapping.loadRowData(row, config);
            mapping.beforeLoadMember(config);
            mappings.add(mapping);
        }
        this.dealImportRangeAndName(config, mappings);
        LinkedList result = Lists.newLinkedList();
        for (ItemMapping mapping1 : mappings) {
            if (!mapping1.check(mapping1.rowIndex, config, sourceKey, wildcardKeys, extWildcardKeys)) continue;
            result.add(mapping1);
        }
        return result;
    }

    protected boolean isEmptyRow(Row row) {
        if (row == null || row.getPhysicalNumberOfCells() == 0) {
            return true;
        }
        int colCount = row.getLastCellNum();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            Cell cell = row.getCell(colIndex);
            String value = POIUtils.getStringValue((Cell)cell);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isWildcardstatus(DynamicObject _entry) {
        return _entry.getBoolean("wildcardstatus");
    }

    protected ItemMapping createItemMapping() {
        return new ItemMapping();
    }

    protected DynamicObject getItemMapping(@NotNull Long itemMappingId) {
        return BusinessDataServiceHelper.loadSingle((Object)itemMappingId, (String)this.getMappingEntityNumber());
    }

    protected String getMappingEntityNumber() {
        return "eb_dimmembermapping";
    }

    protected boolean update(@NotNull DynamicObject itemMapping, @NotNull ItemImportConfig config, @NotNull List<ItemMapping> mappings, boolean hasCover) {
        DynamicObjectCollection _entries = itemMapping.getDynamicObjectCollection("entryentity");
        HashMap entryKeys = Maps.newHashMapWithExpectedSize((int)_entries.size());
        if (hasCover) {
            _entries.clear();
        } else {
            for (DynamicObject entry : _entries) {
                entryKeys.put(this.getEntryKey(entry, config), entry);
            }
        }
        for (ItemMapping item : mappings) {
            DynamicObject _entry = (DynamicObject)entryKeys.get(item.getKey(config));
            if (_entry == null) {
                _entry = _entries.addNew();
            }
            _entry.set("morebussdata", (Object)item.entityNumber);
            _entry.set("showbizmember", (Object)item.bizName);
            _entry.set("biznumber", (Object)(item.wildcard ? item.bizNumber + '%' : item.bizNumber));
            _entry.set("bizmember", (Object)item.bizId);
            _entry.set("range", (Object)item.getRange());
            _entry.set("assistmorebussdata", (Object)item.extEntityNumber);
            _entry.set("showbizmemberext", (Object)item.extBizName);
            _entry.set("biznumberext", (Object)(item.extWildcard ? item.extBizNumber + '%' : item.extBizNumber));
            _entry.set("bizmemberext", (Object)item.extBizId);
            if (StringUtils.isEmpty((String)item.extEntityNumber) && config.hasMoreAssistData) {
                _entry.set("showbizmemberext", null);
                _entry.set("biznumberext", null);
                _entry.set("bizmemberext", (Object)0L);
            }
            _entry.set("dimmember", (Object)item.acMemberId);
            _entry.set("dimmemnumber", (Object)item.acNumber);
            _entry.set("showdimmember", (Object)item.acName);
            _entry.set("budimmember", (Object)item.bgMemberId);
            _entry.set("budimmemnumber", (Object)item.bgNumber);
            _entry.set("bushowdimmember", (Object)item.bgName);
            _entry.set("iscontain", (Object)item.getIsContain());
            _entry.set("wildcardstatus", (Object)Character.valueOf(item.getWildcard()));
            _entry.set("entrystatus", (Object)Character.valueOf('1'));
            _entry.set("remark", (Object)item.remark);
        }
        _entries.sort((o1, o2) -> {
            String key2;
            String key1;
            if (config.hasMoreData) {
                key1 = o1.getString("morebussdata") + '@' + o1.getString("biznumber");
                key2 = o2.getString("morebussdata") + '@' + o2.getString("biznumber");
            } else {
                key1 = o1.getString("biznumber");
                key2 = o2.getString("biznumber");
            }
            int re = key1.compareTo(key2);
            if (re == 0) {
                if (config.hasAssistData) {
                    if (config.hasMoreAssistData) {
                        key1 = o1.getString("assistmorebussdata") + '@' + o1.getString("biznumberext");
                        key2 = o2.getString("assistmorebussdata") + '@' + o2.getString("biznumberext");
                    } else {
                        key1 = o1.getString("biznumberext");
                        key2 = o2.getString("biznumberext");
                    }
                    re = key1.compareTo(key2);
                }
                if (re == 0) {
                    re = o1.getString("dimmemnumber").compareTo(o2.getString("dimmemnumber"));
                }
            }
            return re;
        });
        int in = _entries.size();
        for (int i = 0; i < in; ++i) {
            ((DynamicObject)_entries.get(i)).set("seq", (Object)i);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemMapping});
        this.writeLog(config.bizAppId, config.bizEntityNumber);
        return true;
    }

    protected String getEntryKey(DynamicObject entry, @NotNull ItemImportConfig config) {
        if (entry == null) {
            return null;
        }
        StringBuilder entryKey = new StringBuilder();
        entryKey.append(entry.getString("biznumber")).append('#').append(entry.getString("range"));
        if (config.hasAssistData && StringUtils.isNotEmpty((String)entry.getString("biznumberext"))) {
            entryKey.append('#').append(entry.getString("biznumberext"));
        }
        return entryKey.toString();
    }

    protected void writeLog(@NotNull String bizAppId, @NotNull String bizEntityNumber) {
        MultiLangEnumBridge operation = new MultiLangEnumBridge("\u4fdd\u5b58", "DimMappingImportPlugin_17", "epm-eb-formplugin");
        MultiLangEnumBridge description = new MultiLangEnumBridge("\u5bfc\u5165\u6570\u636e\u4fdd\u5b58\u6210\u529f\u3002", "DimMappingImportPlugin_18", "epm-eb-formplugin");
        OperationLogUtil.log((String)bizAppId, (String)bizEntityNumber, null, null, (MultiLangEnumBridge)operation, (MultiLangEnumBridge)description, null);
    }

    protected static class ItemMapping
    extends ItemMappingWildcard {
        public Long bizId = 0L;
        public String entityNumber = null;
        public String bizName = null;
        public Long extBizId = 0L;
        public String extEntityNumber = null;
        public String extBizName = null;
        public Long bgMemberId = 0L;
        public String bgNumber = null;
        public String bgName = null;
        public Long acMemberId = 0L;
        public String acNumber = null;
        public String acName = null;
        public String isContain = null;
        public String remark = null;

        protected ItemMapping() {
        }

        public String getKey(@NotNull ItemImportConfig config) {
            StringBuilder itemKey = new StringBuilder();
            itemKey.append(this.bizNumber);
            if (this.wildcard) {
                itemKey.append('%');
            }
            itemKey.append('#').append(this.range);
            if (config.hasAssistData && StringUtils.isNotEmpty((String)this.extBizNumber)) {
                itemKey.append('#').append(this.extBizNumber);
                if (this.extWildcard) {
                    itemKey.append('%');
                }
            }
            return itemKey.toString();
        }

        public char getWildcard() {
            return (char)(this.wildcard || this.extWildcard ? 49 : 48);
        }

        public String getRange() {
            return this.wildcard ? "" : this.range;
        }

        public String getIsContain() {
            return this.isContain;
        }

        public void loadRowData(@NotNull Row row, @NotNull ItemImportConfig config) {
            int colIndex = 0;
            if (config.hasItemMapping) {
                String isContainCellValue;
                this.rowIndex = row.getRowNum();
                if (config.hasMoreData) {
                    int n = ++colIndex;
                    this.entityNumber = POIUtils.getStringValue((Cell)row.getCell(n));
                }
                int n = ++colIndex;
                this.bizName = POIUtils.getStringValue((Cell)row.getCell(n));
                int n2 = ++colIndex;
                ++colIndex;
                this.bizNumber = POIUtils.getStringValue((Cell)row.getCell(n2));
                if (this.bizNumber != null && this.bizNumber.length() > 0 && '%' == this.bizNumber.charAt(this.bizNumber.length() - 1)) {
                    this.wildcard = true;
                    this.bizNumber = this.bizNumber.substring(0, this.bizNumber.length() - 1);
                    this.range = "";
                    if (!config.hasMoreData) {
                        // empty if block
                    }
                } else if (!config.hasMoreData) {
                    RangeMappingEnum r;
                    String rangeStr;
                    this.range = "";
                    if (!StringUtils.isEmpty((String)(rangeStr = POIUtils.getStringValue((Cell)row.getCell(colIndex++)))) && (r = RangeMappingEnum.getRangeByName((String)rangeStr)) != null) {
                        this.range = r.getIndStr();
                    }
                }
                int n3 = ++colIndex;
                this.acName = POIUtils.getStringValue((Cell)row.getCell(n3));
                int n4 = ++colIndex;
                this.acNumber = POIUtils.getStringValue((Cell)row.getCell(n4));
                int n5 = ++colIndex;
                this.bgName = POIUtils.getStringValue((Cell)row.getCell(n5));
                int n6 = ++colIndex;
                ++colIndex;
                this.bgNumber = POIUtils.getStringValue((Cell)row.getCell(n6));
                if (StringUtils.isEmpty((String)this.bgNumber)) {
                    this.bgName = null;
                }
                if (config.hasAssistData) {
                    if (config.hasMoreAssistData) {
                        int n7 = ++colIndex;
                        this.extEntityNumber = POIUtils.getStringValue((Cell)row.getCell(n7));
                    }
                    int n8 = ++colIndex;
                    this.extBizName = POIUtils.getStringValue((Cell)row.getCell(n8));
                    int n9 = ++colIndex;
                    ++colIndex;
                    this.extBizNumber = POIUtils.getStringValue((Cell)row.getCell(n9));
                    if (this.extBizNumber != null && this.extBizNumber.length() > 0 && '%' == this.extBizNumber.charAt(this.extBizNumber.length() - 1)) {
                        this.extWildcard = true;
                        this.extBizNumber = this.extBizNumber.substring(0, this.extBizNumber.length() - 1);
                    }
                }
                if (StringUtils.isNotEmpty((String)(isContainCellValue = POIUtils.getStringValue((Cell)row.getCell(colIndex++))))) {
                    this.isContain = DimMappingIsContainEnum.PARALLEL_STRUCTURE.getName().equals(isContainCellValue) ? DimMappingIsContainEnum.PARALLEL_STRUCTURE.getIndex() : DimMappingIsContainEnum.UPPER_AND_LOWER_STRUCTURE.getIndex();
                }
                this.remark = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
            } else {
                this.bizName = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
                this.bizNumber = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
                this.extBizName = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
                this.extBizNumber = POIUtils.getStringValue((Cell)row.getCell(colIndex));
                if (StringUtils.isEmpty((String)this.extBizNumber)) {
                    this.extBizName = null;
                }
            }
        }

        public boolean check(int rowIndex, @NotNull ItemImportConfig config, @NotNull Map<String, String> sourceKeys, @NotNull Map<String, Map<String, ItemMappingWildcard>> wildcardKeys, @NotNull Map<String, Map<String, ItemMappingWildcard>> extWildcardKeys) {
            if (config.hasItemMapping) {
                return this.checkMapping(rowIndex, config, sourceKeys, wildcardKeys, extWildcardKeys);
            }
            return this.checkWhiteSet(rowIndex, config, sourceKeys);
        }

        public boolean checkMapping(int rowIndex, @NotNull ItemImportConfig config, @NotNull Map<String, String> sourceKeys, @NotNull Map<String, Map<String, ItemMappingWildcard>> wildcardKeys, @NotNull Map<String, Map<String, ItemMappingWildcard>> extWildcardKeys) {
            ItemMappingWildcard cross;
            String _entityNumber;
            StringBuilder msg = new StringBuilder();
            String _extEntityNumber = null;
            String string = _entityNumber = config.hasMoreData ? this.entityNumber : config.entityNumber;
            if (StringUtils.isEmpty((String)_entityNumber)) {
                msg.append(ResManager.loadResFormat((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (String)"DimMappingImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{_entityNumber})).append("\r\n");
            } else if (!config.getTypes().containsKey(DimMappingImportUtils.dealEntityNumber(_entityNumber))) {
                msg.append(ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801(%1)\u3002", (String)"DimMappingImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{_entityNumber})).append("\r\n");
            }
            if (StringUtils.isEmpty((String)this.bizNumber)) {
                msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimMappingImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            } else if (this.bizNumber.indexOf(13) >= 0 || this.bizNumber.indexOf(10) >= 0) {
                msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u6362\u884c\u7b26\uff1b", (String)"DimMappingImportPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            }
            if (config.hasAssistData) {
                String string2 = _extEntityNumber = config.hasMoreAssistData ? this.extEntityNumber : config.extEntityNumber;
                if (StringUtils.isNotEmpty((String)_extEntityNumber) && !config.getTypes().containsKey(DimMappingImportUtils.dealEntityNumber(_extEntityNumber))) {
                    msg.append(ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u591a\u7c7b\u522b\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801(%1);", (String)"DimMappingImportPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[]{_extEntityNumber})).append("\r\n");
                }
                if (_entityNumber != null && _entityNumber.equals(_extEntityNumber)) {
                    msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u522b\u7f16\u7801\u4e0e\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u522b\u7f16\u7801\u4e0d\u5141\u8bb8\u76f8\u540c;", (String)"DimMappingImportPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                }
                if (StringUtils.isNotEmpty((String)_extEntityNumber)) {
                    if (StringUtils.isNotEmpty((String)this.extBizNumber) && (this.extBizNumber.indexOf(13) >= 0 || this.extBizNumber.indexOf(10) >= 0)) {
                        msg.append(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u6362\u884c\u7b26;\r\n", (String)"DimMappingImportPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                } else if (StringUtils.isNotEmpty((String)this.extBizNumber)) {
                    msg.append(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff0c\u4f46\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u522b\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DimMappingImportUtils_13", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (StringUtils.isNotEmpty((String)this.bizNumber)) {
                String _oldDistKey;
                String sourceKey = this.bizNumber;
                if (this.wildcard) {
                    sourceKey = sourceKey + 101;
                } else if (this.hasRange()) {
                    sourceKey = sourceKey + '@' + this.range;
                }
                if (config.hasAssistData && StringUtils.isNotEmpty((String)this.extBizNumber)) {
                    sourceKey = sourceKey + '@' + this.extBizNumber;
                    if (this.extWildcard) {
                        sourceKey = sourceKey + 101;
                    }
                }
                if ((_oldDistKey = sourceKeys.get(sourceKey)) != null) {
                    if (_oldDistKey.equals(this.acNumber)) {
                        if (config.hasAssistData) {
                            msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u548c\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\u3002", (String)"DimMappingImportUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                        } else {
                            msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\u3002", (String)"DimMappingImportUtils_11", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                        }
                    } else {
                        msg.append(ResManager.loadKDString((String)"\u4e00\u4e2a\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4e0d\u5141\u8bb8\u6620\u5c04\u591a\u4e2a\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimMappingImportPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                    }
                } else {
                    sourceKeys.put(sourceKey, this.acNumber);
                }
            }
            if ((cross = this.checkWildcard(false, wildcardKeys)) != null) {
                msg.append(this.getMessage(this.bizNumber, cross.bizNumber)).append("\r\n");
            }
            if ((cross = this.checkWildcard(true, extWildcardKeys)) != null) {
                msg.append(this.getMessage(this.extBizNumber, cross.extBizNumber)).append("\r\n");
            }
            if (this.remark != null && this.remark.length() > 2000) {
                msg.append(ResManager.loadKDString((String)"\u5907\u6ce8\u5b57\u6bb5\u8d85\u8fc7\u6700\u59272000\u5b57\u7b26\u957f\u5ea6\u9650\u5236\r\n", (String)"DimMappingImportUtils_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (msg.length() > 0) {
                Cell cell = POIUtils.getCell((Sheet)config.errorSheet, (int)rowIndex, (int)0);
                POIUtils.setCellStyleOfRed((Cell)cell);
                cell.setCellValue(msg.toString());
            } else {
                this.beforeLoadMember(config);
            }
            return msg.length() == 0;
        }

        protected void beforeLoadMember(ItemImportConfig config) {
            Map bizNumbers;
            String _entityNumber;
            String _extEntityNumber = null;
            String string = _entityNumber = config.hasMoreData ? this.entityNumber : config.entityNumber;
            if (config.hasAssistData) {
                String string2 = _extEntityNumber = config.hasMoreAssistData ? this.extEntityNumber : config.extEntityNumber;
            }
            if (_entityNumber != null) {
                bizNumbers = config.getBizNumberMap().computeIfAbsent(_entityNumber, f -> Maps.newLinkedHashMap());
                bizNumbers.put(this.bizNumber, null);
            }
            if (config.hasAssistData && StringUtils.isNotEmpty((String)_extEntityNumber)) {
                bizNumbers = config.getBizNumberMap().computeIfAbsent(_extEntityNumber, f -> Maps.newLinkedHashMap());
                bizNumbers.put(this.extBizNumber, null);
            }
            if (StringUtils.isNotEmpty((String)this.acNumber)) {
                config.getMemberMap().put(this.acNumber, null);
            }
            if (StringUtils.isNotEmpty((String)this.bgNumber)) {
                config.getMemberMap().put(this.bgNumber, null);
            }
        }

        private String getMessage(String s1, String s2) {
            return ResManager.loadResFormat((String)"\u57fa\u7840\u8d44\u6599\u7f16\u7801%1\u4e0e%2\u5b58\u5728\u5305\u542b\u5173\u7cfb\u3002\u5728\u5339\u914d\u7b26\u573a\u666f\u4e0b\uff0c\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u5141\u8bb8\u5b58\u5728\u5305\u542b\u5173\u7cfb\u3002", (String)"DimMappingImportUtils_14", (String)"epm-eb-formplugin", (Object[])new Object[]{s1, s2});
        }

        protected boolean hasRange() {
            return true;
        }

        protected boolean isCheckRangeDetail() {
            return true;
        }

        public boolean checkWhiteSet(int rowIndex, @NotNull ItemImportConfig config, @NotNull Map<String, String> sourceKeys) {
            StringBuilder msg = new StringBuilder();
            if (StringUtils.isEmpty((String)this.bizNumber)) {
                msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimMappingImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            } else if (this.bizNumber.indexOf(13) >= 0 || this.bizNumber.indexOf(10) >= 0) {
                msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u6362\u884c\u7b26\uff1b", (String)"DimMappingImportPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            }
            if (config.hasAssistData && StringUtils.isNotEmpty((String)this.extBizNumber) && (this.extBizNumber.indexOf(13) >= 0 || this.extBizNumber.indexOf(10) >= 0)) {
                msg.append(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u6362\u884c\u7b26;\r\n", (String)"DimMappingImportPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)this.bizNumber)) {
                String sourceKey = this.bizNumber;
                if (config.hasAssistData && StringUtils.isNotEmpty((String)this.extBizNumber)) {
                    sourceKey = sourceKey + '@' + this.extBizNumber;
                }
                if (sourceKeys.containsKey(sourceKey)) {
                    if (config.hasAssistData) {
                        msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u548c\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\u3002", (String)"DimMappingImportUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                    } else {
                        msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\u3002", (String)"DimMappingImportUtils_11", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                    }
                } else {
                    sourceKeys.put(sourceKey, null);
                }
            }
            if (msg.length() > 0) {
                Cell cell = POIUtils.getCell((Sheet)config.errorSheet, (int)rowIndex, (int)0);
                POIUtils.setCellStyleOfRed((Cell)cell);
                cell.setCellValue(msg.toString());
            }
            return msg.length() == 0;
        }
    }

    protected static class ItemMappingWildcard {
        public boolean isExtWildcardCross = false;
        protected int rowIndex = 0;
        public String bizNumber = null;
        public boolean wildcard = false;
        public String range = String.valueOf(RangeEnum.ONLY.getIndex());
        public String extBizNumber = null;
        public boolean extWildcard = false;

        protected ItemMappingWildcard() {
        }

        public static ItemMappingWildcard loadWildCard(DynamicObject _entry, int rowIndex) {
            String extBizNumber;
            if (_entry == null) {
                return null;
            }
            ItemMappingWildcard wildcard = new ItemMappingWildcard();
            wildcard.rowIndex = rowIndex;
            wildcard.range = _entry.getString("range");
            String bizNumber = _entry.getString("biznumber");
            int _wildcard = 32;
            if (StringUtils.isNotEmpty((String)bizNumber)) {
                _wildcard = bizNumber.charAt(bizNumber.length() - 1);
                if (37 == _wildcard) {
                    wildcard.bizNumber = bizNumber.substring(0, bizNumber.length() - 1);
                    wildcard.wildcard = true;
                } else {
                    wildcard.bizNumber = bizNumber;
                }
            }
            if (StringUtils.isNotEmpty((String)(extBizNumber = _entry.getString("biznumberext")))) {
                _wildcard = extBizNumber.charAt(extBizNumber.length() - 1);
                if (37 == _wildcard) {
                    wildcard.extWildcard = true;
                    wildcard.extBizNumber = extBizNumber.substring(0, extBizNumber.length() - 1);
                } else {
                    wildcard.extBizNumber = extBizNumber;
                }
            }
            return wildcard;
        }

        public ItemMappingWildcard checkWildcard(@NotNull Map<String, Map<String, ItemMappingWildcard>> wildcardKeys, @NotNull Map<String, Map<String, ItemMappingWildcard>> extWildcardKeys) {
            ItemMappingWildcard extCross;
            ItemMappingWildcard cross = null;
            if (this.wildcard) {
                cross = this.checkWildcard(false, wildcardKeys);
            }
            if (this.extWildcard && (extCross = this.checkWildcard(true, extWildcardKeys)) != null && cross == null) {
                cross = extCross;
            }
            return cross;
        }

        public ItemMappingWildcard checkWildcard(boolean isExt, @NotNull Map<String, Map<String, ItemMappingWildcard>> wildcardKeys) {
            Map subMap;
            if (isExt ? !this.extWildcard : !this.wildcard) {
                return null;
            }
            ItemMappingWildcard cross = null;
            String _mainNumber = this.bizNumber;
            String _extNumber = this.extBizNumber;
            String _extrange = String.valueOf(RangeEnum.ONLY.getIndex());
            boolean _isExtWildcard = this.extWildcard;
            if (isExt) {
                _mainNumber = this.extBizNumber;
                _extNumber = this.bizNumber;
                _extrange = this.range;
                _isExtWildcard = this.wildcard;
            }
            String extKey = StringUtils.toNoEmptyString((Object)_extNumber) + '#' + (_isExtWildcard ? Character.valueOf('%') : _extrange);
            for (Map.Entry<String, Map<String, ItemMappingWildcard>> entry : wildcardKeys.entrySet()) {
                if (this.checkNoCross(_mainNumber, entry.getKey())) continue;
                if (_isExtWildcard) {
                    for (ItemMappingWildcard card : entry.getValue().values()) {
                        boolean _otherExtWildcard = card.extWildcard;
                        if (isExt) {
                            _otherExtWildcard = card.wildcard;
                        }
                        if (!_otherExtWildcard || this.checkNoCross(_extNumber, isExt ? card.bizNumber : card.extBizNumber)) continue;
                        cross = card;
                        break;
                    }
                    if (cross == null) continue;
                    break;
                }
                if (!entry.getValue().containsKey(extKey)) continue;
                cross = entry.getValue().get(extKey);
                break;
            }
            if (!(subMap = wildcardKeys.computeIfAbsent(_mainNumber, f -> Maps.newLinkedHashMap())).containsKey(extKey)) {
                subMap.put(extKey, this);
            }
            if (cross != null) {
                cross.isExtWildcardCross = isExt;
            }
            return cross;
        }

        private boolean checkNoCross(String number, String otherNumber) {
            if (number == null || otherNumber == null) {
                return true;
            }
            return !number.startsWith(otherNumber) && !otherNumber.startsWith(number);
        }
    }

    protected static class ItemImportConfig {
        public boolean hasItemMapping = true;
        public String bizAppId = null;
        public String bizEntityNumber = null;
        public Long itemMappingId = 0L;
        public Long modelId = 0L;
        public Long busModelId = null;
        public String dimNumber = null;
        public Long viewId = null;
        public String entityNumber = null;
        public String extEntityNumber = null;
        public boolean hasMoreData = false;
        public boolean hasAssistData = false;
        public boolean hasMoreAssistData = false;
        public Workbook errorBook = null;
        public Sheet errorSheet = null;
        private Map<String, Map<String, Object[]>> bizNumberMap = Maps.newLinkedHashMap();
        private static Map<String, DynamicObject> types = null;
        private Map<String, Object[]> memberMap = Maps.newLinkedHashMap();

        protected ItemImportConfig() {
        }

        public Map<String, Map<String, Object[]>> getBizNumberMap() {
            return this.bizNumberMap;
        }

        public Map<String, DynamicObject> getTypes() {
            if (types == null) {
                types = this.getAllType();
            }
            return types;
        }

        public Map<String, Object[]> getMemberMap() {
            return this.memberMap;
        }

        private Map<String, DynamicObject> getAllType() {
            LinkedHashMap types = Maps.newLinkedHashMap();
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"eb_registmappingbill", (String)"id,basedatafield,basename", null);
            if (colls != null) {
                colls.forEach(d -> {
                    String entityNumber = DimMappingImportUtils.dealEntityNumber(d.getString("basedatafield"));
                    types.put(entityNumber, d);
                });
            }
            return types;
        }
    }
}

