/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeMappingEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DimMemberMappingListPlugin
extends AbstractListPlugin
implements ClickListener,
BeforeF7SelectListener,
BasedataFuzzySearchListener,
CreateListDataProviderListener {
    private static final String ADDNEW = "tblnew";
    private static final String MODIFY = "tblmod";
    private static final String DEL = "tbldel";
    private static final String BILLLISTAP = "billlistap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SUBENTRYENTITY = "subentryentity";
    private static final String IMPORT = "import";
    private static final String REFRESH = "tblrefresh";
    private static final String EXPORT = "export";
    private static final String HISTORY = "tblhistory";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"model"});
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = null;
        if (((FormDataModel)e.getSource()).getProperty("model") != null) {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
            if (!IDUtils.isNotNull((Long)modelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMemberMappingListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("model", (Object)modelId);
        } else {
            modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        if (this.getView().getControl("bussmodel") != null) {
            ((ListColumn)this.getView().getControl("bussmodel")).setVisible(0);
        }
        this.refreshData();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tblnew": {
                long modelId = this.getModelId();
                if (modelId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DimMemberMappingListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Long> params = new HashMap<String, Long>(16);
                params.put("KEY_MODEL_ID", modelId);
                BaseShowParameter parameter = new BaseShowParameter();
                parameter.setFormId("eb_dimmembermapping");
                parameter.setCustomParams(params);
                parameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u65b0\u589e", (String)"DimMemberMappingListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                parameter.setBillStatus(BillOperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addnew");
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "tblmod": {
                BillList bl = (BillList)this.getView().getControl(BILLLISTAP);
                ListSelectedRowCollection sRows = bl.getSelectedRows();
                if (sRows.size() != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"DimMemberMappingListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Object pkId = ((BillList)this.getView().getControl(BILLLISTAP)).getSelectedRows().get(0).getPrimaryKeyValue();
                this.modify(pkId);
                break;
            }
            case "tbldel": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DimMemberMappingListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"DimMemberMappingListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("del"));
                break;
            }
            case "import": {
                this.openImportPage();
                break;
            }
            case "export": {
                this.export();
                break;
            }
            case "tblrefresh": {
                this.refreshData();
                break;
            }
            case "tblhistory": {
                this.history();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue("model");
            if (obj == null) {
                this.getPageCache().put("KEY_MODEL_ID", null);
            }
            if (obj instanceof DynamicObject) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
            this.refreshData();
            this.dealModelChanged4Bg(e);
        }
    }

    public DynamicObject getSelModel() {
        Object obj;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !"eb_dimmaterule".equals(this.getView().getParentView().getEntityId()) && !"eb_adddimmaterule".equals(this.getView().getParentView().getEntityId()) && (obj = this.getModel().getValue("model")) instanceof DynamicObject) {
            return (DynamicObject)obj;
        }
        return null;
    }

    protected void refreshData() {
        BillList list;
        if (this.getSelModel() != null) {
            this.setDTAndATVisible();
        }
        if ((list = (BillList)this.getControl(BILLLISTAP)) != null) {
            list.clearSelection();
            list.refreshData();
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject model;
        Long modelId = 0L;
        String _modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)_modelId)) {
            modelId = Long.valueOf(_modelId);
        } else if (this.getModel().getProperty("model") != null && (model = (DynamicObject)this.getModel().getValue("model")) != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        if ("addnew".equals(key)) {
            this.refreshData();
        }
        if (e.getReturnData() != null && e.getReturnData().equals("updata")) {
            this.refreshData();
        }
        if (e.getReturnData() != null && e.getReturnData().equals("success")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"DimMemberMappingListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void export() {
        boolean usemoreassistdata;
        boolean usemorebussdata;
        boolean useassistData;
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"DimMemberMappingListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u518d\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"DimMemberMappingListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectField = "model,number,name,useassistdata,usemorebussdata,usemoreassistdata,assistmorebussdata,businessbasedata,dimnumber,entryentity.morebussdata,entryentity.biznumber,entryentity.dimmemnumber,entryentity.showbizmember,entryentity.range,entryentity.showdimmember,entryentity.biznumberext,entryentity.showbizmemberext,entryentity.budimmemnumber,entryentity.bushowdimmember,entryentity.iscontain,entryentity.remark";
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((String)"eb_dimmembermapping", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        long id = ((DynamicObject)doc.get("model")).getLong("id");
        boolean bgmdModel = CommonUtils.isBgmdModel((Long)id);
        if (!(bgmdModel || ModelUtil.isBGModel((Long)id) || this.isLimit(id))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u4f53\u7cfb\u7684\u6743\u9650\u3002", (String)"DimMemberMappingListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection docs = (DynamicObjectCollection)doc.get(ENTRYENTITY);
        String url = this.handleExportData(docs, useassistData = doc.getBoolean("useassistdata"), usemorebussdata = doc.getBoolean("usemorebussdata"), usemoreassistdata = doc.getBoolean("usemoreassistdata"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        this.writeLog(EXPORT, new MultiLangEnumBridge("\u5bfc\u51fa", "EbDimMemberMapListPlugin_51", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "DimMemberMappingListPlugin_35", "epm-eb-formplugin"));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("del".equals(callBackId) && "Yes".equals(evt.getResultValue())) {
            this.delMapping();
        }
    }

    private String handleExportData(DynamicObjectCollection docs, boolean useassistData, boolean usemorebussdata, boolean usemoreassistdata) {
        if (docs != null && !docs.isEmpty()) {
            XSSFWorkbook workBook = new XSSFWorkbook();
            XSSFCellStyle style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFSheet xssfSheet = workBook.createSheet();
            xssfSheet.setColumnWidth(0, 10000);
            ArrayList<String> headerList = new ArrayList<String>(16);
            int range = 2;
            if (usemorebussdata) {
                headerList.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMemberMappingListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                headerList.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMemberMappingListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            headerList.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMemberMappingListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            headerList.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMemberMappingListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (!usemorebussdata) {
                headerList.add(ResManager.loadKDString((String)"\u8303\u56f4", (String)"DimMemberMappingListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            headerList.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"DimMemberMappingListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            headerList.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"DimMemberMappingListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            headerList.add(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"DimMemberMappingListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            headerList.add(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"DimMemberMappingListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (useassistData && usemoreassistdata) {
                headerList.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportUtils_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                headerList.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"DimMappingImportUtils_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (useassistData) {
                headerList.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMemberMappingListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                headerList.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"DimMemberMappingListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            headerList.add(ResManager.loadKDString((String)"\u9884\u5b9e\u6620\u5c04\u6210\u5458\u5173\u7cfb", (String)"DimMemberMappingListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            headerList.add(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"DimMemberMappingListPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (int i = 0; i < 2; ++i) {
                XSSFRow headerRow1 = xssfSheet.createRow(i);
                XSSFCell cell0 = headerRow1.createCell(0, CellType.STRING);
                if (i == 0) {
                    cell0.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6620\u5c04 # eb_dimmembermapping", (String)"DimMemberMappingListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (i == 1) {
                    cell0.setCellValue(ResManager.loadKDString((String)"\u5e26*\u53f7\u7684\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u5e26*\u53f7\u7684\u4e3a\u975e\u5fc5\u586b\u9879\u3002", (String)"DimMemberMappingListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                cell0.setCellStyle((CellStyle)style);
            }
            XSSFRow headerRow1 = xssfSheet.createRow(2);
            for (int i = 0; i < headerList.size(); ++i) {
                xssfSheet.setColumnWidth(i + 1, 5000);
                XSSFCell cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue((String)headerList.get(i));
                cell.setCellStyle((CellStyle)style);
            }
            if (!usemorebussdata) {
                FileImportUtils fileImportUtils = FileImportUtils.getInstance();
                ArrayList<String> rangeStr = new ArrayList<String>(RangeMappingEnum.values().length);
                for (RangeMappingEnum r : RangeMappingEnum.values()) {
                    rangeStr.add(r.getName());
                }
                fileImportUtils.setColumnFormatAsCombo((Sheet)xssfSheet, range, rangeStr.toArray(new String[0]));
            }
            HashMap<String, String> bizTypeMap = new HashMap<String, String>(16);
            DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"eb_registmappingbill", (String)"basedatafield,basename", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
            for (DynamicObject bizType : bizTypes) {
                bizTypeMap.put(bizType.getString("basedatafield"), bizType.getString("basename"));
            }
            for (int i = 0; i < docs.size(); ++i) {
                String bizTypeNumber;
                ArrayList<Object> row = new ArrayList<Object>(16);
                DynamicObject d = (DynamicObject)docs.get(i);
                if (usemorebussdata) {
                    bizTypeNumber = d.getString("morebussdata");
                    row.add(bizTypeMap.get(bizTypeNumber));
                    row.add(bizTypeNumber);
                }
                row.add(d.getString("showbizmember"));
                row.add(d.getString("biznumber"));
                if (!usemorebussdata) {
                    row.add(StringUtils.isEmpty((String)d.getString("range")) ? "" : RangeMappingEnum.getRangeByVal((String)d.getString("range")).getName());
                }
                row.add(d.getString("showdimmember"));
                row.add(d.getString("dimmemnumber"));
                row.add(d.getString("bushowdimmember"));
                row.add(d.getString("budimmemnumber"));
                if (useassistData && usemoreassistdata) {
                    bizTypeNumber = d.getString("assistmorebussdata");
                    row.add(bizTypeMap.get(bizTypeNumber));
                    row.add(bizTypeNumber);
                }
                if (useassistData) {
                    row.add(d.getString("showbizmemberext"));
                    row.add(d.getString("biznumberext"));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)d.getString("iscontain"))) {
                    if ("0".equals(d.getString("iscontain"))) {
                        row.add(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ed3\u6784", (String)"DimMemberMappingListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        row.add(ResManager.loadKDString((String)"\u5e73\u884c\u7ed3\u6784", (String)"DimMemberMappingListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    row.add("");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)d.getString("remark"))) {
                    row.add(d.getString("remark"));
                } else {
                    row.add("");
                }
                XSSFRow xssfRow = xssfSheet.createRow(3 + i);
                for (int j = 0; j < row.size(); ++j) {
                    XSSFCell cell = xssfRow.createCell(j);
                    cell.setCellValue((String)row.get(j));
                }
            }
            try {
                return ImportAndExportUtil.writeFile((Workbook)workBook, (String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6620\u5c04-\u5bfc\u51fa\u6570\u636e", (String)"DimMemberMappingListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DimMemberMappingListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return null;
    }

    private void delMapping() {
        String row;
        HashSet<Long> mappingIds = new HashSet<Long>(16);
        HashSet<Object> delete = new HashSet<Object>(16);
        ArrayList<String> noDelNumber = new ArrayList<String>(16);
        ArrayList<String> DelNumber = new ArrayList<String>(16);
        ArrayList<String> noDelByMappingNumber = new ArrayList<String>(16);
        HashSet<Long> queryId = new HashSet<Long>(16);
        String message = null;
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        application = ApplicationTypeEnum.EB;
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        Set permIdSet = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
        Set haspermids = FunPermissionHelper.getEffectiveByPermModel((String)this.getView().getEntityId(), (ApplicationTypeEnum)application);
        Set perRoleids = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application, (String)this.getView().getEntityId(), (String)"47150e89000000ac");
        permIdSet.addAll(haspermids);
        permIdSet.addAll(perRoleids);
        Set<Long> longs = this.queryDimrule(this.getModelId());
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimmembermapping");
        for (int i = 0; i < primaryKeyValues.length; ++i) {
            queryId.add((Long)primaryKeyValues[i]);
        }
        HashSet<Long> bussModelIds = new HashSet<Long>();
        DataSet ds = QueryServiceHelper.queryDataSet((String)"mapping", (String)"eb_dimmembermapping", (String)"id,model,number,dimnumber,bussmodel", (QFilter[])new QFilter[]{new QFilter("id", "in", queryId)}, null);
        Iterator iterator = null;
        try {
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row2 = ds.next();
                    Long id = row2.getLong("model");
                    if ((permIdSet.contains(id) || this.isBgmdModel(id) || ModelUtil.isBGModel((Long)id)) && !longs.contains(row2.get("id"))) {
                        delete.add(row2.get("id"));
                        mappingIds.add(row2.getLong("id"));
                        if (SysDimensionEnum.Entity.getNumber().equals(row2.getString("dimnumber"))) {
                            bussModelIds.add(row2.getLong("bussmodel"));
                        }
                        DelNumber.add(row2.getString("number"));
                        continue;
                    }
                    if ((permIdSet.contains(id) || this.isBgmdModel(id) || ModelUtil.isBGModel((Long)id)) && longs.contains(row2.get("id"))) {
                        noDelByMappingNumber.add(row2.getString("number"));
                        continue;
                    }
                    noDelNumber.add(row2.getString("number"));
                }
            }
        }
        catch (Throwable row2) {
            iterator = row2;
            throw row2;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)((Object)iterator)).addSuppressed(row2);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (delete.size() != 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])delete.toArray());
            BgMemMappingServiceHelper.clearCacheByMapping(mappingIds);
            for (Long bussModelId : bussModelIds) {
                BgLockCacheServiceHelper.reloadCache((Long)this.getModelId(), (Long)bussModelId);
            }
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "DimMemberMappingListPlugin_15", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "DimMemberMappingListPlugin_16", "epm-eb-formplugin"));
        }
        if (DelNumber.size() != 0) {
            row = null;
            for (String k : DelNumber) {
                if (row == null) {
                    row = k;
                    continue;
                }
                row = row + "," + k;
            }
            message = ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\u201c%1\u201d\u5220\u9664\u6210\u529f\u3002", (String)"DimMemberMappingListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{row});
        }
        if (noDelByMappingNumber.size() != 0) {
            row = null;
            for (String k : noDelByMappingNumber) {
                if (row == null) {
                    row = k;
                    continue;
                }
                row = row + "," + k;
            }
            message = message != null ? ResManager.loadResFormat((String)"\u201c%1\u201d\u7f16\u7801\u4e3a\u201c%2\u201d\u7684\u6570\u636e\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8be5\u884c\u5df2\u88ab\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u5f15\u7528\u3002", (String)"DimMemberMappingListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{message, row}) : ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u6570\u636e\u5220\u9664\u5931\u8d25\uff0c\u8be5\u884c\u5df2\u88ab\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u5f15\u7528\u3002", (String)"DimMemberMappingListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{row});
            this.getView().showTipNotification(message, Integer.valueOf(5000));
        }
        if (noDelNumber.size() != 0) {
            row = null;
            for (String k : noDelNumber) {
                if (row == null) {
                    row = k;
                    continue;
                }
                row = row + "," + k;
            }
            message = message != null ? ResManager.loadResFormat((String)"\u201c%1\u201d\u7f16\u7801\u4e3a\u201c%2\u201d\u7684\u6570\u636e\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u60a8\u6ca1\u6709\u8be5\u6761\u5185\u4f53\u7cfb\u7684\u6743\u9650\u3002", (String)"DimMemberMappingListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{message, row}) : ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u6570\u636e\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0:\u6ca1\u6709\u8be5\u6570\u636e\u7684\u4f53\u7cfb\u6743\u9650\u3002", (String)"DimMemberMappingListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{row});
            this.getView().showTipNotification(message, Integer.valueOf(5000));
        }
        if (noDelNumber.size() == 0 && noDelByMappingNumber.size() == 0) {
            message = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DimMemberMappingListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(message);
        }
        this.refreshData();
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList bl = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection sRows = bl.getSelectedRows();
        Object pkId = ((BillList)this.getView().getControl(BILLLISTAP)).getSelectedRows().get(sRows.size() - 1).getPrimaryKeyValue();
        this.modify(pkId);
    }

    private void modify(Object pkId) {
        DynamicProperty model1 = this.getModel().getDataEntityType().getProperty("model");
        if (model1 != null) {
            ApplicationTypeEnum application = ApplicationTypeEnum.EB;
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            Set permIdSet = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
            Set haspermids = FunPermissionHelper.getEffectiveByPermModel((String)this.getView().getEntityId(), (ApplicationTypeEnum)application);
            Set perRoleids = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application, (String)this.getView().getEntityId(), (String)"47150e89000000ac");
            permIdSet.addAll(haspermids);
            permIdSet.addAll(perRoleids);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimmembermapping", (String)"model", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            if (permIdSet.contains(dynamicObject.getLong("model")) || this.isBgmdModel(model.getLong("id")) || ModelUtil.isBGModel((Long)this.getModelId())) {
                HashMap<String, String> openParameter = new HashMap<String, String>(16);
                openParameter.put("formId", "eb_dimmembermapping");
                openParameter.put("pkId", String.valueOf(pkId));
                FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    formShowParameter.setParentPageId(parentView.getPageId());
                    String menuPageID = pkId + "DIMMEM" + parentView.getPageId();
                    IFormView childFormView = parentView.getView(menuPageID);
                    if (childFormView != null) {
                        childFormView.activate();
                        this.getView().sendFormAction(childFormView);
                    } else {
                        formShowParameter.setPageId(menuPageID);
                        this.getView().showForm(formShowParameter);
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u4fee\u6539\u8be5\u6761\u8bb0\u5f55\u7684\u6743\u9650\u3002", (String)"DimMemberMappingListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            IFormView childFormView;
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "eb_dimmembermapping");
            openParameter.put("pkId", String.valueOf(pkId));
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                formShowParameter.setParentPageId(parentView.getPageId());
            }
            if ((childFormView = this.getView().getView(formShowParameter.getPageId())) != null) {
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            } else {
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private boolean isBgmdModel(Long id) {
        DynamicObject model_new = ModelUtils.getModel((Long)id);
        String reporttype = model_new.getString("reporttype");
        return reporttype.equals("7");
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        if (e.getSource() instanceof BillList && BILLLISTAP.equals((billList = (BillList)e.getSource()).getKey())) {
            e.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and("isfreetype", "=", (Object)Boolean.FALSE));
        }
    }

    private Set<Long> queryDimrule(Long id) {
        DynamicObject[] query;
        HashSet<Long> Dimmatarule = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : query = BusinessDataServiceHelper.load((String)"eb_dimmaterule", (String)"subentryentity.entrydimsionmap,subentryentity.accountdimsionmap,subentryentity.yeardimsionmap,subentryentity.currencydimsionmap,subentryentity.userdefined1dimsionmap,subentryentity.userdefined2dimsionmap,subentryentity.userdefined3dimsionmap,subentryentity.userdefined4dimsionmap,subentryentity.userdefined5dimsionmap,subentryentity.userdefined6dimsionmap", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)id)})) {
            DynamicObjectCollection entryentityCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entryentity : entryentityCollection) {
                DynamicObjectCollection subentryentityCollection = entryentity.getDynamicObjectCollection(SUBENTRYENTITY);
                for (DynamicObject subentryentity : subentryentityCollection) {
                    if ((DynamicObject)subentryentity.get("entrydimsionmap") != null) {
                        Dimmatarule.add(((DynamicObject)subentryentity.get("entrydimsionmap")).getLong("id"));
                    }
                    if ((DynamicObject)subentryentity.get("accountdimsionmap") != null) {
                        Dimmatarule.add(((DynamicObject)subentryentity.get("accountdimsionmap")).getLong("id"));
                    }
                    if ((DynamicObject)subentryentity.get("yeardimsionmap") != null) {
                        Dimmatarule.add(((DynamicObject)subentryentity.get("yeardimsionmap")).getLong("id"));
                    }
                    if ((DynamicObject)subentryentity.get("currencydimsionmap") != null) {
                        Dimmatarule.add(((DynamicObject)subentryentity.get("currencydimsionmap")).getLong("id"));
                    }
                    for (int i = 1; i <= 6; ++i) {
                        if ((DynamicObject)subentryentity.get("userdefined" + i + "dimsionmap") == null) continue;
                        Dimmatarule.add(((DynamicObject)subentryentity.get("userdefined" + i + "dimsionmap")).getLong("id"));
                    }
                }
            }
        }
        return Dimmatarule;
    }

    private void openImportPage() {
        HashMap<String, String> importMessageMap = new HashMap<String, String>(16);
        HashMap<List<String>, String> entryentityMap = new HashMap<List<String>, String>(16);
        if (!this.isSelectRowAndGetImportMessage(importMessageMap, entryentityMap)) {
            return;
        }
        String serImportMessageMap = SerializationUtils.serializeToBase64(importMessageMap);
        String serEntryentityMap = SerializationUtils.serializeToBase64(entryentityMap);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_dimmappingimport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("importMessageMap", (Object)serImportMessageMap);
        showParameter.setCustomParam("entryentityMap", (Object)serEntryentityMap);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPage");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private boolean isSelectRowAndGetImportMessage(Map<String, String> importMessageMap, Map<List<String>, String> entryentityMap) {
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u5bfc\u5165\u3002", (String)"DimMemberMappingListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6620\u5c04\u65b9\u6848\u3002", (String)"DimMemberMappingListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        try {
            String selectField = "model,number,name,useassistdata,bussmodel,businessbasedata,businessbasedataext,dimnumber,entryentity.biznumber,entryentity.dimmemnumber,entryentity.biznumberext,usemorebussdata,usemoreassistdata,entryentity.assistmorebussdata";
            DynamicObject doc = BusinessDataServiceHelper.loadSingle((String)"eb_dimmembermapping", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            long id = ((DynamicObject)doc.get("model")).getLong("id");
            if (!(this.isLimit(id) || CommonUtils.isBgmdModel((Long)id) || ModelUtil.isBGModel((Long)id))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u4f53\u7cfb\u7684\u6743\u9650\u3002", (String)"DimMemberMappingListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            Object bussmodel = doc.get("bussmodel");
            if (bussmodel != null) {
                String busModelId = ((DynamicObject)bussmodel).getString("id");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)busModelId, (String)"eb_businessmodel");
                DynamicObjectCollection viewentry = dynamicObject.getDynamicObjectCollection("viewentry");
                for (DynamicObject object : viewentry) {
                    String dimNumber;
                    DynamicObject dimension = object.getDynamicObject("dimension");
                    if (dimension == null || !org.apache.commons.lang3.StringUtils.equals((CharSequence)(dimNumber = dimension.getString("number")), (CharSequence)doc.getString("dimnumber"))) continue;
                    IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)id);
                    Long viewId = modelCache.getViewByBusModelAndDimNumber(IDUtils.toLong((Object)busModelId), dimNumber);
                    if (viewId == null || viewId == 0L) break;
                    importMessageMap.put("viewId", String.valueOf(viewId));
                    break;
                }
            }
            importMessageMap.put("modelNumber", ((DynamicObject)doc.get("model")).getString("shownumber"));
            importMessageMap.put("modelId", ((DynamicObject)doc.get("model")).getString("id"));
            importMessageMap.put("busModelId", doc.getString("bussmodel.id"));
            importMessageMap.put("number", doc.getString("number"));
            importMessageMap.put("name", doc.getString("name"));
            importMessageMap.put("businessbasedata", doc.getString("businessbasedata"));
            importMessageMap.put("dimnumber", doc.getString("dimnumber"));
            importMessageMap.put("primaryKeyValue", primaryKeyValue.toString());
            importMessageMap.put("businessbasedataext", doc.getString("businessbasedataext"));
            importMessageMap.put("useassistdata", doc.getString("useassistdata"));
            importMessageMap.put("usemorebussdata", doc.getString("usemorebussdata"));
            importMessageMap.put("usemoreassistdata", doc.getString("usemoreassistdata"));
            DynamicObjectCollection docs = (DynamicObjectCollection)doc.get(ENTRYENTITY);
            for (DynamicObject doj : docs) {
                ArrayList<String> bizList = new ArrayList<String>(16);
                bizList.add(doj.getString("biznumber"));
                bizList.add(doj.getString("biznumberext"));
                entryentityMap.put(bizList, doj.getString("dimmemnumber"));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return true;
    }

    public boolean isLimit(Long id) {
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        application = ApplicationTypeEnum.EB;
        Set permIdSet = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
        Set haspermids = FunPermissionHelper.getEffectiveByPermModel((String)this.getView().getEntityId(), (ApplicationTypeEnum)application);
        Set perRoleids = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application, (String)this.getView().getEntityId(), (String)"47150e89000000ac");
        permIdSet.addAll(haspermids);
        permIdSet.addAll(perRoleids);
        return permIdSet.contains(id);
    }

    public void history() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if (billList != null && billList.getFocusRowPkId() != null) {
            DynamicObject mapping = BusinessDataServiceHelper.loadSingle((Object)billList.getFocusRowPkId(), (String)"eb_dimmembermapping");
            if (mapping != null) {
                HashMap<String, String> params = new HashMap<String, String>(16);
                params.put("MAPPING_ID", mapping.getString("id"));
                params.put("MODEL", (String)mapping.getDynamicObject("model"));
                params.put("BUSINESSDATABASE", mapping.getString("businessbasedata"));
                params.put("DIMENSION", mapping.getString("dimnumber"));
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("eb_dimmemberhistorylist");
                parameter.setCustomParams(params);
                parameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u6210\u5458\u6620\u5c04\u8bb0\u5f55", (String)"DimMemberMappingListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6620\u5c04\u5173\u7cfb\u8bb0\u5f55\u3002", (String)"DimMemberMappingListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if ("model".equals(key)) {
            BasedataEdit b = ControlModelFuzzySearchCommon.getInstance().reBuildBasedataEdit(key);
            b.setView(this.getView());
            b.setModel(this.getModel());
            b.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            b.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
            e.setControl((Control)b);
        }
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }

    private void setDTAndATVisible() {
        DynamicObject model = ModelUtils.getModel((Long)this.getModelId());
        String reportType = model.getString("reporttype");
        Long bussmodel = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("bussmodel"));
        if (IDUtils.isEmptyLong((Long)bussmodel).booleanValue()) {
            if (this.getView().getControl("bussmodel") != null) {
                if (ApplicationTypeEnum.isBGMD((String)reportType)) {
                    ((ListColumn)this.getView().getControl("bussmodel")).setVisible(11);
                } else {
                    ((ListColumn)this.getView().getControl("bussmodel")).setVisible(0);
                }
            } else {
                BillList list = (BillList)this.getControl(BILLLISTAP);
                IListColumn column = list.getShowListColumns().stream().filter(item -> "bussmodel.name".equals(item.getListFieldKey())).findFirst().get();
                if (ApplicationTypeEnum.isBGMD((String)reportType)) {
                    column.setVisible(11);
                } else {
                    column.setVisible(0);
                }
            }
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                return allRows;
            }
        });
    }

    public String getModelFieldKey() {
        return "model";
    }

    @Override
    protected void addColumnKeysToHide(Set<String> colsToHide) {
        super.addColumnKeysToHide(colsToHide);
        Long modelId = this.getModelId();
        ModelUtil.hideBussModelNameByEbOrBgModel(colsToHide, (Long)modelId);
    }
}

