/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.EbRangeMappingEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.mapping.DimMappingImportUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class EbDimMappingImportUtils
extends DimMappingImportUtils {
    private static final String EB_EBDIMMEMBERMAP = "eb_ebdimmembermap";

    public static EbDimMappingImportUtils get() {
        return new EbDimMappingImportUtils();
    }

    @Override
    public boolean importByStream(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull TempFileCacheDownloadable.Content content, @NotNull Map<String, String> importConfigMap, StringBuilder errorMsg, Set<Long> bussModelIds) {
        Workbook dataBook;
        XSSFWorkbook errorBook = new XSSFWorkbook();
        boolean result = false;
        this.dealImportConfigMap(importConfigMap);
        DimMappingImportUtils.ItemImportConfig config = new DimMappingImportUtils.ItemImportConfig();
        config.bizAppId = AppMetadataCache.getAppInfo((String)view.getFormShowParameter().getAppId()).getId();
        config.bizEntityNumber = dataModel.getDataEntityType().getName();
        config.modelId = Long.valueOf(importConfigMap.get("modelId"));
        config.dimNumber = importConfigMap.get("dimnumber");
        config.itemMappingId = Long.valueOf(importConfigMap.get("primaryKeyValue"));
        config.entityNumber = importConfigMap.get("businessbasedata");
        config.extEntityNumber = importConfigMap.get("businessbasedataext");
        if ("gl_org".equals(config.extEntityNumber)) {
            config.extEntityNumber = "bos_org";
        }
        config.hasMoreData = this.hasUseMoreBizData(importConfigMap);
        config.hasAssistData = this.hasUseAssistData(importConfigMap);
        DynamicObject itemMapping = this.getItemMapping(config.itemMappingId);
        if (itemMapping == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingImportUtils_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        try {
            dataBook = WorkbookFactory.create((InputStream)content.getInputStream());
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6587\u6863\u3002", (String)"EbDimMappingImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Sheet sheet = dataBook.getSheetAt(0);
        this.checkStyle(config, sheet, content.getFilename());
        POIUtils.POIConfig poiConfig = new POIUtils.POIConfig();
        poiConfig.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
        POIUtils.get().copyBook(dataBook, (Workbook)errorBook, poiConfig);
        Sheet errorSheet = errorBook.getSheetAt(0);
        config.errorBook = errorBook;
        config.errorSheet = errorSheet;
        boolean hasCover = this.hasCover(dataModel);
        List<DimMappingImportUtils.ItemMapping> mappings = this.getImportData(config, sheet, itemMapping, hasCover);
        this.checkMember(config, mappings);
        if (this.checkErrorInfo(config)) {
            result = this.update(itemMapping, config, mappings, hasCover);
        } else {
            POIUtils.downloadFile((IFormView)view, (Workbook)config.errorBook);
            if (errorMsg.length() > 0) {
                errorMsg.append("\r\n");
            }
            errorMsg.append(ResManager.loadResFormat((String)"\u6587\u4ef6%1\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u8be6\u60c5\u3002", (String)"TaskDispatchImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{content.getFilename()}));
        }
        return result;
    }

    @Override
    protected boolean isWildcardstatus(DynamicObject _entry) {
        return false;
    }

    @Override
    protected String getMappingEntityNumber() {
        return EB_EBDIMMEMBERMAP;
    }

    @Override
    protected DimMappingImportUtils.ItemMapping createItemMapping() {
        return new EbItemMapping();
    }

    @Override
    protected void dealImportConfigMap(@NotNull Map<String, String> importConfigMap) {
        String entityNumber = importConfigMap.get("businessbasedata");
        if ("bos_org".equalsIgnoreCase(entityNumber = this.modifyData(entityNumber))) {
            importConfigMap.put("businessbasedata", EbDimMappingImportUtils.dealEntityNumber("bos_org"));
        }
    }

    private String modifyData(String businessbasedata) {
        if (StringUtils.isNotEmpty((String)businessbasedata) && "gl_org".equals(businessbasedata)) {
            businessbasedata = "bos_org";
        }
        return businessbasedata;
    }

    @Override
    protected boolean update(@NotNull DynamicObject itemMapping, @NotNull DimMappingImportUtils.ItemImportConfig config, @NotNull List<DimMappingImportUtils.ItemMapping> mappings, boolean hasCover) {
        DynamicObjectCollection _entries = itemMapping.getDynamicObjectCollection("entryentity");
        StringBuilder key = new StringBuilder();
        HashMap entryKeys = Maps.newHashMapWithExpectedSize((int)_entries.size());
        if (hasCover) {
            _entries.clear();
        } else {
            for (DynamicObject entry : _entries) {
                entryKeys.put(this.getEntryKey(entry, config), entry);
            }
        }
        for (DimMappingImportUtils.ItemMapping item : mappings) {
            DynamicObject _entry = (DynamicObject)entryKeys.get(item.getKey(config));
            if (_entry == null) {
                _entry = _entries.addNew();
            }
            _entry.set("morebussdata", (Object)("bos_org".equals(item.entityNumber) ? "gl_org" : item.entityNumber));
            _entry.set("showbizmember", (Object)item.bizName);
            _entry.set("biznumber", (Object)(item.wildcard ? item.bizNumber + '%' : item.bizNumber));
            _entry.set("bizmember", (Object)item.bizId);
            _entry.set("range", (Object)item.getRange());
            _entry.set("showbizmemberext", (Object)item.extBizName);
            _entry.set("biznumberext", (Object)(item.extWildcard ? item.extBizNumber + '%' : item.extBizNumber));
            _entry.set("bizmemberext", (Object)item.extBizId);
            _entry.set("dimmember", (Object)item.acMemberId);
            _entry.set("dimmemnumber", (Object)item.acNumber);
            _entry.set("showdimmember", (Object)item.acName);
            _entry.set("entrystatus", (Object)Character.valueOf('1'));
        }
        _entries.sort((o1, o2) -> {
            String key2;
            String key1;
            if (config.hasMoreData) {
                key1 = o1.getString("morebussdata") + '@' + o1.getString("biznumber");
                key2 = o2.getString("morebussdata") + '@' + o2.getString("biznumber");
            } else {
                key1 = o1.getString("biznumber");
                key2 = o2.getString("biznumber");
            }
            int re = key1.compareTo(key2);
            if (re == 0) {
                if (config.hasAssistData) {
                    key1 = o1.getString("biznumberext");
                    key2 = o2.getString("biznumberext");
                    re = key1.compareTo(key2);
                }
                if (re == 0) {
                    re = o1.getString("dimmemnumber").compareTo(o2.getString("dimmemnumber"));
                }
            }
            return re;
        });
        int in = _entries.size();
        for (int i = 0; i < in; ++i) {
            ((DynamicObject)_entries.get(i)).set("seq", (Object)i);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemMapping});
        this.writeLog(config.bizAppId, config.bizEntityNumber);
        return true;
    }

    @Override
    protected String getEntryKey(DynamicObject entry, @NotNull DimMappingImportUtils.ItemImportConfig config) {
        if (entry == null) {
            return null;
        }
        StringBuilder entryKey = new StringBuilder();
        entryKey.append(entry.getString("biznumber")).append('#');
        if (config.hasAssistData && StringUtils.isNotEmpty((String)entry.getString("biznumberext"))) {
            entryKey.append('#').append(entry.getString("biznumberext"));
        }
        return entryKey.toString();
    }

    @Override
    protected void checkStyle(@NotNull DimMappingImportUtils.ItemImportConfig config, @NotNull Sheet sheet, String fileName) {
        block5: {
            try {
                Cell cell;
                Row row = sheet.getRow(0);
                Cell cell2 = cell = row != null ? row.getCell(0) : null;
                if (cell == null || !cell.getStringCellValue().contains("")) {
                    // empty if block
                }
                if ((row = sheet.getRow(2)) != null) {
                    String[] heads = EbDimMappingImportUtils.getHeadInfo(config);
                    for (int i = 0; i < heads.length; ++i) {
                        cell = row.getCell(i);
                        if (cell == null || cell.getStringCellValue().contains(heads[i]) || (cell = row.getCell(i)) != null && cell.getStringCellValue().contains(heads[i])) continue;
                        throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DimMappingImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
                    }
                    break block5;
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u5934\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u4ef6\u201c%1\u201d\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DimMappingImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{fileName}));
            }
        }
    }

    protected static String[] getHeadInfo(@NotNull DimMappingImportUtils.ItemImportConfig config) {
        LinkedList heads = Lists.newLinkedList();
        if (config.hasMoreData) {
            heads.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMemberMappingListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMemberMappingListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"DimMappingImportPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        heads.add(ResManager.loadKDString((String)"\u8303\u56f4", (String)"DimMemberMappingListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        heads.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"DimMemberMappingListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        heads.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"DimMemberMappingListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (config.hasAssistData) {
            heads.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"DimMappingImportUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            heads.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"DimMappingImportUtils_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return heads.toArray(new String[0]);
    }

    protected static class EbItemMapping
    extends DimMappingImportUtils.ItemMapping {
        protected EbItemMapping() {
        }

        @Override
        public void loadRowData(@NotNull Row row, @NotNull DimMappingImportUtils.ItemImportConfig config) {
            int colIndex = 0;
            this.rowIndex = row.getRowNum();
            if (config.hasMoreData) {
                int n = ++colIndex;
                this.entityNumber = POIUtils.getStringValue((Cell)row.getCell(n));
            }
            int n = ++colIndex;
            this.bizName = POIUtils.getStringValue((Cell)row.getCell(n));
            int n2 = ++colIndex;
            ++colIndex;
            this.bizNumber = POIUtils.getStringValue((Cell)row.getCell(n2));
            if (this.bizNumber != null && this.bizNumber.length() > 0 && '%' == this.bizNumber.charAt(this.bizNumber.length() - 1)) {
                this.wildcard = true;
                this.bizNumber = this.bizNumber.substring(0, this.bizNumber.length() - 1);
                this.range = "";
            } else {
                EbRangeMappingEnum r;
                String rangeStr;
                this.range = "";
                if (!StringUtils.isEmpty((String)(rangeStr = POIUtils.getStringValue((Cell)row.getCell(colIndex++)))) && (r = EbRangeMappingEnum.getRangeByName((String)rangeStr)) != null) {
                    this.range = String.valueOf(r.getIndex());
                }
            }
            this.acName = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
            this.acNumber = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
            if (config.hasAssistData) {
                this.extBizName = POIUtils.getStringValue((Cell)row.getCell(colIndex++));
                this.extBizNumber = POIUtils.getStringValue((Cell)row.getCell(colIndex));
            }
        }

        @Override
        protected boolean hasRange() {
            return false;
        }

        @Override
        protected boolean isCheckRangeDetail() {
            return false;
        }

        @Override
        public String getKey(@NotNull DimMappingImportUtils.ItemImportConfig config) {
            StringBuilder itemKey = new StringBuilder();
            itemKey.append(this.bizNumber);
            if (this.wildcard) {
                itemKey.append('%');
            }
            itemKey.append('#');
            if (config.hasAssistData && StringUtils.isNotEmpty((String)this.extBizNumber)) {
                itemKey.append('#').append(this.extBizNumber);
                if (this.extWildcard) {
                    itemKey.append('%');
                }
            }
            return itemKey.toString();
        }
    }
}

