/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.google.common.collect.Sets;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.mapping.CheckResult;

class WhiteListCheck {
    private static final int MAX_STR_LENGTH = 50;

    WhiteListCheck() {
    }

    public CheckResult validate(DynamicObject whiteList, int srcEntrySize) {
        DynamicObjectCollection entries;
        DynamicObjectCollection bill;
        CheckResult result = new CheckResult();
        if (whiteList == null) {
            result.append(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WhiteListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), -1);
            return result;
        }
        String number = whiteList.getString("number");
        String check = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((String)check)) {
            result.append(check, -1);
        }
        if ((bill = whiteList.getDynamicObjectCollection("bill")) == null || bill.isEmpty()) {
            result.append(ResManager.loadKDString((String)"\u767d\u540d\u5355\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WhiteListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), -1);
        }
        if ((entries = whiteList.getDynamicObjectCollection("entryentity")) == null || entries.isEmpty()) {
            result.append(ResManager.loadKDString((String)"\u63a7\u5236\u540d\u5355\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WhiteListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), -1);
        } else {
            boolean useExtData = whiteList.getBoolean("useextbiz");
            HashSet whiteKey = Sets.newHashSetWithExpectedSize((int)entries.size());
            int in = entries.size();
            for (int i = 0; i < in; ++i) {
                boolean extBizExistFlag;
                String key;
                DynamicObject entry = (DynamicObject)entries.get(i);
                int rowIndex = i + 1;
                int tipRowIndex = rowIndex - srcEntrySize;
                if (StringUtils.isEmpty((String)entry.getString("biztype"))) {
                    result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WhiteListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)entry.getString("biztype")) && entry.getString("biztype").length() > 50) {
                    result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"WhiteListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                }
                if (StringUtils.isEmpty((String)(key = entry.getString("biznumber")))) {
                    result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WhiteListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                } else if (key.length() > 50) {
                    result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"WhiteListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                }
                if (StringUtils.isNotEmpty((String)entry.getString("bizname")) && entry.getString("bizname").length() > 50) {
                    result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"WhiteListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                }
                boolean bl = extBizExistFlag = StringUtils.isNotEmpty((String)entry.getString("extbiztype")) || StringUtils.isNotEmpty((String)entry.getString("extbiznumber")) || StringUtils.isNotEmpty((String)entry.getString("extbizname"));
                if (!useExtData && extBizExistFlag) {
                    result.append(ResManager.loadResFormat((String)"\u767d\u540d\u5355\u672a\u542f\u7528\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\uff0c\u65e0\u6cd5\u5bfc\u5165\u5206\u5f55\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u201c%1\u201d\u7684\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"WhiteListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{entry.getString("biznumber")}), rowIndex);
                }
                if (useExtData) {
                    String bizType = entry.getString("biztype");
                    String extBizType = entry.getString("extbiztype");
                    if (StringUtils.isNotEmpty((String)extBizType) && bizType.equals(extBizType)) {
                        result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4e0e\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"WhiteListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                    }
                    if (StringUtils.isNotEmpty((String)entry.getString("extbiztype")) && entry.getString("extbiztype").length() > 50) {
                        result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"WhiteListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                    }
                    if (StringUtils.isNotEmpty((String)entry.getString("extbiznumber")) && entry.getString("extbiznumber").length() > 50) {
                        result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"WhiteListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                    }
                    if (StringUtils.isNotEmpty((String)entry.getString("extbizname")) && entry.getString("extbizname").length() > 50) {
                        result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"WhiteListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                    }
                    if (StringUtils.isNotEmpty((String)extBizType) && StringUtils.isEmpty((String)entry.getString("extbiznumber"))) {
                        result.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u6210\u5458\u3002", (String)"WhiteListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[]{tipRowIndex}), rowIndex);
                    }
                }
                if (whiteKey.add(key = this.getWhiteKey(entry, useExtData))) continue;
                check = useExtData && StringUtils.isNotEmpty((String)entry.getString("extbiznumber")) ? ResManager.loadResFormat((String)"\u5206\u5f55\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801(%1)\u53ca\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801(%2)\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WhiteListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{entry.getString("biznumber"), entry.getString("extbiznumber")}) : ResManager.loadResFormat((String)"\u5206\u5f55\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801(%1)\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WhiteListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{entry.getString("biznumber")});
                result.append(check, rowIndex);
            }
        }
        return result;
    }

    public String getWhiteKey(DynamicObject white, boolean useExtBiz) {
        if (useExtBiz && StringUtils.isNotEmpty((String)white.getString("extbiznumber"))) {
            return white.getString("biznumber") + '@' + white.getString("extbiznumber");
        }
        return white.getString("biznumber");
    }
}

