/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class WhiteListExport {
    WhiteListExport() {
    }

    public String export(IFormView view, DynamicObject whitelist) {
        String[] whiteSet;
        int i;
        XSSFCell cell;
        if (view == null || whitelist == null) {
            return null;
        }
        DynamicObjectCollection entries = whitelist.getDynamicObjectCollection("entryentity");
        if (entries == null || entries.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"WhiteSetListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        boolean useExtBiz = whitelist.getBoolean("useextbiz");
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        ArrayList<String> header = new ArrayList<String>();
        header.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599*", (String)"WhiteListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        header.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"WhiteSetListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        header.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"WhiteSetListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (useExtBiz) {
            header.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599", (String)"DimMappingImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            header.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"WhiteSetListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            header.add(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"WhiteSetListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        XSSFRow row = sheet.createRow(0);
        for (int i2 = 0; i2 < header.size(); ++i2) {
            sheet.setColumnWidth(i2, 5000);
            cell = row.createCell(i2, CellType.STRING);
            cell.setCellValue((String)header.get(i2));
            cell.setCellStyle((CellStyle)headerStyle);
        }
        ArrayList whiteLists = Lists.newArrayListWithExpectedSize((int)entries.size());
        for (i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            whiteSet = new String[6];
            whiteSet[0] = entry.getString("biztype");
            whiteSet[1] = entry.getString("biznumber");
            whiteSet[2] = entry.getString("bizname");
            if (useExtBiz) {
                whiteSet[3] = entry.getString("extbiztype");
                whiteSet[4] = entry.getString("extbiznumber");
                whiteSet[5] = entry.getString("extbizname");
            }
            whiteLists.add(whiteSet);
        }
        int in = whiteLists.size();
        for (i = 0; i < in; ++i) {
            whiteSet = (String[])whiteLists.get(i);
            row = sheet.createRow(i + 1);
            for (int j = 0; j < whiteSet.length; ++j) {
                cell = row.createCell(j, CellType.STRING);
                cell.setCellStyle((CellStyle)style);
                cell.setCellValue(whiteSet[j]);
            }
        }
        try {
            return ImportAndExportUtil.writeFile((Workbook)workBook, (String)ResManager.loadKDString((String)"\u63a7\u5236\u767d\u540d\u5355-\u5bfc\u51fa\u6570\u636e", (String)"WhiteSetListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }
}

