/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.utils.BgControlWhiteUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.mapping.WhiteListUtils;
import org.apache.commons.collections4.CollectionUtils;

public class WhiteListListPlugin
extends AbstractListPlugin {
    private static final String SUCCESS = "success";
    private static final String BTN_SET_ORG = "btnsetorg";
    private static final Log log = LogFactory.getLog(WhiteListListPlugin.class);
    private static final String LOG_SPLIT_KEY = ";";
    private static final String LOG_LIST_SPLIT_KEY = ",";
    private static final String LOG_BLANK_SPACE = " ";

    @Override
    public boolean isCheckModel() {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ListGridView list = (ListGridView)this.getView().getControl("gridview");
        list.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btnimport": {
                this.importWhiteList();
                break;
            }
            case "btnexport": {
                this.exportWhiteList();
                break;
            }
            case "btnsetorg": {
                this.openSetOrgPageByList(evt);
                break;
            }
        }
    }

    private void openSetOrgPageByList(ItemClickEvent evt) {
        List collect;
        DynamicObject dynamicObject;
        DynamicObjectCollection orgEntryEntity;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u5206\u914d\u7ec4\u7ec7", (String)"WhiteSetListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setBillNumberSetCache();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_whitelist_setorg_new");
        ArrayList<Long> nameIds = new ArrayList<Long>(16);
        for (ListSelectedRow selectedRow : selectedRows) {
            Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
            nameIds.add(primaryKeyValue);
        }
        Object[] ids = nameIds.toArray(new Long[0]);
        Collection whiteList = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"eb_whitelist").values();
        if (CollectionUtils.isNotEmpty(whiteList) && (orgEntryEntity = (dynamicObject = (DynamicObject)(collect = whiteList.stream().collect(Collectors.toList())).get(0)).getDynamicObjectCollection("orgentryentity")) != null) {
            parameter.setCustomParam("setOrg", (Object)SerializationUtils.serializeToBase64((Object)orgEntryEntity));
        }
        List numbers = whiteList.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        this.getPageCache().put("nameIds", SerializationUtils.toJsonString(nameIds));
        this.getPageCache().put("numbers", SerializationUtils.toJsonString(numbers));
        parameter.setCustomParam("nameIds", (Object)SerializationUtils.toJsonString(nameIds));
        parameter.setCustomParam("source", (Object)"whiteList");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_SET_ORG);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void exportWhiteList() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"WhiteSetListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"WhiteSetListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = selectedRows.get(0);
        DynamicObject whitelist = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"eb_whitelist");
        String url = WhiteListUtils.Export.export(this.getView(), whitelist);
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private void importWhiteList() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u4e00\u884c\u8bb0\u5f55\uff0c\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"WhiteSetListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setBillNumberSetCache();
        ListSelectedRow row = selectedRows.get(0);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_dimmappingimport");
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        Plugin plugin = new Plugin();
        plugin.setClassName(WhiteListUtils.class.getName());
        plugins.add(plugin);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"eb_dimmappingimport");
        formConfig.getPlugins().clear();
        formConfig.setPlugins(plugins);
        showParameter.setFormConfig(formConfig);
        showParameter.setCaption(ResManager.loadKDString((String)"\u79d1\u76ee\u767d\u540d\u5355\u5bfc\u5165", (String)"WhiteSetListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("WHITELIST_ID", row.getPrimaryKeyValue());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "import");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "import": {
                this.closedCallBack_import(evt);
                this.clearCacheByBillSet();
                break;
            }
            case "btnsetorg": {
                this.closedCallBackSetOrgByList(evt);
                this.clearCacheByBillSet();
                break;
            }
        }
    }

    private void setBillNumberSetCache() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u8bb0\u5f55\u3002", (String)"WhiteListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (ListSelectedRow selectedRow : selectedRows) {
            Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
            ids.add(primaryKeyValue);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"eb_whitelist");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)type);
        HashSet<String> billNumberSet = new HashSet<String>(dynamicObjects.length);
        HashSet<String> numberSet = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection bills = (DynamicObjectCollection)dynamicObject.get("bill");
            numberSet.add(dynamicObject.getString("number"));
            for (DynamicObject bill : bills) {
                DynamicObject billDynamicObject = (DynamicObject)bill.get("fbasedataid");
                if (billDynamicObject == null) continue;
                billNumberSet.add(billDynamicObject.getString("number"));
            }
        }
        this.getPageCache().put("billNumberSet", SerializationUtils.serializeToBase64(billNumberSet));
        this.getPageCache().put("numberSet", SerializationUtils.serializeToBase64(numberSet));
    }

    private void clearCacheByBillSet() {
        String billNumberSetStr = this.getPageCache().get("billNumberSet");
        if (StringUtils.isNotEmpty((String)billNumberSetStr)) {
            Set billNumberSet = (Set)SerializationUtils.deSerializeFromBase64((String)billNumberSetStr);
            BgControlWhiteUtils.clearCacheByWhiteList((Set)billNumberSet);
            this.getPageCache().remove("billNumberSet");
        }
    }

    private void closedCallBackSetOrgByList(ClosedCallBackEvent evt) {
        DynamicObject[] whiteList;
        String returnData = (String)evt.getReturnData();
        if (StringUtils.isEmpty((String)returnData)) {
            return;
        }
        Map returnDataMap = (Map)SerializationUtils.deSerializeFromBase64((String)returnData);
        ArrayList<String> delOrgSqlList = new ArrayList<String>(16);
        String insertOrgSql = "insert into t_eb_whiteorgentry(fid,fentryid,fseq,forgbiztype,forgbiznumber,forgbizname,forgbizid) values(?,?,?,?,?,?,?)";
        ArrayList<Object[]> orgParams = new ArrayList<Object[]>(16);
        ArrayList<Long> allNameIds = new ArrayList<Long>(16);
        String nameIdsStr = this.getPageCache().get("nameIds");
        List nameIds = (List)SerializationUtils.fromJsonString((String)nameIdsStr, List.class);
        String delOrgSql = "delete from t_eb_whiteorgentry where fid in (" + StringUtils.join((Collection)nameIds, (String)LOG_LIST_SPLIT_KEY) + ")";
        delOrgSqlList.add(delOrgSql);
        for (Long nameId : nameIds) {
            int seq = 1;
            for (Map.Entry entry : returnDataMap.entrySet()) {
                Map value = (Map)entry.getValue();
                String id = (String)value.get("id");
                String number = (String)value.get("number");
                String name = (String)value.get("name");
                String bizType = (String)value.get("type");
                orgParams.add(new Object[]{nameId, DBServiceHelper.genGlobalLongId(), seq++, bizType, number, name, IDUtils.toLong((Object)id)});
            }
            allNameIds.add(nameId);
        }
        if (CollectionUtils.isNotEmpty(delOrgSqlList)) {
            DBRoute epm = DBRoute.of((String)"epm");
            String join = String.join((CharSequence)LOG_SPLIT_KEY, delOrgSqlList);
            DB.execute((DBRoute)epm, (String)join);
        }
        if (!orgParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertOrgSql, orgParams);
        }
        QFilter filter = new QFilter("id", "in", allNameIds);
        for (DynamicObject dynamicObject : whiteList = BusinessDataServiceHelper.load((String)"eb_whitelist", (String)"id,number,modifier, modifydate", (QFilter[])new QFilter[]{filter})) {
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.update((DynamicObject[])whiteList);
        this.handleSetOrgLog(returnDataMap);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u6210\u529f", (String)"WhiteListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void handleSetOrgLog(Map<String, Map<String, String>> returnDataMap) {
        if (returnDataMap == null) {
            return;
        }
        StringBuilder monitorLogSb = new StringBuilder();
        String userName = UserUtils.getUserName();
        monitorLogSb.append(ResManager.loadKDString((String)"\u7528\u6237\u540d\uff1a", (String)"WhiteListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(userName).append(LOG_SPLIT_KEY);
        String time = DateTimeUtils.formatFromStr((String)(TimeServiceHelper.now() + ""));
        monitorLogSb.append(ResManager.loadKDString((String)"\u65f6\u95f4\uff1a", (String)"WhiteListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(time).append(LOG_SPLIT_KEY);
        String numbersStr = this.getPageCache().get("numbers");
        List numbers = (List)SerializationUtils.fromJsonString((String)numbersStr, List.class);
        String numberStr = ResManager.loadKDString((String)"\u7f16\u7801\uff1a", (String)"WhiteListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        monitorLogSb.append(numberStr).append(StringUtils.join((Collection)numbers, (String)LOG_LIST_SPLIT_KEY)).append(LOG_SPLIT_KEY);
        StringBuilder operationLogSb = new StringBuilder();
        operationLogSb.append(numberStr).append(StringUtils.join((Collection)numbers, (String)LOG_LIST_SPLIT_KEY)).append(LOG_SPLIT_KEY);
        String setOrgsStr = ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\uff1a", (String)"WhiteListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        monitorLogSb.append(setOrgsStr);
        operationLogSb.append(setOrgsStr);
        for (Map.Entry<String, Map<String, String>> entry : returnDataMap.entrySet()) {
            Map<String, String> value = entry.getValue();
            String number = value.get("number");
            String name = value.get("name");
            String bizType = value.get("type");
            monitorLogSb.append(bizType).append(LOG_BLANK_SPACE).append(number).append(LOG_BLANK_SPACE).append(name).append(LOG_LIST_SPLIT_KEY);
            operationLogSb.append(bizType).append(LOG_BLANK_SPACE).append(number).append(LOG_LIST_SPLIT_KEY);
        }
        if (!returnDataMap.isEmpty()) {
            monitorLogSb.setLength(monitorLogSb.length() - 1);
            operationLogSb.setLength(operationLogSb.length() - 1);
        }
        String monitorLog = monitorLogSb.toString();
        log.info("whitelistlist_setorg:" + monitorLog);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u767d\u540d\u5355\u5217\u8868\u5206\u914d\u7ec4\u7ec7", "WhiteListPlugin_29", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)"eb_whitelist", null, null, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5206\u914d\u7ec4\u7ec7\u6210\u529f", "WhiteListPlugin_43", "epm-eb-formplugin"), null);
    }

    private void closedCallBack_import(ClosedCallBackEvent evt) {
        String returnData = (String)evt.getReturnData();
        if (StringUtils.isEmpty((String)returnData)) {
            return;
        }
        if (SUCCESS.equals(returnData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"WhiteListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            OperationLogUtil.log((String)this.getBizAppId(), (String)"eb_whitelist", null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165", "WhiteListPlugin_37", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f", "WhiteListPlugin_38", "epm-eb-formplugin"), null);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "delete".equals((operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            this.setBillNumberSetCache();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = evt.getOperateKey()) {
            case "delete": {
                if (!evt.getOperationResult().isSuccess()) break;
                this.clearCacheByBillSet();
                String numberSetStr = this.getPageCache().get("numberSet");
                if (!StringUtils.isNotEmpty((String)numberSetStr)) break;
                Set numberSet = (Set)SerializationUtils.deSerializeFromBase64((String)numberSetStr);
                OperationLogUtil.log((String)this.getBizAppId(), (String)"eb_whitelist", null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "WhiteListPlugin_39", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", "WhiteListPlugin_40", "epm-eb-formplugin"), (String[])new String[]{StringUtils.join((Collection)numberSet, (String)LOG_LIST_SPLIT_KEY)});
                this.getPageCache().remove("numberSet");
                break;
            }
        }
    }
}

