/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.utils.BgControlWhiteUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.mapping.CheckResult;
import kd.epm.eb.formplugin.mapping.WhiteListUtils;
import org.apache.commons.collections4.CollectionUtils;

public class WhiteListPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final Log log = LogFactory.getLog(WhiteListPlugin.class);
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_REGISTER = "btnregister";
    private static final String BTN_ENABLE = "btnenable";
    private static final String BTN_DISABLE = "btndisable";
    private static final String SEL_USEEXTBIZ = "useextbiz";
    private static final String BIZTYPE = "biztype";
    private static final String EXTBIZTYPE = "extbiztype";
    private static final String BIZNUMBER = "biznumber";
    private static final String EXTBIZNUMBER = "extbiznumber";
    private static final String BTN_SET_ORG = "btnsetorg";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String ORG_TOOL_BARAP = "advcontoolbarap1";
    private static final String ORG_ENTRY_ENTITY = "orgentryentity";
    private static final String ORG_BIZ_TYPE = "orgbiztype";
    private static final String ORG_BIZ_NUMBER = "orgbiznumber";
    private static final String ORG_BIZ_NAME = "orgbizname";
    private static final String ORG_BIZ_ID = "orgbizid";
    private static final String LOG_SPLIT_KEY = ";";
    private static final String LOG_LIST_SPLIT_KEY = ",";
    private static final String LOG_BLANK_SPACE = " ";
    private static final String WHITE_TYPE = "1";
    private static final String BLACK_TYPE = "2";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", ORG_TOOL_BARAP});
        this.addClickListeners(new String[]{"entryentity", BIZNUMBER, EXTBIZNUMBER});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = IDUtils.toLong(this.getFormCustomParam("MODELID"));
        if (IDUtils.isNull((Long)modelId)) {
            this.getModel().setValue("model", (Object)modelId);
        } else {
            this.getModel().setValue("model", (Object)0L);
        }
        Long busModelId = IDUtils.toLong(this.getFormCustomParam("busmodelid"));
        if (IDUtils.isNull((Long)busModelId)) {
            this.getModel().setValue("busmodel", (Object)busModelId);
        } else {
            this.getModel().setValue("busmodel", (Object)0L);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initRegisterBiz();
        this.showExtBiz();
    }

    private void initRegisterBiz() {
        DynamicObjectCollection registerBiz = this.queryRegisterBiz();
        this.initBizType(registerBiz);
        this.initExtBizType(registerBiz);
    }

    private void showExtBiz() {
        Boolean useExtBiz = (Boolean)this.getModel().getValue(SEL_USEEXTBIZ);
        if (useExtBiz.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXTBIZTYPE, EXTBIZNUMBER, "extbizname"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXTBIZTYPE, EXTBIZNUMBER, "extbizname"});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "biznumber": {
                this.closedCallBack_bizData(evt.getReturnData());
                break;
            }
            case "extbiznumber": {
                this.closedCallBack_extBizData(evt.getReturnData());
                break;
            }
            case "register": {
                this.closedCallBack_register(evt.getReturnData());
                break;
            }
            case "btnsetorg": {
                this.closedCallBackSetOrg(evt);
                break;
            }
        }
    }

    private void closedCallBackSetOrg(ClosedCallBackEvent evt) {
        String returnData = (String)evt.getReturnData();
        if (StringUtils.isEmpty((String)returnData)) {
            return;
        }
        Map returnDataMap = (Map)SerializationUtils.deSerializeFromBase64((String)returnData);
        this.getModel().deleteEntryData(ORG_ENTRY_ENTITY);
        for (Map.Entry entry : returnDataMap.entrySet()) {
            Map value = (Map)entry.getValue();
            String id = (String)value.get("id");
            String name = (String)value.get("name");
            String number = (String)value.get("number");
            String bizType = (String)value.get("type");
            int newEntryRow = this.getModel().createNewEntryRow(ORG_ENTRY_ENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ORG_ENTRY_ENTITY, newEntryRow);
            entryRowEntity.set(ORG_BIZ_ID, (Object)id);
            entryRowEntity.set(ORG_BIZ_NUMBER, (Object)number);
            entryRowEntity.set(ORG_BIZ_NAME, (Object)name);
            entryRowEntity.set(ORG_BIZ_TYPE, (Object)bizType);
        }
        this.getView().updateView(ORG_ENTRY_ENTITY);
    }

    private void closedCallBack_bizData(Object returnData) {
        block9: {
            String bizType;
            int rowIndex;
            ListSelectedRowCollection rows;
            block10: {
                boolean nameAndNumberPropertyFlag;
                if (!(returnData instanceof ListSelectedRowCollection) || (rows = (ListSelectedRowCollection)returnData).isEmpty()) break block9;
                rowIndex = this.getSelectRowIndex();
                int maxCount = this.getModel().getEntryRowCount("entryentity");
                HashSet primaryKeys = Sets.newHashSetWithExpectedSize((int)rows.size());
                for (ListSelectedRow row : rows) {
                    primaryKeys.add(row.getPrimaryKeyValue());
                }
                bizType = (String)this.getModel().getValue(BIZTYPE, rowIndex);
                if (rowIndex + rows.size() > maxCount) {
                    this.getModel().batchCreateNewEntryRow("entryentity", rowIndex + rows.size() - maxCount);
                }
                if (!(nameAndNumberPropertyFlag = this.isBizTypeNameAndNumberPropertyExist(bizType))) break block10;
                Map<Object, DynamicObject> bizs = this.queryBiz(primaryKeys, bizType);
                if (bizs == null) break block9;
                int i = 0;
                int _rowIndex = rowIndex;
                int in = rows.size();
                while (i < in) {
                    DynamicObject biz = bizs.get(rows.get(i).getPrimaryKeyValue());
                    if (biz != null) {
                        this.setBizValueByNotNull(_rowIndex, BIZTYPE, bizType, BIZNUMBER, biz.getString("number"), "bizname", biz.getString("name"), "bizid", biz.getLong("id"));
                    } else {
                        this.setBizValueByNull(_rowIndex, BIZNUMBER, "bizname", "bizid");
                    }
                    ++i;
                    ++_rowIndex;
                }
                break block9;
            }
            if (rows != null) {
                int i = 0;
                int _rowIndex = rowIndex;
                int in = rows.size();
                while (i < in) {
                    ListSelectedRow row = rows.get(i);
                    if (row != null) {
                        this.setBizValueByNotNull(_rowIndex, BIZTYPE, bizType, BIZNUMBER, row.getNumber(), "bizname", row.getName(), "bizid", row.getPrimaryKeyValue());
                    } else {
                        this.setBizValueByNull(_rowIndex, BIZNUMBER, "bizname", "bizid");
                    }
                    ++i;
                    ++_rowIndex;
                }
            }
        }
    }

    private void setBizValueByNull(int _rowIndex, String bizNumberKey, String bizNameKey, String bizIdKey) {
        this.getModel().setValue(bizNumberKey, null, _rowIndex);
        this.getModel().setValue(bizNameKey, null, _rowIndex);
        this.getModel().setValue(bizIdKey, null, _rowIndex);
    }

    private void setBizValueByNotNull(int _rowIndex, String bizTypeKey, String bizType, String bizNumberKey, String number, String bizNameKey, String name, String bizIdKey, Object id) {
        this.getModel().setValue(bizTypeKey, (Object)bizType, _rowIndex);
        this.getModel().setValue(bizNumberKey, (Object)number, _rowIndex);
        this.getModel().setValue(bizNameKey, (Object)name, _rowIndex);
        this.getModel().setValue(bizIdKey, id, _rowIndex);
    }

    private boolean isBizTypeNameAndNumberPropertyExist(String bizType) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizType);
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(bizType);
        IDataEntityProperty nameProperty = entityType.findProperty("name");
        IDataEntityProperty numberProperty = entityType.findProperty("number");
        boolean nameAndNumberPropertyFlag = nameProperty != null && numberProperty != null;
        return nameAndNumberPropertyFlag;
    }

    private void closedCallBack_extBizData(Object returnData) {
        block9: {
            String bizType;
            int rowIndex;
            ListSelectedRowCollection rows;
            block10: {
                boolean nameAndNumberPropertyFlag;
                if (!(returnData instanceof ListSelectedRowCollection) || (rows = (ListSelectedRowCollection)returnData).isEmpty()) break block9;
                rowIndex = this.getSelectRowIndex();
                int maxCount = this.getModel().getEntryRowCount("entryentity");
                HashSet primaryKeys = Sets.newHashSetWithExpectedSize((int)rows.size());
                for (ListSelectedRow row : rows) {
                    primaryKeys.add(row.getPrimaryKeyValue());
                }
                bizType = (String)this.getModel().getValue(EXTBIZTYPE, rowIndex);
                if (rowIndex + rows.size() > maxCount) {
                    this.getModel().batchCreateNewEntryRow("entryentity", rowIndex + rows.size() - maxCount);
                }
                if (!(nameAndNumberPropertyFlag = this.isBizTypeNameAndNumberPropertyExist(bizType))) break block10;
                Map<Object, DynamicObject> bizs = this.queryBiz(primaryKeys, bizType);
                if (bizs == null) break block9;
                int i = 0;
                int _rowIndex = rowIndex;
                int in = rows.size();
                while (i < in) {
                    DynamicObject biz = bizs.get(rows.get(i).getPrimaryKeyValue());
                    if (biz != null) {
                        this.setBizValueByNotNull(_rowIndex, EXTBIZTYPE, bizType, EXTBIZNUMBER, biz.getString("number"), "extbizname", biz.getString("name"), "extbizid", biz.getLong("id"));
                    } else {
                        this.setBizValueByNull(_rowIndex, EXTBIZNUMBER, "extbizname", "extbizid");
                    }
                    ++i;
                    ++_rowIndex;
                }
                break block9;
            }
            if (rows != null) {
                int i = 0;
                int _rowIndex = rowIndex;
                int in = rows.size();
                while (i < in) {
                    ListSelectedRow row = rows.get(i);
                    if (row != null) {
                        this.setBizValueByNotNull(_rowIndex, EXTBIZTYPE, bizType, EXTBIZNUMBER, row.getNumber(), "extbizname", row.getName(), "extbizid", row.getPrimaryKeyValue());
                    } else {
                        this.setBizValueByNull(_rowIndex, EXTBIZNUMBER, "extbizname", "extbizid");
                    }
                    ++i;
                    ++_rowIndex;
                }
            }
        }
    }

    private void closedCallBack_register(Object returnData) {
        this.initRegisterBiz();
    }

    private Map<Object, DynamicObject> queryBiz(Set<Object> primaryKeys, String entityNumber) {
        if (primaryKeys == null || primaryKeys.isEmpty()) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", primaryKeys));
        Map bizs = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)"id,name,number", (QFilter[])builder.toArrays());
        if (bizs == null || bizs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8be5\u6570\u636e\u5bf9\u5e94\u7684\u7f16\u7801\u6216\u540d\u79f0\u3002", (String)"WhiteSetPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        for (DynamicObject biz : bizs.values()) {
            if (biz.getString("number") == null || biz.getString("number").isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8be5\u6570\u636e\u5bf9\u5e94\u7684\u7f16\u7801\u3002", (String)"WhiteSetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (biz.getString("name") != null && !biz.getString("name").isEmpty()) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u5e94\u7684\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"WhiteSetPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return bizs;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "biznumber": {
                this.clickBiz(evt);
                break;
            }
            case "extbiznumber": {
                this.clickExtBiz(evt);
                break;
            }
        }
    }

    private void clickBiz(EventObject evt) {
        int rowIndex = this.checkSelectEntry();
        if (rowIndex >= 0) {
            Object _bizType = this.getModel().getValue(BIZTYPE, rowIndex);
            String _formId = (String)_bizType;
            if (StringUtils.isEmpty((String)_formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"WhiteListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.clickBizType(BIZNUMBER, _formId);
        }
    }

    private void clickExtBiz(EventObject evt) {
        int rowIndex = this.checkSelectEntry();
        if (rowIndex >= 0) {
            Object _bizType = this.getModel().getValue(EXTBIZTYPE, rowIndex);
            String _formId = (String)_bizType;
            if (StringUtils.isEmpty((String)_formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"WhiteListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.clickBizType(EXTBIZNUMBER, _formId);
        }
    }

    private int getSelectRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        return entryGrid.getEntryState().getFocusRow();
    }

    private int checkSelectEntry() {
        int rowIndex = this.getSelectRowIndex();
        if (rowIndex < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c", (String)"WhiteListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return rowIndex;
    }

    private void clickBizType(String type, String formId) {
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)formId)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(formId);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        if (formConfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u8bbe\u7f6e\u5f53\u524d\u57fa\u7840\u8d44\u6599\u7684\u5217\u8868", (String)"WhiteSetPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String f7ListFormId = formConfig.getF7ListFormId();
        showParameter.setFormId(f7ListFormId);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowApproved(false);
        showParameter.setShowTitle(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, type);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("560");
        css.setWidth("900");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btnsave": {
                this.itemClick_save(evt);
                break;
            }
            case "btnregister": {
                this.itemClick_register(evt);
                break;
            }
            case "btnenable": {
                this.itemClick_enable(evt);
                break;
            }
            case "btndisable": {
                this.itemClick_disable(evt);
                break;
            }
            case "btnsetorg": {
                this.openSetOrgPage(evt);
                break;
            }
        }
    }

    private void openSetOrgPage(ItemClickEvent evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_whitelist_setorg_new");
        DynamicObjectCollection selectOrg = this.getModel().getEntryEntity(ORG_ENTRY_ENTITY);
        parameter.setCustomParam("setOrg", (Object)SerializationUtils.serializeToBase64((Object)selectOrg));
        parameter.setCustomParam("source", (Object)"whitePage");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_SET_ORG);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void itemClick_save(ItemClickEvent evt) {
    }

    private void itemClick_register(ItemClickEvent evt) {
        ListShowParameter param = new ListShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillFormId("eb_registmappingbill");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "register"));
        this.getView().showForm((FormShowParameter)param);
    }

    private void itemClick_enable(ItemClickEvent evt) {
        DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entitys)) {
            for (int i = 0; i < entitys.size(); ++i) {
                this.getModel().setValue("entrystatus", (Object)Boolean.TRUE, i);
            }
        }
    }

    private void itemClick_disable(ItemClickEvent evt) {
        DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entitys)) {
            for (int i = 0; i < entitys.size(); ++i) {
                this.getModel().setValue("entrystatus", (Object)Boolean.FALSE, i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "biznumber": {
                this.propertyChanged_bizNumber(e);
                break;
            }
            case "extbiznumber": {
                this.propertyChanged_extBizNumber(e);
                break;
            }
            case "biztype": {
                this.propertyChanged_bizType(e);
                break;
            }
            case "extbiztype": {
                this.propertyChanged_extBizType(e);
                break;
            }
            case "useextbiz": {
                this.propertyChanged_useExtBiz(e);
                break;
            }
        }
    }

    private void propertyChanged_bizNumber(PropertyChangedArgs e) {
        ChangeData[] changeSets = e.getChangeSet();
        if (changeSets == null || changeSets.length == 0) {
            return;
        }
        ChangeData data = changeSets[0];
        if (data.getNewValue() == null || StringUtils.isEmpty((String)((String)data.getNewValue()))) {
            this.getModel().setValue("bizname", null, data.getRowIndex());
            this.getModel().setValue("bizid", null, data.getRowIndex());
        }
    }

    private void propertyChanged_extBizNumber(PropertyChangedArgs e) {
        ChangeData[] changeSets = e.getChangeSet();
        if (changeSets == null || changeSets.length == 0) {
            return;
        }
        ChangeData data = changeSets[0];
        if (data.getNewValue() == null || StringUtils.isEmpty((String)((String)data.getNewValue()))) {
            this.getModel().setValue("extbizname", null, data.getRowIndex());
            this.getModel().setValue("extbizid", null, data.getRowIndex());
        }
    }

    private void propertyChanged_bizType(PropertyChangedArgs e) {
        ChangeData[] changeSets = e.getChangeSet();
        if (changeSets == null || changeSets.length == 0) {
            return;
        }
        ChangeData data = changeSets[0];
        if (data.getNewValue() == null || StringUtils.isEmpty((String)((String)data.getNewValue())) || !data.getNewValue().equals(data.getOldValue())) {
            this.getModel().setValue("bizname", null, data.getRowIndex());
            this.getModel().setValue(BIZNUMBER, null, data.getRowIndex());
            this.getModel().setValue("bizid", null, data.getRowIndex());
        }
    }

    private void propertyChanged_extBizType(PropertyChangedArgs e) {
        ChangeData[] changeSets = e.getChangeSet();
        if (changeSets == null || changeSets.length == 0) {
            return;
        }
        ChangeData data = changeSets[0];
        if (data.getNewValue() == null || StringUtils.isEmpty((String)((String)data.getNewValue())) || !data.getNewValue().equals(data.getOldValue())) {
            this.getModel().setValue("extbizname", null, data.getRowIndex());
            this.getModel().setValue(EXTBIZNUMBER, null, data.getRowIndex());
            this.getModel().setValue("extbizid", null, data.getRowIndex());
        }
    }

    private void propertyChanged_useExtBiz(PropertyChangedArgs e) {
        ChangeData[] changeSets = e.getChangeSet();
        if (changeSets == null || changeSets.length == 0) {
            return;
        }
        ChangeData data = changeSets[0];
        if (data.getNewValue() instanceof Boolean) {
            Boolean useExtBiz = (Boolean)data.getNewValue();
            if (useExtBiz.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{EXTBIZTYPE, EXTBIZNUMBER, "extbizname"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{EXTBIZTYPE, EXTBIZNUMBER, "extbizname"});
                IDataModel dataModel = this.getModel();
                int rowCount = dataModel.getEntryRowCount("entryentity");
                dataModel.beginInit();
                for (int i = 0; i < rowCount; ++i) {
                    dataModel.setValue(EXTBIZTYPE, null, i);
                    dataModel.setValue(EXTBIZNUMBER, null, i);
                    dataModel.setValue("extbizname", null, i);
                }
                dataModel.endInit();
                this.getView().updateView();
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "save".equals((operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            args.setCancel(!this.validate());
            this.setBillNumberSetCache();
        }
    }

    private void setBillNumberSetCache() {
        Long id = Convert.toLong((Object)this.getModel().getValue("id"));
        if (id == 0L) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_whitelist");
        DynamicObjectCollection bills = (DynamicObjectCollection)dynamicObject.get("bill");
        HashSet<String> billNumberSet = new HashSet<String>(16);
        for (DynamicObject bill : bills) {
            DynamicObject billDynamicObject = (DynamicObject)bill.get("fbasedataid");
            if (billDynamicObject == null) continue;
            billNumberSet.add(billDynamicObject.getString("number"));
        }
        this.getPageCache().put("billNumberSet", SerializationUtils.serializeToBase64(billNumberSet));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = evt.getOperateKey()) {
            case "save": {
                this.clearCacheByBillSet(evt);
                this.handleSaveLog(evt);
                break;
            }
        }
    }

    private void handleSaveLog(AfterDoOperationEventArgs evt) {
        if (evt.getOperationResult().isSuccess()) {
            DynamicObjectCollection orgEntryEntity;
            StringBuilder operationLogSb = new StringBuilder();
            StringBuilder monitorLogSb = new StringBuilder();
            String userName = UserUtils.getUserName();
            monitorLogSb.append(ResManager.loadKDString((String)"\u7528\u6237\u540d\uff1a", (String)"WhiteListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(userName).append(LOG_SPLIT_KEY);
            String time = DateTimeUtils.formatFromStr((String)(TimeServiceHelper.now() + ""));
            monitorLogSb.append(ResManager.loadKDString((String)"\u65f6\u95f4\uff1a", (String)"WhiteListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(time).append(LOG_SPLIT_KEY);
            IDataModel dataModel = this.getModel();
            String number = (String)dataModel.getValue("number");
            String numberStr = ResManager.loadKDString((String)"\u7f16\u7801\uff1a", (String)"WhiteListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            monitorLogSb.append(numberStr).append(number).append(LOG_SPLIT_KEY);
            operationLogSb.append(numberStr).append(number).append(LOG_SPLIT_KEY);
            String nameListType = (String)dataModel.getValue("namelisttype");
            String nameListTypeStr = ResManager.loadKDString((String)"\u540d\u5355\u7c7b\u578b\uff1a", (String)"WhiteListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            monitorLogSb.append(nameListTypeStr);
            operationLogSb.append(nameListTypeStr);
            if (BLACK_TYPE.equals(nameListType)) {
                monitorLogSb.append(ResManager.loadKDString((String)"\u9ed1\u540d\u5355", (String)"WhiteListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                operationLogSb.append(ResManager.loadKDString((String)"\u9ed1\u540d\u5355", (String)"WhiteListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (WHITE_TYPE.equals(nameListType)) {
                monitorLogSb.append(ResManager.loadKDString((String)"\u767d\u540d\u5355", (String)"WhiteListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                operationLogSb.append(ResManager.loadKDString((String)"\u767d\u540d\u5355", (String)"WhiteListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            monitorLogSb.append(LOG_SPLIT_KEY);
            operationLogSb.append(LOG_SPLIT_KEY);
            DynamicObjectCollection bills = (DynamicObjectCollection)dataModel.getValue("bill");
            if (bills != null && !bills.isEmpty()) {
                String billsStr = ResManager.loadKDString((String)"\u5355\u636e\uff1a", (String)"WhiteListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                List billNumbers = bills.stream().filter(e -> e.getDynamicObject("fbasedataid") != null).map(e -> e.getDynamicObject("fbasedataid").getString("number") + LOG_BLANK_SPACE + e.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                monitorLogSb.append(billsStr).append(StringUtils.join(billNumbers, (String)LOG_LIST_SPLIT_KEY)).append(LOG_SPLIT_KEY);
                billNumbers = bills.stream().filter(e -> e.getDynamicObject("fbasedataid") != null).map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
                operationLogSb.append(billsStr).append(StringUtils.join(billNumbers, (String)LOG_LIST_SPLIT_KEY)).append(LOG_SPLIT_KEY);
            }
            Boolean useExtBiz = (Boolean)dataModel.getValue(SEL_USEEXTBIZ);
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
            if (entryEntity != null && !entryEntity.isEmpty()) {
                List opEntryEntitys;
                List entryEntitys;
                if (useExtBiz.booleanValue()) {
                    entryEntitys = entryEntity.stream().map(e -> {
                        StringBuilder message = new StringBuilder();
                        message.append("biz:").append(e.getString(BIZTYPE)).append(LOG_BLANK_SPACE).append(e.getString(BIZNUMBER)).append(LOG_BLANK_SPACE).append(e.getString("bizname"));
                        if (StringUtils.isNotEmpty((String)e.getString(EXTBIZTYPE)) && StringUtils.isNotEmpty((String)e.getString(EXTBIZNUMBER))) {
                            message.append(LOG_BLANK_SPACE).append("extbiz:").append(e.getString(EXTBIZTYPE)).append(LOG_BLANK_SPACE).append(e.getString(EXTBIZNUMBER)).append(LOG_BLANK_SPACE).append(e.getString("extbizname"));
                        }
                        return message.toString();
                    }).collect(Collectors.toList());
                    opEntryEntitys = entryEntity.stream().map(e -> {
                        StringBuilder message = new StringBuilder();
                        message.append("biz:").append(e.getString(BIZTYPE)).append(LOG_BLANK_SPACE).append(e.getString(BIZNUMBER));
                        if (StringUtils.isNotEmpty((String)e.getString(EXTBIZTYPE)) && StringUtils.isNotEmpty((String)e.getString(EXTBIZNUMBER))) {
                            message.append(LOG_BLANK_SPACE).append("extbiz:").append(e.getString(EXTBIZTYPE)).append(LOG_BLANK_SPACE).append(e.getString(EXTBIZNUMBER));
                        }
                        return message.toString();
                    }).collect(Collectors.toList());
                } else {
                    entryEntitys = entryEntity.stream().map(e -> e.getString(BIZTYPE) + LOG_BLANK_SPACE + e.getString(BIZNUMBER) + LOG_BLANK_SPACE + e.getString("bizname")).collect(Collectors.toList());
                    opEntryEntitys = entryEntity.stream().map(e -> e.getString(BIZTYPE) + LOG_BLANK_SPACE + e.getString(BIZNUMBER)).collect(Collectors.toList());
                }
                String bizsStr = ResManager.loadKDString((String)"\u63a7\u5236\u540d\u5355\u5185\u5bb9\uff1a", (String)"WhiteListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                monitorLogSb.append(bizsStr).append(StringUtils.join(entryEntitys, (String)LOG_LIST_SPLIT_KEY)).append(LOG_SPLIT_KEY);
                operationLogSb.append(bizsStr).append(StringUtils.join(opEntryEntitys, (String)LOG_LIST_SPLIT_KEY)).append(LOG_SPLIT_KEY);
            }
            if ((orgEntryEntity = dataModel.getEntryEntity(ORG_ENTRY_ENTITY)) != null && !orgEntryEntity.isEmpty()) {
                String setOrgsStr = ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\uff1a", (String)"WhiteListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                List orgEntryEntitys = orgEntryEntity.stream().map(e -> e.getString(ORG_BIZ_TYPE) + LOG_BLANK_SPACE + e.getString(ORG_BIZ_NUMBER) + LOG_BLANK_SPACE + e.getString(ORG_BIZ_NAME)).collect(Collectors.toList());
                monitorLogSb.append(setOrgsStr).append(StringUtils.join(orgEntryEntitys, (String)LOG_LIST_SPLIT_KEY));
                orgEntryEntitys = orgEntryEntity.stream().map(e -> e.getString(ORG_BIZ_TYPE) + LOG_BLANK_SPACE + e.getString(ORG_BIZ_NUMBER)).collect(Collectors.toList());
                operationLogSb.append(setOrgsStr).append(StringUtils.join(orgEntryEntitys, (String)LOG_LIST_SPLIT_KEY));
            }
            String monitorLog = monitorLogSb.toString();
            log.info("whitelist_save:" + monitorLog);
            String opName = ResManager.loadKDString((String)"\u767d\u540d\u5355\u4fdd\u5b58", (String)"WhiteListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)opName, (String)operationLogSb.toString());
        }
    }

    private void clearCacheByBillSet(AfterDoOperationEventArgs evt) {
        if (evt.getOperationResult().isSuccess()) {
            String billNumberSetStr = this.getPageCache().get("billNumberSet");
            Set<String> billNumberSet = new HashSet(16);
            if (StringUtils.isNotEmpty((String)billNumberSetStr)) {
                billNumberSet = (Set)SerializationUtils.deSerializeFromBase64((String)billNumberSetStr);
            }
            DynamicObjectCollection bills = (DynamicObjectCollection)this.getModel().getValue("bill");
            for (DynamicObject bill : bills) {
                DynamicObject billDynamicObject = (DynamicObject)bill.get("fbasedataid");
                if (billDynamicObject == null) continue;
                billNumberSet.add(billDynamicObject.getString("number"));
            }
            BgControlWhiteUtils.clearCacheByWhiteList(billNumberSet);
            this.getPageCache().remove("billNumberSet");
        }
    }

    protected boolean validate() {
        boolean exists;
        QFilter qFilter = new QFilter("number", "=", this.getModel().getValue("number"));
        if (this.getModel().getValue("id") != null) {
            qFilter.and(new QFilter("id", "!=", (Object)IDUtils.toLong((Object)this.getModel().getValue("id"))));
        }
        if (exists = QueryServiceHelper.exists((String)"eb_whitelist", (QFilter[])qFilter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"WhiteListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject whiteList = BusinessDataServiceHelper.newDynamicObject((String)"eb_whitelist");
        whiteList.set("number", this.getModel().getValue("number"));
        whiteList.set("name", this.getModel().getValue("name"));
        whiteList.set(SEL_USEEXTBIZ, this.getModel().getValue(SEL_USEEXTBIZ));
        whiteList.set("bill", this.getModel().getValue("bill"));
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection whiteEntries = whiteList.getDynamicObjectCollection("entryentity");
        int in = entries.size();
        for (int i = 0; i < in; ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject whiteEntry = whiteEntries.addNew();
            whiteEntry.set("seq", (Object)(i + 1));
            whiteEntry.set(BIZTYPE, (Object)entry.getString(BIZTYPE));
            whiteEntry.set(BIZNUMBER, (Object)entry.getString(BIZNUMBER));
            whiteEntry.set("bizname", (Object)entry.getString("bizname"));
            whiteEntry.set(EXTBIZTYPE, (Object)entry.getString(EXTBIZTYPE));
            whiteEntry.set(EXTBIZNUMBER, (Object)entry.getString(EXTBIZNUMBER));
            whiteEntry.set("extbizname", (Object)entry.getString("extbizname"));
            whiteEntry.set("entrystatus", (Object)entry.getString("entrystatus"));
        }
        CheckResult validateStr = WhiteListUtils.Check.validate(whiteList, 0);
        if (validateStr != null && validateStr.validateStr.length() > 0) {
            this.getView().showTipNotification(validateStr.validateStr.toString());
            return false;
        }
        return true;
    }

    private String getWhiteKey(DynamicObject white, boolean useExtBiz) {
        if (useExtBiz) {
            return white.getString(BIZNUMBER) + '@' + white.getString(EXTBIZNUMBER);
        }
        return white.getString(BIZNUMBER);
    }

    private DynamicObjectCollection queryRegisterBiz() {
        return QueryServiceHelper.query((String)"eb_registmappingbill", (String)"basedatafield, basename", null);
    }

    private void initBizType(DynamicObjectCollection registerBiz) {
        this.initComboBox((ItemClassTypeEdit)this.getControl(BIZTYPE), registerBiz);
    }

    private void initExtBizType(DynamicObjectCollection registerBiz) {
        this.initComboBox((ItemClassTypeEdit)this.getControl(EXTBIZTYPE), registerBiz);
    }

    private void initComboBox(ItemClassTypeEdit edit, DynamicObjectCollection bizTypes) {
        if (edit == null || bizTypes == null) {
            return;
        }
        DynamicObject[] entityObjs = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", bizTypes.stream().map(k -> k.getString("basedatafield")).collect(Collectors.toSet()))});
        Map<String, String> nameMap = Arrays.stream(entityObjs).filter(k -> k != null && k.getString("name") != null).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getString("name")));
        ArrayList combos = Lists.newArrayListWithExpectedSize((int)bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            ComboItem item = new ComboItem();
            LocaleString name = nameMap.get(bizType.getString("basedatafield")) != null ? new LocaleString(nameMap.get(bizType.getString("basedatafield"))) : new LocaleString(bizType.getString("basename"));
            item.setCaption(name);
            item.setValue(bizType.getString("basedatafield"));
            combos.add(item);
        }
        edit.setComboItems((List)combos);
    }
}

