/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class WhiteListSetOrgPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    protected static final int MAXLEVEL = 20;
    public static final String TREE_SEARCH = "treesearch";
    public static final String TREE_UP = "treeup";
    public static final String TREE_DOWN = "treedown";
    public static final String LEFT_TREE = "lefttree";
    protected static final String L_TREE_LIST = "ltreelist";
    protected static final String L_TREE_FOCUS = "ltreefocus";
    protected static final String L_OLD_TREE_NODE_CACHE = "loldtreenode";
    public static final String ADMIN_ORG_SEARCH = "adminorgsearch";
    public static final String ADMIN_ORG_UP = "adminorgup";
    public static final String ADMIN_ORG_DOWN = "adminorgdown";
    public static final String TREE_ADMIN_ORG = "treeadminorg";
    protected static final String L_ADMIN_ORG_TREE_LIST = "ladminorgtreelist";
    protected static final String L_ADMIN_ORG_TREE_FOCUS = "ladminorgtreefocus";
    protected static final String L_OLD_ADMIN_ORG_TREE_NODE_CACHE = "loldadminorgtreenode";
    public static final String SHOW_TYPE = "showtype";
    public static final String BTN_MOVE_UP = "btn_moveup";
    public static final String BTN_MOVE_DOWN = "btn_movedown";
    public static final String BTN_REMOVE = "btn_remove";
    public static final String BTN_CLEAR_SELECTED = "btn_clearselected";
    public static final String SEARCH_LIST = "searchlist";
    public static final String LIST_UP = "listup";
    public static final String LIST_DOWN = "listdown";
    public static final String ORG_ID = "orgid";
    public static final String ORG_SOURCE = "orgsource";
    public static final String BTN_CANCEL = "btncancel";
    public static final String BTN_SURE = "btn_sure";
    public static final String CACHE_ORG_LIST_ROW_INDEX = "cache_org_list_row_index";
    public static final String ORG_SOURCE_ADMIN_ORG_VIEW = "01";
    public static final String ORG_SOURCE_ORG_VIEW = "15";
    public static final String BOS_ADMIN_ORG = "bos_adminorg";
    public static final String BOS_ORG = "bos_org";
    public static final String CACHE_ORG_LIST_SELECT = "cache_org_list_select";
    public static final String SHOW_TYPE_NUMBER = "1";
    public static final String SHOW_TYPE_NAME = "2";
    public static final String SHOW_TYPE_NAME_AND_NUMBER = "3";
    public static final String SPLIT_STRING = new String(new char[]{'\u0001'});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TREE_UP, TREE_DOWN, ADMIN_ORG_UP, ADMIN_ORG_DOWN, BTN_MOVE_UP, BTN_MOVE_DOWN, BTN_REMOVE, BTN_CLEAR_SELECTED, LIST_UP, LIST_DOWN, BTN_SURE});
        final IPageCache pageCache = this.getPageCache();
        final IFormView view = this.getView();
        final String showType = (String)this.getModel().getValue(SHOW_TYPE);
        Search search = (Search)this.getControl(TREE_SEARCH);
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                WhiteListSetOrgPlugin.this.buildTree(WhiteListSetOrgPlugin.LEFT_TREE, WhiteListSetOrgPlugin.ORG_SOURCE_ORG_VIEW, showType, true);
                WhiteListSetOrgPlugin.this.handleTreeViewCheckNodes();
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), view, pageCache, new TreeSearchUtil.TreeSearchParam(WhiteListSetOrgPlugin.LEFT_TREE, WhiteListSetOrgPlugin.LEFT_TREE, WhiteListSetOrgPlugin.L_TREE_LIST, WhiteListSetOrgPlugin.L_TREE_FOCUS, WhiteListSetOrgPlugin.L_OLD_TREE_NODE_CACHE));
            }
        });
        Search adminOrgSearch = (Search)this.getControl(ADMIN_ORG_SEARCH);
        adminOrgSearch.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                WhiteListSetOrgPlugin.this.buildTree(WhiteListSetOrgPlugin.TREE_ADMIN_ORG, WhiteListSetOrgPlugin.ORG_SOURCE_ADMIN_ORG_VIEW, showType, true);
                WhiteListSetOrgPlugin.this.handleTreeViewCheckNodes();
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), view, pageCache, new TreeSearchUtil.TreeSearchParam(WhiteListSetOrgPlugin.TREE_ADMIN_ORG, WhiteListSetOrgPlugin.TREE_ADMIN_ORG, WhiteListSetOrgPlugin.L_ADMIN_ORG_TREE_LIST, WhiteListSetOrgPlugin.L_ADMIN_ORG_TREE_FOCUS, WhiteListSetOrgPlugin.L_OLD_ADMIN_ORG_TREE_NODE_CACHE));
            }
        });
        Search searchList = (Search)this.getControl(SEARCH_LIST);
        searchList.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    WhiteListSetOrgPlugin.this.searchSelectOrgList(var1.getText(), true);
                } else {
                    WhiteListSetOrgPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"WhiteListSetOrgPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        TreeView orgTree = (TreeView)this.getControl(LEFT_TREE);
        orgTree.addTreeNodeCheckListener(new TreeNodeCheckListener(){

            public void treeNodeCheck(TreeNodeCheckEvent evt) {
                WhiteListSetOrgPlugin.this.orgTreeNodeClick(evt);
            }
        });
        orgTree.addTreeNodeQueryListener(new TreeNodeQueryListener(){

            public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
                WhiteListSetOrgPlugin.this.orgTreeQueryTreeNodeChildren(WhiteListSetOrgPlugin.LEFT_TREE, WhiteListSetOrgPlugin.ORG_SOURCE_ORG_VIEW, treeNodeEvent);
            }
        });
        TreeView adminOrgTree = (TreeView)this.getControl(TREE_ADMIN_ORG);
        adminOrgTree.addTreeNodeCheckListener(new TreeNodeCheckListener(){

            public void treeNodeCheck(TreeNodeCheckEvent evt) {
                WhiteListSetOrgPlugin.this.orgTreeNodeClick(evt);
            }
        });
        adminOrgTree.addTreeNodeQueryListener(new TreeNodeQueryListener(){

            public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
                WhiteListSetOrgPlugin.this.orgTreeQueryTreeNodeChildren(WhiteListSetOrgPlugin.TREE_ADMIN_ORG, WhiteListSetOrgPlugin.ORG_SOURCE_ADMIN_ORG_VIEW, treeNodeEvent);
            }
        });
    }

    private void orgTreeQueryTreeNodeChildren(String treeKey, String orgSource, TreeNodeEvent treeNodeEvent) {
        String leftTreeNodeId = (String)treeNodeEvent.getNodeId();
        TreeNode root = this.getCacheOrgTreeRoot(treeKey);
        TreeNode currentNode = root.getTreeNode(leftTreeNodeId, 20);
        if (CollectionUtils.isEmpty((Collection)currentNode.getChildren())) {
            Map<String, List<TreeNode>> orgChildrenTreeDataEB = this.getOrgChildrenTreeDataEB(orgSource, leftTreeNodeId, (String)this.getModel().getValue(SHOW_TYPE));
            this.expandLeftTreeNode(treeKey, leftTreeNodeId, orgChildrenTreeDataEB, root, currentNode);
        }
    }

    private void orgTreeNodeClick(TreeNodeCheckEvent evt) {
        boolean checked = evt.getChecked();
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        if (evt.getSource() instanceof TreeView) {
            String orgSource = this.getOrgSource((Control)((TreeView)evt.getSource()));
            TreeNode treeNode = this.getOrgTreeNode((TreeView)evt.getSource(), nodeId);
            Map<String, Map<String, String>> selectedOrgs = this.getSelectedIdsFromCache(this.getPageCache());
            if (checked) {
                if (!selectedOrgs.containsKey(orgSource + SPLIT_STRING + nodeId)) {
                    this.selectedNode(selectedOrgs, orgSource, treeNode);
                }
            } else {
                this.unSelectedNode(nodeId, selectedOrgs, orgSource);
            }
        }
    }

    private TreeNode getOrgTreeNode(@NotNull TreeView treeView, Object nodeId) {
        String treeViewKey = treeView.getKey();
        TreeNode cacheOrgTreeRoot = this.getCacheOrgTreeRoot(treeViewKey);
        return cacheOrgTreeRoot.getTreeNode((String)nodeId, 20);
    }

    private String getOrgSource(@NotNull Control control) {
        String controlKey = control.getKey();
        String orgSource = BOS_ORG;
        if (LEFT_TREE.equals(controlKey)) {
            orgSource = BOS_ORG;
        } else if (TREE_ADMIN_ORG.equals(controlKey)) {
            orgSource = BOS_ADMIN_ORG;
        }
        return orgSource;
    }

    private void selectedNode(@NotNull Map<String, Map<String, String>> selectedOrgs, @NotNull String orgSource, TreeNode treeNode) {
        Map data = (Map)treeNode.getData();
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue(ORG_ID, (Object)treeNode.getId(), rowIndex);
        this.getModel().setValue("number", data.get("number"), rowIndex);
        this.getModel().setValue("name", data.get("name"), rowIndex);
        this.getModel().setValue(ORG_SOURCE, (Object)orgSource, rowIndex);
        this.putSelectedOrg(treeNode, selectedOrgs, orgSource);
        this.cacheSelectOrg(this.getPageCache(), selectedOrgs);
    }

    private void putSelectedOrg(TreeNode treeNode, Map<String, Map<String, String>> selectedOrgs, String orgSource) {
        Map data = (Map)treeNode.getData();
        HashMap<String, String> orgMap = new HashMap<String, String>(16);
        orgMap.put("id", treeNode.getId());
        orgMap.put("number", (String)data.get("number"));
        orgMap.put("name", (String)data.get("name"));
        orgMap.put("type", orgSource);
        selectedOrgs.put(orgSource + SPLIT_STRING + treeNode.getId(), orgMap);
    }

    private Map<String, Map<String, String>> getSelectedIdsFromCache(IPageCache pageCache) {
        String _cacheStr = pageCache.get(CACHE_ORG_LIST_SELECT);
        if (StringUtils.isNotEmpty((String)_cacheStr)) {
            return (Map)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        }
        return new LinkedHashMap<String, Map<String, String>>();
    }

    private void unSelectedNode(@NotNull Object nodeId, @NotNull Map<String, Map<String, String>> selectedOrgs, String orgSource) {
        Long orgId = IDUtils.toLong((Object)nodeId);
        DynamicObjectCollection selOrgs = this.getModel().getEntryEntity("entryentity");
        for (int i = selOrgs.size() - 1; i >= 0; --i) {
            DynamicObject selOrg = (DynamicObject)selOrgs.get(i);
            if (selOrg.getLong(ORG_ID) != orgId.longValue() || !selOrg.getString(ORG_SOURCE).equals(orgSource)) continue;
            this.getModel().deleteEntryRow("entryentity", i);
            selectedOrgs.remove(orgSource + SPLIT_STRING + IDUtils.toString((Object)nodeId));
        }
        this.cacheSelectOrg(this.getPageCache(), selectedOrgs);
    }

    private void cacheSelectOrg(IPageCache pageCache, Map<String, Map<String, String>> selectOrgs) {
        if (selectOrgs == null || selectOrgs.isEmpty()) {
            pageCache.remove(CACHE_ORG_LIST_SELECT);
        } else {
            pageCache.put(CACHE_ORG_LIST_SELECT, JSON.toJSONString(selectOrgs));
        }
    }

    protected void searchSelectOrgList(@NotNull String searchTxt, boolean isDown) {
        DynamicObjectCollection selOrgs = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (selOrgs != null && !selOrgs.isEmpty()) {
            DynamicObject selOrg;
            int rowIndex;
            int selRowIndex = -1;
            String _selRowIndex = this.getPageCache().get(CACHE_ORG_LIST_ROW_INDEX);
            if (StringUtils.isNotEmpty((String)_selRowIndex)) {
                try {
                    selRowIndex = Integer.parseInt(_selRowIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isDown) {
                int in = selOrgs.size();
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex + 1 : 0; i < in; ++i) {
                    selOrg = (DynamicObject)selOrgs.get(i);
                    if (selOrg == null || !this.equalsSearchText(selOrg, searchTxt)) continue;
                    this.getPageCache().put(CACHE_ORG_LIST_ROW_INDEX, String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            } else {
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex - 1 : selOrgs.size() - 1; i >= 0; --i) {
                    selOrg = (DynamicObject)selOrgs.get(i);
                    if (selOrg == null || !this.equalsSearchText(selOrg, searchTxt)) continue;
                    this.getPageCache().put(CACHE_ORG_LIST_ROW_INDEX, String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            }
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        if (selectRows.isEmpty()) {
            int[] selectRows1 = entry.getSelectRows();
            if (selectRows1 != null && selectRows1.length > 0) {
                if (isDown) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"WhiteListSetOrgPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"WhiteListSetOrgPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"WhiteListSetOrgPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            }
        } else if (entry != null) {
            int[] rows = selectRows.stream().mapToInt(x -> x).toArray();
            entry.selectRows(rows, 0);
        }
    }

    private boolean equalsSearchText(@NotNull DynamicObject org, @NotNull String searchTxt) {
        String name = org.getString("name");
        String number = org.getString("number");
        String _searchTxt = searchTxt.toLowerCase();
        return StringUtils.isNotEmpty((String)name) && name.contains(searchTxt) || StringUtils.isNotEmpty((String)number) && number.toLowerCase().contains(_searchTxt);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree((String)this.getModel().getValue(SHOW_TYPE));
        this.initSelectOrgs();
        this.handleTreeViewCheckNodes();
    }

    private void handleTreeViewCheckNodes() {
        Map<String, List<String>> selectOrgByOrgSourceMap = this.getSelectIdsByOrgSource();
        for (Map.Entry<String, List<String>> entry : selectOrgByOrgSourceMap.entrySet()) {
            String key = entry.getKey();
            String treeKey = key.equals(BOS_ORG) ? LEFT_TREE : TREE_ADMIN_ORG;
            TreeView orgTreeView = (TreeView)this.getControl(treeKey);
            List<String> selectOrgIds = entry.getValue();
            if (!CollectionUtils.isNotEmpty(selectOrgIds)) continue;
            ArrayList<TreeNode> selectTreeNodes = new ArrayList<TreeNode>(selectOrgIds.size());
            TreeNode treeRoot = this.getCacheOrgTreeRoot(treeKey);
            for (String selectOrgId : selectOrgIds) {
                selectTreeNodes.add(treeRoot.getTreeNode(selectOrgId, 20));
            }
            orgTreeView.checkNodesWithoutChild(selectTreeNodes);
        }
    }

    @NotNull
    private Map<String, List<String>> getSelectIdsByOrgSource() {
        HashMap<String, List<String>> selectOrgByOrgSourceMap = new HashMap<String, List<String>>(16);
        Map<String, Map<String, String>> selectedIdsFromCache = this.getSelectedIdsFromCache(this.getPageCache());
        for (Map.Entry<String, Map<String, String>> entry : selectedIdsFromCache.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split(SPLIT_STRING);
            List orgIds = selectOrgByOrgSourceMap.computeIfAbsent(split[0], f -> new ArrayList(16));
            orgIds.add(split[1]);
        }
        return selectOrgByOrgSourceMap;
    }

    private void initSelectOrgs() {
        DynamicObjectCollection selectOrgs;
        String setOrgStr = (String)this.getView().getFormShowParameter().getCustomParam("setOrg");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)setOrgStr) && CollectionUtils.isNotEmpty((Collection)(selectOrgs = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)setOrgStr)))) {
            LinkedHashMap<String, Map<String, String>> selectedOrgMap = new LinkedHashMap<String, Map<String, String>>(selectOrgs.size());
            IDataModel dataModel = this.getModel();
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow("entryentity", selectOrgs.size());
            for (int i = 0; i < selectOrgs.size(); ++i) {
                DynamicObject entity = dataModel.getEntryRowEntity("entryentity", i);
                DynamicObject dynamicObject = (DynamicObject)selectOrgs.get(i);
                entity.set(ORG_ID, (Object)dynamicObject.getLong("orgbizid"));
                entity.set("number", (Object)dynamicObject.getString("orgbiznumber"));
                entity.set("name", (Object)dynamicObject.getString("orgbizname"));
                entity.set(ORG_SOURCE, (Object)dynamicObject.getString("orgbiztype"));
                Map orgMap = selectedOrgMap.computeIfAbsent(dynamicObject.getString("orgbiztype") + SPLIT_STRING + dynamicObject.getString("orgbizid"), f -> new HashMap(16));
                orgMap.put("id", dynamicObject.getString("orgbizid"));
                orgMap.put("number", dynamicObject.getString("orgbiznumber"));
                orgMap.put("name", dynamicObject.getString("orgbizname"));
                orgMap.put("type", dynamicObject.getString("orgbiztype"));
            }
            dataModel.endInit();
            this.getView().updateView("entryentity");
            this.cacheSelectOrg(this.getPageCache(), selectedOrgMap);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.EDIT.getValue()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        String opkey;
        super.click(evt);
        switch (opkey = ((Control)evt.getSource()).getKey()) {
            case "treeup": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(LEFT_TREE, LEFT_TREE, L_TREE_LIST, L_TREE_FOCUS, L_OLD_TREE_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "treedown": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(LEFT_TREE, LEFT_TREE, L_TREE_LIST, L_TREE_FOCUS, L_OLD_TREE_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "adminorgup": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_ADMIN_ORG, TREE_ADMIN_ORG, L_ADMIN_ORG_TREE_LIST, L_ADMIN_ORG_TREE_FOCUS, L_OLD_ADMIN_ORG_TREE_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "adminorgdown": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_ADMIN_ORG, TREE_ADMIN_ORG, L_ADMIN_ORG_TREE_LIST, L_ADMIN_ORG_TREE_FOCUS, L_OLD_ADMIN_ORG_TREE_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "listup": {
                Search searchList = (Search)this.getControl(SEARCH_LIST);
                this.searchSelectOrgList(searchList.getSearchKey(), false);
                break;
            }
            case "listdown": {
                Search searchList1 = (Search)this.getControl(SEARCH_LIST);
                this.searchSelectOrgList(searchList1.getSearchKey(), true);
                break;
            }
            case "btn_moveup": {
                this.clickMoveUp();
                break;
            }
            case "btn_movedown": {
                this.clickMoveDown();
                break;
            }
            case "btn_remove": {
                this.clickRemove();
                break;
            }
            case "btn_clearselected": {
                this.clickClearSelected();
                break;
            }
            case "btn_sure": {
                this.fillSetOrgToReturnData();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put(CACHE_ORG_LIST_ROW_INDEX, String.valueOf(evt.getRow()));
    }

    protected void clickMoveUp() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"WhiteListSetOrgPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"WhiteListSetOrgPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsUp("entryentity", rows);
            }
        }
    }

    protected void clickMoveDown() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"WhiteListSetOrgPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                int count = this.getModel().getEntryRowCount("entryentity");
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == count - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5904\u4e8e\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"WhiteListSetOrgPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsDown("entryentity", rows);
            }
        }
    }

    protected void clickRemove() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"WhiteListSetOrgPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                HashSet<String> unCheckedIdAndSources = new HashSet<String>(rows.length);
                for (int row : rows) {
                    DynamicObject org = this.getModel().getEntryRowEntity("entryentity", row);
                    if (org == null) continue;
                    unCheckedIdAndSources.add(org.getString(ORG_SOURCE) + SPLIT_STRING + org.getString(ORG_ID));
                }
                this.unClearTreeNode(this.getView(), new ArrayList<String>(unCheckedIdAndSources));
                this.getModel().deleteEntryRows("entryentity", rows);
                Map<String, Map<String, String>> selectData = this.getSelectedIdsFromCache(this.getPageCache());
                unCheckedIdAndSources.forEach(selectData::remove);
                this.cacheSelectOrg(this.getPageCache(), selectData);
            }
        }
    }

    public void unClearTreeNode(@NotNull IFormView view, List<String> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        HashMap<String, List> unClearTreeNodeMap = new HashMap<String, List>(16);
        for (String string : nodes) {
            String[] s = string.split(SPLIT_STRING);
            List treeNodes = unClearTreeNodeMap.computeIfAbsent(s[0], f -> new ArrayList(16));
            treeNodes.add(s[1]);
        }
        for (Map.Entry entry : unClearTreeNodeMap.entrySet()) {
            if (BOS_ORG.equals(entry.getKey())) {
                this.unCheckNodesByTreeView(view, LEFT_TREE, (List)entry.getValue());
                continue;
            }
            if (!BOS_ADMIN_ORG.equals(entry.getKey())) continue;
            this.unCheckNodesByTreeView(view, TREE_ADMIN_ORG, (List)entry.getValue());
        }
    }

    private void unCheckNodesByTreeView(@NotNull IFormView view, String leftTree, List<String> value) {
        TreeView treeView = (TreeView)view.getControl(leftTree);
        if (treeView != null) {
            treeView.uncheckNodes(value);
        }
    }

    protected void clickClearSelected() {
        Map<String, Map<String, String>> selectData = this.getSelectedIdsFromCache(this.getPageCache());
        this.unClearTreeNode(this.getView(), new ArrayList<String>(selectData.keySet()));
        this.cacheSelectOrg(this.getPageCache(), null);
        this.getModel().deleteEntryData("entryentity");
    }

    private void fillSetOrgToReturnData() {
        Map<String, Map<String, String>> selectedIdsFromCache = this.getSelectedIdsFromCache(this.getPageCache());
        LinkedHashMap selectDatas = Maps.newLinkedHashMapWithExpectedSize((int)selectedIdsFromCache.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            String key = dynamicObject.getString(ORG_SOURCE) + SPLIT_STRING + dynamicObject.getString(ORG_ID);
            Map<String, String> selectData = selectedIdsFromCache.get(key);
            if (selectData == null) continue;
            selectDatas.put(key, selectData);
        }
        this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64((Object)selectDatas));
        this.getView().close();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "showtype": {
                this.orgTreeShowTypeChange(e);
                break;
            }
        }
    }

    private void orgTreeShowTypeChange(PropertyChangedArgs evt) {
        ChangeData[] changeData = evt.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u663e\u793a\u65b9\u5f0f\u5207\u6362\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"WhiteListSetOrgPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        this.initLeftTree((String)changeData[0].getNewValue());
        this.handleTreeViewCheckNodes();
        this.getView().hideLoading();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    private void initLeftTree(String showType) {
        this.buildTree(LEFT_TREE, ORG_SOURCE_ORG_VIEW, showType, false);
        this.buildTree(TREE_ADMIN_ORG, ORG_SOURCE_ADMIN_ORG_VIEW, showType, false);
    }

    private void buildTree(String treeKey, String orgSource, String showType, boolean isSearch) {
        TreeView orgTreeView = (TreeView)this.getControl(treeKey);
        orgTreeView.deleteAllNodes();
        TreeNode orgTreeRoot = this.getLeftRoot(orgSource, showType);
        if (orgTreeRoot != null) {
            if (isSearch) {
                Map<String, List<TreeNode>> orgChildrenTreeDataEB = this.getOrgChildrenTreeDataEB(orgSource, null, showType);
                this.expandLeftNextLevel(orgTreeRoot, orgChildrenTreeDataEB);
            } else {
                Map<String, List<TreeNode>> orgChildrenTreeDataEB = this.getOrgChildrenTreeDataEB(orgSource, orgTreeRoot.getId(), showType);
                if (orgChildrenTreeDataEB != null) {
                    List<TreeNode> treeNodes = orgChildrenTreeDataEB.get(orgTreeRoot.getId());
                    for (TreeNode treeNode : treeNodes) {
                        if (!treeNode.isLeaf()) {
                            treeNode.setChildren(new ArrayList());
                        }
                        orgTreeRoot.addChild(treeNode);
                    }
                }
            }
            orgTreeView.addNode(orgTreeRoot);
            orgTreeView.expand(orgTreeRoot.getId());
            this.cacheOrgTreeRoot(treeKey, orgTreeRoot);
        }
    }

    public void expandLeftTreeNode(String treeKey, String leftTreeNodeId, Map<String, List<TreeNode>> orgChildrenTreeDataEB, TreeNode root, TreeNode currentNode) {
        if (orgChildrenTreeDataEB == null) {
            return;
        }
        List<TreeNode> treeNodes = orgChildrenTreeDataEB.get(leftTreeNodeId);
        if (CollectionUtils.isNotEmpty(treeNodes)) {
            Map<String, List<String>> selectIdsByOrgSource = this.getSelectIdsByOrgSource();
            ArrayList checkedNodeIds = new ArrayList();
            ArrayList<TreeNode> checkedNodes = new ArrayList<TreeNode>();
            String orgKey = "";
            if (treeKey.equals(LEFT_TREE)) {
                orgKey = BOS_ORG;
            } else if (treeKey.equals(TREE_ADMIN_ORG)) {
                orgKey = BOS_ADMIN_ORG;
            }
            if (selectIdsByOrgSource.get(orgKey) != null) {
                checkedNodeIds.addAll(selectIdsByOrgSource.get(orgKey));
            }
            for (TreeNode treeNode : treeNodes) {
                if (!treeNode.isLeaf()) {
                    treeNode.setChildren(new ArrayList());
                }
                currentNode.addChild(treeNode);
                if (!checkedNodeIds.contains(treeNode.getId())) continue;
                checkedNodes.add(treeNode);
            }
            TreeView treeView = (TreeView)this.getControl(treeKey);
            treeView.addNode(currentNode);
            treeView.updateNode(currentNode);
            if (CollectionUtils.isNotEmpty(checkedNodes)) {
                treeView.checkNodesWithoutChild(checkedNodes);
            }
            treeView.expand(currentNode.getId());
            this.cacheOrgTreeRoot(treeKey, root);
        }
    }

    protected TreeNode getLeftRoot(String orgSource, String showType) {
        TreeNode rootNode;
        DynamicObjectCollection root = OrgTreeUtils.getSubOrgByParentId((String)"", (String)orgSource, null, (String)"level", (boolean)false);
        if (CollectionUtils.isEmpty((Collection)root)) {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"WhiteListSetOrgPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            rootNode = new TreeNode("", "-1", text.getLocaleValue());
        } else {
            DynamicObject orgObj = (DynamicObject)root.get(0);
            rootNode = this.genTreeNode(orgObj, showType);
            rootNode.setParentid("");
            rootNode.setIsOpened(true);
        }
        return rootNode;
    }

    private TreeNode genTreeNode(DynamicObject orgObj, String showType) {
        TreeNode rootleft = new TreeNode();
        Long leftRootId = orgObj.getLong("org");
        rootleft.setId(leftRootId.toString());
        rootleft.setLongNumber(orgObj.getString("longNumber"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("isNew", SHOW_TYPE_NUMBER);
        data.put("name", orgObj.getString("name"));
        data.put("number", orgObj.getString("longnumber"));
        data.put("id", orgObj.getString("org"));
        rootleft.setData(data);
        rootleft.setText(this.getTreeTextByShowType(rootleft, showType));
        return rootleft;
    }

    private String getTreeTextByShowType(TreeNode treeNode, String showType) {
        String treeText = "";
        if (treeNode == null || treeNode.getData() == null) {
            return treeText;
        }
        Map data = (Map)treeNode.getData();
        if (SHOW_TYPE_NUMBER.equals(showType)) {
            treeText = (String)data.get("number");
        } else if (SHOW_TYPE_NAME.equals(showType)) {
            treeText = (String)data.get("name");
        } else if (SHOW_TYPE_NAME_AND_NUMBER.equals(showType)) {
            treeText = (String)data.get("name") + " " + (String)data.get("number");
        }
        return treeText;
    }

    private void expandLeftNextLevel(TreeNode parentNode, Map<String, List<TreeNode>> childrenDataMap) {
        if (childrenDataMap == null) {
            return;
        }
        List<TreeNode> treeNodes = childrenDataMap.get(parentNode.getId());
        if (treeNodes != null) {
            parentNode.addChildren(treeNodes);
        }
        if (parentNode.getChildren() != null) {
            if (parentNode.getChildren().size() == 0) {
                parentNode.setChildren(null);
            } else {
                for (TreeNode child : parentNode.getChildren()) {
                    this.expandLeftNextLevel(child, childrenDataMap);
                }
            }
        }
    }

    private Map<String, List<TreeNode>> getOrgChildrenTreeDataEB(String ovType, String parentId, String showType) {
        HashMap<String, List<TreeNode>> orgHashMap = new HashMap<String, List<TreeNode>>(16);
        HashSet<String> idset = new HashSet<String>(16);
        ORM ormOV = ORM.create();
        QFilter f2 = new QFilter("view.treetype", "=", (Object)ovType);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)parentId)) {
            f2.and(new QFilter("parent.id", "=", (Object)IDUtils.toLong((Object)parentId)));
        }
        QFilter f4 = new QFilter("org.enable", "=", (Object)SHOW_TYPE_NUMBER);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        String selectFields = "org.id,org.name,org.number,org.fcomment,parent.id,isleaf,longNumber,level,isfreeze";
        DataSet ds = ormOV.queryDataSet(OrgViewServiceHelper.class.getName(), "bos_org_structure", selectFields, new QFilter[]{f2, f4, freezeFilter}, "level,sortcode,longnumber");
        if (ds != null) {
            try {
                for (Row row : ds) {
                    String id = row.getString("org.id");
                    if (idset.contains(id)) continue;
                    idset.add(id);
                    String parentid = row.getString("parent.id");
                    String number = row.getString("longNumber");
                    String orgNumber = row.getString("org.number");
                    String name = row.getString("org.name");
                    TreeNode orgLeft = this.createNode(id, parentid, number, orgNumber, name, showType);
                    orgLeft.setLeaf(row.getBoolean("isleaf").booleanValue());
                    if (orgHashMap == null) continue;
                    ArrayList<TreeNode> treeNodeList = (ArrayList<TreeNode>)orgHashMap.get(parentid);
                    if (treeNodeList == null) {
                        treeNodeList = new ArrayList<TreeNode>(16);
                        orgHashMap.put(parentid, treeNodeList);
                    }
                    treeNodeList.add(orgLeft);
                }
            }
            catch (Throwable ex) {
                throw ex;
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
            }
        }
        return orgHashMap;
    }

    private TreeNode createNode(String id, String parentid, String number, String orgNumber, String name, String showType) {
        TreeNode orgLeft = new TreeNode();
        orgLeft.setId(id);
        orgLeft.setLongNumber(number);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("name", name);
        data.put("number", orgNumber);
        orgLeft.setData(data);
        orgLeft.setText(this.getTreeTextByShowType(orgLeft, showType));
        orgLeft.setParentid(parentid);
        return orgLeft;
    }

    protected TreeNode getCacheOrgTreeRoot(String treeKey) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(treeKey))) {
            TreeNode orgTreeRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeKey), TreeNode.class);
            return orgTreeRoot;
        }
        return null;
    }

    protected void cacheOrgTreeRoot(String treeKey, TreeNode orgTreeRoot) {
        this.getPageCache().put(treeKey, SerializationUtils.toJsonString((Object)orgTreeRoot));
    }
}

