/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.dao.adjust.ImportDataPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.FileImportUtils;
import kd.epm.eb.common.utils.excelImport.IUploadHandle;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.mapping.CheckResult;
import kd.epm.eb.formplugin.mapping.DimMappingImportUtils;
import kd.epm.eb.formplugin.mapping.WhiteListCheck;
import kd.epm.eb.formplugin.mapping.WhiteListExport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class WhiteListUtils
extends AbstractFormPlugin
implements UploadListener,
IUploadHandle {
    private static final Log log = LogFactory.getLog(WhiteListUtils.class);
    public static WhiteListExport Export = new WhiteListExport();
    public static WhiteListCheck Check = new WhiteListCheck();
    private boolean validate = true;
    private DynamicObject whiteList = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        FileImportUtils.registerUploadListener((kd.bos.form.plugin.AbstractFormPlugin)this, (UploadListener)this, (String)"attachmentpanelap");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndownload"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.uploadWhiteList();
                break;
            }
        }
    }

    private void uploadWhiteList() {
        boolean coverage = false;
        if ("1".equals(this.getModel().getValue("radiogroupfield"))) {
            coverage = false;
        } else if ("2".equals(this.getModel().getValue("radiogroupfield"))) {
            coverage = true;
        }
        this.getPageCache().put("file_upload_coverage", String.valueOf(coverage));
        FileImportUtils.handleUpload((IPageCache)this.getPageCache(), () -> this.before(), inputStream -> this.handle(inputStream), () -> this.after());
    }

    public void before() {
        this.whiteList = null;
        this.validate = true;
        Long whiteListId = IDUtils.toLong(this.getFormCustomParam("WHITELIST_ID"));
        if (IDUtils.isNotNull((Long)whiteListId)) {
            this.whiteList = BusinessDataServiceHelper.loadSingle((Object)whiteListId, (String)"eb_whitelist");
            boolean coverage = Boolean.parseBoolean(this.getPageCache().get("file_upload_coverage"));
            if (coverage) {
                DynamicObjectCollection entries = this.whiteList.getDynamicObjectCollection("entryentity");
                entries.clear();
            }
        }
    }

    public void handle(InputStream inputStream) {
        int colCount;
        if (inputStream == null) {
            return;
        }
        Workbook book = null;
        XSSFWorkbook errorBook = new XSSFWorkbook();
        try {
            book = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WhiteListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Sheet sheet = book.getSheetAt(0);
        boolean useExtBiz = this.whiteList.getBoolean("useextbiz");
        this.checkStyle(sheet);
        int n = colCount = sheet.getRow(0) != null ? sheet.getRow(0).getPhysicalNumberOfCells() : 0;
        if (useExtBiz && colCount < 6 || !useExtBiz && colCount < 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u767d\u540d\u5355Excel\u6570\u636e\u5217\u548c\u5df2\u9009\u767d\u540d\u5355\u5206\u5f55\u5217\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"WhiteListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        POIUtils.POIConfig config = new POIUtils.POIConfig();
        config.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
        POIUtils.get().copyBook(book, (Workbook)errorBook, config);
        Sheet errorSheet = errorBook.getSheetAt(0);
        int maxSeq = 0;
        LinkedHashMap keyMap = Maps.newLinkedHashMap();
        if (this.whiteList != null) {
            Row row;
            DynamicObjectCollection entries = this.whiteList.getDynamicObjectCollection("entryentity");
            for (DynamicObject _entry : entries) {
                maxSeq = _entry.getInt("seq");
            }
            int srcEntrySize = entries.size();
            HashMap<String, Set<String>> bizTypeMap = new HashMap<String, Set<String>>(16);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                String extBizType;
                String bizType;
                row = (Row)rows.next();
                if (row == null || row.getRowNum() == 0 || StringUtils.isEmpty((String)(bizType = POIUtils.getStringValue((Cell)row.getCell(0))))) continue;
                String bizNumber = POIUtils.getStringValue((Cell)row.getCell(1));
                Set bizNumberSet = bizTypeMap.computeIfAbsent(bizType, f -> Sets.newHashSetWithExpectedSize((int)16));
                bizNumberSet.add(bizNumber);
                if (!useExtBiz || StringUtils.isEmpty((String)(extBizType = POIUtils.getStringValue((Cell)row.getCell(3))))) continue;
                String extBizNumber = POIUtils.getStringValue((Cell)row.getCell(4));
                bizNumberSet = bizTypeMap.computeIfAbsent(extBizType, f -> Sets.newHashSetWithExpectedSize((int)16));
                bizNumberSet.add(extBizNumber);
            }
            HashMap<String, Map<String, ImportDataPojo>> importBizObjMap = new HashMap(16);
            if (!bizTypeMap.isEmpty()) {
                importBizObjMap = this.getImportBizObjMap(bizTypeMap);
            }
            Iterator rows2 = sheet.rowIterator();
            while (rows2.hasNext()) {
                boolean existValueRow;
                row = (Row)rows2.next();
                if (row == null || row.getRowNum() == 0 || !(existValueRow = POIUtils.isExistValueRow((Row)row))) continue;
                DynamicObject entry = entries.addNew();
                entry.set("id", (Object)DBServiceHelper.genGlobalLongId());
                entry.set("seq", (Object)(++maxSeq));
                String bizType = POIUtils.getStringValue((Cell)row.getCell(0));
                entry.set("biztype", (Object)bizType);
                String biznumber = POIUtils.getStringValue((Cell)row.getCell(1));
                entry.set("biznumber", (Object)biznumber);
                String bizName = POIUtils.getStringValue((Cell)row.getCell(2));
                bizName = this.getRealBizName(importBizObjMap, bizType, biznumber, bizName);
                entry.set("bizname", (Object)bizName);
                if (useExtBiz) {
                    String extBizType = POIUtils.getStringValue((Cell)row.getCell(3));
                    entry.set("extbiztype", (Object)extBizType);
                    String extBizNumber = POIUtils.getStringValue((Cell)row.getCell(4));
                    entry.set("extbiznumber", (Object)extBizNumber);
                    String extBizName = POIUtils.getStringValue((Cell)row.getCell(5));
                    extBizName = this.getRealBizName(importBizObjMap, extBizType, extBizNumber, extBizName);
                    entry.set("extbizname", (Object)extBizName);
                }
                entry.set("entrystatus", (Object)Boolean.TRUE);
                keyMap.put(Check.getWhiteKey(entry, useExtBiz), row.getRowNum());
            }
            CheckResult result = Check.validate(this.whiteList, srcEntrySize);
            String validateStr = result.validateStr.toString();
            if (StringUtils.isNotEmpty((String)validateStr)) {
                this.validate = false;
                String[] errors = StringUtils.split((String)validateStr, (String)"\r\n");
                if (errors != null) {
                    Pattern p = Pattern.compile("([A-Za-z0-9._-]+)");
                    StringBuilder key = new StringBuilder();
                    for (int i = 0; i < errors.length; ++i) {
                        Integer rowIndex = result.rowIndexes.get(i) - srcEntrySize;
                        if (rowIndex <= 0) continue;
                        if (rowIndex < 0) {
                            Matcher m = p.matcher(errors[i]);
                            key.setLength(0);
                            while (m.find()) {
                                key.append(m.group()).append('@');
                            }
                            if (key.length() > 0) {
                                key.setLength(key.length() - 1);
                            }
                            rowIndex = (Integer)keyMap.get(key.toString());
                        }
                        if (rowIndex == null || rowIndex < 0 || errorSheet.getRow(rowIndex.intValue()) == null) continue;
                        Cell cell = POIUtils.getCell((Sheet)errorSheet, (int)rowIndex, (int)0);
                        POIUtils.setCellStyleOfRed((Cell)cell);
                        String cellValue = cell.getStringCellValue();
                        if (cellValue == null || cellValue.trim().length() == 0) {
                            cell.setCellValue(errors[i]);
                            continue;
                        }
                        cell.setCellValue(cellValue + "\r\n" + errors[i]);
                    }
                }
                POIUtils.downloadFile((IFormView)this.getView(), (Workbook)errorBook);
            }
        }
    }

    private String getRealBizName(Map<String, Map<String, ImportDataPojo>> importBizObjMap, String bizType, String bizNumber, String bizName) {
        String pojoBizName;
        Map<String, ImportDataPojo> dataPojoMap;
        ImportDataPojo dataPojo;
        if (importBizObjMap.containsKey(bizType) && (dataPojo = (dataPojoMap = importBizObjMap.get(bizType)).get(bizNumber)) != null && !(pojoBizName = dataPojo.getBizname()).equals(bizName)) {
            bizName = pojoBizName;
        }
        return bizName;
    }

    private Map<String, Map<String, ImportDataPojo>> getImportBizObjMap(Map<String, Set<String>> bizTypeMap) {
        HashMap<String, Map<String, ImportDataPojo>> importBizObjMap = new HashMap<String, Map<String, ImportDataPojo>>(bizTypeMap.size());
        QFBuilder builder = new QFBuilder();
        for (Map.Entry<String, Set<String>> entry : bizTypeMap.entrySet()) {
            String bizType = entry.getKey();
            Set<String> bizNumberSet = entry.getValue();
            String entityNumber = DimMappingImportUtils.dealEntityNumber(bizType);
            String fields = "id,number,name";
            builder.clear();
            builder.add(new QFilter("number", "in", bizNumberSet));
            if ("bos_org_structure".equalsIgnoreCase(entityNumber) || "bos_adminorg_structure".equalsIgnoreCase(entityNumber)) {
                fields = "org.id,org.number,org.name";
                builder.clear();
                builder.add(new QFilter("org.number", "in", bizNumberSet));
                builder.add(new QFilter("view", "=", (Object)DimMappingImportUtils.getOrgView(entityNumber)));
                builder.add(new QFilter("isfreeze", "=", (Object)Character.valueOf('0')));
            }
            try {
                DataSet ds = QueryServiceHelper.queryDataSet((String)entityNumber, (String)entityNumber, (String)fields, (QFilter[])builder.toArrays(), null);
                Throwable throwable = null;
                try {
                    if (ds == null) continue;
                    Map bizImportDataMap = importBizObjMap.computeIfAbsent(bizType, f -> Maps.newHashMapWithExpectedSize((int)16));
                    for (kd.bos.algo.Row row : ds) {
                        ImportDataPojo importDataPojo = bizImportDataMap.computeIfAbsent(row.getString(1), f -> new ImportDataPojo());
                        importDataPojo.setBizid(row.getLong(0));
                        importDataPojo.setBiznumber(row.getString(1));
                        importDataPojo.setBizname(row.getString(2));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599(%1)\u7684\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002", (String)"WhiteListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{bizType}));
            }
        }
        return importBizObjMap;
    }

    protected void checkStyle(@NotNull Sheet sheet) {
        Row row = sheet.getRow(0);
        if (row == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WhiteListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (row != null) {
            String[] heads = this.getBizHeadInfo();
            for (int i = 0; i < heads.length; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WhiteListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String stringCellValue = cell.getStringCellValue();
                if (stringCellValue.contains(heads[i])) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WhiteListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"WhiteListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String[] getBizHeadInfo() {
        LinkedList heads = Lists.newLinkedList();
        heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599*", (String)"WhiteListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        heads.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801*", (String)"WhiteSetListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return heads.toArray(new String[0]);
    }

    public void after() {
        if (this.whiteList != null && this.validate) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.whiteList});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"WhiteListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Excel\u5bfc\u5165\u5931\u8d25\u3002", (String)"WhiteListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void upload(UploadEvent evt) {
        FileImportUtils.uploadFileUrls((kd.bos.form.plugin.AbstractFormPlugin)this, (Object[])evt.getUrls());
    }

    public void remove(UploadEvent evt) {
        FileImportUtils.removeFileUrls((kd.bos.form.plugin.AbstractFormPlugin)this, (Object[])evt.getUrls());
    }
}

