/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.materule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.control.dimmaterule.DimmateruleUtils;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.gridfilter.CommonFilter;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.obj.ObjectUtils;
import kd.epm.eb.control.impl.model.BgControlSchemeValueField;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;

public class AddDimmateRuleNew
extends AbstractBasePlugin
implements BeforeF7SelectListener,
RowClickEventListener,
CommonFilter {
    public static final Log logger = LogFactory.getLog(AddDimmateRuleNew.class);
    private static final String MODEL = "showmodel";
    private static final String BUSINESSMODEL = "showbusinessmodel";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String TITLE = "showtitle";
    private static final String PRIORITY = "showpriority";
    private static final String EFFECTIVETIME = "showeffectivetime";
    private static final String INVALIDTIME = "showinvalidtime";
    private static final String SHOWISONLYCONTROLSUIT = "showisonlycontrolsuit";
    private static final String APPLICATION = "application";
    private static final String BILL = "bill";
    private static final String ENTRYENTITY = "showdimmateruleentity";
    private static final String CARDENTITY = "cardentity";
    private static final String SHOWCARD = "showcard";
    private static final String SERVICECOL = "servicecol";
    private static final String EXTSERVICECOL = "extservicecol";
    private static final String MEMBERMAPPING = "membermapping";
    private static final String DIMNUMBER = "dimnumber";
    private static final String METRICMEMNER = "metricmember";
    private static final String ISDYNAMICVALUE = "isdynamicvalue";
    private static final String CONTROLPROCESS = "controlprocess";
    private static final String SOURCEGROUP = "sourcegroup";
    private static final String WRITEOFFSCHEMESHOW = "showwriteoffscheme";
    private static final String FLEXPANELAPVALUE = "flexpanelapvalue";
    private static final String VALUEFIELDSHOW = "showvaluefield";
    private static final String OPERATIONSHOW = "showoperation";
    private static final String TYPESHOW = "showtype";
    private static final String VALUESHOW = "showvalue";
    private static final String ISONLYCHECK = "isonlycheck";
    private static final String SELECTFORMREFRESH = "selectformrefresh";
    private List<String> ignoreCheckField = Arrays.asList("priority", "serqfilter", "controldimension", "userdefined1dim", "userdefined2dim", "userdefined3dim", "userdefined4dim", "userdefined5dim", "userdefined6dim");
    private static List<String> billList = Lists.newArrayList((Object[])new String[]{BillFieldTypeEmum.ORG.getNumber(), BillFieldTypeEmum.ACCOUNT.getNumber(), BillFieldTypeEmum.CURRENCY.getNumber(), BillFieldTypeEmum.PERIOD.getNumber(), BillFieldTypeEmum.ASSIST.getNumber()});
    List<String> showDimensionList = Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.ChangeType.getNumber());

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7Selected(Lists.newArrayList((Object[])new String[]{MODEL, BUSINESSMODEL, BILL, SERVICECOL, EXTSERVICECOL, MEMBERMAPPING, CONTROLPROCESS, WRITEOFFSCHEMESHOW, SOURCEGROUP}));
        EntryGrid entryGrid = (EntryGrid)this.getControl(SHOWCARD);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object iscopy = formShowParameter.getCustomParam("iscopy");
        if (OperationStatus.EDIT.equals((Object)formShowParameter.getStatus()) || iscopy != null) {
            formShowParameter.setCloseCallBack(new CloseCallBack("kd.epm.eb.formplugin.materule.DimensionMateRuleListPlugin", "closerefreshkey"));
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object iscopy = showParameter.getCustomParam("iscopy");
        if (!OperationStatus.ADDNEW.equals((Object)showParameter.getStatus()) || iscopy != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{APPLICATION, BILL});
            this.initModule();
            this.checkUpgrade();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.openWriteoffSchemeF7(evt);
    }

    private void openWriteoffSchemeF7(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (WRITEOFFSCHEMESHOW.equals(key)) {
            this.cacheCurrentPage();
            FormShowParameter form = new FormShowParameter();
            form.getOpenStyle().setShowType(ShowType.Modal);
            form.setFormId("eb_writeoffscheme");
            form.setCustomParam("billid", (Object)this.getBillId());
            form.setCustomParam("isnofromprocess", (Object)Boolean.TRUE);
            form.setCustomParam("iscanempty", (Object)Boolean.TRUE);
            HashSet<String> existids = new HashSet<String>(10);
            for (int r = 0; r < this.getModel().getEntryRowCount(CARDENTITY); ++r) {
                Long id = this.getModel().getEntryRowEntity(CARDENTITY, r).getLong("writeoffscheme.id");
                if (!IDUtils.isNotNull((Long)id)) continue;
                existids.add(String.valueOf(id));
            }
            form.setCustomParam("hasselectwriteoffschemes", (Object)JSONUtils.toString(existids));
            Long writeoffscheme = 0L;
            Object obj = this.getModel().getValue(WRITEOFFSCHEMESHOW);
            if (obj instanceof Long) {
                writeoffscheme = (Long)obj;
            } else if (obj instanceof DynamicObject) {
                writeoffscheme = ((DynamicObject)obj).getLong("id");
            }
            form.setCustomParam("selectwriteoffscheme", (Object)writeoffscheme);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SELECTFORMREFRESH);
            form.setCloseCallBack(callBack);
            this.getView().showForm(form);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cb) {
        Map returnvalue;
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (SELECTFORMREFRESH.equals(key) && (returnvalue = (Map)cb.getReturnData()) != null) {
            Long selectid = (Long)returnvalue.get("selectwriteoffscheme");
            if (IDUtils.isNotNull((Long)selectid)) {
                this.getModel().setValue(WRITEOFFSCHEMESHOW, returnvalue.get("selectwriteoffscheme"));
            } else {
                this.getModel().setValue(WRITEOFFSCHEMESHOW, null);
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getModel().getEntryEntity(SHOWCARD) != null && !this.getModel().getEntryEntity(SHOWCARD).isEmpty()) {
            DynamicObject entity = (DynamicObject)this.getModel().getEntryEntity(SHOWCARD).get(0);
            entity.set("showcardtitle", (Object)ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u4e00", (String)"AddDimmateRuleNew_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            entity.set("showcardcondition", (Object)ResManager.loadResFormat((String)"\u9002\u7528\u6761\u4ef6\uff1a\u65e0", (String)"AddDimmateRuleNew_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            entity.set("showcardpriority", (Object)ResManager.loadResFormat((String)"\u4f18\u5148\u7ea7\uff1a%1", (String)"AddDimmateRuleNew_22", (String)"epm-eb-formplugin", (Object[])new Object[]{1}));
        }
        this.switchPageNo(1);
        CardEntry entryGrid = (CardEntry)this.getControl(SHOWCARD);
        entryGrid.selectCard(Integer.valueOf(0));
        this.initModule();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.syncOnlyCheck(Convert.toBool((Object)this.getModel().getValue(ISONLYCHECK), (Boolean)false));
        this.setDynamicValueState(this.getModel() != null && this.isDynamic() != false);
        this.reloadControlProcess();
        this.showDimmateRuleCard();
        this.initValueFields();
        this.switchPageNo(1);
        if (this.getModel().getEntryRowCount(SHOWCARD) > 0) {
            this.showPageInfo(1);
            CardEntry entryGrid = (CardEntry)this.getControl(SHOWCARD);
            entryGrid.selectCard(Integer.valueOf(0));
        } else {
            this.getModel().insertEntryRow(SHOWCARD, 0);
            int cardentityCnt = this.getModel().getEntryRowCount(CARDENTITY);
            this.getModel().setValue("realseq", (Object)(cardentityCnt + 1), 0);
            this.getModel().setValue(PRIORITY, (Object)1);
            this.getModel().insertEntryRow(CARDENTITY, cardentityCnt);
            this.getModel().setValue("priority", (Object)(cardentityCnt + 1));
            CalendarHelper helper = new CalendarHelper();
            this.getModel().setValue(EFFECTIVETIME, (Object)helper.getStartDate(new Date()));
            this.getView().updateView(SHOWCARD);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowNo = evt.getRow() + 1;
        int currentPageNo = this.currentPageNo();
        if (currentPageNo == rowNo) {
            return;
        }
        this.cacheCurrentPage();
        this.showPageInfo(rowNo);
        this.switchPageNo(rowNo);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object o = ((BaseView)e.getSource()).getReturnData();
        if (o != null && "success".equals(o)) {
            e.setCheckDataChange(false);
            return;
        }
        this.cacheCurrentPage();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        for (IDataEntityProperty property : dataEntity.getDynamicObjectType().getProperties()) {
            if (!property.getName().startsWith("show")) continue;
            dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
        }
        for (ICollectionProperty entryProperty : dataEntity.getDynamicObjectType().getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection entryField;
            if (!CARDENTITY.equals(entryProperty.getName())) {
                entryField = dataEntity.getDynamicObjectCollection(entryProperty.getName());
                for (IDataEntityProperty property : entryField.getDynamicObjectType().getProperties()) {
                    entryField.forEach(k -> k.getDataEntityState().setBizChanged(property.getOrdinal(), false));
                }
                continue;
            }
            entryField = dataEntity.getDynamicObjectCollection(entryProperty.getName());
            DataEntityPropertyCollection properties = entryField.getDynamicObjectType().getProperties();
            for (String ignoreField : this.ignoreCheckField) {
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)properties.get((Object)ignoreField);
                if (dataEntityProperty == null) continue;
                for (DynamicObject dynamicObject : entryField) {
                    IDataEntityProperty baseDataIdProp;
                    if (dataEntityProperty instanceof BasedataProp && (baseDataIdProp = (IDataEntityProperty)properties.get((Object)(ignoreField + "_id"))) != null) {
                        dynamicObject.getDataEntityState().setBizChanged(baseDataIdProp.getOrdinal(), false);
                    }
                    dynamicObject.getDataEntityState().setBizChanged(dataEntityProperty.getOrdinal(), false);
                }
            }
        }
    }

    private String getDimKey(String dimnumber) {
        return this.getKey(dimnumber, "dim");
    }

    private String getFieldKey(String dimnumber) {
        return this.getKey(dimnumber, "field");
    }

    private String getFieldExtKey(String dimnumber) {
        return this.getKey(dimnumber, "fieldext");
    }

    private String getDimMappingKey(String dimnumber) {
        return this.getKey(dimnumber, "dimsionmap");
    }

    private String getKey(String dimNumber, String suffix) {
        if (this.showDimensionList.contains(dimNumber)) {
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return "yearfield";
            }
            return this.getKey(dimNumber.toLowerCase(Locale.ENGLISH), suffix);
        }
        return dimNumber + suffix;
    }

    private void cacheCurrentPage() {
        try {
            int r;
            this.getModel().beginInit();
            int currentPageNo = this.currentPageNo();
            DynamicObject entryRowEntity = this.getRealCardEntry(currentPageNo - 1);
            if (!StringUtils.equals((String)JSONUtils.toString((Object)this.getModel().getValue(TITLE)), (String)JSONUtils.toString((Object)entryRowEntity.getLocaleString("title")))) {
                entryRowEntity.set("title", this.getModel().getValue(TITLE));
            }
            entryRowEntity.set("priority", this.getModel().getValue(PRIORITY));
            entryRowEntity.set("model", this.getModel().getValue(MODEL));
            entryRowEntity.set("isonlycontrolsuit", this.getModel().getValue(SHOWISONLYCONTROLSUIT));
            Long modelId = this.getModelId();
            if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
                if (CommonUtils.isBgmdModel((Long)modelId)) {
                    entryRowEntity.set("bussmodel", this.getModel().getValue(BUSINESSMODEL));
                } else if (CommonUtils.isBgModel((Long)modelId)) {
                    DynamicObject defaultBusinessModel = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"id", (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArrays());
                    if (defaultBusinessModel != null) {
                        entryRowEntity.set("bussmodel", (Object)defaultBusinessModel);
                    }
                } else {
                    entryRowEntity.set("bussmodel", null);
                }
            }
            entryRowEntity.set("effectivetime", this.getModel().getValue(EFFECTIVETIME));
            entryRowEntity.set("invalidtime", this.getModel().getValue(INVALIDTIME));
            if (this.getModel().getValue(BILL) != null) {
                FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
                DynamicObject billObj = (DynamicObject)this.getModel().getValue(BILL);
                try {
                    FlexBDValueCondition flexBDValueCondition = this.filterConditionValue(filterGrid, billObj.getString("number"));
                    if (flexBDValueCondition != null && flexBDValueCondition.getFilterCondition() != null && flexBDValueCondition.getFilterCondition().getFilterRow().size() > 0) {
                        String serqfilter = SerializationUtils.toJsonString((Object)flexBDValueCondition);
                        entryRowEntity.set("serqfilter", (Object)serqfilter);
                    } else {
                        entryRowEntity.set("serqfilter", null);
                    }
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                entryRowEntity.set("qfilter", null);
                entryRowEntity.set("billid", (Object)billObj.getLong("id"));
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            int i = 0;
            ArrayList<ILocaleString> dimName = new ArrayList<ILocaleString>();
            for (DynamicObject dy : entryentity) {
                Object dimnumber = dy.getString(DIMNUMBER);
                if (!this.showDimensionList.contains(dimnumber)) {
                    dimnumber = "userdefined" + ++i;
                    if (dy.get(SERVICECOL) != null) {
                        entryRowEntity.set(this.getDimKey((String)dimnumber), dy.get("dimension"));
                    } else {
                        entryRowEntity.set(this.getDimKey((String)dimnumber), null);
                    }
                }
                entryRowEntity.set(this.getFieldKey((String)dimnumber), (Object)dy.getDynamicObject(SERVICECOL));
                if (!Arrays.asList(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Metric.getNumber()).contains(dimnumber)) {
                    entryRowEntity.set(this.getFieldExtKey((String)dimnumber), (Object)dy.getDynamicObject(EXTSERVICECOL));
                    entryRowEntity.set(this.getDimMappingKey((String)dimnumber), (Object)dy.getDynamicObject(MEMBERMAPPING));
                }
                if (entryRowEntity.get(this.getFieldKey((String)dimnumber)) == null) continue;
                dimName.add(dy.getLocaleString("dimension.name"));
            }
            if (dimName.size() > 0) {
                ILocaleString ormVal = (ILocaleString)dimName.get(0);
                ILocaleString localeString = entryRowEntity.getLocaleString("controldimension");
                for (Map.Entry entry : ormVal.entrySet()) {
                    String dimStr = dimName.stream().filter(k -> StringUtils.isNotEmpty((String)((String)k.getItem((String)entry.getKey())))).map(k -> {
                        String strName = (String)k.getItem((String)entry.getKey());
                        if (strName == null) {
                            strName = k.getLocaleValue_zh_CN();
                        }
                        return strName;
                    }).collect(Collectors.joining("\u3001"));
                    localeString.put(entry.getKey(), (Object)dimStr);
                }
                entryRowEntity.set("controldimension", (Object)localeString);
            }
            entryRowEntity.set("writeoffscheme", this.getModel().getValue(WRITEOFFSCHEMESHOW));
            DynamicObjectCollection valuefieldentry = entryRowEntity.getDynamicObjectCollection("valuefieldentry");
            int rowCount = this.getModel().getEntryRowCount(VALUESHOW);
            for (r = valuefieldentry.size() - 1; r >= rowCount; --r) {
                valuefieldentry.remove(r);
            }
            for (r = 0; r < rowCount; ++r) {
                DynamicObject row = null;
                row = r >= valuefieldentry.size() ? valuefieldentry.addNew() : (DynamicObject)valuefieldentry.get(r);
                row.set("type", this.getModel().getValue(TYPESHOW, r));
                row.set("operation", this.getModel().getValue(OPERATIONSHOW, r));
                if (!StringUtils.isNotEmpty((String)row.getString("valuefield")) && !StringUtils.isNotEmpty((String)StringUtils.toNoEmptyString((Object)this.getModel().getValue(VALUEFIELDSHOW, r)))) continue;
                row.set("valuefield", this.getModel().getValue(VALUEFIELDSHOW, r));
            }
            this.getModel().endInit();
        }
        catch (Exception e) {
            logger.error("cachecurrentpagerror", (Throwable)e);
        }
    }

    private void showPageInfo(int pageRow) {
        try {
            this.getModel().beginInit();
            DynamicObject dynObj = pageRow > 0 ? this.getRealCardEntry(pageRow - 1) : new DynamicObject(this.getModel().getEntryEntity(CARDENTITY).getDynamicObjectType());
            this.getModel().setValue(TITLE, dynObj.get("title"));
            this.getModel().setValue(PRIORITY, (Object)pageRow);
            this.getModel().setValue(SHOWISONLYCONTROLSUIT, dynObj.get("isonlycontrolsuit"));
            this.getModel().setValue(MODEL, dynObj.get("model"));
            this.getModel().setValue(BUSINESSMODEL, dynObj.get("bussmodel"));
            if (dynObj.get("model") != null && !CommonUtils.isBgmdModel((Long)dynObj.getLong("model.id"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BUSINESSMODEL});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BUSINESSMODEL});
            }
            this.getModel().setValue(EFFECTIVETIME, (Object)dynObj.getDate("effectivetime"));
            this.getModel().setValue(INVALIDTIME, (Object)dynObj.getDate("invalidtime"));
            this.showWriteOffAndValueFields(dynObj);
            this.getModel().endInit();
            this.updateView(TITLE, MODEL, BUSINESSMODEL, PRIORITY, EFFECTIVETIME, INVALIDTIME, SHOWISONLYCONTROLSUIT);
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            if (StringUtils.isNotEmpty((String)dynObj.getString("serqfilter"))) {
                if (!this.isOldCond(dynObj.getString("serqfilter")).booleanValue()) {
                    FlexBDValueCondition fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)dynObj.getString("serqfilter"), FlexBDValueCondition.class);
                    filterGrid.SetValue(fc.getFilterCondition());
                } else {
                    FilterCondition filterCondition = this.tansferFilterCondition(filterGrid, dynObj.getString("serqfilter"));
                    filterGrid.SetValue(filterCondition);
                }
            } else {
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                FilterCondition filterCondition = filterGridState.getFilterCondition();
                filterCondition.getFilterRow().clear();
                filterGrid.SetValue(filterCondition);
                filterGrid.bindData(null);
            }
            this.showDimensionEntry();
            this.initMerticBaseData();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String dimNumber = dynamicObject.getString(DIMNUMBER);
                this.getModel().setValue(SERVICECOL, (Object)dynObj.getDynamicObject(this.getFieldKey(dimNumber)), i);
                if (Arrays.asList(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Metric.getNumber()).contains(dimNumber)) continue;
                this.getModel().setValue(EXTSERVICECOL, (Object)dynObj.getDynamicObject(this.getFieldExtKey(dimNumber)), i);
                this.getModel().setValue(MEMBERMAPPING, (Object)dynObj.getDynamicObject(this.getDimMappingKey(dimNumber)), i);
            }
        }
        catch (Exception e) {
            logger.error("pageInfoshowerror", (Throwable)e);
        }
    }

    private DynamicObject getRealCardEntry(int showIndex) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(SHOWCARD, showIndex);
        int realSeq = dynamicObject.getInt("realseq");
        int losts = realSeq - this.getModel().getEntryRowCount(CARDENTITY);
        if (losts > 0) {
            return this.getModel().getEntryRowEntity(CARDENTITY, realSeq - losts - 1);
        }
        return this.getModel().getEntryRowEntity(CARDENTITY, realSeq - 1);
    }

    @Override
    public Long getModelId() {
        return this.getPageF7Id(MODEL);
    }

    private Long getBillId() {
        return this.getPageF7Id(BILL);
    }

    private Long getBussModelId() {
        return this.getPageF7Id(BUSINESSMODEL);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) {
            case "showmodel": {
                PluginUtils.setModelFilter(beforeF7SelectEvent, this.getView());
                break;
            }
            case "showbusinessmodel": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("model", "=", (Object)this.getF7FilterId(beforeF7SelectEvent, MODEL)));
                break;
            }
            case "bill": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("parent", "=", (Object)this.getF7FilterId(beforeF7SelectEvent, APPLICATION)));
                break;
            }
            case "extservicecol": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("id", "!=", (Object)this.getF7FilterId(beforeF7SelectEvent, "showdimmateruleentity.servicecol")));
            }
            case "servicecol": {
                int row = beforeF7SelectEvent.getRow();
                String dimnumber = this.getModel().getEntryRowEntity(ENTRYENTITY, row).getString("dimension.number");
                ArrayList qFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", (Object)this.initBusCol(dimnumber).toArray(new Long[0]))});
                this.addF7Filters(beforeF7SelectEvent, qFilterList);
                break;
            }
            case "membermapping": {
                int rowNum = beforeF7SelectEvent.getRow();
                if (this.getModel().getValue(SERVICECOL) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5b57\u6bb5\u3002", (String)"AddDimmaterule_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                }
                String dimnum = this.getModel().getEntryRowEntity(ENTRYENTITY, rowNum).getString("dimension.number");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterLists = new ArrayList<QFilter>(16);
                Long model = this.getF7FilterId(beforeF7SelectEvent, MODEL);
                qFilterLists.add(new QFilter("model", "=", (Object)model));
                if (CommonUtils.isBgmdModel((Long)model)) {
                    qFilterLists.add(new QFilter("bussmodel", "=", (Object)this.getBussModelId()));
                }
                if (this.getModel().getValue(EXTSERVICECOL, rowNum) != null) {
                    qFilterLists.add(new QFilter("useassistdata", "=", (Object)true));
                } else {
                    qFilterLists.add(new QFilter("useassistdata", "=", (Object)false));
                }
                qFilterLists.add(new QFilter(DIMNUMBER, "=", (Object)dimnum));
                this.addF7Filters(beforeF7SelectEvent, qFilterLists);
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)model);
                break;
            }
            case "controlprocess": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("entryentity.bill", "=", (Object)this.getF7FilterId(beforeF7SelectEvent, BILL)));
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setSelectedRows(this.getIds(this.getModel().getValue(CONTROLPROCESS), null).toArray());
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setShowTitle(true);
                break;
            }
            case "sourcegroup": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter(BILL, "!=", (Object)this.getF7FilterId(beforeF7SelectEvent, BILL)));
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setSelectedRows(this.getIds(this.getModel().getValue(SOURCEGROUP), null).toArray());
                break;
            }
            case "showwriteoffscheme": {
                if (!"click".equals(beforeF7SelectEvent.getSourceMethod())) break;
                beforeF7SelectEvent.setCancel(true);
                DynamicObjectCollection col = (DynamicObjectCollection)this.getModel().getValue(SOURCEGROUP);
                if (col == null || col.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5173\u8054\u4e0a\u6e38\u5355\u636e\u89c4\u5219\u7ec4\u3002", (String)"AddDimmaterule_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.openWriteoffSchemeF7((EventObject)beforeF7SelectEvent);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bill": {
                this.initModule();
                this.initValueFields();
                int cardCount = this.getModel().getEntryRowCount(CARDENTITY);
                if (cardCount > 1) {
                    for (int i = 0; i < cardCount; ++i) {
                        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(CARDENTITY, i);
                        entryRowEntity.set("serqfilter", null);
                        this.clearDimmate(entryRowEntity);
                    }
                }
                for (int index = 0; index < this.getModel().getEntryRowCount(ENTRYENTITY); ++index) {
                    this.getModel().setValue(SERVICECOL, null, index);
                    this.getModel().setValue(EXTSERVICECOL, null, index);
                    this.getModel().setValue(MEMBERMAPPING, null, index);
                }
                this.getModel().setValue(CONTROLPROCESS, null);
                break;
            }
            case "showmodel": {
                if (this.getModel().getValue(MODEL) != null && !CommonUtils.isBgmdModel((Long)this.getModelId())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BUSINESSMODEL});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BUSINESSMODEL});
                }
                this.getModel().setValue(BUSINESSMODEL, null);
            }
            case "showbusinessmodel": {
                this.showDimensionEntry();
                this.initMerticBaseData();
                if (e.getChangeSet()[0].getOldValue() == null) break;
                this.clearDimmate(this.getRealCardEntry(this.currentPageNo() - 1));
                break;
            }
            case "servicecol": {
                ChangeData changeData = e.getChangeSet()[0];
                if (changeData.getNewValue() != null || this.getModel().getValue(MEMBERMAPPING, changeData.getRowIndex()) == null) break;
                this.getModel().setValue(MEMBERMAPPING, null, changeData.getRowIndex());
                this.getModel().setValue(EXTSERVICECOL, null, changeData.getRowIndex());
                break;
            }
            case "extservicecol": {
                ChangeData changeData1 = e.getChangeSet()[0];
                if (changeData1.getNewValue() != null && changeData1.getOldValue() != null) break;
                this.getModel().setValue(MEMBERMAPPING, null, changeData1.getRowIndex());
                break;
            }
            case "application": {
                this.getModel().setValue(BILL, null);
                break;
            }
            case "isdynamicvalue": {
                if (e.getChangeSet() == null || e.getChangeSet()[0] == null || ObjectUtils.equals((Object)e.getChangeSet()[0].getOldValue(), (Object)e.getChangeSet()[0].getNewValue())) break;
                this.setDynamicValueState((Boolean)e.getChangeSet()[0].getNewValue());
                break;
            }
            case "controlprocess": {
                this.syncControlProcess(e);
            }
            case "sourcegroup": {
                this.checkSourceGroup(e);
                break;
            }
            case "showwriteoffscheme": {
                this.checkWriteoffScheme(e);
                break;
            }
            case "isonlycheck": {
                this.syncOnlyCheck(e);
            }
        }
    }

    private void syncOnlyCheck(PropertyChangedArgs e) {
        this.syncOnlyCheck(e != null && e.getChangeSet() != null && e.getChangeSet().length > 0 && Convert.toBool((Object)e.getChangeSet()[0].getNewValue(), (Boolean)false) != false);
    }

    private void syncOnlyCheck(boolean isOnlyCheck) {
        if (isOnlyCheck) {
            this.getModel().setValue(ISDYNAMICVALUE, (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ISDYNAMICVALUE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ISDYNAMICVALUE});
        }
    }

    private void checkWriteoffScheme(PropertyChangedArgs e) {
        Set<Long> newids;
        if ("issetwriteoffscheme".equals(this.getPageCache().get("issetwriteoffscheme"))) {
            this.getPageCache().remove("issetwriteoffscheme");
            return;
        }
        Set<Long> oldids = this.getIds(e, false);
        if (oldids.equals(newids = this.getIds(e, true))) {
            return;
        }
        if (!newids.isEmpty() && this.isDynamic().booleanValue()) {
            HashMap<Long, String> billtypeids = new HashMap<Long, String>(10);
            HashMap<Long, Set<Long>> writeoffbills = new HashMap<Long, Set<Long>>(10);
            this.getBillTypeIds(billtypeids);
            this.getWriteoffBills(writeoffbills, newids);
            String msg = null;
            for (Long newid : newids) {
                DynamicObject billinfo;
                Set billids = (Set)writeoffbills.get(newid);
                Long billId = 0L;
                for (Long bill : billids) {
                    if (billtypeids.containsKey(bill)) continue;
                    billId = bill;
                    break;
                }
                if (billId != 0L && (billinfo = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"eb_structofbill", (String)"fieldtable")) != null) {
                    String billname = EntityMetadataCache.getDataEntityType((String)billinfo.getString("fieldtable")).getDisplayName().getLocaleValue();
                    DynamicObject dynamicObject = this.getRealCardEntry(this.currentPageNo() - 1);
                    msg = ResManager.loadResFormat((String)"%1\u7684\u51b2\u9500\u65b9\u6848\u4e2d\u5305\u542b\u4e0a\u6e38\u5355\u636e-%2\uff0c\u8be5\u5355\u636e\u672a\u7ed1\u5b9a\u5173\u8054\u5339\u914d\u89c4\u5219\u7ec4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddDimmaterule_41", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("title"), billname});
                }
                if (msg == null) continue;
                this.getView().showTipNotification(msg);
                this.getPageCache().put("issetwriteoffscheme", "issetwriteoffscheme");
                if (oldids != null && !oldids.isEmpty()) {
                    this.getModel().setValue(WRITEOFFSCHEMESHOW, e.getChangeSet()[0].getOldValue());
                    continue;
                }
                this.getModel().setValue(WRITEOFFSCHEMESHOW, null);
            }
        }
    }

    private void initValueFields() {
        Object field2;
        Long billId = this.getBillId();
        if (IDUtils.isNull((Long)billId)) {
            return;
        }
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"eb_structofbill", (String)"id,fieldtable");
        if (bill == null) {
            return;
        }
        ComboEdit itemc = (ComboEdit)this.getControl(TYPESHOW);
        ArrayList<ComboItem> com = new ArrayList<ComboItem>(16);
        com.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u5360\u7528", (String)"AddDimmaterule_32", (String)"epm-eb-formplugin", (Object[])new Object[0])), String.valueOf(BillFieldTypeEmum.TAKEOPERATION.getIndex())));
        com.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u6267\u884c", (String)"AddDimmaterule_33", (String)"epm-eb-formplugin", (Object[])new Object[0])), String.valueOf(BillFieldTypeEmum.RUNOPERATION.getIndex())));
        itemc.setComboItems(com);
        itemc = (ComboEdit)this.getControl(OPERATIONSHOW);
        HashMap<String, String> operaionNames = new HashMap<String, String>(16);
        EntityMetadata entityMeta = null;
        try {
            entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)bill.getString("fieldtable"), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entityMeta != null && entityMeta.getRootEntity() != null && entityMeta.getRootEntity().getOperations() != null) {
            MainEntity rootEntity = entityMeta.getRootEntity();
            for (Operation oper : rootEntity.getOperations()) {
                if (StringUtils.isNotEmpty((String)oper.getName().getLocaleValue())) continue;
                operaionNames.put(oper.getKey(), oper.getName().getLocaleValue());
            }
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bill.getString("fieldtable"));
        String name = null;
        String number = null;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("fieldtable", "=", (Object)bill.getString("fieldtable")));
        builder.add(new QFilter("type", "in", (Object)Sets.newHashSet((Object[])new String[]{BillFieldTypeEmum.TAKEOPERATION.getNumber(), BillFieldTypeEmum.RUNOPERATION.getNumber()})));
        List fields = null;
        try (Object ds = QueryServiceHelper.queryDataSet((String)"queryBillOperations", (String)"eb_bgcontrolbizreg", (String)"number,name", (QFilter[])builder.toArray(), (String)"number");){
            fields = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        com = new ArrayList(16);
        if (fields != null) {
            for (Object field2 : fields) {
                number = String.valueOf(field2.get("number"));
                name = (String)operaionNames.get(number);
                if (StringUtils.isEmpty((String)name)) {
                    name = (String)field2.get("name");
                }
                com.add(new ComboItem(new LocaleString(name), number));
            }
        }
        itemc.setComboItems(com);
        itemc = (ComboEdit)this.getControl(VALUEFIELDSHOW);
        builder = new QFBuilder();
        builder.add(new QFilter("fieldtable", "=", (Object)bill.getString("fieldtable")));
        builder.add(new QFilter("type", "=", (Object)BillFieldTypeEmum.CONTROLVALUE.getNumber()));
        fields = null;
        ds = QueryServiceHelper.queryDataSet((String)"queryBillControlValues", (String)"eb_bgcontrolbizreg", (String)"number,name", (QFilter[])builder.toArray(), (String)"number");
        field2 = null;
        try {
            fields = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        catch (Throwable throwable) {
            field2 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (field2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)field2).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        com = new ArrayList(16);
        if (fields != null) {
            for (Object field2 : fields) {
                number = String.valueOf(field2.get("number"));
                name = BgRegisterUtils.getFieldName((MainEntityType)entityType, (String)number);
                if (StringUtils.isEmpty((String)name)) {
                    name = (String)field2.get("name");
                }
                com.add(new ComboItem(new LocaleString(name), number));
            }
        }
        itemc.setComboItems(com);
    }

    private void checkSourceGroup(PropertyChangedArgs e) {
        Set<Long> ids = this.getIds(e, true);
        if (ids != null && !ids.isEmpty()) {
            HashSet<String> hasBosTypes = new HashSet<String>(10);
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("id", "in", ids));
            String fields = "id, status, number, bill.number, bill.name";
            List dimmates = null;
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDimmate", (String)"eb_adddimmaterule", (String)fields, (QFilter[])builder.toArray(), (String)"number");
            Object object = null;
            try {
                dimmates = CommonServiceHelper.transDataSet((DataSet)ds);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (dimmates != null) {
                ArrayList<String> groupNumbers = new ArrayList<String>();
                for (Map dimmate : dimmates) {
                    if (!Convert.toBool(dimmate.get("status"), (Boolean)false).booleanValue()) {
                        groupNumbers.add((String)dimmate.get("number"));
                    }
                    if (hasBosTypes.contains(dimmate.get("bill.number"))) {
                        String name = (String)dimmate.get("bill.name");
                        if (StringUtils.isEmpty((String)name)) {
                            name = (String)dimmate.get("bill.number");
                        }
                        this.getModel().setValue(SOURCEGROUP, e.getChangeSet()[0].getOldValue());
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u9009\u62e9\u591a\u4e2a\u5339\u914d\u89c4\u5219\u7ec4\uff0c\u6bcf\u4e2a\u5355\u636e\u7c7b\u578b\u8bf7\u9009\u62e9\u552f\u4e00\u5339\u914d\u89c4\u5219\u7ec4\u3002", (String)"AddDimmaterule_31", (String)"epm-eb-formplugin", (Object[])new Object[]{name}));
                        return;
                    }
                    hasBosTypes.add((String)dimmate.get("bill.number"));
                }
                if (!groupNumbers.isEmpty()) {
                    String msg = StringUtils.join(groupNumbers, (String)",");
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5173\u8054\u4e0a\u6e38\u5355\u636e\u89c4\u5219\u7ec4\u5305\u542b\u7981\u7528\u72b6\u6001\u89c4\u5219\u7ec4\u201c%1\u201d\u3002", (String)"AddDimmaterule_40", (String)"epm-eb-formplugin", (Object[])new Object[]{msg}));
                }
            }
        }
    }

    private void reloadControlProcess() {
        Set<Long> newIds = this.getIds(this.getModel().getValue(CONTROLPROCESS), null);
        if (newIds == null || newIds.isEmpty()) {
            return;
        }
        BgControlSchemeValueField valueField = new BgControlSchemeValueField();
        Long writeschemeid = this.queryControlProcessInfo(newIds, valueField);
        this.setDefaultWriteOffId(writeschemeid);
        this.setDefaultValueFields(valueField);
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(CARDENTITY);
        HashSet<Pair> hasKey = new HashSet<Pair>();
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObjectCollection valuefieldentry = ((DynamicObject)entryEntitys.get(i)).getDynamicObjectCollection("valuefieldentry");
            hasKey.clear();
            Iterator it = valuefieldentry.iterator();
            while (it.hasNext()) {
                DynamicObject v = (DynamicObject)it.next();
                Pair key = Pair.onePair((Object)v.getString("type"), (Object)v.getString("operation"));
                if (valueField.getValueFields().get(key) == null) {
                    it.remove();
                    continue;
                }
                hasKey.add(key);
            }
            for (Map.Entry entry : valueField.getValueFields().entrySet()) {
                if (hasKey.contains(entry.getKey())) continue;
                DynamicObject obj = valuefieldentry.addNew();
                obj.set("type", ((Pair)entry.getKey()).p1);
                obj.set("operation", ((Pair)entry.getKey()).p2);
                obj.set("valuefield", entry.getValue());
            }
            valuefieldentry.sort((o1, o2) -> o1.getString("type").compareTo(o2.getString("type")));
        }
    }

    private void syncControlProcess(PropertyChangedArgs e) {
        Set<Long> newIds;
        Set<Long> oldIds = this.getIds(e, false);
        if (oldIds.equals(newIds = this.getIds(e, true))) {
            return;
        }
        Long writeoffschemeid = null;
        BgControlSchemeValueField valueField = new BgControlSchemeValueField();
        writeoffschemeid = this.queryControlProcessInfo(newIds, valueField);
        this.setDefaultWriteOffId(writeoffschemeid);
        this.setDefaultValueFields(valueField);
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(CARDENTITY);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            this.setDefaultByProcess((DynamicObject)entryEntitys.get(i), writeoffschemeid, valueField);
        }
        this.getModel().beginInit();
        if (entryEntitys.size() > 0) {
            this.showWriteOffAndValueFields((DynamicObject)entryEntitys.get(0));
        }
        this.getModel().endInit();
    }

    private Long queryControlProcessInfo(Set<Long> newIds, BgControlSchemeValueField valueField) {
        Long writeoffschemeid = null;
        if (newIds != null && !newIds.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("id", "in", newIds));
            builder.add(new QFilter("entryentity.bill", "=", (Object)this.getBillId()));
            String fields = "number, entryentity.runoperation, entryentity.runvalue,entryentity.takeoperation,entryentity.takevalue,entryentity.writeoffscheme";
            List processes = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryProcessFields", (String)"eb_bgcontrolprocess", (String)fields, (QFilter[])builder.toArrays(), null);){
                processes = CommonServiceHelper.transDataSet((DataSet)ds);
            }
            if (processes != null && !processes.isEmpty()) {
                for (Map process : processes) {
                    valueField.addFromControlProcess(BillFieldTypeEmum.TAKEOPERATION, (String)process.get("entryentity.takeoperation"), (String)process.get("entryentity.takevalue"));
                    valueField.addFromControlProcess(BillFieldTypeEmum.RUNOPERATION, (String)process.get("entryentity.runoperation"), (String)process.get("entryentity.runvalue"));
                    Long _thiswriteid = IDUtils.toLong(process.get("entryentity.writeoffscheme"));
                    if (!IDUtils.isNotNull((Long)_thiswriteid)) continue;
                    if (writeoffschemeid == null) {
                        writeoffschemeid = _thiswriteid;
                        continue;
                    }
                    if (writeoffschemeid.equals(_thiswriteid)) continue;
                    writeoffschemeid = 0L;
                }
            }
        }
        if (writeoffschemeid == null) {
            writeoffschemeid = 0L;
        }
        return writeoffschemeid;
    }

    private void setDefaultByProcess(DynamicObject entryEntity, Long writeoffschemeid, BgControlSchemeValueField valueField) {
        if (entryEntity == null) {
            return;
        }
        if (IDUtils.isNotNull((Long)writeoffschemeid)) {
            entryEntity.set("writeoffscheme", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)writeoffschemeid, (String)"eb_writeoffscheme_pro"));
        } else {
            entryEntity.set("writeoffscheme", null);
        }
        DynamicObjectCollection valuefieldentry = entryEntity.getDynamicObjectCollection("valuefieldentry");
        valuefieldentry.clear();
        if (valueField != null) {
            for (Map.Entry entry : valueField.getValueFields().entrySet()) {
                DynamicObject obj = valuefieldentry.addNew();
                obj.set("type", ((Pair)entry.getKey()).p1);
                obj.set("operation", ((Pair)entry.getKey()).p2);
                obj.set("valuefield", entry.getValue());
            }
            valuefieldentry.sort((o1, o2) -> o1.getString("type").compareTo(o2.getString("type")));
        }
    }

    private void setDefaultWriteOffId(Long writeoffschemeid) {
        this.getPageCache().put("DefaultWriteOffId", String.valueOf(writeoffschemeid));
    }

    private Long getDefaultWriteOffId() {
        return IDUtils.toLong((Object)this.getPageCache().get("DefaultWriteOffId"));
    }

    private void setDefaultValueFields(BgControlSchemeValueField valueField) {
        String json = "";
        if (valueField != null) {
            json = valueField.toJsonString();
        }
        this.getPageCache().put("DefaultValueFields", json);
    }

    private BgControlSchemeValueField getDefaultValueFields() {
        String json = this.getPageCache().get("DefaultValueFields");
        BgControlSchemeValueField valueField = new BgControlSchemeValueField();
        valueField.loadFromJson(json);
        return valueField;
    }

    private void showWriteOffAndValueFields(DynamicObject dynObj) {
        this.getModel().deleteEntryData(VALUESHOW);
        if (dynObj == null) {
            this.getModel().setValue(WRITEOFFSCHEMESHOW, (Object)0L);
            this.updateView(WRITEOFFSCHEMESHOW);
            this.updateView(VALUESHOW);
            return;
        }
        Object writeoff = dynObj.get("writeoffscheme");
        if (writeoff instanceof Long && IDUtils.isNull((Long)((Long)writeoff))) {
            writeoff = null;
        }
        this.getModel().setValue(WRITEOFFSCHEMESHOW, writeoff);
        DynamicObjectCollection values = dynObj.getDynamicObjectCollection("valuefieldentry");
        if (values != null && !values.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(VALUESHOW, values.size());
            HashSet<String> valueNumbers = new HashSet<String>(10);
            DynamicObject billObj = (DynamicObject)this.getModel().getValue(BILL);
            if (billObj != null) {
                QFBuilder builder = new QFBuilder();
                builder.add(new QFilter("fieldtable", "=", (Object)billObj.getString("number")));
                builder.add(new QFilter("type", "=", (Object)BillFieldTypeEmum.CONTROLVALUE.getNumber()));
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBillControlValues", (String)"eb_bgcontrolbizreg", (String)"number", (QFilter[])builder.toArray(), (String)"number");){
                    while (ds != null && ds.hasNext()) {
                        valueNumbers.add(ds.next().getString("number"));
                    }
                }
            }
            for (int i = 0; i < values.size(); ++i) {
                DynamicObject value = (DynamicObject)values.get(i);
                this.getModel().setValue(TYPESHOW, value.get("type"), i);
                this.getModel().setValue(OPERATIONSHOW, value.get("operation"), i);
                if (!valueNumbers.contains(value.get("valuefield"))) continue;
                this.getModel().setValue(VALUEFIELDSHOW, value.get("valuefield"), i);
            }
        }
        this.updateView(WRITEOFFSCHEMESHOW);
        this.updateView(VALUESHOW);
    }

    private Set<Long> getIds(PropertyChangedArgs e, boolean isNew) {
        HashSet<Long> ids = new HashSet<Long>(10);
        if (e != null && e.getChangeSet() != null && e.getChangeSet() != null) {
            for (int i = 0; i < e.getChangeSet().length; ++i) {
                if (e.getChangeSet()[i] == null) continue;
                Object value = e.getChangeSet()[i].getNewValue();
                if (!isNew) {
                    value = e.getChangeSet()[i].getOldValue();
                }
                this.getIds(value, ids);
            }
        }
        return ids;
    }

    private Set<Long> getIds(Object value, Set<Long> ids) {
        if (ids == null) {
            ids = new HashSet<Long>(10);
        }
        if (value instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)value;
            ids.add(IDUtils.toLong((Object)obj.getPkValue()));
        } else if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection col = (DynamicObjectCollection)value;
            for (DynamicObject obj : col) {
                ids.add(IDUtils.toLong((Object)obj.get("fbasedataid.id")));
            }
        }
        return ids;
    }

    private void setDynamicValueState(boolean isDynamicValue) {
        this.getView().setVisible(Boolean.valueOf(isDynamicValue), new String[]{CONTROLPROCESS, SOURCEGROUP, WRITEOFFSCHEMESHOW, FLEXPANELAPVALUE});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            if (this.getModel().getEntryRowCount(CARDENTITY) == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u5339\u914d\u89c4\u5219\u3002", (String)"AddDimmateRuleNew_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Integer pageNo = this.currentPageNo();
            Integer switchPageNo = 0;
            if (pageNo == 1 && this.getModel().getEntryRowCount(SHOWCARD) > 1) {
                switchPageNo = 2;
                this.switchPageNo(switchPageNo - 1);
            } else {
                switchPageNo = pageNo - 1;
                this.switchPageNo(switchPageNo);
            }
            this.showPageInfo(switchPageNo);
            try {
                int realseq = this.getModel().getEntryRowEntity(SHOWCARD, pageNo - 1).getInt("realseq");
                this.getModel().deleteEntryRow(CARDENTITY, realseq - 1);
                for (int i = 0; i < this.getModel().getEntryRowCount(SHOWCARD); ++i) {
                    DynamicObject d = this.getModel().getEntryRowEntity(SHOWCARD, i);
                    if (realseq >= d.getInt("realseq")) continue;
                    this.getModel().setValue("realseq", (Object)(d.getInt("realseq") - 1), i);
                    if (i <= pageNo - 1) continue;
                    this.changePriority(i, d.getInt("seq") - 1);
                }
            }
            catch (Exception e) {
                logger.error("deleteentryerror", (Throwable)e);
            }
        } else if ("save".equals(operateKey)) {
            this.cacheCurrentPage();
            String checkInfo = this.checkData();
            if (checkInfo != null) {
                this.getView().showTipNotification(checkInfo);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge();
                opDesc.setDescription(checkInfo);
                this.writeLog(null, "save", this.getOpName(), opDesc, null, false);
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        Integer pageNo = this.currentPageNo();
        if ("newentry".equals(operate.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SHOWCARD);
            int index = entryEntity.size() - 1;
            this.getModel().setValue("showcardtitle", (Object)ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\uff08\u65b0\uff09", (String)"AddDimmateRuleNew_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), index);
            String cond = ResManager.loadResFormat((String)"\u9002\u7528\u6761\u4ef6\uff1a%1", (String)"AddDimmateRuleNew_21", (String)"epm-eb-formplugin", (Object[])new Object[]{"-"});
            this.getModel().setValue("showcardcondition", (Object)cond, index);
            this.changePriority(index, this.getModel().getEntryRowCount(SHOWCARD));
            int newIndex = this.getModel().createNewEntryRow(CARDENTITY);
            this.getModel().setValue("realseq", (Object)this.getModel().getEntryRowCount(CARDENTITY), index);
            if (this.getModel().getEntryRowCount(SHOWCARD) == 1) {
                this.setMustInput(true);
            }
            DynamicObject entity = this.getModel().getEntryRowEntity(CARDENTITY, newIndex);
            this.setDefaultByProcess(entity, this.getDefaultWriteOffId(), this.getDefaultValueFields());
        } else if ("copyentryrow".equals(operate.getOperateKey())) {
            this.cacheCurrentPage();
            this.getModel().beginInit();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SHOWCARD);
            int index = entryEntity.size() - 1;
            this.getModel().setValue("realseq", (Object)(this.getModel().getEntryRowCount(CARDENTITY) + 1), index);
            DynamicObject dyn = this.getModel().getEntryRowEntity(SHOWCARD, pageNo - 1);
            int entityIndex = dyn.getInt("realseq");
            DynamicObject copyobj = (DynamicObject)OrmUtils.clone((IDataEntityBase)this.getModel().getEntryRowEntity(CARDENTITY, entityIndex - 1), (boolean)true, (boolean)true);
            this.getModel().createNewEntryRow(CARDENTITY, copyobj);
            OrmLocaleValue copyTitleOrm = (OrmLocaleValue)this.getModel().getValue("title");
            if (this.getModel().getValue(TITLE) instanceof OrmLocaleValue) {
                OrmLocaleValue value = (OrmLocaleValue)this.getModel().getValue(TITLE);
                for (Map.Entry entry : value.entrySet()) {
                    copyTitleOrm.setItem((String)entry.getKey(), (String)entry.getValue() + "copy");
                }
            }
            this.getModel().endInit();
            this.getModel().setValue("title", (Object)copyTitleOrm, this.getModel().getEntryRowCount(CARDENTITY) - 1);
            this.getModel().setValue("showcardtitle", (Object)copyTitleOrm.getLocaleValue(), this.getModel().getEntryRowCount(SHOWCARD) - 1);
            this.changePriority(index, this.getModel().getEntryRowCount(SHOWCARD));
        } else if ("deleteentry".equals(operate.getOperateKey())) {
            CardEntry entryGrid = (CardEntry)this.getControl(SHOWCARD);
            entryGrid.selectCard(Integer.valueOf(pageNo - 1));
            if (this.getModel().getEntryRowCount(SHOWCARD) < 1) {
                this.setMustInput(false);
            }
        } else if ("moveentryup".equals(operate.getOperateKey())) {
            this.changePriority(pageNo - 1, pageNo);
            this.changePriority(pageNo - 2, pageNo - 1);
            this.switchPageNo(pageNo - 1);
            this.getModel().setValue(PRIORITY, (Object)(pageNo - 1));
        } else if ("moveentrydown".equals(operate.getOperateKey())) {
            this.changePriority(pageNo - 1, pageNo);
            this.changePriority(pageNo, pageNo + 1);
            this.switchPageNo(pageNo + 1);
            this.getModel().setValue(PRIORITY, (Object)(pageNo + 1));
            CardEntry cardEntry = (CardEntry)this.getControl(SHOWCARD);
            cardEntry.focusCell(pageNo.intValue(), "showcardtitle");
        } else if ("save".equals(operate.getOperateKey())) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            if (StringUtils.isEmpty((String)dynamicObject.getString("number"))) {
                dynamicObject.set("number", (Object)this.getCodeRuleNumber());
            }
            List realseqInt = this.getModel().getEntryEntity(SHOWCARD).stream().map(k -> k.getInt("realseq")).collect(Collectors.toList());
            List prioritys = dynamicObject.getDynamicObjectCollection(CARDENTITY).stream().collect(Collectors.toList());
            Map priorityMap = DimmateruleUtils.getInstance().sortPrioritys(prioritys, realseqInt);
            for (DynamicObject dynObj : dynamicObject.getDynamicObjectCollection(CARDENTITY)) {
                int seq = priorityMap.containsKey(dynObj.getInt("seq")) ? ((Integer)priorityMap.get(dynObj.getInt("seq"))).intValue() : dynObj.getInt("seq");
                dynObj.set("seq", (Object)seq);
                dynObj.set("priority", (Object)seq);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.getView().setEnable(Boolean.FALSE, new String[]{APPLICATION, BILL});
            if (dynamicObject.getDynamicObject(BILL) != null) {
                CacheServiceHelper.clearFieldsCache((String)dynamicObject.getDynamicObject(BILL).getString("number"));
            }
            this.getView().setReturnData((Object)"success");
            this.getView().returnDataToParent((Object)"success");
            MultiLangEnumBridge opName = this.getOpName();
            if (opName != null) {
                this.writeLog(dynamicObject.getString("number"), "save", opName, null, null);
            }
        }
    }

    private void addBeforeF7Selected(List<String> bdEdits) {
        for (String bdEdit : bdEdits) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(bdEdit);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private Integer currentPageNo() {
        String currentPageNo = this.getPageCache().get("currentPageNo");
        if (currentPageNo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9875\u53f7\u5f02\u5e38", (String)"AddDimmateRuleNew_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Integer.parseInt(currentPageNo);
    }

    private void switchPageNo(Integer pageNo) {
        this.getPageCache().put("currentPageNo", String.valueOf(pageNo));
    }

    private void initFilterGridap(DynamicObject dynamicObject) {
        try {
            List filterColumns = new ArrayList();
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            if (dynamicObject != null) {
                String billNumber = dynamicObject.getString("number");
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billNumber);
                filterColumns = this.getFilterFields(entityType);
                filterGrid.setEntityNumber(billNumber);
            }
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            filterGrid.setFilterColumns(filterColumns);
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            filterCondition.getFilterRow().clear();
            filterGrid.bindData(null);
            filterGrid.SetValue(filterCondition);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u6761\u4ef6\u63a7\u4ef6\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"AddDimmateRuleNew_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void showDimensionEntry() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (this.getModel().getValue(MODEL) == null) {
            return;
        }
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        List<Map<String, String>> showDims = this.queryDimension(modelId, this.getBussModelId());
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, showDims.size());
        int userDefIndex = 0;
        for (int i = 0; i < showDims.size(); ++i) {
            Map<String, String> dim = showDims.get(i);
            String dimnumber = dim.get("number");
            this.getModel().setValue("dimension", (Object)IDUtils.toLong((Object)dim.get("id")), i);
            if (!this.showDimensionList.contains(dimnumber)) {
                dimnumber = "userdefined" + ++userDefIndex;
            }
            this.getModel().setValue(DIMNUMBER, (Object)dimnumber, i);
            if (!Arrays.asList(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Metric.getNumber()).contains(dimnumber)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{EXTSERVICECOL, MEMBERMAPPING});
        }
    }

    private List<Map<String, String>> queryDimension(Long modelId, Long businessModelId) {
        HashSet<Long> dimensionIdSet = new HashSet<Long>(16);
        boolean hasBusinessModel = this.hasBusinessModel(modelId);
        String cacheKey = "controldimension_" + modelId + "_" + businessModelId;
        if (this.getPageCache().get(cacheKey) != null) {
            List dims = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(cacheKey), List.class);
            return dims;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        if (CommonUtils.hasBusinessModel((Long)modelId).booleanValue()) {
            if (CommonUtils.isBgmdModel((Long)modelId)) {
                builder.add(new QFilter("businessmodel.id", "=", (Object)businessModelId));
            }
            String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
            DynamicObjectCollection ctrlDims = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
            for (DynamicObject ctrlDim : ctrlDims) {
                if (!IDUtils.isNotEmptyLong((Long)ctrlDim.getLong("entryentity.dimensionid")).booleanValue()) continue;
                dimensionIdSet.add(ctrlDim.getLong("entryentity.dimensionid"));
            }
            builder.clear();
            if (dimensionIdSet.isEmpty()) {
                builder.add(new QFilter("model", "=", (Object)modelId));
                builder.add("issysdimension", "=", (Object)Boolean.TRUE);
            } else {
                builder.add(new QFilter("id", "in", dimensionIdSet));
            }
        }
        String selectField = "id,number,name,dseq,issysdimension,fieldmapped";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_dimension", (String)selectField, (QFilter[])builder.toArray(), (String)"dseq");
        ArrayList<Map<String, String>> showDimFlex = new ArrayList<Map<String, String>>(16);
        for (String dim : this.showDimensionList) {
            if (!hasBusinessModel && (SysDimensionEnum.ChangeType.getNumber().equals(dim) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dim) || SysDimensionEnum.Metric.getNumber().equals(dim)) || hasBusinessModel && SysDimensionEnum.Year.getNumber().equals(dim)) continue;
            final DynamicObject dimensionObj = doc.stream().filter(k -> dim.equals(k.getString("number"))).findAny().get();
            showDimFlex.add(new HashMap(){
                {
                    this.put("id", dimensionObj.getString("id"));
                    this.put("number", dimensionObj.getString("number"));
                    this.put("name", dimensionObj.getString("name"));
                    this.put("issysdimension", "1");
                }
            });
        }
        List userDefDim = doc.stream().filter(k -> !k.getBoolean("issysdimension")).sorted(Comparator.comparing(o -> Integer.parseInt(o.getString("fieldmapped").substring(3)))).collect(Collectors.toList());
        for (final DynamicObject dyn : userDefDim) {
            showDimFlex.add(new HashMap(){
                {
                    this.put("id", dyn.getString("id"));
                    this.put("number", dyn.getString("number"));
                    this.put("name", dyn.getString("name"));
                    this.put("issysdimension", "0");
                }
            });
        }
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(showDimFlex));
        return showDimFlex;
    }

    private boolean hasBusinessModel(Long id) {
        DynamicObject model_new = ModelUtils.getModel((Long)id);
        String reporttype = model_new.getString("reporttype");
        return reporttype.equals("6") || reporttype.equals("7");
    }

    public Collection<Long> getAllRegField(String dimnumber) {
        String selectFields = "name,id,number,type";
        Long billid = null;
        if (this.getModel().getValue(BILL) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e", (String)"AddDimmateRuleNew_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        billid = ((DynamicObject)this.getModel().getValue(BILL)).getLong("id");
        Map ftypegroup = null;
        if (this.getPageCache().get("cachebizreg" + billid + this.getModelId()) != null) {
            ftypegroup = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("cachebizreg" + billid + this.getModelId()), Map.class);
        } else {
            String metricVal = METRICMEMNER + this.getModelId();
            QFilter qcf = new QFilter("bizunitid", "=", (Object)billid).or(new QFilter("type", "=", (Object)metricVal));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)selectFields, (QFilter[])new QFilter[]{qcf});
            ftypegroup = query.stream().filter(f -> billList.contains(f.getString("type")) || metricVal.equals(f.getString("type"))).collect(Collectors.groupingBy(k -> k.getString("type"), Collectors.mapping(k -> k.getLong("id"), Collectors.toSet())));
            this.getPageCache().put("cachebizreg" + billid + this.getModelId(), SerializationUtils.toJsonString(ftypegroup));
        }
        return ftypegroup.containsKey(dimnumber) ? (Collection)ftypegroup.get(dimnumber) : new HashSet(16);
    }

    private Collection<Long> initBusCol(String dimnumber) {
        String dimKey = null;
        switch (dimnumber) {
            case "Entity": {
                dimKey = BillFieldTypeEmum.ORG.getNumber();
                break;
            }
            case "Account": {
                dimKey = BillFieldTypeEmum.ACCOUNT.getNumber();
                break;
            }
            case "Currency": {
                dimKey = BillFieldTypeEmum.CURRENCY.getNumber();
                break;
            }
            case "BudgetPeriod": 
            case "Year": {
                dimKey = BillFieldTypeEmum.PERIOD.getNumber();
                break;
            }
            case "Metric": {
                dimKey = METRICMEMNER + this.getModelId();
                break;
            }
            default: {
                dimKey = BillFieldTypeEmum.ASSIST.getNumber();
            }
        }
        return this.getAllRegField(dimKey);
    }

    private String checkData() {
        try {
            String checkSameDimension;
            DynamicObjectCollection valuefields;
            String checkGroupName = this.checkGroupName();
            if (StringUtils.isNotEmpty((String)checkGroupName)) {
                return checkGroupName;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SHOWCARD);
            HashMap<Long, String> billtypeids = new HashMap<Long, String>(10);
            HashMap<Long, Set<Long>> writeoffbills = new HashMap<Long, Set<Long>>(10);
            boolean isdynamic = this.isDynamic();
            if (isdynamic) {
                this.getBillTypeIds(billtypeids);
                HashSet<Long> writeoffids = new HashSet<Long>(10);
                for (DynamicObject e : this.getModel().getEntryEntity(CARDENTITY)) {
                    Long id = e.getLong("writeoffscheme.id");
                    if (!IDUtils.isNotNull((Long)id)) continue;
                    writeoffids.add(id);
                }
                if (!writeoffids.isEmpty()) {
                    this.getWriteoffBills(writeoffbills, writeoffids);
                }
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                Object vf2;
                String msg;
                DynamicObject dynamicObject = this.getRealCardEntry(i);
                if (dynamicObject.getLocaleString("title") == null || dynamicObject.getLocaleString("title").isEmpty()) {
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u6807\u9898\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AddDimmateRuleNew_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
                ILocaleString title = dynamicObject.getLocaleString("title");
                if (title.getLocaleValue() != null && title.getLocaleValue().length() > 150) {
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u6807\u9898\u8fc7\u957f", (String)"AddDimmateRuleNew_43", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
                if (StringUtils.isEmpty((String)dynamicObject.getString("priority"))) {
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u4f18\u5148\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AddDimmateRuleNew_13", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
                if (dynamicObject.get("model") == null) {
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u4f53\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AddDimmateRuleNew_7", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
                if (CommonUtils.isBgmdModel((Long)dynamicObject.getLong("model.id")) && IDUtils.isEmptyLong((Long)dynamicObject.getLong("bussmodel.id")).booleanValue()) {
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u4e1a\u52a1\u6a21\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"AddDimmateRuleNew_44", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
                if (dynamicObject.getDate("effectivetime") == null) {
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AddDimmateRuleNew_10", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
                if (dynamicObject.getDate("invalidtime") != null) {
                    Date effectivetime = dynamicObject.getDate("effectivetime");
                    Date invalidtime = dynamicObject.getDate("invalidtime");
                    if (invalidtime.before(effectivetime)) {
                        return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"AddDimmaterule_2", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                    }
                }
                if (isdynamic && (msg = this.checkWriteOff(billtypeids, writeoffbills, dynamicObject)) != null) {
                    return msg;
                }
                if (isdynamic && (valuefields = dynamicObject.getDynamicObjectCollection("valuefieldentry")) != null) {
                    for (Object vf2 : valuefields) {
                        if (!StringUtils.isEmpty((String)vf2.getString("valuefield"))) continue;
                        return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u6263\u51cf\u53d6\u503c\u4fe1\u606f\u4e2d\u7684\u6263\u51cf\u53d6\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddDimmaterule_34", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                    }
                }
                ArrayList notNullDimension = Lists.newArrayList((Object[])new SysDimensionEnum[]{SysDimensionEnum.Entity, SysDimensionEnum.Account, SysDimensionEnum.BudgetPeriod, SysDimensionEnum.Year, SysDimensionEnum.Currency, SysDimensionEnum.Metric});
                ArrayList hasMappingDimNumber = Lists.newArrayList((Object[])new String[]{"Entity", "Account", "Currency", "ChangeType", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6"});
                for (SysDimensionEnum dimension : notNullDimension) {
                    if (!CommonUtils.hasBusinessModel((Long)dynamicObject.getLong("model.id")).booleanValue() && dimension == SysDimensionEnum.Metric || CommonUtils.hasBusinessModel((Long)dynamicObject.getLong("model.id")).booleanValue() && dimension == SysDimensionEnum.Year || !CommonUtils.hasBusinessModel((Long)dynamicObject.getLong("model.id")).booleanValue() && dimension == SysDimensionEnum.BudgetPeriod || dynamicObject.get(this.getFieldKey(dimension.getNumber())) != null) continue;
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684%2\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddDimmateRuleNew_17", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, dimension.getChineseName()});
                }
                vf2 = hasMappingDimNumber.iterator();
                while (vf2.hasNext()) {
                    String dimNumber = (String)vf2.next();
                    if (dynamicObject.get(this.getFieldExtKey(dimNumber)) == null || dynamicObject.get(this.getDimMappingKey(dimNumber)) != null) continue;
                    return ResManager.loadResFormat((String)"\u7b2c%1\u9875\u7b7e\u7684\u4e1a\u52a1\u5b57\u6bb5\u9009\u62e9\u4e86\u8f85\u52a9\u57fa\u7840\u8d44\u6599\uff0c\u672a\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddDimmateRuleNew_24", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                }
            }
            if (isdynamic) {
                for (DynamicObject e : this.getModel().getEntryEntity(CARDENTITY)) {
                    String msg = this.checkWriteOff(billtypeids, writeoffbills, e);
                    if (msg != null) {
                        return msg;
                    }
                    valuefields = e.getDynamicObjectCollection("valuefieldentry");
                    if (valuefields == null) continue;
                    for (Object vf2 : valuefields) {
                        if (!StringUtils.isEmpty((String)vf2.getString("valuefield"))) continue;
                        return ResManager.loadResFormat((String)"\u65e0\u4f53\u7cfb\u6743\u9650\u9875\u7b7e\u7684\u6263\u51cf\u53d6\u503c\u4fe1\u606f\u4e2d\u7684\u6263\u51cf\u53d6\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddDimmaterule_37", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)(checkSameDimension = DimmateruleUtils.getInstance().checkGroup(this.getModel().getDataEntity(true))))) {
                return checkSameDimension;
            }
        }
        catch (Exception e) {
            logger.error("checkdataerror", (Throwable)e);
            return null;
        }
        return null;
    }

    private Boolean isDynamic() {
        return Convert.toBool((Object)this.getModel().getValue(ISDYNAMICVALUE), (Boolean)false);
    }

    private void getWriteoffBills(Map<Long, Set<Long>> writeoffbills, Set<Long> writeoffids) {
        if (writeoffbills == null || writeoffids == null || writeoffids.isEmpty()) {
            return;
        }
        DynamicObjectCollection sourcegroups = QueryServiceHelper.query((String)"eb_writeoffscheme_pro", (String)"id,writeoffinfo.writeoffbill.id", (QFilter[])new QFilter("id", "in", writeoffids).toArray());
        if (sourcegroups != null) {
            for (DynamicObject s : sourcegroups) {
                writeoffbills.computeIfAbsent(s.getLong("id"), f -> new HashSet(10)).add(s.getLong("writeoffinfo.writeoffbill.id"));
            }
        }
    }

    private void getBillTypeIds(Map<Long, String> billtypeids) {
        if (billtypeids == null) {
            return;
        }
        DynamicObjectCollection sourcegroups = (DynamicObjectCollection)this.getModel().getValue(SOURCEGROUP);
        if (sourcegroups != null && !sourcegroups.isEmpty()) {
            HashSet<Long> sids = new HashSet<Long>(10);
            for (DynamicObject s : sourcegroups) {
                sids.add(s.getLong("fbasedataid.id"));
            }
            if (!sids.isEmpty() && (sourcegroups = QueryServiceHelper.query((String)"eb_adddimmaterule", (String)"bill.id", (QFilter[])new QFilter("id", "in", sids).toArray())) != null) {
                for (DynamicObject s : sourcegroups) {
                    billtypeids.put(s.getLong("bill.id"), "");
                }
            }
        }
    }

    private String checkWriteOff(Map<Long, String> billtypeids, Map<Long, Set<Long>> writeoffbills, DynamicObject dynamicObject) {
        Long writeoffid = dynamicObject.getLong("writeoffscheme.id");
        if (IDUtils.isNotNull((Long)writeoffid) && writeoffbills.get(writeoffid) != null) {
            for (Long billid : writeoffbills.get(writeoffid)) {
                DynamicObject billinfo;
                if (billtypeids.containsKey(billid) || (billinfo = BusinessDataServiceHelper.loadSingleFromCache((Object)billid, (String)"eb_structofbill", (String)"fieldtable")) == null) continue;
                String billname = EntityMetadataCache.getDataEntityType((String)billinfo.getString("fieldtable")).getDisplayName().getLocaleValue();
                return ResManager.loadResFormat((String)"%1\u7684\u51b2\u9500\u65b9\u6848\u4e2d\u5305\u542b\u4e0a\u6e38\u5355\u636e-%2\uff0c\u8be5\u5355\u636e\u672a\u7ed1\u5b9a\u5173\u8054\u5339\u914d\u89c4\u5219\u7ec4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddDimmaterule_41", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("title"), billname});
            }
        }
        return null;
    }

    public String checkGroupName() {
        ILocaleString groupName = (ILocaleString)this.getModel().getValue("name");
        if (groupName != null) {
            if (groupName.getLocaleValue().length() > 150) {
                return ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u5206\u7ec4\u7684\u540d\u79f0\u8fc7\u957f", (String)"AddDimmateRuleNew_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"eb_adddimmaterule", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("bill.id", "=", (Object)this.getBillId())});
            for (DynamicObject dynamicObject : ruleList) {
                if (dynamicObject.getString("number").equals(this.getModel().getValue("number")) || !dynamicObject.getString("name").equals(groupName.getLocaleValue())) continue;
                return ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u5206\u7ec4\u7684\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"AddDimmateRuleNew_39", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public String getCodeRuleNumber() {
        String number;
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        try {
            number = service.getNumber("eb_dimmaterule", BusinessDataServiceHelper.newDynamicObject((String)"eb_dimmaterule"), null);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            KDBizException kdBizException = new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7684\u987a\u5e8f\u53f7\u5df2\u7ecf\u7528\u5b8c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AddDimmaterule_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            kdBizException.initCause((Throwable)ex);
            throw kdBizException;
        }
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u89c4\u5219\u7f16\u7801\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u7684\u7f16\u7801\u89c4\u5219\u662f\u5426\u6b63\u5e38\u3002", (String)"AddDimmateRuleNew_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return number;
    }

    private Boolean isOldCond(String cond) {
        return !cond.startsWith("{");
    }

    private String compareTypeId(String k, String fieldName, List<Map<String, Object>> fieldFilterMap) {
        String compareTypeId = null;
        try {
            Optional<Map> optional = fieldFilterMap.stream().filter(m -> fieldName.equals((String)m.get("fieldName"))).findFirst();
            if (optional.isPresent()) {
                List compareTypeDtos = (List)optional.get().get("compareTypeList");
                Map<String, String> idMap = compareTypeDtos.stream().collect(Collectors.toMap(m -> {
                    String key;
                    if (m instanceof CompareType) {
                        CompareType cpt = (CompareType)m;
                        key = cpt.getOperate() + cpt.getValue();
                        if (cpt.getClassName() != null && !cpt.getClassName().contains("NullAnalysis")) {
                            key = key + cpt.getClassName();
                        }
                    } else {
                        LinkedHashMap cptMap = (LinkedHashMap)m;
                        key = cptMap.get("operate") + "" + cptMap.get("value");
                        if (cptMap.get("className") != null && !cptMap.get("className").toString().contains("NullAnalysis")) {
                            key = key + cptMap.get("className");
                        }
                    }
                    return key;
                }, n -> {
                    if (n instanceof CompareType) {
                        CompareType cpt = (CompareType)n;
                        return cpt.getId();
                    }
                    return (String)((LinkedHashMap)n).get("id");
                }));
                compareTypeId = idMap.get(this.getEnCompareType(k));
            }
            if (compareTypeId == null) {
                HashMap mapping = new HashMap(){
                    {
                        this.put("1", "67");
                        this.put("2", "83");
                        this.put("3", "21");
                        this.put("4", "36");
                        this.put("5", "65");
                        this.put("6", "19");
                        this.put("7", "37");
                        this.put("8", "9");
                        this.put("9", "59");
                        this.put("10", "58");
                        this.put("11", "17");
                        this.put("12", "34");
                    }
                };
                return (String)mapping.get(k);
            }
        }
        catch (Exception e) {
            logger.error("init-condition-error,%s", (Object)e.getMessage());
        }
        return compareTypeId;
    }

    private String getEnCompareType(String compareType) {
        HashMap mapping = new HashMap(){
            {
                this.put("1", "=");
                this.put("2", "<>");
                this.put("3", ">");
                this.put("4", "<");
                this.put("5", ">=");
                this.put("6", "<=");
                this.put("7", "=ISNULL");
                this.put("8", "<>NOTISNULL");
                this.put("9", "LIKE");
                this.put("10", "NOT LIKE");
                this.put("11", "IN");
                this.put("12", "Not IN");
            }
        };
        return (String)mapping.get(compareType);
    }

    private String fieldName(String field) {
        if (field == null) {
            return "";
        }
        if (field.startsWith("model.")) {
            field = field.replaceFirst("model.", "");
        }
        return field;
    }

    private String combine(String k) {
        switch (k) {
            case "2": {
                return "0";
            }
            case "3": {
                return "1";
            }
        }
        return "";
    }

    public FilterCondition tansferFilterCondition(FilterGrid filterGrid, String serqfilter) {
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        String[] splits = serqfilter.split(",");
        if (splits.length < 2) {
            return filterCondition;
        }
        ArrayList<SimpleFilterRow> filterRows = new ArrayList<SimpleFilterRow>(16);
        try {
            Map smap = (Map)SerializationUtils.deSerializeFromBase64((String)splits[1]);
            String priKey = splits[0].replace("Qf", "");
            if (smap == null || priKey == null) {
                return filterCondition;
            }
            DimmateruleUtils util = DimmateruleUtils.getInstance();
            int total = Integer.parseInt((String)smap.get("num"));
            for (int k = 1; k <= total; ++k) {
                String i = priKey.contains("tabpageap") ? String.valueOf(k) : k + priKey.substring(priKey.length() - 1);
                final FilterValue filterValue = new FilterValue();
                String val = "";
                if (smap.get("valueqf" + i) != null) {
                    val = ((String)smap.get("valueqf" + i)).replaceAll("'", "").replaceAll("\"", "");
                    filterValue.setValue((Object)val);
                }
                String field = this.fieldName((String)smap.get("filedqf" + i));
                String compareTypeId = this.compareTypeId((String)smap.get("center" + i), field, filterGrid.getFilterColumns());
                if (compareTypeId == null) {
                    String errMsg = ResManager.loadResFormat((String)"\u5b57\u6bb5\u201c%1\u201d\u4e0d\u652f\u6301\u6761\u4ef6\u201c%2\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AddDimmateRuleNew_35", (String)"epm-eb-formplugin", (Object[])new Object[]{field, this.getEnCompareType((String)smap.get("center" + i))});
                    this.getView().showTipNotification(errMsg);
                    continue;
                }
                SimpleFilterRow sfr = new SimpleFilterRow(util.getBeforeMark(smap.get("before" + i)), compareTypeId, field, util.getAfterMark(smap.get("after" + i)), this.combine((String)smap.get("containqf" + i)), (List)new ArrayList(){
                    {
                        this.add(filterValue);
                    }
                });
                filterRows.add(sfr);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u52a0\u8f7d\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6761\u4ef6\u3002", (String)"AddDimmateRuleNew_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            logger.error("init-condition-err,%s", (Object)e.getMessage());
        }
        filterCondition.setFilterRow(filterRows);
        return filterCondition;
    }

    private void checkUpgrade() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object pkId = showParameter.getPkId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"eb_adddimmaterule");
        if (dynamicObject.getDynamicObjectCollection(CARDENTITY).stream().noneMatch(k -> k.getString("serqfilter") != null && !"".equals(k.getString("serqfilter")) && !k.getString("serqfilter").startsWith("{"))) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        for (DynamicObject dimmateObj : dynamicObject.getDynamicObjectCollection(CARDENTITY)) {
            if (dimmateObj.getString("serqfilter") == null || "".equals(dimmateObj.getString("serqfilter")) || dimmateObj.getString("serqfilter").startsWith("{")) continue;
            try {
                FlexBDValueCondition flexPropertyCon = new FlexBDValueCondition();
                FilterCondition filterCondition = this.tansferFilterCondition(filterGrid, dimmateObj.getString("serqfilter"));
                flexPropertyCon.setFilterCondition(filterCondition);
                String serqfilter = SerializationUtils.toJsonString((Object)flexPropertyCon);
                dimmateObj.set("serqfilter", (Object)serqfilter);
                dimmateObj.set("qfilter", null);
            }
            catch (Exception e) {
                logger.error("updagrade-dimmaterule-error" + dimmateObj.getString("title"), (Throwable)e);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void showDimmateRuleCard() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CARDENTITY);
        if (showParameter.getCustomParam("iscopy") != null) {
            this.getModel().setValue("name", (Object)(this.getModel().getValue("name") + "copy"));
            entryEntity.removeIf(k -> !modelIds.contains(k.getLong("model.id")));
            entryEntity.forEach(k -> {
                if (k.get("title") != null) {
                    k.set("title", (Object)(k.getLocaleString("title") + "copy"));
                }
            });
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            try {
                boolean isFirstDisable = true;
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(CARDENTITY, i);
                if (modelIds.contains(entryRowEntity.getLong("model.id"))) {
                    FlexBDValueCondition fc;
                    LocaleString description;
                    int index = this.getModel().createNewEntryRow(SHOWCARD);
                    String condText = "-";
                    if (StringUtils.isNotEmpty((String)entryRowEntity.getString("serqfilter")) && !this.isOldCond(entryRowEntity.getString("serqfilter")).booleanValue() && (description = (fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)entryRowEntity.getString("serqfilter"), FlexBDValueCondition.class)).getDescription()) != null) {
                        String string = condText = description.toString() != null ? description.toString().substring(0, 10) + "..." : "";
                    }
                    if (entryRowEntity.getString("title") != null && entryRowEntity.getString("title").length() > 12) {
                        this.getModel().setValue("showcardtitle", (Object)(entryRowEntity.getString("title").substring(0, 12) + "..."), index);
                    } else {
                        this.getModel().setValue("showcardtitle", entryRowEntity.get("title"), index);
                    }
                    this.getModel().setValue("showcardcondition", (Object)ResManager.loadResFormat((String)"\u9002\u7528\u6761\u4ef6\uff1a%1", (String)"AddDimmateRuleNew_21", (String)"epm-eb-formplugin", (Object[])new Object[]{condText}), index);
                    this.changePriority(index, index + 1);
                    this.getModel().setValue("realseq", (Object)(i + 1), index);
                    continue;
                }
                if (!isFirstDisable || !IDUtils.isNotNull((long)entryRowEntity.getLong("model.id"))) continue;
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ISONLYCHECK, ISDYNAMICVALUE, CONTROLPROCESS, SOURCEGROUP});
                isFirstDisable = false;
                continue;
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5361\u7247\u4fe1\u606f\u5c55\u793a\u9519\u8bef\u3002", (String)"AddDimmateRuleNew_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                logger.error("cardshowerror", (Throwable)e);
            }
        }
    }

    private void initModule() {
        DynamicObject billObj = (DynamicObject)this.getModel().getValue(BILL);
        this.initFilterGridap(billObj);
    }

    private void initMerticBaseData() {
        Set delIds;
        if (this.getModel().getValue(MODEL) == null || !CommonUtils.hasBusinessModel((Long)this.getModelId()).booleanValue()) {
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()}))).and(new QFilter("isagg", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection metricMembers = QueryServiceHelper.query((String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
        String metricVal = METRICMEMNER + this.getModelId();
        qFilter = new QFilter("type", "=", (Object)metricVal);
        DynamicObjectCollection billFieldMembers = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
        if (billFieldMembers != null && !billFieldMembers.isEmpty() && billFieldMembers.stream().anyMatch(k -> StringUtils.isEmpty((String)k.getString("name")))) {
            DeleteServiceHelper.delete((String)"eb_bgcontrolbizreg", (QFilter[])new QFilter[]{new QFilter("id", "in", billFieldMembers.stream().map(k -> k.getLong("id")).collect(Collectors.toList()))});
            billFieldMembers.clear();
        }
        ArrayList<Object> addEnt = new ArrayList<Object>(16);
        for (Object metricMember : metricMembers) {
            if (billFieldMembers == null || !billFieldMembers.stream().noneMatch(arg_0 -> AddDimmateRuleNew.lambda$initMerticBaseData$21((DynamicObject)metricMember, arg_0))) continue;
            addEnt.add(metricMember);
        }
        ArrayList<DynamicObject> saveDyna = new ArrayList<DynamicObject>(addEnt.size());
        if (!addEnt.isEmpty()) {
            for (DynamicObject dynamicObject : addEnt) {
                DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolbizreg");
                dynamicObject2.set("id", (Object)dynamicObject.getLong("id"));
                dynamicObject2.set("number", (Object)dynamicObject.getString("number"));
                dynamicObject2.set("name", (Object)dynamicObject.getString("name"));
                dynamicObject2.set("type", (Object)metricVal);
                saveDyna.add(dynamicObject2);
            }
            SaveServiceHelper.save((DynamicObject[])saveDyna.toArray(new DynamicObject[0]));
        }
        if (billFieldMembers != null && !(delIds = billFieldMembers.stream().filter(k -> metricMembers.stream().noneMatch(l -> l.getString("number").equals(k.getString("number")))).map(k -> k.getLong("id")).collect(Collectors.toSet())).isEmpty()) {
            DeleteServiceHelper.delete((String)"eb_bgcontrolbizreg", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)delIds.toArray())});
        }
    }

    private void changePriority(int index, int priority) {
        this.getModel().setValue("showcardpriority", (Object)ResManager.loadResFormat((String)"\u4f18\u5148\u7ea7\uff1a%1", (String)"AddDimmateRuleNew_22", (String)"epm-eb-formplugin", (Object[])new Object[]{priority}), index);
    }

    private void clearDimmate(DynamicObject dynamicObject) {
        for (String dimNumber : this.showDimensionList) {
            dynamicObject.set(this.getFieldKey(dimNumber), null);
            if (Arrays.asList(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Metric.getNumber()).contains(dimNumber)) continue;
            dynamicObject.set(this.getFieldExtKey(dimNumber), null);
            dynamicObject.set(this.getDimMappingKey(dimNumber), null);
        }
        Stream.iterate(1, x -> x + 1).limit(6L).forEach(k -> {
            dynamicObject.set(this.getFieldKey("userdefined" + k), null);
            dynamicObject.set(this.getFieldExtKey("userdefined" + k), null);
            dynamicObject.set(this.getDimMappingKey("userdefined" + k), null);
            dynamicObject.set(this.getDimKey("userdefined" + k), null);
        });
    }

    private void updateView(String ... keys) {
        for (String key : keys) {
            this.getView().updateView(key);
        }
    }

    private MultiLangEnumBridge getOpName() {
        if (this.getView().getFormShowParameter().getCustomParam("iscopy") != null) {
            return new MultiLangEnumBridge("\u590d\u5236", "WarnningSchemePlugin_17", "epm-eb-formplugin");
        }
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            return new MultiLangEnumBridge("\u65b0\u589e", "WarnningSchemePlugin_18", "epm-eb-formplugin");
        }
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            return new MultiLangEnumBridge("\u4fee\u6539", "WarnningSchemePlugin_19", "epm-eb-formplugin");
        }
        return null;
    }

    private void setMustInput(Boolean isMustInput) {
        Arrays.asList(TITLE, MODEL, BUSINESSMODEL, EFFECTIVETIME, INVALIDTIME).forEach(key -> {
            FieldEdit fieldEdit = (FieldEdit)this.getControl((String)key);
            fieldEdit.setMustInput(isMustInput.booleanValue());
        });
    }

    private static /* synthetic */ boolean lambda$initMerticBaseData$21(DynamicObject metricMember, DynamicObject j) {
        return j.getString("number").equals(metricMember.getString("number"));
    }
}

