/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberedit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetaUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.dimension.EbDimensionManagerList;
import kd.epm.eb.formplugin.memberedit.DimensionMemberBaseEdit;

public class AccountMemberEdit
extends DimensionMemberBaseEdit
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(AccountMemberEdit.class);
    private static final String MEASURE_TOOL = "measure";
    private static final String SELECTMEASURE = "selectmeasure";
    private static final String FORM_MEASURE = "epm_metricselect";
    private static final String TABCONTROL = "tabcontrol";
    private static final String Metric_Id = "metricId";
    private static final String RELATE_ENTRYENTITY = "entryentity2";
    private static final String SAVE_RELATE_ENTRYENTITY = "entryentity3";
    private static final String Value_Item = "valueItem";
    private String dim = "dim";
    private String dimid = "dimid";
    private String dimnum = "dimnum";
    protected static List<String> propertys = Arrays.asList("aggoprt", "accounttype", "drcrdirect");

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String parentNumber;
        super.afterCreateNewData(e);
        this.getPageCache().put("model", String.valueOf(this.getModelId()));
        String addcontinue = (String)this.getView().getFormShowParameter().getCustomParam("addcontinue");
        if ("0".equals(addcontinue)) {
            this.setDefaultVal();
        }
        if (this.isBGMD()) {
            String dataset = (String)this.getView().getFormShowParameter().getCustomParam("dataset");
            if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
                DynamicObject datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)this.getModelId());
                dataset = String.valueOf(datasetObj.getLong("id"));
            }
            this.getModel().setValue("dataset", (Object)dataset);
        }
        if ((parentNumber = (String)this.getView().getFormShowParameter().getCustomParam("parentNumber")) != null) {
            String number = this.dealNumber(parentNumber);
            this.getModel().setValue("number", (Object)number);
        }
        this.hiddenFields();
        this.getView().setVisible(Boolean.FALSE, new String[]{"relatedaccount", "relatedpanel"});
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    private String dealNumber(String number) {
        char _char;
        int i;
        int length = number.length();
        String str = "";
        for (i = length - 1; i >= 0 && Character.isDigit(_char = number.charAt(i)); --i) {
            str = _char + str;
        }
        String newNumber = "";
        if (StringUtils.isNotEmpty((String)str)) {
            try {
                BigDecimal value = new BigDecimal(str).add(BigDecimal.ONE);
                StringBuilder valueStr = new StringBuilder(value.stripTrailingZeros().toPlainString());
                int len = str.length() - valueStr.length();
                if (len > 0) {
                    for (int j = 0; j < len; ++j) {
                        valueStr.insert(0, "0");
                    }
                }
                String string = newNumber = i >= 0 ? number.substring(0, i + 1) + valueStr : valueStr.toString();
                if (!MetaUtils.verifyMetaLength((String)SysDimensionEnum.Account.getMemberTreemodel(), (String)"number", (String)newNumber)) {
                    newNumber = "";
                }
            }
            catch (Exception ex) {
                log.error("dealNumber-error", (Throwable)ex);
            }
        }
        return newNumber;
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getPageCache().put("dimensionId", this.getView().getFormShowParameter().getCustomParam("dimensionId").toString());
        if (this.isBGMD()) {
            boolean isRelated;
            this.setMetricTab();
            Long id = NewEbAppUtil.isNewEbModel((Long)this.getModelId()) ? (Long)this.getView().getFormShowParameter().getCustomParam("id") : Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("id"));
            if (this.checkDefByOthers(id)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isrelated"});
            }
            if (isRelated = ((Boolean)this.getModel().getValue("isrelated")).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"relatedaccount", "relatedpanel"});
                this.setEntryAfterLoad();
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"relatedaccount", "relatedpanel"});
            }
            String ctmember = (String)this.getModel().getValue("ctmember");
            this.createCTComboItem(ctmember);
        }
        if (this.isEB()) {
            this.setSupDims();
        }
        this.hiddenFields();
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hiddenControl();
        this.setSupDimensione();
        this.getModel().setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{MEASURE_TOOL, "advcontoolbarap"});
        BasedataEdit relatedaccount = (BasedataEdit)this.getView().getControl("relatedaccount");
        relatedaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ctView = (BasedataEdit)this.getView().getControl("ctview");
        ctView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit member2 = (TextEdit)this.getControl("member2");
        member2.addClickListener((ClickListener)this);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("dimentryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl("dimensionf7");
        f7SelectedList.addF7SelectedListRemoveAllListener(this::F7SelectedListRemoveAllListener);
        f7SelectedList.addF7SelectedListRemoveListener(this::F7SelectedListRemoveListener);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            String msg = this.checkAccountName(name.getLocaleValue());
            if (!StringUtils.isEmpty((String)msg)) {
                e.setCancel(true);
                this.getView().showTipNotification(msg);
            }
            if (this.isBGMD()) {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                if (entryentity.size() == 0) {
                    if (this.getPageCache().get("metrics") == null || SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("metrics")) == null) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AccountMemberEdit_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        DynamicObjectCollection metrics = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("metrics"));
                        this.setEntryEntity(metrics);
                    }
                } else {
                    this.getPageCache().put("metrics", SerializationUtils.serializeToBase64((Object)entryentity));
                }
                if (!this.checkRelateAccount()) {
                    e.setCancel(true);
                } else {
                    this.fillEntryEntity();
                }
                String comboSelect = (String)this.getModel().getValue("ctformula");
                this.getModel().setValue("ctmember", (Object)comboSelect);
            }
        }
    }

    private String checkAccountName(String name) {
        String msg = "";
        if (StringUtils.isEmpty((String)name)) {
            msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"AccountMemberEdit_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            return msg;
        }
        if (name.contains(",") || name.contains("\uff0c")) {
            msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e2d\u4e0d\u80fd\u5305\u542b\u9017\u53f7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AccountMemberEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (("save".equalsIgnoreCase(operateKey) || "addcontinue".equalsIgnoreCase(operateKey)) && issuccess) {
            if (this.isEB()) {
                Long modelid = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("model").toString());
                this.initSupDimensioneEntryentity(new QFilter("id", "=", (Object)modelid));
            }
            if (this.isBGMD()) {
                this.getModel().deleteEntryData(RELATE_ENTRYENTITY);
                this.setEntryAfterLoad();
                List ids = e.getOperationResult().getSuccessPkIds();
                if (ids == null || ids.size() == 0) {
                    return;
                }
                DynamicObject account = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"epm_accountmembertree");
                DynamicObjectCollection metrics = account.getDynamicObjectCollection("entryentity");
                if (metrics != null && metrics.size() == 0) {
                    DynamicObjectCollection cacheMetrics = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("metrics"));
                    for (DynamicObject cacheMetric : cacheMetrics) {
                        DynamicObject dynamicObject = metrics.addNew();
                        dynamicObject.set("metric", (Object)cacheMetric.getString("metric.id"));
                        dynamicObject.set("istopoly", (Object)cacheMetric.getString("istopoly"));
                        dynamicObject.set("databytime", (Object)cacheMetric.getString("databytime"));
                        dynamicObject.set("skip", (Object)cacheMetric.getString("skip"));
                        dynamicObject.set("metricdescription", (Object)cacheMetric.getString("metricdescription"));
                        dynamicObject.set("change", (Object)cacheMetric.getString("change"));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{account});
                    this.setEntryEntity(cacheMetrics);
                    this.getView().updateView("entryentity");
                } else if (metrics != null && metrics.size() > 1) {
                    ArrayList<String> metricsList = new ArrayList<String>(16);
                    DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                    for (DynamicObject metric : metrics) {
                        String metricId = metric.getString("metric.id");
                        if (!metricsList.contains(metricId)) {
                            metricsList.add(metricId);
                            continue;
                        }
                        dynamicObjects.add((Object)metric);
                    }
                    metrics.removeAll((Collection)dynamicObjects);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{account});
                }
            }
        }
        if (!issuccess && this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.setSupDimensione();
        }
    }

    private void fillEntryEntity() {
        this.getModel().deleteEntryData(SAVE_RELATE_ENTRYENTITY);
        DynamicObjectCollection dynamicObjects2 = this.getModel().getEntryEntity(RELATE_ENTRYENTITY);
        if (dynamicObjects2 != null && dynamicObjects2.size() > 0) {
            this.getModel().beginInit();
            for (DynamicObject dynamicObject : dynamicObjects2) {
                int row = this.getModel().createNewEntryRow(SAVE_RELATE_ENTRYENTITY);
                this.setRowData(row, dynamicObject);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(SAVE_RELATE_ENTRYENTITY);
    }

    private void setRowData(int row, DynamicObject dynamicObject) {
        this.getModel().setValue("dimid", (Object)dynamicObject.getString("dimid2"), row);
        this.getModel().setValue("dimnumber", (Object)dynamicObject.getString("dimnum2"), row);
        this.getModel().setValue("memberid", (Object)dynamicObject.getString("dimmenid2"), row);
        this.getModel().setValue("membernumber", (Object)dynamicObject.getString("dimmennum2"), row);
        this.getModel().setValue("source", (Object)"1", row);
    }

    private boolean checkRelateAccount() {
        boolean isRelated = (Boolean)this.getModel().getValue("isrelated");
        if (isRelated) {
            DynamicObject relateAccount = (DynamicObject)this.getModel().getValue("relatedaccount");
            if (relateAccount == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5173\u8054\u7684\u79d1\u76ee\u3002", (String)"AccountMemberEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection dynamicObjects2 = this.getModel().getEntryEntity(RELATE_ENTRYENTITY);
            if (dynamicObjects2 != null && dynamicObjects2.size() > 0) {
                for (DynamicObject dynamicObject : dynamicObjects2) {
                    String member = dynamicObject.getString("member2");
                    if (!StringUtils.isEmpty((String)member)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u5173\u8054\u503c\u7ef4\u5ea6\u6210\u5458\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"AccountMemberEdit_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (SELECTMEASURE.equals(key)) {
            this.selectMeasure();
        }
        if ("bar_close".equals(key)) {
            this.getModel().setDataChanged(false);
        }
        super.itemClick(evt);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String propName = e.getProperty().getName();
        if ("datatype".equals(propName)) {
            String oldvalue = (String)this.getModel().getValue("datatype");
            this.getPageCache().put("datatype", oldvalue);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        int num;
        String key = e.getProperty().getName();
        String temKey = key.substring(0, key.length() - 1);
        if ("numtype".equals(temKey) || temKey.equals("istooploy") || temKey.equals("databytime") || temKey.equals("skip") || temKey.equals("mdescription")) {
            num = Integer.parseInt(key.substring(key.length() - 1));
            String istopoly = this.getModel().getValue("istooploy" + num).toString();
            String databytime = (String)this.getModel().getValue("databytime" + num);
            String skip = (String)this.getModel().getValue("skip" + num);
            String metricdescription = (String)this.getModel().getValue("mdescription" + num);
            String numtype = (String)this.getModel().getValue("numtype" + num);
            this.reloadChange(numtype, databytime, "change" + num);
            if (numtype != null && numtype.length() > 0) {
                DynamicObject entryentity;
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                if (rowCount <= num) {
                    this.getModel().beginInit();
                    this.getModel().createNewEntryRow("entryentity");
                    this.getModel().endInit();
                }
                if ((entryentity = this.getModel().getEntryRowEntity("entryentity", num)) == null) {
                    this.getModel().createNewEntryRow("entryentity");
                    entryentity = this.getModel().getEntryRowEntity("entryentity", num);
                }
                entryentity.set("istopoly", (Object)istopoly);
                entryentity.set("databytime", (Object)databytime);
                entryentity.set("skip", (Object)skip);
                entryentity.set("metricdescription", (Object)metricdescription);
                if (databytime != null && databytime.length() > 0) {
                    if ("0".equals(databytime)) {
                        this.getModel().setValue("change" + num, (Object)"1");
                    } else if ("1".equals(databytime)) {
                        this.getModel().setValue("change" + num, (Object)"4");
                    } else {
                        this.getModel().setValue("change" + num, (Object)"6");
                    }
                }
            }
        }
        if ("change".equals(temKey)) {
            num = Integer.parseInt(key.substring(key.length() - 1));
            String change = (String)this.getModel().getValue("change" + num);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", num);
            if (entryentity == null) {
                this.getModel().createNewEntryRow("entryentity");
                entryentity = this.getModel().getEntryRowEntity("entryentity", num);
            }
            entryentity.set("change", (Object)change);
        }
        if (key.equals("accounttype")) {
            String accounttype = this.getModel().getValue("accounttype").toString();
            if ("50".equals(accounttype)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"drcrdirect"});
            } else if ("51".equals(accounttype)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"drcrdirect"});
                this.getModel().setValue("drcrdirect", (Object)"0");
            }
        }
        if ("isrelated".equals(key)) {
            boolean isRelated = (Boolean)this.getModel().getValue("isrelated");
            if (isRelated) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"relatedaccount", "relatedpanel"});
            } else {
                if (this.getModel().getValue("relatedaccount") != null) {
                    this.getModel().setValue("relatedaccount", null);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"relatedaccount", "relatedpanel"});
            }
        }
        if ("relatedaccount".equals(key)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("relatedaccount");
            if (dynamicObject == null) {
                this.clearEntity();
                return;
            }
            Long redatasetId = dynamicObject.getLong("dataset.id");
            if (redatasetId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u79d1\u76ee\u7684\u6570\u636e\u96c6\u4e3a\u7a7a\u3002", (String)"AccountMemberEdit_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.clearEntity();
                return;
            }
            DynamicObject dataset = (DynamicObject)this.getModel().getValue("dataset");
            Long dataId = dataset.getLong("id");
            this.setRelateEntity(dataId, redatasetId);
        }
        if ("ctview".equals(key)) {
            this.createCTComboItem(null);
        }
    }

    private void setRelateEntity(Long dataId, Long redatasetId) {
        Long model = this.getModelId();
        if (dataId.equals(redatasetId)) {
            this.clearEntity();
            return;
        }
        DynamicObjectCollection curDataset = this.queryDimByDataSet(dataId, model);
        if (curDataset == null) {
            return;
        }
        DynamicObjectCollection relateDataset = this.queryDimByDataSet(redatasetId, model);
        Map<Long, DynamicObject> curids = curDataset.stream().collect(Collectors.toMap(dataset -> dataset.getLong("id"), dataset -> dataset));
        if (relateDataset == null) {
            return;
        }
        relateDataset.removeIf(e -> curids.containsKey(e.getLong("id")));
        this.createRow(relateDataset, RELATE_ENTRYENTITY);
    }

    private void createRow(DynamicObjectCollection dynamicObjects, String entity) {
        this.getModel().deleteEntryData(entity);
        String index = entity.substring(entity.length() - 1);
        this.getModel().beginInit();
        for (DynamicObject dynamicObject : dynamicObjects) {
            int row = this.getModel().createNewEntryRow(entity);
            this.getModel().setValue(this.dim + index, (Object)(dynamicObject.getString("name") + "(" + dynamicObject.getString("shortnumber") + ")"), row);
            this.getModel().setValue(this.dimnum + index, (Object)dynamicObject.getString("number"), row);
            this.getModel().setValue(this.dimid + index, (Object)dynamicObject.getString("id"), row);
        }
        this.getModel().endInit();
        this.getView().updateView(entity);
    }

    private void clearEntity() {
        this.getModel().deleteEntryData(RELATE_ENTRYENTITY);
        this.getModel().deleteEntryData(SAVE_RELATE_ENTRYENTITY);
        this.getView().updateView(RELATE_ENTRYENTITY);
        this.getView().updateView(SAVE_RELATE_ENTRYENTITY);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String data;
        DynamicObjectCollection returnCollection;
        super.closedCallBack(event);
        String key = event.getActionId();
        if (FORM_MEASURE.equals(key) && (returnCollection = (DynamicObjectCollection)event.getReturnData()) != null) {
            this.addMeasure(returnCollection);
        }
        if ("relatedselect".equals(key)) {
            data = (String)event.getReturnData();
            if (data == null) {
                return;
            }
            this.getModel().setValue("relatedaccount", (Object)data);
        }
        if ("memberselect2".equals(key) && (data = (DynamicObject)event.getReturnData()) != null) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(RELATE_ENTRYENTITY);
            int[] row = entryGrid.getSelectRows();
            if (row == null || row.length == 0) {
                return;
            }
            this.setValueToEntity((DynamicObject)data, row[0]);
        }
    }

    private void setValueToEntity(DynamicObject data, int row) {
        this.getModel().setValue("dimmenid2", (Object)data.getString("id"), row);
        this.getModel().setValue("dimmennum2", (Object)data.getString("number"), row);
        this.getModel().setValue("member2", (Object)data.getString("name"), row);
        this.getView().updateView(RELATE_ENTRYENTITY);
    }

    private void setEntryEntity(DynamicObjectCollection metrics) {
        if (metrics != null && metrics.size() > 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().beginInit();
            for (DynamicObject metric : metrics) {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("metric", (Object)metric.getString("metric.id"), row);
                this.getModel().setValue("istopoly", (Object)metric.getString("istopoly"), row);
                this.getModel().setValue("databytime", (Object)metric.getString("databytime"), row);
                this.getModel().setValue("skip", (Object)metric.getString("skip"), row);
                this.getModel().setValue("metricdescription", (Object)metric.getString("metricdescription"), row);
                this.getModel().setValue("change", (Object)metric.getString("change"), row);
            }
            this.getModel().endInit();
        }
    }

    private void setMetricTab() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (entryentity.size() > 0) {
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                DynamicObject metric = (DynamicObject)dynamicObject.get("metric");
                if (metric == null) continue;
                this.setTabPage(i, metric.getString("id"), metric.getString("datatype"), metric.getString("name"), metric.getBoolean("isagg"));
                this.setTappageData(i, metric.getBoolean("isagg"), dynamicObject.getString("databytime"), dynamicObject.getString("skip"), dynamicObject.getString("metricdescription"), dynamicObject.getString("change"));
                this.reloadChange(metric.getString("datatype"), dynamicObject.getString("databytime"), "change" + i);
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baritemaddlevel"});
        }
    }

    private void setDefaultVal() {
        IDataModel iModel = this.getModel();
        IFormView iView = this.getView();
        Long id = Convert.toLong((Object)iView.getFormShowParameter().getCustomParam("id"), (Long)0L);
        DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"epm_accountmembertree");
        if ("Account".equals(parent.getString("number"))) {
            iModel.setValue("accounttype", (Object)"50");
            iModel.setValue("aggoprt", (Object)"1");
            iModel.setValue("drcrdirect", (Object)"0");
            if (this.isBGMD()) {
                this.setMoneyToRootOrOldData("50");
            }
        } else {
            iModel.setValue("aggoprt", parent.get("aggoprt"));
            iModel.setValue("accounttype", parent.get("accounttype"));
            iModel.setValue("drcrdirect", parent.get("drcrdirect"));
            if (this.isBGMD()) {
                this.setEntryEntity(parent.getDynamicObjectCollection("entryentity"));
                this.setMetricTab();
            }
            if (this.isEB()) {
                this.setSupDimsEntity(parent);
                this.setSupDims();
            }
        }
    }

    private void setMoneyToRootOrOldData(String accounttype) {
        String model = ((DynamicObject)this.getModel().getValue("model")).getString("id");
        QFilter qFilter1 = new QFilter("model", "=", (Object)Long.parseLong(model));
        QFilter qFilter2 = null;
        qFilter2 = "50".equals(accounttype) ? new QFilter("number", "=", (Object)"Money") : new QFilter("number", "=", (Object)"Amount");
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
        DynamicObject moneyMetric = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_metricmembertree", (String)"id,name,datatype,isagg", (QFilter[])qFilters);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        DynamicObject dynamicObject = ORM.create().newDynamicObject("epm_accountmembertree.entryentity");
        dynamicObject.set("metric", (Object)moneyMetric);
        dynamicObject.set("istopoly", (Object)moneyMetric.getBoolean("isagg"));
        dynamicObject.set("databytime", (Object)"0");
        dynamicObject.set("skip", (Object)"0");
        dynamicObject.set("metricdescription", (Object)"");
        dynamicObject.set("change", (Object)"1");
        dynamicObjects.add((Object)dynamicObject);
        this.setTabPage(0, moneyMetric.getString("id"), moneyMetric.getString("datatype"), moneyMetric.getString("name"), moneyMetric.getBoolean("isagg"));
        this.setTappageData(0, moneyMetric.getBoolean("isagg"), "0", "0", "", "1");
        this.reloadChange(moneyMetric.getString("datatype"), "0", "change0");
    }

    private void selectMeasure() {
        FormShowParameter form = new FormShowParameter();
        form.setFormId(FORM_MEASURE);
        form.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FORM_MEASURE);
        form.setCloseCallBack(closeCallBack);
        List<Long> metricIds = this.getMetricIdListFromCache();
        if (metricIds.size() > 0) {
            form.setCustomParam(Metric_Id, metricIds);
        }
        form.setCustomParam("accountNum", this.getModel().getValue("number"));
        form.setCustomParam("dimensionNum", (Object)"Account");
        form.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        this.getView().showForm(form);
    }

    private void addMeasure(DynamicObjectCollection returnCollection) {
        List<Long> metricIdList = this.getMetricIdListFromCache();
        metricIdList.clear();
        this.getPageCache().put(Metric_Id, SerializationUtils.toJsonString(metricIdList));
        for (int i = 0; i < returnCollection.size(); ++i) {
            this.setTabPage(i, ((DynamicObject)returnCollection.get(i)).getString("id"), ((DynamicObject)returnCollection.get(i)).getString("type1"), ((DynamicObject)returnCollection.get(i)).getString("name1"), ((DynamicObject)returnCollection.get(i)).getBoolean("isagg1"));
        }
        this.clearTabPage(returnCollection);
        this.setMetricData(returnCollection);
    }

    private void setTabPage(int index, String id, String type, String name, boolean isagg) {
        Tab tab = (Tab)this.getControl(TABCONTROL);
        List<Long> metricIdList = this.getMetricIdListFromCache();
        List items = tab.getItems();
        metricIdList.add(Long.parseLong(id));
        this.getModel().setValue("numtype" + index, (Object)type);
        this.getModel().setValue("istooploy" + index, (Object)isagg);
        TabPage tabPage = (TabPage)items.get(index);
        tabPage.setText(new LocaleString(name));
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabpageap" + index});
        this.getPageCache().put(Metric_Id, SerializationUtils.toJsonString(metricIdList));
    }

    private void clearTabPage(DynamicObjectCollection collection) {
        Tab tab = (Tab)this.getControl(TABCONTROL);
        List items = tab.getItems();
        for (int i = 0; i < 6 - collection.size(); ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap" + (5 - i)});
            IDataModel model = ((Control)items.get(5 - i)).getModel();
            model.getProperty("numtype" + (5 - i)).setValueFast((Object)model.getDataEntity(), (Object)"");
            model.getProperty("istooploy" + (5 - i)).setValueFast((Object)model.getDataEntity(), (Object)Boolean.FALSE);
            TabPage tabPage = (TabPage)items.get(5 - i);
            tabPage.setText(new LocaleString(""));
        }
    }

    private void reloadChange(String numtype, String databytime, String changeKey) {
        ComboEdit edit = (ComboEdit)this.getControl(changeKey);
        if (numtype != null && numtype.length() > 0) {
            if ("1".equals(numtype)) {
                if ("0".equals(databytime)) {
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747\u6c47\u7387", (String)"AccountMemberEdit_6", (String)"epm-eb-formplugin", (Object[])new Object[0])), "1"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5e73\u5747\u6c47\u7387", (String)"AccountMemberEdit_7", (String)"epm-eb-formplugin", (Object[])new Object[0])), "2"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6c47\u7387", (String)"AccountMemberEdit_8", (String)"epm-eb-formplugin", (Object[])new Object[0])), "3"));
                    edit.setComboItems(items);
                } else if ("1".equals(databytime)) {
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u6c47\u7387", (String)"AccountMemberEdit_9", (String)"epm-eb-formplugin", (Object[])new Object[0])), "4"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5386\u53f2\u6c47\u7387", (String)"AccountMemberEdit_10", (String)"epm-eb-formplugin", (Object[])new Object[0])), "5"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6c47\u7387", (String)"AccountMemberEdit_8", (String)"epm-eb-formplugin", (Object[])new Object[0])), "3"));
                    edit.setComboItems(items);
                } else {
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747\u6c47\u7387", (String)"AccountMemberEdit_6", (String)"epm-eb-formplugin", (Object[])new Object[0])), "1"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5e73\u5747\u6c47\u7387", (String)"AccountMemberEdit_7", (String)"epm-eb-formplugin", (Object[])new Object[0])), "2"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6c47\u7387", (String)"AccountMemberEdit_8", (String)"epm-eb-formplugin", (Object[])new Object[0])), "3"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u6c47\u7387", (String)"AccountMemberEdit_9", (String)"epm-eb-formplugin", (Object[])new Object[0])), "4"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5386\u53f2\u6c47\u7387", (String)"AccountMemberEdit_10", (String)"epm-eb-formplugin", (Object[])new Object[0])), "5"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u6298\u7b97", (String)"AccountMemberEdit_11", (String)"epm-eb-formplugin", (Object[])new Object[0])), "6"));
                    edit.setComboItems(items);
                }
            } else {
                ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u6298\u7b97", (String)"AccountMemberEdit_11", (String)"epm-eb-formplugin", (Object[])new Object[0])), "6"));
                edit.setComboItems(items);
            }
        }
    }

    private void createCTComboItem(String defaultVal) {
        DynamicObject ct = (DynamicObject)this.getModel().getValue("ctview");
        if (ct == null) {
            return;
        }
        long modelId = this.getModelId();
        ComboEdit edit = (ComboEdit)this.getControl("ctformula");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String selectId = null;
        if (ct != null) {
            Long viewId = ct.getLong("id");
            HashMap map = new HashMap(DimensionViewServiceHelper.getInstance().queryCTFormula(viewId, Long.valueOf(modelId)));
            for (Map.Entry entry : map.entrySet()) {
                items.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
            }
            if (defaultVal != null && map.containsKey(defaultVal)) {
                selectId = defaultVal;
            }
        }
        edit.setComboItems(items);
        if (selectId != null) {
            this.getModel().setValue("ctformula", selectId);
        }
    }

    private List<Long> getMetricIdListFromCache() {
        ArrayList<Long> metricIdList = new ArrayList<Long>();
        String metricId = this.getPageCache().get(Metric_Id);
        if (StringUtils.isNotEmpty((String)metricId)) {
            return (List)SerializationUtils.fromJsonString((String)metricId, List.class);
        }
        return metricIdList;
    }

    private void setMetricData(DynamicObjectCollection returnCollection) {
        DynamicObjectCollection oldMetricEntryentity = this.getModel().getEntryEntity("entryentity");
        this.getModel().deleteEntryData("entryentity");
        int i = 0;
        if (returnCollection.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", returnCollection.size());
            for (DynamicObject dynamicObject : returnCollection) {
                boolean exist = false;
                for (DynamicObject old : oldMetricEntryentity) {
                    if (old.getString("metric.id") == null || !old.getString("metric.id").equals(dynamicObject.getString("id"))) continue;
                    this.add2MetricEntryEntity(i, dynamicObject, old.getBoolean("metric.isagg"), old.getString("databytime"), old.getString("skip"), old.getString("metricdescription"), old.getString("change"));
                    this.setTappageData(i, old.getBoolean("metric.isagg"), old.getString("databytime"), old.getString("skip"), old.getString("metricdescription"), old.getString("change"));
                    exist = true;
                    break;
                }
                if (!exist) {
                    String numType = dynamicObject.getString("type1");
                    if (MetricDataTypeEnum.CURRENCY.getIndex().equals(numType)) {
                        this.setTappageData(i, dynamicObject.getBoolean("isagg1"), "0", "0", "", "1");
                    } else {
                        this.setTappageData(i, dynamicObject.getBoolean("isagg1"), "0", "0", "", "6");
                    }
                    String databytime = (String)this.getModel().getValue("databytime" + i);
                    String skip = (String)this.getModel().getValue("skip" + i);
                    String metricdescription = (String)this.getModel().getValue("mdescription" + i);
                    String change = (String)this.getModel().getValue("change" + i);
                    this.add2MetricEntryEntity(i, dynamicObject, dynamicObject.getBoolean("isagg1"), databytime, skip, metricdescription, change);
                }
                ++i;
            }
        }
        this.getView().updateView("entryentity");
    }

    private void setTappageData(int index, boolean istooploy, String databytime, String skip, String mdescription, String change) {
        this.getModel().setValue("enum" + index, (Object)ResManager.loadKDString((String)"\u65e0", (String)"AccountMemberEdit_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("istooploy" + index, (Object)istooploy);
        this.getModel().setValue("databytime" + index, (Object)databytime);
        this.getModel().setValue("skip" + index, (Object)skip);
        this.getModel().setValue("mdescription" + index, (Object)mdescription);
        this.getModel().setValue("change" + index, (Object)change);
    }

    private void add2MetricEntryEntity(int index, DynamicObject dynamicObject, Boolean istooploy, String databytime, String skip, String mdescription, String change) {
        DynamicObject entityRow = this.getModel().getEntryRowEntity("entryentity", index);
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"epm_metricmembertree");
        obj.set("id", dynamicObject.get("id"));
        entityRow.set("metric", (Object)obj);
        if (istooploy != null) {
            entityRow.set("istopoly", (Object)dynamicObject.getBoolean("isagg1"));
        }
        if (databytime != null) {
            entityRow.set("databytime", (Object)databytime);
        }
        if (skip != null) {
            entityRow.set("skip", (Object)skip);
        }
        if (mdescription != null) {
            entityRow.set("metricdescription", (Object)mdescription);
        }
        if (change != null) {
            entityRow.set("change", (Object)change);
        }
    }

    private void hiddenControl() {
        String accountType;
        this.getView().setVisible(Boolean.FALSE, new String[]{"datatype"});
        this.getModel().setValue("datatype", (Object)0);
        if (this.isEB()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"selmetric", "relatedaccount", "relatedpanel"});
        }
        if ("51".equals(accountType = this.getModel().getValue("accounttype").toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"drcrdirect"});
        }
    }

    @Override
    protected String getTreeModelType() {
        return "epm_accountmembertree";
    }

    private DynamicObjectCollection queryDimByDataSet(Long datasetId, Long modelId) {
        ArrayList<String> dimIds = new ArrayList<String>();
        QFilter dataSetQf = new QFilter("id", "=", (Object)datasetId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dataset", (String)"entryentity.datasetdim", (QFilter[])new QFilter[]{dataSetQf});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dimIds.add(dynamicObject.getString("entryentity.datasetdim"));
        }
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter dimQf = new QFilter("id", "in", (Object)IDUtils.toLongs(dimIds));
        String selects = "id,number,name,shortnumber";
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)selects, (QFilter[])new QFilter[]{modelQf, dimQf});
        return dims;
    }

    @Override
    public String getCurrentDimNumber(String controlKey) {
        return SysDimensionEnum.Account.getNumber();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        long modelId = this.getModelId();
        if ("relatedaccount".equals(key)) {
            OperationContext context = OperationContext.get();
            if (context.getOpMethod().equals("getLookUpList")) {
                QFilter qf = new QFilter("model", "=", (Object)modelId);
                QFilter qfnumber = new QFilter("number", "!=", (Object)"Account");
                if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    String number = (String)this.getModel().getValue("number");
                    qfnumber.and(new QFilter("number", "!=", (Object)number));
                }
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.getListFilterParameter().setFilter(qf.and(qfnumber));
            } else if (context.getOpMethod().equals("click") || context.getOpMethod().equals("showMore")) {
                beforeF7SelectEvent.setCancel(true);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("eb_relatedselect");
                showParameter.setCustomParam("model", (Object)this.getModelId());
                if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    String number = (String)this.getModel().getValue("number");
                    showParameter.setCustomParam("curNumber", (Object)number);
                }
                DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
                showParameter.setCustomParam("parent", (Object)parent.getLong("id"));
                showParameter.setShowTitle(true);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "relatedselect");
                showParameter.setCloseCallBack(callBack);
                this.getView().showForm(showParameter);
            }
        }
        if ("ctview".equals(key)) {
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            QFilter dimQf = new QFilter("dimension.number", "=", (Object)SysDimensionEnum.ChangeType.getNumber());
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf.and(dimQf));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("member1".equals(key)) {
            this.openPage("1", "isleaf");
        }
        if ("member2".equals(key)) {
            this.openPage("2", null);
        }
    }

    private void openPage(String index, String leaf) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity" + index);
        int row = entryGrid.getSelectRows()[0];
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity" + index, row);
        String dimNumber = dynamicObject.getString("dimnum" + index);
        String entity = DimensionServiceHelper.getMemberKeyByDimNum((String)dimNumber);
        String comboName = dynamicObject.getString("dim" + index).split("\\(")[0];
        this.openDimMemberselect(dimNumber, leaf, entity, comboName, "memberselect" + index);
    }

    private void openDimMemberselect(String number, String isleaf, String entity, String comboName, String closeKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("comboName", (Object)comboName);
        formShowParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        formShowParameter.setCustomParam("dimNum", (Object)number);
        formShowParameter.setCustomParam("membertree", (Object)entity);
        formShowParameter.setCustomParam("isleaf", (Object)isleaf);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u9009\u62e9", (String)"AccountMemberEdit_13", (String)"epm-eb-formplugin", (Object[])new Object[]{comboName}));
        formShowParameter.setFormId("eb_dimmemberf7");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeKey);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void setEntryAfterLoad() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(SAVE_RELATE_ENTRYENTITY);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String source = dynamicObject.getString("source");
                if (!"1".equals(source)) continue;
                this.getModel().beginInit();
                int rigthRow = this.getModel().createNewEntryRow(RELATE_ENTRYENTITY);
                this.getModel().endInit();
                this.setRowLoadData(rigthRow, dynamicObject);
            }
            this.getView().updateView(RELATE_ENTRYENTITY);
        }
    }

    private void setRowLoadData(int row, DynamicObject data) {
        Long modelId = this.getModelId();
        String dimnum = data.getString("dimnumber");
        String dimmember = data.getString("membernumber");
        DynamicObject dim = DimensionServiceHelper.queryDimensionByNumber((Long)modelId, (String)"name,shortnumber", (String)dimnum);
        DynamicObject member = DimensionServiceHelper.queryMemberNameByNumber((String)DimensionServiceHelper.getMemberKeyByDimNum((String)dimnum), (long)modelId, (String)dimmember);
        this.getModel().setValue("dim2", (Object)(dim.getString("name") + "(" + dim.getString("shortnumber") + ")"), row);
        this.getModel().setValue("member2", (Object)member.getString("name"), row);
        this.getModel().setValue("dimid2", (Object)data.getString("dimid"), row);
        this.getModel().setValue("dimnum2", (Object)dimnum, row);
        this.getModel().setValue("dimmenid2", (Object)data.getString("memberid"), row);
        this.getModel().setValue("dimmennum2", (Object)dimmember, row);
    }

    private boolean checkDefByOthers(Long id) {
        QFilter qFilter = new QFilter("relatedaccount", "=", (Object)id);
        boolean isRef = QueryServiceHelper.exists((String)"epm_accountmembertree", (QFilter[])new QFilter[]{qFilter});
        return isRef;
    }

    @Override
    protected void setParentFilter(BeforeF7SelectEvent evt) {
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        if (this.isBGMD()) {
            QFilter qfNumber = new QFilter("number", "=", (Object)"Account");
            QFilter qf = new QFilter("dataset", "=", (Object)((DynamicObject)this.getModel().getValue("dataset")).getLong("id"));
            qFilters.add(qfNumber.or(qf));
        } else {
            qFilters.add(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    @Override
    protected void setContinueAddDefaultValue(Map<String, Object> temp) {
        super.setContinueAddDefaultValue(temp);
        IDataModel iDataModel = this.getModel();
        iDataModel.setValue("storagetype", temp.get("storagetype"));
        iDataModel.setValue("aggoprt", temp.get("aggoprt"));
        iDataModel.setValue("drcrdirect", temp.get("drcrdirect"));
        Object accounttype = temp.get("accounttype");
        iDataModel.setValue("accounttype", accounttype);
        if (accounttype != null && this.isBGMD()) {
            this.setMoneyToRootOrOldData(accounttype.toString());
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private void hiddenFields() {
        if (this.isEB()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ctview", "ctformula", "isrelated", "selmetric"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimensionrange"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"databytime0", "skip0"});
    }

    private void initSupDimensioneEntryentity(QFilter filter) {
        this.getModel().deleteEntryData("dimentryentity");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("dimentryentity");
        DynamicObjectCollection supDimension = this.getSupDimension(filter);
        String appTypeNum = this.getView().getFormShowParameter().getAppId();
        Long modelId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("model").toString());
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        String algoKey = "kd.epm.eb.formplugin.dimension.DimensionManagerList";
        if (supDimension != null) {
            supDimension.forEach(sup -> {
                String number = sup.getString("number");
                String name = sup.getString("name");
                if (!SysDimensionEnum.Account.getNumber().equals(number)) {
                    QFilter fmodelid2;
                    QFilter[] filters;
                    String selectFields;
                    DynamicObjectCollection dcs2;
                    int num = 1;
                    if (!ApplicationTypeEnum.BGBD.getAppnum().equals(appTypeNum) && SysDimensionEnum.Account.getNumber().equals(number) && SysDimensionEnum.Account.getNumber().equals(sup.getString("number")) && (dcs2 = QueryServiceHelper.query((String)algoKey, (String)"epm_icmembertree", (String)(selectFields = "count(*) as num"), (QFilter[])(filters = new QFilter[]{fmodelid, fmodelid2 = new QFilter("issysmember", "!=", (Object)1)}), (String)"dseq")) != null && dcs2.size() > 0) {
                        num = Integer.parseInt(((DynamicObject)dcs2.get(0)).get("num").toString());
                    }
                    if (num > 0) {
                        DynamicObject dynamicObject = new DynamicObject(entryentity.getDynamicObjectType(), (Object)sup.getString("id"));
                        dynamicObject.set("dimensionnumber", (Object)number);
                        dynamicObject.set("dimensionname", (Object)name);
                        entryentity.add((Object)dynamicObject);
                    }
                }
            });
        }
        this.getView().updateView("dimentryentity");
    }

    private DynamicObjectCollection getSupDimension(QFilter filter) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension";
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,reporttype", (QFilter[])new QFilter[]{filter});
        if (model != null) {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)model.getLong("id"));
            if (BizModel.isEBByModel((DynamicObject)model)) {
                builder.add("number", "not in", EbDimensionManagerList.hideEbDims);
            }
            return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])builder.toArray(), (String)"dseq");
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u516c\u6709\u7ef4\u5ea6\u3002", (String)"AccountMemberEdit_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return null;
    }

    private void setDimenData() {
        this.getModel().deleteEntryData("entryentity1");
        List<ValueTextItem> valueTextItems = this.getValueTextItemsFromCache();
        if (valueTextItems.size() > 0) {
            for (ValueTextItem valueTextItem : valueTextItems) {
                int row = this.getModel().createNewEntryRow("entryentity1");
                DynamicObject entityRow = this.getModel().getEntryRowEntity("entryentity1", row);
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
                obj.set("id", (Object)Long.valueOf(valueTextItem.getValue()));
                entityRow.set("defindimsension", (Object)obj);
            }
        }
    }

    private List<ValueTextItem> getValueTextItemsFromCache() {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(Value_Item))) {
            List pgCacheExistValueTextItem = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(Value_Item), List.class);
            this.dealValueTextItem(valueTextItems, pgCacheExistValueTextItem);
        }
        return valueTextItems;
    }

    private void dealValueTextItem(List<ValueTextItem> nowItems, List<Map<String, String>> existItems) {
        for (Map<String, String> existItem : existItems) {
            nowItems.add(new ValueTextItem(existItem.get("value"), existItem.get("text")));
        }
    }

    private void setSupDimensione() {
        if (this.isEB()) {
            Long modelid = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("model").toString());
            DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelid)});
            if (model != null && "9".equals(model.get("reporttype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"permadv"});
                this.initSupDimensioneEntryentity(new QFilter("reporttype", "=", (Object)"9"));
            } else {
                this.initSupDimensioneEntryentity(new QFilter("id", "=", (Object)modelid));
            }
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        String key = ((EntryGrid)evt.getSource()).getKey();
        if ("customvalues".equals(key)) {
            super.entryRowClick(evt);
        } else {
            List<ValueTextItem> valueTextItems = this.getValueTextItemsFromCache();
            F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl("dimensionf7");
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("dimentryentity");
            if (evt.getRow() >= 0) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(evt.getRow());
                Boolean exist = Boolean.FALSE;
                if (valueTextItems.size() > 0) {
                    for (ValueTextItem valueTextItem : valueTextItems) {
                        if (!valueTextItem.getValue().equals(dynamicObject.getString("id"))) continue;
                        exist = Boolean.TRUE;
                        break;
                    }
                }
                if (!exist.booleanValue()) {
                    valueTextItems.add(new ValueTextItem(dynamicObject.getString("id"), dynamicObject.getString("dimensionname")));
                    f7SelectedList.addItems(valueTextItems);
                }
            }
            if (valueTextItems.size() > 0) {
                this.getPageCache().put(Value_Item, SerializationUtils.toJsonString(valueTextItems));
                this.setDimenData();
            }
        }
    }

    private void F7SelectedListRemoveAllListener(F7SelectedListRemoveEvent removeEvent) {
        List<ValueTextItem> valueTextItems = this.getValueTextItemsFromCache();
        if (valueTextItems.size() > 0) {
            valueTextItems.clear();
            this.getPageCache().put(Value_Item, SerializationUtils.toJsonString(valueTextItems));
        }
        this.setDimenData();
    }

    private void F7SelectedListRemoveListener(F7SelectedListRemoveEvent removeEvent) {
        List<ValueTextItem> valueTextItems = this.getValueTextItemsFromCache();
        valueTextItems.removeIf(value -> value.getValue().equals(removeEvent.getParam()));
        this.getPageCache().put(Value_Item, SerializationUtils.toJsonString(valueTextItems));
        this.setDimenData();
    }

    private void setSupDims() {
        DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity1");
        if (entryentity1.size() > 0) {
            F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl("dimensionf7");
            List<ValueTextItem> valueTextItems = this.getValueTextItemsFromCache();
            entryentity1.forEach(dynamicObject -> {
                Long dojId = dynamicObject.getLong("defindimsension_id");
                if (dojId != 0L) {
                    DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((Object)dojId, (String)"epm_dimension");
                    valueTextItems.add(new ValueTextItem(dynamicObject1.getString("id"), dynamicObject1.getString("name")));
                    f7SelectedList.addItems(valueTextItems);
                }
            });
            this.getPageCache().put(Value_Item, SerializationUtils.toJsonString(valueTextItems));
        }
    }

    private void setSupDimsEntity(DynamicObject object) {
        DynamicObjectCollection supDims = (DynamicObjectCollection)object.get("entryentity1");
        if (supDims != null && supDims.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity1", supDims.size());
            DynamicObjectCollection entryentity1s = this.getModel().getEntryEntity("entryentity1");
            int i = 0;
            for (DynamicObject entryentity1 : entryentity1s) {
                entryentity1.set("defindimsension", ((DynamicObject)supDims.get(i)).get("defindimsension"));
                ++i;
            }
        }
    }
}

