/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberedit;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.model.BudgetPeriodService;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.business.model.entity.BudgetPeriodMemTree;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class BudgetPeriodMembAdd
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(BudgetPeriodMembAdd.class);

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_save"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_save".equals(key)) {
            Date startfy = (Date)this.getModel().getValue("startfy");
            int presetyear = (Integer)this.getModel().getValue("addyear");
            if (startfy == null || presetyear == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5fc5\u5f55\u9879", (String)"BudgetPeriodMembAdd_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Calendar instance = Calendar.getInstance();
            instance.setTime(startfy);
            int startYear = instance.get(1);
            int endyear = startYear + presetyear;
            int srartMonth = 1;
            DynamicObject root = this.getRoot();
            BudgetPeriodMemTree budgetPeriodMemTree = new BudgetPeriodMemTree(this.getModelObj(), (Object)this.getDimensionObj());
            budgetPeriodMemTree.setNumber(root.getString("number"));
            budgetPeriodMemTree.setLongnumber(root.getString("longnumber"));
            budgetPeriodMemTree.initYearTree(startYear, endyear, srartMonth);
            List yearTree = budgetPeriodMemTree.getChildren();
            ArrayList exist = new ArrayList(16);
            ArrayList noExist = new ArrayList(16);
            yearTree.removeIf(next -> {
                String number = next.getNumber();
                boolean exists = this.exists(number);
                if (exists) {
                    exist.add(number);
                } else {
                    noExist.add(number);
                }
                return exists;
            });
            if (!yearTree.isEmpty()) {
                ArrayList<DynamicObject> savez = new ArrayList<DynamicObject>(10);
                try (TXHandle th = TX.required();){
                    try {
                        budgetPeriodMemTree.initPeriodTree(1, true, true, true);
                        for (AbstractDimensionMemTree treenode : budgetPeriodMemTree.getChildren()) {
                            treenode.setParent(Long.valueOf(root.getLong("id")));
                            this.init(treenode, savez);
                        }
                        long modelId = this.getModelId();
                        DynamicObject firstPeriod = null;
                        BudgetPeriodService periodService = BudgetPeriodService.getInstance();
                        boolean hasModifyDefault = periodService.hasModifyDefault(modelId);
                        if (hasModifyDefault) {
                            firstPeriod = BudgetPeriodService.getInstance().getFirstPeriod(modelId);
                        }
                        log.info("[budgetperiod]BudgetPeriodMembAdd.btn_save:modelid=" + modelId + ",dimensionid=" + this.getDimensionId() + ",startYear=" + startYear + ",endyear" + endyear);
                        SaveServiceHelper.save((DynamicObject[])savez.toArray(new DynamicObject[0]));
                        if (hasModifyDefault) {
                            BudgetPeriodService.getInstance().modifyStartDate(modelId, firstPeriod);
                        }
                        if (!savez.isEmpty()) {
                            DynamicObject bgPeriod = (DynamicObject)savez.get(0);
                            Long dimensionId = bgPeriod.getDynamicObject("dimension").getLong("id");
                            CubeUtils.get().checkDimension(Long.valueOf(modelId), dimensionId);
                        }
                    }
                    catch (Exception e) {
                        th.markRollback();
                        log.error(e.getMessage());
                        throw new KDBizException(e.getMessage());
                    }
                }
                DynamicObject modelObj = (DynamicObject)((DynamicObject)savez.get(0)).get("model");
                if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)modelObj)) {
                    List datasets = DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)SysDimensionEnum.BudgetPeriod.getNumber());
                    ShrekOlapServiceHelper.addCubeMembers((Model)Model.of((DynamicObject)modelObj), (List)datasets, (String)SysDimensionEnum.BudgetPeriod.getNumber(), (List)Member.of(savez, (boolean)false), (ShrekConfig)ShrekConfigServiceHelper.getBgMDConfig());
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!noExist.isEmpty()) {
                stringBuilder.append(noExist);
            }
            stringBuilder.append(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"BudgetPeriodMembAdd_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (!exist.isEmpty()) {
                stringBuilder.append(ResManager.loadKDString((String)"\u8df3\u8fc7\u5df2\u5b58\u5728\u7684\u8d22\u5e74\uff1a", (String)"BudgetPeriodMembAdd_2", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(exist);
            }
            this.getView().getParentView().showConfirm(stringBuilder.toString(), MessageBoxOptions.OK);
            this.getView().close();
        }
    }

    private DynamicObject getRoot() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("dimension", "=", (Object)this.getDimensionId());
        qFilter.and("number", "=", (Object)"BudgetPeriod");
        DynamicObject root = QueryServiceHelper.queryOne((String)"epm_bperiodmembertree", (String)"id, number, longnumber", (QFilter[])qFilter.toArray());
        if (root == null) {
            log.error("[budgetperiod]BudgetPeriodMembAdd.getRootId():modelid=" + this.getModelId() + ",dimensionid=" + this.getDimensionId());
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002log\u5173\u952e\u5b57\uff1abudgetperiod", (String)"BudgetPeriodMembAdd_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return root;
    }

    private void init(AbstractDimensionMemTree treenode, List<DynamicObject> out_ref_List) {
        DynamicObject dynamicObject = treenode.initToDyna();
        dynamicObject.set("shownumber", (Object)treenode.getNumber());
        out_ref_List.add(dynamicObject);
        for (AbstractDimensionMemTree child : treenode.getChildren()) {
            this.init(child, out_ref_List);
        }
    }

    public DynamicObject getModelObj() {
        long modelId = this.getModelId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        if (dynamicObject == null) {
            log.error("[budgetperiod]BudgetPeriodMembAdd.getModelObj():modelid=" + modelId + ",dimensionid=" + this.getDimensionId());
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u4f53\u7cfb\u3002", (String)"BudgetPeriodMembAdd_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dynamicObject;
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId == null || modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u4f20\u5165", (String)"BudgetPeriodMembAdd_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }

    public Long getDimensionId() {
        Long dimensionId = (Long)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        if (dimensionId == null || dimensionId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u672a\u4f20\u5165", (String)"BudgetPeriodMembAdd_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dimensionId;
    }

    public DynamicObject getDimensionObj() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getDimensionId(), (String)"epm_dimension");
        if (dynamicObject == null) {
            log.error("[budgetperiod]BudgetPeriodMembAdd.getModelObj():modelid=" + this.getModelId() + ",dimensionid=" + this.getDimensionId());
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetPeriodMembAdd_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dynamicObject;
    }

    public boolean exists(String number) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("dimension", "=", (Object)this.getDimensionId());
        qFilter.and("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"epm_bperiodmembertree", (QFilter[])qFilter.toArray());
    }
}

