/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberedit;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.model.BudgetPeriodService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BudgetPeriodStartDateModify
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BudgetPeriodStartDateModify.class);
    private static final String FIELD_YEAR = "startyear";
    private static final String BTN_SAVE = "btn_save";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Member firstMember = (Member)modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, SysDimensionEnum.BudgetPeriod.getNumber()).getChildrenBySort().get(0);
        DynamicObject dyObj = BudgetPeriodService.getInstance().queryPeriodObj(firstMember.getId().longValue());
        this.getModel().setValue(FIELD_YEAR, (Object)dyObj.getDate("startdate"));
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_SAVE.equals(key)) {
            long modelId = this.getModelId();
            if (!MemberParamsUtils.isPeriodUserDefine((long)modelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e-\u53c2\u6570\u914d\u7f6e-\u9884\u7b97\u4f53\u7cfb\u4e2d\u7684\u7ef4\u5ea6\u7ba1\u7406\u4e2d'\u542f\u7528\u975e\u6807\u8d22\u5e74\u6a21\u5f0f\u63a7\u5236'\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BudgetPeriodStartDateModify_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Date startDate = (Date)this.getModel().getValue(FIELD_YEAR);
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            int startDay = c.get(5);
            if (startDay >= 27) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u8bf7\u9009\u62e927\u65e5\u524d\u7684\u4e00\u5929\u3002", (String)"BudgetPeriodStartDateModify_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (BudgetPeriodService.getInstance().hasModifyDefault(modelId)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u4fee\u6539\u8fc7\u5f00\u59cb\u671f\u95f4\u3001\u7ed3\u675f\u671f\u95f4\uff0c\u786e\u5b9a\u8fdb\u884c\u8986\u76d6\u4fee\u6539\uff1f", (String)"BudgetPeriodStartDateModify_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u4fee\u6539\u671f\u95f4\u6210\u5458\u7684\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\uff1f", (String)"BudgetPeriodStartDateModify_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.doModifyStartDate();
        }
    }

    private void doModifyStartDate() {
        long modelId = this.getModelId();
        Date startDate = (Date)this.getModel().getValue(FIELD_YEAR);
        BudgetPeriodService.getInstance().modifyStartDate(modelId, startDate);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539\u671f\u95f4\u8d77\u59cb\u65e5\u671f", "BudgetPeriodStartDateModify_3", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fee\u6539\u671f\u95f4\u8d77\u59cb\u65e5\u671f\u6210\u529f", "BudgetPeriodStartDateModify_4", "epm-eb-formplugin");
        this.writeLog("save", opName, opDesc);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"BudgetPeriodStartDateModify_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId == null || modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u4f20\u5165", (String)"BudgetPeriodMembAdd_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }
}

