/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberedit;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricUseEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class MetricMemberEdit
extends AbstractBasePlugin {
    private static final Set<String> presetMetricNames = new HashSet<String>(Arrays.asList("Money", "UnitPrice", "Amount"));
    private static final String DIMENSIONID = "dimensionId";
    private static final String MODEL = "model";
    private static final String USE = "use";
    private static final String COMPARE_METRIC = "comparemetric";
    private static final String CALC_RULE = "calcrule";
    private static final String DATA_TYPE = "datatype";
    private static final String ISAGG = "isagg";
    private static final String ENUMENTRYENTITY = "enumentryentity";
    private static final String ENUM_FLEXPANEL = "advconap";
    private static final String DECIMALNUM = "decimalnum";
    private static final String STORAGE_NO_DETAIL = "storagenodetail";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnsure"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{ENUM_FLEXPANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{CALC_RULE, COMPARE_METRIC});
        Object modelId = this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (modelId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"MetricMemberEdit_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String model = modelId.toString();
        this.getModel().setValue(MODEL, (Object)model);
        IPageCache pageCache = this.getPageCache();
        pageCache.put(MODEL, model);
        String dimension = this.getDimensionId();
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ea6\u91cf\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u3002", (String)"MetricMemberEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnsure"});
            return;
        }
        this.getModel().setValue("dimension", (Object)dimension);
        pageCache.put(DIMENSIONID, dimension);
        this.getModel().setValue(DECIMALNUM, (Object)2);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{"disable"});
        Boolean disable = (Boolean)this.getModel().getValue("disable");
        if (disable.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"disabledate", "disabler"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"disabledate", "disabler"});
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        String number = this.getModel().getValue("number").toString();
        Long id = Convert.toLong((Object)this.getModel().getValue("id"));
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        IPageCache pageCache = this.getPageCache();
        pageCache.put(MODEL, model.getString("id"));
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        pageCache.put(DIMENSIONID, dimension.getString("id"));
        DynamicObjectCollection hasquotes = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.metric", "=", (Object)id)});
        if (hasquotes.size() > 0 || presetMetricNames.contains(number)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        }
        String use = String.valueOf(this.getModel().getValue(USE));
        this.getView().setEnable(Boolean.valueOf(!MetricUseEnum.metricIsRate((String)use)), new String[]{ISAGG});
        this.initCalcRuleAndCompareMetric(use);
        Object isPreSetMem = this.getView().getFormShowParameter().getCustomParam("membersource");
        if (isPreSetMem != null && MemberSourceEnum.PRESET.getIndex().equals(isPreSetMem.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DATA_TYPE, USE, ISAGG, "disable", STORAGE_NO_DETAIL});
        } else {
            List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)dimension.getString("number"));
            if (datasets != null && !datasets.isEmpty()) {
                HashSet<String> memberNumbers = new HashSet<String>();
                memberNumbers.add(number);
                if (ShrekOlapServiceHelper.existCubeData((Model)Model.of((DynamicObject)model), (List)datasets, (String)dimension.getString("number"), memberNumbers)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{DATA_TYPE});
                }
            }
        }
        String dataType = String.valueOf(this.getView().getModel().getValue(DATA_TYPE));
        if (!MetricDataTypeEnum.ENUM.getIndex().equals(dataType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENUM_FLEXPANEL});
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemName;
        switch (itemName = e.getProperty().getName()) {
            case "use": {
                this.propertyChanged_use(e);
                break;
            }
            case "datatype": {
                this.propertyChanged_dataType(e);
                break;
            }
            case "comparemetric": {
                this.propertyChanged_compareMetric(e);
                break;
            }
            case "disable": {
                this.propertyChanged_disable(e);
                break;
            }
            case "isagg": {
                this.propertyChanged_agg(e);
                break;
            }
            case "storagenodetail": {
                this.propertyChanged_storageNoDetail(e);
            }
        }
    }

    private void propertyChanged_use(PropertyChangedArgs e) {
        String currentUseType = (String)e.getChangeSet()[0].getNewValue();
        if (MetricUseEnum.Prepare.getIndex().equals(currentUseType)) {
            super.getView().setEnable(Boolean.TRUE, new String[]{DATA_TYPE, ISAGG});
            super.getModel().setValue(DATA_TYPE, (Object)MetricDataTypeEnum.CURRENCY.getIndex());
            super.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_METRIC, CALC_RULE});
        } else {
            super.getView().setEnable(Boolean.FALSE, new String[]{DATA_TYPE, ISAGG});
            if (MetricUseEnum.YearOnYearDiff.getIndex().equals(currentUseType)) {
                super.getView().setEnable(Boolean.valueOf(true), new String[]{ISAGG});
                super.getModel().setValue(DATA_TYPE, (Object)MetricDataTypeEnum.CURRENCY.getIndex());
            } else {
                super.getModel().setValue(DATA_TYPE, (Object)MetricDataTypeEnum.RATE.getIndex());
            }
            super.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_METRIC});
            this.initCalcRuleAndCompareMetric(String.valueOf(this.getModel().getValue(USE)));
        }
    }

    private void propertyChanged_dataType(PropertyChangedArgs e) {
        String dataType = (String)this.getModel().getValue(DATA_TYPE);
        MetricDataTypeEnum typeEnum = MetricDataTypeEnum.getByIndex((String)dataType);
        if (MetricDataTypeEnum.ENUM == typeEnum) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ENUM_FLEXPANEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{ISAGG});
            this.getModel().setValue(ISAGG, (Object)Boolean.FALSE);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)Long.parseLong(this.getPageCache().get(MODEL)));
            String number = this.getModel().getValue("number").toString();
            if (StringUtils.isEmpty((String)number)) {
                return;
            }
            Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, number);
            if (member == null) {
                return;
            }
            Long memberId = member.getId();
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"eb_enumvalue", (String)"enumnumber,enumname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId)});
            this.getModel().deleteEntryData(ENUMENTRYENTITY);
            if (docs != null && docs.size() > 0) {
                this.getModel().beginInit();
                this.getModel().batchCreateNewEntryRow(ENUMENTRYENTITY, docs.size());
                for (int i = 0; i < docs.size(); ++i) {
                    this.getModel().getEntryRowEntity(ENUMENTRYENTITY, i).set("enumnumber", (Object)((DynamicObject)docs.get(i)).getString("enumnumber"));
                    this.getModel().getEntryRowEntity(ENUMENTRYENTITY, i).set("enumname", (Object)((DynamicObject)docs.get(i)).getString("enumname"));
                }
                this.getModel().endInit();
                this.getView().updateView(ENUMENTRYENTITY);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENUM_FLEXPANEL});
            if (MetricDataTypeEnum.CURRENCY == typeEnum || MetricDataTypeEnum.RATE == typeEnum) {
                this.getModel().setValue(DECIMALNUM, (Object)2);
            } else {
                this.getModel().setValue(DECIMALNUM, (Object)0);
            }
        }
        if (MetricDataTypeEnum.TEXT == typeEnum || MetricDataTypeEnum.DATE == typeEnum || MetricDataTypeEnum.ENUM == typeEnum) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ISAGG});
            this.getModel().setValue(ISAGG, (Object)Boolean.FALSE);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{ISAGG});
        }
    }

    private void propertyChanged_compareMetric(PropertyChangedArgs e) {
        String newDataType;
        String newCompMetricId;
        String currentUseType = (String)this.getModel().getValue(USE);
        if (currentUseType == null) {
            return;
        }
        if (MetricUseEnum.YearOnYearDiff.getIndex().equals(currentUseType) && (newCompMetricId = (String)e.getChangeSet()[0].getNewValue()) != null && (newDataType = (String)CommonServiceHelper.getValueFromDB((String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)DATA_TYPE, (String)"model,id", (Object[])new Object[]{this.getModelId(), Long.parseLong(newCompMetricId)})) != null) {
            this.getModel().setValue(DATA_TYPE, (Object)newDataType);
        }
    }

    private void propertyChanged_disable(PropertyChangedArgs e) {
        Boolean disable = (Boolean)this.getModel().getValue("disable");
        if (disable.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"disabledate", "disabler"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"disabledate", "disabler"});
        }
    }

    private void propertyChanged_agg(PropertyChangedArgs e) {
        block8: {
            Boolean isAgg = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isAgg.booleanValue()) {
                String dataType = (String)this.getModel().getValue(DATA_TYPE);
                MetricDataTypeEnum typeEnum = MetricDataTypeEnum.getByIndex((String)dataType);
                if (MetricDataTypeEnum.TEXT == typeEnum || MetricDataTypeEnum.DATE == typeEnum || MetricDataTypeEnum.ENUM == typeEnum) {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)ISAGG, (Object)Boolean.FALSE);
                    this.getView().updateView(ISAGG);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u3001\u65e5\u671f\u3001\u679a\u4e3e\u7c7b\u578b\u7684\u5ea6\u91cf\u4e0d\u5141\u8bb8\u6253\u5f00\u805a\u5408\u5c5e\u6027\u3002", (String)"MetricMemberEdit_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (QueryServiceHelper.exists((String)SysDimensionEnum.Metric.getMemberTreemodel(), (Object)this.getModel().getValue("id"))) {
                    List datasets = DatasetServiceHelper.getAllDatasets((Long)this.getModelId());
                    try {
                        if (ShrekOlapServiceHelper.existNoDetailData((IModelCacheHelper)this.getIModelCacheHelper(), (List)datasets, (String)((String)this.getModel().getValue("number")))) {
                            EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)ISAGG, (Object)Boolean.FALSE);
                            this.getView().updateView(ISAGG);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ea6\u91cf\u6210\u5458\u5b58\u5728\u975e\u660e\u7ec6\u6570\u636e\uff0c\u5220\u9664\u975e\u660e\u7ec6\u6570\u636e\u540e\u624d\u5141\u8bb8\u5173\u95ed\u975e\u660e\u7ec6\u5b58\u50a8\u5c5e\u6027\u3002", (String)"MetricMemberEdit_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            break block8;
                        }
                        this.closeStorageNoDetail();
                    }
                    catch (Exception ex) {
                        EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)ISAGG, (Object)Boolean.FALSE);
                        this.getView().updateView(ISAGG);
                        log.error("checkNoDetailData-error", (Throwable)ex);
                        this.getView().showTipNotification(ex.getMessage());
                    }
                } else {
                    this.closeStorageNoDetail();
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{STORAGE_NO_DETAIL});
            }
        }
    }

    private void propertyChanged_storageNoDetail(PropertyChangedArgs e) {
        Boolean isStorage = (Boolean)e.getChangeSet()[0].getNewValue();
        if (isStorage.booleanValue()) {
            this.getModel().setValue(ISAGG, (Object)Boolean.FALSE);
        } else if (QueryServiceHelper.exists((String)SysDimensionEnum.Metric.getMemberTreemodel(), (Object)this.getModel().getValue("id"))) {
            List datasets = DatasetServiceHelper.getAllDatasets((Long)this.getModelId());
            try {
                if (ShrekOlapServiceHelper.existNoDetailData((IModelCacheHelper)this.getIModelCacheHelper(), (List)datasets, (String)((String)this.getModel().getValue("number")))) {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)STORAGE_NO_DETAIL, (Object)Boolean.TRUE);
                    this.getView().updateView(STORAGE_NO_DETAIL);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ea6\u91cf\u6210\u5458\u5b58\u5728\u975e\u660e\u7ec6\u6570\u636e\uff0c\u5220\u9664\u975e\u660e\u7ec6\u6570\u636e\u540e\u624d\u5141\u8bb8\u5173\u95ed\u975e\u660e\u7ec6\u5b58\u50a8\u5c5e\u6027\u3002", (String)"MetricMemberEdit_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)STORAGE_NO_DETAIL, (Object)Boolean.TRUE);
                this.getView().updateView(STORAGE_NO_DETAIL);
                log.error("checkNoDetailData-error", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
    }

    private void closeStorageNoDetail() {
        if (((Boolean)this.getModel().getValue(STORAGE_NO_DETAIL)).booleanValue()) {
            this.getModel().setValue(STORAGE_NO_DETAIL, (Object)Boolean.FALSE);
        }
    }

    private void initCalcRuleAndCompareMetric(String index) {
        MetricUseEnum choosedUseEnum = MetricUseEnum.getMetricUseByIndex((String)index);
        super.getView().setVisible(Boolean.FALSE, new String[]{CALC_RULE, COMPARE_METRIC});
        if (choosedUseEnum != null && MetricUseEnum.Prepare != choosedUseEnum) {
            super.getView().setVisible(Boolean.TRUE, new String[]{CALC_RULE, COMPARE_METRIC});
            super.getModel().setValue(CALC_RULE, (Object)choosedUseEnum.getCalcRule());
            this.initCompareMetric();
        }
    }

    private void initCompareMetric() {
        ArrayList items = new ArrayList();
        QFilter qf = new QFilter(MODEL, "=", (Object)this.getModelId());
        qf.and(DATA_TYPE, "in", (Object)new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()});
        qf.and(COMPARE_METRIC, "in", (Object)new String[]{" ", "0"});
        QueryServiceHelper.query((String)"epm_metricmembertree", (String)"id,name,number", (QFilter[])qf.toArray(), null).forEach(metric -> items.add(new ComboItem(new LocaleString(metric.getString("name")), metric.getString("id"))));
        if (!items.isEmpty()) {
            ComboEdit combo = (ComboEdit)this.getControl(COMPARE_METRIC);
            combo.setComboItems(items);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("btnsave".equals(operateKey)) {
            OperationStatus status;
            this.getPageCache().put("currNumber", (String)this.getModel().getValue("number"));
            this.getPageCache().put("showNumber", (String)this.getModel().getValue("showNumber"));
            if (StringUtils.isEmpty((String)((String)this.getModel().getValue("number")))) {
                this.getModel().setValue("number", this.getModel().getValue("shownumber"));
            }
            if (StringUtils.isEmpty((String)((String)this.getModel().getValue("shownumber")))) {
                this.getModel().setValue("shownumber", this.getModel().getValue("shownumber"));
            }
            this.setDeaultValue();
            String modelId = this.getPageCache().get(MODEL);
            if (MetricDataTypeEnum.ENUM.getIndex().equals(this.getModel().getValue(DATA_TYPE)) && !this.enumDataHandle(modelId)) {
                args.setCancel(true);
            }
            if (OperationStatus.EDIT == (status = this.getView().getFormShowParameter().getStatus())) {
                Boolean disable = (Boolean)this.getModel().getValue("disable");
                if (disable.booleanValue()) {
                    QFilter qFilter = new QFilter("id", "=", this.getModel().getValue("id"));
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getBizEntityNumber(), (String)"disable", (QFilter[])qFilter.toArray());
                    if (dynamicObject != null && !dynamicObject.getBoolean("disable")) {
                        this.getModel().setValue("disabledate", (Object)TimeServiceHelper.now());
                        this.getModel().setValue("disabler", (Object)UserUtils.getUserId());
                    }
                }
            } else {
                this.checkNumberOnly();
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null) {
            return;
        }
        String operateKey = e.getOperateKey();
        if (!e.getOperationResult().getValidateResult().isSuccess()) {
            if ("btnsave".equals(operateKey)) {
                this.getModel().setValue("number", (Object)this.getPageCache().get("currNumber"));
                this.getModel().setValue("shownumber", (Object)this.getPageCache().get("showNumber"));
            }
            return;
        }
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (isSuccess && "btnsave".equals(operateKey)) {
            String modelId = this.getPageCache().get(MODEL);
            String dimensionId = this.getPageCache().get(DIMENSIONID);
            CubeUtils.get().checkDimension(Long.valueOf(modelId), Long.valueOf(dimensionId));
            try {
                this.syncOlapData();
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MetricMemberEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().close();
            }
            catch (Exception ex) {
                log.error("syncOlapData-error", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
            }
        }
    }

    private void syncOlapData() {
        long modelId = this.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model");
        if (ShrekOlapServiceHelper.isStartShrek()) {
            List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)SysDimensionEnum.Metric.getNumber());
            Member metric = new Member();
            metric.setId(Long.valueOf(Long.parseLong(this.getModel().getValue("id").toString())));
            metric.setNumber(this.getModel().getValue("number").toString());
            metric.setSeq(Integer.parseInt(this.getModel().getValue("dseq").toString()));
            metric.setAggType(this.getModel().getValue("aggoprt").toString());
            metric.setHasAgg((Boolean)this.getModel().getValue(ISAGG));
            ShrekOlapServiceHelper.addCubeMembers((Model)Model.of((DynamicObject)model), (List)datasets, (String)SysDimensionEnum.Metric.getNumber(), Collections.singletonList(metric), (ShrekConfig)ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model));
            if (this.isEditStatus()) {
                ShrekOlapServiceHelper.updateCubeMember((Model)Model.of((DynamicObject)model), (List)datasets, (String)SysDimensionEnum.Metric.getNumber(), (Member)metric, (ShrekConfig)ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model));
            }
        }
    }

    public boolean isEditStatus() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    private void setDeaultValue() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        IDataModel iDataModel = this.getModel();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            QFilter qf1 = new QFilter(MODEL, "=", (Object)this.getModelId());
            QFilter qf2 = new QFilter("number", "=", (Object)"Metric");
            DynamicObject object = QueryServiceHelper.queryOne((String)"epm_metricmembertree", (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
            if (object == null) {
                object = (DynamicObject)this.reAddRootMetric()[0];
            }
            StringBuilder sb = new StringBuilder("Metric!");
            sb.append(iDataModel.getValue("number"));
            iDataModel.setValue("longnumber", (Object)sb.toString());
            iDataModel.setValue("level", (Object)2);
            iDataModel.setValue("membersource", (Object)MemberSourceEnum.ADD.getIndex());
            iDataModel.setValue("status", (Object)"C");
            iDataModel.setValue("enable", (Object)"1");
            iDataModel.setValue("creator", (Object)userId);
            iDataModel.setValue("createtime", (Object)now);
            long parentId = object.getLong("id");
            iDataModel.setValue("parent", (Object)parentId);
            iDataModel.setValue("dseq", (Object)DimensionServiceHelper.getDSeq((long)parentId, (String)"epm_metricmembertree"));
        }
        iDataModel.setValue("modifytime", (Object)now);
        iDataModel.setValue("modifier", (Object)userId);
    }

    private Object[] reAddRootMetric() {
        DynamicObject metricDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"epm_metricmembertree");
        metricDynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        metricDynamicObject.set("number", (Object)"Metric");
        metricDynamicObject.set("status", (Object)"C");
        metricDynamicObject.set("creator", (Object)UserUtils.getUserId());
        metricDynamicObject.set("modifier", (Object)UserUtils.getUserId());
        metricDynamicObject.set("enable", (Object)"1");
        metricDynamicObject.set("createtime", (Object)TimeServiceHelper.now());
        metricDynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
        metricDynamicObject.set("masterid", (Object)"0");
        metricDynamicObject.set("disabler", (Object)"0");
        metricDynamicObject.set("disabledate", null);
        metricDynamicObject.set(MODEL, (Object)this.getModelId());
        metricDynamicObject.set("dimension", (Object)this.getPageCache().get(DIMENSIONID));
        return SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metricDynamicObject});
    }

    @Override
    public Long getModelId() {
        Long model = 0L;
        String modelId = this.getPageCache().get(MODEL);
        if (modelId != null) {
            model = Long.valueOf(modelId);
        }
        return model;
    }

    private String getDimensionId() {
        QFilter qf1 = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter qf2 = new QFilter("number", "=", (Object)"Metric");
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qf1, qf2});
        if (dimension == null) {
            return null;
        }
        return dimension.getString("id");
    }

    private void checkNumberOnly() {
        String number = (String)this.getModel().getValue("number");
        Long dimensionId = IDUtils.toLong((Object)this.getPageCache().get(DIMENSIONID));
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        qFilter.and("dimension", "=", (Object)dimensionId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberNumber", (String)this.getBizEntityNumber(), (String)"id,number", (QFilter[])qFilter.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    if (!number.equalsIgnoreCase(row.getString("number"))) continue;
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5185\u7801\u201c%1\u201d\u5df2\u5b58\u5728\u4e8e\u8be5\u4f53\u7cfb\u4e2d\u3002", (String)"DimensionMemberSaveValidator_23", (String)"epm-eb-cube", (Object[])new Object[]{number}));
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addrow": {
                this.newAddAccountRow();
            }
        }
        String modelId = this.getPageCache().get(MODEL);
        if (MetricDataTypeEnum.ENUM.getIndex().equals(this.getModel().getValue(DATA_TYPE))) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENUMENTRYENTITY);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelId));
            Long numberId = modelCache.getDimension(SysDimensionEnum.Metric.getNumber()).getId();
            for (DynamicObject doc : entryEntity) {
                doc.set("enummodel", (Object)modelId);
                doc.set("dimid", (Object)numberId);
            }
        }
    }

    private void newAddAccountRow() {
        this.getModel().beginInit();
        this.getModel().createNewEntryRow(ENUMENTRYENTITY);
        this.getModel().endInit();
        this.getView().updateView(ENUMENTRYENTITY);
    }

    public boolean enumDataHandle(String modelId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENUMENTRYENTITY);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelId));
        Long numberId = modelCache.getDimension(SysDimensionEnum.Metric.getNumber()).getId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"epm_model");
        DynamicObject dimensionDoc = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        dynamicObject.set("id", (Object)modelId);
        dimensionDoc.set("id", (Object)numberId);
        Long count = entryEntity.stream().filter(e -> StringUtils.isEmpty((String)e.getString("enumname")) && StringUtils.isEmpty((String)e.getString("enumnumber"))).count();
        int[] dels = new int[Integer.parseInt(count.toString())];
        int j = 0;
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)entryEntity.size());
        HashSet names = Sets.newHashSetWithExpectedSize((int)entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String number = entry.getString("enumnumber");
            String name = entry.getString("enumname");
            if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)number)) {
                dels[j] = i;
                ++j;
                continue;
            }
            if (StringUtils.isEmpty((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetricMemberEdit_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((String)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetricMemberEdit_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!numbers.add(number)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u679a\u4e3e\u503c\u7f16\u7801\u201c%1\u201d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"MetricMemberEdit_10", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                return false;
            }
            if (!names.add(name)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u679a\u4e3e\u503c\u540d\u79f0\u201c%1\u201d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"MetricMemberEdit_11", (String)"epm-eb-formplugin", (Object[])new Object[]{name}));
                return false;
            }
            entry.set("enummodel", (Object)dynamicObject);
            entry.set("dimid", (Object)dimensionDoc);
        }
        this.getModel().deleteEntryRows(ENUMENTRYENTITY, dels);
        this.getView().updateView(ENUMENTRYENTITY);
        return true;
    }
}

